<?php
/****關聯模型***/
class UserRelationModel extends RelationModel {
	
	//定義(主)表名
	protected $tableName = 'admin';

	//定義關聯關係
	protected $_link = array(
		//role為角色表名
		'role' => array(
			'mapping_type' => 	MANY_TO_MANY, 		//關係類型：多對多
			'foreign_key' => 	'user_id',			//主表在中間表中的字段名稱
			'relation_foreign_key' => 	'role_id',			//關聯表(副表)在中間表中的字段名稱(外鍵)
			//安裝的時候表前綴一定要更改//debug//不能使用C()動態改變
			'relation_table' => 'yy_role_user', 	//中間表的表名(多對多關係中必須指定)
			'mapping_fields' => 'id,name,remark',	//只讀取關聯表(副表)中的部分字段,不指定則為全部字段
			'mapping_order' => 'id' ,//排序
			'mapping_limit' => 0,					//返回記錄數
		),

	);

}

?>