<?php

//視圖模型
class ArcViewModel extends ExViewModel {
	

 	protected $viewFields = array();

	/**
	* 架構函數
	* 取得DB類的實例對像 字段檢查
	* @access public
    * @param string $name 模型名稱
	* @param string $tableName 主表名稱
	* @param string $tablePrefix 表前綴
	* @param mixed $connection 數據庫連接信息
	*/
	public function __construct($name='',$tableName='article',$tablePrefix='',$connection='') {
		//
		$this->viewFields = array(
		$tableName => array('*','_type' => 'LEFT'),
			'category' => array(
			'name' => 'catename',
			'ename' => 'ename',
			'modelid' => 'modelid',
			'_on' => $tableName.'.cid = category.id',//_on 對應上面LEFT關聯條件
			//'_type' => 'LEFT'
			),
		);
		
		 // 模型初始化
		$this->_initialize();
		// 獲取模型名稱
		if(!empty($name)) {
			if(strpos($name,'.')) { // 支持 數據庫名.模型名的 定義
				list($this->dbName,$this->name) = explode('.',$name);
			}else{
				$this->name   =  $name;
			}
		}elseif(empty($this->name)){
			$this->name =   $this->getModelName();
		}
		// 設置表前綴
		if(is_null($tablePrefix)) {// 前綴為Null表示沒有前綴
			$this->tablePrefix = '';
		}elseif('' != $tablePrefix) {
			$this->tablePrefix = $tablePrefix;
		}else{
			$this->tablePrefix = $this->tablePrefix?$this->tablePrefix:C('DB_PREFIX');
		}

		// 數據庫初始化操作
		// 獲取數據庫操作對像
		// 當前模型有獨立的數據庫連接信息
		$this->db(0,empty($this->connection)?$connection:$this->connection);
	}


}

?>