<?php
/*******************************************************************************
* [TuziCMS] 兔子CMS
* @Copyright (C) 2014-2015  http://tuzicms.com   All rights reserved.
* @Team  Yejiao.net
* @Author  秦子诗   QQ：176881336
* @WeiBo  http://weibo.com/tuzicms
* @Licence  http://www.tuzicms.com/license.txt
*******************************************************************************/
namespace Home\Controller;
use Think\Controller;
use Common\Lib\String; //引入类函数
use Common\Lib\Category; //引入类函数
use Common\Lib\Common; //引入类函数
class ReviewController extends CommonController {
	//方法：index
	public function index(){
		$this->display();
	}

	public function add(){
// 		dump($_POST);
// 		exit;
		if (!IS_AJAX ||  !IS_POST) {
			//exit(json_encode( array('status' => 0, 'info' => '非法请求' ) ));
			$this->error('非法请求');
		}
		//判断是否开启评论
		$comment_state=C('COMMENT_STATE');
// 		dump($comment_show);
// 		exit;
		if ($comment_state==0) {
			$this->ajaxReturn(array('status'=>3,'msg'=>'评论系统关闭','url'=>''),'json');
			//echo "<script>alert('请先登录');window.history.back()</script>";exit;
		}
		//接收数据，插入数据库
		$data['newsid'] = I('post.newsid');
		$data['f_id'] = I('post.f_id');
		$data['comment_model'] = I('post.comment_model');
		$data['comment_title'] = I('post.comment_title');
		$data['comment_content']  = I('post.comment_content');
		$data['comment_pic']  =  __ROOT__.'/Data/Images/default.gif';
		$data['comment_time'] =time();
		$data['comment_ip'] = get_client_ip();
		
		$verify=I('post.verify');
		if (!$verify){
			$this->error('请填写验证码');
		}
		//判断验证码是否正确
		if (!check_verify($verify)) {
			$furl = $_SERVER['HTTP_REFERER'];
			$this->error('验证码不正确', $furl);
			//$this->error('验证码不正确');
		}

		$uid = $_SESSION['uid'];//不能用empty(get_cookie('uid')),empty不能用于函数返回值
// 		dump($uid);
// 		exit;
		//判断是否允许游客评论
		$comment_login=C('COMMENT_LOGIN');
		if ($comment_login==0) {
			if (empty($uid)) {
			$this->ajaxReturn(array('status'=>2,'msg'=>'请先登录','url'=>''),'json');
			//echo "<script>alert('请先登录');window.history.back()</script>";exit;
			}
		}

		if (!empty($uid)) {
			$data['userid'] = $uid;
			$data['comment_username'] = $_SESSION['user_name'];
					
		}else {
			$data['userid'] = 0;			
			$data['comment_username'] = I('nickname', '游客');
		}

		if(empty($data['comment_title'])) {
			$this->error('文章不正确，请刷新再评论');
		}
		
		if(empty($data['comment_content']) || mb_strlen($data['comment_content'], 'utf-8')<3) {
			$this->error('请填写评论内容，内容太短');
		}

// 		if (check_badword($data['comment_content'])) {
// 			$this->error('评论内容包含非法信息，请认真填写！');
// 		}
		//判断是否开启评论审核
		$comment_verify=C('COMMENT_VERIFY');
		if ($comment_verify==0) {//未开启
			$data['comment_show'] = 1;
		}else {
			$data['comment_show'] = 0;
		}

		if($id = M('Comment')->add($data)) {
			//未插入数据库，前端调用显示用
			$list= array(
				'id' => $id,
				'userid' => $data['userid'],
				'review_id' => $data['f_id'],
				'newsid' => $data['newsid'],
				'comment_ip' => $data['comment_ip'],
				'comment_model' => $data['comment_model'],
				'comment_username' => $data['comment_username'],
				'comment_pic' => __ROOT__.'/Data/Images/default.gif',
				'comment_content' => $data['comment_content'],
				'comment_time' => date('Y-m-d H:i:s', time())
			);
			$furl = $_SERVER['HTTP_REFERER'];
			$this->success('添加成功', $furl, $list);
		}else {			
			$this->error('添加失败'.M('Comment')->getError());
		}
	
	}


}

?>