DROP TABLE IF EXISTS `bc_bb_badwords`;
CREATE TABLE `bc_bb_badwords` (
  `word` varchar(255) NOT NULL DEFAULT '',
  `replacement` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='不良词汇';

DROP TABLE IF EXISTS `bc_bb_bans`;
CREATE TABLE `bc_bb_bans` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `ip_addr` varchar(23) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='封禁';

DROP TABLE IF EXISTS `bc_bb_cats`;
CREATE TABLE `bc_bb_cats` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `sort_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='论坛分类';

INSERT INTO `bc_bb_cats` (`id`, `name`, `sort_id`) VALUES
(1, '测试分类', 1);

DROP TABLE IF EXISTS `bc_bb_config`;
CREATE TABLE `bc_bb_config` (
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '设置名称',
  `content` varchar(255) NOT NULL DEFAULT '' COMMENT '设置的值'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='论坛设置';

INSERT INTO `bc_bb_config` (`name`, `content`) VALUES
('active_topics_count', '20'),
('admin_email', 'admin@admin.com'),
('board_closed', '0'),
('board_closed_reason', '系统维护中……'),
('board_descr', '论坛描述'),
('board_keywords', '论坛,社区,BootBB,BootCMS'),
('board_name', '测试论坛'),
('edit_post_timeout', '900'),
('enable_detailed_online_list', '1'),
('enable_forum_stats_box', '1'),
('enable_memberlist', '1'),
('enable_quickreply', '1'),
('enable_stafflist', '0'),
('enable_stats', '0'),
('flood_interval', '30'),
('hide_signatures', '0'),
('members_per_page', '10'),
('new_post_minutes', '30'),
('posts_per_page', '10'),
('show_edited_message_timeout', '120'),
('topics_per_page', '10'),
('topic_review_posts', '10');

DROP TABLE IF EXISTS `bc_bb_forums`;
CREATE TABLE `bc_bb_forums` (
  `id` smallint(5) unsigned NOT NULL COMMENT '版块ID',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '版块名称',
  `cat_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `descr` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `moderators` varchar(127) NOT NULL DEFAULT '' COMMENT '版主',
  `topics` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题数',
  `posts` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '回复数',
  `last_topic_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最新主题ID',
  `last_post_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后回复时间',
  `sort_id` int(5) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `auth` char(10) NOT NULL DEFAULT '0011222223' COMMENT '权限',
  `auto_lock` int(11) NOT NULL DEFAULT '0',
  `hide_mods_list` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '隐藏版主列表'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='版块';

INSERT INTO `bc_bb_forums` (`id`, `name`, `cat_id`, `descr`, `status`, `moderators`, `topics`, `posts`, `last_topic_id`, `last_post_time`, `sort_id`, `auth`, `auto_lock`, `hide_mods_list`) VALUES
(1, '测试版块', 1, '这是一个用于测试的论坛版块。', 1, '', 0, 0, 0, 0, 0, '0011222223', 0, 0);

DROP TABLE IF EXISTS `bc_bb_members`;
CREATE TABLE `bc_bb_members` (
  `id` int(11) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户',
  `username` varchar(30) NOT NULL DEFAULT '' COMMENT '用户名',
  `nickname` varchar(30) NOT NULL DEFAULT '' COMMENT '昵称',
  `regdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '注册时间',
  `show_email` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '显示电子邮箱',
  `level` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `banned` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '禁止',
  `banned_reason` varchar(255) NOT NULL DEFAULT '' COMMENT '禁止原因',
  `posts` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发帖数',
  `enable_quickreply` int(1) NOT NULL DEFAULT '0',
  `hide_avatars` int(1) NOT NULL DEFAULT '0',
  `hide_userinfo` int(1) NOT NULL DEFAULT '0',
  `hide_signatures` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '隐藏签名',
  `auto_subscribe_topic` int(1) NOT NULL DEFAULT '0',
  `auto_subscribe_reply` int(1) NOT NULL DEFAULT '0',
  `avatar` varchar(127) NOT NULL DEFAULT '0' COMMENT '头像',
  `real_name` varchar(127) NOT NULL DEFAULT '' COMMENT '真实姓名',
  `signature` varchar(255) NOT NULL DEFAULT '' COMMENT '签名',
  `birthday` int(8) unsigned NOT NULL DEFAULT '0' COMMENT '生日'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='论坛会员';

DROP TABLE IF EXISTS `bc_bb_posts`;
CREATE TABLE `bc_bb_posts` (
  `id` int(11) unsigned NOT NULL COMMENT '回复ID',
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `poster_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发表人ID',
  `poster_ip` varchar(23) NOT NULL DEFAULT '' COMMENT '发表人IP地址',
  `content` text NOT NULL COMMENT '回复内容',
  `post_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发表时间',
  `edited_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复编辑时间',
  `editor_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '回复编辑者ID',
  `editor_name` varchar(30) NOT NULL DEFAULT '' COMMENT '回复编辑者名字',
  `editor_ip` varchar(39) NOT NULL DEFAULT '' COMMENT '回复编辑者IP地址',
  `enable_bbcode` int(1) NOT NULL DEFAULT '1',
  `enable_smilies` int(1) NOT NULL DEFAULT '1',
  `enable_sig` int(1) NOT NULL DEFAULT '1',
  `enable_html` int(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='论坛帖子';

DROP TABLE IF EXISTS `bc_bb_searches`;
CREATE TABLE `bc_bb_searches` (
  `sess_id` varchar(32) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `results` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='搜索';

DROP TABLE IF EXISTS `bc_bb_stats`;
CREATE TABLE `bc_bb_stats` (
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='论坛统计';

INSERT INTO `bc_bb_stats` (`name`, `content`) VALUES
('members', '0'),
('posts', '0'),
('started', '0'),
('topics', '0');

DROP TABLE IF EXISTS `bc_bb_subscriptions`;
CREATE TABLE `bc_bb_subscriptions` (
  `topic_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='论坛订阅';

DROP TABLE IF EXISTS `bc_bb_topics`;
CREATE TABLE `bc_bb_topics` (
  `id` int(11) NOT NULL COMMENT '主题ID',
  `forum_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '版块ID',
  `topic_title` varchar(255) NOT NULL DEFAULT '' COMMENT '主题的标题',
  `topic_content` text NOT NULL COMMENT '主题的内容',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题创建时间',
  `creater_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '主题创建者ID',
  `creater_name` varchar(30) NOT NULL DEFAULT '' COMMENT '主题创建者名字',
  `creater_ip` varchar(39) NOT NULL DEFAULT '' COMMENT '主题创建者IP地址',
  `edited_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题编辑时间',
  `editor_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '主题编辑者ID',
  `editor_name` varchar(30) NOT NULL DEFAULT '' COMMENT '主题编辑者名字',
  `editor_ip` varchar(39) NOT NULL DEFAULT '' COMMENT '主题编辑者IP地址',
  `last_post_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '最新回复ID',
  `last_post_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最新回复时间',
  `last_poster_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后回复者ID',
  `last_poster_name` varchar(30) NOT NULL DEFAULT '' COMMENT '最后回复者名字',
  `replies` int(11) NOT NULL DEFAULT '0' COMMENT '回复数',
  `views` int(11) NOT NULL DEFAULT '0' COMMENT '浏览数',
  `status_locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定状态',
  `status_sticky` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '置顶状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='论坛帖子主题';

ALTER TABLE `bc_bb_badwords` ADD PRIMARY KEY (`word`);

ALTER TABLE `bc_bb_bans` ADD PRIMARY KEY (`id`);

ALTER TABLE `bc_bb_cats` ADD PRIMARY KEY (`id`);

ALTER TABLE `bc_bb_config` ADD PRIMARY KEY (`name`);

ALTER TABLE `bc_bb_forums` ADD PRIMARY KEY (`id`);

ALTER TABLE `bc_bb_members` ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `user_id` (`user_id`);

ALTER TABLE `bc_bb_posts` ADD PRIMARY KEY (`id`);

ALTER TABLE `bc_bb_searches` ADD PRIMARY KEY (`sess_id`);
  
ALTER TABLE `bc_bb_stats` ADD PRIMARY KEY (`name`);

ALTER TABLE `bc_bb_topics` ADD PRIMARY KEY (`id`), ADD KEY `status_sticky` (`status_sticky`), ADD KEY `last_post_time` (`last_post_time`);

ALTER TABLE `bc_bb_bans` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `bc_bb_cats` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '分类ID';

ALTER TABLE `bc_bb_forums` MODIFY `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '版块ID';

ALTER TABLE `bc_bb_members` MODIFY `id` int(11) unsigned NOT NULL AUTO_INCREMENT;

ALTER TABLE `bc_bb_posts` MODIFY `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '回复ID';

ALTER TABLE `bc_bb_topics` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主题ID';

DROP TABLE IF EXISTS `bc_carts`;
CREATE TABLE `bc_carts` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `price` decimal(6,2) unsigned NOT NULL DEFAULT '0.00',
  `quantity` smallint(4) unsigned NOT NULL DEFAULT '0',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bc_linkages`;
CREATE TABLE `bc_linkages` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `parent_id` smallint(4) unsigned NOT NULL DEFAULT '0',
  `has_child` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `bc_linkages` (`id`, `name`, `parent_id`, `has_child`) VALUES
(1, '中国', 0, 1),
(2, '北京市', 1, 1),
(3, '上海市', 1, 1),
(4, '天津市', 1, 1),
(5, '重庆市', 1, 1),
(6, '河北省', 1, 1),
(7, '山西省', 1, 1),
(8, '内蒙古自治区', 1, 1),
(9, '辽宁省', 1, 1),
(10, '吉林省', 1, 1),
(11, '黑龙江省', 1, 1),
(12, '江苏省', 1, 1),
(13, '浙江省', 1, 1),
(14, '安徽省', 1, 1),
(15, '福建省', 1, 1),
(16, '江西省', 1, 1),
(17, '山东省', 1, 1),
(18, '河南省', 1, 1),
(19, '湖北省', 1, 1),
(20, '湖南省', 1, 1),
(21, '广东省', 1, 1),
(22, '广西壮族自治区', 1, 1),
(23, '海南省', 1, 1),
(24, '四川省', 1, 1),
(25, '贵州省', 1, 1),
(26, '云南省', 1, 1),
(27, '西藏自治区', 1, 1),
(28, '陕西省', 1, 1),
(29, '甘肃省', 1, 1),
(30, '青海省', 1, 1),
(31, '宁夏回族自治区', 1, 1),
(32, '新疆维吾尔自治区', 1, 1),
(33, '台湾省', 1, 1),
(34, '香港特别行政区', 1, 1),
(35, '澳门特别行政区', 1, 1),
(36, '东城区', 2, 0),
(37, '西城区', 2, 0),
(38, '朝阳区', 2, 0),
(39, '石景山区', 2, 0),
(40, '海淀区', 2, 0),
(41, '门头沟区', 2, 0),
(42, '房山区', 2, 0),
(43, '通州区', 2, 0),
(44, '顺义区', 2, 0),
(45, '昌平区', 2, 0),
(46, '大兴区', 2, 0),
(47, '怀柔区', 2, 0),
(48, '平谷区', 2, 0),
(49, '密云县', 2, 0),
(50, '延庆县', 2, 0),
(51, '黄浦区', 3, 0),
(52, '徐汇区', 3, 0),
(53, '长宁区', 3, 0),
(54, '静安区', 3, 0),
(55, '普陀区', 3, 0),
(56, '闸北区', 3, 0),
(57, '虹口区', 3, 0),
(58, '杨浦区', 3, 0),
(59, '闵行区', 3, 0),
(60, '宝山区', 3, 0),
(61, '嘉定区', 3, 0),
(62, '浦东新区', 3, 0),
(63, '金山区', 3, 0),
(64, '松江区', 3, 0),
(65, '青浦区', 3, 0),
(66, '南汇区', 3, 0),
(67, '奉贤区', 3, 0),
(68, '崇明县', 3, 0),
(69, '和平区', 4, 0),
(70, '河东区', 4, 0),
(71, '河西区', 4, 0),
(72, '南开区', 4, 0),
(73, '河北区', 4, 0),
(74, '红桥区', 4, 0),
(75, '塘沽区', 4, 0),
(76, '汉沽区', 4, 0),
(77, '大港区', 4, 0),
(78, '东丽区', 4, 0),
(79, '西青区', 4, 0),
(80, '津南区', 4, 0),
(81, '北辰区', 4, 0),
(82, '武清区', 4, 0),
(83, '宝坻区', 4, 0),
(84, '宁河县', 4, 0),
(85, '静海县', 4, 0),
(86, '蓟县', 4, 0),
(87, '万州区', 5, 0),
(88, '黔江区', 5, 0),
(89, '涪陵区', 5, 0),
(90, '渝中区', 5, 0),
(91, '大渡口区', 5, 0),
(92, '江北区', 5, 0),
(93, '沙坪坝区', 5, 0),
(94, '九龙坡区', 5, 0),
(95, '南岸区', 5, 0),
(96, '北碚区', 5, 0),
(97, '渝北区', 5, 0),
(98, '巴南区', 5, 0),
(99, '长寿区', 5, 0),
(100, '江津区', 5, 0),
(101, '合川区', 5, 0),
(102, '永川区', 5, 0),
(103, '南川区', 5, 0),
(104, '綦江区', 5, 0),
(105, '大足区', 5, 0),
(106, '潼南县', 5, 0),
(107, '铜梁县', 5, 0),
(108, '荣昌县', 5, 0),
(109, '璧山县', 5, 0),
(110, '梁平县', 5, 0),
(111, '城口县', 5, 0),
(112, '丰都县', 5, 0),
(113, '垫江县', 5, 0),
(114, '武隆县', 5, 0),
(115, '忠县', 5, 0),
(116, '开县', 5, 0),
(117, '云阳县', 5, 0),
(118, '奉节县', 5, 0),
(119, '巫山县', 5, 0),
(120, '巫溪县', 5, 0),
(121, '石柱土家族自治县', 5, 0),
(122, '秀山土家族苗族自治县', 5, 0),
(123, '酉阳土家族苗族自治县', 5, 0),
(124, '彭水苗族土家族自治县', 5, 0),
(125, '石家庄市', 6, 1),
(126, '唐山市', 6, 1),
(127, '秦皇岛市', 6, 1),
(128, '邯郸市', 6, 1),
(129, '邢台市', 6, 1),
(130, '保定市', 6, 1),
(131, '张家口市', 6, 1),
(132, '承德市', 6, 1),
(133, '沧州市', 6, 1),
(134, '廊坊市', 6, 1),
(135, '衡水市', 6, 1),
(136, '太原市', 7, 1),
(137, '大同市', 7, 1),
(138, '阳泉市', 7, 1),
(139, '长治市', 7, 1),
(140, '晋城市', 7, 1),
(141, '朔州市', 7, 1),
(142, '晋中市', 7, 1),
(143, '运城市', 7, 1),
(144, '忻州市', 7, 1),
(145, '临汾市', 7, 1),
(146, '吕梁市', 7, 1),
(147, '呼和浩特市', 8, 1),
(148, '包头市', 8, 1),
(149, '乌海市', 8, 1),
(150, '赤峰市', 8, 1),
(151, '通辽市', 8, 1),
(152, '鄂尔多斯市', 8, 1),
(153, '呼伦贝尔市', 8, 1),
(154, '巴彦淖尔市', 8, 1),
(155, '乌兰察布市', 8, 1),
(156, '兴安盟', 8, 1),
(157, '锡林郭勒盟', 8, 1),
(158, '阿拉善盟', 8, 1),
(159, '沈阳市', 9, 1),
(160, '大连市', 9, 1),
(161, '鞍山市', 9, 1),
(162, '抚顺市', 9, 1),
(163, '本溪市', 9, 1),
(164, '丹东市', 9, 1),
(165, '锦州市', 9, 1),
(166, '营口市', 9, 1),
(167, '阜新市', 9, 1),
(168, '辽阳市', 9, 1),
(169, '盘锦市', 9, 1),
(170, '铁岭市', 9, 1),
(171, '朝阳市', 9, 1),
(172, '葫芦岛市', 9, 1),
(173, '长春市', 10, 1),
(174, '吉林市', 10, 1),
(175, '四平市', 10, 1),
(176, '辽源市', 10, 1),
(177, '通化市', 10, 1),
(178, '白山市', 10, 1),
(179, '松原市', 10, 1),
(180, '白城市', 10, 1),
(181, '延边', 10, 1),
(182, '哈尔滨市', 11, 1),
(183, '齐齐哈尔市', 11, 1),
(184, '鸡西市', 11, 1),
(185, '鹤岗市', 11, 1),
(186, '双鸭山市', 11, 1),
(187, '大庆市', 11, 1),
(188, '伊春市', 11, 1),
(189, '佳木斯市', 11, 1),
(190, '七台河市', 11, 1),
(191, '牡丹江市', 11, 1),
(192, '黑河市', 11, 1),
(193, '绥化市', 11, 1),
(194, '大兴安岭地区', 11, 1),
(195, '南京市', 12, 1),
(196, '无锡市', 12, 1),
(197, '徐州市', 12, 1),
(198, '常州市', 12, 1),
(199, '苏州市', 12, 1),
(200, '南通市', 12, 1),
(201, '连云港市', 12, 1),
(202, '淮安市', 12, 1),
(203, '盐城市', 12, 1),
(204, '扬州市', 12, 1),
(205, '镇江市', 12, 1),
(206, '泰州市', 12, 1),
(207, '宿迁市', 12, 1),
(208, '杭州市', 13, 1),
(209, '宁波市', 13, 1),
(210, '温州市', 13, 1),
(211, '嘉兴市', 13, 1),
(212, '湖州市', 13, 1),
(213, '绍兴市', 13, 1),
(214, '金华市', 13, 1),
(215, '衢州市', 13, 1),
(216, '舟山市', 13, 1),
(217, '台州市', 13, 1),
(218, '丽水市', 13, 1),
(219, '合肥市', 14, 1),
(220, '芜湖市', 14, 1),
(221, '蚌埠市', 14, 1),
(222, '淮南市', 14, 1),
(223, '马鞍山市', 14, 1),
(224, '淮北市', 14, 1),
(225, '铜陵市', 14, 1),
(226, '安庆市', 14, 1),
(227, '黄山市', 14, 1),
(228, '滁州市', 14, 1),
(229, '阜阳市', 14, 1),
(230, '宿州市', 14, 1),
(231, '六安市', 14, 1),
(232, '亳州市', 14, 1),
(233, '池州市', 14, 1),
(234, '宣城市', 14, 1),
(235, '福州市', 15, 1),
(236, '厦门市', 15, 1),
(237, '莆田市', 15, 1),
(238, '三明市', 15, 1),
(239, '泉州市', 15, 1),
(240, '漳州市', 15, 1),
(241, '南平市', 15, 1),
(242, '龙岩市', 15, 1),
(243, '宁德市', 15, 1),
(244, '南昌市', 16, 1),
(245, '景德镇市', 16, 1),
(246, '萍乡市', 16, 1),
(247, '九江市', 16, 1),
(248, '新余市', 16, 1),
(249, '鹰潭市', 16, 1),
(250, '赣州市', 16, 1),
(251, '吉安市', 16, 1),
(252, '宜春市', 16, 1),
(253, '抚州市', 16, 1),
(254, '上饶市', 16, 1),
(255, '济南市', 17, 1),
(256, '青岛市', 17, 1),
(257, '淄博市', 17, 1),
(258, '枣庄市', 17, 1),
(259, '东营市', 17, 1),
(260, '烟台市', 17, 1),
(261, '潍坊市', 17, 1),
(262, '济宁市', 17, 1),
(263, '泰安市', 17, 1),
(264, '威海市', 17, 1),
(265, '日照市', 17, 1),
(266, '莱芜市', 17, 1),
(267, '临沂市', 17, 1),
(268, '德州市', 17, 1),
(269, '聊城市', 17, 1),
(270, '滨州市', 17, 1),
(271, '荷泽市', 17, 1),
(272, '郑州市', 18, 1),
(273, '开封市', 18, 1),
(274, '洛阳市', 18, 1),
(275, '平顶山市', 18, 1),
(276, '安阳市', 18, 1),
(277, '鹤壁市', 18, 1),
(278, '新乡市', 18, 1),
(279, '焦作市', 18, 1),
(280, '濮阳市', 18, 1),
(281, '许昌市', 18, 1),
(282, '漯河市', 18, 1),
(283, '三门峡市', 18, 1),
(284, '南阳市', 18, 1),
(285, '商丘市', 18, 1),
(286, '信阳市', 18, 1),
(287, '周口市', 18, 1),
(288, '驻马店市', 18, 1),
(289, '武汉市', 19, 1),
(290, '黄石市', 19, 1),
(291, '十堰市', 19, 1),
(292, '宜昌市', 19, 1),
(293, '襄阳市', 19, 1),
(294, '鄂州市', 19, 1),
(295, '荆门市', 19, 1),
(296, '孝感市', 19, 1),
(297, '荆州市', 19, 1),
(298, '黄冈市', 19, 1),
(299, '咸宁市', 19, 1),
(300, '随州市', 19, 1),
(301, '恩施土家族苗族自治州', 19, 1),
(302, '仙桃市', 19, 0),
(303, '潜江市', 19, 0),
(304, '天门市', 19, 0),
(305, '神农架林区', 19, 0),
(306, '长沙市', 20, 1),
(307, '株洲市', 20, 1),
(308, '湘潭市', 20, 1),
(309, '衡阳市', 20, 1),
(310, '邵阳市', 20, 1),
(311, '岳阳市', 20, 1),
(312, '常德市', 20, 1),
(313, '张家界市', 20, 1),
(314, '益阳市', 20, 1),
(315, '郴州市', 20, 1),
(316, '永州市', 20, 1),
(317, '怀化市', 20, 1),
(318, '娄底市', 20, 1),
(319, '湘西土家族苗族自治州', 20, 1),
(320, '广州市', 21, 1),
(321, '韶关市', 21, 1),
(322, '深圳市', 21, 1),
(323, '珠海市', 21, 1),
(324, '汕头市', 21, 1),
(325, '佛山市', 21, 1),
(326, '江门市', 21, 1),
(327, '湛江市', 21, 1),
(328, '茂名市', 21, 1),
(329, '肇庆市', 21, 1),
(330, '惠州市', 21, 1),
(331, '梅州市', 21, 1),
(332, '汕尾市', 21, 1),
(333, '河源市', 21, 1),
(334, '阳江市', 21, 1),
(335, '清远市', 21, 1),
(336, '东莞市', 21, 0),
(337, '中山市', 21, 0),
(338, '潮州市', 21, 1),
(339, '揭阳市', 21, 1),
(340, '云浮市', 21, 1),
(341, '南宁市', 22, 1),
(342, '柳州市', 22, 1),
(343, '桂林市', 22, 1),
(344, '梧州市', 22, 1),
(345, '北海市', 22, 1),
(346, '防城港市', 22, 1),
(347, '钦州市', 22, 1),
(348, '贵港市', 22, 1),
(349, '玉林市', 22, 1),
(350, '百色市', 22, 1),
(351, '贺州市', 22, 1),
(352, '河池市', 22, 1),
(353, '来宾市', 22, 1),
(354, '崇左市', 22, 1),
(355, '海口市', 23, 1),
(356, '三亚市', 23, 0),
(357, '三沙市', 23, 0),
(358, '五指山市', 23, 0),
(359, '琼海市', 23, 0),
(360, '儋州市', 23, 0),
(361, '文昌市', 23, 0),
(362, '万宁市', 23, 0),
(363, '东方市', 23, 0),
(364, '定安县', 23, 0),
(365, '屯昌县', 23, 0),
(366, '澄迈县', 23, 0),
(367, '临高县', 23, 0),
(368, '白沙黎族自治县', 23, 0),
(369, '昌江黎族自治县', 23, 0),
(370, '乐东黎族自治县', 23, 0),
(371, '陵水黎族自治县', 23, 0),
(372, '保亭黎族苗族自治县', 23, 0),
(373, '琼中黎族苗族自治县', 23, 0),
(374, '成都市', 24, 1),
(375, '自贡市', 24, 1),
(376, '攀枝花市', 24, 1),
(377, '泸州市', 24, 1),
(378, '德阳市', 24, 1),
(379, '绵阳市', 24, 1),
(380, '广元市', 24, 1),
(381, '遂宁市', 24, 1),
(382, '内江市', 24, 1),
(383, '乐山市', 24, 1),
(384, '南充市', 24, 1),
(385, '眉山市', 24, 1),
(386, '宜宾市', 24, 1),
(387, '广安市', 24, 1),
(388, '达州市', 24, 1),
(389, '雅安市', 24, 1),
(390, '巴中市', 24, 1),
(391, '资阳市', 24, 1),
(392, '阿坝州', 24, 1),
(393, '甘孜州', 24, 1),
(394, '凉山州', 24, 1),
(395, '贵阳市', 25, 1),
(396, '六盘水市', 25, 1),
(397, '遵义市', 25, 1),
(398, '安顺市', 25, 1),
(399, '铜仁市', 25, 1),
(400, '黔西南州', 25, 1),
(401, '毕节市', 25, 1),
(402, '黔东南州', 25, 1),
(403, '黔南州', 25, 1),
(404, '昆明市', 26, 1),
(405, '曲靖市', 26, 1),
(406, '玉溪市', 26, 1),
(407, '保山市', 26, 1),
(408, '昭通市', 26, 1),
(409, '丽江市', 26, 1),
(410, '普洱市', 26, 1),
(411, '临沧市', 26, 1),
(412, '楚雄彝族自治州', 26, 1),
(413, '红河哈尼族彝族自治州', 26, 1),
(414, '文山壮族苗族自治州', 26, 1),
(415, '西双版纳傣族自治州', 26, 1),
(416, '大理白族自治州', 26, 1),
(417, '德宏傣族景颇族自治州', 26, 1),
(418, '怒江僳僳族自治州', 26, 1),
(419, '迪庆藏族自治州', 26, 1),
(420, '拉萨市', 27, 1),
(421, '昌都地区', 27, 1),
(422, '山南地区', 27, 1),
(423, '日喀则地区', 27, 1),
(424, '那曲地区', 27, 1),
(425, '阿里地区', 27, 1),
(426, '林芝地区', 27, 1),
(427, '西安市', 28, 1),
(428, '铜川市', 28, 1),
(429, '宝鸡市', 28, 1),
(430, '咸阳市', 28, 1),
(431, '渭南市', 28, 1),
(432, '延安市', 28, 1),
(433, '汉中市', 28, 1),
(434, '榆林市', 28, 1),
(435, '安康市', 28, 1),
(436, '商洛市', 28, 1),
(437, '兰州市', 29, 1),
(438, '嘉峪关市', 29, 0),
(439, '金昌市', 29, 1),
(440, '白银市', 29, 1),
(441, '天水市', 29, 1),
(442, '武威市', 29, 1),
(443, '张掖市', 29, 1),
(444, '平凉市', 29, 1),
(445, '酒泉市', 29, 1),
(446, '庆阳市', 29, 1),
(447, '定西市', 29, 1),
(448, '陇南市', 29, 1),
(449, '临夏州', 29, 1),
(450, '甘州', 29, 1),
(451, '西宁市', 30, 1),
(452, '海东市', 30, 1),
(453, '海州', 30, 1),
(454, '黄南州', 30, 1),
(455, '海南州', 30, 1),
(456, '果洛州', 30, 1),
(457, '玉树州', 30, 1),
(458, '海西州', 30, 1),
(459, '银川市', 31, 1),
(460, '石嘴山市', 31, 1),
(461, '吴忠市', 31, 1),
(462, '固原市', 31, 1),
(463, '中卫市', 31, 1),
(464, '乌鲁木齐市', 32, 1),
(465, '克拉玛依市', 32, 1),
(466, '吐鲁番市', 32, 1),
(467, '哈密地区', 32, 1),
(468, '昌吉回族自治州', 32, 1),
(469, '博尔塔拉蒙古自治州', 32, 1),
(470, '巴音郭楞蒙古自治州', 32, 1),
(471, '阿克苏地区', 32, 1),
(472, '克孜勒苏柯尔克孜自治州', 32, 1),
(473, '喀什地区', 32, 1),
(474, '和田地区', 32, 1),
(475, '伊犁哈萨克自治州', 32, 1),
(476, '塔城地区', 32, 1),
(477, '阿勒泰地区', 32, 1),
(478, '石河子市', 32, 0),
(479, '阿拉尔市', 32, 0),
(480, '图木舒克市', 32, 0),
(481, '五家渠市', 32, 0),
(482, '北屯市', 32, 0),
(483, '铁门关市', 32, 0),
(484, '台北市', 33, 0),
(485, '高雄市', 33, 0),
(486, '基隆市', 33, 0),
(487, '新竹市', 33, 0),
(488, '台中市', 33, 0),
(489, '嘉义市', 33, 0),
(490, '台南市', 33, 0),
(491, '台北县', 33, 0),
(492, '桃园县', 33, 0),
(493, '新竹县', 33, 0),
(494, '苗栗县', 33, 0),
(495, '台中县', 33, 0),
(496, '彰化县', 33, 0),
(497, '南投县', 33, 0),
(498, '云林县', 33, 0),
(499, '嘉义县', 33, 0),
(500, '台南县', 33, 0),
(501, '高雄县', 33, 0),
(502, '屏东县', 33, 0),
(503, '宜兰县', 33, 0),
(504, '花莲县', 33, 0),
(505, '台东县', 33, 0),
(506, '澎湖县', 33, 0),
(507, '金门县', 33, 0),
(508, '连江县', 33, 0),
(509, '中西区', 34, 0),
(510, '东区', 34, 0),
(511, '南区', 34, 0),
(512, '湾仔区', 34, 0),
(513, '九龙城区', 34, 0),
(514, '观塘区', 34, 0),
(515, '深水埗区', 34, 0),
(516, '黄大仙区', 34, 0),
(517, '油尖旺区', 34, 0),
(518, '离岛区', 34, 0),
(519, '葵青区', 34, 0),
(520, '北区', 34, 0),
(521, '西贡区', 34, 0),
(522, '沙田区', 34, 0),
(523, '大埔区', 34, 0),
(524, '荃湾区', 34, 0),
(525, '屯门区', 34, 0),
(526, '元朗区', 34, 0),
(527, '花地玛堂区', 35, 0),
(528, '市圣安多尼堂区', 35, 0),
(529, '大堂区', 35, 0),
(530, '望德堂区', 35, 0),
(531, '风顺堂区', 35, 0),
(532, '嘉模堂区', 35, 0),
(533, '圣方济各堂区', 35, 0),
(534, '长安区', 125, 0),
(535, '桥东区', 125, 0),
(536, '桥西区', 125, 0),
(537, '新华区', 125, 0),
(538, '井陉矿区', 125, 0),
(539, '裕华区', 125, 0),
(540, '井陉县', 125, 0),
(541, '正定县', 125, 0),
(542, '栾城县', 125, 0),
(543, '行唐县', 125, 0),
(544, '灵寿县', 125, 0),
(545, '高邑县', 125, 0),
(546, '深泽县', 125, 0),
(547, '赞皇县', 125, 0),
(548, '无极县', 125, 0),
(549, '平山县', 125, 0),
(550, '元氏县', 125, 0),
(551, '赵县', 125, 0),
(552, '辛集市', 125, 0),
(553, '藁城市', 125, 0),
(554, '晋州市', 125, 0),
(555, '新乐市', 125, 0),
(556, '鹿泉市', 125, 0),
(557, '路南区', 126, 0),
(558, '路北区', 126, 0),
(559, '古冶区', 126, 0),
(560, '开平区', 126, 0),
(561, '丰南区', 126, 0),
(562, '丰润区', 126, 0),
(563, '滦县', 126, 0),
(564, '曹妃甸区', 126, 0),
(565, '滦南县', 126, 0),
(566, '乐亭县', 126, 0),
(567, '迁西县', 126, 0),
(568, '玉田县', 126, 0),
(569, '遵化市', 126, 0),
(570, '迁安市', 126, 0),
(571, '海港区', 127, 0),
(572, '山海关区', 127, 0),
(573, '北戴河区', 127, 0),
(574, '青龙县', 127, 0),
(575, '昌黎县', 127, 0),
(576, '抚宁县', 127, 0),
(577, '卢龙县', 127, 0),
(578, '邯山区', 128, 0),
(579, '丛台区', 128, 0),
(580, '复兴区', 128, 0),
(581, '峰峰矿区', 128, 0),
(582, '邯郸县', 128, 0),
(583, '临漳县', 128, 0),
(584, '成安县', 128, 0),
(585, '大名县', 128, 0),
(586, '涉县', 128, 0),
(587, '磁县', 128, 0),
(588, '肥乡县', 128, 0),
(589, '永年县', 128, 0),
(590, '邱县', 128, 0),
(591, '鸡泽县', 128, 0),
(592, '广平县', 128, 0),
(593, '馆陶县', 128, 0),
(594, '魏县', 128, 0),
(595, '曲周县', 128, 0),
(596, '武安市', 128, 0),
(597, '桥东区', 129, 0),
(598, '桥西区', 129, 0),
(599, '邢台县', 129, 0),
(600, '临城县', 129, 0),
(601, '内丘县', 129, 0),
(602, '柏乡县', 129, 0),
(603, '隆尧县', 129, 0),
(604, '任县', 129, 0),
(605, '南和县', 129, 0),
(606, '宁晋县', 129, 0),
(607, '巨鹿县', 129, 0),
(608, '新河县', 129, 0),
(609, '广宗县', 129, 0),
(610, '平乡县', 129, 0),
(611, '威县', 129, 0),
(612, '清河县', 129, 0),
(613, '临西县', 129, 0),
(614, '南宫市', 129, 0),
(615, '沙河市', 129, 0),
(616, '新市区', 130, 0),
(617, '北市区', 130, 0),
(618, '南市区', 130, 0),
(619, '满城县', 130, 0),
(620, '清苑县', 130, 0),
(621, '涞水县', 130, 0),
(622, '阜平县', 130, 0),
(623, '徐水县', 130, 0),
(624, '定兴县', 130, 0),
(625, '唐县', 130, 0),
(626, '高阳县', 130, 0),
(627, '容城县', 130, 0),
(628, '涞源县', 130, 0),
(629, '望都县', 130, 0),
(630, '安新县', 130, 0),
(631, '易县', 130, 0),
(632, '曲阳县', 130, 0),
(633, '蠡县', 130, 0),
(634, '顺平县', 130, 0),
(635, '博野县', 130, 0),
(636, '雄县', 130, 0),
(637, '涿州市', 130, 0),
(638, '定州市', 130, 0),
(639, '安国市', 130, 0),
(640, '高碑店市', 130, 0),
(641, '桥东区', 131, 0),
(642, '桥西区', 131, 0),
(643, '宣化区', 131, 0),
(644, '下花园区', 131, 0),
(645, '宣化县', 131, 0),
(646, '张北县', 131, 0),
(647, '康保县', 131, 0),
(648, '沽源县', 131, 0),
(649, '尚义县', 131, 0),
(650, '蔚县', 131, 0),
(651, '阳原县', 131, 0),
(652, '怀安县', 131, 0),
(653, '万全县', 131, 0),
(654, '怀来县', 131, 0),
(655, '涿鹿县', 131, 0),
(656, '赤城县', 131, 0),
(657, '崇礼县', 131, 0),
(658, '双桥区', 132, 0),
(659, '双滦区', 132, 0),
(660, '鹰手营子矿区', 132, 0),
(661, '承德县', 132, 0),
(662, '兴隆县', 132, 0),
(663, '平泉县', 132, 0),
(664, '滦平县', 132, 0),
(665, '隆化县', 132, 0),
(666, '丰宁县', 132, 0),
(667, '宽城县', 132, 0),
(668, '围场县', 132, 0),
(669, '新华区', 133, 0),
(670, '运河区', 133, 0),
(671, '沧县', 133, 0),
(672, '青县', 133, 0),
(673, '东光县', 133, 0),
(674, '海兴县', 133, 0),
(675, '盐山县', 133, 0),
(676, '肃宁县', 133, 0),
(677, '南皮县', 133, 0),
(678, '吴桥县', 133, 0),
(679, '献县', 133, 0),
(680, '孟村县', 133, 0),
(681, '泊头市', 133, 0),
(682, '任丘市', 133, 0),
(683, '黄骅市', 133, 0),
(684, '河间市', 133, 0),
(685, '安次区', 134, 0),
(686, '广阳区', 134, 0),
(687, '固安县', 134, 0),
(688, '永清县', 134, 0),
(689, '香河县', 134, 0),
(690, '大城县', 134, 0),
(691, '文安县', 134, 0),
(692, '大厂县', 134, 0),
(693, '霸州市', 134, 0),
(694, '三河市', 134, 0),
(695, '桃城区', 135, 0),
(696, '枣强县', 135, 0),
(697, '武邑县', 135, 0),
(698, '武强县', 135, 0),
(699, '饶阳县', 135, 0),
(700, '安平县', 135, 0),
(701, '故城县', 135, 0),
(702, '景县', 135, 0),
(703, '阜城县', 135, 0),
(704, '冀州市', 135, 0),
(705, '深州市', 135, 0),
(706, '小店区', 136, 0),
(707, '迎泽区', 136, 0),
(708, '杏花岭区', 136, 0),
(709, '尖草坪区', 136, 0),
(710, '万柏林区', 136, 0),
(711, '晋源区', 136, 0),
(712, '清徐县', 136, 0),
(713, '阳曲县', 136, 0),
(714, '娄烦县', 136, 0),
(715, '古交市', 136, 0),
(716, '城区', 137, 0),
(717, '矿区', 137, 0),
(718, '南郊区', 137, 0),
(719, '新荣区', 137, 0),
(720, '阳高县', 137, 0),
(721, '天镇县', 137, 0),
(722, '广灵县', 137, 0),
(723, '灵丘县', 137, 0),
(724, '浑源县', 137, 0),
(725, '左云县', 137, 0),
(726, '大同县', 137, 0),
(727, '城区', 138, 0),
(728, '矿区', 138, 0),
(729, '郊区', 138, 0),
(730, '平定县', 138, 0),
(731, '盂县', 138, 0),
(732, '城区', 139, 0),
(733, '郊区', 139, 0),
(734, '长治县', 139, 0),
(735, '襄垣县', 139, 0),
(736, '屯留县', 139, 0),
(737, '平顺县', 139, 0),
(738, '黎城县', 139, 0),
(739, '壶关县', 139, 0),
(740, '长子县', 139, 0),
(741, '武乡县', 139, 0),
(742, '沁县', 139, 0),
(743, '沁源县', 139, 0),
(744, '潞城市', 139, 0),
(745, '城区', 140, 0),
(746, '沁水县', 140, 0),
(747, '阳城县', 140, 0),
(748, '陵川县', 140, 0),
(749, '泽州县', 140, 0),
(750, '高平市', 140, 0),
(751, '朔城区', 141, 0),
(752, '平鲁区', 141, 0),
(753, '山阴县', 141, 0),
(754, '应县', 141, 0),
(755, '右玉县', 141, 0),
(756, '怀仁县', 141, 0),
(757, '榆次区', 142, 0),
(758, '榆社县', 142, 0),
(759, '左权县', 142, 0),
(760, '和顺县', 142, 0),
(761, '昔阳县', 142, 0),
(762, '寿阳县', 142, 0),
(763, '太谷县', 142, 0),
(764, '祁县', 142, 0),
(765, '平遥县', 142, 0),
(766, '灵石县', 142, 0),
(767, '介休市', 142, 0),
(768, '盐湖区', 143, 0),
(769, '临猗县', 143, 0),
(770, '万荣县', 143, 0),
(771, '闻喜县', 143, 0),
(772, '稷山县', 143, 0),
(773, '新绛县', 143, 0),
(774, '绛县', 143, 0),
(775, '垣曲县', 143, 0),
(776, '夏县', 143, 0),
(777, '平陆县', 143, 0),
(778, '芮城县', 143, 0),
(779, '永济市', 143, 0),
(780, '河津市', 143, 0),
(781, '忻府区', 144, 0),
(782, '定襄县', 144, 0),
(783, '五台县', 144, 0),
(784, '代县', 144, 0),
(785, '繁峙县', 144, 0),
(786, '宁武县', 144, 0),
(787, '静乐县', 144, 0),
(788, '神池县', 144, 0),
(789, '五寨县', 144, 0),
(790, '岢岚县', 144, 0),
(791, '河曲县', 144, 0),
(792, '保德县', 144, 0),
(793, '偏关县', 144, 0),
(794, '原平市', 144, 0),
(795, '尧都区', 145, 0),
(796, '曲沃县', 145, 0),
(797, '翼城县', 145, 0),
(798, '襄汾县', 145, 0),
(799, '洪洞县', 145, 0),
(800, '古县', 145, 0),
(801, '安泽县', 145, 0),
(802, '浮山县', 145, 0),
(803, '吉县', 145, 0),
(804, '乡宁县', 145, 0),
(805, '大宁县', 145, 0),
(806, '隰县', 145, 0),
(807, '永和县', 145, 0),
(808, '蒲县', 145, 0),
(809, '汾西县', 145, 0),
(810, '侯马市', 145, 0),
(811, '霍州市', 145, 0),
(812, '离石区', 146, 0),
(813, '文水县', 146, 0),
(814, '交城县', 146, 0),
(815, '兴县', 146, 0),
(816, '临县', 146, 0),
(817, '柳林县', 146, 0),
(818, '石楼县', 146, 0),
(819, '岚县', 146, 0),
(820, '方山县', 146, 0),
(821, '中阳县', 146, 0),
(822, '交口县', 146, 0),
(823, '孝义市', 146, 0),
(824, '汾阳市', 146, 0),
(825, '新城区', 147, 0),
(826, '回民区', 147, 0),
(827, '玉泉区', 147, 0),
(828, '赛罕区', 147, 0),
(829, '土默特左旗', 147, 0),
(830, '托克托县', 147, 0),
(831, '和林格尔县', 147, 0),
(832, '清水河县', 147, 0),
(833, '武川县', 147, 0),
(834, '东河区', 148, 0),
(835, '昆都仑区', 148, 0),
(836, '青山区', 148, 0),
(837, '石拐区', 148, 0),
(838, '白云矿区', 148, 0),
(839, '九原区', 148, 0),
(840, '土默特右旗', 148, 0),
(841, '固阳县', 148, 0),
(842, '达尔罕茂明安联合旗', 148, 0),
(843, '海勃湾区', 149, 0),
(844, '海南区', 149, 0),
(845, '乌达区', 149, 0),
(846, '红山区', 150, 0),
(847, '元宝山区', 150, 0),
(848, '松山区', 150, 0),
(849, '阿鲁科尔沁旗', 150, 0),
(850, '巴林左旗', 150, 0),
(851, '巴林右旗', 150, 0),
(852, '林西县', 150, 0),
(853, '克什克腾旗', 150, 0),
(854, '翁牛特旗', 150, 0),
(855, '喀喇沁旗', 150, 0),
(856, '宁城县', 150, 0),
(857, '敖汉旗', 150, 0),
(858, '科尔沁区', 151, 0),
(859, '科尔沁左翼中旗', 151, 0),
(860, '科尔沁左翼后旗', 151, 0),
(861, '开鲁县', 151, 0),
(862, '库伦旗', 151, 0),
(863, '奈曼旗', 151, 0),
(864, '扎鲁特旗', 151, 0),
(865, '霍林郭勒市', 151, 0),
(866, '东胜区', 152, 0),
(867, '达拉特旗', 152, 0),
(868, '准格尔旗', 152, 0),
(869, '鄂托克前旗', 152, 0),
(870, '鄂托克旗', 152, 0),
(871, '杭锦旗', 152, 0),
(872, '乌审旗', 152, 0),
(873, '伊金霍洛旗', 152, 0),
(874, '海拉尔区', 153, 0),
(875, '阿荣旗', 153, 0),
(876, '莫力达瓦达斡尔族自治旗', 153, 0),
(877, '鄂伦春自治旗', 153, 0),
(878, '鄂温克族自治旗', 153, 0),
(879, '陈巴尔虎旗', 153, 0),
(880, '新巴尔虎左旗', 153, 0),
(881, '新巴尔虎右旗', 153, 0),
(882, '满洲里市', 153, 0),
(883, '牙克石市', 153, 0),
(884, '扎兰屯市', 153, 0),
(885, '额尔古纳市', 153, 0),
(886, '根河市', 153, 0),
(887, '临河区', 154, 0),
(888, '五原县', 154, 0),
(889, '磴口县', 154, 0),
(890, '乌拉特前旗', 154, 0),
(891, '乌拉特中旗', 154, 0),
(892, '乌拉特后旗', 154, 0),
(893, '杭锦后旗', 154, 0),
(894, '集宁区', 155, 0),
(895, '卓资县', 155, 0),
(896, '化德县', 155, 0),
(897, '商都县', 155, 0),
(898, '兴和县', 155, 0),
(899, '凉城县', 155, 0),
(900, '察哈尔右翼前旗', 155, 0),
(901, '察哈尔右翼中旗', 155, 0),
(902, '察哈尔右翼后旗', 155, 0),
(903, '四子王旗', 155, 0),
(904, '丰镇市', 155, 0),
(905, '乌兰浩特市', 156, 0),
(906, '阿尔山市', 156, 0),
(907, '科尔沁右翼前旗', 156, 0),
(908, '科尔沁右翼中旗', 156, 0),
(909, '扎赉特旗', 156, 0),
(910, '突泉县', 156, 0),
(911, '二连浩特市', 157, 0),
(912, '锡林浩特市', 157, 0),
(913, '阿巴嘎旗', 157, 0),
(914, '苏尼特左旗', 157, 0),
(915, '苏尼特右旗', 157, 0),
(916, '东乌珠穆沁旗', 157, 0),
(917, '西乌珠穆沁旗', 157, 0),
(918, '太仆寺旗', 157, 0),
(919, '镶黄旗', 157, 0),
(920, '正镶白旗', 157, 0),
(921, '正蓝旗', 157, 0),
(922, '多伦县', 157, 0),
(923, '阿拉善左旗', 158, 0),
(924, '阿拉善右旗', 158, 0),
(925, '额济纳旗', 158, 0),
(926, '和平区', 159, 0),
(927, '沈河区', 159, 0),
(928, '大东区', 159, 0),
(929, '皇姑区', 159, 0),
(930, '铁西区', 159, 0),
(931, '苏家屯区', 159, 0),
(932, '东陵区', 159, 0),
(933, '沈北新区', 159, 0),
(934, '于洪区', 159, 0),
(935, '辽中县', 159, 0),
(936, '康平县', 159, 0),
(937, '法库县', 159, 0),
(938, '新民市', 159, 0),
(939, '中山区', 160, 0),
(940, '西岗区', 160, 0),
(941, '沙河口区', 160, 0),
(942, '甘井子区', 160, 0),
(943, '旅顺口区', 160, 0),
(944, '金州区', 160, 0),
(945, '长海县', 160, 0),
(946, '瓦房店市', 160, 0),
(947, '普兰店市', 160, 0),
(948, '庄河市', 160, 0),
(949, '铁东区', 161, 0),
(950, '铁西区', 161, 0),
(951, '立山区', 161, 0),
(952, '千山区', 161, 0),
(953, '台安县', 161, 0),
(954, '岫岩满族自治县', 161, 0),
(955, '海城市', 161, 0),
(956, '新抚区', 162, 0),
(957, '东洲区', 162, 0),
(958, '望花区', 162, 0),
(959, '顺城区', 162, 0),
(960, '抚顺县', 162, 0),
(961, '新宾满族自治县', 162, 0),
(962, '清原满族自治县', 162, 0),
(963, '平山区', 163, 0),
(964, '溪湖区', 163, 0),
(965, '明山区', 163, 0),
(966, '南芬区', 163, 0),
(967, '本溪满族自治县', 163, 0),
(968, '桓仁满族自治县', 163, 0),
(969, '元宝区', 164, 0),
(970, '振兴区', 164, 0),
(971, '振安区', 164, 0),
(972, '宽甸满族自治县', 164, 0),
(973, '东港市', 164, 0),
(974, '凤城市', 164, 0),
(975, '古塔区', 165, 0),
(976, '凌河区', 165, 0),
(977, '太和区', 165, 0),
(978, '黑山县', 165, 0),
(979, '义县', 165, 0),
(980, '凌海市', 165, 0),
(981, '北镇市', 165, 0),
(982, '站前区', 166, 0),
(983, '西市区', 166, 0),
(984, '鲅鱼圈区', 166, 0),
(985, '老边区', 166, 0),
(986, '盖州市', 166, 0),
(987, '大石桥市', 166, 0),
(988, '海州区', 167, 0),
(989, '新邱区', 167, 0),
(990, '太平区', 167, 0),
(991, '清河门区', 167, 0),
(992, '细河区', 167, 0),
(993, '阜新蒙古族自治县', 167, 0),
(994, '彰武县', 167, 0),
(995, '白塔区', 168, 0),
(996, '文圣区', 168, 0),
(997, '宏伟区', 168, 0),
(998, '弓长岭区', 168, 0),
(999, '太子河区', 168, 0),
(1000, '辽阳县', 168, 0),
(1001, '灯塔市', 168, 0),
(1002, '双台子区', 169, 0),
(1003, '兴隆台区', 169, 0),
(1004, '大洼县', 169, 0),
(1005, '盘山县', 169, 0),
(1006, '银州区', 170, 0),
(1007, '清河区', 170, 0),
(1008, '铁岭县', 170, 0),
(1009, '西丰县', 170, 0),
(1010, '昌图县', 170, 0),
(1011, '调兵山市', 170, 0),
(1012, '开原市', 170, 0),
(1013, '双塔区', 171, 0),
(1014, '龙城区', 171, 0),
(1015, '朝阳县', 171, 0),
(1016, '建平县', 171, 0),
(1017, '喀喇沁左翼蒙古族自治县', 171, 0),
(1018, '北票市', 171, 0),
(1019, '凌源市', 171, 0),
(1020, '连山区', 172, 0),
(1021, '龙港区', 172, 0),
(1022, '南票区', 172, 0),
(1023, '绥中县', 172, 0),
(1024, '建昌县', 172, 0),
(1025, '兴城市', 172, 0),
(1026, '南关区', 173, 0),
(1027, '宽城区', 173, 0),
(1028, '朝阳区', 173, 0),
(1029, '二道区', 173, 0),
(1030, '绿园区', 173, 0),
(1031, '双阳区', 173, 0),
(1032, '农安县', 173, 0),
(1033, '九台市', 173, 0),
(1034, '榆树市', 173, 0),
(1035, '德惠市', 173, 0),
(1036, '昌邑区', 174, 0),
(1037, '龙潭区', 174, 0),
(1038, '船营区', 174, 0),
(1039, '丰满区', 174, 0),
(1040, '永吉县', 174, 0),
(1041, '蛟河市', 174, 0),
(1042, '桦甸市', 174, 0),
(1043, '舒兰市', 174, 0),
(1044, '磐石市', 174, 0),
(1045, '铁西区', 175, 0),
(1046, '铁东区', 175, 0),
(1047, '梨树县', 175, 0),
(1048, '伊通满族自治县', 175, 0),
(1049, '公主岭市', 175, 0),
(1050, '双辽市', 175, 0),
(1051, '龙山区', 176, 0),
(1052, '西安区', 176, 0),
(1053, '东丰县', 176, 0),
(1054, '东辽县', 176, 0),
(1055, '东昌区', 177, 0),
(1056, '二道江区', 177, 0),
(1057, '通化县', 177, 0),
(1058, '辉南县', 177, 0),
(1059, '柳河县', 177, 0),
(1060, '梅河口市', 177, 0),
(1061, '集安市', 177, 0),
(1062, '浑江区', 178, 0),
(1063, '江源区', 178, 0),
(1064, '临江市', 178, 0),
(1065, '抚松县', 178, 0),
(1066, '靖宇县', 178, 0),
(1067, '长白朝鲜族自治县', 178, 0),
(1068, '宁江区', 179, 0),
(1069, '扶余市', 179, 0),
(1070, '长岭县', 179, 0),
(1071, '乾安县', 179, 0),
(1072, '前郭尔罗斯蒙古族自治县', 179, 0),
(1073, '洮北区', 180, 0),
(1074, '镇赉县', 180, 0),
(1075, '通榆县', 180, 0),
(1076, '洮南市', 180, 0),
(1077, '大安市', 180, 0),
(1078, '延吉市', 181, 0),
(1079, '图们市', 181, 0),
(1080, '敦化市', 181, 0),
(1081, '珲春市', 181, 0),
(1082, '龙井市', 181, 0),
(1083, '和龙市', 181, 0),
(1084, '汪清县', 181, 0),
(1085, '安图县', 181, 0),
(1086, '南岗区', 182, 0),
(1087, '道里区', 182, 0),
(1088, '道外区', 182, 0),
(1089, '香坊区', 182, 0),
(1090, '松北区', 182, 0),
(1091, '平房区', 182, 0),
(1092, '呼兰区', 182, 0),
(1093, '阿城区', 182, 0),
(1094, '双城区', 182, 0),
(1095, '尚志市', 182, 0),
(1096, '五常市', 182, 0),
(1097, '宾县', 182, 0),
(1098, '方正县', 182, 0),
(1099, '依兰县', 182, 0),
(1100, '巴彦县', 182, 0),
(1101, '木兰县', 182, 0),
(1102, '延寿县', 182, 0),
(1103, '通河县', 182, 0),
(1104, '龙沙区', 183, 0),
(1105, '建华区', 183, 0),
(1106, '铁锋区', 183, 0),
(1107, '昂昂溪区', 183, 0),
(1108, '富拉尔基区', 183, 0),
(1109, '碾子山区', 183, 0),
(1110, '梅里斯达斡尔族区', 183, 0),
(1111, '龙江县', 183, 0),
(1112, '依安县', 183, 0),
(1113, '泰来县', 183, 0),
(1114, '甘南县', 183, 0),
(1115, '富裕县', 183, 0),
(1116, '克山县', 183, 0),
(1117, '克东县', 183, 0),
(1118, '拜泉县', 183, 0),
(1119, '讷河市', 183, 0),
(1120, '鸡冠区', 184, 0),
(1121, '恒山区', 184, 0),
(1122, '滴道区', 184, 0),
(1123, '梨树区', 184, 0),
(1124, '城子河区', 184, 0),
(1125, '麻山区', 184, 0),
(1126, '鸡东县', 184, 0),
(1127, '虎林市', 184, 0),
(1128, '密山市', 184, 0),
(1129, '向阳区', 185, 0),
(1130, '工农区', 185, 0),
(1131, '南山区', 185, 0),
(1132, '兴安区', 185, 0),
(1133, '东山区', 185, 0),
(1134, '兴山区', 185, 0),
(1135, '萝北县', 185, 0),
(1136, '绥滨县', 185, 0),
(1137, '尖山区', 186, 0),
(1138, '岭东区', 186, 0),
(1139, '四方台区', 186, 0),
(1140, '宝山区', 186, 0),
(1141, '集贤县', 186, 0),
(1142, '友谊县', 186, 0),
(1143, '宝清县', 186, 0),
(1144, '饶河县', 186, 0),
(1145, '萨尔图区', 187, 0),
(1146, '龙凤区', 187, 0),
(1147, '让胡路区', 187, 0),
(1148, '红岗区', 187, 0),
(1149, '大同区', 187, 0),
(1150, '肇州县', 187, 0),
(1151, '肇源县', 187, 0),
(1152, '林甸县', 187, 0),
(1153, '杜尔伯特蒙古族自治县', 187, 0),
(1154, '伊春区', 188, 0),
(1155, '南岔区', 188, 0),
(1156, '友好区', 188, 0),
(1157, '西林区', 188, 0),
(1158, '翠峦区', 188, 0),
(1159, '新青区', 188, 0),
(1160, '美溪区', 188, 0),
(1161, '金山屯区', 188, 0),
(1162, '五营区', 188, 0),
(1163, '乌马河区', 188, 0),
(1164, '汤旺河区', 188, 0),
(1165, '带岭区', 188, 0),
(1166, '乌伊岭区', 188, 0),
(1167, '红星区', 188, 0),
(1168, '上甘岭区', 188, 0),
(1169, '嘉荫县', 188, 0),
(1170, '铁力市', 188, 0),
(1171, '向阳区', 189, 0),
(1172, '前进区', 189, 0),
(1173, '东风区', 189, 0),
(1174, '郊区', 189, 0),
(1175, '桦南县', 189, 0),
(1176, '桦川县', 189, 0),
(1177, '汤原县', 189, 0),
(1178, '抚远县', 189, 0),
(1179, '同江市', 189, 0),
(1180, '富锦市', 189, 0),
(1181, '新兴区', 190, 0),
(1182, '桃山区', 190, 0),
(1183, '茄子河区', 190, 0),
(1184, '勃利县', 190, 0),
(1185, '东安区', 191, 0),
(1186, '阳明区', 191, 0),
(1187, '爱民区', 191, 0),
(1188, '西安区', 191, 0),
(1189, '东宁县', 191, 0),
(1190, '林口县', 191, 0),
(1191, '绥芬河市', 191, 0),
(1192, '海林市', 191, 0),
(1193, '宁安市', 191, 0),
(1194, '穆棱市', 191, 0),
(1195, '爱辉区', 192, 0),
(1196, '嫩江县', 192, 0),
(1197, '逊克县', 192, 0),
(1198, '孙吴县', 192, 0),
(1199, '北安市', 192, 0),
(1200, '五大连池市', 192, 0),
(1201, '北林区', 193, 0),
(1202, '望奎县', 193, 0),
(1203, '兰西县', 193, 0),
(1204, '青冈县', 193, 0),
(1205, '庆安县', 193, 0),
(1206, '明水县', 193, 0),
(1207, '绥棱县', 193, 0),
(1208, '安达市', 193, 0),
(1209, '肇东市', 193, 0),
(1210, '海伦市', 193, 0),
(1211, '呼玛县', 194, 0),
(1212, '塔河县', 194, 0),
(1213, '漠河县', 194, 0),
(1214, '玄武区', 195, 0),
(1215, '秦淮区', 195, 0),
(1216, '建邺区', 195, 0),
(1217, '鼓楼区', 195, 0),
(1218, '浦口区', 195, 0),
(1219, '栖霞区', 195, 0),
(1220, '雨花台区', 195, 0),
(1221, '江宁区', 195, 0),
(1222, '六合区', 195, 0),
(1223, '溧水区', 195, 0),
(1224, '高淳区', 195, 0),
(1225, '崇安区', 196, 0),
(1226, '南长区', 196, 0),
(1227, '北塘区', 196, 0),
(1228, '锡山区', 196, 0),
(1229, '惠山区', 196, 0),
(1230, '滨湖区', 196, 0),
(1231, '江阴市', 196, 0),
(1232, '宜兴市', 196, 0),
(1233, '鼓楼区', 197, 0),
(1234, '云龙区', 197, 0),
(1235, '贾汪区', 197, 0),
(1236, '泉山区', 197, 0),
(1237, '铜山区', 197, 0),
(1238, '丰县', 197, 0),
(1239, '沛县', 197, 0),
(1240, '睢宁县', 197, 0),
(1241, '新沂市', 197, 0),
(1242, '邳州市', 197, 0),
(1243, '天宁区', 198, 0),
(1244, '钟楼区', 198, 0),
(1245, '戚墅堰区', 198, 0),
(1246, '新北区', 198, 0),
(1247, '武进区', 198, 0),
(1248, '溧阳市', 198, 0),
(1249, '金坛市', 198, 0),
(1250, '姑苏区', 199, 0),
(1251, '虎丘区', 199, 0),
(1252, '吴中区', 199, 0),
(1253, '相城区', 199, 0),
(1254, '吴江区', 199, 0),
(1255, '常熟市', 199, 0),
(1256, '昆山市', 199, 0),
(1257, '张家港市', 199, 0),
(1258, '太仓市', 199, 0),
(1259, '崇川区', 200, 0),
(1260, '港闸区', 200, 0),
(1261, '海安县', 200, 0),
(1262, '如东县', 200, 0),
(1263, '启东市', 200, 0),
(1264, '如皋市', 200, 0),
(1265, '通州市', 200, 0),
(1266, '海门市', 200, 0),
(1267, '连云区', 201, 0),
(1268, '新浦区', 201, 0),
(1269, '海州区', 201, 0),
(1270, '赣榆县', 201, 0),
(1271, '东海县', 201, 0),
(1272, '灌云县', 201, 0),
(1273, '灌南县', 201, 0),
(1274, '清河区', 202, 0),
(1275, '淮安区', 202, 0),
(1276, '淮阴区', 202, 0),
(1277, '清浦区', 202, 0),
(1278, '涟水县', 202, 0),
(1279, '洪泽县', 202, 0),
(1280, '盱眙县', 202, 0),
(1281, '金湖县', 202, 0),
(1282, '亭湖区', 203, 0),
(1283, '盐都区', 203, 0),
(1284, '响水县', 203, 0),
(1285, '滨海县', 203, 0),
(1286, '阜宁县', 203, 0),
(1287, '射阳县', 203, 0),
(1288, '建湖县', 203, 0),
(1289, '东台市', 203, 0),
(1290, '大丰市', 203, 0),
(1291, '广陵区', 204, 0),
(1292, '邗江区', 204, 0),
(1293, '江都区', 204, 0),
(1294, '宝应县', 204, 0),
(1295, '仪征市', 204, 0),
(1296, '高邮市', 204, 0),
(1297, '京口区', 205, 0),
(1298, '润州区', 205, 0),
(1299, '丹徒区', 205, 0),
(1300, '丹阳市', 205, 0),
(1301, '扬中市', 205, 0),
(1302, '句容市', 205, 0),
(1303, '海陵区', 206, 0),
(1304, '高港区', 206, 0),
(1305, '姜堰区', 206, 0),
(1306, '兴化市', 206, 0),
(1307, '靖江市', 206, 0),
(1308, '泰兴市', 206, 0),
(1309, '宿城区', 207, 0),
(1310, '宿豫区', 207, 0),
(1311, '沭阳县', 207, 0),
(1312, '泗阳县', 207, 0),
(1313, '泗洪县', 207, 0),
(1314, '上城区', 208, 0),
(1315, '下城区', 208, 0),
(1316, '江干区', 208, 0),
(1317, '拱墅区', 208, 0),
(1318, '西湖区', 208, 0),
(1319, '滨江区', 208, 0),
(1320, '萧山区', 208, 0),
(1321, '余杭区', 208, 0),
(1322, '桐庐县', 208, 0),
(1323, '淳安县', 208, 0),
(1324, '建德市', 208, 0),
(1325, '富阳市', 208, 0),
(1326, '临安市', 208, 0),
(1327, '海曙区', 209, 0),
(1328, '江东区', 209, 0),
(1329, '江北区', 209, 0),
(1330, '北仑区', 209, 0),
(1331, '镇海区', 209, 0),
(1332, '鄞州区', 209, 0),
(1333, '象山县', 209, 0),
(1334, '宁海县', 209, 0),
(1335, '余姚市', 209, 0),
(1336, '慈溪市', 209, 0),
(1337, '奉化市', 209, 0),
(1338, '鹿城区', 210, 0),
(1339, '龙湾区', 210, 0),
(1340, '瓯海区', 210, 0),
(1341, '洞头县', 210, 0),
(1342, '永嘉县', 210, 0),
(1343, '平阳县', 210, 0),
(1344, '苍南县', 210, 0),
(1345, '文成县', 210, 0),
(1346, '泰顺县', 210, 0),
(1347, '瑞安市', 210, 0),
(1348, '乐清市', 210, 0),
(1349, '秀城区', 211, 0),
(1350, '秀洲区', 211, 0),
(1351, '嘉善县', 211, 0),
(1352, '海盐县', 211, 0),
(1353, '海宁市', 211, 0),
(1354, '平湖市', 211, 0),
(1355, '桐乡市', 211, 0),
(1356, '吴兴区', 212, 0),
(1357, '南浔区', 212, 0),
(1358, '德清县', 212, 0),
(1359, '长兴县', 212, 0),
(1360, '安吉县', 212, 0),
(1361, '越城区', 213, 0),
(1362, '绍兴县', 213, 0),
(1363, '新昌县', 213, 0),
(1364, '诸暨市', 213, 0),
(1365, '上虞市', 213, 0),
(1366, '嵊州市', 213, 0),
(1367, '婺城区', 214, 0),
(1368, '金东区', 214, 0),
(1369, '武义县', 214, 0),
(1370, '浦江县', 214, 0),
(1371, '磐安县', 214, 0),
(1372, '兰溪市', 214, 0),
(1373, '义乌市', 214, 0),
(1374, '东阳市', 214, 0),
(1375, '永康市', 214, 0),
(1376, '柯城区', 215, 0),
(1377, '衢江区', 215, 0),
(1378, '常山县', 215, 0),
(1379, '开化县', 215, 0),
(1380, '龙游县', 215, 0),
(1381, '江山市', 215, 0),
(1382, '定海区', 216, 0),
(1383, '普陀区', 216, 0),
(1384, '岱山县', 216, 0),
(1385, '嵊泗县', 216, 0),
(1386, '椒江区', 217, 0),
(1387, '黄岩区', 217, 0),
(1388, '路桥区', 217, 0),
(1389, '玉环县', 217, 0),
(1390, '三门县', 217, 0),
(1391, '天台县', 217, 0),
(1392, '仙居县', 217, 0),
(1393, '温岭市', 217, 0),
(1394, '临海市', 217, 0),
(1395, '莲都区', 218, 0),
(1396, '青田县', 218, 0),
(1397, '缙云县', 218, 0),
(1398, '遂昌县', 218, 0),
(1399, '松阳县', 218, 0),
(1400, '云和县', 218, 0),
(1401, '庆元县', 218, 0),
(1402, '景宁畲族自治县', 218, 0),
(1403, '龙泉市', 218, 0),
(1404, '瑶海区', 219, 0),
(1405, '庐阳区', 219, 0),
(1406, '蜀山区', 219, 0),
(1407, '包河区', 219, 0),
(1408, '长丰县', 219, 0),
(1409, '肥东县', 219, 0),
(1410, '肥西县', 219, 0),
(1411, '庐江县', 219, 0),
(1412, '巢湖市', 219, 0),
(1413, '镜湖区', 220, 0),
(1414, '弋江区', 220, 0),
(1415, '鸠江区', 220, 0),
(1416, '三山区', 220, 0),
(1417, '芜湖县', 220, 0),
(1418, '繁昌县', 220, 0),
(1419, '南陵县', 220, 0),
(1420, '无为县', 220, 0),
(1421, '龙子湖区', 221, 0),
(1422, '蚌山区', 221, 0),
(1423, '禹会区', 221, 0),
(1424, '淮上区', 221, 0),
(1425, '怀远县', 221, 0),
(1426, '五河县', 221, 0),
(1427, '固镇县', 221, 0),
(1428, '大通区', 222, 0),
(1429, '田家庵区', 222, 0),
(1430, '谢家集区', 222, 0),
(1431, '八公山区', 222, 0),
(1432, '潘集区', 222, 0),
(1433, '凤台县', 222, 0),
(1434, '花山区', 223, 0),
(1435, '雨山区', 223, 0),
(1436, '博望区', 223, 0),
(1437, '当涂县', 223, 0),
(1438, '含山县', 223, 0),
(1439, '和县', 223, 0),
(1440, '杜集区', 224, 0),
(1441, '相山区', 224, 0),
(1442, '烈山区', 224, 0),
(1443, '濉溪县', 224, 0),
(1444, '铜官山区', 225, 0),
(1445, '狮子山区', 225, 0),
(1446, '郊区', 225, 0),
(1447, '铜陵县', 225, 0),
(1448, '迎江区', 226, 0),
(1449, '大观区', 226, 0),
(1450, '宜秀区', 226, 0),
(1451, '怀宁县', 226, 0),
(1452, '枞阳县', 226, 0),
(1453, '潜山县', 226, 0),
(1454, '太湖县', 226, 0),
(1455, '宿松县', 226, 0),
(1456, '望江县', 226, 0),
(1457, '岳西县', 226, 0),
(1458, '桐城市', 226, 0),
(1459, '屯溪区', 227, 0),
(1460, '黄山区', 227, 0),
(1461, '徽州区', 227, 0),
(1462, '歙县', 227, 0),
(1463, '休宁县', 227, 0),
(1464, '黟县', 227, 0),
(1465, '祁门县', 227, 0),
(1466, '琅琊区', 228, 0),
(1467, '南谯区', 228, 0),
(1468, '来安县', 228, 0),
(1469, '全椒县', 228, 0),
(1470, '定远县', 228, 0),
(1471, '凤阳县', 228, 0),
(1472, '天长市', 228, 0),
(1473, '明光市', 228, 0),
(1474, '颍州区', 229, 0),
(1475, '颍东区', 229, 0),
(1476, '颍泉区', 229, 0),
(1477, '临泉县', 229, 0),
(1478, '太和县', 229, 0),
(1479, '阜南县', 229, 0),
(1480, '颍上县', 229, 0),
(1481, '界首市', 229, 0),
(1482, '埇桥区', 230, 0),
(1483, '砀山县', 230, 0),
(1484, '萧县', 230, 0),
(1485, '灵璧县', 230, 0),
(1486, '泗县', 230, 0),
(1487, '金安区', 231, 0),
(1488, '裕安区', 231, 0),
(1489, '寿县', 231, 0),
(1490, '霍邱县', 231, 0),
(1491, '舒城县', 231, 0),
(1492, '金寨县', 231, 0),
(1493, '霍山县', 231, 0),
(1494, '谯城区', 232, 0),
(1495, '涡阳县', 232, 0),
(1496, '蒙城县', 232, 0),
(1497, '利辛县', 232, 0),
(1498, '贵池区', 233, 0),
(1499, '东至县', 233, 0),
(1500, '石台县', 233, 0),
(1501, '青阳县', 233, 0),
(1502, '宣州区', 234, 0),
(1503, '郎溪县', 234, 0),
(1504, '广德县', 234, 0),
(1505, '泾县', 234, 0),
(1506, '绩溪县', 234, 0),
(1507, '旌德县', 234, 0),
(1508, '宁国市', 234, 0),
(1509, '鼓楼区', 235, 0),
(1510, '台江区', 235, 0),
(1511, '仓山区', 235, 0),
(1512, '马尾区', 235, 0),
(1513, '晋安区', 235, 0),
(1514, '闽侯县', 235, 0),
(1515, '连江县', 235, 0),
(1516, '罗源县', 235, 0),
(1517, '闽清县', 235, 0),
(1518, '永泰县', 235, 0),
(1519, '平潭县', 235, 0),
(1520, '福清市', 235, 0),
(1521, '长乐市', 235, 0),
(1522, '思明区', 236, 0),
(1523, '海沧区', 236, 0),
(1524, '湖里区', 236, 0),
(1525, '集美区', 236, 0),
(1526, '同安区', 236, 0),
(1527, '翔安区', 236, 0),
(1528, '城厢区', 237, 0),
(1529, '涵江区', 237, 0),
(1530, '荔城区', 237, 0),
(1531, '秀屿区', 237, 0),
(1532, '仙游县', 237, 0),
(1533, '梅列区', 238, 0),
(1534, '三元区', 238, 0),
(1535, '明溪县', 238, 0),
(1536, '清流县', 238, 0),
(1537, '宁化县', 238, 0),
(1538, '大田县', 238, 0),
(1539, '尤溪县', 238, 0),
(1540, '沙县', 238, 0),
(1541, '将乐县', 238, 0),
(1542, '泰宁县', 238, 0),
(1543, '建宁县', 238, 0),
(1544, '永安市', 238, 0),
(1545, '鲤城区', 239, 0),
(1546, '丰泽区', 239, 0),
(1547, '洛江区', 239, 0),
(1548, '泉港区', 239, 0),
(1549, '惠安县', 239, 0),
(1550, '安溪县', 239, 0),
(1551, '永春县', 239, 0),
(1552, '德化县', 239, 0),
(1553, '金门县', 239, 0),
(1554, '石狮市', 239, 0),
(1555, '晋江市', 239, 0),
(1556, '南安市', 239, 0),
(1557, '芗城区', 240, 0),
(1558, '龙文区', 240, 0),
(1559, '云霄县', 240, 0),
(1560, '漳浦县', 240, 0),
(1561, '诏安县', 240, 0),
(1562, '长泰县', 240, 0),
(1563, '东山县', 240, 0),
(1564, '南靖县', 240, 0),
(1565, '平和县', 240, 0),
(1566, '华安县', 240, 0),
(1567, '龙海市', 240, 0),
(1568, '延平区', 241, 0),
(1569, '顺昌县', 241, 0),
(1570, '浦城县', 241, 0),
(1571, '光泽县', 241, 0),
(1572, '松溪县', 241, 0),
(1573, '政和县', 241, 0),
(1574, '邵武市', 241, 0),
(1575, '武夷山市', 241, 0),
(1576, '建瓯市', 241, 0),
(1577, '建阳市', 241, 0),
(1578, '新罗区', 242, 0),
(1579, '长汀县', 242, 0),
(1580, '永定县', 242, 0),
(1581, '上杭县', 242, 0),
(1582, '武平县', 242, 0),
(1583, '连城县', 242, 0),
(1584, '漳平市', 242, 0),
(1585, '蕉城区', 243, 0),
(1586, '霞浦县', 243, 0),
(1587, '古田县', 243, 0),
(1588, '屏南县', 243, 0),
(1589, '寿宁县', 243, 0),
(1590, '周宁县', 243, 0),
(1591, '柘荣县', 243, 0),
(1592, '福安市', 243, 0),
(1593, '福鼎市', 243, 0),
(1594, '东湖区', 244, 0),
(1595, '西湖区', 244, 0),
(1596, '青云谱区', 244, 0),
(1597, '湾里区', 244, 0),
(1598, '青山湖区', 244, 0),
(1599, '南昌县', 244, 0),
(1600, '新建县', 244, 0),
(1601, '安义县', 244, 0),
(1602, '进贤县', 244, 0),
(1603, '昌江区', 245, 0),
(1604, '珠山区', 245, 0),
(1605, '浮梁县', 245, 0),
(1606, '乐平市', 245, 0),
(1607, '安源区', 246, 0),
(1608, '湘东区', 246, 0),
(1609, '莲花县', 246, 0),
(1610, '上栗县', 246, 0),
(1611, '芦溪县', 246, 0),
(1612, '庐山区', 247, 0),
(1613, '浔阳区', 247, 0),
(1614, '九江县', 247, 0),
(1615, '武宁县', 247, 0),
(1616, '修水县', 247, 0),
(1617, '永修县', 247, 0),
(1618, '德安县', 247, 0),
(1619, '星子县', 247, 0),
(1620, '都昌县', 247, 0),
(1621, '湖口县', 247, 0),
(1622, '彭泽县', 247, 0),
(1623, '瑞昌市', 247, 0),
(1624, '共青城市', 247, 0),
(1625, '渝水区', 248, 0),
(1626, '分宜县', 248, 0),
(1627, '月湖区', 249, 0),
(1628, '余江县', 249, 0),
(1629, '贵溪市', 249, 0),
(1630, '章贡区', 250, 0),
(1631, '赣县', 250, 0),
(1632, '信丰县', 250, 0),
(1633, '大余县', 250, 0),
(1634, '上犹县', 250, 0),
(1635, '崇义县', 250, 0),
(1636, '安远县', 250, 0),
(1637, '龙南县', 250, 0),
(1638, '定南县', 250, 0),
(1639, '全南县', 250, 0),
(1640, '宁都县', 250, 0),
(1641, '于都县', 250, 0),
(1642, '兴国县', 250, 0),
(1643, '会昌县', 250, 0),
(1644, '寻乌县', 250, 0),
(1645, '石城县', 250, 0),
(1646, '瑞金市', 250, 0),
(1647, '南康市', 250, 0),
(1648, '吉州区', 251, 0),
(1649, '青原区', 251, 0),
(1650, '吉安县', 251, 0),
(1651, '吉水县', 251, 0),
(1652, '峡江县', 251, 0),
(1653, '新干县', 251, 0),
(1654, '永丰县', 251, 0),
(1655, '泰和县', 251, 0),
(1656, '遂川县', 251, 0),
(1657, '万安县', 251, 0),
(1658, '安福县', 251, 0),
(1659, '永新县', 251, 0),
(1660, '井冈山市', 251, 0),
(1661, '袁州区', 252, 0),
(1662, '奉新县', 252, 0),
(1663, '万载县', 252, 0),
(1664, '上高县', 252, 0),
(1665, '宜丰县', 252, 0),
(1666, '靖安县', 252, 0),
(1667, '铜鼓县', 252, 0),
(1668, '丰城市', 252, 0),
(1669, '樟树市', 252, 0),
(1670, '高安市', 252, 0),
(1671, '临川区', 253, 0),
(1672, '南城县', 253, 0),
(1673, '黎川县', 253, 0),
(1674, '南丰县', 253, 0),
(1675, '崇仁县', 253, 0),
(1676, '乐安县', 253, 0),
(1677, '宜黄县', 253, 0),
(1678, '金溪县', 253, 0),
(1679, '资溪县', 253, 0),
(1680, '东乡县', 253, 0),
(1681, '广昌县', 253, 0),
(1682, '信州区', 254, 0),
(1683, '上饶县', 254, 0),
(1684, '广丰县', 254, 0),
(1685, '玉山县', 254, 0),
(1686, '铅山县', 254, 0),
(1687, '横峰县', 254, 0),
(1688, '弋阳县', 254, 0),
(1689, '余干县', 254, 0),
(1690, '鄱阳县', 254, 0),
(1691, '万年县', 254, 0),
(1692, '婺源县', 254, 0),
(1693, '德兴市', 254, 0),
(1694, '历下区', 255, 0),
(1695, '市中区', 255, 0),
(1696, '槐荫区', 255, 0),
(1697, '天桥区', 255, 0),
(1698, '历城区', 255, 0),
(1699, '长清区', 255, 0),
(1700, '平阴县', 255, 0),
(1701, '济阳县', 255, 0),
(1702, '商河县', 255, 0),
(1703, '章丘市', 255, 0),
(1704, '市南区', 256, 0),
(1705, '市北区', 256, 0),
(1706, '黄岛区', 256, 0),
(1707, '崂山区', 256, 0),
(1708, '李沧区', 256, 0),
(1709, '城阳区', 256, 0),
(1710, '胶州市', 256, 0),
(1711, '即墨市', 256, 0),
(1712, '平度市', 256, 0),
(1713, '莱西市', 256, 0),
(1714, '淄川区', 257, 0),
(1715, '张店区', 257, 0),
(1716, '博山区', 257, 0),
(1717, '临淄区', 257, 0),
(1718, '周村区', 257, 0),
(1719, '桓台县', 257, 0),
(1720, '高青县', 257, 0),
(1721, '沂源县', 257, 0),
(1722, '市中区', 258, 0),
(1723, '薛城区', 258, 0),
(1724, '峄城区', 258, 0),
(1725, '台儿庄区', 258, 0),
(1726, '山亭区', 258, 0),
(1727, '滕州市', 258, 0),
(1728, '东营区', 259, 0),
(1729, '河口区', 259, 0),
(1730, '垦利县', 259, 0),
(1731, '利津县', 259, 0),
(1732, '广饶县', 259, 0),
(1733, '芝罘区', 260, 0),
(1734, '福山区', 260, 0),
(1735, '牟平区', 260, 0),
(1736, '莱山区', 260, 0),
(1737, '长岛县', 260, 0),
(1738, '龙口市', 260, 0),
(1739, '莱阳市', 260, 0),
(1740, '莱州市', 260, 0),
(1741, '蓬莱市', 260, 0),
(1742, '招远市', 260, 0),
(1743, '栖霞市', 260, 0),
(1744, '海阳市', 260, 0),
(1745, '潍城区', 261, 0),
(1746, '寒亭区', 261, 0),
(1747, '坊子区', 261, 0),
(1748, '奎文区', 261, 0),
(1749, '临朐县', 261, 0),
(1750, '昌乐县', 261, 0),
(1751, '青州市', 261, 0),
(1752, '诸城市', 261, 0),
(1753, '寿光市', 261, 0),
(1754, '安丘市', 261, 0),
(1755, '高密市', 261, 0),
(1756, '昌邑市', 261, 0),
(1757, '市中区', 262, 0),
(1758, '任城区', 262, 0),
(1759, '微山县', 262, 0),
(1760, '鱼台县', 262, 0),
(1761, '金乡县', 262, 0),
(1762, '嘉祥县', 262, 0),
(1763, '汶上县', 262, 0),
(1764, '泗水县', 262, 0),
(1765, '梁山县', 262, 0),
(1766, '曲阜市', 262, 0),
(1767, '兖州市', 262, 0),
(1768, '邹城市', 262, 0),
(1769, '泰山区', 263, 0),
(1770, '岱岳区', 263, 0),
(1771, '宁阳县', 263, 0),
(1772, '东平县', 263, 0),
(1773, '新泰市', 263, 0),
(1774, '肥城市', 263, 0),
(1775, '环翠区', 264, 0),
(1776, '文登市', 264, 0),
(1777, '荣成市', 264, 0),
(1778, '乳山市', 264, 0),
(1779, '东港区', 265, 0),
(1780, '岚山区', 265, 0),
(1781, '五莲县', 265, 0),
(1782, '莒县', 265, 0),
(1783, '莱城区', 266, 0),
(1784, '钢城区', 266, 0),
(1785, '兰山区', 267, 0),
(1786, '罗庄区', 267, 0),
(1787, '河东区', 267, 0),
(1788, '沂南县', 267, 0),
(1789, '郯城县', 267, 0),
(1790, '沂水县', 267, 0),
(1791, '苍山县', 267, 0),
(1792, '费县', 267, 0),
(1793, '平邑县', 267, 0),
(1794, '莒南县', 267, 0),
(1795, '蒙阴县', 267, 0),
(1796, '临沭县', 267, 0),
(1797, '德城区', 268, 0),
(1798, '陵县', 268, 0),
(1799, '宁津县', 268, 0),
(1800, '庆云县', 268, 0),
(1801, '临邑县', 268, 0),
(1802, '齐河县', 268, 0),
(1803, '平原县', 268, 0),
(1804, '夏津县', 268, 0),
(1805, '武城县', 268, 0),
(1806, '乐陵市', 268, 0),
(1807, '禹城市', 268, 0),
(1808, '东昌府区', 269, 0),
(1809, '阳谷县', 269, 0),
(1810, '莘县', 269, 0),
(1811, '茌平县', 269, 0),
(1812, '东阿县', 269, 0),
(1813, '冠县', 269, 0),
(1814, '高唐县', 269, 0),
(1815, '临清市', 269, 0),
(1816, '滨城区', 270, 0),
(1817, '惠民县', 270, 0),
(1818, '阳信县', 270, 0),
(1819, '无棣县', 270, 0),
(1820, '沾化县', 270, 0),
(1821, '博兴县', 270, 0),
(1822, '邹平县', 270, 0),
(1823, '牡丹区', 271, 0),
(1824, '曹县', 271, 0),
(1825, '单县', 271, 0),
(1826, '成武县', 271, 0),
(1827, '巨野县', 271, 0),
(1828, '郓城县', 271, 0),
(1829, '鄄城县', 271, 0),
(1830, '定陶县', 271, 0),
(1831, '东明县', 271, 0),
(1832, '中原区', 272, 0),
(1833, '二七区', 272, 0),
(1834, '管城回族区', 272, 0),
(1835, '金水区', 272, 0),
(1836, '上街区', 272, 0),
(1837, '惠济区', 272, 0),
(1838, '中牟县', 272, 0),
(1839, '巩义市', 272, 0),
(1840, '荥阳市', 272, 0),
(1841, '新密市', 272, 0),
(1842, '新郑市', 272, 0),
(1843, '登封市', 272, 0),
(1844, '龙亭区', 273, 0),
(1845, '顺河回族区', 273, 0),
(1846, '鼓楼区', 273, 0),
(1847, '禹王台区', 273, 0),
(1848, '金明区', 273, 0),
(1849, '杞县', 273, 0),
(1850, '通许县', 273, 0),
(1851, '尉氏县', 273, 0),
(1852, '开封县', 273, 0),
(1853, '兰考县', 273, 0),
(1854, '老城区', 274, 0),
(1855, '西工区', 274, 0),
(1856, '廛河回族区', 274, 0),
(1857, '涧西区', 274, 0),
(1858, '吉利区', 274, 0),
(1859, '洛龙区', 274, 0),
(1860, '孟津县', 274, 0),
(1861, '新安县', 274, 0),
(1862, '栾川县', 274, 0),
(1863, '嵩县', 274, 0),
(1864, '汝阳县', 274, 0),
(1865, '宜阳县', 274, 0);
INSERT INTO `bc_linkages` (`id`, `name`, `parent_id`, `has_child`) VALUES
(1866, '洛宁县', 274, 0),
(1867, '伊川县', 274, 0),
(1868, '偃师市', 274, 0),
(1869, '新华区', 275, 0),
(1870, '卫东区', 275, 0),
(1871, '石龙区', 275, 0),
(1872, '湛河区', 275, 0),
(1873, '宝丰县', 275, 0),
(1874, '叶县', 275, 0),
(1875, '鲁山县', 275, 0),
(1876, '郏县', 275, 0),
(1877, '舞钢市', 275, 0),
(1878, '汝州市', 275, 0),
(1879, '文峰区', 276, 0),
(1880, '北关区', 276, 0),
(1881, '殷都区', 276, 0),
(1882, '龙安区', 276, 0),
(1883, '安阳县', 276, 0),
(1884, '汤阴县', 276, 0),
(1885, '滑县', 276, 0),
(1886, '内黄县', 276, 0),
(1887, '林州市', 276, 0),
(1888, '鹤山区', 277, 0),
(1889, '山城区', 277, 0),
(1890, '淇滨区', 277, 0),
(1891, '浚县', 277, 0),
(1892, '淇县', 277, 0),
(1893, '红旗区', 278, 0),
(1894, '卫滨区', 278, 0),
(1895, '凤泉区', 278, 0),
(1896, '牧野区', 278, 0),
(1897, '新乡县', 278, 0),
(1898, '获嘉县', 278, 0),
(1899, '原阳县', 278, 0),
(1900, '延津县', 278, 0),
(1901, '封丘县', 278, 0),
(1902, '长垣县', 278, 0),
(1903, '卫辉市', 278, 0),
(1904, '辉县市', 278, 0),
(1905, '解放区', 279, 0),
(1906, '中站区', 279, 0),
(1907, '马村区', 279, 0),
(1908, '山阳区', 279, 0),
(1909, '修武县', 279, 0),
(1910, '博爱县', 279, 0),
(1911, '武陟县', 279, 0),
(1912, '温县', 279, 0),
(1913, '济源市', 279, 0),
(1914, '沁阳市', 279, 0),
(1915, '孟州市', 279, 0),
(1916, '华龙区', 280, 0),
(1917, '清丰县', 280, 0),
(1918, '南乐县', 280, 0),
(1919, '范县', 280, 0),
(1920, '台前县', 280, 0),
(1921, '濮阳县', 280, 0),
(1922, '魏都区', 281, 0),
(1923, '许昌县', 281, 0),
(1924, '鄢陵县', 281, 0),
(1925, '襄城县', 281, 0),
(1926, '禹州市', 281, 0),
(1927, '长葛市', 281, 0),
(1928, '源汇区', 282, 0),
(1929, '郾城区', 282, 0),
(1930, '召陵区', 282, 0),
(1931, '舞阳县', 282, 0),
(1932, '临颍县', 282, 0),
(1933, '湖滨区', 283, 0),
(1934, '渑池县', 283, 0),
(1935, '陕县', 283, 0),
(1936, '卢氏县', 283, 0),
(1937, '义马市', 283, 0),
(1938, '灵宝市', 283, 0),
(1939, '宛城区', 284, 0),
(1940, '卧龙区', 284, 0),
(1941, '南召县', 284, 0),
(1942, '方城县', 284, 0),
(1943, '西峡县', 284, 0),
(1944, '镇平县', 284, 0),
(1945, '内乡县', 284, 0),
(1946, '淅川县', 284, 0),
(1947, '社旗县', 284, 0),
(1948, '唐河县', 284, 0),
(1949, '新野县', 284, 0),
(1950, '桐柏县', 284, 0),
(1951, '邓州市', 284, 0),
(1952, '梁园区', 285, 0),
(1953, '睢阳区', 285, 0),
(1954, '民权县', 285, 0),
(1955, '睢县', 285, 0),
(1956, '宁陵县', 285, 0),
(1957, '柘城县', 285, 0),
(1958, '虞城县', 285, 0),
(1959, '夏邑县', 285, 0),
(1960, '永城市', 285, 0),
(1961, '浉河区', 286, 0),
(1962, '平桥区', 286, 0),
(1963, '罗山县', 286, 0),
(1964, '光山县', 286, 0),
(1965, '新县', 286, 0),
(1966, '商城县', 286, 0),
(1967, '固始县', 286, 0),
(1968, '潢川县', 286, 0),
(1969, '淮滨县', 286, 0),
(1970, '息县', 286, 0),
(1971, '川汇区', 287, 0),
(1972, '扶沟县', 287, 0),
(1973, '西华县', 287, 0),
(1974, '商水县', 287, 0),
(1975, '沈丘县', 287, 0),
(1976, '郸城县', 287, 0),
(1977, '淮阳县', 287, 0),
(1978, '太康县', 287, 0),
(1979, '鹿邑县', 287, 0),
(1980, '项城市', 287, 0),
(1981, '驿城区', 288, 0),
(1982, '西平县', 288, 0),
(1983, '上蔡县', 288, 0),
(1984, '平舆县', 288, 0),
(1985, '正阳县', 288, 0),
(1986, '确山县', 288, 0),
(1987, '泌阳县', 288, 0),
(1988, '汝南县', 288, 0),
(1989, '遂平县', 288, 0),
(1990, '新蔡县', 288, 0),
(1991, '江岸区', 289, 0),
(1992, '江汉区', 289, 0),
(1993, '硚口区', 289, 0),
(1994, '汉阳区', 289, 0),
(1995, '武昌区', 289, 0),
(1996, '青山区', 289, 0),
(1997, '洪山区', 289, 0),
(1998, '东西湖区', 289, 0),
(1999, '汉南区', 289, 0),
(2000, '蔡甸区', 289, 0),
(2001, '江夏区', 289, 0),
(2002, '黄陂区', 289, 0),
(2003, '新洲区', 289, 0),
(2004, '黄石港区', 290, 0),
(2005, '西塞山区', 290, 0),
(2006, '下陆区', 290, 0),
(2007, '铁山区', 290, 0),
(2008, '阳新县', 290, 0),
(2009, '大冶市', 290, 0),
(2010, '茅箭区', 291, 0),
(2011, '张湾区', 291, 0),
(2012, '郧县', 291, 0),
(2013, '郧西县', 291, 0),
(2014, '竹山县', 291, 0),
(2015, '竹溪县', 291, 0),
(2016, '房县', 291, 0),
(2017, '丹江口市', 291, 0),
(2018, '西陵区', 292, 0),
(2019, '伍家岗区', 292, 0),
(2020, '点军区', 292, 0),
(2021, '猇亭区', 292, 0),
(2022, '夷陵区', 292, 0),
(2023, '远安县', 292, 0),
(2024, '兴山县', 292, 0),
(2025, '秭归县', 292, 0),
(2026, '长阳土家族自治县', 292, 0),
(2027, '五峰土家族自治县', 292, 0),
(2028, '宜都市', 292, 0),
(2029, '当阳市', 292, 0),
(2030, '枝江市', 292, 0),
(2031, '襄城区', 293, 0),
(2032, '樊城区', 293, 0),
(2033, '襄州区', 293, 0),
(2034, '南漳县', 293, 0),
(2035, '谷城县', 293, 0),
(2036, '保康县', 293, 0),
(2037, '老河口市', 293, 0),
(2038, '枣阳市', 293, 0),
(2039, '宜城市', 293, 0),
(2040, '梁子湖区', 294, 0),
(2041, '华容区', 294, 0),
(2042, '鄂城区', 294, 0),
(2043, '东宝区', 295, 0),
(2044, '掇刀区', 295, 0),
(2045, '京山县', 295, 0),
(2046, '沙洋县', 295, 0),
(2047, '钟祥市', 295, 0),
(2048, '孝南区', 296, 0),
(2049, '孝昌县', 296, 0),
(2050, '大悟县', 296, 0),
(2051, '云梦县', 296, 0),
(2052, '应城市', 296, 0),
(2053, '安陆市', 296, 0),
(2054, '汉川市', 296, 0),
(2055, '沙市区', 297, 0),
(2056, '荆州区', 297, 0),
(2057, '公安县', 297, 0),
(2058, '监利县', 297, 0),
(2059, '江陵县', 297, 0),
(2060, '石首市', 297, 0),
(2061, '洪湖市', 297, 0),
(2062, '松滋市', 297, 0),
(2063, '黄州区', 298, 0),
(2064, '团风县', 298, 0),
(2065, '红安县', 298, 0),
(2066, '罗田县', 298, 0),
(2067, '英山县', 298, 0),
(2068, '浠水县', 298, 0),
(2069, '蕲春县', 298, 0),
(2070, '黄梅县', 298, 0),
(2071, '麻城市', 298, 0),
(2072, '武穴市', 298, 0),
(2073, '咸安区', 299, 0),
(2074, '嘉鱼县', 299, 0),
(2075, '通城县', 299, 0),
(2076, '崇阳县', 299, 0),
(2077, '通山县', 299, 0),
(2078, '赤壁市', 299, 0),
(2079, '曾都区', 300, 0),
(2080, '广水市', 300, 0),
(2081, '恩施市', 301, 0),
(2082, '利川市', 301, 0),
(2083, '建始县', 301, 0),
(2084, '巴东县', 301, 0),
(2085, '宣恩县', 301, 0),
(2086, '咸丰县', 301, 0),
(2087, '来凤县', 301, 0),
(2088, '鹤峰县', 301, 0),
(2089, '芙蓉区', 306, 0),
(2090, '天心区', 306, 0),
(2091, '岳麓区', 306, 0),
(2092, '开福区', 306, 0),
(2093, '雨花区', 306, 0),
(2094, '望城区', 306, 0),
(2095, '长沙县', 306, 0),
(2096, '宁乡县', 306, 0),
(2097, '浏阳市', 306, 0),
(2098, '荷塘区', 307, 0),
(2099, '芦淞区', 307, 0),
(2100, '石峰区', 307, 0),
(2101, '天元区', 307, 0),
(2102, '株洲县', 307, 0),
(2103, '攸县', 307, 0),
(2104, '茶陵县', 307, 0),
(2105, '炎陵县', 307, 0),
(2106, '醴陵市', 307, 0),
(2107, '雨湖区', 308, 0),
(2108, '岳塘区', 308, 0),
(2109, '湘潭县', 308, 0),
(2110, '湘乡市', 308, 0),
(2111, '韶山市', 308, 0),
(2112, '珠晖区', 309, 0),
(2113, '雁峰区', 309, 0),
(2114, '石鼓区', 309, 0),
(2115, '蒸湘区', 309, 0),
(2116, '南岳区', 309, 0),
(2117, '衡阳县', 309, 0),
(2118, '衡南县', 309, 0),
(2119, '衡山县', 309, 0),
(2120, '衡东县', 309, 0),
(2121, '祁东县', 309, 0),
(2122, '耒阳市', 309, 0),
(2123, '常宁市', 309, 0),
(2124, '双清区', 310, 0),
(2125, '大祥区', 310, 0),
(2126, '北塔区', 310, 0),
(2127, '邵东县', 310, 0),
(2128, '新邵县', 310, 0),
(2129, '邵阳县', 310, 0),
(2130, '隆回县', 310, 0),
(2131, '洞口县', 310, 0),
(2132, '绥宁县', 310, 0),
(2133, '新宁县', 310, 0),
(2134, '城步苗族自治县', 310, 0),
(2135, '武冈市', 310, 0),
(2136, '岳阳楼区', 311, 0),
(2137, '云溪区', 311, 0),
(2138, '君山区', 311, 0),
(2139, '岳阳县', 311, 0),
(2140, '华容县', 311, 0),
(2141, '湘阴县', 311, 0),
(2142, '平江县', 311, 0),
(2143, '汨罗市', 311, 0),
(2144, '临湘市', 311, 0),
(2145, '武陵区', 312, 0),
(2146, '鼎城区', 312, 0),
(2147, '安乡县', 312, 0),
(2148, '汉寿县', 312, 0),
(2149, '澧县', 312, 0),
(2150, '临澧县', 312, 0),
(2151, '桃源县', 312, 0),
(2152, '石门县', 312, 0),
(2153, '津市市', 312, 0),
(2154, '永定区', 313, 0),
(2155, '武陵源区', 313, 0),
(2156, '慈利县', 313, 0),
(2157, '桑植县', 313, 0),
(2158, '资阳区', 314, 0),
(2159, '赫山区', 314, 0),
(2160, '南县', 314, 0),
(2161, '桃江县', 314, 0),
(2162, '安化县', 314, 0),
(2163, '沅江市', 314, 0),
(2164, '北湖区', 315, 0),
(2165, '苏仙区', 315, 0),
(2166, '桂阳县', 315, 0),
(2167, '宜章县', 315, 0),
(2168, '永兴县', 315, 0),
(2169, '嘉禾县', 315, 0),
(2170, '临武县', 315, 0),
(2171, '汝城县', 315, 0),
(2172, '桂东县', 315, 0),
(2173, '安仁县', 315, 0),
(2174, '资兴市', 315, 0),
(2175, '零陵区', 316, 0),
(2176, '冷水滩区', 316, 0),
(2177, '祁阳县', 316, 0),
(2178, '东安县', 316, 0),
(2179, '双牌县', 316, 0),
(2180, '道县', 316, 0),
(2181, '江永县', 316, 0),
(2182, '宁远县', 316, 0),
(2183, '蓝山县', 316, 0),
(2184, '新田县', 316, 0),
(2185, '江华瑶族自治县', 316, 0),
(2186, '鹤城区', 317, 0),
(2187, '中方县', 317, 0),
(2188, '沅陵县', 317, 0),
(2189, '辰溪县', 317, 0),
(2190, '溆浦县', 317, 0),
(2191, '会同县', 317, 0),
(2192, '麻阳苗族自治县', 317, 0),
(2193, '新晃侗族自治县', 317, 0),
(2194, '芷江侗族自治县', 317, 0),
(2195, '靖州苗族侗族自治县', 317, 0),
(2196, '通道侗族自治县', 317, 0),
(2197, '洪江市', 317, 0),
(2198, '娄星区', 318, 0),
(2199, '双峰县', 318, 0),
(2200, '新化县', 318, 0),
(2201, '冷水江市', 318, 0),
(2202, '涟源市', 318, 0),
(2203, '吉首市', 319, 0),
(2204, '泸溪县', 319, 0),
(2205, '凤凰县', 319, 0),
(2206, '花垣县', 319, 0),
(2207, '保靖县', 319, 0),
(2208, '古丈县', 319, 0),
(2209, '永顺县', 319, 0),
(2210, '龙山县', 319, 0),
(2211, '荔湾区', 320, 0),
(2212, '越秀区', 320, 0),
(2213, '海珠区', 320, 0),
(2214, '天河区', 320, 0),
(2215, '白云区', 320, 0),
(2216, '黄埔区', 320, 0),
(2217, '番禺区', 320, 0),
(2218, '花都区', 320, 0),
(2219, '南沙区', 320, 0),
(2220, '萝岗区', 320, 0),
(2221, '增城市', 320, 0),
(2222, '从化市', 320, 0),
(2223, '武江区', 321, 0),
(2224, '浈江区', 321, 0),
(2225, '曲江区', 321, 0),
(2226, '始兴县', 321, 0),
(2227, '仁化县', 321, 0),
(2228, '翁源县', 321, 0),
(2229, '乳源瑶族自治县', 321, 0),
(2230, '新丰县', 321, 0),
(2231, '乐昌市', 321, 0),
(2232, '南雄市', 321, 0),
(2233, '罗湖区', 322, 0),
(2234, '福田区', 322, 0),
(2235, '南山区', 322, 0),
(2236, '宝安区', 322, 0),
(2237, '龙岗区', 322, 0),
(2238, '盐田区', 322, 0),
(2239, '香洲区', 323, 0),
(2240, '斗门区', 323, 0),
(2241, '金湾区', 323, 0),
(2242, '龙湖区', 324, 0),
(2243, '金平区', 324, 0),
(2244, '濠江区', 324, 0),
(2245, '潮阳区', 324, 0),
(2246, '潮南区', 324, 0),
(2247, '澄海区', 324, 0),
(2248, '南澳县', 324, 0),
(2249, '禅城区', 325, 0),
(2250, '南海区', 325, 0),
(2251, '顺德区', 325, 0),
(2252, '三水区', 325, 0),
(2253, '高明区', 325, 0),
(2254, '蓬江区', 326, 0),
(2255, '江海区', 326, 0),
(2256, '新会区', 326, 0),
(2257, '台山市', 326, 0),
(2258, '开平市', 326, 0),
(2259, '鹤山市', 326, 0),
(2260, '恩平市', 326, 0),
(2261, '赤坎区', 327, 0),
(2262, '霞山区', 327, 0),
(2263, '坡头区', 327, 0),
(2264, '麻章区', 327, 0),
(2265, '遂溪县', 327, 0),
(2266, '徐闻县', 327, 0),
(2267, '廉江市', 327, 0),
(2268, '雷州市', 327, 0),
(2269, '吴川市', 327, 0),
(2270, '茂南区', 328, 0),
(2271, '茂港区', 328, 0),
(2272, '电白县', 328, 0),
(2273, '高州市', 328, 0),
(2274, '化州市', 328, 0),
(2275, '信宜市', 328, 0),
(2276, '端州区', 329, 0),
(2277, '鼎湖区', 329, 0),
(2278, '广宁县', 329, 0),
(2279, '怀集县', 329, 0),
(2280, '封开县', 329, 0),
(2281, '德庆县', 329, 0),
(2282, '高要市', 329, 0),
(2283, '四会市', 329, 0),
(2284, '惠城区', 330, 0),
(2285, '惠阳区', 330, 0),
(2286, '博罗县', 330, 0),
(2287, '惠东县', 330, 0),
(2288, '龙门县', 330, 0),
(2289, '梅江区', 331, 0),
(2290, '梅县', 331, 0),
(2291, '大埔县', 331, 0),
(2292, '丰顺县', 331, 0),
(2293, '五华县', 331, 0),
(2294, '平远县', 331, 0),
(2295, '蕉岭县', 331, 0),
(2296, '兴宁市', 331, 0),
(2297, '城区', 332, 0),
(2298, '海丰县', 332, 0),
(2299, '陆河县', 332, 0),
(2300, '陆丰市', 332, 0),
(2301, '源城区', 333, 0),
(2302, '紫金县', 333, 0),
(2303, '龙川县', 333, 0),
(2304, '连平县', 333, 0),
(2305, '和平县', 333, 0),
(2306, '东源县', 333, 0),
(2307, '江城区', 334, 0),
(2308, '阳西县', 334, 0),
(2309, '阳东县', 334, 0),
(2310, '阳春市', 334, 0),
(2311, '清城区', 335, 0),
(2312, '清新区', 335, 0),
(2313, '佛冈县', 335, 0),
(2314, '阳山县', 335, 0),
(2315, '连山壮族瑶族自治县', 335, 0),
(2316, '连南瑶族自治县', 335, 0),
(2317, '英德市', 335, 0),
(2318, '连州市', 335, 0),
(2319, '湘桥区', 338, 0),
(2320, '潮安县', 338, 0),
(2321, '饶平县', 338, 0),
(2322, '榕城区', 339, 0),
(2323, '揭东区', 339, 0),
(2324, '揭西县', 339, 0),
(2325, '惠来县', 339, 0),
(2326, '普宁市', 339, 0),
(2327, '云城区', 340, 0),
(2328, '新兴县', 340, 0),
(2329, '郁南县', 340, 0),
(2330, '云安县', 340, 0),
(2331, '罗定市', 340, 0),
(2332, '兴宁区', 341, 0),
(2333, '青秀区', 341, 0),
(2334, '江南区', 341, 0),
(2335, '西乡塘区', 341, 0),
(2336, '良庆区', 341, 0),
(2337, '邕宁区', 341, 0),
(2338, '武鸣县', 341, 0),
(2339, '隆安县', 341, 0),
(2340, '马山县', 341, 0),
(2341, '上林县', 341, 0),
(2342, '宾阳县', 341, 0),
(2343, '横县', 341, 0),
(2344, '城中区', 342, 0),
(2345, '鱼峰区', 342, 0),
(2346, '柳南区', 342, 0),
(2347, '柳北区', 342, 0),
(2348, '柳江县', 342, 0),
(2349, '柳城县', 342, 0),
(2350, '鹿寨县', 342, 0),
(2351, '融安县', 342, 0),
(2352, '融水苗族自治县', 342, 0),
(2353, '三江侗族自治县', 342, 0),
(2354, '秀峰区', 343, 0),
(2355, '叠彩区', 343, 0),
(2356, '象山区', 343, 0),
(2357, '七星区', 343, 0),
(2358, '雁山区', 343, 0),
(2359, '临桂区', 343, 0),
(2360, '阳朔县', 343, 0),
(2361, '灵川县', 343, 0),
(2362, '全州县', 343, 0),
(2363, '兴安县', 343, 0),
(2364, '永福县', 343, 0),
(2365, '灌阳县', 343, 0),
(2366, '龙胜各族自治县', 343, 0),
(2367, '资源县', 343, 0),
(2368, '平乐县', 343, 0),
(2369, '荔蒲县', 343, 0),
(2370, '恭城瑶族自治县', 343, 0),
(2371, '万秀区', 344, 0),
(2372, '长洲区', 344, 0),
(2373, '龙圩区', 344, 0),
(2374, '苍梧县', 344, 0),
(2375, '藤县', 344, 0),
(2376, '蒙山县', 344, 0),
(2377, '岑溪市', 344, 0),
(2378, '海城区', 345, 0),
(2379, '银海区', 345, 0),
(2380, '铁山港区', 345, 0),
(2381, '合浦县', 345, 0),
(2382, '港口区', 346, 0),
(2383, '防城区', 346, 0),
(2384, '上思县', 346, 0),
(2385, '东兴市', 346, 0),
(2386, '钦南区', 347, 0),
(2387, '钦北区', 347, 0),
(2388, '灵山县', 347, 0),
(2389, '浦北县', 347, 0),
(2390, '港北区', 348, 0),
(2391, '港南区', 348, 0),
(2392, '覃塘区', 348, 0),
(2393, '平南县', 348, 0),
(2394, '桂平市', 348, 0),
(2395, '玉州区', 349, 0),
(2396, '容县', 349, 0),
(2397, '陆川县', 349, 0),
(2398, '博白县', 349, 0),
(2399, '兴业县', 349, 0),
(2400, '北流市', 349, 0),
(2401, '右江区', 350, 0),
(2402, '田阳县', 350, 0),
(2403, '田东县', 350, 0),
(2404, '平果县', 350, 0),
(2405, '德保县', 350, 0),
(2406, '靖西县', 350, 0),
(2407, '那坡县', 350, 0),
(2408, '凌云县', 350, 0),
(2409, '乐业县', 350, 0),
(2410, '田林县', 350, 0),
(2411, '西林县', 350, 0),
(2412, '隆林各族自治县', 350, 0),
(2413, '八步区', 351, 0),
(2414, '昭平县', 351, 0),
(2415, '钟山县', 351, 0),
(2416, '富川瑶族自治县', 351, 0),
(2417, '金城江区', 352, 0),
(2418, '南丹县', 352, 0),
(2419, '天峨县', 352, 0),
(2420, '凤山县', 352, 0),
(2421, '东兰县', 352, 0),
(2422, '罗城仫佬族自治县', 352, 0),
(2423, '环江毛南族自治县', 352, 0),
(2424, '巴马瑶族自治县', 352, 0),
(2425, '都安瑶族自治县', 352, 0),
(2426, '大化瑶族自治县', 352, 0),
(2427, '宜州市', 352, 0),
(2428, '兴宾区', 353, 0),
(2429, '忻城县', 353, 0),
(2430, '象州县', 353, 0),
(2431, '武宣县', 353, 0),
(2432, '金秀瑶族自治县', 353, 0),
(2433, '合山市', 353, 0),
(2434, '江洲区', 354, 0),
(2435, '扶绥县', 354, 0),
(2436, '宁明县', 354, 0),
(2437, '龙州县', 354, 0),
(2438, '大新县', 354, 0),
(2439, '天等县', 354, 0),
(2440, '凭祥市', 354, 0),
(2441, '秀英区', 355, 0),
(2442, '龙华区', 355, 0),
(2443, '琼山区', 355, 0),
(2444, '美兰区', 355, 0),
(2445, '锦江区', 374, 0),
(2446, '青羊区', 374, 0),
(2447, '金牛区', 374, 0),
(2448, '武侯区', 374, 0),
(2449, '成华区', 374, 0),
(2450, '龙泉驿区', 374, 0),
(2451, '青白江区', 374, 0),
(2452, '新都区', 374, 0),
(2453, '温江区', 374, 0),
(2454, '金堂县', 374, 0),
(2455, '双流县', 374, 0),
(2456, '郫县', 374, 0),
(2457, '大邑县', 374, 0),
(2458, '蒲江县', 374, 0),
(2459, '新津县', 374, 0),
(2460, '都江堰市', 374, 0),
(2461, '彭州市', 374, 0),
(2462, '邛崃市', 374, 0),
(2463, '崇州市', 374, 0),
(2464, '自流井区', 375, 0),
(2465, '贡井区', 375, 0),
(2466, '大安区', 375, 0),
(2467, '沿滩区', 375, 0),
(2468, '荣县', 375, 0),
(2469, '富顺县', 375, 0),
(2470, '东区', 376, 0),
(2471, '西区', 376, 0),
(2472, '仁和区', 376, 0),
(2473, '米易县', 376, 0),
(2474, '盐边县', 376, 0),
(2475, '江阳区', 377, 0),
(2476, '纳溪区', 377, 0),
(2477, '龙马潭区', 377, 0),
(2478, '泸县', 377, 0),
(2479, '合江县', 377, 0),
(2480, '叙永县', 377, 0),
(2481, '古蔺县', 377, 0),
(2482, '旌阳区', 378, 0),
(2483, '中江县', 378, 0),
(2484, '罗江县', 378, 0),
(2485, '广汉市', 378, 0),
(2486, '什邡市', 378, 0),
(2487, '绵竹市', 378, 0),
(2488, '涪城区', 379, 0),
(2489, '游仙区', 379, 0),
(2490, '三台县', 379, 0),
(2491, '盐亭县', 379, 0),
(2492, '安县', 379, 0),
(2493, '梓潼县', 379, 0),
(2494, '北川羌族自治县', 379, 0),
(2495, '平武县', 379, 0),
(2496, '江油市', 379, 0),
(2497, '利州区', 380, 0),
(2498, '昭化区', 380, 0),
(2499, '朝天区', 380, 0),
(2500, '旺苍县', 380, 0),
(2501, '青川县', 380, 0),
(2502, '剑阁县', 380, 0),
(2503, '苍溪县', 380, 0),
(2504, '船山区', 381, 0),
(2505, '安居区', 381, 0),
(2506, '蓬溪县', 381, 0),
(2507, '射洪县', 381, 0),
(2508, '大英县', 381, 0),
(2509, '市中区', 382, 0),
(2510, '东兴区', 382, 0),
(2511, '威远县', 382, 0),
(2512, '资中县', 382, 0),
(2513, '隆昌县', 382, 0),
(2514, '市中区', 383, 0),
(2515, '沙湾区', 383, 0),
(2516, '五通桥区', 383, 0),
(2517, '金口河区', 383, 0),
(2518, '犍为县', 383, 0),
(2519, '井研县', 383, 0),
(2520, '夹江县', 383, 0),
(2521, '沐川县', 383, 0),
(2522, '峨边彝族自治县', 383, 0),
(2523, '马边彝族自治县', 383, 0),
(2524, '峨眉山市', 383, 0),
(2525, '顺庆区', 384, 0),
(2526, '高坪区', 384, 0),
(2527, '嘉陵区', 384, 0),
(2528, '南部县', 384, 0),
(2529, '营山县', 384, 0),
(2530, '蓬安县', 384, 0),
(2531, '仪陇县', 384, 0),
(2532, '西充县', 384, 0),
(2533, '阆中市', 384, 0),
(2534, '东坡区', 385, 0),
(2535, '仁寿县', 385, 0),
(2536, '彭山县', 385, 0),
(2537, '洪雅县', 385, 0),
(2538, '丹棱县', 385, 0),
(2539, '青神县', 385, 0),
(2540, '翠屏区', 386, 0),
(2541, '南溪区', 386, 0),
(2542, '宜宾县', 386, 0),
(2543, '江安县', 386, 0),
(2544, '长宁县', 386, 0),
(2545, '高县', 386, 0),
(2546, '珙县', 386, 0),
(2547, '筠连县', 386, 0),
(2548, '兴文县', 386, 0),
(2549, '屏山县', 386, 0),
(2550, '广安区', 387, 0),
(2551, '前锋区', 387, 0),
(2552, '岳池县', 387, 0),
(2553, '武胜县', 387, 0),
(2554, '邻水县', 387, 0),
(2555, '华蓥市', 387, 0),
(2556, '通川区', 388, 0),
(2557, '达川区', 388, 0),
(2558, '宣汉县', 388, 0),
(2559, '开江县', 388, 0),
(2560, '大竹县', 388, 0),
(2561, '渠县', 388, 0),
(2562, '万源市', 388, 0),
(2563, '雨城区', 389, 0),
(2564, '名山区', 389, 0),
(2565, '荥经县', 389, 0),
(2566, '汉源县', 389, 0),
(2567, '石棉县', 389, 0),
(2568, '天全县', 389, 0),
(2569, '芦山县', 389, 0),
(2570, '宝兴县', 389, 0),
(2571, '巴州区', 390, 0),
(2572, '恩阳区', 390, 0),
(2573, '平昌县', 390, 0),
(2574, '南江县', 390, 0),
(2575, '通江县', 390, 0),
(2576, '雁江区', 391, 0),
(2577, '安岳县', 391, 0),
(2578, '乐至县', 391, 0),
(2579, '简阳市', 391, 0),
(2580, '汶川县', 392, 0),
(2581, '理县', 392, 0),
(2582, '茂县', 392, 0),
(2583, '松潘县', 392, 0),
(2584, '九寨沟县', 392, 0),
(2585, '金川县', 392, 0),
(2586, '小金县', 392, 0),
(2587, '黑水县', 392, 0),
(2588, '马尔康县', 392, 0),
(2589, '壤塘县', 392, 0),
(2590, '阿坝县', 392, 0),
(2591, '若尔盖县', 392, 0),
(2592, '红原县', 392, 0),
(2593, '康定县', 393, 0),
(2594, '泸定县', 393, 0),
(2595, '丹巴县', 393, 0),
(2596, '九龙县', 393, 0),
(2597, '雅江县', 393, 0),
(2598, '道孚县', 393, 0),
(2599, '炉霍县', 393, 0),
(2600, '甘孜县', 393, 0),
(2601, '新龙县', 393, 0),
(2602, '德格县', 393, 0),
(2603, '白玉县', 393, 0),
(2604, '石渠县', 393, 0),
(2605, '色达县', 393, 0),
(2606, '理塘县', 393, 0),
(2607, '巴塘县', 393, 0),
(2608, '乡城县', 393, 0),
(2609, '稻城县', 393, 0),
(2610, '得荣县', 393, 0),
(2611, '西昌市', 394, 0),
(2612, '木里藏族自治县', 394, 0),
(2613, '盐源县', 394, 0),
(2614, '德昌县', 394, 0),
(2615, '会理县', 394, 0),
(2616, '会东县', 394, 0),
(2617, '宁南县', 394, 0),
(2618, '普格县', 394, 0),
(2619, '布拖县', 394, 0),
(2620, '金阳县', 394, 0),
(2621, '昭觉县', 394, 0),
(2622, '喜德县', 394, 0),
(2623, '冕宁县', 394, 0),
(2624, '越西县', 394, 0),
(2625, '甘洛县', 394, 0),
(2626, '美姑县', 394, 0),
(2627, '雷波县', 394, 0),
(2628, '南明区', 395, 0),
(2629, '云岩区', 395, 0),
(2630, '观山湖区', 395, 0),
(2631, '花溪区', 395, 0),
(2632, '乌当区', 395, 0),
(2633, '白云区', 395, 0),
(2634, '开阳县', 395, 0),
(2635, '息烽县', 395, 0),
(2636, '修文县', 395, 0),
(2637, '清镇市', 395, 0),
(2638, '钟山区', 396, 0),
(2639, '六枝特区', 396, 0),
(2640, '水城县', 396, 0),
(2641, '盘县', 396, 0),
(2642, '红花岗区', 397, 0),
(2643, '汇川区', 397, 0),
(2644, '遵义县', 397, 0),
(2645, '桐梓县', 397, 0),
(2646, '绥阳县', 397, 0),
(2647, '正安县', 397, 0),
(2648, '道真仡佬族苗族自治县', 397, 0),
(2649, '务川仡佬族苗族自治县', 397, 0),
(2650, '凤冈县', 397, 0),
(2651, '湄潭县', 397, 0),
(2652, '余庆县', 397, 0),
(2653, '习水县', 397, 0),
(2654, '赤水市', 397, 0),
(2655, '仁怀市', 397, 0),
(2656, '西秀区', 398, 0),
(2657, '平坝县', 398, 0),
(2658, '普定县', 398, 0),
(2659, '镇宁布依族苗族自治县', 398, 0),
(2660, '关岭布依族苗族自治县', 398, 0),
(2661, '紫云苗族布依族自治县', 398, 0),
(2662, '碧江区', 399, 0),
(2663, '万山区', 399, 0),
(2664, '江口县', 399, 0),
(2665, '玉屏侗族自治县', 399, 0),
(2666, '石阡县', 399, 0),
(2667, '思南县', 399, 0),
(2668, '印江土家族苗族自治县', 399, 0),
(2669, '德江县', 399, 0),
(2670, '沿河土家族自治县', 399, 0),
(2671, '松桃苗族自治县', 399, 0),
(2672, '兴义市', 400, 0),
(2673, '兴仁县', 400, 0),
(2674, '普安县', 400, 0),
(2675, '晴隆县', 400, 0),
(2676, '贞丰县', 400, 0),
(2677, '望谟县', 400, 0),
(2678, '册亨县', 400, 0),
(2679, '安龙县', 400, 0),
(2680, '七星关区', 401, 0),
(2681, '大方县', 401, 0),
(2682, '黔西县', 401, 0),
(2683, '金沙县', 401, 0),
(2684, '织金县', 401, 0),
(2685, '纳雍县', 401, 0),
(2686, '威宁彝族回族苗族自治县', 401, 0),
(2687, '赫章县', 401, 0),
(2688, '凯里市', 402, 0),
(2689, '黄平县', 402, 0),
(2690, '施秉县', 402, 0),
(2691, '三穗县', 402, 0),
(2692, '镇远县', 402, 0),
(2693, '岑巩县', 402, 0),
(2694, '天柱县', 402, 0),
(2695, '锦屏县', 402, 0),
(2696, '剑河县', 402, 0),
(2697, '台江县', 402, 0),
(2698, '黎平县', 402, 0),
(2699, '榕江县', 402, 0),
(2700, '从江县', 402, 0),
(2701, '雷山县', 402, 0),
(2702, '麻江县', 402, 0),
(2703, '丹寨县', 402, 0),
(2704, '都匀市', 403, 0),
(2705, '福泉市', 403, 0),
(2706, '荔波县', 403, 0),
(2707, '贵定县', 403, 0),
(2708, '瓮安县', 403, 0),
(2709, '独山县', 403, 0),
(2710, '平塘县', 403, 0),
(2711, '罗甸县', 403, 0),
(2712, '长顺县', 403, 0),
(2713, '龙里县', 403, 0),
(2714, '惠水县', 403, 0),
(2715, '三都水族自治县', 403, 0),
(2716, '五华区', 404, 0),
(2717, '盘龙区', 404, 0),
(2718, '官渡区', 404, 0),
(2719, '西山区', 404, 0),
(2720, '东川区', 404, 0),
(2721, '呈贡区', 404, 0),
(2722, '晋宁县', 404, 0),
(2723, '富民县', 404, 0),
(2724, '宜良县', 404, 0),
(2725, '石林彝族自治县', 404, 0),
(2726, '嵩明县', 404, 0),
(2727, '禄劝彝族苗族自治县', 404, 0),
(2728, '寻甸回族彝族自治县', 404, 0),
(2729, '安宁市', 404, 0),
(2730, '麒麟区', 405, 0),
(2731, '马龙县', 405, 0),
(2732, '陆良县', 405, 0),
(2733, '师宗县', 405, 0),
(2734, '罗平县', 405, 0),
(2735, '富源县', 405, 0),
(2736, '会泽县', 405, 0),
(2737, '沾益县', 405, 0),
(2738, '宣威市', 405, 0),
(2739, '红塔区', 406, 0),
(2740, '江川县', 406, 0),
(2741, '澄江县', 406, 0),
(2742, '通海县', 406, 0),
(2743, '华宁县', 406, 0),
(2744, '易门县', 406, 0),
(2745, '峨山彝族自治县', 406, 0),
(2746, '新平彝族傣族自治县', 406, 0),
(2747, '元江哈尼族彝族傣族自治县', 406, 0),
(2748, '隆阳区', 407, 0),
(2749, '施甸县', 407, 0),
(2750, '腾冲县', 407, 0),
(2751, '龙陵县', 407, 0),
(2752, '昌宁县', 407, 0),
(2753, '昭阳区', 408, 0),
(2754, '鲁甸县', 408, 0),
(2755, '巧家县', 408, 0),
(2756, '盐津县', 408, 0),
(2757, '大关县', 408, 0),
(2758, '永善县', 408, 0),
(2759, '绥江县', 408, 0),
(2760, '镇雄县', 408, 0),
(2761, '彝良县', 408, 0),
(2762, '威信县', 408, 0),
(2763, '水富县', 408, 0),
(2764, '古城区', 409, 0),
(2765, '玉龙纳西族自治县', 409, 0),
(2766, '永胜县', 409, 0),
(2767, '华坪县', 409, 0),
(2768, '宁蒗彝族自治县', 409, 0),
(2769, '翠云区', 410, 0),
(2770, '普洱哈尼族彝族自治县', 410, 0),
(2771, '墨江哈尼族自治县', 410, 0),
(2772, '景东彝族自治县', 410, 0),
(2773, '景谷傣族彝族自治县', 410, 0),
(2774, '镇沅彝族哈尼族拉祜族自治县', 410, 0),
(2775, '江城哈尼族彝族自治县', 410, 0),
(2776, '孟连傣族拉祜族佤族自治县', 410, 0),
(2777, '澜沧拉祜族自治县', 410, 0),
(2778, '西盟佤族自治县', 410, 0),
(2779, '临翔区', 411, 0),
(2780, '凤庆县', 411, 0),
(2781, '云县', 411, 0),
(2782, '永德县', 411, 0),
(2783, '镇康县', 411, 0),
(2784, '双江拉祜族佤族布朗族傣族自治县', 411, 0),
(2785, '耿马傣族佤族自治县', 411, 0),
(2786, '沧源佤族自治县', 412, 0),
(2787, '楚雄市', 412, 0),
(2788, '双柏县', 412, 0),
(2789, '牟定县', 412, 0),
(2790, '南华县', 412, 0),
(2791, '姚安县', 412, 0),
(2792, '大姚县', 412, 0),
(2793, '永仁县', 412, 0),
(2794, '元谋县', 412, 0),
(2795, '武定县', 412, 0),
(2796, '禄丰县', 412, 0),
(2797, '蒙自市', 413, 0),
(2798, '个旧市', 413, 0),
(2799, '开远市', 413, 0),
(2800, '弥勒市', 413, 0),
(2801, '屏边苗族自治县', 413, 0),
(2802, '建水县', 413, 0),
(2803, '石屏县', 413, 0),
(2804, '泸西县', 413, 0),
(2805, '元阳县', 413, 0),
(2806, '红河县', 413, 0),
(2807, '金平苗族瑶族傣族自治县', 413, 0),
(2808, '绿春县', 413, 0),
(2809, '河口瑶族自治县', 413, 0),
(2810, '文山市', 414, 0),
(2811, '砚山县', 414, 0),
(2812, '西畴县', 414, 0),
(2813, '麻栗坡县', 414, 0),
(2814, '马关县', 414, 0),
(2815, '丘北县', 414, 0),
(2816, '广南县', 414, 0),
(2817, '富宁县', 414, 0),
(2818, '景洪市', 415, 0),
(2819, '勐海县', 415, 0),
(2820, '勐腊县', 415, 0),
(2821, '大理市', 416, 0),
(2822, '漾濞彝族自治县', 416, 0),
(2823, '祥云县', 416, 0),
(2824, '宾川县', 416, 0),
(2825, '弥渡县', 416, 0),
(2826, '南涧彝族自治县', 416, 0),
(2827, '巍山彝族回族自治县', 416, 0),
(2828, '永平县', 416, 0),
(2829, '云龙县', 416, 0),
(2830, '洱源县', 416, 0),
(2831, '剑川县', 416, 0),
(2832, '鹤庆县', 416, 0),
(2833, '瑞丽市', 417, 0),
(2834, '芒市', 417, 0),
(2835, '梁河县', 417, 0),
(2836, '盈江县', 417, 0),
(2837, '陇川县', 417, 0),
(2838, '泸水县', 418, 0),
(2839, '福贡县', 418, 0),
(2840, '贡山独龙族怒族自治县', 418, 0),
(2841, '兰坪白族普米族自治县', 418, 0),
(2842, '香格里拉县', 419, 0),
(2843, '德钦县', 419, 0),
(2844, '维西傈僳族自治县', 419, 0),
(2845, '城关区', 420, 0),
(2846, '林周县', 420, 0),
(2847, '当雄县', 420, 0),
(2848, '尼木县', 420, 0),
(2849, '曲水县', 420, 0),
(2850, '堆龙德庆县', 420, 0),
(2851, '达孜县', 420, 0),
(2852, '墨竹工卡县', 420, 0),
(2853, '昌都县', 421, 0),
(2854, '江达县', 421, 0),
(2855, '贡觉县', 421, 0),
(2856, '类乌齐县', 421, 0),
(2857, '丁青县', 421, 0),
(2858, '察雅县', 421, 0),
(2859, '八宿县', 421, 0),
(2860, '左贡县', 421, 0),
(2861, '芒康县', 421, 0),
(2862, '洛隆县', 421, 0),
(2863, '边坝县', 421, 0),
(2864, '乃东县', 422, 0),
(2865, '扎囊县', 422, 0),
(2866, '贡嘎县', 422, 0),
(2867, '桑日县', 422, 0),
(2868, '琼结县', 422, 0),
(2869, '曲松县', 422, 0),
(2870, '措美县', 422, 0),
(2871, '洛扎县', 422, 0),
(2872, '加查县', 422, 0),
(2873, '隆子县', 422, 0),
(2874, '错那县', 422, 0),
(2875, '浪卡子县', 422, 0),
(2876, '日喀则市', 423, 0),
(2877, '南木林县', 423, 0),
(2878, '江孜县', 423, 0),
(2879, '定日县', 423, 0),
(2880, '萨迦县', 423, 0),
(2881, '拉孜县', 423, 0),
(2882, '昂仁县', 423, 0),
(2883, '谢通门县', 423, 0),
(2884, '白朗县', 423, 0),
(2885, '仁布县', 423, 0),
(2886, '康马县', 423, 0),
(2887, '定结县', 423, 0),
(2888, '仲巴县', 423, 0),
(2889, '亚东县', 423, 0),
(2890, '吉隆县', 423, 0),
(2891, '聂拉木县', 423, 0),
(2892, '萨嘎县', 423, 0),
(2893, '岗巴县', 423, 0),
(2894, '那曲县', 424, 0),
(2895, '嘉黎县', 424, 0),
(2896, '比如县', 424, 0),
(2897, '聂荣县', 424, 0),
(2898, '安多县', 424, 0),
(2899, '申扎县', 424, 0),
(2900, '索县', 424, 0),
(2901, '班戈县', 424, 0),
(2902, '巴青县', 424, 0),
(2903, '尼玛县', 424, 0),
(2904, '双湖县', 424, 0),
(2905, '普兰县', 425, 0),
(2906, '札达县', 425, 0),
(2907, '噶尔县', 425, 0),
(2908, '日土县', 425, 0),
(2909, '革吉县', 425, 0),
(2910, '改则县', 425, 0),
(2911, '措勤县', 425, 0),
(2912, '林芝县', 426, 0),
(2913, '工布江达县', 426, 0),
(2914, '米林县', 426, 0),
(2915, '墨脱县', 426, 0),
(2916, '波密县', 426, 0),
(2917, '察隅县', 426, 0),
(2918, '朗县', 426, 0),
(2919, '新城区', 427, 0),
(2920, '碑林区', 427, 0),
(2921, '莲湖区', 427, 0),
(2922, '灞桥区', 427, 0),
(2923, '未央区', 427, 0),
(2924, '雁塔区', 427, 0),
(2925, '阎良区', 427, 0),
(2926, '临潼区', 427, 0),
(2927, '长安区', 427, 0),
(2928, '蓝田县', 427, 0),
(2929, '周至县', 427, 0),
(2930, '户县', 427, 0),
(2931, '高陵县', 427, 0),
(2932, '王益区', 428, 0),
(2933, '印台区', 428, 0),
(2934, '耀州区', 428, 0),
(2935, '宜君县', 428, 0),
(2936, '渭滨区', 429, 0),
(2937, '金台区', 429, 0),
(2938, '陈仓区', 429, 0),
(2939, '凤翔县', 429, 0),
(2940, '岐山县', 429, 0),
(2941, '扶风县', 429, 0),
(2942, '眉县', 429, 0),
(2943, '陇县', 429, 0),
(2944, '千阳县', 429, 0),
(2945, '麟游县', 429, 0),
(2946, '凤县', 429, 0),
(2947, '太白县', 429, 0),
(2948, '秦都区', 430, 0),
(2949, '杨凌区', 430, 0),
(2950, '渭城区', 430, 0),
(2951, '三原县', 430, 0),
(2952, '泾阳县', 430, 0),
(2953, '乾县', 430, 0),
(2954, '礼泉县', 430, 0),
(2955, '永寿县', 430, 0),
(2956, '彬县', 430, 0),
(2957, '长武县', 430, 0),
(2958, '旬邑县', 430, 0),
(2959, '淳化县', 430, 0),
(2960, '武功县', 430, 0),
(2961, '兴平市', 430, 0),
(2962, '临渭区', 431, 0),
(2963, '华县', 431, 0),
(2964, '潼关县', 431, 0),
(2965, '大荔县', 431, 0),
(2966, '合阳县', 431, 0),
(2967, '澄城县', 431, 0),
(2968, '蒲城县', 431, 0),
(2969, '白水县', 431, 0),
(2970, '富平县', 431, 0),
(2971, '韩城市', 431, 0),
(2972, '华阴市', 431, 0),
(2973, '宝塔区', 432, 0),
(2974, '延长县', 432, 0),
(2975, '延川县', 432, 0),
(2976, '子长县', 432, 0),
(2977, '安塞县', 432, 0),
(2978, '志丹县', 432, 0),
(2979, '吴起县', 432, 0),
(2980, '甘泉县', 432, 0),
(2981, '富县', 432, 0),
(2982, '洛川县', 432, 0),
(2983, '宜川县', 432, 0),
(2984, '黄龙县', 432, 0),
(2985, '黄陵县', 432, 0),
(2986, '汉台区', 433, 0),
(2987, '南郑县', 433, 0),
(2988, '城固县', 433, 0),
(2989, '洋县', 433, 0),
(2990, '西乡县', 433, 0),
(2991, '勉县', 433, 0),
(2992, '宁强县', 433, 0),
(2993, '略阳县', 433, 0),
(2994, '镇巴县', 433, 0),
(2995, '留坝县', 433, 0),
(2996, '佛坪县', 433, 0),
(2997, '榆阳区', 434, 0),
(2998, '神木县', 434, 0),
(2999, '府谷县', 434, 0),
(3000, '横山县', 434, 0),
(3001, '靖边县', 434, 0),
(3002, '定边县', 434, 0),
(3003, '绥德县', 434, 0),
(3004, '米脂县', 434, 0),
(3005, '佳县', 434, 0),
(3006, '吴堡县', 434, 0),
(3007, '清涧县', 434, 0),
(3008, '子洲县', 434, 0),
(3009, '汉滨区', 435, 0),
(3010, '汉阴县', 435, 0),
(3011, '石泉县', 435, 0),
(3012, '宁陕县', 435, 0),
(3013, '紫阳县', 435, 0),
(3014, '岚皋县', 435, 0),
(3015, '平利县', 435, 0),
(3016, '镇坪县', 435, 0),
(3017, '旬阳县', 435, 0),
(3018, '白河县', 435, 0),
(3019, '商州区', 436, 0),
(3020, '洛南县', 436, 0),
(3021, '丹凤县', 436, 0),
(3022, '商南县', 436, 0),
(3023, '山阳县', 436, 0),
(3024, '镇安县', 436, 0),
(3025, '柞水县', 436, 0),
(3026, '城关区', 437, 0),
(3027, '七里河区', 437, 0),
(3028, '西固区', 437, 0),
(3029, '安宁区', 437, 0),
(3030, '红古区', 437, 0),
(3031, '永登县', 437, 0),
(3032, '皋兰县', 437, 0),
(3033, '榆中县', 437, 0),
(3034, '金川区', 439, 0),
(3035, '永昌县', 439, 0),
(3036, '白银区', 440, 0),
(3037, '平川区', 440, 0),
(3038, '靖远县', 440, 0),
(3039, '会宁县', 440, 0),
(3040, '景泰县', 440, 0),
(3041, '秦城区', 441, 0),
(3042, '北道区', 441, 0),
(3043, '清水县', 441, 0),
(3044, '秦安县', 441, 0),
(3045, '甘谷县', 441, 0),
(3046, '武山县', 441, 0),
(3047, '张家川回族自治县', 441, 0),
(3048, '凉州区', 442, 0),
(3049, '民勤县', 442, 0),
(3050, '古浪县', 442, 0),
(3051, '天祝藏族自治县', 442, 0),
(3052, '甘州区', 443, 0),
(3053, '肃南裕固族自治县', 443, 0),
(3054, '民乐县', 443, 0),
(3055, '临泽县', 443, 0),
(3056, '高台县', 443, 0),
(3057, '山丹县', 443, 0),
(3058, '崆峒区', 444, 0),
(3059, '泾川县', 444, 0),
(3060, '灵台县', 444, 0),
(3061, '崇信县', 444, 0),
(3062, '华亭县', 444, 0),
(3063, '庄浪县', 444, 0),
(3064, '静宁县', 444, 0),
(3065, '肃州区', 445, 0),
(3066, '金塔县', 445, 0),
(3067, '瓜州县', 445, 0),
(3068, '肃北蒙古族自治县', 445, 0),
(3069, '阿克塞哈萨克族自治县', 445, 0),
(3070, '玉门市', 445, 0),
(3071, '敦煌市', 445, 0),
(3072, '西峰区', 446, 0),
(3073, '庆城县', 446, 0),
(3074, '环县', 446, 0),
(3075, '华池县', 446, 0),
(3076, '合水县', 446, 0),
(3077, '正宁县', 446, 0),
(3078, '宁县', 446, 0),
(3079, '镇原县', 446, 0),
(3080, '安定区', 447, 0),
(3081, '通渭县', 447, 0),
(3082, '陇西县', 447, 0),
(3083, '渭源县', 447, 0),
(3084, '临洮县', 447, 0),
(3085, '漳县', 447, 0),
(3086, '岷县', 447, 0),
(3087, '武都区', 448, 0),
(3088, '成县', 448, 0),
(3089, '文县', 448, 0),
(3090, '宕昌县', 448, 0),
(3091, '康县', 448, 0),
(3092, '西和县', 448, 0),
(3093, '礼县', 448, 0),
(3094, '徽县', 448, 0),
(3095, '两当县', 448, 0),
(3096, '临夏市', 449, 0),
(3097, '临夏县', 449, 0),
(3098, '康乐县', 449, 0),
(3099, '永靖县', 449, 0),
(3100, '广河县', 449, 0),
(3101, '和政县', 449, 0),
(3102, '东乡族自治县', 449, 0),
(3103, '积石山保安族东乡族撒拉族自治县', 449, 0),
(3104, '合作市', 450, 0),
(3105, '临潭县', 450, 0),
(3106, '卓尼县', 450, 0),
(3107, '舟曲县', 450, 0),
(3108, '迭部县', 450, 0),
(3109, '玛曲县', 450, 0),
(3110, '碌曲县', 450, 0),
(3111, '夏河县', 450, 0),
(3112, '城东区', 451, 0),
(3113, '城中区', 451, 0),
(3114, '城西区', 451, 0),
(3115, '城北区', 451, 0),
(3116, '大通回族土族自治县', 451, 0),
(3117, '湟中县', 451, 0),
(3118, '湟源县', 451, 0),
(3119, '乐都区', 452, 0),
(3120, '平安县', 452, 0),
(3121, '民和回族土族自治县', 452, 0),
(3122, '互助土族自治县', 452, 0),
(3123, '化隆回族自治县', 452, 0),
(3124, '循化撒拉族自治县', 452, 0),
(3125, '门源回族自治县', 453, 0),
(3126, '祁连县', 453, 0),
(3127, '海晏县', 453, 0),
(3128, '刚察县', 453, 0),
(3129, '同仁县', 454, 0),
(3130, '尖扎县', 454, 0),
(3131, '泽库县', 454, 0),
(3132, '河南蒙古族自治县', 454, 0),
(3133, '共和县', 455, 0),
(3134, '同德县', 455, 0),
(3135, '贵德县', 455, 0),
(3136, '兴海县', 455, 0),
(3137, '贵南县', 455, 0),
(3138, '玛沁县', 456, 0),
(3139, '班玛县', 456, 0),
(3140, '甘德县', 456, 0),
(3141, '达日县', 456, 0),
(3142, '久治县', 456, 0),
(3143, '玛多县', 456, 0),
(3144, '玉树县', 457, 0),
(3145, '杂多县', 457, 0),
(3146, '称多县', 457, 0),
(3147, '治多县', 457, 0),
(3148, '囊谦县', 457, 0),
(3149, '曲麻莱县', 457, 0),
(3150, '格尔木市', 458, 0),
(3151, '德令哈市', 458, 0),
(3152, '乌兰县', 458, 0),
(3153, '都兰县', 458, 0),
(3154, '天峻县', 458, 0),
(3155, '兴庆区', 459, 0),
(3156, '西夏区', 459, 0),
(3157, '金凤区', 459, 0),
(3158, '永宁县', 459, 0),
(3159, '贺兰县', 459, 0),
(3160, '灵武市', 459, 0),
(3161, '大武口区', 460, 0),
(3162, '惠农区', 460, 0),
(3163, '平罗县', 460, 0),
(3164, '利通区', 461, 0),
(3165, '盐池县', 461, 0),
(3166, '同心县', 461, 0),
(3167, '青铜峡市', 461, 0),
(3168, '原州区', 462, 0),
(3169, '西吉县', 462, 0),
(3170, '隆德县', 462, 0),
(3171, '泾源县', 462, 0),
(3172, '彭阳县', 462, 0),
(3173, '沙坡头区', 463, 0),
(3174, '中宁县', 463, 0),
(3175, '海原县', 463, 0),
(3176, '天山区', 464, 0),
(3177, '沙依巴克区', 464, 0),
(3178, '新市区', 464, 0),
(3179, '水磨沟区', 464, 0),
(3180, '头屯河区', 464, 0),
(3181, '达坂城区', 464, 0),
(3182, '米东区', 464, 0),
(3183, '乌鲁木齐县', 464, 0),
(3184, '独山子区', 465, 0),
(3185, '克拉玛依区', 465, 0),
(3186, '白碱滩区', 465, 0),
(3187, '乌尔禾区', 465, 0),
(3188, '高昌区', 466, 0),
(3189, '鄯善县', 466, 0),
(3190, '托克逊县', 466, 0),
(3191, '哈密市', 467, 0),
(3192, '巴里坤哈萨克自治县', 467, 0),
(3193, '伊吾县', 467, 0),
(3194, '昌吉市', 468, 0),
(3195, '阜康市', 468, 0),
(3196, '呼图壁县', 468, 0),
(3197, '玛纳斯县', 468, 0),
(3198, '奇台县', 468, 0),
(3199, '吉木萨尔县', 468, 0),
(3200, '木垒哈萨克自治县', 468, 0),
(3201, '博乐市', 469, 0),
(3202, '阿拉山口市', 469, 0),
(3203, '精河县', 469, 0),
(3204, '温泉县', 469, 0),
(3205, '库尔勒市', 470, 0),
(3206, '轮台县', 470, 0),
(3207, '尉犁县', 470, 0),
(3208, '若羌县', 470, 0),
(3209, '且末县', 470, 0),
(3210, '焉耆回族自治县', 470, 0),
(3211, '和静县', 470, 0),
(3212, '和硕县', 470, 0),
(3213, '博湖县', 470, 0),
(3214, '阿克苏市', 471, 0),
(3215, '温宿县', 471, 0),
(3216, '库车县', 471, 0),
(3217, '沙雅县', 471, 0),
(3218, '新和县', 471, 0),
(3219, '拜城县', 471, 0),
(3220, '乌什县', 471, 0),
(3221, '阿瓦提县', 471, 0),
(3222, '柯坪县', 471, 0),
(3223, '阿图什市', 472, 0),
(3224, '阿克陶县', 472, 0),
(3225, '阿合奇县', 472, 0),
(3226, '乌恰县', 472, 0),
(3227, '喀什市', 473, 0),
(3228, '疏附县', 473, 0),
(3229, '疏勒县', 473, 0),
(3230, '英吉沙县', 473, 0),
(3231, '泽普县', 473, 0),
(3232, '莎车县', 473, 0),
(3233, '叶城县', 473, 0),
(3234, '麦盖提县', 473, 0),
(3235, '岳普湖县', 473, 0),
(3236, '伽师县', 473, 0),
(3237, '巴楚县', 473, 0),
(3238, '塔什库尔干塔吉克自治县', 473, 0),
(3239, '和田市', 474, 0),
(3240, '和田县', 474, 0),
(3241, '墨玉县', 474, 0),
(3242, '皮山县', 474, 0),
(3243, '洛浦县', 474, 0),
(3244, '策勒县', 474, 0),
(3245, '于田县', 474, 0),
(3246, '民丰县', 474, 0),
(3247, '伊宁市', 475, 0),
(3248, '奎屯市', 475, 0),
(3249, '霍尔果斯市', 475, 0),
(3250, '伊宁县', 475, 0),
(3251, '察布查尔锡伯自治县', 475, 0),
(3252, '霍城县', 475, 0),
(3253, '巩留县', 475, 0),
(3254, '新源县', 475, 0),
(3255, '昭苏县', 475, 0),
(3256, '特克斯县', 475, 0),
(3257, '尼勒克县', 475, 0),
(3258, '塔城市', 476, 0),
(3259, '乌苏市', 476, 0),
(3260, '额敏县', 476, 0),
(3261, '沙湾县', 476, 0),
(3262, '托里县', 476, 0),
(3263, '裕民县', 476, 0),
(3264, '和布克赛尔蒙古自治县', 476, 0),
(3265, '阿勒泰市', 477, 0),
(3266, '布尔津县', 477, 0),
(3267, '富蕴县', 477, 0),
(3268, '福海县', 477, 0),
(3269, '哈巴河县', 477, 0),
(3270, '青河县', 477, 0),
(3271, '吉木乃县', 477, 0);

DROP TABLE IF EXISTS `bc_logs`;
CREATE TABLE `bc_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `node_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `content` varchar(255) NOT NULL,
  `ip` varchar(39) NOT NULL DEFAULT '',
  `backup` text NOT NULL,
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  `trashed` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='日志';

DROP TABLE IF EXISTS `bc_media`;
CREATE TABLE `bc_media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_name` varchar(20) NOT NULL DEFAULT '',
  `thumb_name` varchar(22) NOT NULL DEFAULT '',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `group` int(10) unsigned NOT NULL DEFAULT '0',
  `image_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `group` (`group`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='媒体';

INSERT INTO `bc_media` (`id`, `file_name`, `thumb_name`, `type`, `group`, `image_id`, `created`) VALUES
(1, '13082212000042.jpg', '13082212000042-t.jpg', 0, 1, 0, 1377144000),
(2, '13082212000091.jpg', '13082212000091-t.jpg', 0, 1, 0, 1377144001),
(3, '13082212000122.jpg', '13082212000122-t.jpg', 0, 1, 0, 1377144002),
(4, '13082212000217.jpg', '13082212000217-t.jpg', 0, 1, 0, 1377144002),
(5, '13082212000218.jpg', '13082212000218-t.jpg', 0, 1, 0, 1377144003),
(6, '13082212000315.jpg', '13082212000315-t.jpg', 0, 1, 0, 1377144004);

DROP TABLE IF EXISTS `bc_media_groups`;
CREATE TABLE `bc_media_groups` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(30) NOT NULL DEFAULT '',
  `group_name` varchar(80) NOT NULL DEFAULT '',
  `rs_width` smallint(4) unsigned NOT NULL DEFAULT '0',
  `rs_height` smallint(4) unsigned NOT NULL DEFAULT '0',
  `tn_width` smallint(4) unsigned NOT NULL DEFAULT '0',
  `tn_height` smallint(4) unsigned NOT NULL DEFAULT '0',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='媒体分组';

INSERT INTO `bc_media_groups` (`id`, `slug`, `group_name`, `rs_width`, `rs_height`, `tn_width`, `tn_height`, `created`) VALUES
(1, 'product', '产品图片', 595, 397, 150, 100, 1372316861);

DROP TABLE IF EXISTS `bc_nodes`;
CREATE TABLE `bc_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `author_id` int(10) unsigned NOT NULL DEFAULT '0',
  `slug` varchar(32) NOT NULL DEFAULT '',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `node_title` varchar(60) NOT NULL DEFAULT '',
  `node_intro` text NOT NULL,
  `node_content` mediumtext NOT NULL,
  `category` smallint(5) unsigned NOT NULL DEFAULT '0',
  `submenu` smallint(5) unsigned NOT NULL DEFAULT '0',
  `sidebar` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `commenting` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `keywords` varchar(120) NOT NULL DEFAULT '',
  `descript` varchar(250) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  `last_edited` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `slug` (`slug`),
  KEY `type` (`type`),
  KEY `category` (`category`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='节点';

INSERT INTO `bc_nodes` (`id`, `author_id`, `slug`, `type`, `node_title`, `node_intro`, `node_content`, `category`, `submenu`, `sidebar`, `commenting`, `keywords`, `descript`, `status`, `created`, `last_edited`) VALUES
(1, 1, 'homepage', 2, '欢迎', '', '<p>\n	欢迎来到 BootCMS 世界！\n</p>\n<p>\n	在167年前的今天（1949年10月17日），波兰作曲家和钢琴家<strong>弗雷德里克·弗朗索瓦·肖邦</strong>在巴黎市中心的家中去世，时年39岁。\n</p>\n<p>\n	肖邦是历史上最具影响力和最受欢迎的钢琴作曲家之一，是波兰音乐史上最重要的人物之一，是欧洲19世纪浪漫主义音乐的代表人物。\n</p>\n<p>\n	<img src="assets/uploads/attachment/image/20161016/20161016095543_16660.png" alt="" /> \n</p>\n<p>\n	肖邦父亲是法国人，母亲是波兰人，真实出生日期目前仍有争议，其拉丁文出生文献（出生证明和教堂受洗纪录）上记载为1810年2月22日，但其父母与家人均以3月1日作为肖邦生日，目前音乐史学界的考证，倾向3月1日为其正确出生日期，而2月22日为当年他的父亲误算了出生周数所致（比实际出生日期提早整整一星期）。肖邦自幼喜爱波兰民族音乐，7岁时就创作了波兰舞曲，8岁登台演出，不足20岁已出名。肖邦39岁时英年早逝，后半生主要生活在法国，创作了大量钢琴作品，如4部叙事曲、十余部波兰舞曲包括《军队》、《英雄》，26首钢琴前奏曲包括《雨滴》，27首钢琴练习曲包括《离别》、《革命》，4部谐谑曲、3部钢琴奏鸣曲，至少22首多夜曲，59首马祖卡，两首钢琴协奏曲，幻想曲和大提琴奏鸣曲等。肖邦一生的创作大多是钢琴曲，被誉为“钢琴诗人”。<br />\n<br />\n为了纪念肖邦，波兰华沙每五年举行一次肖邦国际钢琴比赛。\n</p>', 0, 0, 0, 0, '', '', 1, 1476611760, 1476612187),
(2, 1, 'demo', 1, '永兴美术社', '', '这是一个单页示范。它可以显示在菜单中。\n<h4>\n	经营项目\n</h4>\n<ul>\n	<li>\n		刻章、刻字\n	</li>\n	<li>\n		室内写真喷绘\n	</li>\n	<li>\n		图标设计、CAD/效果图大幅面输出\n	</li>\n	<li>\n		打印、复印、扫描、传真\n	</li>\n	<li>\n		彩喷、快照\n	</li>\n	<li>\n		条幅、X展架、易拉宝、展板制作\n	</li>\n	<li>\n		名片制作\n	</li>\n	<li>\n		工程复印、装订、印刷\n	</li>\n	<li>\n		锦旗、标牌制作\n	</li>\n	<li>\n		批量加工、订做广告衫、T恤衫等\n	</li>\n</ul>\n<h4>\n	地址\n</h4>\n<p>\n	黑龙江省哈尔滨市香坊区大庆副路125号\n</p>\n<h4>\n	电话\n</h4>\n<p>\n	0451-82106850、13804524270\n</p>\n<h4>\n	营业时间\n</h4>\n<p>\n	星期一至星期日 8:00 - 17:00\n</p>\n<p>\n	作为一个新的 BootCMS 的使用者，您应当去<a href="manage/">后台</a>删除此页，并根据您的内容创建新的单页。玩得开心！\n</p>', 0, 0, 4, 1, 'BootCMS,demo,永兴,美术社,打字,复印', 'BootCMS演示页', 1, 1404651120, 1404651664);

DROP TABLE IF EXISTS `bc_node_categories`;
CREATE TABLE `bc_node_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` tinytext NOT NULL,
  `slug` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='分类';

INSERT INTO `bc_node_categories` (`id`, `name`, `description`, `slug`) VALUES
(1, 'Action Games', '', 'action-games');

DROP TABLE IF EXISTS `bc_node_comments`;
CREATE TABLE `bc_node_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `node_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `reply_to` int(10) unsigned NOT NULL DEFAULT '0',
  `comment` text NOT NULL,
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  `last_edited` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `node_id` (`node_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='评论';

DROP TABLE IF EXISTS `bc_node_likes`;
CREATE TABLE `bc_node_likes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `node_id` int(10) unsigned NOT NULL DEFAULT '0',
  `like_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(39) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='喜欢';

DROP TABLE IF EXISTS `bc_orders`;
CREATE TABLE `bc_orders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_no` varchar(15) NOT NULL DEFAULT '',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `freight` decimal(5,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `consignee` varchar(10) NOT NULL DEFAULT '',
  `phone` varchar(25) NOT NULL DEFAULT '',
  `addr_prov` smallint(5) unsigned NOT NULL DEFAULT '0',
  `addr_city` smallint(5) unsigned NOT NULL DEFAULT '0',
  `addr_area` smallint(5) unsigned NOT NULL DEFAULT '0',
  `addr_detail` varchar(250) NOT NULL DEFAULT '',
  `message` varchar(250) NOT NULL DEFAULT '',
  `shipping` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `trade_no` varchar(30) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `order_no` (`order_no`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='订单';

DROP TABLE IF EXISTS `bc_order_products`;
CREATE TABLE `bc_order_products` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0',
  `product` varchar(120) NOT NULL DEFAULT '',
  `price` decimal(6,2) unsigned NOT NULL DEFAULT '0.00',
  `quantity` smallint(4) unsigned NOT NULL DEFAULT '0',
  `freight` decimal(5,2) unsigned NOT NULL DEFAULT '0.00',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订单产品';

DROP TABLE IF EXISTS `bc_pay_payments`;
CREATE TABLE `bc_pay_payments` (
  `id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) NOT NULL DEFAULT '',
  `pay_name` varchar(120) NOT NULL DEFAULT '',
  `pay_code` varchar(20) NOT NULL DEFAULT '',
  `pay_desc` text NOT NULL,
  `pay_method` tinyint(1) NOT NULL DEFAULT '0',
  `pay_fee` varchar(10) NOT NULL DEFAULT '',
  `config` text NOT NULL,
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `list_order` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `author` varchar(60) NOT NULL DEFAULT '',
  `website` varchar(100) NOT NULL DEFAULT '',
  `version` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `pay_code` (`pay_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='支付方式';

INSERT INTO `bc_pay_payments` (`id`, `name`, `pay_name`, `pay_code`, `pay_desc`, `pay_method`, `pay_fee`, `config`, `is_cod`, `is_online`, `list_order`, `enabled`, `author`, `website`, `version`) VALUES
(1, '支付宝', '支付宝', 'Alipay', '支付宝（中国）网络技术有限公司是国内领先的独立第三方支付平台，是阿里巴巴集团的关联公司。支付宝致力于为中国电子商务提供“简单、安全、快速”的在线支付解决方案。【<a href="https://b.alipay.com/order/productSet.htm" target="_blank"><strong>立即在线申请</strong></a>】', 0, '0', 'O:8:"stdClass":4:{s:12:"service_type";s:1:"0";s:7:"account";s:8:"username";s:7:"partner";s:16:"2088567890123456";s:3:"key";s:32:"abcdeabcde1234567890abcdeabcde12";}', 0, 1, 0, 1, '千狐工作室', 'http://www.alipay.com', '1.0.0');

DROP TABLE IF EXISTS `bc_products`;
CREATE TABLE `bc_products` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product_name` varchar(120) NOT NULL DEFAULT '',
  `category` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `introduce` varchar(500) NOT NULL DEFAULT '',
  `commodity_price` decimal(6,2) unsigned NOT NULL DEFAULT '0.00',
  `promotion_price` decimal(6,2) unsigned NOT NULL DEFAULT '0.00',
  `promote` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `list_order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  `item1` varchar(250) NOT NULL DEFAULT '',
  `item2` varchar(250) NOT NULL DEFAULT '',
  `item3` varchar(250) NOT NULL DEFAULT '',
  `item4` varchar(250) NOT NULL DEFAULT '',
  `item5` varchar(250) NOT NULL DEFAULT '',
  `item6` varchar(250) NOT NULL DEFAULT '',
  `item7` varchar(250) NOT NULL DEFAULT '',
  `item8` varchar(250) NOT NULL DEFAULT '',
  `item9` varchar(250) NOT NULL DEFAULT '',
  `item10` varchar(250) NOT NULL DEFAULT '',
  `pictures` varchar(250) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='产品';

INSERT INTO `bc_products` (`id`, `product_name`, `category`, `introduce`, `commodity_price`, `promotion_price`, `promote`, `list_order`, `created`, `item1`, `item2`, `item3`, `item4`, `item5`, `item6`, `item7`, `item8`, `item9`, `item10`, `pictures`, `status`) VALUES
(1, '苹果 iPhone 5（16GB）', 1, '优点：屏幕升级为4英寸，支持全景拍摄；听筒降噪功能有助于提升通话质量；siri 在 iOS 6 中已经实现汉语支持。\n缺点：自带地图软件尚待完善；铝合金材质容易刮花掉漆。', '4599.00', '4099.00', 1, 0, 1374762807, 'a:2:{i:0;s:12:"网络模式";i:1;s:17:"GSM，WCDMA，LTE";}', 'a:2:{i:0;s:12:"网络类型";i:1;s:12:"单卡双模";}', 'a:2:{i:0;s:12:"主屏尺寸";i:1;s:26:"4.0英寸，1136x640像素";}', 'a:2:{i:0;s:9:"CPU型号";i:1;s:9:"苹果 A6";}', 'a:2:{i:0;s:9:"CPU频率";i:1;s:14:"1066MHz 双核";}', 'a:2:{i:0;s:9:"触摸屏";i:1;s:24:"电容屏，多点触摸";}', 'a:2:{i:0;s:12:"键盘类型";i:1;s:18:"虚拟触摸键盘";}', 'a:2:{i:0;s:12:"内置容量";i:1;s:4:"16GB";}', 'a:2:{i:0;s:9:"摄像头";i:1;s:12:"800万像素";}', 'a:2:{i:0;s:12:"副摄像头";i:1;s:12:"120万像素";}', 'a:6:{i:0;s:1:"1";i:1;s:1:"2";i:2;s:1:"3";i:3;s:1:"4";i:4;s:1:"5";i:5;s:1:"6";}', 0);

DROP TABLE IF EXISTS `bc_product_categories`;
CREATE TABLE `bc_product_categories` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT '',
  `parent` smallint(5) unsigned NOT NULL DEFAULT '0',
  `list_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='产品分类';

INSERT INTO `bc_product_categories` (`id`, `name`, `parent`, `list_order`) VALUES
(1, '手机', 0, 1);

DROP TABLE IF EXISTS `bc_regions`;
CREATE TABLE `bc_regions` (
  `id` smallint(3) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(32) NOT NULL DEFAULT '',
  `region_title` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='区域';

INSERT INTO `bc_regions` (`id`, `type`, `region_title`) VALUES
(1, '0', '主菜单'),
(2, '1', '侧边栏');

DROP TABLE IF EXISTS `bc_region_blocks`;
CREATE TABLE `bc_region_blocks` (
  `id` smallint(3) unsigned NOT NULL AUTO_INCREMENT,
  `region_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `block_title` varchar(30) NOT NULL DEFAULT '',
  `block_content` text NOT NULL,
  `list_order` smallint(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='块';

INSERT INTO `bc_region_blocks` (`id`, `region_id`, `block_title`, `block_content`, `list_order`, `status`) VALUES
(1, 1, '首页', '', 1, 0),
(2, 1, '示范', 'demo', 2, 0),
(3, 1, '产品', 'product', 3, 0),
(4, 2, 'AdSense', '<script>\ngoogle_ad_client = "ca-pub-3247088052200757";\ngoogle_ad_slot = "5148538461";\ngoogle_ad_width = 180;\ngoogle_ad_height = 150;\n</script>\n<script type="text/javascript" src="http://pagead2.googlesyndication.com/pagead/show_ads.js">\n</script>', 4, 0),
(5, 1, '论坛', 'forum', 5, 0);

DROP TABLE IF EXISTS `bc_roles`;
CREATE TABLE `bc_roles` (
  `id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `authorization_code` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户角色';

INSERT INTO `bc_roles` (`id`, `name`, `description`, `authorization_code`) VALUES
(1, '暂停', '暂停账户没有任何权限。用户无法登录。', '0xvl3v'),
(2, '客户', '低级账户，用户可以登录，但不能执行任何任务。', 'aml66t'),
(3, '员工', '基本账户，用户可以登录和查看网站上的信息，但不能做任何改动。', 'iqib61'),
(4, '评论审核', '基本账户，用户可以批准、编辑、删除访问者留下的评论。', 'knvilx'),
(5, '作者', '高级账户，用户可以撰写和编辑自己的文章。', 'qdrgjr'),
(6, '发布员', '高级账户，用户可以批准、编辑、删除、恢复文章。', '4kqyo7'),
(7, '网站管理员', '高级账户，受信任的用户几乎可以控制网站所有的部分。', '9v1m48'),
(9, '管理员', '顶级管理员账户，用户可以控制网站的任何部分。', '466kyn');

DROP TABLE IF EXISTS `bc_shippings`;
CREATE TABLE `bc_shippings` (
  `id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `shipping_name` varchar(60) NOT NULL DEFAULT '',
  `shipping_desc` varchar(255) NOT NULL DEFAULT '',
  `areas` text NOT NULL,
  `base_weight` smallint(4) unsigned NOT NULL DEFAULT '0',
  `step_weight` smallint(4) unsigned NOT NULL DEFAULT '0',
  `price_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `base_price` decimal(5,2) unsigned NOT NULL DEFAULT '0.00',
  `step_price` decimal(5,2) unsigned NOT NULL DEFAULT '0.00',
  `insurance` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `support_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `list_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `bc_shippings` (`id`, `shipping_name`, `shipping_desc`, `areas`, `base_weight`, `step_weight`, `price_type`, `base_price`, `step_price`, `insurance`, `support_cod`, `list_order`, `status`) VALUES
(1, 'EMS', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 1, 1),
(2, '申通快递', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 2, 1),
(3, '中通速递', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 3, 1),
(4, '韵达快递', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 4, 1),
(5, '宅急送', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 5, 1),
(6, '邮政包裹', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 6, 1),
(7, '顺丰速运', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 7, 1),
(8, '圆通速递', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 8, 1),
(9, '百世汇通', '', '', 1000, 500, 0, '15.00', '12.00', '0.00', 0, 9, 0),
(10, '天天快递', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 10, 1),
(11, '全峰快递', '', '', 1000, 500, 0, '0.00', '0.00', '0.00', 0, 11, 1);

DROP TABLE IF EXISTS `bc_sites`;
CREATE TABLE `bc_sites` (
  `id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `site_title` varchar(40) NOT NULL DEFAULT '',
  `site_description` varchar(60) NOT NULL DEFAULT '',
  `meta_keywords` varchar(120) NOT NULL DEFAULT '',
  `meta_description` varchar(250) NOT NULL DEFAULT '',
  `admin_email` varchar(254) NOT NULL DEFAULT '',
  `company` varchar(40) NOT NULL DEFAULT '',
  `phone` varchar(25) NOT NULL DEFAULT '',
  `address` varchar(120) NOT NULL DEFAULT '',
  `date_format` varchar(15) NOT NULL DEFAULT '' COMMENT '日期格式',
  `timezone` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '时区',
  `comment_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `comment_email` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `version` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='站点';

INSERT INTO `bc_sites` (`id`, `site_title`, `site_description`, `meta_keywords`, `meta_description`, `admin_email`, `company`, `phone`, `address`, `date_format`, `timezone`, `comment_default`, `comment_email`, `version`) VALUES
(1, 'BootCMS', '完全面向对象的开源内容管理系统', 'bootcms,cms,open source,开源,内容管理,内容管理系统', 'BootCMS 是中国第一款完全面向对象的开源内容管理系统。', 'admin@domain.com', '千狐工作室', '0451-88888888', '哈尔滨市香坊区进乡街120号', 'Y年n月j日 H:i', 8, 0, 0, '1.1.3');

DROP TABLE IF EXISTS `bc_users`;
CREATE TABLE `bc_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(64) NOT NULL DEFAULT '',
  `email` varchar(254) NOT NULL DEFAULT '',
  `role_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `nickname` varchar(32) NOT NULL DEFAULT '',
  `company` varchar(80) NOT NULL DEFAULT '',
  `first_name` varchar(32) NOT NULL DEFAULT '',
  `secondary_email` varchar(254) NOT NULL DEFAULT '',
  `phone` varchar(25) NOT NULL DEFAULT '',
  `address` varchar(250) NOT NULL DEFAULT '',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  `resets` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `last_reset` int(10) unsigned NOT NULL DEFAULT '0',
  `logins` int(10) unsigned NOT NULL DEFAULT '0',
  `last_login` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_username` (`username`),
  UNIQUE KEY `uniq_email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户';

DROP TABLE IF EXISTS `bc_user_tokens`;
CREATE TABLE `bc_user_tokens` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_agent` varchar(40) NOT NULL DEFAULT '',
  `token` varchar(40) NOT NULL DEFAULT '',
  `type` varchar(100) NOT NULL DEFAULT '',
  `created` int(10) unsigned NOT NULL DEFAULT '0',
  `expires` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_token` (`token`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户自动登录令牌';
