<?php

defined('SYSPATH') || exit('Access Denied.');

/**
 * Log writer abstract class. All [Log] writers must extend this class.
 * @package BootPHP
 * @category 日志
 * @author Tinsh
 * @copyright (C) 2005-2016 Kilofox Studio
 */
abstract class Log_Writer {

	/**
	 * Numeric log level to string lookup table.
	 * @var array
	 */
	protected $_log_levels = array(
		LOG_EMERG => 'EMERGENCY',
		LOG_ALERT => 'ALERT',
		LOG_CRIT => 'CRITICAL',
		LOG_ERR => 'ERROR',
		LOG_WARNING => 'WARNING',
		LOG_NOTICE => 'NOTICE',
		LOG_INFO => 'INFO',
		LOG_DEBUG => 'DEBUG',
		8 => 'STRACE',
	);

	/**
	 * Write an array of messages.
	 *
	 *     $writer->write($messages);
	 *
	 * @param array  messages
	 * @return void
	 */
	abstract public function write(array $messages);

	/**
	 * Allows the writer to have a unique key when stored.
	 *
	 *     echo $writer;
	 *
	 * @return string
	 */
	final public function __toString()
	{
		return spl_object_hash($this);
	}

}
