﻿<?php
/**
 * TODO 基础分页的相同代码封装，使前台的代码更少
 * @param $count 要分页的总记录数
 * @param int $pagesize 每页查询条数
 * @return \Think\Page
 */
function getpage($count, $pagesize = 10) {
    $p = new \Think\Page($count, $pagesize);
    $p->setConfig('header', '共<b>%TOTAL_ROW%</b>条记录&nbsp;第<b>%NOW_PAGE%</b>页/共<b>%TOTAL_PAGE%</b>页');
    $p->setConfig('prev', '上一页');
    $p->setConfig('next', '下一页');
    $p->setConfig('last', '末页');
    $p->setConfig('first', '首页');
    $p->setConfig('theme', '%FIRST%%UP_PAGE%%LINK_PAGE%%DOWN_PAGE%%END%%HEADER%');
    $p->lastSuffix = false;//最后一页不显示为总页数
    return $p;
}


//前端取值时去除引号
function rinput($strvalue)
{
$svalue = htmlspecialchars_decode($strvalue);
$svalue = stripslashes($svalue);
$bstring="'|#";
$svalue = preg_replace("/$bstring/i",'',$svalue);
return $svalue;
}

//验证客户端信息输入
function cinput($value)
{
if(is_numeric($value)){	
		if(strlen($value)>6) {
			$value = intval(substr($value,0,6));
		}else{
			$value = intval($value);
			}
			}else{
//去除敏感字段
$badstring="select|insert|update|delete|#|%|union|onload|alert|script|into|drop|limit|truncate|outfile";
$value = preg_replace("/$badstring/i",'',$value);
}
return $value;
}



//生成随机字符
function GetRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}



//取子分类
    function sidtype($sid){
        $Data=M('nav');
        $id = $sid;
        $list=$Data->where(array('parent_id'=>$id))->order('sort')->select();
        return $list;
    }

//检测是否存在下级菜单
  function getsidnum($sid){
	    $id = $sid;
        $countvalue = M('nav')->where(array('parent_id'=>$id))->count();
        return $countvalue;
    }

   
//获取单页信息
  function getsingle($sid){
	    $id = $sid;
        $list = M('page')->where(array('id'=>$id))->find();
        return $list;
    }
  

//获取文章栏目列表
  function getartlist($sid,$num){
	    $id = $sid;
        $list = M('article')->where(array('cat_id'=>$id))->limit($num)->select();
        return $list;
    }
  


//获取商品栏目列表
  function getshoplist($sid,$num){
	    $id = $sid;
        $list = M('product')->where(array('cat_id'=>$id))->limit($num)->select();
        return $list;
    }
  

//获得推荐商品
function getshopview($str=''){
if(!strstr($str,',')){
return false;
}
$strarray = array();
$strarray = split(',',$str);
$retvalue = array();
foreach($strarray as $k=>$value){
$tempid = $value;
$getshop = M('product')->where(array('id'=>$tempid))->find();
$retvalue[] = $getshop;
}
return $retvalue;
}


//获得推荐文章
function getartview($str=''){
if(!strstr($str,',')){
return false;
}
$strarray = array();
$strarray = split(',',$str);
$retvalue = array();
foreach($strarray as $k=>$value){
$tempid = $value;
$getart = M('article')->where(array('id'=>$tempid))->find();
$retvalue[] = $getart;
}
return $retvalue;
}




?>