<?php
namespace Home\Controller;
use Think\Controller;


class BackController extends CommonController {

	//文章主页显示
    public function index(){
		$tablelist = array();
		$db = M();
        $table = $db->query($sql = 'SHOW TABLE STATUS');
		
        foreach($table as $k=>$value){
		$tablelist[$k]['data'] = round((($value['index_length'] + $value['data_length'])/1024),2);
        $tablelist[$k]['name'] = $value['name'];
        $tablelist[$k]['engine'] = $value['engine'];
		$tablelist[$k]['rows'] = $value['rows'];
        $tablelist[$k]['comment'] = $value['comment'];
		}		
        $this->tablelist = $tablelist;	
		$this->display();
    }



 
   /**
     * 优化表
     * @param  String $tables 表名
     * @author 麦当苗儿 <zuojiazi@vip.qq.com>
     */
    public function optimize($tables = null){
        if($tables) {
            $Db   = M();
            if(is_array($tables)){
                $tables = implode('`,`', $tables);
                $list = $Db->query("OPTIMIZE TABLE `{$tables}`");

                if($list){
                    $this->success("数据表优化完成！");
                } else {
                    $this->error("数据表优化出错请重试！");
                }
            } else {
                $list = $Db->query("OPTIMIZE TABLE `{$tables}`");
                if($list){
                    $this->success("数据表'{$tables}'优化完成！");
                } else {
                    $this->error("数据表'{$tables}'优化出错请重试！");
                }
            }
        } else {
            $this->error("请指定要优化的表！");
        }
    }

 /**
     * 修复表
     * @param  String $tables 表名
     * @author 麦当苗儿 <zuojiazi@vip.qq.com>
     */
    public function repair($tables = null){
        if($tables) {
            $Db   = M();
            if(is_array($tables)){
                $tables = implode('`,`', $tables);
                $list = $Db->query("REPAIR TABLE `{$tables}`");

                if($list){
                    $this->success("数据表修复完成！");
                } else {
                    $this->error("数据表修复出错请重试！");
                }
            } else {
                $list = $Db->query("REPAIR TABLE `{$tables}`");
                if($list){
                    $this->success("数据表'{$tables}'修复完成！");
                } else {
                    $this->error("数据表'{$tables}'修复出错请重试！");
                }
            }
        } else {
            $this->error("请指定要修复的表！");
        }
    }



public function export()    
{
           $path = './Public/back/';
            if(!is_dir($path)){
                mkdir($path, 0755, true);
            }

			
//读取备份配置
            $config = array(
                'path'     => realpath($path) . DIRECTORY_SEPARATOR               
            );

            //检查是否有正在执行的任务
            $lock = "{$config['path']}backup.lock";
            if(is_file($lock)){
                $this->error('检测已有一个备份，请删除lock文件再试！');
            } else {
                //创建锁文件
                file_put_contents($lock, NOW_TIME);
            }

$mylocalhost = I('mylocalhost');
$myroot = I('myroot');
$mypwd = I('mypwd');
$mydbname = I('mydbname');
$mybm = I('mybm');
if(is_null($mylocalhost) || is_null($myroot) || is_null($mypwd) || is_null($mydbname) || is_null($mybm)){
$this->error('请传入正确的参数');
}
$db = new \Think\DbManage($mylocalhost,$myroot,$mypwd,$mydbname,$mybm);
// 参数：备份哪个表(可选),备份目录(可选，默认为backup),分卷大小(可选,默认2048，即2M)
$db->backup ('',$path,'');
  
}









    
}