DROP TABLE IF EXISTS `mac_art_relation`
CREATE TABLE `mac_art_relation` (  `r_id` mediumint(8) NOT NULL auto_increment,  `r_type` tinyint(1) NOT NULL default '0',  `r_a` mediumint(8) NOT NULL default '0',  `r_b` mediumint(8) NOT NULL default '0',  PRIMARY KEY  (`r_id`),  KEY `r_type` (`r_type`),  KEY `r_a` (`r_a`),  KEY `r_b` (`r_b`)) ENGINE=MyISAM DEFAULT CHARSET=utf8
DROP TABLE IF EXISTS `mac_art_topic`
CREATE TABLE `mac_art_topic` (  `t_id` smallint(6) unsigned NOT NULL auto_increment,  `t_name` varchar(64) NOT NULL,  `t_enname` varchar(128) NOT NULL,  `t_sort` smallint(6) NOT NULL default '0',  `t_tpl` varchar(128) NOT NULL,  `t_pic` varchar(255) NOT NULL,  `t_content` varchar(255) NOT NULL,  `t_key` varchar(255) NOT NULL,  `t_des` varchar(255) NOT NULL,  `t_title` varchar(255) NOT NULL,  `t_hide` tinyint(1) NOT NULL default '0',  `t_level` tinyint(1) NOT NULL default '0',  `t_up` mediumint(8) NOT NULL default '0',  `t_down` mediumint(8) NOT NULL default '0',  `t_score` decimal(3,1) NOT NULL,  `t_scoreall` mediumint(8) NOT NULL,  `t_scorenum` smallint(6) NOT NULL,  `t_hits` mediumint(8) NOT NULL default '0',  `t_dayhits` mediumint(8) NOT NULL default '0',  `t_weekhits` mediumint(8) NOT NULL default '0',  `t_monthhits` mediumint(8) NOT NULL default '0',  `t_addtime` int(10) NOT NULL,  `t_time` int(10) NOT NULL,  `t_hitstime` int(10) NOT NULL,  PRIMARY KEY  (`t_id`),  KEY `t_sort` (`t_sort`),  KEY `t_hide` (`t_hide`),  KEY `t_level` (`t_level`),  KEY `t_up` (`t_up`),  KEY `t_down` (`t_down`),  KEY `t_score` (`t_score`),  KEY `t_scoreall` (`t_scoreall`),  KEY `t_scorenum` (`t_scorenum`),  KEY `t_hits` (`t_hits`),  KEY `t_dayhits` (`t_dayhits`),  KEY `t_weekhits` (`t_weekhits`),  KEY `t_monthhits` (`t_monthhits`),  KEY `t_addtime` (`t_addtime`),  KEY `t_time` (`t_time`),  KEY `t_hitstime` (`t_hitstime`)) ENGINE=MyISAM DEFAULT CHARSET=utf8
DROP TABLE IF EXISTS `mac_art_type`
CREATE TABLE `mac_art_type` (  `t_id` smallint(6) unsigned NOT NULL auto_increment,  `t_name` varchar(64) NOT NULL,  `t_enname` varchar(128) NOT NULL,  `t_pid` smallint(6) NOT NULL default '0',  `t_sort` smallint(6) NOT NULL default '0',  `t_hide` tinyint(1) NOT NULL default '0',  `t_tpl` varchar(64) NOT NULL,  `t_tpl_list` varchar(64) NOT NULL,  `t_tpl_art` varchar(64) NOT NULL,  `t_key` varchar(255) NOT NULL,  `t_des` varchar(255) NOT NULL,  `t_title` varchar(255) NOT NULL,  `t_union` varchar(255) NOT NULL,  PRIMARY KEY  (`t_id`),  KEY `t_pid` (`t_pid`),  KEY `t_sort` (`t_sort`),  KEY `t_hide` (`t_hide`)) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8
INSERT INTO `mac_art_type` VALUES('1','站内新闻','zhanneixinwen','0','1','0','art_type.html','art_list.html','art_detail.html','','','','');
INSERT INTO `mac_art_type` VALUES('2','娱乐动态','yuledongtai','0','2','0','art_type.html','art_list.html','art_detail.html','','','','');
INSERT INTO `mac_art_type` VALUES('3','八卦爆料','baguabaoliao','0','3','0','art_type.html','art_list.html','art_detail.html','','','','');
INSERT INTO `mac_art_type` VALUES('4','影片资讯','yingpianzixun','0','4','0','art_type.html','art_list.html','art_detail.html','','','','');
INSERT INTO `mac_art_type` VALUES('5','明星资讯','mingxingzixun','0','5','0','art_type.html','art_list.html','art_detail.html','','','','');
INSERT INTO `mac_art_type` VALUES('6','电视资讯','dianshizixun','0','6','0','art_type.html','art_list.html','art_detail.html','','','','');
DROP TABLE IF EXISTS `mac_comment`
CREATE TABLE `mac_comment` (  `c_id` int(11) NOT NULL auto_increment,  `c_type` int(11) default '0',  `c_vid` int(11) default '0',  `c_rid` int(11) default '0',  `c_hide` tinyint(1) default '0',  `c_name` varchar(64) NOT NULL,  `c_ip` varchar(32) NOT NULL,  `c_content` varchar(128) NOT NULL,  `c_time` int(10) NOT NULL,  PRIMARY KEY  (`c_id`),  KEY `c_vid` (`c_vid`),  KEY `c_type` (`c_type`),  KEY `c_rid` (`c_rid`),  KEY `c_time` (`c_time`),  KEY `c_hide` (`c_hide`)) ENGINE=MyISAM DEFAULT CHARSET=utf8
DROP TABLE IF EXISTS `mac_gbook`
CREATE TABLE `mac_gbook` (  `g_id` int(11) NOT NULL auto_increment,  `g_vid` int(11) default '0',  `g_hide` tinyint(1) default '0',  `g_sort` smallint(6) NOT NULL default '0',  `g_name` varchar(64) NOT NULL,  `g_content` varchar(255) NOT NULL,  `g_reply` varchar(255) NOT NULL,  `g_ip` int(11) NOT NULL,  `g_time` int(10) NOT NULL,  `g_replytime` int(10) NOT NULL,  PRIMARY KEY  (`g_id`),  KEY `g_vid` (`g_vid`),  KEY `g_time` (`g_time`),  KEY `g_hide` (`g_hide`),  KEY `g_sort` (`g_sort`),  KEY `g_replytime` (`g_replytime`)) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8
INSERT INTO `mac_gbook` VALUES('1','0','0','0','游客','请在这里发表您的个人看法，最多200个字。[em:8][em:8][em:8][em:8][em:8][em:8][em:8][em:8]','','2130706433','1458349846','0');
INSERT INTO `mac_gbook` VALUES('2','0','0','0','游客','请在这里发表您的个人看法，最多200个字。[em:16][em:16][em:16][em:16][em:16]','','2130706433','1458350953','0');
INSERT INTO `mac_gbook` VALUES('3','0','0','0','游客','请在这里发表您的个人看法，最多200个字。[em:10][em:11][em:11][em:11][em:11][em:11]','','2130706433','1458704775','0');
DROP TABLE IF EXISTS `mac_link`
CREATE TABLE `mac_link` (  `l_id` smallint(6) unsigned NOT NULL auto_increment,  `l_name` varchar(64) NOT NULL,  `l_url` varchar(255) NOT NULL,  `l_logo` varchar(255) NOT NULL,  `l_type` tinyint(1) NOT NULL default '0',  `l_sort` smallint(6) NOT NULL default '0',  PRIMARY KEY  (`l_id`),  KEY `l_sort` (`l_sort`),  KEY `l_type` (`l_type`)) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8
INSERT INTO `mac_link` VALUES('1','非常恶搞','http://www.egao8.cc','','0','1');
INSERT INTO `mac_link` VALUES('2','58搞笑视频','http://www.58gx.cc','','0','2');
INSERT INTO `mac_link` VALUES('3','KT听书网','http://www.ktsing.com','','0','3');
INSERT INTO `mac_link` VALUES('4','猫先生','http://www.catsir.cc','','0','5');
DROP TABLE IF EXISTS `mac_user`
CREATE TABLE `mac_user` (  `u_id` mediumint(8) unsigned NOT NULL auto_increment,  `u_qid` varchar(32) NOT NULL,  `u_name` varchar(32) NOT NULL,  `u_password` varchar(32) NOT NULL,  `u_qq` varchar(16) NOT NULL,  `u_email` varchar(32) NOT NULL,  `u_phone` varchar(16) NOT NULL,  `u_status` tinyint(1) NOT NULL default '0',  `u_flag` tinyint(1) NOT NULL default '0',  `u_question` varchar(255) NOT NULL,  `u_answer` varchar(255) NOT NULL,  `u_group` smallint(6) NOT NULL default '0',  `u_points` smallint(6) NOT NULL default '0',  `u_regtime` int(11) NOT NULL,  `u_logintime` int(11) NOT NULL,  `u_loginnum` smallint(6) NOT NULL default '0',  `u_extend` smallint(6) NOT NULL default '0',  `u_loginip` int(11) NOT NULL,  `u_random` varchar(32) NOT NULL,  `u_fav` text NOT NULL,  `u_plays` text NOT NULL,  `u_downs` text NOT NULL,  `u_start` int(11) NOT NULL,  `u_end` int(11) NOT NULL,  PRIMARY KEY  (`u_id`),  KEY `u_group` (`u_group`),  KEY `u_status` (`u_status`)) ENGINE=MyISAM DEFAULT CHARSET=utf8
DROP TABLE IF EXISTS `mac_user_card`
CREATE TABLE `mac_user_card` (  `c_id` int(11) unsigned NOT NULL auto_increment,  `c_number` varchar(16) NOT NULL,  `c_pass` varchar(8) NOT NULL,  `c_money` smallint(11) NOT NULL default '0',  `c_point` smallint(11) NOT NULL default '0',  `c_used` tinyint(1) NOT NULL default '0',  `c_sale` tinyint(1) NOT NULL default '0',  `c_user` smallint(6) NOT NULL default '0',  `c_addtime` int(11) NOT NULL,  `c_usetime` int(11) NOT NULL,  PRIMARY KEY  (`c_id`),  KEY `c_used` (`c_used`),  KEY `c_sale` (`c_sale`),  KEY `c_user` (`c_user`),  KEY `c_addtime` (`c_addtime`),  KEY `c_usetime` (`c_usetime`)) ENGINE=MyISAM DEFAULT CHARSET=utf8
DROP TABLE IF EXISTS `mac_user_group`
CREATE TABLE `mac_user_group` (  `ug_id` smallint(6) NOT NULL auto_increment,  `ug_name` varchar(32) NOT NULL,  `ug_type` varchar(255) NOT NULL,  `ug_popedom` varchar(32) NOT NULL,  `ug_upgrade` smallint(6) NOT NULL default '0',  `ug_popvalue` smallint(6) NOT NULL default '0',  PRIMARY KEY  (`ug_id`),  KEY `ug_upgrade` (`ug_upgrade`),  KEY `ug_popvalue` (`ug_popvalue`)) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8
INSERT INTO `mac_user_group` VALUES('1','普通会员','','','0','1');
DROP TABLE IF EXISTS `mac_user_pay`
CREATE TABLE `mac_user_pay` (  `p_id` int(11) NOT NULL auto_increment,  `p_order` int(11) NOT NULL default '0',  `p_uid` mediumint(8) NOT NULL default '0',  `p_price` smallint(6) NOT NULL default '0',  `p_time` int(11) NOT NULL default '0',  `p_point` smallint(6) NOT NULL default '0',  `p_status` tinyint(1) NOT NULL default '0',  PRIMARY KEY  (`p_id`),  KEY `p_order` (`p_order`),  KEY `p_uid` (`p_uid`),  KEY `p_status` (`p_status`)) ENGINE=MyISAM DEFAULT CHARSET=latin1
DROP TABLE IF EXISTS `mac_user_visit`
CREATE TABLE `mac_user_visit` (  `uv_id` int(11) NOT NULL auto_increment,  `uv_uid` int(11) default '0',  `uv_ip` int(11) NOT NULL,  `uv_ly` varchar(128) NOT NULL,  `uv_time` int(10) NOT NULL,  PRIMARY KEY  (`uv_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8
DROP TABLE IF EXISTS `mac_vod_relation`
CREATE TABLE `mac_vod_relation` (  `r_id` mediumint(8) NOT NULL auto_increment,  `r_type` tinyint(1) NOT NULL default '0',  `r_a` mediumint(8) NOT NULL default '0',  `r_b` mediumint(8) NOT NULL default '0',  PRIMARY KEY  (`r_id`),  KEY `r_type` (`r_type`),  KEY `r_a` (`r_a`),  KEY `r_b` (`r_b`)) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8
DROP TABLE IF EXISTS `mac_vod_topic`
CREATE TABLE `mac_vod_topic` (  `t_id` smallint(6) unsigned NOT NULL auto_increment,  `t_name` varchar(64) NOT NULL,  `t_enname` varchar(128) NOT NULL,  `t_sort` smallint(6) NOT NULL default '0',  `t_tpl` varchar(128) NOT NULL,  `t_pic` varchar(255) NOT NULL,  `t_content` varchar(255) NOT NULL,  `t_key` varchar(255) NOT NULL,  `t_des` varchar(255) NOT NULL,  `t_title` varchar(255) NOT NULL,  `t_hide` tinyint(1) NOT NULL default '0',  `t_level` tinyint(1) NOT NULL default '0',  `t_up` mediumint(8) NOT NULL default '0',  `t_down` mediumint(8) NOT NULL default '0',  `t_score` decimal(3,1) NOT NULL,  `t_scoreall` mediumint(8) NOT NULL,  `t_scorenum` smallint(6) NOT NULL,  `t_hits` mediumint(8) NOT NULL default '0',  `t_dayhits` mediumint(8) NOT NULL default '0',  `t_weekhits` mediumint(8) NOT NULL default '0',  `t_monthhits` mediumint(8) NOT NULL default '0',  `t_addtime` int(10) NOT NULL,  `t_time` int(10) NOT NULL,  `t_hitstime` int(10) NOT NULL,  PRIMARY KEY  (`t_id`),  KEY `t_sort` (`t_sort`),  KEY `t_hide` (`t_hide`),  KEY `t_level` (`t_level`),  KEY `t_up` (`t_up`),  KEY `t_down` (`t_down`),  KEY `t_score` (`t_score`),  KEY `t_scoreall` (`t_scoreall`),  KEY `t_scorenum` (`t_scorenum`),  KEY `t_hits` (`t_hits`),  KEY `t_dayhits` (`t_dayhits`),  KEY `t_weekhits` (`t_weekhits`),  KEY `t_monthhits` (`t_monthhits`),  KEY `t_addtime` (`t_addtime`),  KEY `t_time` (`t_time`),  KEY `t_hitstime` (`t_hitstime`)) ENGINE=MyISAM DEFAULT CHARSET=utf8
DROP TABLE IF EXISTS `mac_vod_type`
CREATE TABLE `mac_vod_type` (  `t_id` smallint(6) unsigned NOT NULL auto_increment,  `t_name` varchar(64) NOT NULL,  `t_enname` varchar(128) NOT NULL,  `t_pid` smallint(6) NOT NULL default '0',  `t_sort` smallint(6) NOT NULL default '0',  `t_hide` tinyint(1) NOT NULL default '0',  `t_tpl` varchar(64) NOT NULL,  `t_tpl_list` varchar(64) NOT NULL,  `t_tpl_vod` varchar(64) NOT NULL,  `t_tpl_play` varchar(64) NOT NULL,  `t_tpl_down` varchar(64) NOT NULL,  `t_key` varchar(255) NOT NULL,  `t_des` varchar(255) NOT NULL,  `t_title` varchar(255) NOT NULL,  `t_union` varchar(255) NOT NULL,  PRIMARY KEY  (`t_id`),  KEY `t_sort` (`t_sort`),  KEY `t_pid` (`t_pid`),  KEY `t_hide` (`t_hide`)) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8
INSERT INTO `mac_vod_type` VALUES('1','恶搞配音','peiyin','0','1','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('2','吐槽','tucao','0','2','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('3','神曲','shenqu','0','3','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('4','动漫','dongman','0','4','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('5','胥渡吧','xuduba','1','11','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('6','小夏配音','xiaoxia','1','12','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('7','淮秀帮','huaixiubang','1','13','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('8','老湿','laoshi','1','14','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('9','司文痞子','siwenpizi','1','14','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('10','某S解说','mous','1','16','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('11','歪歌公社','waige','1','17','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('12','欧子','ouzi','2','21','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('13','暴走漫画','baozou','2','22','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('14','飞碟说','feidieshuo','2','23','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('15','壹读视频','yidu','2','24','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('16','唱罢吹灯','changba','3','25','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('17','猿创艺','yuanchuangyi','3','26','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('18','海之爱','haizhiai','3','27','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('19','饭小杰','fangxiaojie','3','28','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('20','阿初','achu','3','29','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('21','印象德林','yinxiang','4','30','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('22','龙颜大悦','longyandayue','4','31','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
INSERT INTO `mac_vod_type` VALUES('23','敖厂长','aochangzhang','4','32','0','vod_type.html','vod_list.html','vod_detail.html','vod_play.html','vod_down.html','','','','');
DROP TABLE IF EXISTS `mac_vod_class`
CREATE TABLE `mac_vod_class` (  `c_id` smallint(6) unsigned NOT NULL auto_increment,  `c_name` varchar(64) NOT NULL,  `c_pid` smallint(6) NOT NULL default '0',  `c_sort` smallint(6) NOT NULL default '0',  `c_hide` tinyint(1) NOT NULL default '0',  PRIMARY KEY  (`c_id`),  KEY `c_sort` (`c_sort`),  KEY `c_pid` (`c_pid`),  KEY `c_hide` (`c_hide`)) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8
INSERT INTO `mac_vod_class` VALUES('1','惊悚','1','1','0');
INSERT INTO `mac_vod_class` VALUES('2','悬疑','1','2','0');
INSERT INTO `mac_vod_class` VALUES('3','魔幻','1','3','0');
INSERT INTO `mac_vod_class` VALUES('4','罪案','1','4','0');
INSERT INTO `mac_vod_class` VALUES('5','灾难','1','5','0');
INSERT INTO `mac_vod_class` VALUES('6','动画','1','6','0');
INSERT INTO `mac_vod_class` VALUES('7','古装','1','7','0');
INSERT INTO `mac_vod_class` VALUES('8','青春','1','8','0');
INSERT INTO `mac_vod_class` VALUES('9','歌舞','1','9','0');
INSERT INTO `mac_vod_class` VALUES('10','文艺','1','10','0');
INSERT INTO `mac_vod_class` VALUES('11','生活','1','10','0');
INSERT INTO `mac_vod_class` VALUES('12','历史','1','10','0');
INSERT INTO `mac_vod_class` VALUES('13','励志','1','10','0');
INSERT INTO `mac_vod_class` VALUES('14','预告片','1','10','0');
INSERT INTO `mac_vod_class` VALUES('15','言情','2','1','0');
INSERT INTO `mac_vod_class` VALUES('16','都市','2','2','0');
INSERT INTO `mac_vod_class` VALUES('17','家庭','2','3','0');
INSERT INTO `mac_vod_class` VALUES('18','生活','2','4','0');
INSERT INTO `mac_vod_class` VALUES('19','偶像','2','5','0');
INSERT INTO `mac_vod_class` VALUES('20','喜剧','2','6','0');
INSERT INTO `mac_vod_class` VALUES('21','历史','2','7','0');
INSERT INTO `mac_vod_class` VALUES('22','古装','2','8','0');
INSERT INTO `mac_vod_class` VALUES('23','武侠','2','9','0');
INSERT INTO `mac_vod_class` VALUES('24','刑侦','2','10','0');
INSERT INTO `mac_vod_class` VALUES('25','战争','2','11','0');
INSERT INTO `mac_vod_class` VALUES('26','神话','2','12','0');
INSERT INTO `mac_vod_class` VALUES('27','军旅','2','13','0');
INSERT INTO `mac_vod_class` VALUES('28','谍战','2','14','0');
INSERT INTO `mac_vod_class` VALUES('29','商战','2','15','0');
INSERT INTO `mac_vod_class` VALUES('30','校园','2','16','0');
INSERT INTO `mac_vod_class` VALUES('31','穿越','2','17','0');
INSERT INTO `mac_vod_class` VALUES('32','悬疑','2','18','0');
INSERT INTO `mac_vod_class` VALUES('33','犯罪','2','19','0');
INSERT INTO `mac_vod_class` VALUES('34','科幻','2','20','0');
INSERT INTO `mac_vod_class` VALUES('35','预告片','2','21','0');
INSERT INTO `mac_vod_class` VALUES('36','脱口秀','3','1','0');
INSERT INTO `mac_vod_class` VALUES('37','真人秀','3','2','0');
INSERT INTO `mac_vod_class` VALUES('38','选秀','3','3','0');
INSERT INTO `mac_vod_class` VALUES('39','情感','3','4','0');
INSERT INTO `mac_vod_class` VALUES('40','访谈','3','5','0');
INSERT INTO `mac_vod_class` VALUES('41','时尚','3','6','0');
INSERT INTO `mac_vod_class` VALUES('42','晚会','3','7','0');
INSERT INTO `mac_vod_class` VALUES('43','财经','3','8','0');
INSERT INTO `mac_vod_class` VALUES('44','益智','3','9','0');
INSERT INTO `mac_vod_class` VALUES('45','音乐','3','10','0');
INSERT INTO `mac_vod_class` VALUES('46','游戏','3','11','0');
INSERT INTO `mac_vod_class` VALUES('47','职场','3','12','0');
INSERT INTO `mac_vod_class` VALUES('48','美食','3','13','0');
INSERT INTO `mac_vod_class` VALUES('49','旅游','3','14','0');
INSERT INTO `mac_vod_class` VALUES('50','冒险','4','1','0');
INSERT INTO `mac_vod_class` VALUES('51','热血','4','2','0');
INSERT INTO `mac_vod_class` VALUES('52','搞笑','4','3','0');
INSERT INTO `mac_vod_class` VALUES('53','少女','4','4','0');
INSERT INTO `mac_vod_class` VALUES('54','推理','4','5','0');
INSERT INTO `mac_vod_class` VALUES('55','竞技','4','6','0');
INSERT INTO `mac_vod_class` VALUES('56','益智','4','7','0');
INSERT INTO `mac_vod_class` VALUES('57','童话','4','8','0');
INSERT INTO `mac_vod_class` VALUES('58','经典','4','9','0');
DROP TABLE IF EXISTS `mac_art`
CREATE TABLE `mac_art` (  `a_id` int(11) unsigned NOT NULL auto_increment,  `a_name` varchar(255) NOT NULL,  `a_subname` varchar(255) NOT NULL,  `a_enname` varchar(255) NOT NULL,  `a_letter` char(1) NOT NULL,  `a_color` char(6) NOT NULL,  `a_from` varchar(32) NOT NULL,  `a_author` varchar(32) NOT NULL,  `a_tag` varchar(64) NOT NULL,  `a_pic` varchar(255) NOT NULL,  `a_type` smallint(6) NOT NULL default '0',  `a_topic` varchar(255) NOT NULL,  `a_level` tinyint(1) NOT NULL default '0',  `a_hide` tinyint(1) NOT NULL default '0',  `a_lock` tinyint(1) NOT NULL default '0',  `a_up` mediumint(8) NOT NULL default '0',  `a_down` mediumint(8) NOT NULL default '0',  `a_hits` mediumint(8) NOT NULL default '0',  `a_dayhits` mediumint(8) NOT NULL default '0',  `a_weekhits` mediumint(8) NOT NULL default '0',  `a_monthhits` mediumint(8) NOT NULL default '0',  `a_addtime` int(10) NOT NULL,  `a_time` int(10) NOT NULL,  `a_hitstime` int(10) NOT NULL,  `a_maketime` int(10) NOT NULL,  `a_remarks` varchar(255) NOT NULL,  `a_content` mediumtext NOT NULL,  PRIMARY KEY  (`a_id`),  KEY `a_type` (`a_type`),  KEY `a_level` (`a_level`),  KEY `a_hits` (`a_hits`),  KEY `a_dayhits` (`a_dayhits`),  KEY `a_weekhits` (`a_weekhits`),  KEY `a_monthhits` (`a_monthhits`),  KEY `a_addtime` (`a_addtime`),  KEY `a_time` (`a_time`),  KEY `a_maketime` (`a_maketime`),  KEY `a_hide` (`a_hide`),  KEY `a_letter` (`a_letter`),  KEY `a_down` (`a_down`),  KEY `a_up` (`a_up`),  KEY `a_tag` (`a_tag`),  KEY `a_name` (`a_name`),  KEY `a_enname` (`a_enname`)) ENGINE=MyISAM DEFAULT CHARSET=utf8
DROP TABLE IF EXISTS `mac_vod`
CREATE TABLE `mac_vod` (  `d_id` int(11) unsigned NOT NULL auto_increment,  `d_name` varchar(255) NOT NULL,  `d_subname` varchar(255) NOT NULL,  `d_enname` varchar(255) NOT NULL,  `d_letter` char(1) NOT NULL,  `d_color` char(6) NOT NULL,  `d_pic` varchar(255) NOT NULL,  `d_picthumb` varchar(255) NOT NULL,  `d_picslide` varchar(255) NOT NULL,  `d_starring` varchar(255) NOT NULL,  `d_directed` varchar(255) NOT NULL,  `d_tag` varchar(64) NOT NULL,  `d_remarks` varchar(64) NOT NULL,  `d_area` varchar(16) NOT NULL,  `d_lang` varchar(16) NOT NULL,  `d_year` smallint(4) NOT NULL,  `d_type` smallint(6) NOT NULL default '0',  `d_type_expand` varchar(255) NOT NULL,  `d_class` varchar(255) NOT NULL,  `d_topic` varchar(255) NOT NULL default '0',  `d_hide` tinyint(1) NOT NULL default '0',  `d_lock` tinyint(1) NOT NULL,  `d_state` int(8) NOT NULL default '0',  `d_level` tinyint(1) NOT NULL default '0',  `d_usergroup` smallint(6) NOT NULL default '0',  `d_stint` smallint(6) NOT NULL default '0',  `d_stintdown` smallint(6) NOT NULL default '0',  `d_hits` mediumint(8) NOT NULL default '0',  `d_dayhits` mediumint(8) NOT NULL default '0',  `d_weekhits` mediumint(8) NOT NULL default '0',  `d_monthhits` mediumint(8) NOT NULL default '0',  `d_duration` smallint(6) NOT NULL default '0',  `d_up` mediumint(8) NOT NULL default '0',  `d_down` mediumint(8) NOT NULL default '0',  `d_score` decimal(3,1) NOT NULL default '0.0',  `d_scoreall` mediumint(8) NOT NULL,  `d_scorenum` smallint(6) NOT NULL default '0',  `d_addtime` int(10) NOT NULL,  `d_time` int(10) NOT NULL,  `d_hitstime` int(10) NOT NULL,  `d_maketime` int(10) NOT NULL,  `d_content` text NOT NULL,  `d_playfrom` varchar(255) NOT NULL,  `d_playserver` varchar(255) NOT NULL,  `d_playnote` varchar(255) NOT NULL,  `d_playurl` mediumtext NOT NULL,  `d_downfrom` varchar(255) NOT NULL,  `d_downserver` varchar(255) NOT NULL,  `d_downnote` varchar(255) NOT NULL,  `d_downurl` mediumtext NOT NULL,  PRIMARY KEY  (`d_id`),  KEY `d_type` (`d_type`),  KEY `d_state` (`d_state`),  KEY `d_level` (`d_level`),  KEY `d_hits` (`d_hits`),  KEY `d_dayhits` (`d_dayhits`),  KEY `d_weekhits` (`d_weekhits`),  KEY `d_monthhits` (`d_monthhits`),  KEY `d_stint` (`d_stint`),  KEY `d_stintdown` (`d_stintdown`),  KEY `d_hide` (`d_hide`),  KEY `d_usergroup` (`d_usergroup`),  KEY `d_score` (`d_score`),  KEY `d_addtime` (`d_addtime`),  KEY `d_time` (`d_time`),  KEY `d_maketime` (`d_maketime`),  KEY `d_topic` (`d_topic`),  KEY `d_letter` (`d_letter`),  KEY `d_name` (`d_name`),  KEY `d_enname` (`d_enname`),  KEY `d_year` (`d_year`),  KEY `d_area` (`d_area`),  KEY `d_language` (`d_lang`),  KEY `d_starring` (`d_starring`),  KEY `d_directed` (`d_directed`),  KEY `d_tag` (`d_tag`),  KEY `d_type_expand` (`d_type_expand`),  KEY `d_class` (`d_class`),  KEY `d_lock` (`d_lock`),  KEY `d_up` (`d_up`),  KEY `d_down` (`d_down`),  KEY `d_scoreall` (`d_scoreall`),  KEY `d_scorenum` (`d_scorenum`)) ENGINE=MyISAM AUTO_INCREMENT=1613 DEFAULT CHARSET=utf8
INSERT INTO `mac_vod` VALUES('1','［大话西游］28 太白金星的身份之谜—专辑：《小宝说书，不一样的解读》','','dahuaxiyou28taibaijinxingdeshenfenzhimizhuanjixiaobaoshuoshubuyiyangdejiedu','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462563918.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','371','0','0','0','0','0','0','5.0','1435','287','1457668855','1457668855','0','0','［大话西游］28 太白金星的身份之谜—专辑：《小宝说书，不一样的解读》','youku','0','','XOTM3NDIyMDU2','','','','');
INSERT INTO `mac_vod` VALUES('2','吐槽2015羊年春晚  胥渡吧','','tucao2015yangnianchunwanxuduba','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446284228.png','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','502','0','0','0','0','0','0','1.0','171','171','1457668855','1457668855','0','0','吐槽2015羊年春晚  胥渡吧','youku','0','','XODc5Nzk3NTcy','','','','');
INSERT INTO `mac_vod` VALUES('3','爆笑!没钱买年货之&lt;欢乐逗逼贺新年&gt;许华升作品—专辑：《[优酷牛人]追债骚年许华升原创恶搞短片合辑》','','baoxiaomeiqianmainianhuozhilthuanledoubihexinniangtxuhuashengzuopinzhuanjiyoukuniurenzhuizhaisaonianxuhuashengyuanchuangegaoduanpianheji','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462842511.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','462','0','0','0','0','0','0','3.0','1257','419','1457668855','1457668855','0','0','爆笑!没钱买年货之<欢乐逗逼贺新年>许华升作品—专辑：《【优酷牛人】追债骚年许华升原创恶搞短片合辑》','youku','0','','XODc3NzI0MzAw','','','','');
INSERT INTO `mac_vod` VALUES('4','[Youtube奇趣精选]有爱老夫妇浪漫日常—专辑：《另类老头老太太，你们这么卖萌你们的家人知道吗？》','','Youtubeqiqujingxuanyouailaofufulangmanrichangzhuanjilingleilaotoulaotaitainimenzhememaimengnimendejiarenzhidaoma','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462843015.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','615','0','0','0','0','0','0','2.0','238','119','1457668855','1457668855','0','0','【Youtube奇趣精选】有爱老夫妇浪漫日常—专辑：《另类老头老太太，你们这么卖萌你们的家人知道吗？》','youku','0','','XODc5ODc5ODMy','','','','');
INSERT INTO `mac_vod` VALUES('5','暑假那点事，只有长得好看的人才有暑假','','shujianadianshizhiyouchangdehaokanderencaiyoushujia','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462843017.gif','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','419','0','0','0','0','0','0','9.0','1404','156','1457668855','1457668855','0','0','暑假那点事，只有长得好看的人才有暑假','youku','0','','146009010','','','','');
INSERT INTO `mac_vod` VALUES('6','年度盘点《摩擦2014》  [牛人]胥渡吧 2014','','niandupandianmoca2014niurenxuduba2014','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446284444.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','672','0','0','0','0','0','0','10.0','3360','336','1457668855','1457668855','0','0','年度盘点《摩擦2014》  【牛人】胥渡吧 2014','youku','0','','XODU5Njg3MjA0','','','','');
INSERT INTO `mac_vod` VALUES('7','[麦兜找穿帮]《武媚娘传奇》第四弹 剧组任性全穿帮—专辑：《[优酷牛人]何仙姑夫爆笑原创恶搞经典合辑》','','maidouzhaochuanbangwumeiniangchuanqidisidanjuzurenxingquanchuanbangzhuanjiyoukuniurenhexiangufubaoxiaoyuanchuangegaojingdianheji','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446284498.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','771','0','0','0','0','0','0','6.0','78','13','1457668855','1457668855','0','0','【麦兜找穿帮】《武媚娘传奇》第四弹 剧组任性全穿帮—专辑：《【优酷牛人】何仙姑夫爆笑原创恶搞经典合辑》','youku','0','','XODgwMTkyMDk2','','','','');
INSERT INTO `mac_vod` VALUES('8','2015美国春晚已利箭在弦 一触即发  [牛人]大案命案要案在身 2014','','2015meiguochunwanyilijianzaixianyichujifaniurendaanminganyaoanzaishen2014','2','','http://www.egao8.cc/upload/vod/2015-10-12/144462845111.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','954','0','0','0','0','0','0','4.0','848','212','1457668855','1457668855','0','0','2015美国春晚已利箭在弦 一触即发  【牛人】大案命案要案在身 2014','youku','0','','XODU0OTMyNjUy','','','','');
INSERT INTO `mac_vod` VALUES('9','《匹诺曹》穿帮镜头','','pinuocaochuanbangjingtou','P','','http://www.egao8.cc/upload/vod/2015-10-12/144462845314.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','552','0','0','0','0','0','0','5.0','1280','256','1457668855','1457668855','0','0','《匹诺曹》穿帮镜头','youku','0','','XODc3OTgyMTg0','','','','');
INSERT INTO `mac_vod` VALUES('10','尔康和紫薇的后现代生活','','erkangheziweidehouxiandaishenghuo','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462926617.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','241','0','0','0','0','0','0','1.0','388','388','1457668855','1457668855','0','0','尔康和紫薇的后现代生活','youku','0','','108525286','','','','');
INSERT INTO `mac_vod` VALUES('11','恶搞 新《还珠格格》有一个嬷嬷','','egaoxinhuaizhugegeyouyigemama','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462926718.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','291','0','0','0','0','0','0','8.0','3200','400','1457668855','1457668855','0','0','恶搞 新《还珠格格》有一个嬷嬷','youku','0','','71320696','','','','');
INSERT INTO `mac_vod` VALUES('12','奥运吼大声，包租婆，咆哮马神一样的狮子吼','','aoyunhoudashengbaozupopaoxiaomashenyiyangdeshizihou','A','','http://www.egao8.cc/upload/vod/2015-10-12/14446292771.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','815','0','0','0','0','0','0','4.0','1016','254','1457668855','1457668855','0','0','奥运吼大声，包租婆，咆哮马神一样的狮子吼','youku','0','','107991013','','','','');
INSERT INTO `mac_vod` VALUES('13','恶搞配音那些年我们一起找工作','','egaopeiyinnaxienianwomenyiqizhaogongzuo','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446292782.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','21','0','0','0','0','0','0','6.0','1266','211','1457668855','1457668855','0','0','恶搞配音那些年我们一起找工作','youku','0','','92066316','','','','');
INSERT INTO `mac_vod` VALUES('14','新还珠格格片段 紫薇尔康骑马','','xinhuaizhugegepianduanziweierkangqima','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446292805.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','458','0','0','0','0','0','0','9.0','4068','452','1457668855','1457668855','0','0','新还珠格格片段 紫薇尔康骑马','youku','0','','72836509','','','','');
INSERT INTO `mac_vod` VALUES('15','我们是新青年之胥渡吧','','womenshixinqingnianzhixuduba','W','','http://www.egao8.cc/upload/vod/2015-10-12/14446292816.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','272','0','0','0','0','0','0','1.0','205','205','1457668855','1457668855','0','0','我们是新青年之胥渡吧','youku','0','','86782504','','','','');
INSERT INTO `mac_vod` VALUES('16','恶搞文章裸泳的真正原因','','egaowenzhangluoyongdezhenzhengyuanyin','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446292828.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','450','0','0','0','0','0','0','7.0','2597','371','1457668855','1457668855','0','0','恶搞文章裸泳的真正原因','youku','0','','106167883','','','','');
INSERT INTO `mac_vod` VALUES('17','恶搞艺考真可怕！','','egaoyikaozhenkepa','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462929312.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','76','0','0','0','0','0','0','4.0','588','147','1457668855','1457668855','0','0','恶搞艺考真可怕！','youku','0','','91277688','','','','');
INSERT INTO `mac_vod` VALUES('18','2012百姓春晚盛典之胥渡吧','','2012baixingchunwanshengdianzhixuduba','2','','http://www.egao8.cc/upload/vod/2015-10-12/144462929516.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','573','0','0','0','0','0','0','4.0','608','152','1457668855','1457668855','0','0','2012百姓春晚盛典之胥渡吧','youku','0','','86782980','','','','');
INSERT INTO `mac_vod` VALUES('19','恶搞新白娘子配音《金山寺夜店》','','egaoxinbainiangzipeiyinjinshansiyedian','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446293041.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','963','0','0','0','0','0','0','8.0','416','52','1457668855','1457668855','0','0','恶搞新白娘子配音《金山寺夜店》','youku','0','','53829154','','','','');
INSERT INTO `mac_vod` VALUES('20','胥渡新白：观音抠像样本花絮','','xuduxinbaiguanyinkouxiangyangbenhuaxu','X','','http://www.egao8.cc/upload/vod/2016-02-24/145628081619.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','109','0','0','0','0','0','0','3.0','558','186','1457668855','1457668855','0','0','胥渡新白：观音抠像样本花絮','youku','0','','XMTc4NjEzMTg0','','','','');
INSERT INTO `mac_vod` VALUES('21','你是恐归族吗？过年不回家的N个理由！—专辑：《[优酷搞笑牛人]胡狼恶搞原创经典作品合辑》','','nishikongguizumaguonianbuhuijiadeNgeliyouzhuanjiyoukugaoxiaoniurenhulangegaoyuanchuangjingdianzuopinheji','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446282986.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','35','0','0','0','0','0','0','10.0','4570','457','1457668867','1457668867','0','0','你是恐归族吗？过年不回家的N个理由！—专辑：《【优酷搞笑牛人】胡狼恶搞原创经典作品合辑》','youku','0','','XODg4MDM3MTky','','','','');
INSERT INTO `mac_vod` VALUES('22','山寨球星莱万多夫斯基泡妞攻略—专辑：《[笑吧]最新最热最有趣整蛊恶搞失败集锦！》','','shanzhaiqiuxinglaiwanduofusijipaoniugongluezhuanjixiaobazuixinzuirezuiyouquzhengguegaoshibaijijin','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462830311.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','43','0','0','0','0','0','0','6.0','444','74','1457668867','1457668867','0','0','山寨球星莱万多夫斯基泡妞攻略—专辑：《【笑吧】最新最热最有趣整蛊恶搞失败集锦！》','youku','0','','XODg4MTkzODky','','','','');
INSERT INTO `mac_vod` VALUES('23','天下神脚 谁与争锋—专辑：《搞笑牛人：大案命案要案在身经典合辑》','','tianxiashenjiaoshuiyuzhengfengzhuanjigaoxiaoniurendaanminganyaoanzaishenjingdianheji','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462830817.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','366','0','0','0','0','0','0','5.0','2200','440','1457668867','1457668867','0','0','天下神脚 谁与争锋—专辑：《搞笑牛人：大案命案要案在身经典合辑》','youku','0','','XODg5NTI5MDk2','','','','');
INSERT INTO `mac_vod` VALUES('24','[马马虎虎]黑人朋友在中国遭遇东方特色尴尬—专辑：《[马马虎虎]老外告诉你的那些事儿》','','mamahuhuheirenpengyouzaizhongguozaoyudongfangtesegangazhuanjimamahuhulaowaigaosunidenaxieshier','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446283215.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','478','0','0','0','0','0','0','4.0','280','70','1457668867','1457668867','0','0','【马马虎虎】黑人朋友在中国遭遇东方特色尴尬—专辑：《【马马虎虎】老外告诉你的那些事儿》','youku','0','','XODgwNTE1Njg4','','','','');
INSERT INTO `mac_vod` VALUES('25','爆笑毒舌悟空智斗老板抢年终奖—专辑：《[优酷牛人]剑少兮创意恶搞合辑，犀利与搞笑并重！》','','baoxiaodushewukongzhidoulaobanqiangnianzhongjiangzhuanjiyoukuniurenjianshaoxichuangyiegaohejixiliyugaoxiaobingzhong','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446283259.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','70','0','0','0','0','0','0','6.0','2058','343','1457668867','1457668867','0','0','爆笑毒舌悟空智斗老板抢年终奖—专辑：《【优酷牛人】剑少兮创意恶搞合辑，犀利与搞笑并重！》','youku','0','','XODg5MDA2MTEy','','','','');
INSERT INTO `mac_vod` VALUES('26','曾经想火 第二季：第5集—专辑：《《曾经想火》第二季》','','zengjingxianghuodierjidi5jizhuanjizengjingxianghuodierji','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462832913.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','302','0','0','0','0','0','0','9.0','1080','120','1457668867','1457668867','0','0','曾经想火 第二季：第5集—专辑：《《曾经想火》第二季》','youku','0','','XODgwMDM5OTcy','','','','');
INSERT INTO `mac_vod` VALUES('27','小黄人吐槽：无间间间间间道 《笑点研究所》32期—专辑：《[笑点研究所]小黄人毒舌神吐槽！》','','xiaohuangrentucaowujianjianjianjianjiandaoxiaodianyanjiusuo32qizhuanjixiaodianyanjiusuoxiaohuangrendusheshentucao','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462833417.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','53','0','0','0','0','0','0','9.0','3339','371','1457668867','1457668867','0','0','小黄人吐槽：无间间间间间道 《笑点研究所》32期—专辑：《【笑点研究所】小黄人毒舌神吐槽！》','youku','0','','XODg3NTU4NjQ0','','','','');
INSERT INTO `mac_vod` VALUES('28','[轻松时刻]新一年的我 将会是个崭新的逗比—专辑：《发现生活笑点，感受[轻松时刻]！》','','qingsongshikexinyiniandewojianghuishigezhanxindedoubizhuanjifaxianshenghuoxiaodianganshouqingsongshike','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446283442.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','170','0','0','0','0','0','0','2.0','602','301','1457668867','1457668867','0','0','【轻松时刻】新一年的我 将会是个崭新的逗比—专辑：《发现生活笑点，感受【轻松时刻】！》','youku','0','','XODgxMTQ0ODA4','','','','');
INSERT INTO `mac_vod` VALUES('29','[买萌卖萌]萌宠萌宝视频集锦[第四十八期]—专辑：《[买萌卖萌]各种神宠的卖萌进行时，看看有你们家的吗？》','','maimengmaimengmengchongmengbaoshipinjijindisishibaqizhuanjimaimengmaimenggezhongshenchongdemaimengjinxingshikankanyounimenjiadema','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446283486.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','721','0','0','0','0','0','0','9.0','4284','476','1457668867','1457668867','0','0','【买萌卖萌】萌宠萌宝视频集锦（第四十八期）—专辑：《【买萌卖萌】各种神宠的卖萌进行时，看看有你们家的吗？》','youku','0','','XODg4MTExNTQw','','','','');
INSERT INTO `mac_vod` VALUES('30','[飞碟唱]理发师之歌—专辑：《[飞碟唱]》','','feidiechanglifashizhigezhuanjifeidiechang','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462835513.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','240','0','0','0','0','0','0','7.0','3101','443','1457668867','1457668867','0','0','【飞碟唱】理发师之歌—专辑：《【飞碟唱】》','youku','0','','XODgxMTA2ODQw','','','','');
INSERT INTO `mac_vod` VALUES('31','每周星座04-拯救处女男人生的星座女—专辑：《[优酷牛人]秀策坊动画黑星座系列》','','meizhouxingzuo04zhengjiuchunvnanrenshengdexingzuonvzhuanjiyoukuniurenxiucefangdonghuaheixingzuoxilie','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462836019.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','982','0','0','0','0','0','0','10.0','3610','361','1457668867','1457668867','0','0','每周星座04-拯救处女男人生的星座女—专辑：《【优酷牛人】秀策坊动画黑星座系列》','youku','0','','XODgwMDkyMDQ0','','','','');
INSERT INTO `mac_vod` VALUES('32','天津妞犀利吐槽陆小凤与花满楼 司文痞子113部—专辑：《[优酷牛人]司文痞子恶搞配音经典合辑》','','tianjinniuxilitucaoluxiaofengyuhuamanlousiwenpizi113buzhuanjiyoukuniurensiwenpiziegaopeiyinjingdianheji','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446283715.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','168','0','0','0','0','0','0','5.0','610','122','1457668867','1457668867','0','0','天津妞犀利吐槽陆小凤与花满楼 司文痞子113部—专辑：《【优酷牛人】司文痞子恶搞配音经典合辑》','youku','0','','XODc5OTM3MTIw','','','','');
INSERT INTO `mac_vod` VALUES('33','开挂的印度少年 54','','kaiguadeyindushaonian54','K','','http://www.egao8.cc/upload/vod/2015-10-12/144462838115.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','240','0','0','0','0','0','0','10.0','4790','479','1457668867','1457668867','0','0','开挂的印度少年 54','youku','0','','XODgwNDQzNjI4','','','','');
INSERT INTO `mac_vod` VALUES('34','曾经想火 第二季 05 真实的欣欣','','zengjingxianghuodierji05zhenshidexinxin','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462838116.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','109','0','0','0','0','0','0','1.0','168','168','1457668867','1457668867','0','0','曾经想火 第二季 05 真实的欣欣','youku','0','','XODgwMDM5OTcy','','','','');
INSERT INTO `mac_vod` VALUES('35','简笔笑画番外篇《何以笙箫默》—专辑：《[优酷牛人]简笔笑画无节操动画爆笑合辑》','','jianbixiaohuafanwaipianheyishengxiaomozhuanjiyoukuniurenjianbixiaohuawujiecaodonghuabaoxiaoheji','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462838218.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','403','0','0','0','0','0','0','2.0','68','34','1457668867','1457668867','0','0','简笔笑画番外篇《何以笙箫默》—专辑：《【优酷牛人】简笔笑画无节操动画爆笑合辑》','youku','0','','XODgwNDA3OTA4','','','','');
INSERT INTO `mac_vod` VALUES('36','吐槽2015羊年春晚 150126','','tucao2015yangnianchunwan150126','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446283967.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','720','0','0','0','0','0','0','7.0','1106','158','1457668867','1457668867','0','0','吐槽2015羊年春晚 150126','youku','0','','XODc5Nzk3NTcy','','','','');
INSERT INTO `mac_vod` VALUES('37','学长为讨好学妹 居然男扮女装替考《囧闻一箩筐》—专辑：《[何仙姑夫]囧闻一箩筐》','','xuechangweitaohaoxuemeijirannanbannvzhuangtikaowenyiluokuangzhuanjihexiangufuwenyiluokuang','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462840111.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','876','0','0','0','0','0','0','3.0','1437','479','1457668867','1457668867','0','0','学长为讨好学妹 居然男扮女装替考《囧闻一箩筐》—专辑：《【何仙姑夫】囧闻一箩筐》','youku','0','','XODc4NjI4OTAw','','','','');
INSERT INTO `mac_vod` VALUES('38','[飞碟一分钟]一分钟告诉你长期熬夜怎么保健—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhonggaosunichangqiaoyezenmebaojianzhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462840415.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','157','0','0','0','0','0','0','6.0','2520','420','1457668867','1457668867','0','0','【飞碟一分钟】一分钟告诉你长期熬夜怎么保健—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XODgwNDIxNjc2','','','','');
INSERT INTO `mac_vod` VALUES('39','英国妞模仿151种口袋妖怪叫声—专辑：《这里有彪悍女汉子，也有萌妹纸！》','','yingguoniumofang151zhongkoudaiyaoguaijiaoshengzhuanjizheliyoubiaohannvhanziyeyoumengmeizhi','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462840819.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','566','0','0','0','0','0','0','7.0','112','16','1457668867','1457668867','0','0','英国妞模仿151种口袋妖怪叫声—专辑：《这里有彪悍女汉子，也有萌妹纸！》','youku','0','','XODc4NjA3NzI0','','','','');
INSERT INTO `mac_vod` VALUES('40','[哇哈哦哦]贵宾犬卡在门内,黑猫警长救援拉不出「钻进去推屁股」—专辑：《对这个动物比人类还会卖萌的世界绝望鸟！》','','wahaououguibinquankazaimennaheimiaojingchangjiuyuanlabuchuzuanjinqutuipiguzhuanjiduizhegedongwubirenleihuaihuimaimengdeshijiejuewangniao','W','','http://www.egao8.cc/upload/vod/2015-10-12/14446284184.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','76','0','0','0','0','0','0','9.0','306','34','1457668867','1457668867','0','0','【哇哈哦哦】贵宾犬卡在门内,黑猫警长救援拉不出「钻进去推屁股」—专辑：《对这个动物比人类还会卖萌的世界绝望鸟！》','youku','0','','XODc5NjI3MzMy','','','','');
INSERT INTO `mac_vod` VALUES('41','[粉丝堂搞笑]恶搞达人巴哥恶搞&lt;Uptown Funk&gt;致敬Michael Jackson—专辑：《[粉丝堂]恶搞达人巴哥各类爆笑恶搞MV','','fensitanggaoxiaoegaodarenbageegaoltUptownFunkgtzhijingMichaelJacksonzhuanjifensitangegaodarenbagegeleibaoxiaoegaoMV','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462820611.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','879','0','0','0','0','0','0','10.0','990','99','1457668879','1457668879','0','0','【粉丝堂搞笑】恶搞达人巴哥恶搞<Uptown Funk>致敬Michael Jackson—专辑：《【粉丝堂】恶搞达人巴哥各类爆笑恶搞MV','youku','0','','XODg3NTU4ODY0','','','','');
INSERT INTO `mac_vod` VALUES('42','[麦兜找穿帮]2014电视剧十大穿帮镜头 何仙姑夫工作室—专辑：《[优酷牛人]何仙姑夫爆笑原创恶搞经典合辑》','','maidouzhaochuanbang2014dianshijushidachuanbangjingtouhexiangufugongzuoshizhuanjiyoukuniurenhexiangufubaoxiaoyuanchuangegaojingdianheji','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462821015.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','635','0','0','0','0','0','0','2.0','650','325','1457668879','1457668879','0','0','【麦兜找穿帮】2014电视剧十大穿帮镜头 何仙姑夫工作室—专辑：《【优酷牛人】何仙姑夫爆笑原创恶搞经典合辑》','youku','0','','XODg4NjI0MzYw','','','','');
INSERT INTO `mac_vod` VALUES('43','傻缺奇趣视频合辑[第六十五期]—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','','shaqueqiqushipinhejidiliushiwuqizhuanjibeijushaquegaoxiaoqiqushibaidiaobaoshipinjijindisandan','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462821419.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','722','0','0','0','0','0','0','7.0','3024','432','1457668879','1457668879','0','0','傻缺奇趣视频合辑(第六十五期)—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','youku','0','','XODg3OTgwOTky','','','','');
INSERT INTO `mac_vod` VALUES('44','[内涵播报32]作死！叫醒基友的正确方式—专辑：《内涵播报》','','nahanbobao32zuosijiaoxingjiyoudezhengquefangshizhuanjinahanbobao','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446282254.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','488','0','0','0','0','0','0','5.0','1870','374','1457668879','1457668879','0','0','【内涵播报32】作死！叫醒基友的正确方式—专辑：《内涵播报》','youku','0','','XODgwODcxNTU2','','','','');
INSERT INTO `mac_vod` VALUES('45','[每日一囧452]逆天了，整过容的屁股—专辑：《[每日一囧]2014再战江湖第二弹！》','','meiriyi452nitianliaozhengguorongdepiguzhuanjimeiriyi2014zaizhanjianghudierdan','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446282287.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','500','0','0','0','0','0','0','4.0','1864','466','1457668879','1457668879','0','0','【每日一囧452】逆天了，整过容的屁股—专辑：《【每日一囧】2014再战江湖第二弹！》','youku','0','','XODg4NzA4MDM2','','','','');
INSERT INTO `mac_vod` VALUES('46','优酷视频审核员张全蛋—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','','youkushipinshenheyuanzhangquandanzhuanjiduanjuyefengkuangbaoxiaopandianjingcaiduanju','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462823211.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','792','0','0','0','0','0','0','3.0','24','8','1457668879','1457668879','0','0','优酷视频审核员张全蛋—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','youku','0','','XODg3ODg0NzQ4','','','','');
INSERT INTO `mac_vod` VALUES('47','天津妞犀利吐槽千金女贼 司文痞子第115—专辑：《[优酷牛人]司文痞子恶搞配音经典合辑》','','tianjinniuxilitucaoqianjinnvzeisiwenpizidi115zhuanjiyoukuniurensiwenpiziegaopeiyinjingdianheji','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462823818.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','119','0','0','0','0','0','0','4.0','1624','406','1457668879','1457668879','0','0','天津妞犀利吐槽千金女贼 司文痞子第115—专辑：《【优酷牛人】司文痞子恶搞配音经典合辑》','youku','0','','XODg5NzI4MjM2','','','','');
INSERT INTO `mac_vod` VALUES('48','[飞碟一分钟]一分钟教你长途不晕车—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaonichangtubuyunchezhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462823919.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','204','0','0','0','0','0','0','7.0','2128','304','1457668879','1457668879','0','0','【飞碟一分钟】一分钟教你长途不晕车—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XODg3NTIyNDAw','','','','');
INSERT INTO `mac_vod` VALUES('49','分分钟涨姿势第十五期：中国美女地理系列！—专辑：《[分分钟涨姿势]姿势就是力量》','','fenfenzhongzhangzishidishiwuqizhongguomeinvdilixiliezhuanjifenfenzhongzhangzishizishijiushililiang','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446282504.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','987','0','0','0','0','0','0','6.0','1224','204','1457668879','1457668879','0','0','分分钟涨姿势第十五期：中国美女地理系列！—专辑：《【分分钟涨姿势】姿势就是力量》','youku','0','','XODg3NTk4MjMy','','','','');
INSERT INTO `mac_vod` VALUES('50','[奇趣盘点]一周搞笑奇趣视频集锦[第四十八期]—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','','qiqupandianyizhougaoxiaoqiqushipinjijindisishibaqizhuanjibeijushaquegaoxiaoqiqushibaidiaobaoshipinjijindisandan','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446282548.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','879','0','0','0','0','0','0','1.0','92','92','1457668879','1457668879','0','0','【奇趣盘点】一周搞笑奇趣视频集锦（第四十八期）—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','youku','0','','XODgzMjE0MTI0','','','','');
INSERT INTO `mac_vod` VALUES('51','火锅风云—专辑：《有一种恶搞叫XX风云》','','huoguofengyunzhuanjiyouyizhongegaojiaoXXfengyun','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462826013.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','9','0','0','0','0','0','0','2.0','128','64','1457668879','1457668879','0','0','火锅风云—专辑：《有一种恶搞叫XX风云》','youku','0','','XODg3ODcxMzIw','','','','');
INSERT INTO `mac_vod` VALUES('52','胥渡吧：每逢过年必心塞—专辑：《胥渡吧恶搞配音经典合辑》  胥渡出品','','xudubameifengguonianbixinsaizhuanjixudubaegaopeiyinjingdianhejixuduchupin','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462826215.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','475','0','0','0','0','0','0','7.0','3143','449','1457668879','1457668879','0','0','胥渡吧：每逢过年必心塞—专辑：《胥渡吧恶搞配音经典合辑》  胥渡出品','youku','0','','XODg1MTkxMTYw','','','','');
INSERT INTO `mac_vod` VALUES('53','汽车洋葱圈 第十期 4s店保养黑幕—专辑：《汽车洋葱圈搞笑吐槽系列节目》','','qicheyangcongquandishiqi4sdianbaoyangheimuzhuanjiqicheyangcongquangaoxiaotucaoxiliejiemu','Q','','http://www.egao8.cc/upload/vod/2015-10-12/144462826418.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','592','0','0','0','0','0','0','10.0','4380','438','1457668879','1457668879','0','0','汽车洋葱圈 第十期 4s店保养黑幕—专辑：《汽车洋葱圈搞笑吐槽系列节目》','youku','0','','XODg3MTgyNDc2','','','','');
INSERT INTO `mac_vod` VALUES('54','每周星座06-谁是推倒双鱼女的极品男—专辑：《[优酷牛人]秀策坊动画黑星座系列》','','meizhouxingzuo06shuishituidaoshuangyunvdejipinnanzhuanjiyoukuniurenxiucefangdonghuaheixingzuoxilie','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446282776.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','146','0','0','0','0','0','0','9.0','1836','204','1457668879','1457668879','0','0','每周星座06-谁是推倒双鱼女的极品男—专辑：《【优酷牛人】秀策坊动画黑星座系列》','youku','0','','XODg5OTM3OTQw','','','','');
INSERT INTO `mac_vod` VALUES('55','萌妹巧吐槽！韩国欧巴李钟硕的异乡之恋！竟是Runningman姐妹篇？—专辑：《[搞笑牛人]吟笑派创意恶搞视频合辑》','','mengmeiqiaotucaohanguooubalizhongshuodeyixiangzhilianjingshiRunningmanjiemeipianzhuanjigaoxiaoniurenyinxiaopaichuangyiegaoshipinheji','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446282799.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','641','0','0','0','0','0','0','3.0','90','30','1457668879','1457668879','0','0','萌妹巧吐槽！韩国欧巴李钟硕的异乡之恋！竟是Runningman姐妹篇？—专辑：《【搞笑牛人】吟笑派创意恶搞视频合辑》','youku','0','','XODg3MjQ3NTU2','','','','');
INSERT INTO `mac_vod` VALUES('56','最强大脑第二季 选手逆天令人发指[囧闻一箩筐]—专辑：《[何仙姑夫]囧闻一箩筐》','','zuiqiangdanaodierjixuanshounitianlingrenfazhiwenyiluokuangzhuanjihexiangufuwenyiluokuang','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462828112.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','550','0','0','0','0','0','0','8.0','3472','434','1457668879','1457668879','0','0','最强大脑第二季 选手逆天令人发指【囧闻一箩筐】—专辑：《【何仙姑夫】囧闻一箩筐》','youku','0','','XODgwODU5NjAw','','','','');
INSERT INTO `mac_vod` VALUES('57','2014年度喜当爹七宗最[囧闻一箩筐]—专辑：《[何仙姑夫]囧闻一箩筐》','','2014nianduxidangdieqizongzuiwenyiluokuangzhuanjihexiangufuwenyiluokuang','2','','http://www.egao8.cc/upload/vod/2015-10-12/144462828516.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','564','0','0','0','0','0','0','8.0','2344','293','1457668879','1457668879','0','0','2014年度喜当爹七宗最【囧闻一箩筐】—专辑：《【何仙姑夫】囧闻一箩筐》','youku','0','','XODg2NTY5NjU2','','','','');
INSERT INTO `mac_vod` VALUES('58','暴走每周精选05—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','','baozoumeizhoujingxuan05zhuanjibaozoumanhuabangnijianjiecaobaozouxiaoketangkanshapianerdoubizhelianmeng','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462828618.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','843','0','0','0','0','0','0','9.0','4212','468','1457668879','1457668879','0','0','暴走每周精选05—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','youku','0','','XODg5NTcxODEy','','','','');
INSERT INTO `mac_vod` VALUES('59','唐唐脱口秀：开挂的印度少年[唐唐脱口秀]第三十四期—专辑：《[唐唐脱口秀]官方专辑》','','tangtangtuokouxiukaiguadeyindushaoniantangtangtuokouxiudisanshisiqizhuanjitangtangtuokouxiuguanfangzhuanji','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446282942.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','266','0','0','0','0','0','0','8.0','3440','430','1457668879','1457668879','0','0','唐唐脱口秀：开挂的印度少年【唐唐脱口秀】第三十四期—专辑：《【唐唐脱口秀】官方专辑》','youku','0','','XODgwNDQzNjI4','','','','');
INSERT INTO `mac_vod` VALUES('60','[逗逼者联盟 07]守银大任—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','','doubizhelianmeng07shouyindarenzhuanjibaozoumanhuabangnijianjiecaobaozouxiaoketangkanshapianerdoubizhelianmeng','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462830413.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','680','0','0','0','0','0','0','3.0','1152','384','1457668879','1457668879','0','0','【逗逼者联盟 07】守银大任—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','youku','0','','XODgwOTM5MTIw','','','','');
INSERT INTO `mac_vod` VALUES('61','[羊年励志神剧]你羊巅峰了吗？—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','','yangnianlizhishenjuniyangdianfengliaomazhuanjiduanjuyefengkuangbaoxiaopandianjingcaiduanju','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446280897.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','966','0','0','0','0','0','0','3.0','564','188','1457668891','1457668891','0','0','【羊年励志神剧】你羊巅峰了吗？—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','youku','0','','XODkwNjQ2OTc2','','','','');
INSERT INTO `mac_vod` VALUES('62','唐唐脱口秀：单身狗的眼泪[唐唐脱口秀]第三十六期—专辑：《[唐唐脱口秀]官方专辑》','','tangtangtuokouxiudanshengoudeyanleitangtangtuokouxiudisanshiliuqizhuanjitangtangtuokouxiuguanfangzhuanji','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462809311.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','837','0','0','0','0','0','0','10.0','1140','114','1457668891','1457668891','0','0','唐唐脱口秀：单身狗的眼泪【唐唐脱口秀】第三十六期—专辑：《【唐唐脱口秀】官方专辑》','youku','0','','XODkwMzkyODQ4','','','','');
INSERT INTO `mac_vod` VALUES('63','蜘蛛侠招女公关—专辑：《周星星麻辣喜剧》','','zhizhuxiazhaonvgongguanzhuanjizhouxingxingmalaxiju','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446281142.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','616','0','0','0','0','0','0','1.0','68','68','1457668891','1457668891','0','0','蜘蛛侠招女公关—专辑：《周星星麻辣喜剧》','youku','0','','XODg5NTg0Mjcy','','','','');
INSERT INTO `mac_vod` VALUES('64','女神の动物园第44期：可爱狗狗背书包上学—专辑：《女神+萌宠的爆笑组合！女神の动物园》','','nvshendongwuyuandi44qikeaigougoubeishubaoshangxuezhuanjinvshenmengchongdebaoxiaozuhenvshendongwuyuan','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446281143.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','41','0','0','0','0','0','0','7.0','2282','326','1457668891','1457668891','0','0','女神の动物园第44期：可爱狗狗背书包上学—专辑：《女神+萌宠的爆笑组合！女神の动物园》','youku','0','','XODg4OTE1MDk2','','','','');
INSERT INTO `mac_vod` VALUES('65','简笔笑画番外2《宫斗》—专辑：《[优酷牛人]简笔笑画无节操动画爆笑合辑》','','jianbixiaohuafanwai2gongdouzhuanjiyoukuniurenjianbixiaohuawujiecaodonghuabaoxiaoheji','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446281176.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','943','0','0','0','0','0','0','4.0','1836','459','1457668891','1457668891','0','0','简笔笑画番外2《宫斗》—专辑：《【优酷牛人】简笔笑画无节操动画爆笑合辑》','youku','0','','XODg5ODkxNzgw','','','','');
INSERT INTO `mac_vod` VALUES('66','与亲爸亲妈一起把乐带回家！','','yuqinbaqinmayiqibaledaihuijia','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446281199.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','500','0','0','0','0','0','0','9.0','4167','463','1457668891','1457668891','0','0','与亲爸亲妈一起把乐带回家！','youku','0','','XODgyODE2MTU2','','','','');
INSERT INTO `mac_vod` VALUES('67','万万没想到：千钧一发','','wanwanmeixiangdaoqianjunyifa','W','','http://www.egao8.cc/upload/vod/2015-10-12/144462812212.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','479','0','0','0','0','0','0','3.0','1131','377','1457668891','1457668891','0','0','万万没想到：千钧一发','youku','0','','XODg2ODUyNzk2','','','','');
INSERT INTO `mac_vod` VALUES('68','2014十大逗比动物事件盘点—专辑：《2014年度&ldquo;各种&rdquo;盘点》','','2014shidadoubidongwushijianpandianzhuanji2014nianduldquogezhongrdquopandian','2','','http://www.egao8.cc/upload/vod/2015-10-12/144462813117.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','496','0','0','0','0','0','0','9.0','3735','415','1457668891','1457668891','0','0','2014十大逗比动物事件盘点—专辑：《2014年度&ldquo;各种&rdquo;盘点》','youku','0','','XODg5NjA5MDYw','','','','');
INSERT INTO `mac_vod` VALUES('69','2014年，前5个有史以来国外最好的作死成功—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','','2014nianqian5geyoushiyilaiguowaizuihaodezuosichenggongzhuanjibeijushaquegaoxiaoqiqushibaidiaobaoshipinjijindisandan','2','','http://www.egao8.cc/upload/vod/2015-10-12/14446281412.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','256','0','0','0','0','0','0','9.0','774','86','1457668891','1457668891','0','0','2014年，前5个有史以来国外最好的作死成功—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','youku','0','','XODg4OTU1MjMy','','','','');
INSERT INTO `mac_vod` VALUES('70','山寨球星莱夫多万斯基泡妞攻略—专辑：《[笑吧]最新最热最有趣整蛊恶搞失败集锦！》','','shanzhaiqiuxinglaifuduowansijipaoniugongluezhuanjixiaobazuixinzuirezuiyouquzhengguegaoshibaijijin','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446281467.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','810','0','0','0','0','0','0','4.0','1292','323','1457668891','1457668891','0','0','山寨球星莱夫多万斯基泡妞攻略—专辑：《【笑吧】最新最热最有趣整蛊恶搞失败集锦！》','youku','0','','XODg4MTkzODky','','','','');
INSERT INTO `mac_vod` VALUES('71','[飞碟一分钟]一分钟告诉你菜鸟司机易犯的错误—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhonggaosunicainiaosijiyifandecuowuzhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462815010.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','804','0','0','0','0','0','0','6.0','624','104','1457668891','1457668891','0','0','【飞碟一分钟】一分钟告诉你菜鸟司机易犯的错误—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XODg5NTMwOTYw','','','','');
INSERT INTO `mac_vod` VALUES('72','[飞碟说]酒桌上的中国—专辑：《『飞碟说 』创意动画趣味科普热点视频精彩选集》','','feidieshuojiuzhuoshangdezhongguozhuanjifeidieshuochuangyidonghuaquweikepuredianshipinjingcaixuanji','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462815515.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','725','0','0','0','0','0','0','4.0','312','78','1457668891','1457668891','0','0','【飞碟说】酒桌上的中国—专辑：《『飞碟说 』创意动画趣味科普热点视频精彩选集》','youku','0','','XODg2NTU1MDIw','','','','');
INSERT INTO `mac_vod` VALUES('73','致命遇险一百种自救[二]—专辑：《郑云原创搞笑短片经典大合辑》','','zhimingyuxianyibaizhongzijiuerzhuanjizhengyunyuanchuanggaoxiaoduanpianjingdiandaheji','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462815818.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','155','0','0','0','0','0','0','3.0','582','194','1457668891','1457668891','0','0','致命遇险一百种自救（二）—专辑：《郑云原创搞笑短片经典大合辑》','youku','0','','XODg2MTQ4MDgw','','','','');
INSERT INTO `mac_vod` VALUES('74','[飞碟一分钟]一分钟教你增强路由器WIFI信号—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaonizengqiangluyouqiWIFIxinhaozhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446281662.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','20','0','0','0','0','0','0','6.0','1920','320','1457668891','1457668891','0','0','【飞碟一分钟】一分钟教你增强路由器WIFI信号—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XODg2ODIwMjcy','','','','');
INSERT INTO `mac_vod` VALUES('75','学校里的疯子 第四季 第十一集 醉了！女神竟然如此放荡不羁—专辑：《[向尚飞影视传媒]爆笑校园短剧+街采神回复》','','xuexiaolidefengzidisijidishiyijizuiliaonvshenjingranrucifangdangbujizhuanjixiangshangfeiyingshichuanmeibaoxiaoxiaoyuanduanjujiecaishenhuifu','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446281717.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','839','0','0','0','0','0','0','3.0','1119','373','1457668891','1457668891','0','0','学校里的疯子 第四季 第十一集 醉了！女神竟然如此放荡不羁—专辑：《【向尚飞影视传媒】爆笑校园短剧+街采神回复》','youku','0','','XODg2OTc3MTgw','','','','');
INSERT INTO `mac_vod` VALUES('76','[奇趣盘点]一周搞笑奇趣视频集锦[第四十九期]—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','','qiqupandianyizhougaoxiaoqiqushipinjijindisishijiuqizhuanjibeijushaquegaoxiaoqiqushibaidiaobaoshipinjijindisandan','Q','','http://www.egao8.cc/upload/vod/2015-10-12/144462817511.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','977','0','0','0','0','0','0','3.0','1323','441','1457668891','1457668891','0','0','【奇趣盘点】一周搞笑奇趣视频集锦（第四十九期）—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','youku','0','','XODg4MDU5MjE2','','','','');
INSERT INTO `mac_vod` VALUES('77','[暴走看啥片儿第二季]10 微爱之渐入佳境：一部到处都在自黑的电影—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、','','baozoukanshapianerdierji10weiaizhijianrujiajingyibudaochuduzaiziheidedianyingzhuanjibaozoumanhuabangnijianjiecaobaozouxiaoketangkanshapianer','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462818015.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','889','0','0','0','0','0','0','6.0','2442','407','1457668891','1457668891','0','0','【暴走看啥片儿第二季】10 微爱之渐入佳境：一部到处都在自黑的电影—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、','youku','0','','XODg3ODA0OTI0','','','','');
INSERT INTO `mac_vod` VALUES('78','唐唐神吐槽：最脑残的美少女[Big笑工坊]第九十六期 综艺 恶搞 2015—专辑：《[Big笑工坊]官方专辑》','','tangtangshentucaozuinaocandemeishaonvBigxiaogongfangdijiushiliuqizongyiegao2015zhuanjiBigxiaogongfangguanfangzhuanji','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462818519.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','377','0','0','0','0','0','0','10.0','790','79','1457668891','1457668891','0','0','唐唐神吐槽：最脑残的美少女【Big笑工坊】第九十六期 综艺 恶搞 2015—专辑：《【Big笑工坊】官方专辑》','youku','0','','XODg3NTM1NDg0','','','','');
INSERT INTO `mac_vod` VALUES('79','[轻松时刻]看脸社会里 逗比的生存指南—专辑：《发现生活笑点，感受[轻松时刻]！》','','qingsongshikekanlianshehuilidoubideshengcunzhinanzhuanjifaxianshenghuoxiaodianganshouqingsongshike','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446281953.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','836','0','0','0','0','0','0','5.0','1555','311','1457668891','1457668891','0','0','【轻松时刻】看脸社会里 逗比的生存指南—专辑：《发现生活笑点，感受【轻松时刻】！》','youku','0','','XODg3NTI3MjMy','','','','');
INSERT INTO `mac_vod` VALUES('80','[内涵播报35]女神亲授省钱秘诀，万万没想到！—专辑：《内涵播报》','','nahanbobao35nvshenqinshoushengqianmijuewanwanmeixiangdaozhuanjinahanbobao','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446281997.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','502','0','0','0','0','0','0','8.0','1016','127','1457668891','1457668891','0','0','【内涵播报35】女神亲授省钱秘诀，万万没想到！—专辑：《内涵播报》','youku','0','','XODg3MjQwODg0','','','','');
INSERT INTO `mac_vod` VALUES('81','《名侦探狄仁杰》2月25日优酷全球首映 先导篇曝光','','mingzhentandirenjie2yue25riyoukuquanqiushouyingxiandaopianpuguang','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462796018.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','153','0','0','0','0','0','0','2.0','790','395','1457668902','1457668902','0','0','《名侦探狄仁杰》2月25日优酷全球首映 先导篇曝光','youku','0','','XODkwODY0MTYw','','','','');
INSERT INTO `mac_vod` VALUES('82','[内涵播报36]笑尿！男演员的哭戏竟如此蛋疼！—专辑：《内涵播报》','','nahanbobao36xiaoniaonanyanyuandekuxijingrucidantengzhuanjinahanbobao','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446279713.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','219','0','0','0','0','0','0','4.0','40','10','1457668902','1457668902','0','0','【内涵播报36】笑尿！男演员的哭戏竟如此蛋疼！—专辑：《内涵播报》','youku','0','','XODkwNjIwNjI0','','','','');
INSERT INTO `mac_vod` VALUES('83','[飞碟一分钟]一分钟告诉你人为什么会做噩梦—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhonggaosunirenweishimehuizuoemengzhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446279756.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','132','0','0','0','0','0','0','2.0','778','389','1457668902','1457668902','0','0','【飞碟一分钟】一分钟告诉你人为什么会做噩梦—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XODkwMjU5NDgw','','','','');
INSERT INTO `mac_vod` VALUES('84','剑少兮风云系列05：春劫风云—专辑：《[优酷牛人]剑少兮创意恶搞合辑，犀利与搞笑并重！》','','jianshaoxifengyunxilie05chunjiefengyunzhuanjiyoukuniurenjianshaoxichuangyiegaohejixiliyugaoxiaobingzhong','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462797912.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','115','0','0','0','0','0','0','3.0','1272','424','1457668902','1457668902','0','0','剑少兮风云系列05：春劫风云—专辑：《【优酷牛人】剑少兮创意恶搞合辑，犀利与搞笑并重！》','youku','0','','XODk0MjA5Mjk2','','','','');
INSERT INTO `mac_vod` VALUES('85','小黄人吐槽：最性感变女郎撕逼最丑忍者龟 《笑点研究所》33期—专辑：《[笑点研究所]小黄人毒舌神吐槽！》','','xiaohuangrentucaozuixingganbiannvlangsibizuichourenzheguixiaodianyanjiusuo33qizhuanjixiaodianyanjiusuoxiaohuangrendusheshentucao','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462798818.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','609','0','0','0','0','0','0','5.0','1835','367','1457668902','1457668902','0','0','小黄人吐槽：最性感变女郎撕逼最丑忍者龟 《笑点研究所》33期—专辑：《【笑点研究所】小黄人毒舌神吐槽！》','youku','0','','XODkzMTQ1ODI0','','','','');
INSERT INTO `mac_vod` VALUES('86','老陕说穿帮：第23期 盘点《千金女贼》穿帮镜头—专辑：《老陕说穿帮》','','laoshanshuochuanbangdi23qipandianqianjinnvzeichuanbangjingtouzhuanjilaoshanshuochuanbang','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446279961.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','525','0','0','0','0','0','0','5.0','2270','454','1457668902','1457668902','0','0','老陕说穿帮：第23期 盘点《千金女贼》穿帮镜头—专辑：《老陕说穿帮》','youku','0','','XODkyNDk0NjYw','','','','');
INSERT INTO `mac_vod` VALUES('87','情人节必干事儿—专辑：《2015年逗比搞笑情人节集锦合辑》','','qingrenjiebiganshierzhuanji2015niandoubigaoxiaoqingrenjiejijinheji','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446280037.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','491','0','0','0','0','0','0','6.0','186','31','1457668902','1457668902','0','0','情人节必干事儿—专辑：《2015年逗比搞笑情人节集锦合辑》','youku','0','','XODkyMjg1NTIw','','','','');
INSERT INTO `mac_vod` VALUES('88','[欧子最吐槽68]星爷版《单身狗歌2015》献给情人节单身狗们！—专辑：《2015年逗比搞笑情人节集锦合辑》','','ouzizuitucao68xingyebandanshengouge2015xiangeiqingrenjiedanshengoumenzhuanji2015niandoubigaoxiaoqingrenjiejijinheji','O','','http://www.egao8.cc/upload/vod/2015-10-12/144462800710.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','105','0','0','0','0','0','0','1.0','178','178','1457668902','1457668902','0','0','【欧子最吐槽68】星爷版《单身狗歌2015》献给情人节单身狗们！—专辑：《2015年逗比搞笑情人节集锦合辑》','youku','0','','XODkyOTY4MDM2','','','','');
INSERT INTO `mac_vod` VALUES('89','[暴走看啥片儿第二季]11 年终特别企划&mdash;&mdash;2014年度最具性价比电影盘点—专辑：《暴走漫画帮你捡节操！暴走小课','','baozoukanshapianerdierji11nianzhongtebieqihuamdashmdash2014nianduzuijuxingjiabidianyingpandianzhuanjibaozoumanhuabangnijianjiecaobaozouxiaoke','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462801014.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','183','0','0','0','0','0','0','10.0','3350','335','1457668902','1457668902','0','0','【暴走看啥片儿第二季】11 年终特别企划&mdash;&mdash;2014年度最具性价比电影盘点—专辑：《暴走漫画帮你捡节操！暴走小课','youku','0','','XODkyOTM2MDY0','','','','');
INSERT INTO `mac_vod` VALUES('90','看完這個惡作劇，再也沒有人敢酒後駕車了！—专辑：《超级欠扁！整蛊恶作剧第二弹！》','','kanwanzuozaiyeyourenganjiuhouliaozhuanjichaojiqianbianzhengguezuojudierdan','K','','http://www.egao8.cc/upload/vod/2015-10-12/144462801318.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','10','0','0','0','0','0','0','6.0','2550','425','1457668902','1457668902','0','0','看完這個惡作劇，再也沒有人敢酒後駕車了！—专辑：《超级欠扁！整蛊恶作剧第二弹！》','youku','0','','XODkyMzU3MTI0','','','','');
INSERT INTO `mac_vod` VALUES('91','《汽车洋葱圈》第十一期 春节回家 路上你可别尿了—专辑：《汽车洋葱圈搞笑吐槽系列节目》','','qicheyangcongquandishiyiqichunjiehuijialushangnikebieniaoliaozhuanjiqicheyangcongquangaoxiaotucaoxiliejiemu','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446280233.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','592','0','0','0','0','0','0','2.0','964','482','1457668902','1457668902','0','0','《汽车洋葱圈》第十一期 春节回家 路上你可别尿了—专辑：《汽车洋葱圈搞笑吐槽系列节目》','youku','0','','XODkyMDY0MzAw','','','','');
INSERT INTO `mac_vod` VALUES('92','致命遇险一百种自救[四]—专辑：《郑云原创搞笑短片经典大合辑》','','zhimingyuxianyibaizhongzijiusizhuanjizhengyunyuanchuanggaoxiaoduanpianjingdiandaheji','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446280277.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','899','0','0','0','0','0','0','1.0','273','273','1457668902','1457668902','0','0','致命遇险一百种自救（四）—专辑：《郑云原创搞笑短片经典大合辑》','youku','0','','XODkxOTE4NTk2','','','','');
INSERT INTO `mac_vod` VALUES('93','亮瞎 闺蜜吵架快速和好秘诀 37','','liangxiaguimichaojiakuaisuhehaomijue37','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462803312.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','123','0','0','0','0','0','0','9.0','3825','425','1457668902','1457668902','0','0','亮瞎 闺蜜吵架快速和好秘诀 37','youku','0','','XODkxOTkwOTA4','','','','');
INSERT INTO `mac_vod` VALUES('94','曾经想火 第二季：第07集—专辑：《《曾经想火》第二季》','','zengjingxianghuodierjidi07jizhuanjizengjingxianghuodierji','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462804116.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','926','0','0','0','0','0','0','10.0','490','49','1457668902','1457668902','0','0','曾经想火 第二季：第07集—专辑：《《曾经想火》第二季》','youku','0','','XODg5ODkwMDA4','','','','');
INSERT INTO `mac_vod` VALUES('95','唐唐神吐槽：最具槽点的大片[Big笑工坊]第九十七期 2015 综艺 脱口秀—专辑：《[Big笑工坊]官方专辑》','','tangtangshentucaozuijucaodiandedapianBigxiaogongfangdijiushiqiqi2015zongyituokouxiuzhuanjiBigxiaogongfangguanfangzhuanji','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446280521.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','685','0','0','0','0','0','0','4.0','1464','366','1457668902','1457668902','0','0','唐唐神吐槽：最具槽点的大片【Big笑工坊】第九十七期 2015 综艺 脱口秀—专辑：《【Big笑工坊】官方专辑》','youku','0','','XODkyMzAxOTI4','','','','');
INSERT INTO `mac_vod` VALUES('96','[失败盘点]傻缺失败出糗[第二十八期]—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','','shibaipandianshaqueshibaichuqiudiershibaqizhuanjibeijushaquegaoxiaoqiqushibaidiaobaoshipinjijindisandan','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446280565.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','748','0','0','0','0','0','0','4.0','1328','332','1457668902','1457668902','0','0','【失败盘点】傻缺失败出糗（第二十八期）—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','youku','0','','XODkwODY1MTA4','','','','');
INSERT INTO `mac_vod` VALUES('97','[胡言狼语]第二期：单身狗的情人节该怎么过？—专辑：《[优酷搞笑牛人]胡狼恶搞原创经典作品合辑》','','huyanlangyudierqidanshengoudeqingrenjiegaizenmeguozhuanjiyoukugaoxiaoniurenhulangegaoyuanchuangjingdianzuopinheji','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446280619.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','681','0','0','0','0','0','0','4.0','1040','260','1457668902','1457668902','0','0','【胡言狼语】第二期：单身狗的情人节该怎么过？—专辑：《【优酷搞笑牛人】胡狼恶搞原创经典作品合辑》','youku','0','','XODkxNDk5NDEy','','','','');
INSERT INTO `mac_vod` VALUES('98','[飞碟一分钟]一分钟教你初次见家长怎么办—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaonichucijianjiachangzenmebanzhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462806714.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','521','0','0','0','0','0','0','8.0','3600','450','1457668902','1457668902','0','0','【飞碟一分钟】一分钟教你初次见家长怎么办—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XODkwOTMxMDY0','','','','');
INSERT INTO `mac_vod` VALUES('99','[飞碟说]反逼婚攻防战—专辑：《『飞碟说 』创意动画趣味科普热点视频精彩选集》','','feidieshuofanbihungongfangzhanzhuanjifeidieshuochuangyidonghuaquweikepuredianshipinjingcaixuanji','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462807418.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','20','0','0','0','0','0','0','3.0','927','309','1457668902','1457668902','0','0','【飞碟说】反逼婚攻防战—专辑：《『飞碟说 』创意动画趣味科普热点视频精彩选集》','youku','0','','XODkxNTg3MDMy','','','','');
INSERT INTO `mac_vod` VALUES('100','小三儿当街对峙：我睡了你男票！—专辑：《[笑吧]最新最热最有趣整蛊恶搞失败集锦！》','','xiaosanerdangjieduizhiwoshuiliaoninanpiaozhuanjixiaobazuixinzuirezuiyouquzhengguegaoshibaijijin','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446280853.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','901','0','0','0','0','0','0','2.0','962','481','1457668902','1457668902','0','0','小三儿当街对峙：我睡了你男票！—专辑：《【笑吧】最新最热最有趣整蛊恶搞失败集锦！》','youku','0','','XODg5OTEzMTQ0','','','','');
INSERT INTO `mac_vod` VALUES('101','[飞碟一分钟]一分钟教你过情人节省钱又浪漫—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaoniguoqingrenjieshengqianyoulangmanzhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446278552.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','106','0','0','0','0','0','0','9.0','4203','467','1457668914','1457668914','0','0','【飞碟一分钟】一分钟教你过情人节省钱又浪漫—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XODkyMzE0ODI4','','','','');
INSERT INTO `mac_vod` VALUES('102','《大中华皇家至尊男友租赁中心》：新年新气象，服务全升级—专辑：《[马马虎虎]老外告诉你的那些事儿》','','dazhonghuahuangjiazhizunnanyouzulinzhongxinxinnianxinqixiangfuwuquanshengjizhuanjimamahuhulaowaigaosunidenaxieshier','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446278606.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','45','0','0','0','0','0','0','3.0','759','253','1457668914','1457668914','0','0','《大中华皇家至尊男友租赁中心》：新年新气象，服务全升级—专辑：《【马马虎虎】老外告诉你的那些事儿》','youku','0','','XODk0MTgwODI0','','','','');
INSERT INTO `mac_vod` VALUES('103','学校里的疯子 第四季 第十二集 当情人节礼物被误吞后—专辑：《[向尚飞影视传媒]爆笑校园短剧+街采神回复》','','xuexiaolidefengzidisijidishierjidangqingrenjieliwubeiwutunhouzhuanjixiangshangfeiyingshichuanmeibaoxiaoxiaoyuanduanjujiecaishenhuifu','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462786311.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','847','0','0','0','0','0','0','3.0','1308','436','1457668914','1457668914','0','0','学校里的疯子 第四季 第十二集 当情人节礼物被误吞后—专辑：《【向尚飞影视传媒】爆笑校园短剧+街采神回复》','youku','0','','XODkxNzk5MjA4','','','','');
INSERT INTO `mac_vod` VALUES('104','[吟笑派]春节相亲忙！剩女教你逼婚&ldquo;求生第一计&rdquo;！—专辑：《[搞笑牛人]吟笑派创意恶搞视频合辑》','','yinxiaopaichunjiexiangqinmangshengnvjiaonibihunldquoqiushengdiyijirdquozhuanjigaoxiaoniurenyinxiaopaichuangyiegaoshipinheji','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462786715.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','609','0','0','0','0','0','0','9.0','3105','345','1457668914','1457668914','0','0','【吟笑派】春节相亲忙！剩女教你逼婚&ldquo;求生第一计&rdquo;！—专辑：《【搞笑牛人】吟笑派创意恶搞视频合辑》','youku','0','','XODk0Mjk1MjI4','','','','');
INSERT INTO `mac_vod` VALUES('105','[飞碟唱]水瓶座之歌—专辑：《[飞碟唱]》','','feidiechangshuipingzuozhigezhuanjifeidiechang','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462787018.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','649','0','0','0','0','0','0','4.0','680','170','1457668914','1457668914','0','0','【飞碟唱】水瓶座之歌—专辑：《【飞碟唱】》','youku','0','','XODkwOTExNzUy','','','','');
INSERT INTO `mac_vod` VALUES('106','恶搞新春各种逼—专辑：《[优酷牛人]剑少兮创意恶搞合辑，犀利与搞笑并重！》','','egaoxinchungezhongbizhuanjiyoukuniurenjianshaoxichuangyiegaohejixiliyugaoxiaobingzhong','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446278813.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','750','0','0','0','0','0','0','7.0','588','84','1457668914','1457668914','0','0','恶搞新春各种逼—专辑：《【优酷牛人】剑少兮创意恶搞合辑，犀利与搞笑并重！》','youku','0','','XODkyMjU2NjA0','','','','');
INSERT INTO `mac_vod` VALUES('107','[每日一囧453]无法拒绝的表白方式—专辑：《[每日一囧]2014再战江湖第二弹！》','','meiriyi453wufajujuedebiaobaifangshizhuanjimeiriyi2014zaizhanjianghudierdan','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446278846.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','417','0','0','0','0','0','0','6.0','2226','371','1457668914','1457668914','0','0','【每日一囧453】无法拒绝的表白方式—专辑：《【每日一囧】2014再战江湖第二弹！》','youku','0','','XODkwNzkwNDQ0','','','','');
INSERT INTO `mac_vod` VALUES('108','[每日一囧454]情人节胖子求婚的独特技能—专辑：《[每日一囧]2014再战江湖第二弹！》','','meiriyi454qingrenjiepangziqiuhundedutejinenzhuanjimeiriyi2014zaizhanjianghudierdan','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446278868.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','122','0','0','0','0','0','0','7.0','343','49','1457668914','1457668914','0','0','【每日一囧454】情人节胖子求婚的独特技能—专辑：《【每日一囧】2014再战江湖第二弹！》','youku','0','','XODkyMTAzMDUy','','','','');
INSERT INTO `mac_vod` VALUES('109','过年相亲太频繁 妹子眩晕呕吐[囧闻一箩筐]—专辑：《[何仙姑夫]囧闻一箩筐》','','guonianxiangqintaipinfanmeizixuanyunoutuwenyiluokuangzhuanjihexiangufuwenyiluokuang','G','','http://www.egao8.cc/upload/vod/2015-10-12/144462789813.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','558','0','0','0','0','0','0','4.0','1976','494','1457668914','1457668914','0','0','过年相亲太频繁 妹子眩晕呕吐【囧闻一箩筐】—专辑：《【何仙姑夫】囧闻一箩筐》','youku','0','','XODkxMzg1MTk2','','','','');
INSERT INTO `mac_vod` VALUES('110','女神の动物园第45期：喵星人爱上韩剧女主角—专辑：《女神+萌宠的爆笑组合！女神の动物园》','','nvshendongwuyuandi45qimiaoxingrenaishanghanjunvzhujiaozhuanjinvshenmengchongdebaoxiaozuhenvshendongwuyuan','N','','http://www.egao8.cc/upload/vod/2015-10-12/144462790317.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','884','0','0','0','0','0','0','4.0','268','67','1457668914','1457668914','0','0','女神の动物园第45期：喵星人爱上韩剧女主角—专辑：《女神+萌宠的爆笑组合！女神の动物园》','youku','0','','XODkzNjQwNTU2','','','','');
INSERT INTO `mac_vod` VALUES('111','[飞碟一分钟]一分钟告诉你男人最讨厌的五类女人—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhonggaosuninanrenzuitaoyandewuleinvrenzhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446279111.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','978','0','0','0','0','0','0','3.0','720','240','1457668914','1457668914','0','0','【飞碟一分钟】一分钟告诉你男人最讨厌的五类女人—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XODkxNjA2Nzg0','','','','');
INSERT INTO `mac_vod` VALUES('112','分分钟涨姿势第十六期：好看的翘臀都有哪些用？—专辑：《[分分钟涨姿势]姿势就是力量》','','fenfenzhongzhangzishidishiliuqihaokandeqiaotunduyounaxieyongzhuanjifenfenzhongzhangzishizishijiushililiang','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446279155.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','690','0','0','0','0','0','0','9.0','1953','217','1457668914','1457668914','0','0','分分钟涨姿势第十六期：好看的翘臀都有哪些用？—专辑：《【分分钟涨姿势】姿势就是力量》','youku','0','','XODkyNDk3NTcy','','','','');
INSERT INTO `mac_vod` VALUES('113','我访你话 第二十四期 粉丝可以成就一个明星也可以毁了一个明星—专辑：《[向尚飞影视传媒]爆笑校园短剧+街采神回复》','','wofangnihuadiershisiqifensikeyichengjiuyigemingxingyekeyihuiliaoyigemingxingzhuanjixiangshangfeiyingshichuanmeibaoxiaoxiaoyuanduanjujiecaishenhuifu','W','','http://www.egao8.cc/upload/vod/2015-10-12/14446279209.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','85','0','0','0','0','0','0','10.0','630','63','1457668914','1457668914','0','0','我访你话 第二十四期 粉丝可以成就一个明星也可以毁了一个明星—专辑：《【向尚飞影视传媒】爆笑校园短剧+街采神回复》','youku','0','','XODkxMTAzMDIw','','','','');
INSERT INTO `mac_vod` VALUES('114','金灶沐：《新春联播》 年底那些事儿—专辑：《[优酷牛人]金灶沐恶搞配音系列》','','jinzaomuxinchunlianboniandinaxieshierzhuanjiyoukuniurenjinzaomuegaopeiyinxilie','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462792713.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','697','0','0','0','0','0','0','6.0','1962','327','1457668914','1457668914','0','0','金灶沐：《新春联播》 年底那些事儿—专辑：《【优酷牛人】金灶沐恶搞配音系列》','youku','0','','XODkyNjg3Njgw','','','','');
INSERT INTO `mac_vod` VALUES('115','母牛群狮口下勇救小牛—专辑：《对这个动物比人类还会卖萌的世界绝望鸟！》','','muniuqunshikouxiayongjiuxiaoniuzhuanjiduizhegedongwubirenleihuaihuimaimengdeshijiejuewangniao','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462793217.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','782','0','0','0','0','0','0','9.0','1503','167','1457668914','1457668914','0','0','母牛群狮口下勇救小牛—专辑：《对这个动物比人类还会卖萌的世界绝望鸟！》','youku','0','','XODkxNjI5Mzcy','','','','');
INSERT INTO `mac_vod` VALUES('116','[暴走敖尼玛]02 敖尼玛口爆鸟叔牌薯片—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','','baozouaonima02aonimakoubaoniaoshupaishupianzhuanjibaozoumanhuabangnijianjiecaobaozouxiaoketangkanshapianerdoubizhelianmeng','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446279432.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','562','0','0','0','0','0','0','6.0','2856','476','1457668914','1457668914','0','0','【暴走敖尼玛】02 敖尼玛口爆鸟叔牌薯片—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','youku','0','','XODkxMDMzNTI4','','','','');
INSERT INTO `mac_vod` VALUES('117','杨幂、唐嫣、刘诗诗等齐上场，看ab等小花旦大PK如何接班四大花旦  ！—专辑：《[搞笑牛人]吟笑派创意恶搞视频合辑》','','yangmitangyanliushishidengqishangchangkanabdengxiaohuadandaPKruhejiebansidahuadanzhuanjigaoxiaoniurenyinxiaopaichuangyiegaoshipinheji','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446279465.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','478','0','0','0','0','0','0','6.0','30','5','1457668914','1457668914','0','0','杨幂、唐嫣、刘诗诗等齐上场，看ab等小花旦大PK如何接班四大花旦  ！—专辑：《【搞笑牛人】吟笑派创意恶搞视频合辑》','youku','0','','XODkyMDc4MjU2','','','','');
INSERT INTO `mac_vod` VALUES('118','[笑料百出]第41期 情人节后十大奇葩分手理由—专辑：《畅所欲言！笑料百出！》','','xiaoliaobaichudi41qiqingrenjiehoushidaqipafenshouliyouzhuanjichangsuoyuyanxiaoliaobaichu','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462795110.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','441','0','0','0','0','0','0','4.0','1960','490','1457668914','1457668914','0','0','【笑料百出】第41期 情人节后十大奇葩分手理由—专辑：《畅所欲言！笑料百出！》','youku','0','','XODk0MjI1NzQ4','','','','');
INSERT INTO `mac_vod` VALUES('119','大案力作：2015羊年美国春晚—专辑：《搞笑牛人：大案命案要案在身经典合辑》','','daanlizuo2015yangnianmeiguochunwanzhuanjigaoxiaoniurendaanminganyaoanzaishenjingdianheji','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462795111.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','79','0','0','0','0','0','0','4.0','1112','278','1457668914','1457668914','0','0','大案力作：2015羊年美国春晚—专辑：《搞笑牛人：大案命案要案在身经典合辑》','youku','0','','XODkwOTkxNjc2','','','','');
INSERT INTO `mac_vod` VALUES('120','[欧子最吐槽67]《汪妃》汪峰头条老婆都有了！！！—专辑：《[优酷牛人] 恶搞先锋欧子歪歌优秀作品大合辑》','','ouzizuitucao67wangfeiwangfengtoutiaolaopoduyouliaozhuanjiyoukuniurenegaoxianfengouziwaigeyouxiuzuopindaheji','O','','http://www.egao8.cc/upload/vod/2015-10-12/144462795615.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','989','0','0','0','0','0','0','1.0','449','449','1457668914','1457668914','0','0','【欧子最吐槽67】《汪妃》汪峰头条老婆都有了！！！—专辑：《【优酷牛人】 恶搞先锋欧子歪歌优秀作品大合辑》','youku','0','','XODkwOTI3NjQ4','','','','');
INSERT INTO `mac_vod` VALUES('121','[胡言狼语]第五期：同学聚会到底该不该去—专辑：《[优酷搞笑牛人]胡狼恶搞原创经典作品合辑》','','huyanlangyudiwuqitongxuejuhuidaodigaibugaiquzhuanjiyoukugaoxiaoniurenhulangegaoyuanchuangjingdianzuopinheji','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462772715.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','989','0','0','0','0','0','0','2.0','884','442','1457669005','1457669005','0','0','【胡言狼语】第五期：同学聚会到底该不该去—专辑：《【优酷搞笑牛人】胡狼恶搞原创经典作品合辑》','youku','0','','XOTA5NzYwNzk2','','','','');
INSERT INTO `mac_vod` VALUES('122','每周星座09-最容易失财失色的星座—专辑：《[优酷牛人]秀策坊动画黑星座系列》','','meizhouxingzuo09zuirongyishicaishisedexingzuozhuanjiyoukuniurenxiucefangdonghuaheixingzuoxilie','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446277391.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','364','0','0','0','0','0','0','2.0','360','180','1457669005','1457669005','0','0','每周星座09-最容易失财失色的星座—专辑：《【优酷牛人】秀策坊动画黑星座系列》','youku','0','','XOTA4MzIyNDEy','','','','');
INSERT INTO `mac_vod` VALUES('123','惊呆！大妈装少女骗得30万[唐唐脱口秀]第40期—专辑：《[唐唐脱口秀]官方专辑》','','jingdaidamazhuangshaonvpiande30wantangtangtuokouxiudi40qizhuanjitangtangtuokouxiuguanfangzhuanji','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446277456.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','117','0','0','0','0','0','0','3.0','594','198','1457669005','1457669005','0','0','惊呆！大妈装少女骗得30万【唐唐脱口秀】第40期—专辑：《【唐唐脱口秀】官方专辑》','youku','0','','XOTA4Njg1NDYw','','','','');
INSERT INTO `mac_vod` VALUES('124','China Town 第一集 《鸡蛋萌萌哒一》误将卤水当冰 毒，惊动联合球。—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','','ChinaTowndiyijijidanmengmengdayiwujianglushuidangbingdujingdonglianheqiuzhuanjiduanjuyefengkuangbaoxiaopandianjingcaiduanju','C','','http://www.egao8.cc/upload/vod/2015-10-12/144462774910.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','221','0','0','0','0','0','0','7.0','1834','262','1457669005','1457669005','0','0','China Town 第一集 《鸡蛋萌萌哒一》误将卤水当冰 毒，惊动联合球。—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','youku','0','','XOTA4NTYxMTg4','','','','');
INSERT INTO `mac_vod` VALUES('125','致命遇险一百种自救[六]—专辑：《郑云原创搞笑短片经典大合辑》','','zhimingyuxianyibaizhongzijiuliuzhuanjizhengyunyuanchuanggaoxiaoduanpianjingdiandaheji','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462775414.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','868','0','0','0','0','0','0','3.0','1500','500','1457669005','1457669005','0','0','致命遇险一百种自救（六）—专辑：《郑云原创搞笑短片经典大合辑》','youku','0','','XOTA4MTA5ODQw','','','','');
INSERT INTO `mac_vod` VALUES('126','[飞碟一分钟]一分钟教你如何对别人Say No—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaoniruheduibierenSayNozhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462775918.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','717','0','0','0','0','0','0','2.0','46','23','1457669005','1457669005','0','0','【飞碟一分钟】一分钟教你如何对别人Say No—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XOTA4Njc0NTQ4','','','','');
INSERT INTO `mac_vod` VALUES('127','[怪咖搞笑]三妹子疯癫演绎皇后乐团的波西米亚狂想曲—专辑：《这里有彪悍女汉子，也有萌妹纸！》','','guaikagaoxiaosanmeizifengdianyanyihuanghouletuandeboximiyakuangxiangquzhuanjizheliyoubiaohannvhanziyeyoumengmeizhi','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446277683.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','147','0','0','0','0','0','0','6.0','306','51','1457669005','1457669005','0','0','【怪咖搞笑】三妹子疯癫演绎皇后乐团的波西米亚狂想曲—专辑：《这里有彪悍女汉子，也有萌妹纸！》','youku','0','','XOTA4MTY0Mjc2','','','','');
INSERT INTO `mac_vod` VALUES('128','屌丝年薪千万的秘诀[李韬爆笑生活69]—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','','sinianxinqianwandemijuelitaobaoxiaoshenghuo69zhuanjiduanjuyefengkuangbaoxiaopandianjingcaiduanju','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446277727.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','507','0','0','0','0','0','0','7.0','280','40','1457669005','1457669005','0','0','屌丝年薪千万的秘诀（李韬爆笑生活69）—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','youku','0','','XOTA2ODA5MzEy','','','','');
INSERT INTO `mac_vod` VALUES('129','小品恶搞《备胎的春节》—专辑：《[小飞酱编剧]恶搞配音全集》','','xiaopinegaobeitaidechunjiezhuanjixiaofeijiangbianjuegaopeiyinquanji','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462777811.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','363','0','0','0','0','0','0','10.0','3040','304','1457669005','1457669005','0','0','小品恶搞《备胎的春节》—专辑：《【小飞酱编剧】恶搞配音全集》','youku','0','','XOTA2OTMxMzc2','','','','');
INSERT INTO `mac_vod` VALUES('130','[飞碟唱]金牛座之歌—专辑：《[飞碟唱]》','','feidiechangjinniuzuozhigezhuanjifeidiechang','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462778315.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','749','0','0','0','0','0','0','7.0','994','142','1457669005','1457669005','0','0','【飞碟唱】金牛座之歌—专辑：《【飞碟唱】》','youku','0','','XOTA0MjgwODA4','','','','');
INSERT INTO `mac_vod` VALUES('131','打招呼才发现认错人该怎么办？网友列10招化解尴尬','','dazhaohucaifaxianrencuorengaizenmebanwangyoulie10zhaohuajieganga','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446277962.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','420','0','0','0','0','0','0','8.0','3704','463','1457669005','1457669005','0','0','打招呼才发现认错人该怎么办？网友列10招化解尴尬','youku','0','','XODk3MDg4Mjky','','','','');
INSERT INTO `mac_vod` VALUES('132','胥渡吧：春节防逼婚指南—专辑：《胥渡吧恶搞配音经典合辑》','','xudubachunjiefangbihunzhinanzhuanjixudubaegaopeiyinjingdianheji','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446278016.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','98','0','0','0','0','0','0','3.0','1224','408','1457669005','1457669005','0','0','胥渡吧：春节防逼婚指南—专辑：《胥渡吧恶搞配音经典合辑》','youku','0','','XODk1OTk1NDAw','','','','');
INSERT INTO `mac_vod` VALUES('133','[奇趣盘点]一周搞笑奇趣视频集锦[第五十期]—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','','qiqupandianyizhougaoxiaoqiqushipinjijindiwushiqizhuanjibeijushaquegaoxiaoqiqushibaidiaobaoshipinjijindisandan','Q','','http://www.egao8.cc/upload/vod/2015-10-12/144462781113.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','725','0','0','0','0','0','0','6.0','2880','480','1457669005','1457669005','0','0','【奇趣盘点】一周搞笑奇趣视频集锦（第五十期）—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','youku','0','','XODkyNzY4Mjg0','','','','');
INSERT INTO `mac_vod` VALUES('134','胥渡吧：群侠过大年！容嬷嬷蹭年夜饭，白蛇看春晚。—专辑：《胥渡吧恶搞配音经典合辑》','','xudubaqunxiaguodanianrongmamacengnianyefanbaishekanchunwanzhuanjixudubaegaopeiyinjingdianheji','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462781114.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','711','0','0','0','0','0','0','9.0','1476','164','1457669005','1457669005','0','0','胥渡吧：群侠过大年！容嬷嬷蹭年夜饭，白蛇看春晚。—专辑：《胥渡吧恶搞配音经典合辑》','youku','0','','XODk1NDgzMzMy','','','','');
INSERT INTO `mac_vod` VALUES('135','唐唐脱口秀：春节&ldquo;终极大招&rdquo;[唐唐脱口秀]第三十七期—专辑：《[唐唐脱口秀]官方专辑》','','tangtangtuokouxiuchunjieldquozhongjidazhaordquotangtangtuokouxiudisanshiqiqizhuanjitangtangtuokouxiuguanfangzhuanji','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462781115.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','185','0','0','0','0','0','0','9.0','522','58','1457669005','1457669005','0','0','唐唐脱口秀：春节&ldquo;终极大招&rdquo;【唐唐脱口秀】第三十七期—专辑：《【唐唐脱口秀】官方专辑》','youku','0','','XODk0OTEyMDY0','','','','');
INSERT INTO `mac_vod` VALUES('136','天哪！你们家宝宝掉水里了！—专辑：《[笑吧]最新最热最有趣整蛊恶搞失败集锦！》','','tiannanimenjiabaobaodiaoshuililiaozhuanjixiaobazuixinzuirezuiyouquzhengguegaoshibaijijin','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462781518.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','244','0','0','0','0','0','0','7.0','3430','490','1457669005','1457669005','0','0','天哪！你们家宝宝掉水里了！—专辑：《【笑吧】最新最热最有趣整蛊恶搞失败集锦！》','youku','0','','XODkyNzM1Mzk2','','','','');
INSERT INTO `mac_vod` VALUES('137','[飞碟一分钟]一分钟教你搞定衣服上的火锅味—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaonigaodingyifushangdehuoguoweizhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446278285.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','205','0','0','0','0','0','0','4.0','604','151','1457669005','1457669005','0','0','【飞碟一分钟】一分钟教你搞定衣服上的火锅味—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XODk0MjIwNDY0','','','','');
INSERT INTO `mac_vod` VALUES('138','[妹子说热剧]盘点春晚最牛钉子户 何仙姑夫工作室—专辑：《[优酷牛人]何仙姑夫爆笑原创恶搞经典合辑》','','meizishuorejupandianchunwanzuiniudingzihuhexiangufugongzuoshizhuanjiyoukuniurenhexiangufubaoxiaoyuanchuangegaojingdianheji','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446278349.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','853','0','0','0','0','0','0','1.0','214','214','1457669005','1457669005','0','0','【妹子说热剧】盘点春晚最牛钉子户 何仙姑夫工作室—专辑：《【优酷牛人】何仙姑夫爆笑原创恶搞经典合辑》','youku','0','','XODk0MDYyNTA0','','','','');
INSERT INTO `mac_vod` VALUES('139','[发现最热视频]美国熊孩子试吃各国早餐的反应—专辑：《超级欠扁！整蛊恶作剧第二弹！》','','faxianzuireshipinmeiguoxionghaizishichigeguozaocandefanyingzhuanjichaojiqianbianzhengguezuojudierdan','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462783813.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','692','0','0','0','0','0','0','4.0','1848','462','1457669005','1457669005','0','0','【发现最热视频】美国熊孩子试吃各国早餐的反应—专辑：《超级欠扁！整蛊恶作剧第二弹！》','youku','0','','XODkyNDc3NjM2','','','','');
INSERT INTO `mac_vod` VALUES('140','暴走每周精选06—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','','baozoumeizhoujingxuan06zhuanjibaozoumanhuabangnijianjiecaobaozouxiaoketangkanshapianerdoubizhelianmeng','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462784316.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','195','0','0','0','0','0','0','1.0','413','413','1457669005','1457669005','0','0','暴走每周精选06—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','youku','0','','XODkzOTkzNDAw','','','','');
INSERT INTO `mac_vod` VALUES('141','笑到爆!农村神剧!《追债之偷橘子续集》许华升作品!—专辑：《[优酷牛人]追债骚年许华升原创恶搞短片合辑》','','xiaodaobaonongcunshenjuzhuizhaizhitoujuzixujixuhuashengzuopinzhuanjiyoukuniurenzhuizhaisaonianxuhuashengyuanchuangegaoduanpianheji','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446276357.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','710','0','0','0','0','0','0','1.0','350','350','1457669017','1457669017','0','0','笑到爆!农村神剧!《追债之偷橘子续集》许华升作品!—专辑：《【优酷牛人】追债骚年许华升原创恶搞短片合辑》','youku','0','','XOTA0OTY2NTEy','','','','');
INSERT INTO `mac_vod` VALUES('142','[暴走敖尼玛]06外交体虾片，鸡鸡味嘎嘣脆—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','','baozouaonima06waijiaotixiapianjijiweigabengcuizhuanjibaozoumanhuabangnijianjiecaobaozouxiaoketangkanshapianerdoubizhelianmeng','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462763810.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','133','0','0','0','0','0','0','6.0','1350','225','1457669017','1457669017','0','0','【暴走敖尼玛】06外交体虾片，鸡鸡味嘎嘣脆—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','youku','0','','XOTA5MDk3NDc2','','','','');
INSERT INTO `mac_vod` VALUES('143','[飞碟一分钟]一分钟教你练出人鱼线—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaonilianchurenyuxianzhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462764214.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','43','0','0','0','0','0','0','7.0','287','41','1457669017','1457669017','0','0','【飞碟一分钟】一分钟教你练出人鱼线—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XOTA3OTU2MzQ4','','','','');
INSERT INTO `mac_vod` VALUES('144','《卧槽大片》第36期 吐槽封神榜2—专辑：《卧槽大片！吐得一手好槽！》','','wocaodapiandi36qitucaofengshenbang2zhuanjiwocaodapiantudeyishouhaocao','W','','http://www.egao8.cc/upload/vod/2015-10-12/144462764416.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','552','0','0','0','0','0','0','3.0','789','263','1457669017','1457669017','0','0','《卧槽大片》第36期 吐槽封神榜2—专辑：《卧槽大片！吐得一手好槽！》','youku','0','','XOTA3OTA2NjYw','','','','');
INSERT INTO `mac_vod` VALUES('145','一秒变大胸？    陈浩民现身教戏遇逗比  01—专辑：《各类爆笑迷你剧大集锦《逗比同事》》','','yimiaobiandaxiongchenhaominxianshenjiaoxiyudoubi01zhuanjigeleibaoxiaominijudajijindoubitongshi','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462764719.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','866','0','0','0','0','0','0','2.0','298','149','1457669017','1457669017','0','0','一秒变大胸？    陈浩民现身教戏遇逗比  01—专辑：《各类爆笑迷你剧大集锦《逗比同事》》','youku','0','','XOTAxMTE0NjQ4','','','','');
INSERT INTO `mac_vod` VALUES('146','3分鐘看完電影版《忐忑As above so below》—专辑：《[谷阿莫神解说]几分钟带你看完各种电影大片》','','3fenkanwanyingbankengdaoAsabovesobelowzhuanjiguamoshenjieshuojifenzhongdainikanwangezhongdianyingdapian','3','','http://www.egao8.cc/upload/vod/2015-10-12/14446276592.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','538','0','0','0','0','0','0','8.0','3056','382','1457669017','1457669017','0','0','3分鐘看完電影版《忐忑As above so below》—专辑：《【谷阿莫神解说】几分钟带你看完各种电影大片》','youku','0','','XOTA2NDQ0NTY0','','','','');
INSERT INTO `mac_vod` VALUES('147','暴走每周精选08—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','','baozoumeizhoujingxuan08zhuanjibaozoumanhuabangnijianjiecaobaozouxiaoketangkanshapianerdoubizhelianmeng','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446276625.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','711','0','0','0','0','0','0','10.0','1900','190','1457669017','1457669017','0','0','暴走每周精选08—专辑：《暴走漫画帮你捡节操！暴走小课堂、看啥片儿、逗逼者联盟》','youku','0','','XOTA4MDYzMzI0','','','','');
INSERT INTO `mac_vod` VALUES('148','女神の动物园第48期：史上最销魂大猩猩—专辑：《女神+萌宠的爆笑组合！女神の动物园》','','nvshendongwuyuandi48qishishangzuixiaohundaxingxingzhuanjinvshenmengchongdebaoxiaozuhenvshendongwuyuan','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446276647.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','374','0','0','0','0','0','0','10.0','4730','473','1457669017','1457669017','0','0','女神の动物园第48期：史上最销魂大猩猩—专辑：《女神+萌宠的爆笑组合！女神の动物园》','youku','0','','XOTA3MzU2ODQw','','','','');
INSERT INTO `mac_vod` VALUES('149','[胡言狼语]第四期：女人为什么有妇女节而男人没有—专辑：《[优酷搞笑牛人]胡狼恶搞原创经典作品合辑》','','huyanlangyudisiqinvrenweishimeyoufunvjieernanrenmeiyouzhuanjiyoukugaoxiaoniurenhulangegaoyuanchuangjingdianzuopinheji','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462766710.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','609','0','0','0','0','0','0','10.0','4290','429','1457669017','1457669017','0','0','【胡言狼语】第四期：女人为什么有妇女节而男人没有—专辑：《【优酷搞笑牛人】胡狼恶搞原创经典作品合辑》','youku','0','','XOTA2ODAyNTA4','','','','');
INSERT INTO `mac_vod` VALUES('150','[轻松时刻]一种好朋友才会对你做的事情—专辑：《发现生活笑点，感受[轻松时刻]！》','','qingsongshikeyizhonghaopengyoucaihuiduinizuodeshiqingzhuanjifaxianshenghuoxiaodianganshouqingsongshike','Q','','http://www.egao8.cc/upload/vod/2015-10-12/144462766912.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','841','0','0','0','0','0','0','7.0','1232','176','1457669017','1457669017','0','0','【轻松时刻】一种好朋友才会对你做的事情—专辑：《发现生活笑点，感受【轻松时刻】！》','youku','0','','XODk5MjEyMzI0','','','','');
INSERT INTO `mac_vod` VALUES('151','怪话：过年在家遇到老情人怎么办？[150220期]—专辑：《神回复牛人在此集结！凡人跪了~~~~》','','guaihuaguonianzaijiayudaolaoqingrenzenmeban150220qizhuanjishenhuifuniurenzaicijijiefanrenguiliao','G','','http://www.egao8.cc/upload/vod/2015-10-12/144462767215.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','90','0','0','0','0','0','0','6.0','2292','382','1457669017','1457669017','0','0','怪话：过年在家遇到老情人怎么办？【150220期】—专辑：《神回复牛人在此集结！凡人跪了~~~~》','youku','0','','XODk2MjI1NDY0','','','','');
INSERT INTO `mac_vod` VALUES('152','天津妞:年度最烂石敢duang—专辑：《[优酷牛人]司文痞子恶搞配音经典合辑》','','tianjinniunianduzuilanshiganduangzhuanjiyoukuniurensiwenpiziegaopeiyinjingdianheji','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462767518.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','220','0','0','0','0','0','0','1.0','382','382','1457669017','1457669017','0','0','天津妞:年度最烂石敢duang—专辑：《【优酷牛人】司文痞子恶搞配音经典合辑》','youku','0','','XOTA5OTc2NDQ4','','','','');
INSERT INTO `mac_vod` VALUES('153','胥渡吧：白蛇调查雾霾，唐僧穹顶之下duang一下！—专辑：《胥渡吧恶搞配音经典合辑》','','xudubabaishediaochawumaitangsengqiongdingzhixiaduangyixiazhuanjixudubaegaopeiyinjingdianheji','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446276821.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','187','0','0','0','0','0','0','7.0','2198','314','1457669017','1457669017','0','0','胥渡吧：白蛇调查雾霾，唐僧穹顶之下duang一下！—专辑：《胥渡吧恶搞配音经典合辑》','youku','0','','XOTAzMDE5Njcy','','','','');
INSERT INTO `mac_vod` VALUES('154','河南神曲《也是醉了》—专辑：《搞笑牛人：大案命案要案在身经典合辑》','','henanshenquyeshizuiliaozhuanjigaoxiaoniurendaanminganyaoanzaishenjingdianheji','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446276875.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','292','0','0','0','0','0','0','8.0','1856','232','1457669017','1457669017','0','0','河南神曲《也是醉了》—专辑：《搞笑牛人：大案命案要案在身经典合辑》','youku','0','','XOTEwMDk3MTg0','','','','');
INSERT INTO `mac_vod` VALUES('155','[麦兜找穿帮]《锦绣缘》穿帮镜头 何仙姑夫工作室—专辑：《热剧雷剧吐槽穿帮合辑！天雷滚滚，舍你其谁！》','','maidouzhaochuanbangjinxiuyuanchuanbangjingtouhexiangufugongzuoshizhuanjirejuleijutucaochuanbanghejitianleigungunsheniqishui','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446276887.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','430','0','0','0','0','0','0','8.0','1928','241','1457669017','1457669017','0','0','【麦兜找穿帮】《锦绣缘》穿帮镜头 何仙姑夫工作室—专辑：《热剧雷剧吐槽穿帮合辑！天雷滚滚，舍你其谁！》','youku','0','','XOTA5ODA4MTMy','','','','');
INSERT INTO `mac_vod` VALUES('156','[飞碟一分钟]一分钟教你快速处理开水烫伤—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaonikuaisuchulikaishuithengshangzhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462769312.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','339','0','0','0','0','0','0','9.0','1044','116','1457669017','1457669017','0','0','【飞碟一分钟】一分钟教你快速处理开水烫伤—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XOTEwMDk2OTM2','','','','');
INSERT INTO `mac_vod` VALUES('157','神曲《XI毒添新兵》吐槽王学兵—专辑：《[优酷牛人]咚哥唱谈经典系列合辑》','','shenquXIdutianxinbingtucaowangxuebingzhuanjiyoukuniurendonggechangtanjingdianxilieheji','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462769615.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','851','0','0','0','0','0','0','8.0','3432','429','1457669017','1457669017','0','0','神曲《XI毒添新兵》吐槽王学兵—专辑：《【优酷牛人】咚哥唱谈经典系列合辑》','youku','0','','XOTA5MzcxODgw','','','','');
INSERT INTO `mac_vod` VALUES('158','致命遇险一百种自救[七]—专辑：《郑云原创搞笑短片经典大合辑》','','zhimingyuxianyibaizhongzijiuqizhuanjizhengyunyuanchuanggaoxiaoduanpianjingdiandaheji','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446277114.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','142','0','0','0','0','0','0','1.0','175','175','1457669017','1457669017','0','0','致命遇险一百种自救（七）—专辑：《郑云原创搞笑短片经典大合辑》','youku','0','','XOTA5NDQwMjQw','','','','');
INSERT INTO `mac_vod` VALUES('159','[内涵播报40]女友独自在家，男友竟然这样做！—专辑：《内涵播报》','','nahanbobao40nvyouduzizaijiananyoujingranzheyangzuozhuanjinahanbobao','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446277136.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','981','0','0','0','0','0','0','9.0','3537','393','1457669017','1457669017','0','0','【内涵播报40】女友独自在家，男友竟然这样做！—专辑：《内涵播报》','youku','0','','XOTA5MDc3NTIw','','','','');
INSERT INTO `mac_vod` VALUES('160','傻缺奇趣视频合辑[第六十八期]—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','','shaqueqiqushipinhejidiliushibaqizhuanjibeijushaquegaoxiaoqiqushibaidiaobaoshipinjijindisandan','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462772211.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','982','0','0','0','0','0','0','6.0','1794','299','1457669017','1457669017','0','0','傻缺奇趣视频合辑(第六十八期)—专辑：《杯具傻缺搞笑奇趣失败碉堡视频集锦第三弹！》','youku','0','','XOTA2MzgxNTA0','','','','');
INSERT INTO `mac_vod` VALUES('161','7分鐘看完《速度與激情1-6》—专辑：《[谷阿莫神解说]几分钟带你看完各种电影大片》','','7fenkanwansudujiqing16zhuanjiguamoshenjieshuojifenzhongdainikanwangezhongdianyingdapian','7','','http://www.egao8.cc/upload/vod/2015-10-12/14446275441.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','52','0','0','0','0','0','0','6.0','2664','444','1457669028','1457669028','0','0','7分鐘看完《速度與激情1-6》—专辑：《【谷阿莫神解说】几分钟带你看完各种电影大片》','youku','0','','XOTEwNTkzNDI4','','','','');
INSERT INTO `mac_vod` VALUES('162','《谁是武侠世界最悲催的反派》—专辑：《但吐无妨[王炸天作品]》','','shuishiwuxiashijiezuibeicuidefanpaizhuanjidantuwufangwangzhatianzuopin','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446275507.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','425','0','0','0','0','0','0','4.0','1664','416','1457669028','1457669028','0','0','《谁是武侠世界最悲催的反派》—专辑：《但吐无妨【王炸天作品】》','youku','0','','XOTEwMjEwMDQ4','','','','');
INSERT INTO `mac_vod` VALUES('163','中国英式喜剧C4第153集，老外教你中国生活秘籍2—专辑：《搞笑英文脱口秀C4爆笑来袭！》','','zhongguoyingshixijuC4di153jilaowaijiaonizhongguoshenghuomiji2zhuanjigaoxiaoyingwentuokouxiuC4baoxiaolaixi','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462756316.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','191','0','0','0','0','0','0','3.0','897','299','1457669028','1457669028','0','0','中国英式喜剧C4第153集，老外教你中国生活秘籍2—专辑：《搞笑英文脱口秀C4爆笑来袭！》','youku','0','','XOTEwODc1NTQ4','','','','');
INSERT INTO `mac_vod` VALUES('164','二傻大闹运动场—专辑：《[笑吧]最新最热最有趣整蛊恶搞失败集锦！》','','ershadanaoyundongchangzhuanjixiaobazuixinzuirezuiyouquzhengguegaoshibaijijin','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462756417.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','200','0','0','0','0','0','0','9.0','2700','300','1457669028','1457669028','0','0','二傻大闹运动场—专辑：《【笑吧】最新最热最有趣整蛊恶搞失败集锦！》','youku','0','','XOTEwNDg5MTQw','','','','');
INSERT INTO `mac_vod` VALUES('165','[飞碟一分钟]一分钟教你帮男友戒游戏—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaonibangnanyoujieyouxizhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462756418.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','516','0','0','0','0','0','0','4.0','1928','482','1457669028','1457669028','0','0','【飞碟一分钟】一分钟教你帮男友戒游戏—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XOTA5MzkzNzQ0','','','','');
INSERT INTO `mac_vod` VALUES('166','老公是怎么被脱光的—专辑：《周星星麻辣喜剧》','','laogongshizenmebeituoguangdezhuanjizhouxingxingmalaxiju','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446275743.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','676','0','0','0','0','0','0','2.0','790','395','1457669028','1457669028','0','0','老公是怎么被脱光的—专辑：《周星星麻辣喜剧》','youku','0','','XOTA5NzY3Njc2','','','','');
INSERT INTO `mac_vod` VALUES('167','简笔笑画第四季05《锦绣缘》—专辑：《[优酷牛人]简笔笑画无节操动画爆笑合辑》','','jianbixiaohuadisiji05jinxiuyuanzhuanjiyoukuniurenjianbixiaohuawujiecaodonghuabaoxiaoheji','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446275755.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','933','0','0','0','0','0','0','10.0','1960','196','1457669028','1457669028','0','0','简笔笑画第四季05《锦绣缘》—专辑：《【优酷牛人】简笔笑画无节操动画爆笑合辑》','youku','0','','XOTA4OTYzNjc2','','','','');
INSERT INTO `mac_vod` VALUES('168','[飞碟一分钟]一分钟教你防治脱发—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaonifangzhituofazhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462758210.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','510','0','0','0','0','0','0','3.0','831','277','1457669028','1457669028','0','0','【飞碟一分钟】一分钟教你防治脱发—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XOTEwNzkwODYw','','','','');
INSERT INTO `mac_vod` VALUES('169','[欧子爱找刺儿14]《锦绣缘华丽冒险》十大穿帮镜头—专辑：《热剧雷剧吐槽穿帮合辑！天雷滚滚，舍你其谁！》','','ouziaizhaocier14jinxiuyuanhualimaoxianshidachuanbangjingtouzhuanjirejuleijutucaochuanbanghejitianleigungunsheniqishui','O','','http://www.egao8.cc/upload/vod/2015-10-12/144462758312.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','848','0','0','0','0','0','0','1.0','392','392','1457669028','1457669028','0','0','【欧子爱找刺儿14】《锦绣缘华丽冒险》十大穿帮镜头—专辑：《热剧雷剧吐槽穿帮合辑！天雷滚滚，舍你其谁！》','youku','0','','XOTEwMTA0MzQw','','','','');
INSERT INTO `mac_vod` VALUES('170','[笑料百出]第50期 手机居然可以烫睫毛—专辑：《畅所欲言！笑料百出！》','','xiaoliaobaichudi50qishoujijirankeyithengjiemaozhuanjichangsuoyuyanxiaoliaobaichu','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462758615.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','857','0','0','0','0','0','0','8.0','2208','276','1457669028','1457669028','0','0','【笑料百出】第50期 手机居然可以烫睫毛—专辑：《畅所欲言！笑料百出！》','youku','0','','XOTA3NjE0MzY4','','','','');
INSERT INTO `mac_vod` VALUES('171','每周星座09-最容易失财失色的星座—专辑：《[优酷牛人]秀策坊创意动画》','','meizhouxingzuo09zuirongyishicaishisedexingzuozhuanjiyoukuniurenxiucefangchuangyidonghua','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462758918.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','166','0','0','0','0','0','0','8.0','2200','275','1457669028','1457669028','0','0','每周星座09-最容易失财失色的星座—专辑：《【优酷牛人】秀策坊创意动画》','youku','0','','XOTA4MzIyNDEy','','','','');
INSERT INTO `mac_vod` VALUES('172','山寨球星莱万多夫斯基泡妞续集—专辑：《[笑吧]最新最热最有趣整蛊恶搞失败集锦！》','','shanzhaiqiuxinglaiwanduofusijipaoniuxujizhuanjixiaobazuixinzuirezuiyouquzhengguegaoshibaijijin','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446275971.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','374','0','0','0','0','0','0','6.0','2814','469','1457669028','1457669028','0','0','山寨球星莱万多夫斯基泡妞续集—专辑：《【笑吧】最新最热最有趣整蛊恶搞失败集锦！》','youku','0','','XOTA4MzQwMDgw','','','','');
INSERT INTO `mac_vod` VALUES('173','[妹子说热剧]盘点娱乐圈的不老女神 何仙姑夫工作室—专辑：《[优酷牛人]何仙姑夫爆笑原创恶搞经典合辑》','','meizishuorejupandianyulequandebulaonvshenhexiangufugongzuoshizhuanjiyoukuniurenhexiangufubaoxiaoyuanchuangegaojingdianheji','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446276044.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','296','0','0','0','0','0','0','9.0','2682','298','1457669028','1457669028','0','0','【妹子说热剧】盘点娱乐圈的不老女神 何仙姑夫工作室—专辑：《【优酷牛人】何仙姑夫爆笑原创恶搞经典合辑》','youku','0','','XOTA4NDIxMzA4','','','','');
INSERT INTO `mac_vod` VALUES('174','逗比们是这样过完春节的！[马桶说08]—专辑：《厕所新闻+马桶说》','','doubimenshizheyangguowanchunjiedematongshuo08zhuanjicesuoxinwenmatongshuo','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446276077.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','217','0','0','0','0','0','0','3.0','555','185','1457669028','1457669028','0','0','逗比们是这样过完春节的！【马桶说08】—专辑：《厕所新闻+马桶说》','youku','0','','XOTA4NjQyMjA0','','','','');
INSERT INTO `mac_vod` VALUES('175','[托比恋爱学]01三招教你搞定心中女神—专辑：《[优酷牛人]秀策坊创意动画》','','tuobilianaixue01sanzhaojiaonigaodingxinzhongnvshenzhuanjiyoukuniurenxiucefangchuangyidonghua','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462761111.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','142','0','0','0','0','0','0','8.0','1312','164','1457669028','1457669028','0','0','【托比恋爱学】01三招教你搞定心中女神—专辑：《【优酷牛人】秀策坊创意动画》','youku','0','','XOTA5NzEwNzE2','','','','');
INSERT INTO `mac_vod` VALUES('176','星爷教你做快乐的屌丝—专辑：《那些年，我们一起恶搞过的星爷~》','','xingyejiaonizuokuailedesizhuanjinaxienianwomenyiqiegaoguodexingye','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462761314.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','43','0','0','0','0','0','0','9.0','9','1','1457669028','1457669028','0','0','星爷教你做快乐的屌丝—专辑：《那些年，我们一起恶搞过的星爷~》','youku','0','','XOTA4MzE0ODYw','','','','');
INSERT INTO `mac_vod` VALUES('177','[每日一囧463]为什么范冰冰要演武则天—专辑：《[每日一囧]2014再战江湖第二弹！》','','meiriyi463weishimefanbingbingyaoyanwuzetianzhuanjimeiriyi2014zaizhanjianghudierdan','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462761617.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','112','0','0','0','0','0','0','2.0','650','325','1457669028','1457669028','0','0','【每日一囧463】为什么范冰冰要演武则天—专辑：《【每日一囧】2014再战江湖第二弹！》','youku','0','','XOTA5NzA2MDIw','','','','');
INSERT INTO `mac_vod` VALUES('178','[奇趣视界]萌宝突然意识到自己有一个舌头时&hellip;&hellip;—专辑：《萝莉正太合辑，卖萌到底哪家强？》','','qiqushijiemengbaoturanyishidaozijiyouyigeshetoushihelliphellipzhuanjiluolizhengtaihejimaimengdaodinajiaqiang','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446276281.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','8','0','0','0','0','0','0','10.0','2460','246','1457669028','1457669028','0','0','【奇趣视界】萌宝突然意识到自己有一个舌头时&hellip;&hellip;—专辑：《萝莉正太合辑，卖萌到底哪家强？》','youku','0','','XOTA4MjUwNzI4','','','','');
INSERT INTO `mac_vod` VALUES('179','[飞碟唱]双子座之歌—专辑：《[飞碟唱]》','','feidiechangshuangzizuozhigezhuanjifeidiechang','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446276314.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','110','0','0','0','0','0','0','4.0','1944','486','1457669028','1457669028','0','0','【飞碟唱】双子座之歌—专辑：《【飞碟唱】》','youku','0','','XOTA5MzgyMTUy','','','','');
INSERT INTO `mac_vod` VALUES('180','别学我第一季第一集：看大叔如何恶搞泡温泉美女—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','','biexuewodiyijidiyijikandashuruheegaopaowenquanmeinvzhuanjiduanjuyefengkuangbaoxiaopandianjingcaiduanju','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462763811.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','767','0','0','0','0','0','0','6.0','2988','498','1457669028','1457669028','0','0','别学我第一季第一集：看大叔如何恶搞泡温泉美女—专辑：《短剧也疯狂！爆笑盘点精彩短剧！》','youku','0','','XOTA3NTkwNzI0','','','','');
INSERT INTO `mac_vod` VALUES('181','[发现最热视频]可爱死了！超萌小萝莉从小就知道谎报年龄—专辑：《萝莉正太合辑，卖萌到底哪家强？》','','faxianzuireshipinkeaisiliaochaomengxiaoluolicongxiaojiuzhidaohuangbaonianlingzhuanjiluolizhengtaihejimaimengdaodinajiaqiang','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462742512.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','852','0','0','0','0','0','0','3.0','1200','400','1457669038','1457669038','0','0','【发现最热视频】可爱死了！超萌小萝莉从小就知道谎报年龄—专辑：《萝莉正太合辑，卖萌到底哪家强？》','youku','0','','XOTEzNzY0MDMy','','','','');
INSERT INTO `mac_vod` VALUES('182','[内涵播报41]美女上什么最爽？彪悍神回复！—专辑：《内涵播报》','','nahanbobao41meinvshangshimezuishuangbiaohanshenhuifuzhuanjinahanbobao','N','','http://www.egao8.cc/upload/vod/2015-10-12/144462742916.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','641','0','0','0','0','0','0','10.0','1290','129','1457669038','1457669038','0','0','【内涵播报41】美女上什么最爽？彪悍神回复！—专辑：《内涵播报》','youku','0','','XOTEwNDczNTA0','','','','');
INSERT INTO `mac_vod` VALUES('183','致命遇险一百种自救[八]—专辑：《郑云原创搞笑短片经典大合辑》','','zhimingyuxianyibaizhongzijiubazhuanjizhengyunyuanchuanggaoxiaoduanpianjingdiandaheji','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462743118.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','993','0','0','0','0','0','0','2.0','928','464','1457669038','1457669038','0','0','致命遇险一百种自救（八）—专辑：《郑云原创搞笑短片经典大合辑》','youku','0','','XOTEyOTc0Mzg4','','','','');
INSERT INTO `mac_vod` VALUES('184','315提前曝光 你中招了没 13','','315tiqianpuguangnizhongzhaoliaomei13','3','','http://www.egao8.cc/upload/vod/2015-10-12/14446274392.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','398','0','0','0','0','0','0','5.0','280','56','1457669038','1457669038','0','0','315提前曝光 你中招了没 13','youku','0','','XOTEwNTA1MDYw','','','','');
INSERT INTO `mac_vod` VALUES('185','唐唐神吐槽：最好骗的女神 [Big笑工坊]第101期  综艺 恶搞 脱口秀 2015—专辑：《[Big笑工坊]官方专辑》','','tangtangshentucaozuihaopiandenvshenBigxiaogongfangdi101qizongyiegaotuokouxiu2015zhuanjiBigxiaogongfangguanfangzhuanji','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446274486.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','438','0','0','0','0','0','0','5.0','1755','351','1457669038','1457669038','0','0','唐唐神吐槽：最好骗的女神 【Big笑工坊】第101期  综艺 恶搞 脱口秀 2015—专辑：《【Big笑工坊】官方专辑》','youku','0','','XOTEwNzk4Mzc2','','','','');
INSERT INTO `mac_vod` VALUES('186','山寨刘德华献唱《低头族》—专辑：《[优酷牛人]咚哥唱谈经典系列合辑》','','shanzhailiudehuaxianchangditouzuzhuanjiyoukuniurendonggechangtanjingdianxilieheji','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446274519.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','37','0','0','0','0','0','0','7.0','1540','220','1457669038','1457669038','0','0','山寨刘德华献唱《低头族》—专辑：《【优酷牛人】咚哥唱谈经典系列合辑》','youku','0','','XOTEzNzU0MjI4','','','','');
INSERT INTO `mac_vod` VALUES('187','[胡言狼语]第七期：综艺电影该炮轰还是该点赞—专辑：《[优酷搞笑牛人]胡狼恶搞原创经典作品合辑》','','huyanlangyudiqiqizongyidianyinggaipaohonghuaishigaidianzanzhuanjiyoukugaoxiaoniurenhulangegaoyuanchuangjingdianzuopinheji','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462745714.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','716','0','0','0','0','0','0','8.0','616','77','1457669038','1457669038','0','0','【胡言狼语】第七期：综艺电影该炮轰还是该点赞—专辑：《【优酷搞笑牛人】胡狼恶搞原创经典作品合辑》','youku','0','','XOTE1MzM2MjE2','','','','');
INSERT INTO `mac_vod` VALUES('188','每周星座10-偷偷告诉你十二星座谁最好色—专辑：《[优酷牛人]秀策坊创意动画》','','meizhouxingzuo10toutougaosunishierxingzuoshuizuihaosezhuanjiyoukuniurenxiucefangchuangyidonghua','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462745917.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','838','0','0','0','0','0','0','8.0','96','12','1457669038','1457669038','0','0','每周星座10-偷偷告诉你十二星座谁最好色—专辑：《【优酷牛人】秀策坊创意动画》','youku','0','','XOTEzMjY2OTQ4','','','','');
INSERT INTO `mac_vod` VALUES('189','[麦兜找穿帮] 《平凡的世界》大穿帮 凶悍群演不好惹—专辑：《[优酷牛人]何仙姑夫爆笑原创恶搞经典合辑》','','maidouzhaochuanbangpingfandeshijiedachuanbangxionghanqunyanbuhaoruozhuanjiyoukuniurenhexiangufubaoxiaoyuanchuangegaojingdianheji','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446274681.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','860','0','0','0','0','0','0','8.0','3264','408','1457669039','1457669039','0','0','【麦兜找穿帮】 《平凡的世界》大穿帮 凶悍群演不好惹—专辑：《【优酷牛人】何仙姑夫爆笑原创恶搞经典合辑》','youku','0','','XOTEzMzI5OTYw','','','','');
INSERT INTO `mac_vod` VALUES('190','搞日笑语乱入：坑爹の人森—专辑：《[优酷牛人]剑少兮创意恶搞合辑，犀利与搞笑并重！》','','gaorixiaoyuluanrukangdierensenzhuanjiyoukuniurenjianshaoxichuangyiegaohejixiliyugaoxiaobingzhong','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446274693.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','588','0','0','6','0','0','0','5.0','360','72','1457669039','1457669039','1458352924','0','搞日笑语乱入：坑爹の人森—专辑：《【优酷牛人】剑少兮创意恶搞合辑，犀利与搞笑并重！》','youku','0','','XOTEyODE1OTE2','','','','');
INSERT INTO `mac_vod` VALUES('191','[飞碟一分钟]一分钟教你对付女友的男闺蜜—专辑：《[飞碟一分钟第二季]天天跟我做，每天一分钟》','','feidieyifenzhongyifenzhongjiaoniduifunvyoudenanguimizhuanjifeidieyifenzhongdierjitiantiangenwozuomeitianyifenzhong','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446274705.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','400','0','0','0','0','0','0','10.0','3590','359','1457669039','1457669039','0','0','【飞碟一分钟】一分钟教你对付女友的男闺蜜—专辑：《【飞碟一分钟第二季】天天跟我做，每天一分钟》','youku','0','','XOTEzNjMzMjYw','','','','');
INSERT INTO `mac_vod` VALUES('192','[鬼畜精分曲]duang~刘德华的滑板鞋！啪啪啪！30s后持续高能！—专辑：《[搞笑牛人]吟笑派创意恶搞视频合辑》','','guixujingfenquduangliudehuadehuabanxiepapapa30shouchixugaonenzhuanjigaoxiaoniurenyinxiaopaichuangyiegaoshipinheji','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446274749.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','551','0','0','0','0','0','0','8.0','2336','292','1457669039','1457669039','0','0','【鬼畜精分曲】duang~刘德华的滑板鞋！啪啪啪！30s后持续高能！—专辑：《【搞笑牛人】吟笑派创意恶搞视频合辑》','youku','0','','XOTEyNDQzMTI4','','','','');
INSERT INTO `mac_vod` VALUES('193','暴走每周精选09—专辑：《暴走漫画帮你捡节操！暴走小课堂、逗逼者联盟》','','baozoumeizhoujingxuan09zhuanjibaozoumanhuabangnijianjiecaobaozouxiaoketangdoubizhelianmeng','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462747712.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','368','0','0','0','0','0','0','3.0','585','195','1457669039','1457669039','0','0','暴走每周精选09—专辑：《暴走漫画帮你捡节操！暴走小课堂、逗逼者联盟》','youku','0','','XOTExOTkxMDQ4','','','','');
INSERT INTO `mac_vod` VALUES('194','[每日一囧466]如果壁咚的是女汉子—专辑：《[每日一囧]2014再战江湖第二弹！》','','meiriyi466ruguobidongdeshinvhanzizhuanjimeiriyi2014zaizhanjianghudierdan','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462748116.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','526','0','0','0','0','0','0','5.0','1560','312','1457669039','1457669039','0','0','【每日一囧466】如果壁咚的是女汉子—专辑：《【每日一囧】2014再战江湖第二弹！》','youku','0','','XOTEyNTg4MzM2','','','','');
INSERT INTO `mac_vod` VALUES('195','200秒看完《大英雄天團[Big Hero 6]》—专辑：《[谷阿莫神解说]几分钟带你看完各种电影大片》','','200miaokanwandayingxiongtianBigHero6zhuanjiguamoshenjieshuojifenzhongdainikanwangezhongdianyingdapian','2','','http://www.egao8.cc/upload/vod/2015-10-12/144462748218.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','295','0','0','0','0','0','0','1.0','433','433','1457669039','1457669039','0','0','200秒看完《大英雄天團(Big Hero 6)》—专辑：《【谷阿莫神解说】几分钟带你看完各种电影大片》','youku','0','','XOTEyNjQxMjU2','','','','');
INSERT INTO `mac_vod` VALUES('196','极品街访：你能接受另一半从事特殊职业吗？—专辑：《神回复牛人在此集结！凡人跪了~~~~》','','jipinjiefangninenjieshoulingyibancongshiteshuzhiyemazhuanjishenhuifuniurenzaicijijiefanrenguiliao','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446275182.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','788','0','0','0','0','0','0','8.0','176','22','1457669039','1457669039','0','0','极品街访：你能接受另一半从事特殊职业吗？—专辑：《神回复牛人在此集结！凡人跪了~~~~》','youku','0','','XOTEwNzczNTI0','','','','');
INSERT INTO `mac_vod` VALUES('197','周杰伦2015新专辑揭秘为什么婚礼不请吴宗宪—专辑：《一风之音《恶了就搞》系列》','','zhoujielun2015xinzhuanjijiemiweishimehunlibuqingwuzongxianzhuanjiyifengzhiyineliaojiugaoxilie','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446275204.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','212','0','0','0','0','0','0','3.0','1014','338','1457669039','1457669039','0','0','周杰伦2015新专辑揭秘为什么婚礼不请吴宗宪—专辑：《一风之音《恶了就搞》系列》','youku','0','','XOTExODU4MDIw','','','','');
INSERT INTO `mac_vod` VALUES('198','[买萌卖萌]萌宠萌宝视频集锦[第五十一期]—专辑：《[买萌卖萌]各种神宠的卖萌进行时，看看有你们家的吗？》','','maimengmaimengmengchongmengbaoshipinjijindiwushiyiqizhuanjimaimengmaimenggezhongshenchongdemaimengjinxingshikankanyounimenjiadema','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446275237.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','118','0','0','0','0','0','0','2.0','126','63','1457669039','1457669039','0','0','【买萌卖萌】萌宠萌宝视频集锦（第五十一期）—专辑：《【买萌卖萌】各种神宠的卖萌进行时，看看有你们家的吗？》','youku','0','','XOTExNDQwODY4','','','','');
INSERT INTO `mac_vod` VALUES('199','[欧子最吐槽74]小刘德华唱《回不去的时光》感动70和80后的歌！—专辑：《[优酷牛人] 恶搞先锋欧子歪歌优秀作品大合辑》','','ouzizuitucao74xiaoliudehuachanghuibuqudeshiguanggandong70he80houdegezhuanjiyoukuniurenegaoxianfengouziwaigeyouxiuzuopindaheji','O','','http://www.egao8.cc/upload/vod/2015-10-12/144462752610.jpg','','','胥渡吧','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','651','0','0','0','0','0','0','3.0','1275','425','1457669039','1457669039','0','0','【欧子最吐槽74】小刘德华唱《回不去的时光》感动70和80后的歌！—专辑：《【优酷牛人】 恶搞先锋欧子歪歌优秀作品大合辑》','youku','0','','XOTExMjM4NTgw','','','','');
INSERT INTO `mac_vod` VALUES('200','太囧315 奇葩假货满天飞[囧闻一箩筐]—专辑：《[何仙姑夫]囧闻一箩筐》','','tai315qipajiahuomantianfeiwenyiluokuangzhuanjihexiangufuwenyiluokuang','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462753215.jpg','','','胥渡吧','','何仙姑','','大陆','','0','5','','','','0','0','0','0','0','0','0','798','0','0','0','0','0','0','9.0','2934','326','1457669039','1457669280','0','0','太囧315 奇葩假货满天飞【囧闻一箩筐】—专辑：《【何仙姑夫】囧闻一箩筐》','youku','no','','XOTExMzUzOTA4','','','','');
INSERT INTO `mac_vod` VALUES('201','炒股一路飘绿是衰  炒股一路飘绿是衰','','chaoguyilupiaolvshishuaichaoguyilupiaolvshishuai','C','','http://www.egao8.cc/upload/vod/2015-10-12/14446265980.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','904','0','0','0','0','0','0','9.0','1440','160','1457669318','1457669318','0','0','炒股一路飘绿是衰  炒股一路飘绿是衰','youku','0','','XMTMyNzc3OTEzMg==','','','','');
INSERT INTO `mac_vod` VALUES('202','经典演绎《高温联播》  经典演绎《高温联播》','','jingdianyanyigaowenlianbojingdianyanyigaowenlianbo','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446265680.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','588','0','0','0','0','0','0','7.0','3241','463','1457669318','1457669318','0','0','经典演绎《高温联播》  经典演绎《高温联播》','youku','0','','XMTMyNjkzMzEzMg==','','','','');
INSERT INTO `mac_vod` VALUES('203','九月最强恐怖巨制《开学传说》  九月最强恐怖巨制《开学传说》','','jiuyuezuiqiangkongbujuzhikaixuechuanshuojiuyuezuiqiangkongbujuzhikaixuechuanshuo','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446265370.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','177','0','0','0','0','0','0','8.0','224','28','1457669318','1457669318','0','0','九月最强恐怖巨制《开学传说》  九月最强恐怖巨制《开学传说》','youku','0','','XMTMyNDg1NTU0OA==','','','','');
INSERT INTO `mac_vod` VALUES('204','神剧星子派传奇 看延参听淮秀帮  神剧星子派传奇 看延参听淮秀帮','','shenjuxingzipaichuanqikanyancantinghuaixiubangshenjuxingzipaichuanqikanyancantinghuaixiubang','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446265060.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','426','0','0','0','0','0','0','1.0','263','263','1457669318','1457669318','0','0','神剧星子派传奇 看延参听淮秀帮  神剧星子派传奇 看延参听淮秀帮','youku','0','','XMTMxNTg4NjYxMg==','','','','');
INSERT INTO `mac_vod` VALUES('205','七夕情侣的那个事 看了会脸红的  七夕情侣的那个事 看了会脸红的','','qixiqinglvdenageshikanliaohuilianhongdeqixiqinglvdenageshikanliaohuilianhongde','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446264760.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','57','0','0','0','0','0','0','8.0','2472','309','1457669318','1457669318','0','0','七夕情侣的那个事 看了会脸红的  七夕情侣的那个事 看了会脸红的','youku','0','','XMTMxNTA0NzkzNg==','','','','');
INSERT INTO `mac_vod` VALUES('206','避暑神剧的正确打开方式  避暑神剧的正确打开方式','','bishushenjudezhengquedakaifangshibishushenjudezhengquedakaifangshi','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446264450.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','13','0','0','0','0','0','0','2.0','340','170','1457669318','1457669318','0','0','避暑神剧的正确打开方式  避暑神剧的正确打开方式','youku','0','','XMTMwODAzMzM2OA==','','','','');
INSERT INTO `mac_vod` VALUES('207','淮秀帮马上吐槽  淮秀帮马上吐槽','','huaixiubangmashangtucaohuaixiubangmashangtucao','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446264190.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','702','0','0','0','0','0','0','3.0','993','331','1457669318','1457669318','0','0','淮秀帮马上吐槽  淮秀帮马上吐槽','youku','0','','XMTMwODU1NjQ1Ng==','','','','');
INSERT INTO `mac_vod` VALUES('208','中国动漫逆袭史  中国动漫逆袭史','','zhongguodongmannixishizhongguodongmannixishi','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446263870.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','253','0','0','0','0','0','0','1.0','389','389','1457669318','1457669318','0','0','中国动漫逆袭史  中国动漫逆袭史','youku','0','','XMTMxMjI3Mjk3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('209','吓死本宝宝了  吓死本宝宝了','','xiasibenbaobaoliaoxiasibenbaobaoliao','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446263440.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','766','0','0','0','0','0','0','5.0','865','173','1457669318','1457669318','0','0','吓死本宝宝了  吓死本宝宝了','youku','0','','XMTMwNjc2NTM0OA==','','','','');
INSERT INTO `mac_vod` VALUES('210','避暑神剧的正确打开方式！','','bishushenjudezhengquedakaifangshi','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446263100.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','555','0','0','0','0','0','0','7.0','2611','373','1457669318','1457669318','0','0','避暑神剧的正确打开方式！','youku','0','','XMTMwMjgxNTY4OA==','','','','');
INSERT INTO `mac_vod` VALUES('211','国外恶搞整人  国外恶搞整人','','guowaiegaozhengrenguowaiegaozhengren','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446262810.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','406','0','0','0','0','0','0','8.0','1296','162','1457669318','1457669318','0','0','国外恶搞整人  国外恶搞整人','youku','0','','XMTMxMjc1NjI0OA==','','','','');
INSERT INTO `mac_vod` VALUES('212','装你麻痹，一起嗨！  装你麻痹，一起嗨！','','zhuangnimabiyiqihaizhuangnimabiyiqihai','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446262510.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','823','0','0','0','0','0','0','3.0','972','324','1457669318','1457669318','0','0','装你麻痹，一起嗨！  装你麻痹，一起嗨！','youku','0','','XMTI5MjQ2MDM4OA==','','','','');
INSERT INTO `mac_vod` VALUES('213','淮秀帮恶搞减肥！减肥！  淮秀帮恶搞减肥！','','huaixiubangegaojianfeijianfeihuaixiubangegaojianfei','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446262180.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','279','0','0','0','0','0','0','3.0','1131','377','1457669318','1457669318','0','0','淮秀帮恶搞减肥！减肥！  淮秀帮恶搞减肥！','youku','0','','XMTI4OTg5NjUzMg==','','','','');
INSERT INTO `mac_vod` VALUES('214','纸巾老湿带你领略跳着舞的革命','','zhijinlaoshidainilingluetiaozhouwudegeming','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446261940.gif','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','464','0','0','0','0','0','0','7.0','1379','197','1457669318','1457669318','0','0','纸巾老湿带你领略跳着舞的革命','youku','0','','XMTMwMzc1NTEwNA==','','','','');
INSERT INTO `mac_vod` VALUES('215','2分钟回顾有一种青春叫周杰伦  2分钟回顾','','2fenzhonghuiguyouyizhongqingchunjiaozhoujielun2fenzhonghuigu','2','','http://www.egao8.cc/upload/vod/2015-10-12/14446261660.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','540','0','0','0','0','0','0','4.0','580','145','1457669318','1457669318','0','0','2分钟回顾有一种青春叫周杰伦  2分钟回顾','youku','0','','XMTI4OTg5Mjk3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('216','淮秀帮  淮秀帮','','huaixiubanghuaixiubang','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446261270.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','385','0','0','0','0','0','0','1.0','193','193','1457669318','1457669318','0','0','淮秀帮  淮秀帮','youku','0','','XMTI4MjQ3MTg2NA==','','','','');
INSERT INTO `mac_vod` VALUES('217','[淮秀帮]吐槽暑期神剧  [淮秀帮]吐槽暑期神剧','','huaixiubangtucaoshuqishenjuhuaixiubangtucaoshuqishenju','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446261010.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','846','0','0','0','0','0','0','4.0','180','45','1457669318','1457669318','0','0','【淮秀帮】吐槽暑期神剧  【淮秀帮】吐槽暑期神剧','youku','0','','XMTI4OTM5Mjk4MA==','','','','');
INSERT INTO `mac_vod` VALUES('218','吐槽小说翻拍毁原著《翻拍笔记》  吐槽小说翻拍毁原著','','tucaoxiaoshuofanpaihuiyuanzhufanpaibijitucaoxiaoshuofanpaihuiyuanzhu','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446260730.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','991','0','0','0','0','0','0','3.0','801','267','1457669318','1457669318','0','0','吐槽小说翻拍毁原著《翻拍笔记》  吐槽小说翻拍毁原著','youku','0','','XMTI3MDEzNjQ4OA==','','','','');
INSERT INTO `mac_vod` VALUES('219','《花千骨》的正确打开方式  正确打开方式','','huaqiangudezhengquedakaifangshizhengquedakaifangshi','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446260490.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','354','0','0','0','0','0','0','6.0','2436','406','1457669318','1457669318','0','0','《花千骨》的正确打开方式  正确打开方式','youku','0','','XMTI3NDAyOTc3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('220','群星加薪血泪史《薪闻联播》  淮秀帮《薪闻联播》','','qunxingjiaxinxueleishixinwenlianbohuaixiubangxinwenlianbo','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446260160.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','189','0','0','0','0','0','0','6.0','720','120','1457669318','1457669318','0','0','群星加薪血泪史《薪闻联播》  淮秀帮《薪闻联播》','youku','0','','XOTI0NTg5MTE2','','','','');
INSERT INTO `mac_vod` VALUES('221','[淮秀帮]《盗墓笔记》的正确打开方式！  《盗墓笔记》的正确打开方式！','','huaixiubangdaomubijidezhengquedakaifangshidaomubijidezhengquedakaifangshi','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446259910.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','719','0','0','0','0','0','0','1.0','304','304','1457669322','1457669322','0','0','【淮秀帮】《盗墓笔记》的正确打开方式！  《盗墓笔记》的正确打开方式！','youku','0','','XMTI4ODU1NTgxNg==','','','','');
INSERT INTO `mac_vod` VALUES('222','高考毕业特辑《不吐槽不青春》  [牛人]淮秀帮创意配音：112','','gaokaobiyetejibutucaobuqingchunniurenhuaixiubangchuangyipeiyin112','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446259610.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','385','0','0','0','0','0','0','8.0','1664','208','1457669322','1457669322','0','0','高考毕业特辑《不吐槽不青春》  【牛人】淮秀帮创意配音：112','youku','0','','XOTYzODA3NDg4','','','','');
INSERT INTO `mac_vod` VALUES('223','《武媚娘传奇》港台美日韩版爆笑剧透  淮秀帮','','wumeiniangchuanqigangtaimeirihanbanbaoxiaojutouhuaixiubang','W','','http://www.egao8.cc/upload/vod/2015-10-12/14446259320.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','97','0','0','0','0','0','0','4.0','272','68','1457669322','1457669322','0','0','《武媚娘传奇》港台美日韩版爆笑剧透  淮秀帮','youku','0','','XODg0MjYxMTE2','','','','');
INSERT INTO `mac_vod` VALUES('224','新片剧透《侏罗纪世界》  新片剧透 2015：08','','xinpianjutouzhuluojishijiexinpianjutou201508','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446259030.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','485','0','0','0','0','0','0','2.0','462','231','1457669322','1457669322','0','0','新片剧透《侏罗纪世界》  新片剧透 2015：08','youku','0','','XMTI2MTI4NTU2MA==','','','','');
INSERT INTO `mac_vod` VALUES('225','爆笑《装逼学院》：装你麻痹，一起嗨！','','baoxiaozhuangbixueyuanzhuangnimabiyiqihai','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446258800.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','146','0','0','0','0','0','0','6.0','1662','277','1457669322','1457669322','0','0','爆笑《装逼学院》：装你麻痹，一起嗨！','youku','0','','XOTM1MDE2ODIw','','','','');
INSERT INTO `mac_vod` VALUES('226','[轻松时刻]悲剧的人生总是事与愿违—专辑：《发现生活笑点，感受[轻松时刻]！》','','qingsongshikebeijuderenshengzongshishiyuyuanweizhuanjifaxianshenghuoxiaodianganshouqingsongshike','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446258570.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','896','0','0','0','0','0','0','5.0','725','145','1457669322','1457669322','0','0','【轻松时刻】悲剧的人生总是事与愿违—专辑：《发现生活笑点，感受【轻松时刻】！》','youku','0','','XODgyODI0NzQ0','','','','');
INSERT INTO `mac_vod` VALUES('227','爆笑毕业季《毕业生联盟》','','baoxiaobiyejibiyeshenglianmeng','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446258320.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','20','0','0','0','0','0','0','2.0','516','258','1457669322','1457669322','0','0','爆笑毕业季《毕业生联盟》','youku','0','','XMTI1OTQ2NDY0MA==','','','','');
INSERT INTO `mac_vod` VALUES('228','民生励志传奇《薪闻联播》  淮秀帮创意配音110','','minshenglizhichuanqixinwenlianbohuaixiubangchuangyipeiyin110','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446258040.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','523','0','0','0','0','0','0','1.0','151','151','1457669322','1457669322','0','0','民生励志传奇《薪闻联播》  淮秀帮创意配音110','youku','0','','XOTIzODMyMTE2','','','','');
INSERT INTO `mac_vod` VALUES('229','九月最强恐怖片  九月最强恐怖片','','jiuyuezuiqiangkongbupianjiuyuezuiqiangkongbupian','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446257800.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','377','0','0','0','0','0','0','3.0','270','90','1457669322','1457669322','0','0','九月最强恐怖片  九月最强恐怖片','youku','0','','XMTMyNzc2NDM4NA==','','','','');
INSERT INTO `mac_vod` VALUES('230','就这样狗带:一句话终结影视剧  就这样狗带:一句话终结影视剧','','jiuzheyanggoudaiyijuhuazhongjieyingshijujiuzheyanggoudaiyijuhuazhongjieyingshiju','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446257530.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','774','0','0','0','0','0','0','6.0','1218','203','1457669322','1457669322','0','0','就这样狗带:一句话终结影视剧  就这样狗带:一句话终结影视剧','youku','0','','XMTM1NTU4MjIwNA==','','','','');
INSERT INTO `mac_vod` VALUES('231','我把身边的朋友都得罪完了  我把身边的朋友都得罪完了','','wobashenbiandepengyoududezuiwanliaowobashenbiandepengyoududezuiwanliao','W','','http://www.egao8.cc/upload/vod/2015-10-12/14446257250.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','373','0','0','0','0','0','0','3.0','303','101','1457669322','1457669322','0','0','我把身边的朋友都得罪完了  我把身边的朋友都得罪完了','youku','0','','XMTMyNzE1MTQ2MA==','','','','');
INSERT INTO `mac_vod` VALUES('232','九月最强恐怖片《开学传说》  九月最强恐怖片《开学传说》','','jiuyuezuiqiangkongbupiankaixuechuanshuojiuyuezuiqiangkongbupiankaixuechuanshuo','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446256970.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','554','0','0','0','0','0','0','4.0','16','4','1457669322','1457669322','0','0','九月最强恐怖片《开学传说》  九月最强恐怖片《开学传说》','youku','0','','XMTM1MzA4NTU4NA==','','','','');
INSERT INTO `mac_vod` VALUES('233','创意生活快乐配音“淮秀帮”  创意生活快乐配音“淮秀帮”','','chuangyishenghuokuailepeiyinhuaixiubangchuangyishenghuokuailepeiyinhuaixiubang','C','','http://www.egao8.cc/upload/vod/2015-10-12/14446256690.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','664','0','0','0','0','0','0','2.0','736','368','1457669322','1457669322','0','0','创意生活快乐配音“淮秀帮”  创意生活快乐配音“淮秀帮”','youku','0','','XMTMwODU1MDY1Mg==','','','','');
INSERT INTO `mac_vod` VALUES('234','《花千骨》的正确打开方式！  《花千骨》的正确打开方式！','','huaqiangudezhengquedakaifangshihuaqiangudezhengquedakaifangshi','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446256450.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','269','0','0','0','0','0','0','3.0','21','7','1457669322','1457669322','0','0','《花千骨》的正确打开方式！  《花千骨》的正确打开方式！','youku','0','','XMTMzNTk5MTA3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('235','《盗墓笔记》的正确打开方式  《盗墓笔记》的正确打开方式','','daomubijidezhengquedakaifangshidaomubijidezhengquedakaifangshi','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446256210.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','405','0','0','0','0','0','0','7.0','1540','220','1457669322','1457669322','0','0','《盗墓笔记》的正确打开方式  《盗墓笔记》的正确打开方式','youku','0','','XMTMyNzcwMjY2MA==','','','','');
INSERT INTO `mac_vod` VALUES('236','新十大奇葩绝症：吓死本宝宝了！  淮秀帮','','xinshidaqipajuezhengxiasibenbaobaoliaohuaixiubang','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446255980.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','826','0','0','0','0','0','0','5.0','2080','416','1457669322','1457669322','0','0','新十大奇葩绝症：吓死本宝宝了！  淮秀帮','youku','0','','XMTMwNjE0NTczNg==','','','','');
INSERT INTO `mac_vod` VALUES('237','#淮秀帮创意配音#酷暑爆笑巨献  #淮秀帮创意配音','','huaixiubangchuangyipeiyinkushubaoxiaojuxianhuaixiubangchuangyipeiyin','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446255700.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','255','0','0','0','0','0','0','8.0','1888','236','1457669322','1457669322','0','0','#淮秀帮创意配音#酷暑爆笑巨献  #淮秀帮创意配音','youku','0','','XMTMxNDUwOTI3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('238','已懵逼：避暑神剧的正确打开方式  已懵逼：避暑神剧的正确打开方式','','yimengbibishushenjudezhengquedakaifangshiyimengbibishushenjudezhengquedakaifangshi','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446255440.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','632','0','0','0','0','0','0','9.0','1647','183','1457669322','1457669322','0','0','已懵逼：避暑神剧的正确打开方式  已懵逼：避暑神剧的正确打开方式','youku','0','','XMTMwMDk2NjEyNA==','','','','');
INSERT INTO `mac_vod` VALUES('239','内四外的打法视频教学  内四外的打法视频教学','','nasiwaidedafashipinjiaoxuenasiwaidedafashipinjiaoxue','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446255170.gif','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','368','0','0','0','0','0','0','9.0','2187','243','1457669322','1457669322','0','0','内四外的打法视频教学  内四外的打法视频教学','youku','0','','XMTMxMTgwNTMxMg==','','','','');
INSERT INTO `mac_vod` VALUES('240','奥奇传说关键是声音  关键是声音','','aoqichuanshuoguanjianshishengyinguanjianshishengyin','A','','http://www.egao8.cc/upload/vod/2015-10-12/14446254890.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','591','0','0','0','0','0','0','7.0','77','11','1457669322','1457669322','0','0','奥奇传说关键是声音  关键是声音','youku','0','','XMTI3Mzg5MDI4MA==','','','','');
INSERT INTO `mac_vod` VALUES('241','奔跑吧，五花肉  奔跑吧，五花肉','','benpaobawuhuaroubenpaobawuhuarou','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446254650.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','400','0','0','0','0','0','0','2.0','638','319','1457669326','1457669326','0','0','奔跑吧，五花肉  奔跑吧，五花肉','youku','0','','XMTMwNzg5NjA3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('242','群星吐槽疯狂股市《翻滚吧 大盘》','','qunxingtucaofengkuanggushifangunbadapan','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446254370.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','111','0','0','0','0','0','0','7.0','2478','354','1457669326','1457669326','0','0','群星吐槽疯狂股市《翻滚吧 大盘》','youku','0','','XMTI2NTA3MzgyNA==','','','','');
INSERT INTO `mac_vod` VALUES('243','群星吐槽疯狂股市《翻滚吧 大盘》  [牛人]淮秀帮创意配音:111','','qunxingtucaofengkuanggushifangunbadapanniurenhuaixiubangchuangyipeiyin111','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446254100.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','509','0','0','0','0','0','0','1.0','292','292','1457669326','1457669326','0','0','群星吐槽疯狂股市《翻滚吧 大盘》  【牛人】淮秀帮创意配音:111','youku','0','','XOTUxNjIwOTky','','','','');
INSERT INTO `mac_vod` VALUES('244','[淮秀帮]群星鬼畜版《Duang》盘点羊年最热点！—专辑：《[优酷牛人]淮秀帮恶搞配音视频经典专辑》','','huaixiubangqunxingguixubanDuangpandianyangnianzuiredianzhuanjiyoukuniurenhuaixiubangegaopeiyinshipinjingdianzhuanji','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446253830.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','98','0','0','0','0','0','0','1.0','415','415','1457669326','1457669326','0','0','【淮秀帮】群星鬼畜版《Duang》盘点羊年最热点！—专辑：《【优酷牛人】淮秀帮恶搞配音视频经典专辑》','youku','0','','XOTA1MTg1NTA0','','','','');
INSERT INTO `mac_vod` VALUES('245','装你麻痹，一起嗨！  淮秀帮','','zhuangnimabiyiqihaihuaixiubang','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446253580.png','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','351','0','0','0','0','0','0','7.0','1687','241','1457669326','1457669326','0','0','装你麻痹，一起嗨！  淮秀帮','youku','0','','XOTM1MDE2ODIw','','','','');
INSERT INTO `mac_vod` VALUES('246','[哇哈哦哦]吊炸天！小屁孩背身射箭命中移动飞盘—专辑：《萝莉正太合辑，卖萌到底哪家强？》','','wahaououdiaozhatianxiaopihaibeishenshejianmingzhongyidongfeipanzhuanjiluolizhengtaihejimaimengdaodinajiaqiang','W','','http://www.egao8.cc/upload/vod/2015-10-12/14446253320.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','958','0','0','0','0','0','0','8.0','1176','147','1457669326','1457669326','0','0','【哇哈哦哦】吊炸天！小屁孩背身射箭命中移动飞盘—专辑：《萝莉正太合辑，卖萌到底哪家强？》','youku','0','','XOTAyMDE3NDk2','','','','');
INSERT INTO `mac_vod` VALUES('247','[牛人]淮秀帮创意配音 2015  奔跑吧 学霸','','niurenhuaixiubangchuangyipeiyin2015benpaobaxueba','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446253050.gif','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','81','0','0','0','0','0','0','5.0','2470','494','1457669326','1457669326','0','0','【牛人】淮秀帮创意配音 2015  奔跑吧 学霸','youku','0','','XODc1MTA3MzIw','','','','');
INSERT INTO `mac_vod` VALUES('248','奔跑吧 学霸  淮秀帮','','benpaobaxuebahuaixiubang','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446252800.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','598','0','0','0','0','0','0','1.0','253','253','1457669326','1457669326','0','0','奔跑吧 学霸  淮秀帮','youku','0','','XODc1MTA3MzIw','','','','');
INSERT INTO `mac_vod` VALUES('249','神雕侠侣经典吐槽《舌尖上的小龙女》  [牛人]淮秀帮创意配音 2014','','shendiaoxialvjingdiantucaoshejianshangdexiaolongnvniurenhuaixiubangchuangyipeiyin2014','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446252510.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','356','0','0','0','0','0','0','5.0','640','128','1457669326','1457669326','0','0','神雕侠侣经典吐槽《舌尖上的小龙女》  【牛人】淮秀帮创意配音 2014','youku','0','','XODQ1NTcyNjMy','','','','');
INSERT INTO `mac_vod` VALUES('250','淮秀帮《进击的CP粉》为爱逆战  淮秀帮','','huaixiubangjinjideCPfenweiainizhanhuaixiubang','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446252250.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','422','0','0','0','0','0','0','7.0','1302','186','1457669326','1457669326','0','0','淮秀帮《进击的CP粉》为爱逆战  淮秀帮','youku','0','','XNzkyMTg3MTE2','','','','');
INSERT INTO `mac_vod` VALUES('251','时尚时尚最时尚洗剪吹篇《发型护卫队》 141109  [牛人]淮秀帮创意配音 2014','','shishangshishangzuishishangxijianchuipianfaxinghuweidui141109niurenhuaixiubangchuangyipeiyin2014','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446251990.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','332','0','0','0','0','0','0','3.0','1419','473','1457669326','1457669326','0','0','时尚时尚最时尚洗剪吹篇《发型护卫队》 141109  【牛人】淮秀帮创意配音 2014','youku','0','','XODIyOTAzNTI0','','','','');
INSERT INTO `mac_vod` VALUES('252','淮秀帮教师节致青春《萌师奇谭》  淮秀帮','','huaixiubangjiaoshijiezhiqingchunmengshiqitanhuaixiubang','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446251720.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','339','0','0','0','0','0','0','8.0','1192','149','1457669326','1457669326','0','0','淮秀帮教师节致青春《萌师奇谭》  淮秀帮','youku','0','','XNzc4NDY0MTA0','','','','');
INSERT INTO `mac_vod` VALUES('253','淮秀帮经典演绎《高温联播》现场版！  淮秀帮','','huaixiubangjingdianyanyigaowenlianboxianchangbanhuaixiubang','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446251530.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','666','0','0','0','0','0','0','9.0','954','106','1457669326','1457669326','0','0','淮秀帮经典演绎《高温联播》现场版！  淮秀帮','youku','0','','XNzg3MTQwMDM2','','','','');
INSERT INTO `mac_vod` VALUES('254','走近科学《10大神奇病症》  淮秀帮','','zoujinkexue10dashenqibingzhenghuaixiubang','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446251300.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','754','0','0','0','0','0','0','4.0','380','95','1457669326','1457669326','0','0','走近科学《10大神奇病症》  淮秀帮','youku','0','','XNzg3NDYyNDcy','','','','');
INSERT INTO `mac_vod` VALUES('255','毕业季特刊《三年高考·四年毕业》','','biyejitekansanniangaokaosinianbiye','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446251050.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','513','0','0','0','0','0','0','8.0','2832','354','1457669326','1457669326','0','0','毕业季特刊《三年高考·四年毕业》','youku','0','','XNzI3MjU1NzI0','','','','');
INSERT INTO `mac_vod` VALUES('256','十一双节爆笑演义——国庆撞中秋！','','shiyishuangjiebaoxiaoyanyiguoqingzhuangzhongqiu','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446250770.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','573','0','0','0','0','0','0','6.0','1368','228','1457669326','1457669326','0','0','十一双节爆笑演义——国庆撞中秋！','youku','0','','114094065','','','','');
INSERT INTO `mac_vod` VALUES('257','开学季一人分裂西游记 《唐僧迎开学》  淮秀帮','','kaixuejiyirenfenliexiyoujitangsengyingkaixuehuaixiubang','K','','http://www.egao8.cc/upload/vod/2015-10-12/14446250400.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','530','0','0','0','0','0','0','1.0','298','298','1457669326','1457669326','0','0','开学季一人分裂西游记 《唐僧迎开学》  淮秀帮','youku','0','','XNzY0OTU0MjI0','','','','');
INSERT INTO `mac_vod` VALUES('258','古今中外演绎——高考作文坑爹大盘点！','','gujinzhongwaiyanyigaokaozuowenkangdiedapandian','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446250020.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','202','0','0','0','0','0','0','2.0','2','1','1457669326','1457669326','0','0','古今中外演绎——高考作文坑爹大盘点！','youku','0','','104144305','','','','');
INSERT INTO `mac_vod` VALUES('259','淮秀帮夏日风暴《高温总动员》','','huaixiubangxiarifengbaogaowenzongdongyuan','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446249660.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','874','0','0','0','0','0','0','3.0','789','263','1457669326','1457669326','0','0','淮秀帮夏日风暴《高温总动员》','youku','0','','XNzQ4OTcyMDMy#149940641','','','','');
INSERT INTO `mac_vod` VALUES('260','创意配音爸爸去哪儿的正确打开方式！','','chuangyipeiyinbabaqunaerdezhengquedakaifangshi','C','','http://www.egao8.cc/upload/vod/2015-10-12/14446249400.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','549','0','0','0','0','0','0','6.0','702','117','1457669326','1457669326','0','0','创意配音爸爸去哪儿的正确打开方式！','youku','0','','XNzU5NzQwOTEy','','','','');
INSERT INTO `mac_vod` VALUES('261','怀旧巨献——《致我们终将逝去的童年》','','huaijiujuxianzhiwomenzhongjiangshiqudetongnian','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446249150.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','200','0','0','0','0','0','0','4.0','1316','329','1457669331','1457669331','0','0','怀旧巨献——《致我们终将逝去的童年》','youku','0','','141189795','','','','');
INSERT INTO `mac_vod` VALUES('262','创意配唱经典游戏乱炖版《小苹果》','','chuangyipeichangjingdianyouxiluandunbanxiaopingguo','C','','http://www.egao8.cc/upload/vod/2015-10-12/14446248790.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','18','0','0','0','0','0','0','5.0','140','28','1457669331','1457669331','0','0','创意配唱经典游戏乱炖版《小苹果》','youku','0','','XNzQzMzY2MzM2','','','','');
INSERT INTO `mac_vod` VALUES('263','恶搞配音致我们终将牛逼的青春','','egaopeiyinzhiwomenzhongjiangniubideqingchun','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248540.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','664','0','0','0','0','0','0','10.0','3240','324','1457669331','1457669331','0','0','恶搞配音致我们终将牛逼的青春','youku','0','','137312754','','','','');
INSERT INTO `mac_vod` VALUES('264','恶搞让子弹飞——贺岁档三巨头亲密会谈！','','egaorangzidanfeihesuidangsanjutouqinmihuitan','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248290.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','517','0','0','0','0','0','0','1.0','439','439','1457669331','1457669331','0','0','恶搞让子弹飞——贺岁档三巨头亲密会谈！','youku','0','','82190636','','','','');
INSERT INTO `mac_vod` VALUES('265','毕业季献礼《舌尖上的食堂》','','biyejixianlishejianshangdeshitang','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446248301.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','923','0','0','0','0','0','0','1.0','326','326','1457669331','1457669331','0','0','毕业季献礼《舌尖上的食堂》','youku','0','','XNzI4NjExMDI0','','','','');
INSERT INTO `mac_vod` VALUES('266','恶搞配音买票难难于上青天','','egaopeiyinmaipiaonannanyushangqingtian','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248322.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','451','0','0','0','0','0','0','4.0','1204','301','1457669331','1457669331','0','0','恶搞配音买票难难于上青天','youku','0','','86014911','','','','');
INSERT INTO `mac_vod` VALUES('267','创意婚礼穿越时空送钻戒','','chuangyihunlichuanyueshikongsongzuanjie','C','','http://www.egao8.cc/upload/vod/2015-10-12/14446248333.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','134','0','0','0','0','0','0','2.0','326','163','1457669331','1457669331','0','0','创意婚礼穿越时空送钻戒','youku','0','','XNzI0NzEzMTcy','','','','');
INSERT INTO `mac_vod` VALUES('268','拾节操巨献《爱，都去哪了》！','','shijiecaojuxianaiduqunaliao','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446248344.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','727','0','0','0','0','0','0','5.0','1595','319','1457669331','1457669331','0','0','拾节操巨献《爱，都去哪了》！','youku','0','','XNjkxMjgyMDM2','','','','');
INSERT INTO `mac_vod` VALUES('269','恶搞经典角色演绎雷人广告！','','egaojingdianjiaoseyanyileirenguanggao','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248355.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','952','0','0','0','0','0','0','3.0','1239','413','1457669331','1457669331','0','0','恶搞经典角色演绎雷人广告！','youku','0','','82408832','','','','');
INSERT INTO `mac_vod` VALUES('270','吐槽于妈三弄之《宫锁琼瑶》','','tucaoyumasanlongzhigongsuoqiongyao','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446248366.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','751','0','0','0','0','0','0','2.0','890','445','1457669331','1457669331','0','0','吐槽于妈三弄之《宫锁琼瑶》','youku','0','','XNjk4NzQxODA0','','','','');
INSERT INTO `mac_vod` VALUES('271','笑尿！学渣男神高考','','xiaoniaoxuezhananshengaokao','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446248387.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','534','0','0','0','0','0','0','1.0','404','404','1457669331','1457669331','0','0','笑尿！学渣男神高考','youku','0','','XNzE4Mzc5NTQ4','','','','');
INSERT INTO `mac_vod` VALUES('272','恶搞“涨工资体”群星总动员——加薪何时有！','','egaozhanggongzitiqunxingzongdongyuanjiaxinheshiyou','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248398.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','429','0','0','0','0','0','0','8.0','3064','383','1457669331','1457669331','0','0','恶搞“涨工资体”群星总动员——加薪何时有！','youku','0','','80928632','','','','');
INSERT INTO `mac_vod` VALUES('273','神剧的正确打开方式','','shenjudezhengquedakaifangshi','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446248399.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','535','0','0','0','0','0','0','4.0','856','214','1457669331','1457669331','0','0','神剧的正确打开方式','youku','0','','XNTE1MTg0ODA0','','','','');
INSERT INTO `mac_vod` VALUES('274','恶搞新还珠格格——剖腹产伤不起','','egaoxinhuaizhugegepoufuchanshangbuqi','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462484010.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','168','0','0','0','0','0','0','1.0','86','86','1457669331','1457669331','0','0','恶搞新还珠格格——剖腹产伤不起','youku','0','','73800235','','','','');
INSERT INTO `mac_vod` VALUES('275','男人帮——恶搞光棍节肿木过！？[淮秀帮出品]','','nanrenbangegaoguanggunjiezhongmuguohuaixiubangchupin','N','','http://www.egao8.cc/upload/vod/2015-10-12/144462484111.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','113','0','0','0','0','0','0','9.0','1548','172','1457669331','1457669331','0','0','男人帮——恶搞光棍节肿木过！？（淮秀帮出品）','youku','0','','80259233','','','','');
INSERT INTO `mac_vod` VALUES('276','恶搞配音还珠格格——皇后容嬷嬷成亲记','','egaopeiyinhuaizhugegehuanghourongmamachengqinji','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462484212.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','874','0','0','0','0','0','0','4.0','1024','256','1457669331','1457669331','0','0','恶搞配音还珠格格——皇后容嬷嬷成亲记','youku','0','','72695513','','','','');
INSERT INTO `mac_vod` VALUES('277','恶搞新白娘子传奇——白娘子做公益','','egaoxinbainiangzichuanqibainiangzizuogongyi','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462484213.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','923','0','0','0','0','0','0','6.0','2130','355','1457669331','1457669331','0','0','恶搞新白娘子传奇——白娘子做公益','youku','0','','80564604','','','','');
INSERT INTO `mac_vod` VALUES('278','淮秀帮2015年新年盘点——《2014年十大关键词》  淮秀帮','','huaixiubang2015nianxinnianpandian2014nianshidaguanjiancihuaixiubang','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462484314.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','952','0','0','0','0','0','0','5.0','1735','347','1457669331','1457669331','0','0','淮秀帮2015年新年盘点——《2014年十大关键词》  淮秀帮','youku','0','','XODYxNjc1OTA0','','','','');
INSERT INTO `mac_vod` VALUES('279','现实版《十大未解之谜》我竟无言以对  淮秀帮','','xianshibanshidaweijiezhimiwojingwuyanyiduihuaixiubang','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462484415.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','122','0','0','0','0','0','0','10.0','920','92','1457669331','1457669331','0','0','现实版《十大未解之谜》我竟无言以对  淮秀帮','youku','0','','XODA2NTIwNzUy','','','','');
INSERT INTO `mac_vod` VALUES('280','就是这样任性《秋冬四大错觉》  [牛人]淮秀帮创意配音 2014','','jiushizheyangrenxingqiudongsidacuojueniurenhuaixiubangchuangyipeiyin2014','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462484516.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','311','0','0','0','0','0','0','6.0','372','62','1457669331','1457669331','0','0','就是这样任性《秋冬四大错觉》  【牛人】淮秀帮创意配音 2014','youku','0','','XODM2MTg0NTE2','','','','');
INSERT INTO `mac_vod` VALUES('281','夏季坑爹巨献压轴篇——《开学》','','xiajikangdiejuxianyazhoupiankaixue','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462484717.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','366','0','0','0','0','0','0','1.0','461','461','1457669335','1457669335','0','0','夏季坑爹巨献压轴篇——《开学》','youku','0','','111428420','','','','');
INSERT INTO `mac_vod` VALUES('282','[创意配音]淮秀帮光棍节特辑《脱单吧，兄弟》！  湖咯咯','','chuangyipeiyinhuaixiubangguanggunjietejituodanbaxiongdihukeke','C','','http://www.egao8.cc/upload/vod/2015-10-12/144462484718.gif','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','354','0','0','0','0','0','0','5.0','1770','354','1457669335','1457669335','0','0','【创意配音】淮秀帮光棍节特辑《脱单吧，兄弟》！  湖咯咯','youku','0','','XODI0MzA5NjE2','','','','');
INSERT INTO `mac_vod` VALUES('283','淮秀帮七夕《中二病高发》看电影《绣春刀》','','huaixiubangqixizhongerbinggaofakandianyingxiuchundao','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462484919.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','811','0','0','0','0','0','0','5.0','1450','290','1457669335','1457669335','0','0','淮秀帮七夕《中二病高发》看电影《绣春刀》','youku','0','','XNzUxNzUyOTc2','','','','');
INSERT INTO `mac_vod` VALUES('284','西游记恶搞·雾霾篇《敢问路在何方》  淮秀帮','','xiyoujiegaowumaipianganwenluzaihefanghuaixiubang','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446248551.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','989','0','0','0','0','0','0','5.0','2135','427','1457669335','1457669335','0','0','西游记恶搞·雾霾篇《敢问路在何方》  淮秀帮','youku','0','','XODAxNjIxNTA0','','','','');
INSERT INTO `mac_vod` VALUES('285','夏季压轴狂卷风《高温联播》','','xiajiyazhoukuangjuanfenggaowenlianbo','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446248562.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','113','0','0','0','0','0','0','2.0','314','157','1457669335','1457669335','0','0','夏季压轴狂卷风《高温联播》','youku','0','','149940641#XNzQ4OTcyMDMy','','','','');
INSERT INTO `mac_vod` VALUES('286','狂霸酷炫拽巨制《霸道总裁成长记》  淮秀帮','','kuangbakuxuanzhuaijuzhibadaozongcaichengchangjihuaixiubang','K','','http://www.egao8.cc/upload/vod/2015-10-12/14446248573.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','623','0','0','0','0','0','0','4.0','932','233','1457669335','1457669335','0','0','狂霸酷炫拽巨制《霸道总裁成长记》  淮秀帮','youku','0','','XNzc0Mjg4MTI0','','','','');
INSERT INTO `mac_vod` VALUES('287','淮秀帮爆笑短片进击的世界','','huaixiubangbaoxiaoduanpianjinjideshijie','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446248584.gif','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','429','0','0','0','0','0','0','7.0','2737','391','1457669335','1457669335','0','0','淮秀帮爆笑短片进击的世界','youku','0','','XNzM4NjcwMTEy','','','','');
INSERT INTO `mac_vod` VALUES('288','假如这些游戏都拍成电视剧','','jiaruzhexieyouxidupaichengdianshiju','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446248605.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','161','0','0','0','0','0','0','4.0','1904','476','1457669335','1457669335','0','0','假如这些游戏都拍成电视剧','youku','0','','XNzQxNDcxMTA4','','','','');
INSERT INTO `mac_vod` VALUES('289','恶搞配音毕业生伤不起——毕业了我们一无所有','','egaopeiyinbiyeshengshangbuqibiyeliaowomenyiwusuoyou','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248616.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','415','0','0','0','0','0','0','1.0','68','68','1457669335','1457669335','0','0','恶搞配音毕业生伤不起——毕业了我们一无所有','youku','0','','89683308','','','','');
INSERT INTO `mac_vod` VALUES('290','恶搞配音最强洗脑中国广告史','','egaopeiyinzuiqiangxinaozhongguoguanggaoshi','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248627.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','9','0','0','0','0','0','0','4.0','432','108','1457669335','1457669335','0','0','恶搞配音最强洗脑中国广告史','youku','0','','XNzA1MTg1MTA0','','','','');
INSERT INTO `mac_vod` VALUES('291','熊孩子的成名捷径','','xionghaizidechengmingjiejing','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446248638.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','227','0','0','0','0','0','0','9.0','162','18','1457669335','1457669335','0','0','熊孩子的成名捷径','youku','0','','XNjk2ODA1NDc2','','','','');
INSERT INTO `mac_vod` VALUES('292','恶搞还珠格格—铁锹部的孩纸伤不起啊','','egaohuaizhugegetieqiaobudehaizhishangbuqia','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248649.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','74','0','0','0','0','0','0','6.0','1998','333','1457669335','1457669335','0','0','恶搞还珠格格—铁锹部的孩纸伤不起啊','youku','0','','74052830','','','','');
INSERT INTO `mac_vod` VALUES('293','恶搞《新西游记》坑爹啊！！','','egaoxinxiyoujikangdiea','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462486510.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','522','0','0','0','0','0','0','1.0','319','319','1457669335','1457669335','0','0','恶搞《新西游记》坑爹啊！！','youku','0','','88349126','','','','');
INSERT INTO `mac_vod` VALUES('294','不作死就不会死逗比爱情事故','','buzuosijiubuhuisidoubiaiqingshigu','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462486511.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','762','0','0','0','0','0','0','9.0','927','103','1457669335','1457669335','0','0','不作死就不会死逗比爱情事故','youku','0','','XNjc1MzkwNTk2','','','','');
INSERT INTO `mac_vod` VALUES('295','毫无违和感！都敏俊，救救女王！','','haowuweiheganduminjunjiujiunvwang','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462486612.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','455','0','0','0','0','0','0','3.0','894','298','1457669335','1457669335','0','0','毫无违和感！都敏俊，救救女王！','youku','0','','XNjc5MjE0MTky','','','','');
INSERT INTO `mac_vod` VALUES('296','恶搞配音秋裤体群星版——有一种寒冷叫忘穿秋裤！','','egaopeiyinqiukutiqunxingbanyouyizhonghanlingjiaowangchuanqiuku','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462486713.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','979','0','0','0','0','0','0','4.0','492','123','1457669335','1457669335','0','0','恶搞配音秋裤体群星版——有一种寒冷叫忘穿秋裤！','youku','0','','83158373','','','','');
INSERT INTO `mac_vod` VALUES('297','恶搞老人摔倒了，你就去扶！','','egaolaorenshuaidaoliaonijiuqufu','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462486814.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','683','0','0','0','0','0','0','4.0','136','34','1457669335','1457669335','0','0','恶搞老人摔倒了，你就去扶！','youku','0','','79466398','','','','');
INSERT INTO `mac_vod` VALUES('298','恶搞周星驰、容嬷嬷现场解说110米栏决赛','','egaozhouxingchirongmamaxianchangjieshuo110milanjuesai','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462487115.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','132','0','0','0','0','0','0','10.0','3450','345','1457669335','1457669335','0','0','恶搞周星驰、容嬷嬷现场解说110米栏决赛','youku','0','','74995509','','','','');
INSERT INTO `mac_vod` VALUES('299','恶搞新白娘子传奇相亲记——我们结婚吧','','egaoxinbainiangzichuanqixiangqinjiwomenjiehunba','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462487216.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','362','0','0','0','0','0','0','1.0','355','355','1457669335','1457669335','0','0','恶搞新白娘子传奇相亲记——我们结婚吧','youku','0','','103881067#77553861','','','','');
INSERT INTO `mac_vod` VALUES('300','恶搞还珠格格、新白娘子传奇 尔康遇蛇变许仙','','egaohuaizhugegexinbainiangzichuanqierkangyushebianxuxian','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462487317.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','127','0','0','0','0','0','0','9.0','4248','472','1457669335','1457669335','0','0','恶搞还珠格格、新白娘子传奇 尔康遇蛇变许仙','youku','0','','76436301','','','','');
INSERT INTO `mac_vod` VALUES('301','[恶搞配音]新还珠格格——大运会， 我们来了','','egaopeiyinxinhuaizhugegedayunhuiwomenlailiao','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462487318.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','149','0','0','0','0','0','0','4.0','1356','339','1457669339','1457669339','0','0','【恶搞配音】新还珠格格——大运会， 我们来了','youku','0','','74270172','','','','');
INSERT INTO `mac_vod` VALUES('302','恶搞配音为什么没有男朋友','','egaopeiyinweishimemeiyounanpengyou','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462487419.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','370','0','0','0','0','0','0','10.0','4580','458','1457669339','1457669339','0','0','恶搞配音为什么没有男朋友','youku','0','','90916077','','','','');
INSERT INTO `mac_vod` VALUES('303','恶搞新还珠格格——大运会， 我们来了','','egaoxinhuaizhugegedayunhuiwomenlailiao','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248801.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','200','0','0','0','0','0','0','7.0','2205','315','1457669339','1457669339','0','0','恶搞新还珠格格——大运会， 我们来了','youku','0','','74270172','','','','');
INSERT INTO `mac_vod` VALUES('304','恶搞配音各种劳模大盘点——人类很忙！','','egaopeiyingezhonglaomodapandianrenleihenmang','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248812.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','767','0','0','0','0','0','0','4.0','20','5','1457669339','1457669339','0','0','恶搞配音各种劳模大盘点——人类很忙！','youku','0','','XMzkzMjcwNTY4','','','','');
INSERT INTO `mac_vod` VALUES('305','恶搞《画皮2》网络热点版宣传片！','','egaohuapi2wangluoredianbanxuanchuanpian','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248823.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','170','0','0','0','0','0','0','1.0','360','360','1457669339','1457669339','0','0','恶搞《画皮2》网络热点版宣传片！','youku','0','','93636509','','','','');
INSERT INTO `mac_vod` VALUES('306','恶搞新闻联播——315消费权益微观察','','egaoxinwenlianbo315xiaofeiquanyiweiguancha','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248824.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','725','0','0','0','0','0','0','1.0','67','67','1457669339','1457669339','0','0','恶搞新闻联播——315消费权益微观察','youku','0','','91414752','','','','');
INSERT INTO `mac_vod` VALUES('307','搜索体群星总动员——工作工作！','','sousuotiqunxingzongdongyuangongzuogongzuo','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446248835.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','216','0','0','0','0','0','0','2.0','604','302','1457669339','1457669339','0','0','搜索体群星总动员——工作工作！','youku','0','','103260684','','','','');
INSERT INTO `mac_vod` VALUES('308','夏季坑爹巨献——减肥！减肥！','','xiajikangdiejuxianjianfeijianfei','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446248846.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','149','0','0','0','0','0','0','2.0','694','347','1457669339','1457669339','0','0','夏季坑爹巨献——减肥！减肥！','youku','0','','XMzk4MTYwNzcy','','','','');
INSERT INTO `mac_vod` VALUES('309','恶搞天气预报——坑爹的鬼天气！','','egaotianqiyubaokangdiedeguitianqi','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248887.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','997','0','0','2','0','0','0','10.0','2200','220','1457669339','1457669339','1458478018','0','恶搞天气预报——坑爹的鬼天气！','youku','0','','92927917','','','','');
INSERT INTO `mac_vod` VALUES('310','钓鱼岛绝不退让——血性抗日理性爱国！','','diaoyudaojuebutuirangxuexingkangrilixingaiguo','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446248898.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','447','0','0','0','0','0','0','6.0','1782','297','1457669339','1457669339','0','0','钓鱼岛绝不退让——血性抗日理性爱国！','youku','0','','112745319','','','','');
INSERT INTO `mac_vod` VALUES('311','恶搞配音《舌尖上的中国》之社会万象篇','','egaopeiyinshejianshangdezhongguozhishehuiwanxiangpian','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446248909.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','663','0','0','0','0','0','0','10.0','4410','441','1457669339','1457669339','0','0','恶搞配音《舌尖上的中国》之社会万象篇','youku','0','','XNDA3MTU2Njky','','','','');
INSERT INTO `mac_vod` VALUES('312','买票难篇人在囧途之冬囧','','maipiaonanpianrenzaituzhidong','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462489210.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','523','0','0','0','0','0','0','6.0','732','122','1457669339','1457669339','0','0','买票难篇人在囧途之冬囧','youku','0','','XNTA1MTQwNTgw','','','','');
INSERT INTO `mac_vod` VALUES('313','爆笑末日狂想曲——《末日联播》','','baoxiaomorikuangxiangqumorilianbo','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462489311.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','876','0','0','0','0','0','0','2.0','88','44','1457669339','1457669339','0','0','爆笑末日狂想曲——《末日联播》','youku','0','','122368234','','','','');
INSERT INTO `mac_vod` VALUES('314','爆笑新闻联播——暑期荧屏大盘点！','','baoxiaoxinwenlianboshuqiyingpingdapandian','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462489412.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','786','0','0','0','0','0','0','8.0','2184','273','1457669339','1457669339','0','0','爆笑新闻联播——暑期荧屏大盘点！','youku','0','','107937650','','','','');
INSERT INTO `mac_vod` VALUES('315','恶搞配音开春巨献《春节变奏曲》','','egaopeiyinkaichunjuxianchunjiebianzouqu','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462489513.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','789','0','0','0','0','0','0','2.0','716','358','1457669339','1457669339','0','0','恶搞配音开春巨献《春节变奏曲》','youku','0','','128939711','','','','');
INSERT INTO `mac_vod` VALUES('316','冬季降温励志传奇《感冒进行曲》','','dongjijiangwenlizhichuanqiganmaojinxingqu','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462489714.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','140','0','0','0','0','0','0','7.0','3185','455','1457669339','1457669339','0','0','冬季降温励志传奇《感冒进行曲》','youku','0','','158857567','','','','');
INSERT INTO `mac_vod` VALUES('317','爆笑坑爹双语大片《HELLO甄嬛》！','','baoxiaokangdieshuangyudapianHELLOzhen','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462490115.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','60','0','0','0','0','0','0','9.0','4131','459','1457669339','1457669339','0','0','爆笑坑爹双语大片《HELLO甄嬛》！','youku','0','','127648319','','','','');
INSERT INTO `mac_vod` VALUES('318','百家讲坛神吐槽<十大逆袭情侣>','','baijiajiangtanshentucaoshidanixiqinglv','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462490216.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','992','0','0','0','0','0','0','9.0','1089','121','1457669339','1457669339','0','0','百家讲坛神吐槽','youku','0','','130226639#130428941','','','','');
INSERT INTO `mac_vod` VALUES('319','恶搞配音我是老妈是萌货','','egaopeiyinwoshilaomashimenghuo','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462490317.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','845','0','0','0','0','0','0','1.0','177','177','1457669339','1457669339','0','0','恶搞配音我是老妈是萌货','youku','0','','138476582','','','','');
INSERT INTO `mac_vod` VALUES('320','唐僧大话吐槽扫毒《真的预告片》','','tangsengdahuatucaosaoduzhendeyugaopian','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462490818.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','249','0','0','0','0','0','0','8.0','3784','473','1457669339','1457669339','0','0','唐僧大话吐槽扫毒《真的预告片》','youku','0','','160756897','','','','');
INSERT INTO `mac_vod` VALUES('321','恶搞配音熄灯一小时翻滚吧，地球','','egaopeiyinxidengyixiaoshifangunbadiqiu','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462490919.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','800','0','0','0','0','0','0','6.0','534','89','1457669344','1457669344','0','0','恶搞配音熄灯一小时翻滚吧，地球','youku','0','','132537639','','','','');
INSERT INTO `mac_vod` VALUES('322','爆笑励志传奇《了不起的女汉子》','','baoxiaolizhichuanqiliaobuqidenvhanzi','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446249161.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','316','0','0','0','0','0','0','1.0','464','464','1457669344','1457669344','0','0','爆笑励志传奇《了不起的女汉子》','youku','0','','152442888','','','','');
INSERT INTO `mac_vod` VALUES('323','2014新春定制除夕在路上','','2014xinchundingzhichuxizailushang','2','','http://www.egao8.cc/upload/vod/2015-10-12/14446249172.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','81','0','0','0','0','0','0','9.0','207','23','1457669344','1457669344','0','0','2014新春定制除夕在路上','youku','0','','XNjY3NDA4MjM2','','','','');
INSERT INTO `mac_vod` VALUES('324','恶搞配音三角演义·舌战群腐','','egaopeiyinsanjiaoyanyishezhanqunfu','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249183.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','99','0','0','0','0','0','0','2.0','596','298','1457669344','1457669344','0','0','恶搞配音三角演义·舌战群腐','youku','0','','159070118','','','','');
INSERT INTO `mac_vod` VALUES('325','期末励志传奇《学霸去哪儿》','','qimolizhichuanqixuebaqunaer','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446249194.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','344','0','0','0','0','0','0','2.0','116','58','1457669344','1457669344','0','0','期末励志传奇《学霸去哪儿》','youku','0','','160922794','','','','');
INSERT INTO `mac_vod` VALUES('326','来自地球的女蛇精病女性励志疯神榜','','laizidiqiudenvshejingbingnvxinglizhifengshenbang','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446249205.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','6','0','0','0','0','0','0','8.0','3432','429','1457669344','1457669344','0','0','来自地球的女蛇精病女性励志疯神榜','youku','0','','XNjc3OTYyNTUy','','','','');
INSERT INTO `mac_vod` VALUES('327','恶搞创意配音大闹春晚','','egaochuangyipeiyindanaochunwan','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249216.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','746','0','0','0','0','0','0','10.0','220','22','1457669344','1457669344','0','0','恶搞创意配音大闹春晚','youku','0','','XNjY4ODMzODM2','','','','');
INSERT INTO `mac_vod` VALUES('328','恶搞新白娘子传奇结婚记—收红包有妙方','','egaoxinbainiangzichuanqijiehunjishouhongbaoyoumiaofang','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249227.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','942','0','0','0','0','0','0','1.0','58','58','1457669344','1457669344','0','0','恶搞新白娘子传奇结婚记—收红包有妙方','youku','0','','78698132','','','','');
INSERT INTO `mac_vod` VALUES('329','恶搞还珠格格新白娘子传奇—经典尼玛伤不起','','egaohuaizhugegexinbainiangzichuanqijingdiannimashangbuqi','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249268.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','943','0','0','0','0','0','0','3.0','1476','492','1457669344','1457669344','0','0','恶搞还珠格格新白娘子传奇—经典尼玛伤不起','youku','0','','72457562','','','','');
INSERT INTO `mac_vod` VALUES('330','恶搞倾世皇妃——神马，油价下调啦！','','egaoqingshihuangfeishenmayoujiaxiadiaola','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249269.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','314','0','0','0','0','0','0','10.0','1390','139','1457669344','1457669344','0','0','恶搞倾世皇妃——神马，油价下调啦！','youku','0','','78526079','','','','');
INSERT INTO `mac_vod` VALUES('331','恶搞配音群星公益贺岁——校车争霸赛！','','egaopeiyinqunxinggongyihesuixiaochezhengbasai','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462492710.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','91','0','0','0','0','0','0','6.0','1788','298','1457669344','1457669344','0','0','恶搞配音群星公益贺岁——校车争霸赛！','youku','0','','85414900','','','','');
INSERT INTO `mac_vod` VALUES('332','[恶搞]情深深雨蒙蒙——你买到车票了吗？','','egaoqingshenshenyumengmengnimaidaochepiaoliaoma','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462492811.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','28','0','0','0','0','0','0','8.0','3008','376','1457669344','1457669344','0','0','【恶搞】情深深雨蒙蒙——你买到车票了吗？','youku','0','','77040777','','','','');
INSERT INTO `mac_vod` VALUES('333','恶搞配音年度荧屏大盘点四爷很忙','','egaopeiyinnianduyingpingdapandiansiyehenmang','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462492812.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','846','0','0','0','0','0','0','9.0','144','16','1457669344','1457669344','0','0','恶搞配音年度荧屏大盘点四爷很忙','youku','0','','87032119','','','','');
INSERT INTO `mac_vod` VALUES('334','新还珠格格B体终极吐槽——我们已经尽力了','','xinhuaizhugegeBtizhongjitucaowomenyijingjinliliao','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462492913.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','489','0','0','0','0','0','0','2.0','442','221','1457669344','1457669344','0','0','新还珠格格TVB体终极吐槽——我们已经尽力了','youku','0','','75605178','','','','');
INSERT INTO `mac_vod` VALUES('335','伤不起的毕业季——再见，大学！','','shangbuqidebiyejizaijiandaxue','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462493014.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','366','0','0','0','0','0','0','8.0','3808','476','1457669344','1457669344','0','0','伤不起的毕业季——再见，大学！','youku','0','','102785983','','','','');
INSERT INTO `mac_vod` VALUES('336','淮秀帮恶搞配音 军训尼玛伤不起','','huaixiubangegaopeiyinjunxunnimashangbuqi','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462493015.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','605','0','0','0','0','0','0','5.0','1885','377','1457669344','1457669344','0','0','淮秀帮恶搞配音 军训尼玛伤不起','youku','0','','74803524','','','','');
INSERT INTO `mac_vod` VALUES('337','双十一光棍节特辑——单身style！','','shuangshiyiguanggunjietejidanshenstyle','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462493116.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','305','0','0','0','0','0','0','3.0','765','255','1457669344','1457669344','0','0','双十一光棍节特辑——单身style！','youku','0','','117916839','','','','');
INSERT INTO `mac_vod` VALUES('338','恶搞2011十大事件终极大盘点！','','egao2011shidashijianzhongjidapandian','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462493217.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','781','0','0','0','0','0','0','5.0','1495','299','1457669344','1457669344','0','0','恶搞2011十大事件终极大盘点！','youku','0','','87539173','','','','');
INSERT INTO `mac_vod` VALUES('339','第十三放映室之综艺大观','','dishisanfangyingshizhizongyidaguan','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462493318.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','820','0','0','0','0','0','0','10.0','1820','182','1457669344','1457669344','0','0','第十三放映室之综艺大观','youku','0','','135642250','','','','');
INSERT INTO `mac_vod` VALUES('340','恶搞配音坑爹的谣言时代！','','egaopeiyinkangdiedeyaoyanshidai','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462493419.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','925','0','0','0','0','0','0','5.0','940','188','1457669344','1457669344','0','0','恶搞配音坑爹的谣言时代！','youku','0','','XMzg4OTA3MzI4','','','','');
INSERT INTO `mac_vod` VALUES('341','七夕来了——终极脱光宝典','','qixilailiaozhongjituoguangbaodian','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446249411.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','568','0','0','0','0','0','0','9.0','3006','334','1457669348','1457669348','0','0','七夕来了——终极脱光宝典','youku','0','','XNTk0ODY4MzUy','','','','');
INSERT INTO `mac_vod` VALUES('342','奥运会犀利吐槽——我靠 伦敦！','','aoyunhuixilitucaowokaolundun','A','','http://www.egao8.cc/upload/vod/2015-10-12/14446249422.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','441','0','0','0','0','0','0','3.0','1491','497','1457669348','1457669348','0','0','奥运会犀利吐槽——我靠 伦敦！','youku','0','','109571855','','','','');
INSERT INTO `mac_vod` VALUES('343','恶搞配音史诗励志传奇《土豪去哪儿》','','egaopeiyinshishilizhichuanqituhaoqunaer','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249443.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','704','0','0','0','0','0','0','5.0','200','40','1457669348','1457669348','0','0','恶搞配音史诗励志传奇《土豪去哪儿》','youku','0','','156810708','','','','');
INSERT INTO `mac_vod` VALUES('344','恶搞配音我的大学','','egaopeiyinwodedaxue','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249454.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','236','0','0','0','0','0','0','1.0','431','431','1457669348','1457669348','0','0','恶搞配音我的大学','youku','0','','144365120','','','','');
INSERT INTO `mac_vod` VALUES('345','妇女节献礼巾帼十二拆','','funvjiexianlijinguoshierchai','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446249475.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','885','0','0','0','0','0','0','8.0','3016','377','1457669348','1457669348','0','0','妇女节献礼巾帼十二拆','youku','0','','XNjgyMjYyMDEy','','','','');
INSERT INTO `mac_vod` VALUES('346','疯狂夏日爆笑吐槽《选秀时代》','','fengkuangxiaribaoxiaotucaoxuanxiushidai','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446249486.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','717','0','0','0','0','0','0','6.0','2652','442','1457669348','1457669348','0','0','疯狂夏日爆笑吐槽《选秀时代》','youku','0','','147553120','','','','');
INSERT INTO `mac_vod` VALUES('347','北京爱情故事特制的逗比版预告片','','beijingaiqinggushitezhidedoubibanyugaopian','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446249497.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','268','0','0','0','0','0','0','3.0','525','175','1457669348','1457669348','0','0','北京爱情故事特制的逗比版预告片','youku','0','','XNjcyMDg5MTAw','','','','');
INSERT INTO `mac_vod` VALUES('348','恶搞新闻联播春运微观察——周杰伦买票有高招','','egaoxinwenlianbochunyunweiguanchazhoujielunmaipiaoyougaozhao','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249508.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','790','0','0','0','0','0','0','3.0','702','234','1457669348','1457669348','0','0','恶搞新闻联播春运微观察——周杰伦买票有高招','youku','0','','85683289','','','','');
INSERT INTO `mac_vod` VALUES('349','淮秀帮四周年感谢有你','','huaixiubangsizhounianganxieyouni','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446249519.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','508','0','0','0','0','0','0','2.0','22','11','1457669348','1457669348','0','0','淮秀帮四周年感谢有你','youku','0','','160776668','','','','');
INSERT INTO `mac_vod` VALUES('350','恶搞配音芒果台招商大会','','egaopeiyinmangguotaizhaoshangdahui','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462495210.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','861','0','0','0','0','0','0','9.0','2322','258','1457669348','1457669348','0','0','恶搞配音芒果台招商大会','youku','0','','157694784','','','','');
INSERT INTO `mac_vod` VALUES('351','走进淮秀帮','','zoujinhuaixiubang','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462495311.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','761','0','0','0','0','0','0','9.0','1917','213','1457669348','1457669348','0','0','走进淮秀帮','youku','0','','150485436','','','','');
INSERT INTO `mac_vod` VALUES('352','夏季坑爹巨献——暑假来了！','','xiajikangdiejuxianshujialailiao','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462495412.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','836','0','0','0','0','0','0','7.0','1540','220','1457669348','1457669348','0','0','夏季坑爹巨献——暑假来了！','youku','0','','106164552','','','','');
INSERT INTO `mac_vod` VALUES('353','致我们终将牛逼的青春','','zhiwomenzhongjiangniubideqingchun','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462495513.gif','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','685','0','0','0','0','0','0','5.0','1795','359','1457669348','1457669348','0','0','致我们终将牛逼的青春','youku','0','','XNTQ5MjUxMDE2','','','','');
INSERT INTO `mac_vod` VALUES('354','新闻胡播“猪后腿也比环姐美”','','xinwenhubozhuhoutuiyebihuanjiemei','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462495614.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','122','0','0','0','0','0','0','3.0','213','71','1457669348','1457669348','0','0','新闻胡播“猪后腿也比环姐美”','youku','0','','109317423','','','','');
INSERT INTO `mac_vod` VALUES('355','金星撞火星 淮秀帮特辑','','jinxingzhuanghuoxinghuaixiubangteji','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462495715.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','434','0','0','0','0','0','0','5.0','1390','278','1457669348','1457669348','0','0','金星撞火星 淮秀帮特辑','youku','0','','110082771','','','','');
INSERT INTO `mac_vod` VALUES('356','一颗桃子引发的血案！爆笑！','','yiketaoziyinfadexueanbaoxiao','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462495716.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','625','0','0','0','0','0','0','2.0','28','14','1457669348','1457669348','0','0','一颗桃子引发的血案！爆笑！','youku','0','','122703399','','','','');
INSERT INTO `mac_vod` VALUES('357','恶搞中秋许仙买月饼 新白娘子传奇','','egaozhongqiuxuxianmaiyuebingxinbainiangzichuanqi','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462495917.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','666','0','0','0','0','0','0','9.0','423','47','1457669348','1457669348','0','0','恶搞中秋许仙买月饼 新白娘子传奇','youku','0','','72992885','','','','');
INSERT INTO `mac_vod` VALUES('358','恶搞砍手事件歪唱之《红豆》','','egaokanshoushijianwaichangzhihongdou','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462495918.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','750','0','0','0','0','0','0','2.0','8','4','1457669348','1457669348','0','0','恶搞砍手事件歪唱之《红豆》','youku','0','','78080725','','','','');
INSERT INTO `mac_vod` VALUES('359','剩女的翻天逆袭','','shengnvdefantiannixi','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462496019.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','537','0','0','0','0','0','0','3.0','1485','495','1457669348','1457669348','0','0','剩女的翻天逆袭','youku','0','','107400683','','','','');
INSERT INTO `mac_vod` VALUES('360','《新娱乐在线》解析恶搞《四爷很忙》','','xinyulezaixianjiexiegaosiyehenmang','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446249691.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','405','0','0','0','0','0','0','4.0','968','242','1457669348','1457669348','0','0','《新娱乐在线》解析恶搞《四爷很忙》','youku','0','','87172844','','','','');
INSERT INTO `mac_vod` VALUES('361','又见白娘子——拜大树爷考四级','','youjianbainiangzibaidashuyekaosiji','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446249702.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','703','0','0','0','0','0','0','6.0','1200','200','1457669352','1457669352','0','0','又见白娘子——拜大树爷考四级','youku','0','','69215284','','','','');
INSERT INTO `mac_vod` VALUES('362','百变大咖秀群星版——模仿风暴！','','baibiandakaxiuqunxingbanmofangfengbao','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446249713.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','996','0','0','0','0','0','0','6.0','1098','183','1457669352','1457669352','0','0','百变大咖秀群星版——模仿风暴！','youku','0','','106073319','','','','');
INSERT INTO `mac_vod` VALUES('363','恶搞《孽海花·桂花糕》之韩剧版','','egaoniehaihuaguihuagaozhihanjuban','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249724.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','320','0','0','0','0','0','0','5.0','2450','490','1457669352','1457669352','0','0','恶搞《孽海花·桂花糕》之韩剧版','youku','0','','50839166','','','','');
INSERT INTO `mac_vod` VALUES('364','河南考生伤不起 还珠格格恶搞配音','','henankaoshengshangbuqihuaizhugegeegaopeiyin','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446249725.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','428','0','0','0','0','0','0','2.0','58','29','1457669352','1457669352','0','0','河南考生伤不起 还珠格格恶搞配音','youku','0','','XMjg0MjQwNDg0','','','','');
INSERT INTO `mac_vod` VALUES('365','恶搞配音 痞子英雄619上映宣传——女纸好逑真英雄！','','egaopeiyinpiziyingxiong619shangyingxuanchuannvzhihaoqiuzhenyingxiong','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249736.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','44','0','0','0','0','0','0','9.0','3987','443','1457669352','1457669352','0','0','恶搞配音 痞子英雄619上映宣传——女纸好逑真英雄！','youku','0','','103846493','','','','');
INSERT INTO `mac_vod` VALUES('366','新还珠、宫、新白娘子传奇——《疯狂的白菜》','','xinhuaizhugongxinbainiangzichuanqifengkuangdebaicai','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446249837.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','108','0','0','0','0','0','0','10.0','2340','234','1457669352','1457669352','0','0','新还珠、宫、新白娘子传奇——《疯狂的白菜》','youku','0','','73941564','','','','');
INSERT INTO `mac_vod` VALUES('367','恶搞配音 泰坦尼克——屌丝也有春天！！！','','egaopeiyintaitannikesiyeyouchuntian','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446249848.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','32','0','0','0','0','0','0','4.0','1548','387','1457669352','1457669352','0','0','恶搞配音 泰坦尼克——屌丝也有春天！！！','youku','0','','94897076','','','','');
INSERT INTO `mac_vod` VALUES('368','还珠格格—小燕子紫薇考公务员记 全集','','huaizhugegexiaoyanziziweikaogongwuyuanjiquanji','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446249859.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','943','0','0','0','0','0','0','2.0','998','499','1457669352','1457669352','0','0','还珠格格—小燕子紫薇考公务员记 全集','youku','0','','67227283#67759412','','','','');
INSERT INTO `mac_vod` VALUES('369','[恶搞配音]鸭梨山大怎么办？群星怒吼“别惹我！”','','egaopeiyinyalishandazenmebanqunxingnuhoubieruowo','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462498510.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','939','0','0','0','0','0','0','1.0','401','401','1457669352','1457669352','0','0','【恶搞配音】鸭梨山大怎么办？群星怒吼“别惹我！”','youku','0','','82591556','','','','');
INSERT INTO `mac_vod` VALUES('370','恶搞配音《还珠格格》之如人荡漾篇','','egaopeiyinhuaizhugegezhirurendangyangpian','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462498611.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','338','0','0','0','0','0','0','5.0','1400','280','1457669352','1457669352','0','0','恶搞配音《还珠格格》之如人荡漾篇','youku','0','','53652411','','','','');
INSERT INTO `mac_vod` VALUES('371','恶搞新白娘子传奇版《NO BODY》','','egaoxinbainiangzichuanqibanNOBODY','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462498712.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','924','0','0','0','0','0','0','3.0','936','312','1457669352','1457669352','0','0','恶搞新白娘子传奇版《NO BODY》','youku','0','','50318875','','','','');
INSERT INTO `mac_vod` VALUES('372','新白娘子传奇恶搞版《回家的诱惑》','','xinbainiangzichuanqiegaobanhuijiadeyouhuo','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462498713.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','200','0','0','0','0','0','0','3.0','834','278','1457669352','1457669352','0','0','新白娘子传奇恶搞版《回家的诱惑》','youku','0','','63773863','','','','');
INSERT INTO `mac_vod` VALUES('373','恶搞新闻联播 新白娘子特效','','egaoxinwenlianboxinbainiangzitexiao','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462498814.jpg','','','','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','640','0','0','0','0','0','0','3.0','594','198','1457669352','1457669352','0','0','恶搞新闻联播 新白娘子特效','youku','0','','69957508','','','','');
INSERT INTO `mac_vod` VALUES('374','淮秀帮歪歌 游戏乱炖版《小苹果》','','huaixiubangwaigeyouxiluandunbanxiaopingguo','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562823690.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','935','0','0','0','0','0','0','4.0','1792','448','1457669352','1457669352','0','0','淮秀帮歪歌 游戏乱炖版《小苹果》','youku','0','','XNzQzMzY2MzM2','','','','');
INSERT INTO `mac_vod` VALUES('375','淮秀帮恶搞配音《进击的CP粉》','','huaixiubangegaopeiyinjinjideCPfen','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562823560.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','245','0','0','0','0','0','0','5.0','1940','388','1457669352','1457669352','0','0','淮秀帮恶搞配音《进击的CP粉》','youku','0','','XNzkyMTg3MTE2','','','','');
INSERT INTO `mac_vod` VALUES('376','淮秀帮恶搞配音《秋冬四大错觉》','','huaixiubangegaopeiyinqiudongsidacuojue','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562821380.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','449','0','0','0','0','0','0','10.0','4910','491','1457669352','1457669352','0','0','淮秀帮恶搞配音《秋冬四大错觉》','youku','0','','XODM2MTg0NTE2','','','','');
INSERT INTO `mac_vod` VALUES('377','恶搞配音 霸道总裁成长记','','egaopeiyinbadaozongcaichengchangji','E','','http://www.egao8.cc/upload/vod/2016-02-24/14562821280.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','395','0','0','0','0','0','0','9.0','4140','460','1457669352','1457669352','0','0','恶搞配音 霸道总裁成长记','youku','0','','XNzc0Mjg4MTI0','','','','');
INSERT INTO `mac_vod` VALUES('378','淮秀帮光棍节巨献《脱单吧，兄弟》','','huaixiubangguanggunjiejuxiantuodanbaxiongdi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562821110.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','149','0','0','0','0','0','0','10.0','3610','361','1457669352','1457669352','0','0','淮秀帮光棍节巨献《脱单吧，兄弟》','youku','0','','XODI0MTczNDc2','','','','');
INSERT INTO `mac_vod` VALUES('379','火力全开吐槽神雕侠侣《舌尖上的小龙女》','','huoliquankaitucaoshendiaoxialvshejianshangdexiaolongnv','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562821060.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','246','0','0','0','0','0','0','10.0','2420','242','1457669352','1457669352','0','0','火力全开吐槽神雕侠侣《舌尖上的小龙女》','youku','0','','XODQ1NTcyNjMy','','','','');
INSERT INTO `mac_vod` VALUES('380','淮秀帮配音吐槽股市《翻滚吧 大盘》','','huaixiubangpeiyintucaogushifangunbadapan','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562820930.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','941','0','0','0','0','0','0','5.0','1310','262','1457669352','1457669352','0','0','淮秀帮配音吐槽股市《翻滚吧 大盘》','youku','0','','XOTUxNjIwOTky','','','','');
INSERT INTO `mac_vod` VALUES('381','淮秀帮搞笑配音：港台美日韩版《武媚娘传奇》','','huaixiubanggaoxiaopeiyingangtaimeirihanbanwumeiniangchuanqi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562820810.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','455','0','0','0','0','0','0','10.0','3130','313','1457669356','1457669356','0','0','淮秀帮搞笑配音：港台美日韩版《武媚娘传奇》','youku','0','','XODg0MjYxMTE2','','','','');
INSERT INTO `mac_vod` VALUES('382','淮秀帮搞笑吐槽《盗墓笔记》之翻拍笔记','','huaixiubanggaoxiaotucaodaomubijizhifanpaibiji','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562820760.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','230','0','0','0','0','0','0','4.0','584','146','1457669356','1457669356','0','0','淮秀帮搞笑吐槽《盗墓笔记》之翻拍笔记','youku','0','','XMTI3MDEzNjQ4OA==','','','','');
INSERT INTO `mac_vod` VALUES('383','淮秀帮搞笑配音《薪闻联播》','','huaixiubanggaoxiaopeiyinxinwenlianbo','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562820500.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','177','0','0','0','0','0','0','3.0','1497','499','1457669356','1457669356','0','0','淮秀帮搞笑配音《薪闻联播》','youku','0','','XOTIzODMyMTE2','','','','');
INSERT INTO `mac_vod` VALUES('384','淮秀帮爆笑配音《新十大奇葩绝症》','','huaixiubangbaoxiaopeiyinxinshidaqipajuezheng','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562820460.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','924','0','0','0','0','0','0','10.0','2170','217','1457669356','1457669356','0','0','淮秀帮爆笑配音《新十大奇葩绝症》','youku','0','','XMTMwNjE0NTczNg==','','','','');
INSERT INTO `mac_vod` VALUES('385','热剧主角上考场《奔跑吧！学霸》','','rejuzhujiaoshangkaochangbenpaobaxueba','R','','http://www.egao8.cc/upload/vod/2016-02-24/14562820410.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','69','0','0','0','0','0','0','10.0','3800','380','1457669356','1457669356','0','0','热剧主角上考场《奔跑吧！学霸》','youku','0','','XODc1MTA3MzIw','','','','');
INSERT INTO `mac_vod` VALUES('386','淮秀帮：网购是一种病《购die吧，双十一》','','huaixiubangwanggoushiyizhongbinggoudiebashuangshiyi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562820240.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','429','0','0','0','0','0','0','10.0','4270','427','1457669356','1457669356','0','0','淮秀帮：网购是一种病《购die吧，双十一》','youku','0','','XMTM4MTY5MDIzMg==','','','','');
INSERT INTO `mac_vod` VALUES('387','淮秀帮《装逼学院》之装你麻痹','','huaixiubangzhuangbixueyuanzhizhuangnimabi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562820150.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','288','0','0','0','0','0','0','6.0','1698','283','1457669356','1457669356','0','0','淮秀帮《装逼学院》之装你麻痹','youku','0','','XOTM1MDE2ODIw','','','','');
INSERT INTO `mac_vod` VALUES('388','淮秀帮恶搞《聊斋之开学》恐怖灾难片','','huaixiubangegaoliaozhaizhikaixuekongbuzainanpian','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562820020.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','650','0','0','0','0','0','0','8.0','3840','480','1457669356','1457669356','0','0','淮秀帮恶搞《聊斋之开学》恐怖灾难片','youku','0','','XMTMyNDg1NTU0OA==','','','','');
INSERT INTO `mac_vod` VALUES('389','淮秀帮最新搞笑：《结婚那些事》','','huaixiubangzuixingaoxiaojiehunnaxieshi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562819930.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','489','0','0','0','0','0','0','1.0','286','286','1457669356','1457669356','0','0','淮秀帮最新搞笑：《结婚那些事》','youku','0','','XMTM5OTI0NzUwOA==','','','','');
INSERT INTO `mac_vod` VALUES('390','淮秀帮恶搞配音：避暑神剧的正确打开方式！','','huaixiubangegaopeiyinbishushenjudezhengquedakaifangshi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562819840.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','994','0','0','0','0','0','0','1.0','329','329','1457669356','1457669356','0','0','淮秀帮恶搞配音：避暑神剧的正确打开方式！','youku','0','','XMTMwMDk2NjEyNA==','','','','');
INSERT INTO `mac_vod` VALUES('391','淮秀帮年度神作：一句话终结影视剧！','','huaixiubangniandushenzuoyijuhuazhongjieyingshiju','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562819760.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','828','0','0','0','0','0','0','10.0','2190','219','1457669356','1457669356','0','0','淮秀帮年度神作：一句话终结影视剧！','youku','0','','XMTM1NTU4MjIwNA==','','','','');
INSERT INTO `mac_vod` VALUES('392','淮秀帮最新搞笑视频《我的期末时代》','','huaixiubangzuixingaoxiaoshipinwodeqimoshidai','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562819580.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','368','0','0','0','0','0','0','1.0','177','177','1457669356','1457669356','0','0','淮秀帮最新搞笑视频《我的期末时代》','youku','0','','XMTQ0NTUzMDQ5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('393','淮秀帮恶搞配音《大圣归来》中国动漫逆袭史','','huaixiubangegaopeiyindashengguilaizhongguodongmannixishi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562819450.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','962','0','0','0','0','0','0','5.0','790','158','1457669356','1457669356','0','0','淮秀帮恶搞配音《大圣归来》中国动漫逆袭史','youku','0','','XMTMxMjI3Mjk3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('394','淮秀帮最新搞笑视频：《琅琊榜》的正确配对方式！','','huaixiubangzuixingaoxiaoshipinlangyabangdezhengquepeiduifangshi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562819410.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','177','0','0','0','0','0','0','7.0','3339','477','1457669356','1457669356','0','0','淮秀帮最新搞笑视频：《琅琊榜》的正确配对方式！','youku','0','','XMTM2OTgwOTg0NA==','','','','');
INSERT INTO `mac_vod` VALUES('395','淮秀帮恶搞配音《半月传》之后宫作死传奇！','','huaixiubangegaopeiyinbanyuechuanzhihougongzuosichuanqi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562819220.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','48','0','0','0','0','0','0','9.0','3888','432','1457669356','1457669356','0','0','淮秀帮恶搞配音《半月传》之后宫作死传奇！','youku','0','','XMTQ2MzkwNTc4NA==','','','','');
INSERT INTO `mac_vod` VALUES('396','年度最强恐怖片《开学传说》淮秀帮巨制','','nianduzuiqiangkongbupiankaixuechuanshuohuaixiubangjuzhi','N','','http://www.egao8.cc/upload/vod/2016-02-24/14562819180.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','328','0','0','0','0','0','0','2.0','864','432','1457669356','1457669356','0','0','年度最强恐怖片《开学传说》淮秀帮巨制','youku','0','','XMTMyNDg1NTU0OA==','','','','');
INSERT INTO `mac_vod` VALUES('397','淮秀帮恶搞配音：年终财务报表《钱都去哪儿了》！','','huaixiubangegaopeiyinnianzhongcaiwubaobiaoqianduqunaerliao','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562819130.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','741','0','0','0','0','0','0','5.0','600','120','1457669356','1457669356','0','0','淮秀帮恶搞配音：年终财务报表《钱都去哪儿了》！','youku','0','','XMTQ2NjAwMDk3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('398','西游记·雾霾篇《敢问路在何方》','','xiyoujiwumaipianganwenluzaihefang','X','','http://www.egao8.cc/upload/vod/2016-02-24/14562813590.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','227','0','0','0','0','0','0','3.0','1488','496','1457669356','1457669356','0','0','西游记·雾霾篇《敢问路在何方》','tudou','0','','215097946','','','','');
INSERT INTO `mac_vod` VALUES('399','淮秀帮自制大剧《进击的世界杯》','','huaixiubangzizhidajujinjideshijiebei','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562813480.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','198','0','0','0','0','0','0','6.0','288','48','1457669356','1457669356','0','0','淮秀帮自制大剧《进击的世界杯》','youku','0','','XNzM4NjcwMTEy','','','','');
INSERT INTO `mac_vod` VALUES('400','淮秀帮恶搞《中国广告史》','','huaixiubangegaozhongguoguanggaoshi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562813350.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','781','0','0','0','0','0','0','3.0','1116','372','1457669356','1457669356','0','0','淮秀帮恶搞《中国广告史》','youku','0','','XNzA1MTg1MTA0','','','','');
INSERT INTO `mac_vod` VALUES('401','《爸爸去哪儿》的正确打开方式','','babaqunaerdezhengquedakaifangshi','B','','http://www.egao8.cc/upload/vod/2016-02-24/14562813240.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','74','0','0','0','0','0','0','3.0','888','296','1457669360','1457669360','0','0','《爸爸去哪儿》的正确打开方式','youku','0','','XNzU5NzQwOTEy','','','','');
INSERT INTO `mac_vod` VALUES('402','淮秀帮恶搞配音《进击的世界杯》！','','huaixiubangegaopeiyinjinjideshijiebei','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562813150.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','395','0','0','0','0','0','0','10.0','110','11','1457669360','1457669360','0','0','淮秀帮恶搞配音《进击的世界杯》！','youku','0','','XNzM3MjQ3NDM2','','','','');
INSERT INTO `mac_vod` VALUES('403','淮秀帮最新搞笑《芈月传》pk《琅琊榜》','','huaixiubangzuixingaoxiaomiyuechuanpklangyabang','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562813020.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','527','0','0','0','0','0','0','2.0','382','191','1457669360','1457669360','0','0','淮秀帮最新搞笑《芈月传》pk《琅琊榜》','youku','0','','XMTQzNzI3MDc0MA==','','','','');
INSERT INTO `mac_vod` VALUES('404','淮秀帮2016恶搞：春晚大吐槽《戏说春晚》！','','huaixiubang2016egaochunwandatucaoxishuochunwan','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562812840.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','975','0','0','0','0','0','0','6.0','714','119','1457669360','1457669360','0','0','淮秀帮2016恶搞：春晚大吐槽《戏说春晚》！','youku','0','','XMTQ3MTUyMzk4NA==','','','','');
INSERT INTO `mac_vod` VALUES('405','淮秀帮吐槽选秀 熊孩子的成名捷径','','huaixiubangtucaoxuanxiuxionghaizidechengmingjiejing','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562812750.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','212','0','0','0','0','0','0','2.0','624','312','1457669360','1457669360','0','0','淮秀帮吐槽选秀 熊孩子的成名捷径','youku','0','','XNjk2ODA1NDc2','','','','');
INSERT INTO `mac_vod` VALUES('406','淮秀帮爆笑：现实江湖风云再起《新神奇四侠》','','huaixiubangbaoxiaoxianshijianghufengyunzaiqixinshenqisixia','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562812660.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','929','0','0','0','0','0','0','1.0','148','148','1457669360','1457669360','0','0','淮秀帮爆笑：现实江湖风云再起《新神奇四侠》','youku','0','','XMTM0MTMyODU0NA==','','','','');
INSERT INTO `mac_vod` VALUES('407','淮秀帮配音吐槽高温：奔跑吧，五花肉！','','huaixiubangpeiyintucaogaowenbenpaobawuhuarou','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562812480.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','286','0','0','0','0','0','0','10.0','4870','487','1457669360','1457669360','0','0','淮秀帮配音吐槽高温：奔跑吧，五花肉！','youku','0','','XMTMwNzg5NjA3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('408','淮秀帮神恶搞：爆笑毕业季《毕业生联盟》','','huaixiubangshenegaobaoxiaobiyejibiyeshenglianmeng','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562812390.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','162','0','0','0','0','0','0','5.0','1500','300','1457669360','1457669360','0','0','淮秀帮神恶搞：爆笑毕业季《毕业生联盟》','youku','0','','XMTI1OTQ2NDY0MA==','','','','');
INSERT INTO `mac_vod` VALUES('409','淮秀帮吐槽毯星《红毯历险记》','','huaixiubangtucaotanxinghongtanlixianji','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562812300.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','405','0','0','0','0','0','0','5.0','1465','293','1457669360','1457669360','0','0','淮秀帮吐槽毯星《红毯历险记》','youku','0','','XMTI0OTU5MTkwNA==','','','','');
INSERT INTO `mac_vod` VALUES('410','神恶搞高考毕业《不吐槽不青春》','','shenegaogaokaobiyebutucaobuqingchun','S','','http://www.egao8.cc/upload/vod/2016-02-24/14562811990.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','81','0','0','0','0','0','0','8.0','240','30','1457669360','1457669360','0','0','神恶搞高考毕业《不吐槽不青春》','youku','0','','XOTYzODA3NDg4','','','','');
INSERT INTO `mac_vod` VALUES('411','淮秀帮年度盘点《2014十大关键词》','','huaixiubangniandupandian2014shidaguanjianci','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562811900.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','725','0','0','0','0','0','0','2.0','120','60','1457669361','1457669361','0','0','淮秀帮年度盘点《2014十大关键词》','youku','0','','XODYwODE0MDIw','','','','');
INSERT INTO `mac_vod` VALUES('412','群星鬼畜版《Duang》盘点羊年最热点','','qunxingguixubanDuangpandianyangnianzuiredian','Q','','http://www.egao8.cc/upload/vod/2016-02-24/14562811720.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','591','0','0','0','0','0','0','2.0','80','40','1457669361','1457669361','0','0','群星鬼畜版《Duang》盘点羊年最热点','youku','0','','XOTA1MTg1NTA0','','','','');
INSERT INTO `mac_vod` VALUES('413','洗剪吹的进击《发型护卫队》','','xijianchuidejinjifaxinghuweidui','X','','http://www.egao8.cc/upload/vod/2016-02-24/14562811470.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','902','0','0','0','0','0','0','3.0','1092','364','1457669361','1457669361','0','0','洗剪吹的进击《发型护卫队》','youku','0','','XODIyOTAzNTI0','','','','');
INSERT INTO `mac_vod` VALUES('414','淮秀帮走进科学之《十大未解之谜》','','huaixiubangzoujinkexuezhishidaweijiezhimi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562811290.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','99','0','0','0','0','0','0','5.0','1420','284','1457669361','1457669361','0','0','淮秀帮走进科学之《十大未解之谜》','youku','0','','XODA2NTIwNzUy','','','','');
INSERT INTO `mac_vod` VALUES('415','淮秀帮走近科学《十大神奇病症》','','huaixiubangzoujinkexueshidashenqibingzheng','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562811050.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','93','0','0','0','0','0','0','2.0','70','35','1457669361','1457669361','0','0','淮秀帮走近科学《十大神奇病症》','youku','0','','XNzg3NDYyNDcy','','','','');
INSERT INTO `mac_vod` VALUES('416','淮秀帮教师节巨献《萌师奇谭》','','huaixiubangjiaoshijiejuxianmengshiqitan','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562810920.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','512','0','0','0','0','0','0','9.0','4176','464','1457669361','1457669361','0','0','淮秀帮教师节巨献《萌师奇谭》','youku','0','','XNzc4NDY0MTA0','','','','');
INSERT INTO `mac_vod` VALUES('417','逗比群星恶搞配音《高温总动员》','','doubiqunxingegaopeiyingaowenzongdongyuan','D','','http://www.egao8.cc/upload/vod/2016-02-24/14562810750.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','954','0','0','0','0','0','0','10.0','1500','150','1457669361','1457669361','0','0','逗比群星恶搞配音《高温总动员》','youku','0','','XNzQ4OTcyMDMy','','','','');
INSERT INTO `mac_vod` VALUES('418','假如游戏拍成电视剧','','jiaruyouxipaichengdianshiju','J','','http://www.egao8.cc/upload/vod/2016-02-24/14562810660.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','235','0','0','0','0','0','0','2.0','66','33','1457669361','1457669361','0','0','假如游戏拍成电视剧','youku','0','','XNzQxNDcxMTA4','','','','');
INSERT INTO `mac_vod` VALUES('419','淮秀帮毕业季恶搞《舌尖上的食堂》','','huaixiubangbiyejiegaoshejianshangdeshitang','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562810390.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','641','0','0','0','0','0','0','1.0','38','38','1457669361','1457669361','0','0','淮秀帮毕业季恶搞《舌尖上的食堂》','youku','0','','XNzI4NjExMDI0','','','','');
INSERT INTO `mac_vod` VALUES('420','淮秀帮毕业季《三年高考·四年毕业》恶搞配音','','huaixiubangbiyejisanniangaokaosinianbiyeegaopeiyin','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562810300.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','176','0','0','0','0','0','0','8.0','1568','196','1457669361','1457669361','0','0','淮秀帮毕业季《三年高考·四年毕业》恶搞配音','youku','0','','XNzI3MjU1NzI0','','','','');
INSERT INTO `mac_vod` VALUES('421','淮秀帮吐槽于妈三弄之《宫锁琼瑶》','','huaixiubangtucaoyumasanlongzhigongsuoqiongyao','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562810120.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','811','0','0','0','0','0','0','7.0','1932','276','1457669365','1457669365','0','0','淮秀帮吐槽于妈三弄之《宫锁琼瑶》','youku','0','','XNjk4NzQxODA0','','','','');
INSERT INTO `mac_vod` VALUES('422','淮秀帮作死巨制《高考疯云》','','huaixiubangzuosijuzhigaokaofengyun','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562809980.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','739','0','0','0','0','0','0','4.0','1616','404','1457669365','1457669365','0','0','淮秀帮作死巨制《高考疯云》','youku','0','','XNzE4Mzc5NTQ4','','','','');
INSERT INTO `mac_vod` VALUES('423','来自地球的女蛇精病','','laizidiqiudenvshejingbing','L','','http://www.egao8.cc/upload/vod/2016-02-24/14562809850.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','619','0','0','0','0','0','0','3.0','579','193','1457669365','1457669365','0','0','来自地球的女蛇精病','youku','0','','XNjc3OTYyNTUy','','','','');
INSERT INTO `mac_vod` VALUES('424','淮秀帮配音《除夕在路上》','','huaixiubangpeiyinchuxizailushang','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562809530.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','831','0','0','0','0','0','0','3.0','1086','362','1457669365','1457669365','0','0','淮秀帮配音《除夕在路上》','youku','0','','XNjY3NDA4MjM2','','','','');
INSERT INTO `mac_vod` VALUES('425','逗比神剧PK：神剧的正确打开方式','','doubishenjuPKshenjudezhengquedakaifangshi','D','','http://www.egao8.cc/upload/vod/2016-02-24/14562809490.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','722','0','0','0','0','0','0','8.0','2928','366','1457669365','1457669365','0','0','逗比神剧PK：神剧的正确打开方式','youku','0','','XNjg4MDg3Nzky','','','','');
INSERT INTO `mac_vod` VALUES('426','淮秀帮《逗比爱情事故》','','huaixiubangdoubiaiqingshigu','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562809440.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','859','0','0','0','0','0','0','3.0','63','21','1457669365','1457669365','0','0','淮秀帮《逗比爱情事故》','youku','0','','XNjc1NDY2ODUy','','','','');
INSERT INTO `mac_vod` VALUES('427','淮秀帮配音《大闹春晚》','','huaixiubangpeiyindanaochunwan','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562809060.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','277','0','0','0','0','0','0','9.0','1125','125','1457669365','1457669365','0','0','淮秀帮配音《大闹春晚》','youku','0','','XNjY4ODMzODM2','','','','');
INSERT INTO `mac_vod` VALUES('428','淮秀帮YY7720直播中','','huaixiubangYY7720zhibozhong','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808800.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','729','0','0','0','0','0','0','6.0','516','86','1457669365','1457669365','0','0','淮秀帮YY7720直播中','youku','0','','XNjQ1MzgxMzY4','','','','');
INSERT INTO `mac_vod` VALUES('429','唐僧大话吐槽扫毒','','tangsengdahuatucaosaodu','T','','http://www.egao8.cc/upload/vod/2016-02-24/14562808550.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','938','0','0','0','0','0','0','5.0','230','46','1457669365','1457669365','0','0','唐僧大话吐槽扫毒','youku','0','','XNjQzMDI3NTg4','','','','');
INSERT INTO `mac_vod` VALUES('430','恶搞配音 都敏俊 救救女王吧','','egaopeiyinduminjunjiujiunvwangba','E','','http://www.egao8.cc/upload/vod/2016-02-24/14562807942.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','847','0','0','0','0','0','0','10.0','90','9','1457669365','1457669365','0','0','恶搞配音 都敏俊 救救女王吧','youku','0','','XNjc5MjE0MTky','','','','');
INSERT INTO `mac_vod` VALUES('431','妇女节恶搞配音 史上最坑爹“巾帼12钗”','','funvjieegaopeiyinshishangzuikangdiejinguo12cha','F','','http://www.egao8.cc/upload/vod/2016-02-24/14562807943.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','864','0','0','0','0','0','0','2.0','918','459','1457669365','1457669365','0','0','妇女节恶搞配音 史上最坑爹“巾帼12钗”','youku','0','','XNjgyMjYyMDEy','','','','');
INSERT INTO `mac_vod` VALUES('432','恶搞配音《爱，都去哪了》','','egaopeiyinaiduqunaliao','E','','http://www.egao8.cc/upload/vod/2016-02-24/14562807947.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','119','0','0','0','0','0','0','9.0','4446','494','1457669365','1457669365','0','0','恶搞配音《爱，都去哪了》','youku','0','','XNjkxMjgyMDM2','','','','');
INSERT INTO `mac_vod` VALUES('433','期末传奇《学霸去哪儿》76','','qimochuanqixuebaqunaer76','Q','','http://www.egao8.cc/upload/vod/2016-02-24/145628079412.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','709','0','0','0','0','0','0','10.0','4420','442','1457669365','1457669365','0','0','期末传奇《学霸去哪儿》76','youku','0','','XNjQzNjkxMTc2','','','','');
INSERT INTO `mac_vod` VALUES('434','淮秀帮配音特辑《幸福来敲门》','','huaixiubangpeiyintejixingfulaiqiaomen','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808039.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','951','0','0','0','0','0','0','9.0','4437','493','1457669365','1457669365','0','0','淮秀帮配音特辑《幸福来敲门》','tudou','0','','165618959','','','','');
INSERT INTO `mac_vod` VALUES('435','高温联播恶搞新闻联播','','gaowenlianboegaoxinwenlianbo','G','','http://www.egao8.cc/upload/vod/2016-02-24/145628080315.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','631','0','0','0','0','0','0','5.0','1605','321','1457669365','1457669365','0','0','高温联播恶搞新闻联播','youku','0','','XNTk5NzYyNTY0','','','','');
INSERT INTO `mac_vod` VALUES('436','淮秀帮终极脱光宝典','','huaixiubangzhongjituoguangbaodian','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628080318.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','251','0','0','0','0','0','0','4.0','840','210','1457669365','1457669365','0','0','淮秀帮终极脱光宝典','youku','0','','XNTk0ODY4MzUy','','','','');
INSERT INTO `mac_vod` VALUES('437','《人类很忙》','','renleihenmang','R','','http://www.egao8.cc/upload/vod/2016-02-24/14562808072.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','284','0','0','0','0','0','0','6.0','1062','177','1457669365','1457669365','0','0','《人类很忙》','youku','0','','XMzkzMjcwNTY4','','','','');
INSERT INTO `mac_vod` VALUES('438','年度巨献《三角演义》','','niandujuxiansanjiaoyanyi','N','','http://www.egao8.cc/upload/vod/2016-02-24/14562808074.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','423','0','0','0','0','0','0','2.0','196','98','1457669365','1457669365','0','0','年度巨献《三角演义》','youku','0','','XNjM2MjgwNDcy','','','','');
INSERT INTO `mac_vod` VALUES('439','淮秀帮动画版《感冒进行曲》','','huaixiubangdonghuabanganmaojinxingqu','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808075.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','827','0','0','0','0','0','0','10.0','3360','336','1457669365','1457669365','0','0','淮秀帮动画版《感冒进行曲》','youku','0','','XNjM1NDMwMjY4','','','','');
INSERT INTO `mac_vod` VALUES('440','HELLO！甄嬛','','HELLOzhen','H','','http://www.egao8.cc//pic/nopic.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','375','0','0','0','0','0','0','5.0','1800','360','1457669365','1457669365','0','0','HELLO！甄嬛','youku','0','','XNTEwNTkzMjc2','','','','');
INSERT INTO `mac_vod` VALUES('441','淮秀帮配音《选秀时代》','','huaixiubangpeiyinxuanxiushidai','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808078.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','915','0','0','0','0','0','0','6.0','2256','376','1457669369','1457669369','0','0','淮秀帮配音《选秀时代》','youku','0','','XNTkwMjEyNDgw','','','','');
INSERT INTO `mac_vod` VALUES('442','淮秀帮《了不起的女汉子》','','huaixiubangliaobuqidenvhanzi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808079.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','512','0','0','0','0','0','0','1.0','449','449','1457669369','1457669369','0','0','淮秀帮《了不起的女汉子》','youku','0','','XNjA5NzcxNTUy','','','','');
INSERT INTO `mac_vod` VALUES('443','大话西游遇上西游记','','dahuaxiyouyushangxiyouji','D','','http://www.egao8.cc/upload/vod/2016-02-24/145628080710.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','703','0','0','0','0','0','0','9.0','1143','127','1457669369','1457669369','0','0','大话西游遇上西游记','youku','0','','XNDcyMTMxODM2','','','','');
INSERT INTO `mac_vod` VALUES('444','致我们终将逝去的童年','','zhiwomenzhongjiangshiqudetongnian','Z','','http://www.egao8.cc/upload/vod/2016-02-24/145628080712.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','741','0','0','0','0','0','0','4.0','276','69','1457669369','1457669369','0','0','致我们终将逝去的童年','youku','0','','XNTY0NzU5MTgw','','','','');
INSERT INTO `mac_vod` VALUES('445','翻滚吧，地球！','','fangunbadiqiu','F','','http://www.egao8.cc/upload/vod/2016-02-24/145628080714.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','849','0','0','0','0','0','0','1.0','166','166','1457669369','1457669369','0','0','翻滚吧，地球！','youku','0','','XNTMwMTUwNTU2','','','','');
INSERT INTO `mac_vod` VALUES('446','《钓鱼岛绝不退让》淮秀帮说应该看','','diaoyudaojuebutuiranghuaixiubangshuoyinggaikan','D','','http://www.egao8.cc/upload/vod/2016-02-24/145628080715.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','469','0','0','0','0','0','0','10.0','1720','172','1457669369','1457669369','0','0','《钓鱼岛绝不退让》淮秀帮说应该看','youku','0','','XNDUwOTgxMjc2','','','','');
INSERT INTO `mac_vod` VALUES('447','李冰冰携手淮秀帮','','libingbingxieshouhuaixiubang','L','','http://www.egao8.cc/upload/vod/2016-02-24/145628080717.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','509','0','0','0','0','0','0','6.0','1926','321','1457669369','1457669369','0','0','李冰冰携手淮秀帮','youku','0','','XNTMzMDY5NTUy','','','','');
INSERT INTO `mac_vod` VALUES('448','东南卫视淮秀帮《开学》全篇解析！','','dongnanweishihuaixiubangkaixuequanpianjiexi','D','','http://www.egao8.cc/upload/vod/2016-02-24/14562808111.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','600','0','0','0','0','0','0','2.0','922','461','1457669369','1457669369','0','0','东南卫视淮秀帮《开学》全篇解析！','youku','0','','XNDQ2Nzk1OTU2','','','','');
INSERT INTO `mac_vod` VALUES('449','十大逆袭情侣','','shidanixiqinglv','S','','http://www.egao8.cc/upload/vod/2016-02-24/14562808112.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','339','0','0','0','0','0','0','4.0','684','171','1457669369','1457669369','0','0','十大逆袭情侣','youku','0','','XNTIwOTA2NTU2','','','','');
INSERT INTO `mac_vod` VALUES('450','春节变奏曲','','chunjiebianzouqu','C','','http://www.egao8.cc/upload/vod/2016-02-24/14562808113.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','542','0','0','0','0','0','0','10.0','3900','390','1457669369','1457669369','0','0','春节变奏曲','youku','0','','XNTE1NzU4ODQ0','','','','');
INSERT INTO `mac_vod` VALUES('451','人在囧途之冬囧','','renzaituzhidong','R','','http://www.egao8.cc/upload/vod/2016-02-24/14562808115.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','495','0','0','0','0','0','0','2.0','86','43','1457669369','1457669369','0','0','人在囧途之冬囧','youku','0','','XNTA1MTQwNTgw','','','','');
INSERT INTO `mac_vod` VALUES('452','《开学》坑爹巨献','','kaixuekangdiejuxian','K','','http://www.egao8.cc/upload/vod/2016-02-24/14562808116.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','201','0','0','0','0','0','0','4.0','648','162','1457669369','1457669369','0','0','《开学》坑爹巨献','youku','0','','XNDQ1NzEzNjgw','','','','');
INSERT INTO `mac_vod` VALUES('453','《1111光棍节特辑》恶搞版单身style','','1111guanggunjietejiegaobandanshenstyle','1','','http://www.egao8.cc/upload/vod/2016-02-24/14562808128.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','633','0','0','0','0','0','0','9.0','135','15','1457669369','1457669369','0','0','《1111光棍节特辑》恶搞版单身style','youku','0','','XNDcxNjY3MzU2','','','','');
INSERT INTO `mac_vod` VALUES('454','我是老妈是萌货','','woshilaomashimenghuo','W','','http://www.egao8.cc/upload/vod/2016-02-24/145628081218.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','983','0','0','0','0','0','0','3.0','687','229','1457669370','1457669370','0','0','我是老妈是萌货','youku','0','','XNTUzOTA2MzI4','','','','');
INSERT INTO `mac_vod` VALUES('455','淮秀四年，感谢有你','','huaixiusinianganxieyouni','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808163.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','910','0','0','0','0','0','0','10.0','4160','416','1457669370','1457669370','0','0','淮秀四年，感谢有你','youku','0','','XNjQzMTA2Njcy','','','','');
INSERT INTO `mac_vod` VALUES('456','淮秀帮配音综艺大观','','huaixiubangpeiyinzongyidaguan','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808164.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','794','0','0','0','0','0','0','1.0','296','296','1457669370','1457669370','0','0','淮秀帮配音综艺大观','youku','0','','XNTQyNTY5MDAw','','','','');
INSERT INTO `mac_vod` VALUES('457','史诗励志传奇《土豪去哪儿》','','shishilizhichuanqituhaoqunaer','S','','http://www.egao8.cc/upload/vod/2016-02-24/14562808166.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','982','0','0','0','0','0','0','7.0','2268','324','1457669370','1457669370','0','0','史诗励志传奇《土豪去哪儿》','youku','0','','XNjI3MjQyODMy','','','','');
INSERT INTO `mac_vod` VALUES('458','恶搞配音新闻联播《末日联播》','','egaopeiyinxinwenlianbomorilianbo','E','','http://www.egao8.cc/upload/vod/2016-02-24/14562808169.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','41','0','0','0','0','0','0','4.0','1260','315','1457669370','1457669370','0','0','恶搞配音新闻联播《末日联播》','youku','0','','XNDg5NDcyOTM2','','','','');
INSERT INTO `mac_vod` VALUES('459','淮秀帮毕业季《我的大学》','','huaixiubangbiyejiwodedaxue','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628081610.gif','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','5','0','0','0','0','0','0','3.0','201','67','1457669370','1457669370','0','0','淮秀帮毕业季《我的大学》','youku','0','','XNTc3NDYwNDgw','','','','');
INSERT INTO `mac_vod` VALUES('460','张卫健为淮秀帮孙悟空配音者颁奖','','zhangweijianweihuaixiubangsunwukongpeiyinzhebanjiang','Z','','http://www.egao8.cc/upload/vod/2016-02-24/145628081613.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','629','0','0','0','0','0','0','5.0','2445','489','1457669370','1457669370','0','0','张卫健为淮秀帮孙悟空配音者颁奖','youku','0','','XNDQ5MDAyMzA4','','','','');
INSERT INTO `mac_vod` VALUES('461','《国庆撞中秋》十一双节激情奉献','','guoqingzhuangzhongqiushiyishuangjiejiqingfengxian','G','','http://www.egao8.cc/upload/vod/2016-02-24/145628081614.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','636','0','0','0','0','0','0','10.0','2230','223','1457669374','1457669374','0','0','《国庆撞中秋》十一双节激情奉献','youku','0','','XNDU2Mzc2MjYw','','','','');
INSERT INTO `mac_vod` VALUES('462','星空卫视《金星撞火星》淮秀帮特辑！','','xingkongweishijinxingzhuanghuoxinghuaixiubangteji','X','','http://www.egao8.cc/upload/vod/2016-02-24/145628081617.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','966','0','0','0','0','0','0','3.0','816','272','1457669374','1457669374','0','0','星空卫视《金星撞火星》淮秀帮特辑！','youku','0','','XNDQwMzMxMDg0','','','','');
INSERT INTO `mac_vod` VALUES('463','湖南卫视《百变大咖秀》0719期淮秀帮剪辑','','hunanweishibaibiandakaxiu0719qihuaixiubangjianji','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808203.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','30','0','0','0','0','0','0','3.0','363','121','1457669374','1457669374','0','0','湖南卫视《百变大咖秀》0719期淮秀帮剪辑','youku','0','','XNDI5NTQzNTI4','','','','');
INSERT INTO `mac_vod` VALUES('464','奥运会犀利吐槽—我靠 伦敦！','','aoyunhuixilitucaowokaolundun','A','','http://www.egao8.cc/upload/vod/2016-02-24/14562808204.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','957','0','0','0','0','0','0','10.0','3660','366','1457669374','1457669374','0','0','奥运会犀利吐槽—我靠 伦敦！','youku','0','','XNDM4Mjg3NDIw','','','','');
INSERT INTO `mac_vod` VALUES('465','夏季坑爹巨献—暑假来了！','','xiajikangdiejuxianshujialailiao','X','','http://www.egao8.cc/upload/vod/2016-02-24/14562808205.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','844','0','0','0','0','0','0','2.0','674','337','1457669374','1457669374','0','0','夏季坑爹巨献—暑假来了！','youku','0','','XNDI0NjU4MjA4','','','','');
INSERT INTO `mac_vod` VALUES('466','痞子英雄619上映宣传—女纸好逑真英雄！','','piziyingxiong619shangyingxuanchuannvzhihaoqiuzhenyingxiong','P','','http://www.egao8.cc/upload/vod/2016-02-24/14562808206.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','8','0','0','0','0','0','0','4.0','896','224','1457669374','1457669374','0','0','痞子英雄619上映宣传—女纸好逑真英雄！','youku','0','','XNDE1Mzg1OTcy','','','','');
INSERT INTO `mac_vod` VALUES('467','古今中外经典演绎—高考作文坑爹大盘点！','','gujinzhongwaijingdianyanyigaokaozuowenkangdiedapandian','G','','http://www.egao8.cc/upload/vod/2016-02-24/14562808207.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','234','0','0','0','0','0','0','3.0','603','201','1457669374','1457669374','0','0','古今中外经典演绎—高考作文坑爹大盘点！','youku','0','','XNDE2NTc3MjIw','','','','');
INSERT INTO `mac_vod` VALUES('468','各种劳模大盘点—人类很忙！','','gezhonglaomodapandianrenleihenmang','G','','http://www.egao8.cc/upload/vod/2016-02-24/14562808208.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','26','0','0','0','0','0','0','7.0','357','51','1457669374','1457669374','0','0','各种劳模大盘点—人类很忙！','youku','0','','XMzkzMjcwNTY4','','','','');
INSERT INTO `mac_vod` VALUES('469','夏季坑爹巨献—减肥！减肥！','','xiajikangdiejuxianjianfeijianfei','X','','http://www.egao8.cc/upload/vod/2016-02-24/14562808209.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','857','0','0','0','0','0','0','5.0','1455','291','1457669374','1457669374','0','0','夏季坑爹巨献—减肥！减肥！','youku','0','','XMzk4MTYwNzcy','','','','');
INSERT INTO `mac_vod` VALUES('470','伤不起的毕业季—再见，大学！','','shangbuqidebiyejizaijiandaxue','S','','http://www.egao8.cc/upload/vod/2016-02-24/145628082010.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','417','0','0','0','0','0','0','8.0','2384','298','1457669374','1457669374','0','0','伤不起的毕业季—再见，大学！','youku','0','','XNDExMTQzOTMy','','','','');
INSERT INTO `mac_vod` VALUES('471','爆笑新闻联播—暑期荧屏大盘点！','','baoxiaoxinwenlianboshuqiyingpingdapandian','B','','http://www.egao8.cc/upload/vod/2016-02-24/145628082011.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','868','0','0','0','0','0','0','5.0','2170','434','1457669374','1457669374','0','0','爆笑新闻联播—暑期荧屏大盘点！','youku','0','','XNDMxNzUwNjAw','','','','');
INSERT INTO `mac_vod` VALUES('472','天气预报群星版—坑爹的鬼天气！','','tianqiyubaoqunxingbankangdiedeguitianqi','T','','http://www.egao8.cc/upload/vod/2016-02-24/145628082012.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','88','0','0','0','0','0','0','10.0','1700','170','1457669374','1457669374','0','0','天气预报群星版—坑爹的鬼天气！','youku','0','','XMzcxNzExNjY4','','','','');
INSERT INTO `mac_vod` VALUES('473','百变大咖秀群星版—模仿风暴！','','baibiandakaxiuqunxingbanmofangfengbao','B','','http://www.egao8.cc/upload/vod/2016-02-24/145628082013.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','924','0','0','0','0','0','0','1.0','209','209','1457669374','1457669374','0','0','百变大咖秀群星版—模仿风暴！','youku','0','','XNDI0MjkzMjc2','','','','');
INSERT INTO `mac_vod` VALUES('474','淮秀帮伤不起的毕业季—再见，大学！','','huaixiubangshangbuqidebiyejizaijiandaxue','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082014.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','444','0','0','0','0','0','0','10.0','1180','118','1457669374','1457669374','0','0','淮秀帮伤不起的毕业季—再见，大学！','youku','0','','XNDExMTQzOTMy','','','','');
INSERT INTO `mac_vod` VALUES('475','搜索体群星总动员—工作工作！','','sousuotiqunxingzongdongyuangongzuogongzuo','S','','http://www.egao8.cc/upload/vod/2016-02-24/145628082015.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','182','0','0','0','0','0','0','1.0','445','445','1457669374','1457669374','0','0','搜索体群星总动员—工作工作！','youku','0','','XNDEzMDQyNzM2','','','','');
INSERT INTO `mac_vod` VALUES('476','淮秀帮《舌尖上的中国》之社会万象篇！','','huaixiubangshejianshangdezhongguozhishehuiwanxiangpian','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082016.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','392','0','0','0','0','0','0','10.0','3470','347','1457669374','1457669374','0','0','淮秀帮《舌尖上的中国》之社会万象篇！','youku','0','','XNDA3MTU2Njky','','','','');
INSERT INTO `mac_vod` VALUES('477','淮秀帮各种劳模大盘点—人类很忙！','','huaixiubanggezhonglaomodapandianrenleihenmang','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082017.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','297','0','0','0','0','0','0','4.0','872','218','1457669374','1457669374','0','0','淮秀帮各种劳模大盘点—人类很忙！','youku','0','','XMzkzMjcwNTY4','','','','');
INSERT INTO `mac_vod` VALUES('478','超强阵容配音—坑爹的谣言时代！','','chaoqiangzhenrongpeiyinkangdiedeyaoyanshidai','C','','http://www.egao8.cc/upload/vod/2016-02-24/145628082018.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','338','0','0','0','0','0','0','10.0','3090','309','1457669374','1457669374','0','0','超强阵容配音—坑爹的谣言时代！','youku','0','','XMzgzMTQwMTEy','','','','');
INSERT INTO `mac_vod` VALUES('479','淮秀帮超强阵容配音—坑爹的谣言时代！','','huaixiubangchaoqiangzhenrongpeiyinkangdiedeyaoyanshidai','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082019.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','425','0','0','0','0','0','0','4.0','1428','357','1457669374','1457669374','0','0','淮秀帮超强阵容配音—坑爹的谣言时代！','youku','0','','XMzgzMTQwMTEy','','','','');
INSERT INTO `mac_vod` VALUES('480','淮秀帮天气预报群星版—坑爹的鬼天气！','','huaixiubangtianqiyubaoqunxingbankangdiedeguitianqi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808241.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','188','0','0','0','0','0','0','1.0','208','208','1457669374','1457669374','0','0','淮秀帮天气预报群星版—坑爹的鬼天气！','youku','0','','XMzcxNzExNjY4','','','','');
INSERT INTO `mac_vod` VALUES('481','《画皮2》网络热点版宣传片！','','huapi2wangluoredianbanxuanchuanpian','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808242.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','224','0','0','0','0','0','0','4.0','1764','441','1457669378','1457669378','0','0','《画皮2》网络热点版宣传片！','youku','0','','XMzc0NTQ2MDM2','','','','');
INSERT INTO `mac_vod` VALUES('482','淮秀帮2011十大事件终极大盘点！','','huaixiubang2011shidashijianzhongjidapandian','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808243.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','349','0','0','0','0','0','0','2.0','992','496','1457669378','1457669378','0','0','淮秀帮2011十大事件终极大盘点！','youku','0','','XMzUwMTU2Njky','','','','');
INSERT INTO `mac_vod` VALUES('483','童自荣老师为淮秀帮题词！','','tongzironglaoshiweihuaixiubangtici','T','','http://www.egao8.cc/upload/vod/2016-02-24/14562808244.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','848','0','0','0','0','0','0','8.0','2376','297','1457669378','1457669378','0','0','童自荣老师为淮秀帮题词！','youku','0','','XMzQ0NTU0ODQ0','','','','');
INSERT INTO `mac_vod` VALUES('484','新闻联播群星版—315消费权益微观察','','xinwenlianboqunxingban315xiaofeiquanyiweiguancha','X','','http://www.egao8.cc/upload/vod/2016-02-24/14562808245.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','726','0','0','0','0','0','0','4.0','1508','377','1457669378','1457669378','0','0','新闻联播群星版—315消费权益微观察','youku','0','','XMzY1NjU5MDA4','','','','');
INSERT INTO `mac_vod` VALUES('485','淮秀帮年度大合唱—《淮秀欢迎你》','','huaixiubangniandudahechanghuaixiuhuanyingni','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808246.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','955','0','0','0','0','0','0','5.0','20','4','1457669378','1457669378','0','0','淮秀帮年度大合唱—《淮秀欢迎你》','youku','0','','XMzM2Mzk1NDQ0','','','','');
INSERT INTO `mac_vod` VALUES('486','《剧说春运》','','jushuochunyun','J','','http://www.egao8.cc/upload/vod/2016-02-24/14562808247.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','727','0','0','0','0','0','0','7.0','2135','305','1457669378','1457669378','0','0','《剧说春运》','youku','0','','XMzQ0MTY3ODk2','','','','');
INSERT INTO `mac_vod` VALUES('487','《舌尖上的中国》之社会万象篇！','','shejianshangdezhongguozhishehuiwanxiangpian','S','','http://www.egao8.cc/upload/vod/2016-02-24/14562808248.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','701','0','0','0','0','0','0','3.0','1170','390','1457669378','1457669378','0','0','《舌尖上的中国》之社会万象篇！','youku','0','','XNDA3MTU2Njky','','','','');
INSERT INTO `mac_vod` VALUES('488','淮秀帮《画皮2》网络热点版宣传片！','','huaixiubanghuapi2wangluoredianbanxuanchuanpian','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808259.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','257','0','0','0','0','0','0','3.0','1443','481','1457669378','1457669378','0','0','淮秀帮《画皮2》网络热点版宣传片！','youku','0','','XMzc0NTQ2MDM2','','','','');
INSERT INTO `mac_vod` VALUES('489','台湾壹电视播出淮秀帮《四爷很忙》！','','taiwanyidianshibochuhuaixiubangsiyehenmang','T','','http://www.egao8.cc/upload/vod/2016-02-24/145628082510.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','742','0','0','0','0','0','0','10.0','320','32','1457669378','1457669378','0','0','台湾壹电视播出淮秀帮《四爷很忙》！','youku','0','','XMzQ5Mjc4MDk2','','','','');
INSERT INTO `mac_vod` VALUES('490','泰坦尼克—屌丝也有春天','','taitannikesiyeyouchuntian','T','','http://www.egao8.cc/upload/vod/2016-02-24/145628082511.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','722','0','0','0','0','0','0','9.0','3231','359','1457669378','1457669378','0','0','泰坦尼克—屌丝也有春天','youku','0','','XMzc5NTg4MzA0','','','','');
INSERT INTO `mac_vod` VALUES('491','淮秀帮新闻联播群星版—315消费权益微观察','','huaixiubangxinwenlianboqunxingban315xiaofeiquanyiweiguancha','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082512.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','234','0','0','0','0','0','0','3.0','780','260','1457669378','1457669378','0','0','淮秀帮新闻联播群星版—315消费权益微观察','youku','0','','XMzY1NjU5MDA4','','','','');
INSERT INTO `mac_vod` VALUES('492','群星演绎升级版—为什么没有男朋友','','qunxingyanyishengjibanweishimemeiyounanpengyou','Q','','http://www.egao8.cc/upload/vod/2016-02-24/145628082513.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','30','0','0','0','0','0','0','9.0','1278','142','1457669378','1457669378','0','0','群星演绎升级版—为什么没有男朋友','youku','0','','XMzYzNjY0MzA4','','','','');
INSERT INTO `mac_vod` VALUES('493','淮秀帮群星演绎升级版—为什么没有男朋友','','huaixiubangqunxingyanyishengjibanweishimemeiyounanpengyou','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082514.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','833','0','0','0','0','0','0','1.0','150','150','1457669378','1457669378','0','0','淮秀帮群星演绎升级版—为什么没有男朋友','youku','0','','XMzYzNjY0MzA4','','','','');
INSERT INTO `mac_vod` VALUES('494','淮秀帮夏季坑爹巨献—减肥！减肥！','','huaixiubangxiajikangdiejuxianjianfeijianfei','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082515.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','585','0','0','0','0','0','0','1.0','284','284','1457669378','1457669378','0','0','淮秀帮夏季坑爹巨献—减肥！减肥！','youku','0','','XMzk4MTYwNzcy','','','','');
INSERT INTO `mac_vod` VALUES('495','《新娱乐在线》解析淮秀帮恶搞《四爷很忙》！','','xinyulezaixianjiexihuaixiubangegaosiyehenmang','X','','http://www.egao8.cc/upload/vod/2016-02-24/145628082516.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','696','0','0','0','0','0','0','10.0','320','32','1457669379','1457669379','0','0','《新娱乐在线》解析淮秀帮恶搞《四爷很忙》！','youku','0','','XMzQ4NjkxMzc2','','','','');
INSERT INTO `mac_vod` VALUES('496','淮秀帮泰坦尼克—屌丝也有春天','','huaixiubangtaitannikesiyeyouchuntian','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082517.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','294','0','0','0','0','0','0','6.0','2928','488','1457669379','1457669379','0','0','淮秀帮泰坦尼克—屌丝也有春天','youku','0','','XMzc5NTg4MzA0','','','','');
INSERT INTO `mac_vod` VALUES('497','淮秀帮年度荧屏大盘点—四爷很忙！','','huaixiubangnianduyingpingdapandiansiyehenmang','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082518.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','479','0','0','0','0','0','0','10.0','4830','483','1457669379','1457669379','0','0','淮秀帮年度荧屏大盘点—四爷很忙！','youku','0','','XMzQ4MTI4NDc2','','','','');
INSERT INTO `mac_vod` VALUES('498','淮秀帮秋裤体群星版—有一种寒冷叫忘穿秋裤！','','huaixiubangqiukutiqunxingbanyouyizhonghanlingjiaowangchuanqiuku','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082519.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','565','0','0','0','0','0','0','3.0','618','206','1457669379','1457669379','0','0','淮秀帮秋裤体群星版—有一种寒冷叫忘穿秋裤！','youku','0','','XMzMyNjMzNDky','','','','');
INSERT INTO `mac_vod` VALUES('499','淮秀帮群星公益贺岁—校车争霸赛！','','huaixiubangqunxinggongyihesuixiaochezhengbasai','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808291.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','338','0','0','0','0','0','0','6.0','1986','331','1457669379','1457669379','0','0','淮秀帮群星公益贺岁—校车争霸赛！','youku','0','','XMzQxNjU5NjAw','','','','');
INSERT INTO `mac_vod` VALUES('500','淮秀帮男人帮—光棍节肿木过！？','','huaixiubangnanrenbangguanggunjiezhongmuguo','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808292.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','301','0','0','0','0','0','0','5.0','710','142','1457669379','1457669379','0','0','淮秀帮男人帮—光棍节肿木过！？','youku','0','','XMzIxMDM2OTMy','','','','');
INSERT INTO `mac_vod` VALUES('501','淮秀帮鸭梨山大怎么办？群星怒吼“别惹我！”','','huaixiubangyalishandazenmebanqunxingnuhoubieruowo','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808293.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','929','0','0','0','0','0','0','9.0','1395','155','1457669383','1457669383','0','0','淮秀帮鸭梨山大怎么办？群星怒吼“别惹我！”','youku','0','','XMzMwMzY2MjI0','','','','');
INSERT INTO `mac_vod` VALUES('502','淮秀帮新白娘子传奇—白娘子做公益','','huaixiubangxinbainiangzichuanqibainiangzizuogongyi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808294.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','911','0','0','0','0','0','0','10.0','2480','248','1457669383','1457669383','0','0','淮秀帮新白娘子传奇—白娘子做公益','youku','0','','XMzIyMjU4NDE2','','','','');
INSERT INTO `mac_vod` VALUES('503','淮秀帮新白娘子传奇结婚记—收红包有妙方','','huaixiubangxinbainiangzichuanqijiehunjishouhongbaoyoumiaofang','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808295.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','409','0','0','0','0','0','0','5.0','1415','283','1457669383','1457669383','0','0','淮秀帮新白娘子传奇结婚记—收红包有妙方','youku','0','','XMzE0NzkyNTI4','','','','');
INSERT INTO `mac_vod` VALUES('504','淮秀帮撑腰体群星版—老人摔倒了，你就去扶！','','huaixiubangchengyaotiqunxingbanlaorenshuaidaoliaonijiuqufu','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808296.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','301','0','0','0','0','0','0','10.0','2290','229','1457669383','1457669383','0','0','淮秀帮撑腰体群星版—老人摔倒了，你就去扶！','youku','0','','XMzE3ODY1NTky','','','','');
INSERT INTO `mac_vod` VALUES('505','淮秀帮让子弹飞—贺岁档三巨头亲密会谈！','','huaixiubangrangzidanfeihesuidangsanjutouqinmihuitan','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808297.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','434','0','0','0','0','0','0','2.0','584','292','1457669383','1457669383','0','0','淮秀帮让子弹飞—贺岁档三巨头亲密会谈！','youku','0','','XMzI4NzYyNTQ0','','','','');
INSERT INTO `mac_vod` VALUES('506','淮秀帮情深深雨蒙蒙—你买到车票了吗？','','huaixiubangqingshenshenyumengmengnimaidaochepiaoliaoma','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808298.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','876','0','0','0','0','0','0','3.0','111','37','1457669383','1457669383','0','0','淮秀帮情深深雨蒙蒙—你买到车票了吗？','youku','0','','XMzA4MTYzMTA4','','','','');
INSERT INTO `mac_vod` VALUES('507','淮秀帮“涨工资体”群星总动员—加薪何时有！','','huaixiubangzhanggongzitiqunxingzongdongyuanjiaxinheshiyou','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808299.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','160','0','0','0','0','0','0','8.0','96','12','1457669383','1457669383','0','0','淮秀帮“涨工资体”群星总动员—加薪何时有！','youku','0','','XMzIzNzE0NTI4','','','','');
INSERT INTO `mac_vod` VALUES('508','还珠格格第一部—春心大动','','huaizhugegediyibuchunxindadong','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082910.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','542','0','0','0','0','0','0','2.0','750','375','1457669383','1457669383','0','0','还珠格格第一部—春心大动','youku','0','','XMzE1MzgyNjI0','','','','');
INSERT INTO `mac_vod` VALUES('509','淮秀帮情深深雨蒙蒙—小石斑生日记','','huaixiubangqingshenshenyumengmengxiaoshibanshengriji','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082911.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','244','0','0','0','0','0','0','1.0','20','20','1457669383','1457669383','0','0','淮秀帮情深深雨蒙蒙—小石斑生日记','youku','0','','XMzA2NDcyMDI0','','','','');
INSERT INTO `mac_vod` VALUES('510','淮秀帮新白娘子传奇相亲记—我们结婚吧','','huaixiubangxinbainiangzichuanqixiangqinjiwomenjiehunba','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082912.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','707','0','0','0','0','0','0','5.0','985','197','1457669383','1457669383','0','0','淮秀帮新白娘子传奇相亲记—我们结婚吧','youku','0','','XMzEwMjE1NDQ0','','','','');
INSERT INTO `mac_vod` VALUES('511','《情深深雨蒙蒙》—依萍捉奸！','','qingshenshenyumengmengyipingzhuojian','Q','','http://www.egao8.cc/upload/vod/2016-02-24/145628082913.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','841','0','0','0','0','0','0','8.0','1144','143','1457669383','1457669383','0','0','《情深深雨蒙蒙》—依萍捉奸！','youku','0','','XMzE1MTc3MDM2','','','','');
INSERT INTO `mac_vod` VALUES('512','淮秀帮还珠格格、新白娘子传奇—尔康遇蛇变许仙','','huaixiubanghuaizhugegexinbainiangzichuanqierkangyushebianxuxian','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082914.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','276','0','0','0','0','0','0','5.0','1025','205','1457669383','1457669383','0','0','淮秀帮还珠格格、新白娘子传奇—尔康遇蛇变许仙','youku','0','','XMzA1NzQ1MjA0','','','','');
INSERT INTO `mac_vod` VALUES('513','淮秀帮军训尼玛伤不起！','','huaixiubangjunxunnimashangbuqi','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082915.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','608','0','0','0','0','0','0','9.0','4158','462','1457669383','1457669383','0','0','淮秀帮军训尼玛伤不起！','youku','0','','XMjk5MjE0MDk2','','','','');
INSERT INTO `mac_vod` VALUES('514','淮秀帮新还珠格格B体终极吐槽—我们已经尽力了！','','huaixiubangxinhuaizhugegeBtizhongjitucaowomenyijingjinliliao','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082916.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','655','0','0','0','0','0','0','9.0','3177','353','1457669383','1457669383','0','0','淮秀帮新还珠格格TVB体终极吐槽—我们已经尽力了！','youku','0','','XMzAyNDIwNzEy','','','','');
INSERT INTO `mac_vod` VALUES('515','《歪唱MV》千里之外—李双江儿子打人版','','waichangMVqianlizhiwailishuangjiangerzidarenban','W','','http://www.egao8.cc/upload/vod/2016-02-24/145628082917.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','702','0','0','0','0','0','0','8.0','2416','302','1457669383','1457669383','0','0','《歪唱MV》千里之外—李双江儿子打人版','youku','0','','XMzAyNDgxODc2','','','','');
INSERT INTO `mac_vod` VALUES('516','淮秀帮经典尼玛伤不起下集—翻拍时代','','huaixiubangjingdiannimashangbuqixiajifanpaishidai','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082918.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','752','0','0','0','0','0','0','10.0','3430','343','1457669383','1457669383','0','0','淮秀帮经典尼玛伤不起下集—翻拍时代','youku','0','','XMjk3OTcwNjYw','','','','');
INSERT INTO `mac_vod` VALUES('517','淮秀帮新还珠格格—大运会， 我们来了','','huaixiubangxinhuaizhugegedayunhuiwomenlailiao','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628082919.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','778','0','0','0','0','0','0','7.0','1701','243','1457669383','1457669383','0','0','淮秀帮新还珠格格—大运会， 我们来了','youku','0','','XMjk3MDgwNjg4','','','','');
INSERT INTO `mac_vod` VALUES('518','《恶搞解说》周星驰、容嬷嬷现场解说110米栏决赛','','egaojieshuozhouxingchirongmamaxianchangjieshuo110milanjuesai','E','','http://www.egao8.cc/upload/vod/2016-02-24/14562808331.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','971','0','0','0','0','0','0','6.0','780','130','1457669383','1457669383','0','0','《恶搞解说》周星驰、容嬷嬷现场解说110米栏决赛','youku','0','','XMjk5OTgyMDM2','','','','');
INSERT INTO `mac_vod` VALUES('519','《爆笑短片》经典版容嬷嬷扎新版紫薇','','baoxiaoduanpianjingdianbanrongmamazhaxinbanziwei','B','','http://www.egao8.cc/upload/vod/2016-02-24/14562808332.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','992','0','0','0','0','0','0','10.0','1130','113','1457669383','1457669383','0','0','《爆笑短片》经典版容嬷嬷扎新版紫薇','youku','0','','XMjk2Mzk5NTY0','','','','');
INSERT INTO `mac_vod` VALUES('520','淮秀帮还珠格格—铁锹部的孩纸伤不起啊','','huaixiubanghuaizhugegetieqiaobudehaizhishangbuqia','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808333.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','220','0','0','0','0','0','0','10.0','4150','415','1457669383','1457669383','0','0','淮秀帮还珠格格—铁锹部的孩纸伤不起啊','youku','0','','XMjk2MjExMzIw','','','','');
INSERT INTO `mac_vod` VALUES('521','《恶搞短片》新还珠、宫、新白—疯狂的白菜','','egaoduanpianxinhuaizhugongxinbaifengkuangdebaicai','E','','http://www.egao8.cc/upload/vod/2016-02-24/14562808334.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','2','0','0','0','0','0','0','9.0','4410','490','1457669387','1457669387','0','0','《恶搞短片》新还珠、宫、新白—疯狂的白菜','youku','0','','XMjk1NzY2MjU2','','','','');
INSERT INTO `mac_vod` VALUES('522','容嬷嬷叫你起床','','rongmamajiaoniqichuang','R','','http://www.egao8.cc/upload/vod/2016-02-24/14562808335.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','904','0','0','0','0','0','0','10.0','1530','153','1457669387','1457669387','0','0','容嬷嬷叫你起床','youku','0','','XMjkxMTIwODU2','','','','');
INSERT INTO `mac_vod` VALUES('523','淮秀帮新还珠格格—剖腹产伤不起','','huaixiubangxinhuaizhugegepoufuchanshangbuqi','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808336.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','962','0','0','0','0','0','0','7.0','1414','202','1457669387','1457669387','0','0','淮秀帮新还珠格格—剖腹产伤不起','youku','0','','XMjk1MjAwOTQw','','','','');
INSERT INTO `mac_vod` VALUES('524','《恶搞短片》老版容嬷嬷扎新版紫薇','','egaoduanpianlaobanrongmamazhaxinbanziwei','E','','http://www.egao8.cc/upload/vod/2016-02-24/14562808337.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','930','0','0','0','0','0','0','9.0','414','46','1457669387','1457669387','0','0','《恶搞短片》老版容嬷嬷扎新版紫薇','youku','0','','XMjk0NDMxMzE2','','','','');
INSERT INTO `mac_vod` VALUES('525','淮秀帮还珠格格—皇后容嬷嬷成亲记','','huaixiubanghuaizhugegehuanghourongmamachengqinji','H','','http://www.egao8.cc/upload/vod/2016-02-24/14562808338.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','530','0','0','0','0','0','0','6.0','1962','327','1457669387','1457669387','0','0','淮秀帮还珠格格—皇后容嬷嬷成亲记','youku','0','','XMjkwNzgyMDUy','','','','');
INSERT INTO `mac_vod` VALUES('526','新白娘子传奇版《回家的诱惑》','','xinbainiangzichuanqibanhuijiadeyouhuo','X','','http://www.egao8.cc/upload/vod/2016-02-24/14562808339.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','704','0','0','0','0','0','0','3.0','141','47','1457669387','1457669387','0','0','新白娘子传奇版《回家的诱惑》','youku','0','','XMjU1MDk1NDUy','','','','');
INSERT INTO `mac_vod` VALUES('527','《原创MV》新白娘子传奇版《NO BODY》','','yuanchuangMVxinbainiangzichuanqibanNOBODY','Y','','http://www.egao8.cc/upload/vod/2016-02-24/145628083310.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','862','0','0','0','0','0','0','1.0','193','193','1457669387','1457669387','0','0','《原创MV》新白娘子传奇版《NO BODY》','youku','0','','XMjAxMjc1NTAw','','','','');
INSERT INTO `mac_vod` VALUES('528','淮秀帮情深深雨濛濛—报志愿伤不起啊','','huaixiubangqingshenshenyubaozhiyuanshangbuqia','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628083311.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','132','0','0','0','0','0','0','7.0','2520','360','1457669387','1457669387','0','0','淮秀帮情深深雨濛濛—报志愿伤不起啊','youku','0','','XMjg0MjAzMzUy','','','','');
INSERT INTO `mac_vod` VALUES('529','淮秀帮模拟剧场—经典角色演绎雷人汽车广告！','','huaixiubangmonijuchangjingdianjiaoseyanyileirenqicheguanggao','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628083312.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','613','0','0','0','0','0','0','2.0','756','378','1457669387','1457669387','0','0','淮秀帮模拟剧场—经典角色演绎雷人汽车广告！','youku','0','','XMzI5NjM1MzI4','','','','');
INSERT INTO `mac_vod` VALUES('530','Mnet报道《7级公务员》VIP试映会','','Mnetbaodao7jigongwuyuanVIPshiyinghui','M','','http://www.egao8.cc/upload/vod/2016-02-24/145628083313.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','621','0','0','0','0','0','0','8.0','3496','437','1457669387','1457669387','0','0','Mnet报道《7级公务员》VIP试映会','youku','0','','XOTgzNjE4NTY=','','','','');
INSERT INTO `mac_vod` VALUES('531','湖南娱乐台《娱乐急先锋》播放淮秀帮视频','','hunanyuletaiyulejixianfengbofanghuaixiubangshipin','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628083314.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','941','0','0','0','0','0','0','4.0','844','211','1457669387','1457669387','0','0','湖南娱乐台《娱乐急先锋》播放淮秀帮视频','youku','0','','XMzEwNjkzNDE2','','','','');
INSERT INTO `mac_vod` VALUES('532','白娘子呼唤你起床啦','','bainiangzihuhuanniqichuangla','B','','http://www.egao8.cc/upload/vod/2016-02-24/145628083315.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','77','0','0','0','0','0','0','8.0','3856','482','1457669387','1457669387','0','0','白娘子呼唤你起床啦','youku','0','','XMjk1MDMxMDY0','','','','');
INSERT INTO `mac_vod` VALUES('533','淮秀帮还珠格格新白娘子传奇—经典尼玛伤不起','','huaixiubanghuaizhugegexinbainiangzichuanqijingdiannimashangbuqi','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628083316.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','501','0','0','0','0','0','0','8.0','2152','269','1457669387','1457669387','0','0','淮秀帮还珠格格新白娘子传奇—经典尼玛伤不起','youku','0','','XMjg5ODMwMjQ4','','','','');
INSERT INTO `mac_vod` VALUES('534','淮秀帮情深深雨蒙蒙—挤公交车的苦逼命','','huaixiubangqingshenshenyumengmengjigongjiaochedekubiming','H','','http://www.egao8.cc/upload/vod/2016-02-24/145628083317.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','906','0','0','0','0','0','0','6.0','2694','449','1457669387','1457669387','0','0','淮秀帮情深深雨蒙蒙—挤公交车的苦逼命','youku','0','','XMjgwMTgxNjYw','','','','');
INSERT INTO `mac_vod` VALUES('535','《原创配音》《还珠格格》之如人荡漾篇','','yuanchuangpeiyinhuaizhugegezhirurendangyangpian','Y','','http://www.egao8.cc/upload/vod/2016-02-24/145628083318.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','450','0','0','0','0','0','0','10.0','3810','381','1457669387','1457669387','0','0','《原创配音》《还珠格格》之如人荡漾篇','youku','0','','XMjE0NjA5NjQ0','','','','');
INSERT INTO `mac_vod` VALUES('536','原创新白MV—仙哥洗澡记','','yuanchuangxinbaiMVxiangexizaoji','Y','','http://www.egao8.cc/upload/vod/2016-02-24/145628083319.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','14','0','0','0','0','0','0','5.0','195','39','1457669387','1457669387','0','0','原创新白MV—仙哥洗澡记','youku','0','','XMTk5MDIzODA0','','','','');
INSERT INTO `mac_vod` VALUES('537','《7级公务员》4.18试映会影迷自拍','','7jigongwuyuan418shiyinghuiyingmizipai','7','','http://www.egao8.cc/upload/vod/2016-02-24/14562808371.jpg','','','淮秀帮','','','','大陆','','0','7','','','0','0','0','0','0','0','0','0','444','0','0','0','0','0','0','8.0','1000','125','1457669387','1457669387','0','0','《7级公务员》4.18试映会影迷自拍','youku','0','','XODU2MTAwNDg=','','','','');
INSERT INTO `mac_vod` VALUES('538','寿光蒙迪欧车友会宣传  寿光蒙迪欧车友会宣传','','shouguangmengdioucheyouhuixuanchuanshouguangmengdioucheyouhuixuanchuan','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462498915.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','808','0','0','1','0','0','0','1.0','206','206','1457671087','1457671087','1458351305','0','寿光蒙迪欧车友会宣传  寿光蒙迪欧车友会宣传','youku','0','','XMTM0Nzk2NDc2OA==','','','','');
INSERT INTO `mac_vod` VALUES('539','黄老湿教你打篮球之  黄老湿教你打篮球之','','huanglaoshijiaonidalanqiuzhihuanglaoshijiaonidalanqiuzhi','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462499116.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','639','0','0','0','0','0','0','10.0','3290','329','1457671087','1457671087','0','0','黄老湿教你打篮球之  黄老湿教你打篮球之','youku','0','','XMTMxODY3Njk0NA==','','','','');
INSERT INTO `mac_vod` VALUES('540','脚步练习教学视频  脚步练习教学视频','','jiaobulianxijiaoxueshipinjiaobulianxijiaoxueshipin','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462499417.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','193','0','0','0','0','0','0','9.0','1386','154','1457671087','1457671087','0','0','脚步练习教学视频  脚步练习教学视频','youku','0','','XMTMyNTEwMjA3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('541','骑砍第二季 直面全伤  骑砍第二季 直面全伤','','qikandierjizhimianquanshangqikandierjizhimianquanshang','Q','','http://www.egao8.cc/upload/vod/2015-10-12/144462499518.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','691','0','0','0','0','0','0','4.0','284','71','1457671087','1457671087','0','0','骑砍第二季 直面全伤  骑砍第二季 直面全伤','youku','0','','XMTMzMjg3MjU3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('542','黄老湿教篮球---女球员训练营视频精华','','huanglaoshijiaolanqiunvqiuyuanxunlianyingshipinjinghua','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462499619.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','576','0','0','0','0','0','0','5.0','1675','335','1457671087','1457671087','0','0','黄老湿教篮球---女球员训练营视频精华','youku','0','','XMTMwNTg3Mjg2OA==','','','','');
INSERT INTO `mac_vod` VALUES('543','黄老湿教篮球系列--反应速率及速度训练视频教学  黄老湿教篮球系列','','huanglaoshijiaolanqiuxiliefanyingsulvjisuduxunlianshipinjiaoxuehuanglaoshijiaolanqiuxilie','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446250041.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','757','0','0','0','0','0','0','7.0','1260','180','1457671087','1457671087','0','0','黄老湿教篮球系列--反应速率及速度训练视频教学  黄老湿教篮球系列','youku','0','','XMTI5MDc2MzQ1Ng==','','','','');
INSERT INTO `mac_vod` VALUES('544','病骄灰姑娘  病骄灰姑娘','','bingjiaohuiguniangbingjiaohuiguniang','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446250052.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','864','0','0','0','0','0','0','3.0','1356','452','1457671087','1457671087','0','0','病骄灰姑娘  病骄灰姑娘','youku','0','','XMTMyNTg3OTIyNA==','','','','');
INSERT INTO `mac_vod` VALUES('545','黄老湿 pistol p 控球球性教学  视频','','huanglaoshipistolpkongqiuqiuxingjiaoxueshipin','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446250073.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','493','0','0','0','0','0','0','8.0','1856','232','1457671087','1457671087','0','0','黄老湿 pistol p 控球球性教学  视频','youku','0','','XMTI5NzExMTg2NA==','','','','');
INSERT INTO `mac_vod` VALUES('546','纸巾老湿带你领略跳着舞的革命  纸巾老湿带你领略跳着舞的革命','','zhijinlaoshidainilingluetiaozhouwudegemingzhijinlaoshidainilingluetiaozhouwudegeming','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446250104.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','462','0','0','0','0','0','0','1.0','459','459','1457671087','1457671087','0','0','纸巾老湿带你领略跳着舞的革命  纸巾老湿带你领略跳着舞的革命','youku','0','','XMTMyNTQzNzU0NA==','','','','');
INSERT INTO `mac_vod` VALUES('547','老湿搞笑视频跑酷动作搞笑雷人失误集  老湿搞笑视频','','laoshigaoxiaoshipinpaokudongzuogaoxiaoleirenshiwujilaoshigaoxiaoshipin','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250115.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','55','0','0','0','0','0','0','4.0','228','57','1457671087','1457671087','0','0','老湿搞笑视频跑酷动作搞笑雷人失误集  老湿搞笑视频','youku','0','','XMTI4MTcwNDY1Ng==','','','','');
INSERT INTO `mac_vod` VALUES('548','pistol P投篮教学视频  投篮教学视频','','pistolPtoulanjiaoxueshipintoulanjiaoxueshipin','P','','http://www.egao8.cc/upload/vod/2015-10-12/14446250136.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','277','0','0','0','0','0','0','10.0','590','59','1457671087','1457671087','0','0','pistol P投篮教学视频  投篮教学视频','youku','0','','XMTI5NzEwNTY5Ng==','','','','');
INSERT INTO `mac_vod` VALUES('549','五大内线队员进攻动作视频教学  五大内线队员进攻动作视频教学','','wudanaxianduiyuanjingongdongzuoshipinjiaoxuewudanaxianduiyuanjingongdongzuoshipinjiaoxue','W','','http://www.egao8.cc/upload/vod/2015-10-12/14446250157.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','100','0','0','0','0','0','0','4.0','932','233','1457671087','1457671087','0','0','五大内线队员进攻动作视频教学  五大内线队员进攻动作视频教学','youku','0','','XMTMxNDI2NDUzMg==','','','','');
INSERT INTO `mac_vod` VALUES('550','补记留学英国视频 小城小事  小城小事','','bujiliuxueyingguoshipinxiaochengxiaoshixiaochengxiaoshi','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446250168.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','715','0','0','0','0','0','0','10.0','2050','205','1457671087','1457671087','0','0','补记留学英国视频 小城小事  小城小事','youku','0','','XMTI4MDQ4MzgxMg==','','','','');
INSERT INTO `mac_vod` VALUES('551','雷人搞笑老湿吐槽西游记__  雷人搞笑','','leirengaoxiaolaoshitucaoxiyoujileirengaoxiao','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250199.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','783','0','0','0','0','0','0','3.0','261','87','1457671087','1457671087','0','0','雷人搞笑老湿吐槽西游记__  雷人搞笑','youku','0','','XMTI5MDAyMDA5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('552','施老湿彪三天乐队告别视频  施老湿彪三天乐队告别视频','','shilaoshibiaosantianleduigaobieshipinshilaoshibiaosantianleduigaobieshipin','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462502010.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','683','0','0','0','0','0','0','3.0','300','100','1457671087','1457671087','0','0','施老湿彪三天乐队告别视频  施老湿彪三天乐队告别视频','youku','0','','XMTMwMDIyMjAyOA==','','','','');
INSERT INTO `mac_vod` VALUES('553','老湿帅帅的有没有  讲解简单清晰 看学习吧','','laoshishuaishuaideyoumeiyoujiangjiejiandanqingxikanxuexiba','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462502211.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','761','0','0','0','0','0','0','2.0','396','198','1457671087','1457671087','0','0','老湿帅帅的有没有  讲解简单清晰 看学习吧','youku','0','','XMTI2ODIyOTU0OA==','','','','');
INSERT INTO `mac_vod` VALUES('554','专业训练教学视频--身体运动能力训练  专业训练教学视频--','','zhuanyexunlianjiaoxueshipinshentiyundongnenlixunlianzhuanyexunlianjiaoxueshipin','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462502412.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','586','0','0','0','0','0','0','6.0','1182','197','1457671087','1457671087','0','0','专业训练教学视频--身体运动能力训练  专业训练教学视频--','youku','0','','XMTI4Njg5MTU3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('555','阳光大道  阳光大道','','yangguangdadaoyangguangdadao','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462502613.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','191','0','0','0','0','0','0','6.0','2364','394','1457671087','1457671087','0','0','阳光大道  阳光大道','youku','0','','XMTI2OTAzMjgwOA==','','','','');
INSERT INTO `mac_vod` VALUES('556','[三分半02]：评《傅满洲的面具》  老湿','','sanfenban02pingfumanzhoudemianjulaoshi','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462502714.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','330','0','0','0','0','0','0','3.0','597','199','1457671087','1457671087','0','0','【三分半02】：评《傅满洲的面具》  老湿','youku','0','','214891913','','','','');
INSERT INTO `mac_vod` VALUES('557','最新搞笑2014年美女失误集锦  最新搞笑','','zuixingaoxiao2014nianmeinvshiwujijinzuixingaoxiao','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462502815.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','727','0','0','0','0','0','0','6.0','1524','254','1457671087','1457671087','0','0','最新搞笑2014年美女失误集锦  最新搞笑','youku','0','','XMTI4NDgyMzUxMg==','','','','');
INSERT INTO `mac_vod` VALUES('558','纸巾老湿带你领略跳着舞的革命  视频: [搞笑视频]V字仇杀队','','zhijinlaoshidainilingluetiaozhouwudegemingshipingaoxiaoshipinVzichoushadui','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462503016.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','545','0','0','0','0','0','0','1.0','98','98','1457671091','1457671091','0','0','纸巾老湿带你领略跳着舞的革命  视频: [搞笑视频]V字仇杀队','youku','0','','XMTI2NzEyNjA4OA==','','','','');
INSERT INTO `mac_vod` VALUES('559','《社会心态与文化发展的关系》老湿醒世恒言第1期','','shehuixintaiyuwenhuafazhandeguanxilaoshixingshihengyandi1qi','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462503217.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','478','0','0','0','0','0','0','2.0','170','85','1457671091','1457671091','0','0','《社会心态与文化发展的关系》老湿醒世恒言第1期','youku','0','','75558354','','','','');
INSERT INTO `mac_vod` VALUES('560','拳击教学视频 怎么提高出拳速率 be fast 唯快不破  怎么提高出拳速率 be fast 唯快不破','','quanjijiaoxueshipinzenmetigaochuquansulvbefastweikuaibupozenmetigaochuquansulvbefastweikuaibupo','Q','','http://www.egao8.cc/upload/vod/2015-10-12/144462503318.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','321','0','0','0','0','0','0','7.0','2562','366','1457671091','1457671091','0','0','拳击教学视频 怎么提高出拳速率 be fast 唯快不破  怎么提高出拳速率 be fast 唯快不破','youku','0','','XMTI3MDgwMDU0MA==','','','','');
INSERT INTO `mac_vod` VALUES('561','《漫谈房价》老湿醒世恒言第2期','','mantanfangjialaoshixingshihengyandi2qi','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462503519.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','796','0','0','0','0','0','0','8.0','680','85','1457671091','1457671091','0','0','《漫谈房价》老湿醒世恒言第2期','youku','0','','83187551','','','','');
INSERT INTO `mac_vod` VALUES('562','评《青铜狂魔》  青铜狂魔','','pingqingtongkuangmoqingtongkuangmo','P','','http://www.egao8.cc/upload/vod/2015-10-12/14446250411.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','845','0','0','0','0','0','0','9.0','2178','242','1457671091','1457671091','0','0','评《青铜狂魔》  青铜狂魔','youku','0','','oz3cLuajvB0','','','','');
INSERT INTO `mac_vod` VALUES('563','老湿《进击的B》回归B的历史','','laoshijinjideBhuiguiBdelishi','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250442.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','877','0','0','0','0','0','0','10.0','3260','326','1457671091','1457671091','0','0','老湿《进击的TVB》回归TVB的历史','youku','0','','162402051','','','','');
INSERT INTO `mac_vod` VALUES('564','老湿视频全集','','laoshishipinquanji','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250453.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','23','0','0','0','0','0','0','10.0','4300','430','1457671091','1457671091','0','0','老湿视频全集','youku','0','','http://share.vrs.sohu.com/my/v.swf&autoplay=false&id=69314758#184128423$tudou\',\'u7B2Cu516Du5341u4E00u96C6#162402051#XNjQ1MjI5MjIw$tudou\',\'u7B2Cu4E94u5341u516Bu96C6#XNjMyMjA4NDQ4#151905532#150650973#149894423#150204556#172926970#169709562#XNTc0NzMxNTQ4#1fv2Nav4ND1CxT9GY5t0jQ..#111348069#107555973#151820719$tudou\',\'u7B2Cu4E09u5341u4E09u96C6#XNDIzOTU0Mzcy#91043915#91233307#83645968#88154211#87359373#85033448#80929858#80770415#79187489#88632703#88632298#100832975#89343534#75815253#83314665#85817557#75813976#75468608#83187551#75558354#77854492#78264674#77090483#75602608#74837667#72114333#72326326#81743803#82667279#88705442#82502180#http://share.vrs.sohu.com/my/v.swf&autoplay=false&id=69314758#184128423$tudou\',\'u7B2Cu516Du5341u4E00u96C6#162402051#XNjQ1MjI5MjIw$tudou\',\'u7B2Cu4E94u5341u516Bu96C6#XNjMyMjA4NDQ4#175906278#169709562#1fv2Nav4ND1CxT9GY5t0jQ..#111348069#107555973#151820719$tudou\',\'u7B2Cu4E09u5341u4E09u96C6#142461489#120341737$tudou\',\'u7B2Cu4E8Cu5341u4E03u96C6#117163147#90118982#76022829$tudou\',\'u7B2Cu5341u4E00u96C6#106960035','','','','');
INSERT INTO `mac_vod` VALUES('565','老湿我不解说世界杯第一期业余解说，1998世界杯决赛法国对巴西','','laoshiwobujieshuoshijiebeidiyiqiyeyujieshuo1998shijiebeijuesaifaguoduibaxi','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250464.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','379','0','0','0','0','0','0','9.0','3474','386','1457671091','1457671091','0','0','老湿我不解说世界杯第一期业余解说，1998世界杯决赛法国对巴西','youku','0','','XNzIzNjA2MzM2','','','','');
INSERT INTO `mac_vod` VALUES('566','老湿解说小评《与时尚同居》','','laoshijieshuoxiaopingyushishangtongji','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250475.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','262','0','0','0','0','0','0','9.0','3447','383','1457671091','1457671091','0','0','老湿解说小评《与时尚同居》','youku','0','','78264674','','','','');
INSERT INTO `mac_vod` VALUES('567','教育家杨格格挑战老湿 雷点众多','','jiaoyujiayanggegetaozhanlaoshileidianzhongduo','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446250496.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','457','0','0','0','0','0','0','9.0','846','94','1457671091','1457671091','0','0','教育家杨格格挑战老湿 雷点众多','youku','0','','78626098#78376619','','','','');
INSERT INTO `mac_vod` VALUES('568','伤不起的中国大片  伤不起的中国大片','','shangbuqidezhongguodapianshangbuqidezhongguodapian','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446250507.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','468','0','0','0','0','0','0','7.0','2121','303','1457671091','1457671091','0','0','伤不起的中国大片  伤不起的中国大片','youku','0','','XMTM0ODQ1MTU1Mg==','','','','');
INSERT INTO `mac_vod` VALUES('569','黄老湿教你锻炼身体之  黄老湿教你锻炼身体之','','huanglaoshijiaoniduanlianshentizhihuanglaoshijiaoniduanlianshentizhi','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446250518.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','767','0','0','0','0','0','0','10.0','270','27','1457671091','1457671091','0','0','黄老湿教你锻炼身体之  黄老湿教你锻炼身体之','youku','0','','XMTMzNTkzMTkyNA==','','','','');
INSERT INTO `mac_vod` VALUES('570','后天朝时代  后天朝时代','','houtianchaoshidaihoutianchaoshidai','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446250529.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','46','0','0','0','0','0','0','2.0','288','144','1457671091','1457671091','0','0','后天朝时代  后天朝时代','youku','0','','XMTM0NzQyNDEzMg==','','','','');
INSERT INTO `mac_vod` VALUES('571','大个子内线教学视频  大个子内线教学视频','','dagezinaxianjiaoxueshipindagezinaxianjiaoxueshipin','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462505410.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','466','0','0','0','0','0','0','9.0','126','14','1457671091','1457671091','0','0','大个子内线教学视频  大个子内线教学视频','youku','0','','XMTMxODY3NzA5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('572','黄老湿教青少年打篮球  黄老湿教青少年打篮球','','huanglaoshijiaoqingshaoniandalanqiuhuanglaoshijiaoqingshaoniandalanqiu','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462505511.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','904','0','0','0','0','0','0','8.0','872','109','1457671091','1457671091','0','0','黄老湿教青少年打篮球  黄老湿教青少年打篮球','youku','0','','XMTMwOTU4MTk4OA==','','','','');
INSERT INTO `mac_vod` VALUES('573','五人外线落位 打法  五人外线落位 打法','','wurenwaixianluoweidafawurenwaixianluoweidafa','W','','http://www.egao8.cc/upload/vod/2015-10-12/144462505712.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','210','0','0','0','0','0','0','5.0','665','133','1457671091','1457671091','0','0','五人外线落位 打法  五人外线落位 打法','youku','0','','XMTMxMDgxOTY3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('574','老湿胥渡吧搞笑视频全集最新牛人模仿  老湿胥渡吧搞笑视频全集最新牛人模仿','','laoshixudubagaoxiaoshipinquanjizuixinniurenmofanglaoshixudubagaoxiaoshipinquanjizuixinniurenmofang','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462505813.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','448','0','0','0','0','0','0','2.0','302','151','1457671091','1457671091','0','0','老湿胥渡吧搞笑视频全集最新牛人模仿  老湿胥渡吧搞笑视频全集最新牛人模仿','youku','0','','XMTMwMTk0OTEyOA==','','','','');
INSERT INTO `mac_vod` VALUES('575','黄老湿篮球教学视频--你确定你真的在教投篮吗？你有感么？  黄老湿篮球教学视频--','','huanglaoshilanqiujiaoxueshipinniquedingnizhendezaijiaotoulanmaniyouganmehuanglaoshilanqiujiaoxueshipin','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462505914.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','154','0','0','0','0','0','0','4.0','848','212','1457671091','1457671091','0','0','黄老湿篮球教学视频--你确定你真的在教投篮吗？你有感么？  黄老湿篮球教学视频--','youku','0','','XMTI4Njk1OTk1Mg==','','','','');
INSERT INTO `mac_vod` VALUES('576','低年级投篮训练视频教学  低年级投篮训练视频教学','','dinianjitoulanxunlianshipinjiaoxuedinianjitoulanxunlianshipinjiaoxue','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462506115.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','583','0','0','0','0','0','0','7.0','3318','474','1457671091','1457671091','0','0','低年级投篮训练视频教学  低年级投篮训练视频教学','youku','0','','XMTMwMTAyMDQyMA==','','','','');
INSERT INTO `mac_vod` VALUES('577','雷人搞笑老湿吐槽西游记  吐槽西游记','','leirengaoxiaolaoshitucaoxiyoujitucaoxiyouji','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462506316.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','957','0','0','0','0','0','0','6.0','1974','329','1457671091','1457671091','0','0','雷人搞笑老湿吐槽西游记  吐槽西游记','youku','0','','XMTI3OTgwMTY5Ng==','','','','');
INSERT INTO `mac_vod` VALUES('578','老湿！智能手环到底能不能泡到妞  老湿！智能手环到底能不能泡到妞','','laoshizhinenshouhuandaodinenbunenpaodaoniulaoshizhinenshouhuandaodinenbunenpaodaoniu','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462506817.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','323','0','0','0','0','0','0','1.0','60','60','1457671095','1457671095','0','0','老湿！智能手环到底能不能泡到妞  老湿！智能手环到底能不能泡到妞','youku','0','','XMTMwMTIxNTk2MA==','','','','');
INSERT INTO `mac_vod` VALUES('579','懂你-满文军  懂你','','dongnimanwenjundongni','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462506918.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','528','0','0','0','0','0','0','7.0','728','104','1457671095','1457671095','0','0','懂你-满文军  懂你','youku','0','','XMTI2OTAzMjMyNA==','','','','');
INSERT INTO `mac_vod` VALUES('580','黄老湿教你打篮球---中距离脚步训练教学视频  黄老湿教你打篮球---中距离脚步训练教学视频','','huanglaoshijiaonidalanqiuzhongjulijiaobuxunlianjiaoxueshipinhuanglaoshijiaonidalanqiuzhongjulijiaobuxunlianjiaoxueshipin','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462507119.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','470','0','0','0','0','0','0','3.0','1446','482','1457671095','1457671095','0','0','黄老湿教你打篮球---中距离脚步训练教学视频  黄老湿教你打篮球---中距离脚步训练教学视频','youku','0','','XMTMwMDE4OTQ2MA==','','','','');
INSERT INTO `mac_vod` VALUES('581','学校里的疯子 第四季 第十四集 “科学”发现每个人都有超能力—专辑：《[向尚飞影视传媒]爆笑校园短剧+街采神','','xuexiaolidefengzidisijidishisijikexuefaxianmeigerenduyouchaonenlizhuanjixiangshangfeiyingshichuanmeibaoxiaoxiaoyuanduanjujiecaishen','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446250781.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','248','0','0','0','0','0','0','9.0','216','24','1457671095','1457671095','0','0','学校里的疯子 第四季 第十四集 “科学”发现每个人都有超能力—专辑：《【向尚飞影视传媒】爆笑校园短剧+街采神','youku','0','','XODk5OTkxNjU2','','','','');
INSERT INTO `mac_vod` VALUES('582','发个国外青少年篮球队的视频  发个国外','','fageguowaiqingshaonianlanqiuduideshipinfageguowai','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446250782.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','178','0','0','0','0','0','0','7.0','2933','419','1457671095','1457671095','0','0','发个国外青少年篮球队的视频  发个国外','youku','0','','XMTI3NDU2NjE1Ng==','','','','');
INSERT INTO `mac_vod` VALUES('583','《我的滑板鞋》  最丧心病狂版','','wodehuabanxiezuisangxinbingkuangban','W','','http://www.egao8.cc/upload/vod/2015-10-12/14446250803.png','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','45','0','0','0','0','0','0','7.0','2387','341','1457671095','1457671095','0','0','《我的滑板鞋》  最丧心病狂版','youku','0','','XODgxNTkzNzU2','','','','');
INSERT INTO `mac_vod` VALUES('584','女孩赴韩国整容相亲被暴打—专辑：《郑云原创搞笑短片经典大合辑》','','nvhaifuhanguozhengrongxiangqinbeibaodazhuanjizhengyunyuanchuanggaoxiaoduanpianjingdiandaheji','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446250834.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','352','0','0','0','0','0','0','6.0','438','73','1457671095','1457671095','0','0','女孩赴韩国整容相亲被暴打—专辑：《郑云原创搞笑短片经典大合辑》','youku','0','','XOTAyNTkzNTM2','','','','');
INSERT INTO `mac_vod` VALUES('585','老湿情人节特别歌曲《一个世界》','','laoshiqingrenjietebiegequyigeshijie','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250835.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','574','0','0','0','0','0','0','2.0','268','134','1457671095','1457671095','0','0','老湿情人节特别歌曲《一个世界》','youku','0','','88154211','','','','');
INSERT INTO `mac_vod` VALUES('586','把妹达人法式泡妞秘籍—专辑：《[笑吧]最新最热最有趣整蛊恶搞失败集锦！》','','bameidarenfashipaoniumijizhuanjixiaobazuixinzuirezuiyouquzhengguegaoshibaijijin','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446250846.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','400','0','0','0','0','0','0','8.0','3192','399','1457671095','1457671095','0','0','把妹达人法式泡妞秘籍—专辑：《【笑吧】最新最热最有趣整蛊恶搞失败集锦！》','youku','0','','XODg1MjMzMjM2','','','','');
INSERT INTO `mac_vod` VALUES('587','老湿& 敖厂长双核强力吐槽《关公大战外星人》','','laoshiaochangchangshuangheqianglitucaoguangongdazhanwaixingren','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250847.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','991','0','0','0','0','0','0','10.0','2300','230','1457671095','1457671095','0','0','老湿& 敖厂长双核强力吐槽《关公大战外星人》','youku','0','','79187489','','','','');
INSERT INTO `mac_vod` VALUES('588','老湿第6部：令人蛋疼的《西游记》','','laoshidi6bulingrendantengdexiyouji','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250898.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','227','0','0','0','0','0','0','5.0','490','98','1457671095','1457671095','0','0','老湿第6部：令人蛋疼的《西游记》','youku','0','','72114333','','','','');
INSERT INTO `mac_vod` VALUES('589','老湿八扇屏03:生涯多戎马','','laoshibashanping03shengyaduorongma','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446250909.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','954','0','0','0','0','0','0','9.0','1872','208','1457671095','1457671095','0','0','老湿八扇屏03:生涯多戎马','youku','0','','150204556','','','','');
INSERT INTO `mac_vod` VALUES('590','老湿正说鸿门宴','','laoshizhengshuohongmenyan','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462509110.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','239','0','0','0','0','0','0','5.0','625','125','1457671095','1457671095','0','0','老湿正说鸿门宴','youku','0','','XNDkxNjgxMjAw','','','','');
INSERT INTO `mac_vod` VALUES('591','老湿八扇屏6:人心胜兵甲','','laoshibashanping6renxinshengbingjia','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462509211.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','617','0','0','0','0','0','0','7.0','2779','397','1457671095','1457671095','0','0','老湿八扇屏6:人心胜兵甲','youku','0','','XNjA3NjIyMTI4','','','','');
INSERT INTO `mac_vod` VALUES('592','老湿讲解菜花甜妈搞笑广告','','laoshijiangjiecaihuatianmagaoxiaoguanggao','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462509312.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','343','0','0','0','0','0','0','1.0','182','182','1457671095','1457671095','0','0','老湿讲解菜花甜妈搞笑广告','youku','0','','77090483','','','','');
INSERT INTO `mac_vod` VALUES('593','老湿八扇屏04:铁拳为争霸','','laoshibashanping04tiequanweizhengba','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462509313.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','638','0','0','0','0','0','0','2.0','746','373','1457671095','1457671095','0','0','老湿八扇屏04:铁拳为争霸','youku','0','','149894423','','','','');
INSERT INTO `mac_vod` VALUES('594','不吐不快拜年篇大王叫我后年播','','butubukuaibainianpiandawangjiaowohounianbo','B','','http://www.egao8.cc/upload/vod/2015-10-12/144462509414.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','945','0','0','0','0','0','0','10.0','2220','222','1457671095','1457671095','0','0','不吐不快拜年篇大王叫我后年播','youku','0','','XNjY0OTEwNDc2','','','','');
INSERT INTO `mac_vod` VALUES('595','老湿第8部点评新还珠格格  老湿批新还珠','','laoshidi8budianpingxinhuaizhugegelaoshipixinhuaizhu','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462509515.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','173','0','0','0','0','0','0','1.0','466','466','1457671095','1457671095','0','0','老湿第8部点评新还珠格格  老湿批新还珠','youku','0','','75602608','','','','');
INSERT INTO `mac_vod` VALUES('596','老湿解说点评步步惊心','','laoshijieshuodianpingbubujingxin','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462509616.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','952','0','0','0','0','0','0','7.0','3143','449','1457671096','1457671096','0','0','老湿解说点评步步惊心','youku','0','','77854492','','','','');
INSERT INTO `mac_vod` VALUES('597','老湿新《差不多先生》无差别饶舌第3作','','laoshixinchabuduoxianshengwuchabieraoshedi3zuo','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462509717.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','878','0','0','0','0','0','0','3.0','759','253','1457671096','1457671096','0','0','老湿新《差不多先生》无差别饶舌第3作','youku','0','','83314665','','','','');
INSERT INTO `mac_vod` VALUES('598','老湿解说亚锦赛十佳球','','laoshijieshuoyajinsaishijiaqiu','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462509818.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','717','0','0','0','0','0','0','1.0','30','30','1457671099','1457671099','0','0','老湿解说亚锦赛十佳球','youku','0','','88632298','','','','');
INSERT INTO `mac_vod` VALUES('599','土豪我们做朋友','','tuhaowomenzuopengyou','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462509919.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','773','0','0','0','0','0','0','7.0','2184','312','1457671099','1457671099','0','0','土豪我们做朋友','youku','0','','XNjYzODQ0MTAw','','','','');
INSERT INTO `mac_vod` VALUES('600','老湿GC第四期NFL年度十佳球[福利篇]','','laoshiGCdisiqiNFLniandushijiaqiufulipian','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251061.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','754','0','0','0','0','0','0','7.0','154','22','1457671099','1457671099','0','0','老湿GCTV第四期NFL年度十佳球【福利篇】','youku','0','','85033448','','','','');
INSERT INTO `mac_vod` VALUES('601','老湿《惊到你蛋疼的棒国神作》','','laoshijingdaonidantengdebangguoshenzuo','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251072.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','259','0','0','0','0','0','0','6.0','1440','240','1457671099','1457671099','0','0','老湿《惊到你蛋疼的棒国神作》','youku','0','','150204823#83645968','','','','');
INSERT INTO `mac_vod` VALUES('602','老湿新作小评国产三国影视与游戏','','laoshixinzuoxiaopingguochansanguoyingshiyuyouxi','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251083.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','103','0','0','0','0','0','0','1.0','405','405','1457671099','1457671099','0','0','老湿新作小评国产三国影视与游戏','youku','0','','80929858','','','','');
INSERT INTO `mac_vod` VALUES('603','老湿第5部 讲解《影子传说》','','laoshidi5bujiangjieyingzichuanshuo','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251094.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','571','0','0','0','0','0','0','8.0','3520','440','1457671100','1457671100','0','0','老湿第5部 讲解《影子传说》','youku','0','','72326326','','','','');
INSERT INTO `mac_vod` VALUES('604','老湿终结者 走进科学牛头怪之死[新第7部]','','laoshizhongjiezhezoujinkexueniutouguaizhisixindi7bu','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251105.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','668','0','0','0','0','0','0','9.0','3411','379','1457671100','1457671100','0','0','老湿终结者 走进科学牛头怪之死(新第7部)','youku','0','','91233307','','','','');
INSERT INTO `mac_vod` VALUES('605','老湿吐槽于妈雷人电影《换脸新娘》之神结局','','laoshitucaoyumaleirendianyinghuanlianxinniangzhishenjieju','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251116.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','366','0','0','0','0','0','0','6.0','2946','491','1457671100','1457671100','0','0','老湿吐槽于妈雷人电影《换脸新娘》之神结局','youku','0','','134212791','','','','');
INSERT INTO `mac_vod` VALUES('606','老湿吐槽解说西游降魔','','laoshitucaojieshuoxiyoujiangmo','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251127.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','856','0','0','0','0','0','0','6.0','2400','400','1457671100','1457671100','0','0','老湿吐槽解说西游降魔','youku','0','','111111#82502180#88705442#82667279#81743803#72326326#72114333#74837667#75602608#77090483#78264674#77854492#75558354#83187551#75468608#75813976#85817557#83314665#75815253#89343534#100832975#88632298#88632703#79187489#80770415#80929858#85033448#87359373#88154211#83645968#91233307#91043915#142461489$tudou\',\'u7B2Cu4E09u5341u4E09u96C6#151820719$tudou\',\'u7B2Cu4E09u5341u56DBu96C6#111348069#csW_4QzAHQUGSaOFamA6Fg..$ku6\',\'u7B2Cu4E09u5341u4E03u96C6#124694066#124996588','','','','');
INSERT INTO `mac_vod` VALUES('607','老湿新作再见2012','','laoshixinzuozaijian2012','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251138.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','799','0','0','0','0','0','0','2.0','440','220','1457671100','1457671100','0','0','老湿新作再见2012','youku','0','','123870725','','','','');
INSERT INTO `mac_vod` VALUES('608','老湿菊花哥《约战》魔兽搞笑比赛','','laoshijuhuageyuezhanmoshougaoxiaobisai','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251149.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','573','0','0','0','0','0','0','6.0','1020','170','1457671100','1457671100','0','0','老湿菊花哥《约战》魔兽搞笑比赛','youku','0','','104240545','','','','');
INSERT INTO `mac_vod` VALUES('609','老湿客串旁白君《麻辣江湖》公测动画！','','laoshikechuanpangbaijunmalajianghugongcedonghua','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462511610.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','527','0','0','0','0','0','0','9.0','1854','206','1457671100','1457671100','0','0','老湿客串旁白君《麻辣江湖》公测动画！','youku','0','','121816101','','','','');
INSERT INTO `mac_vod` VALUES('610','老湿《伤心太平洋之2010杯具大全》红军为我伴奏','','laoshishangxintaipingyangzhi2010beijudaquanhongjunweiwobanzou','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462511711.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','226','0','0','0','0','0','0','7.0','994','142','1457671100','1457671100','0','0','老湿《伤心太平洋之2010杯具大全》红军为我伴奏','youku','0','','100832975','','','','');
INSERT INTO `mac_vod` VALUES('611','老湿第2部《打倒非主流等牛鬼蛇神》','','laoshidi2budadaofeizhuliudengniuguisheshen','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462511812.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','706','0','0','0','0','0','0','1.0','277','277','1457671100','1457671100','0','0','老湿第2部《打倒非主流等牛鬼蛇神》','youku','0','','88705442','','','','');
INSERT INTO `mac_vod` VALUES('612','老湿解说三国杀 最风骚的内奸之袁绍','','laoshijieshuosanguoshazuifengsaodenajianzhiyuanshao','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462511913.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','721','0','0','0','0','0','0','1.0','19','19','1457671100','1457671100','0','0','老湿解说三国杀 最风骚的内奸之袁绍','youku','0','','75815253','','','','');
INSERT INTO `mac_vod` VALUES('613','菊花哥《驾车进京》游戏改编故事视频老湿客串','','juhuagejiachejinjingyouxigaibiangushishipinlaoshikechuan','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462512014.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','993','0','0','0','0','0','0','8.0','88','11','1457671100','1457671100','0','0','菊花哥《驾车进京》游戏改编故事视频老湿客串','youku','0','','104238567','','','','');
INSERT INTO `mac_vod` VALUES('614','逗士真爱 老湿超级福利篇','','doushizhenailaoshichaojifulipian','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462512015.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','464','0','0','0','0','0','0','7.0','1785','255','1457671100','1457671100','0','0','逗士真爱 老湿超级福利篇','youku','0','','87359373','','','','');
INSERT INTO `mac_vod` VALUES('615','老湿第11部小评国产动漫','','laoshidi11buxiaopingguochandongman','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462512116.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','543','0','0','0','0','0','0','7.0','1659','237','1457671100','1457671100','0','0','老湿第11部小评国产动漫','youku','0','','80770415','','','','');
INSERT INTO `mac_vod` VALUES('616','《R甩饼歌》老湿无差别饶舌第2作','','Rshuaibinggelaoshiwuchabieraoshedi2zuo','R','','http://www.egao8.cc/upload/vod/2015-10-12/144462512217.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','361','0','0','0','0','0','0','6.0','312','52','1457671100','1457671100','0','0','《RAP版甩饼歌》老湿无差别饶舌第2作','youku','0','','85817557','','','','');
INSERT INTO `mac_vod` VALUES('617','夏侯传','','xiahouchuan','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462512318.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','14','0','0','0','0','0','0','6.0','186','31','1457671100','1457671100','0','0','夏侯传','youku','0','','91043915','','','','');
INSERT INTO `mac_vod` VALUES('618','老湿不吐不快西游记补全录','','laoshibutubukuaixiyoujibuquanlu','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462512519.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','769','0','0','0','0','0','0','8.0','2528','316','1457671104','1457671104','0','0','老湿不吐不快西游记补全录','youku','0','','MTExNjIzMjk5$hd_56\',\'u4EE4u4EBAu86CBu75BCu7684u897Fu6E38u8BB0','','','','');
INSERT INTO `mac_vod` VALUES('619','老湿歪批穆桂英','','laoshiwaipimuguiying','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251311.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','909','0','0','0','0','0','0','5.0','310','62','1457671104','1457671104','0','0','老湿歪批穆桂英','youku','0','','148847409$tudou\',\'u7280u5229u70B9u8BC4u536Bu89C6u7248','','','','');
INSERT INTO `mac_vod` VALUES('620','评《至暗之时》_烂片无国界第一弹 老湿归来','','pingzhianzhishilanpianwuguojiediyidanlaoshiguilai','P','','http://www.egao8.cc/upload/vod/2015-10-12/14446251322.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','302','0','0','0','0','0','0','6.0','150','25','1457671104','1457671104','0','0','评《至暗之时》_烂片无国界第一弹 老湿归来','youku','0','','102039316','','','','');
INSERT INTO `mac_vod` VALUES('621','圣诞与剩蛋老湿无差别饶舌','','shengdanyushengdanlaoshiwuchabieraoshe','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446251333.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','922','0','0','0','0','0','0','5.0','2360','472','1457671104','1457671104','0','0','圣诞与剩蛋老湿无差别饶舌','youku','0','','75813976','','','','');
INSERT INTO `mac_vod` VALUES('622','老湿第7部：《伤不起的中国大片》','','laoshidi7bushangbuqidezhongguodapian','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251344.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','959','0','0','0','0','0','0','9.0','270','30','1457671104','1457671104','0','0','老湿第7部：《伤不起的中国大片》','youku','0','','74837667','','','','');
INSERT INTO `mac_vod` VALUES('623','乱谈《史前巨鳄3》_烂片无国界第二弹','','luantanshiqianjue3lanpianwuguojiedierdan','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251355.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','74','0','0','0','0','0','0','10.0','3110','311','1457671104','1457671104','0','0','乱谈《史前巨鳄3》_烂片无国界第二弹','youku','0','','111348069','','','','');
INSERT INTO `mac_vod` VALUES('624','八扇屏最帅的独行侠','','bashanpingzuishuaideduxingxia','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446251366.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','645','0','0','0','0','0','0','10.0','340','34','1457671104','1457671104','0','0','八扇屏最帅的独行侠','youku','0','','144574106','','','','');
INSERT INTO `mac_vod` VALUES('625','老湿第3部《藐视高丽棒子的历史》','','laoshidi3bumiaoshigaolibangzidelishi','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251377.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','21','0','0','0','0','0','0','10.0','1560','156','1457671104','1457671104','0','0','老湿第3部《藐视高丽棒子的历史》','youku','0','','82667279','','','','');
INSERT INTO `mac_vod` VALUES('626','老湿八扇屏5:当年笑赢家','','laoshibashanping5dangnianxiaoyingjia','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251388.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','767','0','0','0','0','0','0','7.0','3437','491','1457671104','1457671104','0','0','老湿八扇屏5:当年笑赢家','youku','0','','150650973','','','','');
INSERT INTO `mac_vod` VALUES('627','老湿最新原创[实验小短片]《神》','','laoshizuixinyuanchuangshiyanxiaoduanpianshen','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446251399.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','919','0','0','0','0','0','0','1.0','337','337','1457671104','1457671104','0','0','老湿最新原创【实验小短片】《神》','youku','0','','113946361','','','','');
INSERT INTO `mac_vod` VALUES('628','三国歌曲周郎','','sanguogequzhoulang','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462514010.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','231','0','0','0','0','0','0','2.0','204','102','1457671104','1457671104','0','0','三国歌曲周郎','youku','0','','XNTE1MTg0ODA0','','','','');
INSERT INTO `mac_vod` VALUES('629','老湿《大学生活启示录》视频','','laoshidaxueshenghuoqishilushipin','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462514111.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','425','0','0','0','0','0','0','2.0','860','430','1457671104','1457671104','0','0','老湿《大学生活启示录》视频','youku','0','','89343534','','','','');
INSERT INTO `mac_vod` VALUES('630','老湿解说中国VS6星巴西 基情大战','','laoshijieshuozhongguoVS6xingbaxijiqingdazhan','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462514212.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','442','0','0','0','0','0','0','4.0','1288','322','1457671104','1457671104','0','0','老湿解说中国VS6星巴西 基情大战','youku','0','','88632703','','','','');
INSERT INTO `mac_vod` VALUES('631','老湿菊花哥再度联手《拳皇大战DNF》','','laoshijuhuagezaidulianshouquanhuangdazhanDNF','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462514313.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','694','0','0','0','0','0','0','8.0','2120','265','1457671104','1457671104','0','0','老湿菊花哥再度联手《拳皇大战DNF》','youku','0','','80340787','','','','');
INSERT INTO `mac_vod` VALUES('632','老湿第1部《超女大战国足》','','laoshidi1buchaonvdazhanguozu','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462514414.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','308','0','0','0','0','0','0','4.0','1416','354','1457671104','1457671104','0','0','老湿第1部《超女大战国足》','youku','0','','82502180','','','','');
INSERT INTO `mac_vod` VALUES('633','老湿客串 菊花哥《超越神的小游戏》','','laoshikechuanjuhuagechaoyueshendexiaoyouxi','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462514515.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','383','0','0','0','0','0','0','1.0','419','419','1457671104','1457671104','0','0','老湿客串 菊花哥《超越神的小游戏》','youku','0','','79517446','','','','');
INSERT INTO `mac_vod` VALUES('634','老湿第4部《后天朝时代》','','laoshidi4buhoutianchaoshidai','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462514616.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','234','0','0','0','0','0','0','2.0','300','150','1457671104','1457671104','0','0','老湿第4部《后天朝时代》','youku','0','','81743803','','','','');
INSERT INTO `mac_vod` VALUES('635','解说回顾2012欧洲杯十佳球','','jieshuohuigu2012ouzhoubeishijiaqiu','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462514717.jpg','','','','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','648','0','0','0','0','0','0','5.0','1105','221','1457671104','1457671104','0','0','解说回顾2012欧洲杯十佳球','youku','0','','107555973','','','','');
INSERT INTO `mac_vod` VALUES('636','老湿不吐不快第三期15《我至今填不完十个坑》','','laoshibutubukuaidisanqi15wozhijintianbuwanshigekang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989650.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','128','0','0','0','0','0','0','9.0','3726','414','1457671104','1457671104','0','0','老湿不吐不快第三期15《我至今填不完十个坑》','tudou','0','','244895615','','','','');
INSERT INTO `mac_vod` VALUES('637','老湿英雄谱第一集：《美国队长》大百科','','laoshiyingxiongpudiyijimeiguoduichangdabaike','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989600.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','146','0','0','0','0','0','0','2.0','496','248','1457671104','1457671104','0','0','老湿英雄谱第一集：《美国队长》大百科','tudou','0','','231440864','','','','');
INSERT INTO `mac_vod` VALUES('638','老湿评游戏：屎一样的游戏《哥斯拉》','','laoshipingyouxishiyiyangdeyouxigesila','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989510.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','818','0','0','0','0','0','0','8.0','2912','364','1457671108','1457671108','0','0','老湿评游戏：屎一样的游戏《哥斯拉》','youku','0','','XMTQxMDk1Nzg2NA==','','','','');
INSERT INTO `mac_vod` VALUES('639','老湿不吐不快第三季13《炸裂的千人斩》','','laoshibutubukuaidisanji13zhaliedeqianrenzhan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989470.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','560','0','0','0','0','0','0','2.0','448','224','1457671108','1457671108','0','0','老湿不吐不快第三季13《炸裂的千人斩》','tudou','0','','244399402','','','','');
INSERT INTO `mac_vod` VALUES('640','老湿不吐不快第三季02：评《带子雄狼》系列','','laoshibutubukuaidisanji02pingdaizixionglangxilie','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989420.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','743','0','0','0','0','0','0','5.0','1970','394','1457671108','1457671108','0','0','老湿不吐不快第三季02：评《带子雄狼》系列','tudou','0','','242104603','','','','');
INSERT INTO `mac_vod` VALUES('641','老湿篮球表演：万合第一控球后卫','','laoshilanqiubiaoyanwanhediyikongqiuhouwei','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989380.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','839','0','0','0','0','0','0','4.0','1564','391','1457671108','1457671108','0','0','老湿篮球表演：万合第一控球后卫','tudou','0','','237856946','','','','');
INSERT INTO `mac_vod` VALUES('642','老湿搜神记第四期:评《沧州绝招》','','laoshisoushenjidisiqipingcangzhoujuezhao','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989340.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','540','0','0','0','0','0','0','3.0','282','94','1457671108','1457671108','0','0','老湿搜神记第四期:评《沧州绝招》','tudou','0','','229204963','','','','');
INSERT INTO `mac_vod` VALUES('643','老湿鉴宝:充满情怀的游戏机','','laoshijianbaochongmanqinghuaideyouxiji','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989290.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','7','0','0','0','0','0','0','9.0','3267','363','1457671108','1457671108','0','0','老湿鉴宝:充满情怀的游戏机','tudou','0','','219364133','','','','');
INSERT INTO `mac_vod` VALUES('644','老湿解说NBA历史十大扣篮','','laoshijieshuoNBAlishishidakoulan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989250.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','117','0','0','0','0','0','0','8.0','1352','169','1457671108','1457671108','0','0','老湿解说NBA历史十大扣篮','tudou','0','','220474170','','','','');
INSERT INTO `mac_vod` VALUES('645','老湿解说《行尸走肉》正确打开方式','','laoshijieshuoxingshizourouzhengquedakaifangshi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989210.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','719','0','0','0','0','0','0','6.0','1296','216','1457671108','1457671108','0','0','老湿解说《行尸走肉》正确打开方式','tudou','0','','188309672','','','','');
INSERT INTO `mac_vod` VALUES('646','老湿查缺补漏再评《西游记》','','laoshichaquebulouzaipingxiyouji','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989160.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','879','0','0','0','0','0','0','5.0','350','70','1457671108','1457671108','0','0','老湿查缺补漏再评《西游记》','tudou','0','','191506525','','','','');
INSERT INTO `mac_vod` VALUES('647','老湿评怪兽电影 闲谈哥斯拉','','laoshipingguaishoudianyingxiantangesila','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989120.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','133','0','0','0','0','0','0','1.0','280','280','1457671108','1457671108','0','0','老湿评怪兽电影 闲谈哥斯拉','tudou','0','','190384694','','','','');
INSERT INTO `mac_vod` VALUES('648','老湿吐槽《来自星星的你》','','laoshitucaolaizixingxingdeni','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989080.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','734','0','0','0','0','0','0','9.0','18','2','1457671108','1457671108','0','0','老湿吐槽《来自星星的你》','56','0','','MTEyNTU3NjIw','','','','');
INSERT INTO `mac_vod` VALUES('649','老湿歌曲《贝尔之歌》','','laoshigequbeierzhige','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561989030.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','904','0','0','0','0','0','0','4.0','524','131','1457671108','1457671108','0','0','老湿歌曲《贝尔之歌》','tudou','0','','191832927','','','','');
INSERT INTO `mac_vod` VALUES('650','老湿再批西游记 补全版','','laoshizaipixiyoujibuquanban','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988990.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','86','0','0','0','0','0','0','6.0','2508','418','1457671108','1457671108','0','0','老湿再批西游记 补全版','tudou','0','','191506525','','','','');
INSERT INTO `mac_vod` VALUES('651','老湿批好莱坞大片《外太空九号计划》','','laoshipihaolaiwudapianwaitaikongjiuhaojihua','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988950.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','189','0','0','0','0','0','0','10.0','990','99','1457671108','1457671108','0','0','老湿批好莱坞大片《外太空九号计划》','youku','0','','XNzEyNTMxNjEy','','','','');
INSERT INTO `mac_vod` VALUES('652','老湿歪谈末日营销 吐槽《超强台风》','','laoshiwaitanmoriyingxiaotucaochaoqiangtaifeng','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988910.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','842','0','0','0','0','0','0','10.0','190','19','1457671108','1457671108','0','0','老湿歪谈末日营销 吐槽《超强台风》','56','0','','MTI2NjM2Njk3','','','','');
INSERT INTO `mac_vod` VALUES('653','老湿号外:盘点十大电影配乐','','laoshihaowaipandianshidadianyingpeile','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988860.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','644','0','0','0','0','0','0','10.0','2600','260','1457671108','1457671108','0','0','老湿号外:盘点十大电影配乐','tudou','0','','215538177','','','','');
INSERT INTO `mac_vod` VALUES('654','老湿打你妹01:洛奇VS阿波罗','','laoshidanimei01luoqiVSaboluo','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988820.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','409','0','0','0','0','0','0','9.0','2349','261','1457671108','1457671108','0','0','老湿打你妹01:洛奇VS阿波罗','tudou','0','','201196434','','','','');
INSERT INTO `mac_vod` VALUES('655','老湿解说：NBA历史十大封盖','','laoshijieshuoNBAlishishidafenggai','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988780.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','424','0','0','0','0','0','0','9.0','4005','445','1457671108','1457671108','0','0','老湿解说：NBA历史十大封盖','tudou','0','','220674569','','','','');
INSERT INTO `mac_vod` VALUES('656','老湿吐槽辱华电影《傅满洲的面具》','','laoshitucaoruhuadianyingfumanzhoudemianju','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988730.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','693','0','0','0','0','0','0','4.0','1380','345','1457671108','1457671108','0','0','老湿吐槽辱华电影《傅满洲的面具》','tudou','0','','214891913','','','','');
INSERT INTO `mac_vod` VALUES('657','老湿解说《走进狄仁杰》','','laoshijieshuozoujindirenjie','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988690.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','188','0','0','0','0','0','0','7.0','1610','230','1457671108','1457671108','0','0','老湿解说《走进狄仁杰》','youku','0','','XOTE0MzM2MTA0','','','','');
INSERT INTO `mac_vod` VALUES('658','老湿解说《报告老板之豪言壮旅》','','laoshijieshuobaogaolaobanzhihaoyanzhuanglv','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988640.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','394','0','0','0','0','0','0','4.0','396','99','1457671112','1457671112','0','0','老湿解说《报告老板之豪言壮旅》','youku','0','','XODg2ODI2MDc2','','','','');
INSERT INTO `mac_vod` VALUES('659','老湿评《雍正命丧少林门》','','laoshipingyongzhengmingsangshaolinmen','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988590.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','32','0','0','0','0','0','0','5.0','1645','329','1457671112','1457671112','0','0','老湿评《雍正命丧少林门》','tudou','0','','219077798','','','','');
INSERT INTO `mac_vod` VALUES('660','老湿吐槽《机械战警大百科》下','','laoshitucaojixiezhanjingdabaikexia','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988550.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','939','0','0','0','0','0','0','9.0','3672','408','1457671112','1457671112','0','0','老湿吐槽《机械战警大百科》下','tudou','0','','242527264','','','','');
INSERT INTO `mac_vod` VALUES('661','老湿三分半第三期:小评《俄罗斯方舟》','','laoshisanfenbandisanqixiaopingeluosifangzhou','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988500.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','963','0','0','0','0','0','0','5.0','205','41','1457671112','1457671112','0','0','老湿三分半第三期:小评《俄罗斯方舟》','tudou','0','','226857568','','','','');
INSERT INTO `mac_vod` VALUES('662','老湿为什么不做热门的电影？','','laoshiweishimebuzuoremendedianying','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988460.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','171','0','0','0','0','0','0','3.0','882','294','1457671112','1457671112','0','0','老湿为什么不做热门的电影？','tudou','0','','232773330','','','','');
INSERT INTO `mac_vod` VALUES('663','老湿搜神记第六期：评《福尔摩斯与中国女侠》','','laoshisoushenjidiliuqipingfuermosiyuzhongguonvxia','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988420.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','96','0','0','0','0','0','0','9.0','1926','214','1457671112','1457671112','0','0','老湿搜神记第六期：评《福尔摩斯与中国女侠》','tudou','0','','229370362','','','','');
INSERT INTO `mac_vod` VALUES('664','老湿说唱《艾劲的爱情故事》','','laoshishuochangaijingdeaiqinggushi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988370.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','994','0','1','1','0','0','0','7.0','3220','460','1457671112','1457671112','1458713074','0','老湿说唱《艾劲的爱情故事》','tudou','0','','235041356','','','','');
INSERT INTO `mac_vod` VALUES('665','老湿解说MLB总决赛','','laoshijieshuoMLBzongjuesai','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988320.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','86','0','0','0','0','0','0','5.0','2125','425','1457671112','1457671112','0','0','老湿解说MLB总决赛','tudou','0','','230078029','','','','');
INSERT INTO `mac_vod` VALUES('666','老湿不吐不快第三季01：老湿评《座头市》系列','','laoshibutubukuaidisanji01laoshipingzuotoushixilie','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988260.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','814','0','0','0','0','0','0','1.0','360','360','1457671113','1457671113','0','0','老湿不吐不快第三季01：老湿评《座头市》系列','youku','0','','XMTM2MzMzODg5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('667','老湿英雄谱番外篇01 美国队长死太快','','laoshiyingxiongpufanwaipian01meiguoduichangsitaikuai','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988190.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','89','0','0','0','0','0','0','10.0','20','2','1457671113','1457671113','0','0','老湿英雄谱番外篇01 美国队长死太快','tudou','0','','231955432','','','','');
INSERT INTO `mac_vod` VALUES('668','老湿不吐不快第三季03：评《修罗雪姬》','','laoshibutubukuaidisanji03pingxiuluoxueji','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988040.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','540','0','0','0','0','0','0','5.0','980','196','1457671113','1457671113','0','0','老湿不吐不快第三季03：评《修罗雪姬》','tudou','0','','242340616','','','','');
INSERT INTO `mac_vod` VALUES('669','老湿英雄谱番外篇03：幻影杀手《艾丽卡》','','laoshiyingxiongpufanwaipian03huanyingshashouailika','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561988000.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','763','0','0','0','0','0','0','3.0','69','23','1457671113','1457671113','0','0','老湿英雄谱番外篇03：幻影杀手《艾丽卡》','tudou','0','','233103966','','','','');
INSERT INTO `mac_vod` VALUES('670','老湿不吐不快第三季05：最雷日版《科学怪人》','','laoshibutubukuaidisanji05zuileiribankexueguairen','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987940.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','575','0','0','0','0','0','0','10.0','4220','422','1457671113','1457671113','0','0','老湿不吐不快第三季05：最雷日版《科学怪人》','tudou','0','','242748129','','','','');
INSERT INTO `mac_vod` VALUES('671','老湿大战壁挂炉','','laoshidazhanbigualu','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987900.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','262','0','0','0','0','0','0','10.0','3170','317','1457671113','1457671113','0','0','老湿大战壁挂炉','tudou','0','','234170567','','','','');
INSERT INTO `mac_vod` VALUES('672','老湿不吐不快第三季08《罗杰科曼和闸蟹魔王》','','laoshibutubukuaidisanji08luojiekemanhezhaxiemowang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987850.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','828','0','0','0','0','0','0','6.0','1446','241','1457671113','1457671113','0','0','老湿不吐不快第三季08《罗杰科曼和闸蟹魔王》','tudou','0','','243315181','','','','');
INSERT INTO `mac_vod` VALUES('673','老湿最新:《monkey magic》混剪','','laoshizuixinmonkeymagichunjian','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987810.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','244','0','0','0','0','0','0','2.0','922','461','1457671113','1457671113','0','0','老湿最新:《monkey magic》混剪','tudou','0','','234608674','','','','');
INSERT INTO `mac_vod` VALUES('674','老湿歌曲《我和电脑下象棋下了一整晚》','','laoshigequwohediannaoxiaxiangqixialiaoyizhengwan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987770.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','703','0','0','0','0','0','0','3.0','315','105','1457671113','1457671113','0','0','老湿歌曲《我和电脑下象棋下了一整晚》','tudou','0','','243389880','','','','');
INSERT INTO `mac_vod` VALUES('675','老湿不吐不快第三季07：读秒解构美版《哥斯拉》','','laoshibutubukuaidisanji07dumiaojiegoumeibangesila','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987720.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','865','0','0','0','0','0','0','3.0','852','284','1457671113','1457671113','0','0','老湿不吐不快第三季07：读秒解构美版《哥斯拉》','tudou','0','','243141543','','','','');
INSERT INTO `mac_vod` VALUES('676','老湿不吐不快第三季11 《金刚列传》','','laoshibutubukuaidisanji11jingangliechuan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987660.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','108','0','0','0','0','0','0','2.0','438','219','1457671113','1457671113','0','0','老湿不吐不快第三季11 《金刚列传》','tudou','0','','243951621','','','','');
INSERT INTO `mac_vod` VALUES('677','老湿大宝鉴04期《卡片争霸战》','','laoshidabaojian04qikapianzhengbazhan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987620.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','781','0','0','0','0','0','0','4.0','1456','364','1457671113','1457671113','0','0','老湿大宝鉴04期《卡片争霸战》','tudou','0','','247613735','','','','');
INSERT INTO `mac_vod` VALUES('678','老湿《大宝鉴》第一集：水浒英雄卡','','laoshidabaojiandiyijishuihuyingxiongka','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987570.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','100','0','0','0','0','0','0','5.0','1125','225','1457671117','1457671117','0','0','老湿《大宝鉴》第一集：水浒英雄卡','tudou','0','','246457771','','','','');
INSERT INTO `mac_vod` VALUES('679','老湿大宝鉴05《葫芦娃大战变形金刚[上]》','','laoshidabaojian05huluwadazhanbianxingjingangshang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987530.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','90','0','0','0','0','0','0','10.0','4440','444','1457671117','1457671117','0','0','老湿大宝鉴05《葫芦娃大战变形金刚（上）》','tudou','0','','247998735','','','','');
INSERT INTO `mac_vod` VALUES('680','老湿英雄谱番外篇02《超胆侠》漫威遗珠','','laoshiyingxiongpufanwaipian02chaodanxiamanweiyizhu','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987490.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','536','0','0','0','0','0','0','3.0','315','105','1457671117','1457671117','0','0','老湿英雄谱番外篇02《超胆侠》漫威遗珠','tudou','0','','232551598','','','','');
INSERT INTO `mac_vod` VALUES('681','老湿英雄谱第二集：不可思议《绿巨人》','','laoshiyingxiongpudierjibukesiyilvjuren','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987450.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','787','0','0','0','0','0','0','7.0','1148','164','1457671117','1457671117','0','0','老湿英雄谱第二集：不可思议《绿巨人》','tudou','0','','231506869','','','','');
INSERT INTO `mac_vod` VALUES('682','老湿《搜神记》第一期：评《毒吻》','','laoshisoushenjidiyiqipingduwen','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987400.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','408','0','0','0','0','0','0','8.0','3488','436','1457671117','1457671117','0','0','老湿《搜神记》第一期：评《毒吻》','tudou','0','','228946939','','','','');
INSERT INTO `mac_vod` VALUES('683','老湿混剪 神探狄仁杰版《任逍遥》','','laoshihunjianshentandirenjiebanrenxiaoyao','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987360.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','435','0','0','0','0','0','0','5.0','1100','220','1457671117','1457671117','0','0','老湿混剪 神探狄仁杰版《任逍遥》','tudou','0','','235508591','','','','');
INSERT INTO `mac_vod` VALUES('684','老湿英雄谱第五集 漫威电影专场','','laoshiyingxiongpudiwujimanweidianyingzhuanchang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987320.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','621','0','0','0','0','0','0','10.0','4230','423','1457671117','1457671117','0','0','老湿英雄谱第五集 漫威电影专场','tudou','0','','231955432','','','','');
INSERT INTO `mac_vod` VALUES('685','老湿搜神记第五期：评《异想天开》','','laoshisoushenjidiwuqipingyixiangtiankai','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987280.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','690','0','0','0','0','0','0','4.0','752','188','1457671117','1457671117','0','0','老湿搜神记第五期：评《异想天开》','tudou','0','','229280505','','','','');
INSERT INTO `mac_vod` VALUES('686','老湿翻唱《茉莉花》','','laoshifanchangmolihua','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987230.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','583','0','0','0','0','0','0','9.0','162','18','1457671117','1457671117','0','0','老湿翻唱《茉莉花》','tudou','0','','236106725','','','','');
INSERT INTO `mac_vod` VALUES('687','老湿搜神记第七期：评《珊瑚岛上的死光》','','laoshisoushenjidiqiqipingshanhudaoshangdesiguang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987190.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','709','0','0','0','0','0','0','8.0','3184','398','1457671117','1457671117','0','0','老湿搜神记第七期：评《珊瑚岛上的死光》','tudou','0','','229499053','','','','');
INSERT INTO `mac_vod` VALUES('688','老湿不吐不快第三季06：《西游补全录之二》','','laoshibutubukuaidisanji06xiyoubuquanluzhier','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987150.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','199','0','0','0','0','0','0','8.0','3392','424','1457671117','1457671117','0','0','老湿不吐不快第三季06：《西游补全录之二》','tudou','0','','242915458','','','','');
INSERT INTO `mac_vod` VALUES('689','老湿英雄谱第三集：《蜘蛛侠》小百科','','laoshiyingxiongpudisanjizhizhuxiaxiaobaike','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987100.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','148','0','0','0','0','0','0','8.0','3416','427','1457671117','1457671117','0','0','老湿英雄谱第三集：《蜘蛛侠》小百科','tudou','0','','231573668','','','','');
INSERT INTO `mac_vod` VALUES('690','老湿不吐不快第三季12 评《最弱章鱼怪》','','laoshibutubukuaidisanji12pingzuiruozhangyuguai','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987060.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','875','0','0','0','0','0','0','3.0','285','95','1457671117','1457671117','0','0','老湿不吐不快第三季12 评《最弱章鱼怪》','tudou','0','','244148441','','','','');
INSERT INTO `mac_vod` VALUES('691','老湿不吐不快第三季16《柯南早期的十个恐怖案件》','','laoshibutubukuaidisanji16kenanzaoqideshigekongbuanjian','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561987020.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','164','0','0','0','0','0','0','10.0','1040','104','1457671117','1457671117','0','0','老湿不吐不快第三季16《柯南早期的十个恐怖案件》','tudou','0','','245084702','','','','');
INSERT INTO `mac_vod` VALUES('692','老湿评《钢铁侠》撞脸日记 英雄谱第四集','','laoshipinggangtiexiazhuanglianrijiyingxiongpudisiji','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986980.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','518','0','0','0','0','0','0','8.0','1872','234','1457671117','1457671117','0','0','老湿评《钢铁侠》撞脸日记 英雄谱第四集','tudou','0','','231637175','','','','');
INSERT INTO `mac_vod` VALUES('693','老湿《大宝鉴》第二集：变种水浒卡','','laoshidabaojiandierjibianzhongshuihuka','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986930.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','411','0','0','0','0','0','0','4.0','24','6','1457671117','1457671117','0','0','老湿《大宝鉴》第二集：变种水浒卡','tudou','0','','246846785','','','','');
INSERT INTO `mac_vod` VALUES('694','老湿不吐不快第三季04：《机械战警补全录》','','laoshibutubukuaidisanji04jixiezhanjingbuquanlu','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986890.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','535','0','0','0','0','0','0','10.0','2940','294','1457671117','1457671117','0','0','老湿不吐不快第三季04：《机械战警补全录》','tudou','0','','242527264','','','','');
INSERT INTO `mac_vod` VALUES('695','不吐不快第三季主题曲MV《无可奉告》','','butubukuaidisanjizhutiquMVwukefenggao','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561986850.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','48','0','0','0','0','0','0','4.0','1848','462','1457671117','1457671117','0','0','不吐不快第三季主题曲MV《无可奉告》','tudou','0','','244736538','','','','');
INSERT INTO `mac_vod` VALUES('696','老湿大宝鉴03《正说天罡三十六》','','laoshidabaojian03zhengshuotiangangsanshiliu','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986800.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','830','0','0','0','0','0','0','3.0','1434','478','1457671117','1457671117','0','0','老湿大宝鉴03《正说天罡三十六》','tudou','0','','247233328','','','','');
INSERT INTO `mac_vod` VALUES('697','老湿不吐不快第三季09《大裸体天魔》','','laoshibutubukuaidisanji09daluotitianmo','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986760.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','729','0','0','0','0','0','0','2.0','98','49','1457671117','1457671117','0','0','老湿不吐不快第三季09《大裸体天魔》','tudou','0','','243545946','','','','');
INSERT INTO `mac_vod` VALUES('698','老湿批美国烂片《异形大战阿凡达》','','laoshipimeiguolanpianyixingdazhanafanda','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986720.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','449','0','0','0','0','0','0','3.0','105','35','1457671121','1457671121','0','0','老湿批美国烂片《异形大战阿凡达》','tudou','0','','194463954','','','','');
INSERT INTO `mac_vod` VALUES('699','老湿不吐不快第三季10《长虫大战》','','laoshibutubukuaidisanji10changchongdazhan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986680.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','148','0','0','0','0','0','0','10.0','290','29','1457671121','1457671121','0','0','老湿不吐不快第三季10《长虫大战》','tudou','0','','243718117','','','','');
INSERT INTO `mac_vod` VALUES('700','不吐不快第三季18：最后一期《终章：我的错误合集》','','butubukuaidisanji18zuihouyiqizhongzhangwodecuowuheji','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561986630.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','631','0','0','0','0','0','0','6.0','1536','256','1457671121','1457671121','0','0','不吐不快第三季18：最后一期《终章：我的错误合集》','tudou','0','','245565262','','','','');
INSERT INTO `mac_vod` VALUES('701','老湿业余解说:我不解说世界杯第1期','','laoshiyeyujieshuowobujieshuoshijiebeidi1qi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986590.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','622','0','0','0','0','0','0','2.0','714','357','1457671121','1457671121','0','0','老湿业余解说:我不解说世界杯第1期','tudou','0','','194917110','','','','');
INSERT INTO `mac_vod` VALUES('702','老湿不吐不快第三季14《黄飞鸿电影十大对手》','','laoshibutubukuaidisanji14huangfeihongdianyingshidaduishou','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986550.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','61','0','0','0','0','0','0','1.0','335','335','1457671121','1457671121','0','0','老湿不吐不快第三季14《黄飞鸿电影十大对手》','tudou','0','','244614584','','','','');
INSERT INTO `mac_vod` VALUES('703','老湿大宝鉴06《葫芦娃大战变形金刚[下]》','','laoshidabaojian06huluwadazhanbianxingjingangxia','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986500.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','360','0','0','0','0','0','0','5.0','880','176','1457671121','1457671121','0','0','老湿大宝鉴06《葫芦娃大战变形金刚（下）》','tudou','0','','248109745','','','','');
INSERT INTO `mac_vod` VALUES('704','老湿不吐不快第三季17《动漫十大惯例现象》','','laoshibutubukuaidisanji17dongmanshidaguanlixianxiang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986460.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','646','0','0','0','0','0','0','10.0','4760','476','1457671121','1457671121','0','0','老湿不吐不快第三季17《动漫十大惯例现象》','tudou','0','','245353878','','','','');
INSERT INTO `mac_vod` VALUES('705','老湿不吐不快《跳票曲》','','laoshibutubukuaitiaopiaoqu','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986420.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','18','0','0','0','0','0','0','8.0','520','65','1457671121','1457671121','0','0','老湿不吐不快《跳票曲》','youku','0','','XNjUwNjc2NDA4','','','','');
INSERT INTO `mac_vod` VALUES('706','老湿CG第六期 冬奥会','','laoshiCGdiliuqidongaohui','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986370.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','791','0','0','0','0','0','0','1.0','132','132','1457671121','1457671121','0','0','老湿CGTV第六期 冬奥会','tudou','0','','187093187','','','','');
INSERT INTO `mac_vod` VALUES('707','老湿：2013电影盘点回顾','','laoshi2013dianyingpandianhuigu','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986330.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','752','0','0','0','0','0','0','9.0','3159','351','1457671121','1457671121','0','0','老湿：2013电影盘点回顾','tudou','0','','188309675','','','','');
INSERT INTO `mac_vod` VALUES('708','老湿：《进击的B》','','laoshijinjideB','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986280.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','403','0','0','0','0','0','0','7.0','35','5','1457671121','1457671121','0','0','老湿：《进击的TVB》','youku','0','','XMTI5MDEwNDQ0OA==','','','','');
INSERT INTO `mac_vod` VALUES('709','《不吐不快第二季》第五集','','butubukuaidierjidiwuji','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561986240.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','218','0','0','0','0','0','0','6.0','672','112','1457671121','1457671121','0','0','《不吐不快第二季》第五集','tudou','0','','188309675','','','','');
INSERT INTO `mac_vod` VALUES('710','老湿：山寨啪啪好莱坞','','laoshishanzhaipapahaolaiwu','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986200.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','888','0','0','0','0','0','0','6.0','294','49','1457671121','1457671121','0','0','老湿：山寨啪啪好莱坞','tudou','0','','188317218','','','','');
INSERT INTO `mac_vod` VALUES('711','老湿：女汉子之爸爸去哪了','','laoshinvhanzizhibabaqunaliao','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986150.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','573','0','0','0','0','0','0','5.0','885','177','1457671121','1457671121','0','0','老湿：女汉子之爸爸去哪了','56','0','','MTAzNDA3ODAz','','','','');
INSERT INTO `mac_vod` VALUES('712','盘点2013最烂太空电影','','pandian2013zuilantaikongdianying','P','','http://www.egao8.cc/upload/vod/2016-02-23/14561986110.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','152','0','0','0','0','0','0','9.0','4203','467','1457671121','1457671121','0','0','盘点2013最烂太空电影','ku6','0','','NPERyu8V3nN1W1BzNy7OUw..','','','','');
INSERT INTO `mac_vod` VALUES('713','老湿翻唱韩寒歌曲《追梦人》','','laoshifanchanghanhangequzhuimengren','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986070.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','473','0','0','0','0','0','0','6.0','744','124','1457671121','1457671121','0','0','老湿翻唱韩寒歌曲《追梦人》','56','0','','OTQ1OTYyNjU','','','','');
INSERT INTO `mac_vod` VALUES('714','老湿：咬死那对异性恋','','laoshiyaosinaduiyixinglian','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561986020.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','602','0','0','0','0','0','0','6.0','1278','213','1457671121','1457671121','0','0','老湿：咬死那对异性恋','56','0','','MTAwNzUxNzEx','','','','');
INSERT INTO `mac_vod` VALUES('715','老湿说唱电影《座头市》','','laoshishuochangdianyingzuotoushi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985980.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','74','0','0','0','0','0','0','5.0','1410','282','1457671121','1457671121','0','0','老湿说唱电影《座头市》','tudou','0','','218726787','','','','');
INSERT INTO `mac_vod` VALUES('716','老湿搜神记第三期：评《青铜狂魔》','','laoshisoushenjidisanqipingqingtongkuangmo','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985940.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','144','0','0','0','0','0','0','9.0','4401','489','1457671121','1457671121','0','0','老湿搜神记第三期：评《青铜狂魔》','tudou','0','','229119885','','','','');
INSERT INTO `mac_vod` VALUES('717','老湿说唱电影：黄飞鸿大战白莲教','','laoshishuochangdianyinghuangfeihongdazhanbailianjiao','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985900.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','33','0','0','0','0','0','0','3.0','681','227','1457671121','1457671121','0','0','老湿说唱电影：黄飞鸿大战白莲教','tudou','0','','213851219','','','','');
INSERT INTO `mac_vod` VALUES('718','老湿《搜神记》第二期：评飞天蜈蚣','','laoshisoushenjidierqipingfeitianwugong','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985860.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','811','0','0','0','0','0','0','4.0','956','239','1457671125','1457671125','0','0','老湿《搜神记》第二期：评飞天蜈蚣','tudou','0','','229038282','','','','');
INSERT INTO `mac_vod` VALUES('719','老湿：大王叫我年后播','','laoshidawangjiaowonianhoubo','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985810.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','611','0','0','0','0','0','0','3.0','291','97','1457671125','1457671125','0','0','老湿：大王叫我年后播','youku','0','','XNjY0OTEwNDc2','','','','');
INSERT INTO `mac_vod` VALUES('720','老湿吐槽《机械战警大百科》上','','laoshitucaojixiezhanjingdabaikeshang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985760.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','384','0','0','0','0','0','0','6.0','1686','281','1457671125','1457671125','0','0','老湿吐槽《机械战警大百科》上','tudou','0','','227673678','','','','');
INSERT INTO `mac_vod` VALUES('721','老湿评《平壤怪兽》','','laoshipingpingrangguaishou','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985720.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','351','0','0','0','0','0','0','7.0','1281','183','1457671125','1457671125','0','0','老湿评《平壤怪兽》','tudou','0','','184128423','','','','');
INSERT INTO `mac_vod` VALUES('722','老湿电影教学：相似体转场','','laoshidianyingjiaoxuexiangsitizhuanchang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985670.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','955','0','0','0','0','0','0','6.0','330','55','1457671125','1457671125','0','0','老湿电影教学：相似体转场','tudou','0','','226739739','','','','');
INSERT INTO `mac_vod` VALUES('723','不吐不快02 山寨啪啪好莱呜','','butubukuai02shanzhaipapahaolaiwu','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561985630.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','105','0','0','0','0','0','0','9.0','1215','135','1457671125','1457671125','0','0','不吐不快02 山寨啪啪好莱呜','56','0','','MTIyNTI2OTU3','','','','');
INSERT INTO `mac_vod` VALUES('724','老湿号外:超级女子武术大战','','laoshihaowaichaojinvziwushudazhan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985580.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','430','0','0','0','0','0','0','9.0','2403','267','1457671125','1457671125','0','0','老湿号外:超级女子武术大战','tudou','0','','225695707','','','','');
INSERT INTO `mac_vod` VALUES('725','老湿《约战》菊花哥魔兽PK','','laoshiyuezhanjuhuagemoshouPK','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985540.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','528','0','0','0','0','0','0','10.0','310','31','1457671125','1457671125','0','0','老湿《约战》菊花哥魔兽PK','youku','0','','XMzExNTg3OTU2','','','','');
INSERT INTO `mac_vod` VALUES('726','老湿GC:07麦迪时刻纪念解说版','','laoshiGC07maidishikejinianjieshuoban','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985500.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','216','0','0','0','0','0','0','1.0','367','367','1457671126','1457671126','0','0','老湿GCTV:07麦迪时刻纪念解说版','tudou','0','','217139793','','','','');
INSERT INTO `mac_vod` VALUES('727','八扇屏04:铁拳为争霸','','bashanping04tiequanweizhengba','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561985450.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','778','0','0','0','0','0','0','5.0','1000','200','1457671126','1457671126','0','0','八扇屏04:铁拳为争霸','tudou','0','','174297710','','','','');
INSERT INTO `mac_vod` VALUES('728','老湿吐槽 歪批停播水浒传','','laoshitucaowaipitingboshuihuchuan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985410.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','218','0','0','0','0','0','0','5.0','305','61','1457671126','1457671126','0','0','老湿吐槽 歪批停播水浒传','tudou','0','','189257730','','','','');
INSERT INTO `mac_vod` VALUES('729','老湿翻唱《离开》配老湿经典头像','','laoshifanchanglikaipeilaoshijingdiantouxiang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985370.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','510','0','0','0','0','0','0','4.0','876','219','1457671126','1457671126','0','0','老湿翻唱《离开》配老湿经典头像','56','0','','OTQ1OTY2MTA','','','','');
INSERT INTO `mac_vod` VALUES('730','不吐不快第二季第六集','','butubukuaidierjidiliuji','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561985320.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','844','0','0','0','0','0','0','9.0','2709','301','1457671126','1457671126','0','0','不吐不快第二季第六集','56','0','','MTE4OTI2Njg2','','','','');
INSERT INTO `mac_vod` VALUES('731','老湿八扇屏第三期《生涯多戎马》','','laoshibashanpingdisanqishengyaduorongma','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985280.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','881','0','0','0','0','0','0','2.0','834','417','1457671126','1457671126','0','0','老湿八扇屏第三期《生涯多戎马》','tudou','0','','173574368','','','','');
INSERT INTO `mac_vod` VALUES('732','八扇屏5:当年笑赢家','','bashanping5dangnianxiaoyingjia','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561985240.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','999','0','0','0','0','0','0','6.0','1734','289','1457671126','1457671126','0','0','八扇屏5:当年笑赢家','tudou','0','','175107658','','','','');
INSERT INTO `mac_vod` VALUES('733','老湿翻唱《最炫民族风》','','laoshifanchangzuixuanminzufeng','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985190.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','546','0','0','0','0','0','0','1.0','372','372','1457671126','1457671126','0','0','老湿翻唱《最炫民族风》','56','0','','OTQ1OTU4MzY','','','','');
INSERT INTO `mac_vod` VALUES('734','老湿歪评轩辕剑之天之痕','','laoshiwaipingxuanyuanjianzhitianzhihen','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985140.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','89','0','0','0','0','0','0','3.0','1440','480','1457671126','1457671126','0','0','老湿歪评轩辕剑之天之痕','youku','0','','XNDQxOTI2NTUy','','','','');
INSERT INTO `mac_vod` VALUES('735','《剑影人消煞》老湿八扇屏第二期','','jianyingrenxiaoshalaoshibashanpingdierqi','J','','http://www.egao8.cc/upload/vod/2016-02-23/14561985100.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','663','0','0','0','0','0','0','5.0','2060','412','1457671126','1457671126','0','0','《剑影人消煞》老湿八扇屏第二期','tudou','0','','172842908','','','','');
INSERT INTO `mac_vod` VALUES('736','老湿八扇屏第一期《最帅的独行侠》','','laoshibashanpingdiyiqizuishuaideduxingxia','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985060.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','22','0','0','0','0','0','0','5.0','380','76','1457671126','1457671126','0','0','老湿八扇屏第一期《最帅的独行侠》','tudou','0','','172053549','','','','');
INSERT INTO `mac_vod` VALUES('737','老湿自制小作品+MV','','laoshizizhixiaozuopinMV','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561985020.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','887','0','0','0','0','0','0','4.0','460','115','1457671126','1457671126','0','0','老湿自制小作品+MV','youku','0','','XMzQ4NDY0NzM2','','','','');
INSERT INTO `mac_vod` VALUES('738','老湿专访2013土豆映像节','','laoshizhuanfang2013tudouyingxiangjie','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984970.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','183','0','0','0','0','0','0','6.0','1488','248','1457671130','1457671130','0','0','老湿专访2013土豆映像节','tudou','0','','170299141','','','','');
INSERT INTO `mac_vod` VALUES('739','老湿专访《烂片无国界》获奖','','laoshizhuanfanglanpianwuguojiehuojiang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984930.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','505','0','0','0','0','0','0','3.0','864','288','1457671130','1457671130','0','0','老湿专访《烂片无国界》获奖','tudou','0','','170336125','','','','');
INSERT INTO `mac_vod` VALUES('740','老湿评好道具','','laoshipinghaodaoju','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984890.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','627','0','0','0','0','0','0','9.0','1737','193','1457671130','1457671130','0','0','老湿评好道具','sohu','0','','999859','','','','');
INSERT INTO `mac_vod` VALUES('741','老湿正说《鸿门宴》','','laoshizhengshuohongmenyan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984840.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','148','0','0','0','0','0','0','8.0','352','44','1457671130','1457671130','0','0','老湿正说《鸿门宴》','56','0','','ODU5NjU0NDU','','','','');
INSERT INTO `mac_vod` VALUES('742','老湿毁童年最终回','','laoshihuitongnianzuizhonghui','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984800.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','882','0','0','0','0','0','0','7.0','1953','279','1457671130','1457671130','0','0','老湿毁童年最终回','56','0','','OTIxODgxNjk','','','','');
INSERT INTO `mac_vod` VALUES('743','老湿甩葱歌','','laoshishuaicongge','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984760.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','116','0','0','0','0','0','0','1.0','322','322','1457671130','1457671130','0','0','老湿甩葱歌','youku','0','','XMzI1NDExMzM2','','','','');
INSERT INTO `mac_vod` VALUES('744','老湿评1999战记最终回','','laoshiping1999zhanjizuizhonghui','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984720.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','853','0','0','0','0','0','0','2.0','414','207','1457671130','1457671130','0','0','老湿评1999战记最终回','tudou','0','','165965124','','','','');
INSERT INTO `mac_vod` VALUES('745','老湿评中国好歌手','','laoshipingzhongguohaogeshou','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984680.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','67','0','0','0','0','0','0','3.0','603','201','1457671130','1457671130','0','0','老湿评中国好歌手','tudou','0','','165027065','','','','');
INSERT INTO `mac_vod` VALUES('746','老湿获金豆角奖','','laoshihuojindoujiaojiang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984630.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','948','0','0','0','0','0','0','2.0','862','431','1457671130','1457671130','0','0','老湿获金豆角奖','tudou','0','','142668163','','','','');
INSERT INTO `mac_vod` VALUES('747','老湿谈幸福','','laoshitanxingfu','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984590.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','156','0','0','0','0','0','0','10.0','80','8','1457671130','1457671130','0','0','老湿谈幸福','ku6','0','','_gDMxXmQd_R_79-E0STMJg..','','','','');
INSERT INTO `mac_vod` VALUES('748','老湿再批好声音','','laoshizaipihaoshengyin','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984550.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','71','0','0','0','0','0','0','10.0','1530','153','1457671130','1457671130','0','0','老湿再批好声音','ku6','0','','1fv2Nav4ND1CxT9GY5t0jQ..','','','','');
INSERT INTO `mac_vod` VALUES('749','老湿游车展','','laoshiyouchezhan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984510.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','41','0','0','0','0','0','0','2.0','644','322','1457671130','1457671130','0','0','老湿游车展','tudou','0','','159090950','','','','');
INSERT INTO `mac_vod` VALUES('750','老湿吐槽中国好声音','','laoshitucaozhongguohaoshengyin','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984460.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','630','0','0','0','0','0','0','3.0','987','329','1457671130','1457671130','0','0','老湿吐槽中国好声音','sohu','0','','953074','','','','');
INSERT INTO `mac_vod` VALUES('751','老湿批好切糕','','laoshipihaoqiegao','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984420.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','876','0','0','0','0','0','0','5.0','2355','471','1457671130','1457671130','0','0','老湿批好切糕','ku6','0','','3HSfGiGTaDebhg-zIDvDsw..','','','','');
INSERT INTO `mac_vod` VALUES('752','老湿谈楚汉硬伤传奇','','laoshitanchuhanyingshangchuanqi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984380.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','531','0','0','0','0','0','0','6.0','954','159','1457671130','1457671130','0','0','老湿谈楚汉硬伤传奇','56','0','','MTMxMjU0NTc2','','','','');
INSERT INTO `mac_vod` VALUES('753','老湿专访|56红人馆','','laoshizhuanfang56hongrenguan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984330.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','319','0','0','0','0','0','0','7.0','238','34','1457671130','1457671130','0','0','老湿专访|56红人馆','56','0','','Njc1MTc2OTE','','','','');
INSERT INTO `mac_vod` VALUES('754','《神》','','shen','S','','http://www.egao8.cc/upload/vod/2016-02-23/14561984290.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','181','0','0','0','0','0','0','4.0','392','98','1457671130','1457671130','0','0','《神》','tudou','0','','153508323','','','','');
INSERT INTO `mac_vod` VALUES('755','老湿露脸啦','','laoshilulianla','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984250.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','526','0','0','0','0','0','0','6.0','2022','337','1457671130','1457671130','0','0','老湿露脸啦','youku','0','','XNTAwMzM4NTQw','','','','');
INSERT INTO `mac_vod` VALUES('756','《走进李元芳》老湿不吐不快作品','','zoujinliyuanfanglaoshibutubukuaizuopin','Z','','http://www.egao8.cc/upload/vod/2016-02-23/14561984210.png','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','484','0','0','0','0','0','0','2.0','696','348','1457671130','1457671130','0','0','《走进李元芳》老湿不吐不快作品','56','0','','MTEyNTY1MzE5','','','','');
INSERT INTO `mac_vod` VALUES('757','《灾难与末日》','','zainanyumori','Z','','http://www.egao8.cc/upload/vod/2016-02-23/14561984160.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','152','0','0','0','0','0','0','1.0','460','460','1457671130','1457671130','0','0','《灾难与末日》','tudou','0','','160151545','','','','');
INSERT INTO `mac_vod` VALUES('758','老湿评步步惊心','','laoshipingbubujingxin','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984120.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','202','0','0','0','0','0','0','7.0','210','30','1457671135','1457671135','0','0','老湿评步步惊心','youku','0','','XMzExNDE3OTY4','','','','');
INSERT INTO `mac_vod` VALUES('759','老湿为腾讯9分钟电影大赛制作宣传片','','laoshiweitengxun9fenzhongdianyingdasaizhizuoxuanchuanpian','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984080.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','375','0','0','0','0','0','0','4.0','1236','309','1457671135','1457671135','0','0','老湿为腾讯9分钟电影大赛制作宣传片','youku','0','','XNDAyMjc1Nzg0','','','','');
INSERT INTO `mac_vod` VALUES('760','老湿R甩饼歌','','laoshiRshuaibingge','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561984030.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','537','0','0','0','0','0','0','4.0','184','46','1457671135','1457671135','0','0','老湿RAP版甩饼歌','youku','0','','XMzIxNDkzODQ4','','','','');
INSERT INTO `mac_vod` VALUES('761','老湿评中国大片','','laoshipingzhongguodapian','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983990.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','783','0','0','0','0','0','0','5.0','360','72','1457671135','1457671135','0','0','老湿评中国大片','youku','0','','XMjk5NjUwODYw','','','','');
INSERT INTO `mac_vod` VALUES('762','拳皇大战DNF','','quanhuangdazhanDNF','Q','','http://www.egao8.cc/upload/vod/2016-02-23/14561983950.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','432','0','0','0','0','0','0','2.0','154','77','1457671135','1457671135','0','0','拳皇大战DNF','youku','0','','XMzIzOTgxOTQ0','','','','');
INSERT INTO `mac_vod` VALUES('763','福利篇逗士の真爱','','fulipiandoushizhenai','F','','http://www.egao8.cc/upload/vod/2016-02-23/14561983900.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','267','0','0','0','0','0','0','3.0','699','233','1457671135','1457671135','0','0','福利篇逗士の真爱','56','0','','Njk3NDMwNjY','','','','');
INSERT INTO `mac_vod` VALUES('764','斯大林/关公大战外星人','','sidalinguangongdazhanwaixingren','S','','http://www.egao8.cc/upload/vod/2016-02-23/14561983860.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','794','0','0','0','0','0','0','6.0','1950','325','1457671135','1457671135','0','0','斯大林/关公大战外星人','youku','0','','XMzIxNDA0MTQ0','','','','');
INSERT INTO `mac_vod` VALUES('765','《鲁班你肿么了》老湿三分半','','lubannizhongmeliaolaoshisanfenban','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983820.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','484','0','0','0','0','0','0','8.0','2960','370','1457671135','1457671135','0','0','《鲁班你肿么了》老湿三分半','tudou','0','','172926970','','','','');
INSERT INTO `mac_vod` VALUES('766','老湿翻唱《宫：爱的供养》','','laoshifanchanggongaidegongyang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983780.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','29','0','0','0','0','0','0','1.0','245','245','1457671135','1457671135','0','0','老湿翻唱《宫：爱的供养》','youku','0','','XMzkwNjU1MzI0','','','','');
INSERT INTO `mac_vod` VALUES('767','老湿:乱谈《大足怪》','','laoshiluantandazuguai','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983740.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','589','0','0','0','0','0','0','4.0','1240','310','1457671135','1457671135','0','0','老湿:乱谈《大足怪》','youku','0','','XNjMzNTAwMzUy','','','','');
INSERT INTO `mac_vod` VALUES('768','2012欧洲杯十佳球','','2012ouzhoubeishijiaqiu','2','','http://www.egao8.cc/upload/vod/2016-02-23/14561983690.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','43','0','0','0','0','0','0','3.0','114','38','1457671135','1457671135','0','0','2012欧洲杯十佳球','youku','0','','XNDMwMTc4MTY0','','','','');
INSERT INTO `mac_vod` VALUES('769','老湿评抗日剧:抗日宝典杀必死','','laoshipingkangrijukangribaodianshabisi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983650.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','239','0','0','0','0','0','0','3.0','396','132','1457671135','1457671135','0','0','老湿评抗日剧:抗日宝典杀必死','tudou','0','','166940902','','','','');
INSERT INTO `mac_vod` VALUES('770','老湿献歌：活着就是希望','','laoshixiangehuozhoujiushixiwang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983610.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','243','0','0','0','0','0','0','7.0','1106','158','1457671135','1457671135','0','0','老湿献歌：活着就是希望','youku','0','','XNTQ3Mjk5MTg0','','','','');
INSERT INTO `mac_vod` VALUES('771','老湿批中国好衣服','','laoshipizhongguohaoyifu','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983560.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','590','0','0','0','0','0','0','10.0','1640','164','1457671135','1457671135','0','0','老湿批中国好衣服','56','0','','OTAzNzkyNDU','','','','');
INSERT INTO `mac_vod` VALUES('772','《换脸新娘》老湿三分半第一期','','huanlianxinnianglaoshisanfenbandiyiqi','H','','http://www.egao8.cc/upload/vod/2016-02-23/14561983520.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','534','0','0','0','0','0','0','7.0','2163','309','1457671135','1457671135','0','0','《换脸新娘》老湿三分半第一期','tudou','0','','165850523','','','','');
INSERT INTO `mac_vod` VALUES('773','老湿《再见2012》','','laoshizaijian2012','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983440.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','299','0','0','0','0','0','0','5.0','2420','484','1457671135','1457671135','0','0','老湿《再见2012》','youku','0','','XNDk1NjAxMzAw','','','','');
INSERT INTO `mac_vod` VALUES('774','圣了个诞','','shengliaogedan','S','','http://www.egao8.cc/upload/vod/2016-02-23/14561983400.gif','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','324','0','0','0','0','0','0','2.0','886','443','1457671135','1457671135','0','0','圣了个诞','youku','0','','XNTA4OTkwMDUy','','','','');
INSERT INTO `mac_vod` VALUES('775','老湿评《穆桂英挂帅》','','laoshipingmuguiyingguashuai','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983360.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','521','0','0','0','0','0','0','3.0','1263','421','1457671135','1457671135','0','0','老湿评《穆桂英挂帅》','youku','0','','XNDgxODM2OTcy','','','','');
INSERT INTO `mac_vod` VALUES('776','超越神的小游戏','','chaoyueshendexiaoyouxi','C','','http://www.egao8.cc/upload/vod/2016-02-23/14561983310.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','518','0','0','0','0','0','0','2.0','528','264','1457671135','1457671135','0','0','超越神的小游戏','tudou','0','','108865256','','','','');
INSERT INTO `mac_vod` VALUES('777','老湿《完爆一代宗师》','','laoshiwanbaoyidaizongshi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983270.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','913','0','0','0','0','0','0','5.0','255','51','1457671135','1457671135','0','0','老湿《完爆一代宗师》','56','0','','MTE0NDU0OTYx','','','','');
INSERT INTO `mac_vod` VALUES('778','老湿戏说周郎','','laoshixishuozhoulang','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983220.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','850','0','0','2','0','0','0','6.0','2178','363','1457671139','1457671139','1458477728','0','老湿戏说周郎','tudou','0','','163070912','','','','');
INSERT INTO `mac_vod` VALUES('779','吐槽《史前巨鳄3》','','tucaoshiqianjue3','T','','http://www.egao8.cc/upload/vod/2016-02-23/14561983180.png','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','355','0','0','0','0','0','0','7.0','1610','230','1457671139','1457671139','0','0','吐槽《史前巨鳄3》','youku','0','','XNDQ2MDg0MTY0','','','','');
INSERT INTO `mac_vod` VALUES('780','老湿批新还珠格格','','laoshipixinhuaizhugege','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983140.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','178','0','0','0','0','0','0','10.0','3460','346','1457671139','1457671139','0','0','老湿批新还珠格格','youku','0','','XMzM3NTk2NzEy','','','','');
INSERT INTO `mac_vod` VALUES('781','鬼才-司马','','guicaisima','G','','http://www.egao8.cc/upload/vod/2016-02-23/14561983090.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','790','0','0','0','0','0','0','5.0','1130','226','1457671139','1457671139','0','0','鬼才-司马','youku','0','','XMjg5ODU0NTA4','','','','');
INSERT INTO `mac_vod` VALUES('782','老湿评西游记，真的很蛋疼','','laoshipingxiyoujizhendehendanteng','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983050.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','882','0','0','0','0','0','0','2.0','498','249','1457671139','1457671139','0','0','老湿评西游记，真的很蛋疼','youku','0','','XMjg4OTk1NzA4','','','','');
INSERT INTO `mac_vod` VALUES('783','老湿特辑','','laoshiteji','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561983010.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','614','0','0','0','0','0','0','10.0','2760','276','1457671139','1457671139','0','0','老湿特辑','youku','0','','XNDAyMjY2OTAw','','','','');
INSERT INTO `mac_vod` VALUES('784','老湿评至暗之时','','laoshipingzhianzhishi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561982960.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','866','0','0','1','0','0','0','4.0','1108','277','1457671139','1457671139','1457870086','0','老湿评至暗之时','youku$$$tudou','0$$$0','$$$','XNDIzOTU0Mzcy$$$142461489','','','','');
INSERT INTO `mac_vod` VALUES('785','社会心态与文化发展的关系','','shehuixintaiyuwenhuafazhandeguanxi','S','','http://www.egao8.cc/upload/vod/2016-02-23/14561982920.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','483','0','0','0','0','0','0','2.0','914','457','1457671139','1457671139','0','0','社会心态与文化发展的关系','youku','0','','XMzMxNTk2NjUy','','','','');
INSERT INTO `mac_vod` VALUES('786','解说中国VS巴西激情大战','','jieshuozhongguoVSbaxijiqingdazhan','J','','http://www.egao8.cc/upload/vod/2016-02-23/14561982880.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','534','0','0','0','0','0','0','4.0','1528','382','1457671139','1457671139','0','0','解说中国VS巴西激情大战','youku','0','','XMzMzMzkwOTEy','','','','');
INSERT INTO `mac_vod` VALUES('787','亚锦赛十佳球','','yajinsaishijiaqiu','Y','','http://www.egao8.cc/upload/vod/2016-02-23/14561982830.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','553','0','0','0','0','0','0','7.0','693','99','1457671139','1457671139','0','0','亚锦赛十佳球','youku','0','','XMzMzNjI2OTcy','','','','');
INSERT INTO `mac_vod` VALUES('788','老湿评《夏侯传》','','laoshipingxiahouchuan','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561982790.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','794','0','0','0','0','0','0','6.0','1602','267','1457671139','1457671139','0','0','老湿评《夏侯传》','tudou','0','','123104968','','','','');
INSERT INTO `mac_vod` VALUES('789','《圣诞与剩蛋》','','shengdanyushengdan','S','','http://www.egao8.cc/upload/vod/2016-02-23/14561982750.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','480','0','0','0','0','0','0','6.0','1668','278','1457671139','1457671139','0','0','《圣诞与剩蛋》','youku','0','','XMzMzMjU4NjAw','','','','');
INSERT INTO `mac_vod` VALUES('790','小评国产三国影视与游戏','','xiaopingguochansanguoyingshiyuyouxi','X','','http://www.egao8.cc/upload/vod/2016-02-23/14561982710.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','53','0','0','0','0','0','0','6.0','2310','385','1457671139','1457671139','0','0','小评国产三国影视与游戏','youku','0','','XMzMxMTIyNDk2','','','','');
INSERT INTO `mac_vod` VALUES('791','老湿《一个世界》','','laoshiyigeshijie','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561982660.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','421','0','0','0','0','0','0','2.0','648','324','1457671139','1457671139','0','0','老湿《一个世界》','tudou','0','','120341737','','','','');
INSERT INTO `mac_vod` VALUES('792','新差不多先生','','xinchabuduoxiansheng','X','','http://www.egao8.cc/upload/vod/2016-02-23/14561982671.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','215','0','0','0','0','0','0','8.0','3520','440','1457671139','1457671139','0','0','新差不多先生','youku','0','','XMzMzMjU4NjYw','','','','');
INSERT INTO `mac_vod` VALUES('793','讲解影子传说','','jiangjieyingzichuanshuo','J','','http://www.egao8.cc/upload/vod/2016-02-23/14561982672.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','32','0','0','0','0','0','0','7.0','2198','314','1457671139','1457671139','0','0','讲解影子传说','youku','0','','XMzMwOTE0Mjg0','','','','');
INSERT INTO `mac_vod` VALUES('794','NFL年度十佳球','','NFLniandushijiaqiu','N','','http://www.egao8.cc/upload/vod/2016-02-23/14561982673.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','689','0','0','0','0','0','0','9.0','3465','385','1457671139','1457671139','0','0','NFL年度十佳球','tudou','0','','117163147','','','','');
INSERT INTO `mac_vod` VALUES('795','漫谈房价','','mantanfangjia','M','','http://www.egao8.cc/upload/vod/2016-02-23/14561982674.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','483','0','0','14','0','0','0','6.0','462','77','1457671139','1457671139','1458477805','0','漫谈房价','youku','0','','XMzMxNTk3Nzky','','','','');
INSERT INTO `mac_vod` VALUES('796','《后天朝时代》','','houtianchaoshidai','H','','http://www.egao8.cc/upload/vod/2016-02-23/14561982675.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','379','0','0','0','0','0','0','2.0','844','422','1457671139','1457671139','0','0','《后天朝时代》','youku','0','','XMzMwNjQ3MjY4','','','','');
INSERT INTO `mac_vod` VALUES('797','三国杀最风骚的内奸之袁绍','','sanguoshazuifengsaodenajianzhiyuanshao','S','','http://www.egao8.cc/upload/vod/2016-02-23/14561982676.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','389','0','0','0','0','0','0','10.0','1900','190','1457671139','1457671139','0','0','三国杀最风骚的内奸之袁绍','tudou','0','','90471550','','','','');
INSERT INTO `mac_vod` VALUES('798','打倒非主流等牛鬼蛇神','','dadaofeizhuliudengniuguisheshen','D','','http://www.egao8.cc/upload/vod/2016-02-23/14561982677.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','523','0','0','0','0','0','0','8.0','1792','224','1457671143','1457671143','0','0','打倒非主流等牛鬼蛇神','youku','0','','XMzMwMDcxNjEy','','','','');
INSERT INTO `mac_vod` VALUES('799','恨她就请她看宫锁心玉','','hentajiuqingtakangongsuoxinyu','H','','http://www.egao8.cc/upload/vod/2016-02-23/14561982678.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','632','0','0','0','0','0','0','5.0','1025','205','1457671143','1457671143','0','0','恨她就请她看宫锁心玉','tudou','0','','86645580','','','','');
INSERT INTO `mac_vod` VALUES('800','老湿小评国产三国影视与游戏','','laoshixiaopingguochansanguoyingshiyuyouxi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561982679.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','244','0','0','0','0','0','0','10.0','270','27','1457671143','1457671143','0','0','老湿小评国产三国影视与游戏','tudou','0','','111850974','','','','');
INSERT INTO `mac_vod` VALUES('801','老湿解说：走进科学牛头怪之死','','laoshijieshuozoujinkexueniutouguaizhisi','L','','http://www.egao8.cc/upload/vod/2016-02-23/145619826710.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','332','0','0','0','0','0','0','5.0','2290','458','1457671143','1457671143','0','0','老湿解说：走进科学牛头怪之死','tudou','0','','121732198','','','','');
INSERT INTO `mac_vod` VALUES('802','老湿评《影子传说》','','laoshipingyingzichuanshuo','L','','http://www.egao8.cc/upload/vod/2016-02-23/145619826711.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','88','0','0','0','0','0','0','8.0','1008','126','1457671143','1457671143','0','0','老湿评《影子传说》','tudou','0','','80356799','','','','');
INSERT INTO `mac_vod` VALUES('803','讲解菜花甜妈搞笑广告','','jiangjiecaihuatianmagaoxiaoguanggao','J','','http://www.egao8.cc/upload/vod/2016-02-23/145619826712.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','172','0','0','0','0','0','0','10.0','1410','141','1457671143','1457671143','0','0','讲解菜花甜妈搞笑广告','tudou','0','','103312750','','','','');
INSERT INTO `mac_vod` VALUES('804','老湿解说：圣诞与剩蛋','','laoshijieshuoshengdanyushengdan','L','','http://www.egao8.cc/upload/vod/2016-02-23/145619826713.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','962','0','0','0','0','0','0','3.0','672','224','1457671143','1457671143','0','0','老湿解说：圣诞与剩蛋','tudou','0','','78219517','','','','');
INSERT INTO `mac_vod` VALUES('805','老湿：惊到你蛋疼的棒国神作','','laoshijingdaonidantengdebangguoshenzuo','L','','http://www.egao8.cc/upload/vod/2016-02-23/145619826714.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','806','0','0','0','0','0','0','9.0','2970','330','1457671143','1457671143','0','0','老湿：惊到你蛋疼的棒国神作','tudou','0','','106028910','','','','');
INSERT INTO `mac_vod` VALUES('806','老湿成名作《老湿评西游记》','','laoshichengmingzuolaoshipingxiyouji','L','','http://www.egao8.cc/upload/vod/2016-02-23/145619826715.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','272','0','0','1','0','0','0','4.0','1096','274','1457671143','1457671143','1458393732','0','老湿成名作《老湿评西游记》','tudou','0','','92359277','','','','');
INSERT INTO `mac_vod` VALUES('807','老湿：社会心态与文化发展的关系','','laoshishehuixintaiyuwenhuafazhandeguanxi','L','','http://www.egao8.cc/upload/vod/2016-02-23/145619826716.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','392','0','0','0','0','0','0','9.0','3186','354','1457671143','1457671143','0','0','老湿：社会心态与文化发展的关系','tudou','0','','76022829','','','','');
INSERT INTO `mac_vod` VALUES('808','老湿评亚锦赛十佳球','','laoshipingyajinsaishijiaqiu','L','','http://www.egao8.cc/upload/vod/2016-02-23/145619826717.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','922','0','0','0','0','0','0','4.0','1916','479','1457671143','1457671143','0','0','老湿评亚锦赛十佳球','tudou','0','','104300150','','','','');
INSERT INTO `mac_vod` VALUES('809','老湿解说《后天朝时代》','','laoshijieshuohoutianchaoshidai','L','','http://www.egao8.cc/upload/vod/2016-02-23/145619826718.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','585','0','0','0','0','0','0','9.0','2628','292','1457671143','1457671143','0','0','老湿解说《后天朝时代》','tudou','0','','57038373','','','','');
INSERT INTO `mac_vod` VALUES('810','老湿第一部：超女大战国足一','','laoshidiyibuchaonvdazhanguozuyi','L','','http://www.egao8.cc/upload/vod/2016-02-23/145619826719.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','321','0','0','0','0','0','0','10.0','2930','293','1457671143','1457671143','0','0','老湿第一部：超女大战国足一','tudou','0','','46980746','','','','');
INSERT INTO `mac_vod` VALUES('811','大学生活启示录','','daxueshenghuoqishilu','D','','http://www.egao8.cc/upload/vod/2016-02-23/14561982711.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','541','0','0','0','0','0','0','5.0','2350','470','1457671143','1457671143','0','0','大学生活启示录','tudou','0','','48846012','','','','');
INSERT INTO `mac_vod` VALUES('812','《与时尚同居》','','yushishangtongji','Y','','http://www.egao8.cc/upload/vod/2016-02-23/14561982712.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','374','0','0','0','0','0','0','5.0','2090','418','1457671143','1457671143','0','0','《与时尚同居》','youku','0','','XMzEzMDU4Njk2','','','','');
INSERT INTO `mac_vod` VALUES('813','老湿第一期：逗士の真爱','','laoshidiyiqidoushizhenai','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561982713.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','918','0','0','0','0','0','0','8.0','3744','468','1457671143','1457671143','0','0','老湿第一期：逗士の真爱','56','0','','Njk3NDMwNjY','','','','');
INSERT INTO `mac_vod` VALUES('814','小评与时尚同居','','xiaopingyushishangtongji','X','','http://www.egao8.cc/upload/vod/2016-02-23/14561982714.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','488','0','0','0','0','0','0','7.0','2156','308','1457671143','1457671143','0','0','小评与时尚同居','youku','0','','XMzMyOTQzNTA4','','','','');
INSERT INTO `mac_vod` VALUES('815','《西游记》','','xiyouji','X','','http://www.egao8.cc/upload/vod/2016-02-23/14561982715.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','871','0','0','0','0','0','0','1.0','113','113','1457671143','1457671143','0','0','《西游记》','youku','0','','XMzMwOTIyNDY4','','','','');
INSERT INTO `mac_vod` VALUES('816','老湿小评国产动漫','','laoshixiaopingguochandongman','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561982716.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','569','0','0','0','0','0','0','8.0','1328','166','1457671143','1457671143','0','0','老湿小评国产动漫','tudou','0','','XMzIzMDgxNjYw','','','','');
INSERT INTO `mac_vod` VALUES('817','老湿评差不多先生','','laoshipingchabuduoxiansheng','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561982717.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','56','0','0','0','0','0','0','7.0','3388','484','1457671143','1457671143','0','0','老湿评差不多先生','tudou','0','','90897021','','','','');
INSERT INTO `mac_vod` VALUES('818','老湿解说足球：中国VS6星巴西','','laoshijieshuozuqiuzhongguoVS6xingbaxi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561982718.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','692','0','0','0','0','0','0','6.0','36','6','1457671147','1457671147','0','0','老湿解说足球：中国VS6星巴西','tudou','0','','90118982','','','','');
INSERT INTO `mac_vod` VALUES('819','藐视高丽棒子的历史','','miaoshigaolibangzidelishi','M','','http://www.egao8.cc/upload/vod/2016-02-23/14561982719.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','947','0','0','0','0','0','0','3.0','1446','482','1457671147','1457671147','0','0','藐视高丽棒子的历史','tudou','0','','48302150','','','','');
INSERT INTO `mac_vod` VALUES('820','伤心太平洋之2010杯具大全','','shangxintaipingyangzhi2010beijudaquan','S','','http://www.egao8.cc/upload/vod/2016-02-23/145619827110.jpg','','','老湿','','','','大陆','','0','8','','','0','0','0','0','0','0','0','0','534','0','0','0','0','0','0','2.0','676','338','1457671147','1457671147','0','0','伤心太平洋之2010杯具大全','tudou','0','','58459559','','','','');
INSERT INTO `mac_vod` VALUES('821','智能手环到底有多智能','','zhinenshouhuandaodiyouduozhinen','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462753216.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','23','0','0','0','0','0','0','8.0','3560','445','1457671163','1457671163','0','0','智能手环到底有多智能','youku','0','','XNzU4ODc2MDI4','','','','');
INSERT INTO `mac_vod` VALUES('822','如何确定你的性倾向','','ruhequedingnidexingqingxiang','R','','http://www.egao8.cc/upload/vod/2015-10-12/144462755912.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','630','0','0','0','0','0','0','9.0','3681','409','1457671163','1457671163','0','0','如何确定你的性倾向','youku','0','','XNzU4MzM2Mjgw','','','','');
INSERT INTO `mac_vod` VALUES('823','一分钟教你应对女友犀利问题','','yifenzhongjiaoniyingduinvyouxiliwenti','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446277661.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','757','0','0','1','0','0','0','7.0','2429','347','1457671163','1457671163','1458478501','0','一分钟教你应对女友犀利问题','youku','0','','XNzA2MDg3Njgw','','','','');
INSERT INTO `mac_vod` VALUES('824','一分钟教你缓解眼疲劳','','yifenzhongjiaonihuanjieyanpilao','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446278049.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','249','0','0','0','0','0','0','9.0','4185','465','1457671163','1457671163','0','0','一分钟教你缓解眼疲劳','youku','0','','XNjk5ODI0MDgw','','','','');
INSERT INTO `mac_vod` VALUES('825','一分钟教你了解24节气','','yifenzhongjiaoniliaojie24jieqi','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462780711.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','174','0','0','0','0','0','0','5.0','1635','327','1457671163','1457671163','0','0','一分钟教你了解24节气','youku','0','','XNzAxNTgyNzI4','','','','');
INSERT INTO `mac_vod` VALUES('826','一分钟教你痔疮来了怎么坐','','yifenzhongjiaonizhichuanglailiaozenmezuo','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462797811.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','69','0','0','0','0','0','0','2.0','964','482','1457671163','1457671163','0','0','一分钟教你痔疮来了怎么坐','youku','0','','XNjkwNjMzNjAw','','','','');
INSERT INTO `mac_vod` VALUES('827','一分钟教你远离湿疹','','yifenzhongjiaoniyuanlishizhen','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462798214.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','185','0','0','0','0','0','0','4.0','348','87','1457671163','1457671163','0','0','一分钟教你远离湿疹','youku','0','','XNjkzMjc2MDYw','','','','');
INSERT INTO `mac_vod` VALUES('828','涨姿势教你如何通马桶','','zhangzishijiaoniruhetongmatong','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446285559.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','746','0','0','0','0','0','0','8.0','288','36','1457671163','1457671163','0','0','涨姿势教你如何通马桶','youku','0','','XNjUwNDY1NTAw','','','','');
INSERT INTO `mac_vod` VALUES('829','一分钟让你了解比特币','','yifenzhongrangniliaojiebitebi','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462855812.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','193','0','0','0','0','0','0','2.0','162','81','1457671163','1457671163','0','0','一分钟让你了解比特币','youku','0','','XNjQ5OTczODI0','','','','');
INSERT INTO `mac_vod` VALUES('830','一分钟让你了解公务员','','yifenzhongrangniliaojiegongwuyuan','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446285731.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','437','0','0','0','0','0','0','2.0','914','457','1457671163','1457671163','0','0','一分钟让你了解公务员','youku','0','','160839652','','','','');
INSERT INTO `mac_vod` VALUES('831','自强不吸另类解说雾霾','','ziqiangbuxilingleijieshuowumai','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446285815.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','106','0','0','0','0','0','0','1.0','11','11','1457671163','1457671163','0','0','自强不吸另类解说雾霾','youku','0','','161405901','','','','');
INSERT INTO `mac_vod` VALUES('832','一分钟教你提醒朋友还钱','','yifenzhongjiaonitixingpengyouhuaiqian','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446285859.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','798','0','0','0','0','0','0','4.0','1288','322','1457671163','1457671163','0','0','一分钟教你提醒朋友还钱','youku','0','','160726722','','','','');
INSERT INTO `mac_vod` VALUES('833','大话品牌 遇到捷达男你就嫁了吧','','dahuapinpaiyudaojiedanannijiujialiaoba','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462859613.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','329','0','0','0','0','0','0','10.0','3300','330','1457671163','1457671163','0','0','大话品牌 遇到捷达男你就嫁了吧','youku','0','','156258140','','','','');
INSERT INTO `mac_vod` VALUES('834','一分钟教你如何升职加薪迎娶白富美','','yifenzhongjiaoniruheshengzhijiaxinyingqubaifumei','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462860017.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','985','0','0','0','0','0','0','1.0','459','459','1457671163','1457671163','0','0','一分钟教你如何升职加薪迎娶白富美','youku','0','','160030762','','','','');
INSERT INTO `mac_vod` VALUES('835','一分钟教你快速退烧','','yifenzhongjiaonikuaisutuishao','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462860119.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','769','0','0','0','0','0','0','1.0','243','243','1457671163','1457671163','0','0','一分钟教你快速退烧','youku','0','','XNjQ2NjI3MTU2','','','','');
INSERT INTO `mac_vod` VALUES('836','你中枪了吗？要钱也要脸','','nizhongqiangliaomayaoqianyeyaolian','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446286104.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','655','0','0','0','0','0','0','2.0','896','448','1457671163','1457671163','0','0','你中枪了吗？要钱也要脸','youku','0','','152629977','','','','');
INSERT INTO `mac_vod` VALUES('837','一分钟教你终止暧昧','','yifenzhongjiaonizhongzhiaimei','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446286169.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','832','0','0','0','0','0','0','2.0','402','201','1457671163','1457671163','0','0','一分钟教你终止暧昧','youku','0','','160171181','','','','');
INSERT INTO `mac_vod` VALUES('838','飞碟说我待二环如初恋','','feidieshuowodaierhuanruchulian','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462862013.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','963','0','0','0','0','0','0','2.0','228','114','1457671163','1457671163','0','0','飞碟说我待二环如初恋','youku','0','','140728207','','','','');
INSERT INTO `mac_vod` VALUES('839','一分钟教你甩掉麻烦女友','','yifenzhongjiaonishuaidiaomafannvyou','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462862317.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','425','0','0','0','0','0','0','5.0','2040','408','1457671163','1457671163','0','0','一分钟教你甩掉麻烦女友','youku','0','','161733014','','','','');
INSERT INTO `mac_vod` VALUES('840','你准备何时忘记雅安?','','nizhunbeiheshiwangjiyaan','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446286362.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','566','0','0','0','0','0','0','3.0','114','38','1457671163','1457671163','0','0','你准备何时忘记雅安?','youku','0','','137152072','','','','');
INSERT INTO `mac_vod` VALUES('841','冬天里快速起床N种奇葩方式','','dongtianlikuaisuqichuangNzhongqipafangshi','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446283487.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','953','0','0','0','0','0','0','10.0','3180','318','1457671428','1457671428','0','0','冬天里快速起床N种奇葩方式','youku','0','','XNjY0NjYwMzA4','','','','');
INSERT INTO `mac_vod` VALUES('842','教你在聚会上逃避买单','','jiaonizaijuhuishangtaobimaidan','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462835514.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','620','0','0','0','0','0','0','8.0','376','47','1457671428','1457671428','0','0','教你在聚会上逃避买单','youku','0','','XNjY3MzA0Njk2','','','','');
INSERT INTO `mac_vod` VALUES('843','升职加薪赢取白富美有绝招','','shengzhijiaxinyingqubaifumeiyoujuezhao','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462835817.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','322','0','0','0','0','0','0','8.0','1064','133','1457671428','1457671428','0','0','升职加薪赢取白富美有绝招','youku','0','','XNjYxNzg1MTU2','','','','');
INSERT INTO `mac_vod` VALUES('844','避免撞衫撞胸的N中奇葩方式','','bimianzhuangshanzhuangxiongdeNzhongqipafangshi','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446283682.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','782','0','0','0','0','0','0','10.0','2180','218','1457671428','1457671428','0','0','避免撞衫撞胸的N中奇葩方式','youku','0','','XNjU4MzU1ODk2','','','','');
INSERT INTO `mac_vod` VALUES('845','涨姿势一分钟让你了解乙肝疫苗','','zhangzishiyifenzhongrangniliaojieyiganyimiao','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446283726.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','940','0','0','0','0','0','0','7.0','2142','306','1457671428','1457671428','0','0','涨姿势一分钟让你了解乙肝疫苗','youku','0','','XNjYwOTA4OTcy','','','','');
INSERT INTO `mac_vod` VALUES('846','教美女练出性感翘臀','','jiaomeinvlianchuxingganqiaotun','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446283748.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','207','0','0','0','0','0','0','2.0','762','381','1457671428','1457671428','0','0','教美女练出性感翘臀','youku','0','','XNjY0NjYwMzA4','','','','');
INSERT INTO `mac_vod` VALUES('847','说多了都是泪2013十大人艰不拆','','shuoduoliaodushilei2013shidarenjianbuchai','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462837812.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','712','0','0','0','0','0','0','1.0','40','40','1457671428','1457671428','0','0','说多了都是泪2013十大人艰不拆','youku','0','','XNjU2NjMwNDA0','','','','');
INSERT INTO `mac_vod` VALUES('848','考试中作弊的N种奇葩方式','','kaoshizhongzuobideNzhongqipafangshi','K','','http://www.egao8.cc/upload/vod/2015-10-12/144462837913.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','553','0','0','0','0','0','0','5.0','565','113','1457671428','1457671428','0','0','考试中作弊的N种奇葩方式','youku','0','','XNjU3OTA4OTUy','','','','');
INSERT INTO `mac_vod` VALUES('849','如何帮男友选择合适的安全套','','ruhebangnanyouxuanzeheshideanquantao','R','','http://www.egao8.cc/upload/vod/2015-10-12/144462838217.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','45','0','0','0','0','0','0','6.0','1740','290','1457671428','1457671428','0','0','如何帮男友选择合适的安全套','youku','0','','XNjYyMjA0OTgw','','','','');
INSERT INTO `mac_vod` VALUES('850','2013十大金曲盘点','','2013shidajinqupandian','2','','http://www.egao8.cc/upload/vod/2015-10-12/14446283956.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','974','0','0','0','0','0','0','4.0','972','243','1457671428','1457671428','0','0','2013十大金曲盘点','youku','0','','163164457','','','','');
INSERT INTO `mac_vod` VALUES('851','教你伪装成高端影迷','','jiaoniweizhuangchenggaoduanyingmi','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446283978.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','844','0','0','0','0','0','0','6.0','1542','257','1457671429','1457671429','0','0','教你伪装成高端影迷','youku','0','','XNjU5MjcxNDQw','','','','');
INSERT INTO `mac_vod` VALUES('852','说多都是泪！中国地铁历险记','','shuoduodushileizhongguoditielixianji','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462840112.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','128','0','0','0','0','0','0','1.0','348','348','1457671429','1457671429','0','0','说多都是泪！中国地铁历险记','youku','0','','XNjc4MjAzMzIw','','','','');
INSERT INTO `mac_vod` VALUES('853','咱妇女自己的AV','','zaifunvzijideAV','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462840416.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','517','0','0','0','0','0','0','9.0','3555','395','1457671429','1457671429','0','0','咱妇女自己的AV','youku','0','','XNjgxMjc3MjEy','','','','');
INSERT INTO `mac_vod` VALUES('854','怎样成为优秀女司机','','zenyangchengweiyouxiunvsiji','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446284141.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','171','0','0','0','0','0','0','9.0','2313','257','1457671429','1457671429','0','0','怎样成为优秀女司机','youku','0','','XNjU2NjI4MzY4','','','','');
INSERT INTO `mac_vod` VALUES('855','教你给女友挑选内衣','','jiaonigeinvyoutaoxuannayi','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446284185.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','969','0','0','0','0','0','0','7.0','2849','407','1457671429','1457671429','0','0','教你给女友挑选内衣','youku','0','','XNjgxNzc4ODky','','','','');
INSERT INTO `mac_vod` VALUES('856','涨姿势教你鉴别隆胸假奶','','zhangzishijiaonijianbielongxiongjianai','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462853214.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','758','0','0','0','0','0','0','10.0','480','48','1457671429','1457671429','0','0','涨姿势教你鉴别隆胸假奶','youku','0','','162392858','','','','');
INSERT INTO `mac_vod` VALUES('857','一分钟教你延长做爱时间','','yifenzhongjiaoniyanchangzuoaishijian','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462853417.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','606','0','0','0','0','0','0','9.0','2214','246','1457671429','1457671429','0','0','一分钟教你延长做爱时间','youku','0','','163044648','','','','');
INSERT INTO `mac_vod` VALUES('858','一分钟教你掌握2013年贺岁档','','yifenzhongjiaonizhangwo2013nianhesuidang','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446285463.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','47','0','0','0','0','0','0','9.0','441','49','1457671429','1457671429','0','0','一分钟教你掌握2013年贺岁档','youku','0','','XNjQ3NDY4MjUy','','','','');
INSERT INTO `mac_vod` VALUES('859','讨好丈母娘迎娶白富美的N种绝招','','taohaozhangmuniangyingqubaifumeideNzhongjuezhao','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446285536.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','335','0','0','0','0','0','0','6.0','696','116','1457671429','1457671429','0','0','讨好丈母娘迎娶白富美的N种绝招','youku','0','','162941104','','','','');
INSERT INTO `mac_vod` VALUES('860','震惊！女友最容易出轨的职业','','zhenjingnvyouzuirongyichuguidezhiye','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462856215.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','693','0','0','0','0','0','0','5.0','1690','338','1457671429','1457671429','0','0','震惊！女友最容易出轨的职业','youku','0','','162304804','','','','');
INSERT INTO `mac_vod` VALUES('861','节操尽碎全球男人时间报告','','jiecaojinsuiquanqiunanrenshijianbaogao','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462826519.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','428','0','0','0','0','0','0','3.0','240','80','1457671438','1457671438','0','0','节操尽碎全球男人时间报告','youku','0','','XNjcyODEwMDcy','','','','');
INSERT INTO `mac_vod` VALUES('862','一分钟教你应对半秃尴尬','','yifenzhongjiaoniyingduibantuganga','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446282711.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','422','0','0','0','0','0','0','1.0','273','273','1457671438','1457671438','0','0','一分钟教你应对半秃尴尬','youku','0','','XNjg3MDU4OTYw','','','','');
INSERT INTO `mac_vod` VALUES('863','说多了都是泪中国海归受难记','','shuoduoliaodushileizhongguohaiguishounanji','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446282732.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','837','0','0','0','0','0','0','6.0','660','110','1457671438','1457671438','0','0','说多了都是泪中国海归受难记','youku','0','','XNjc1MjYxNjgw','','','','');
INSERT INTO `mac_vod` VALUES('864','说多了都是泪医院现形记','','shuoduoliaodushileiyiyuanxianxingji','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446282777.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','303','0','0','0','0','0','0','1.0','437','437','1457671438','1457671438','0','0','说多了都是泪医院现形记','youku','0','','XNjg0NDY3NjA0','','','','');
INSERT INTO `mac_vod` VALUES('865','一秒钟波霸速成攻略','','yimiaozhongbobasuchenggonglue','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462828111.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','417','0','0','0','0','0','0','2.0','670','335','1457671438','1457671438','0','0','一秒钟波霸速成攻略','youku','0','','XNjg0NDI1OTE2','','','','');
INSERT INTO `mac_vod` VALUES('866','女神教男友戒烟的N种奇葩方法','','nvshenjiaonanyoujieyandeNzhongqipafangfa','N','','http://www.egao8.cc/upload/vod/2015-10-12/144462828314.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','995','0','0','0','0','0','0','6.0','1446','241','1457671438','1457671438','0','0','女神教男友戒烟的N种奇葩方法','youku','0','','XNjg2MTQyMTEy','','','','');
INSERT INTO `mac_vod` VALUES('867','RAP说唱如何巧妙拒绝饮酒','','RAPshuochangruheqiaomiaojujueyinjiu','R','','http://www.egao8.cc/upload/vod/2015-10-12/144462828517.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','323','0','0','0','0','0','0','7.0','574','82','1457671438','1457671438','0','0','RAP说唱如何巧妙拒绝饮酒','youku','0','','XNjgzOTcwNzMy','','','','');
INSERT INTO `mac_vod` VALUES('868','消除恼人便秘的奇葩方法','','xiaochunaorenbianmideqipafangfa','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446282931.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','404','0','0','0','0','0','0','8.0','3104','388','1457671438','1457671438','0','0','消除恼人便秘的奇葩方法','youku','0','','XNjg0ODYxMjgw','','','','');
INSERT INTO `mac_vod` VALUES('869','科普教你如何科学应对火灾','','kepujiaoniruhekexueyingduihuozai','K','','http://www.egao8.cc/upload/vod/2015-10-12/14446282953.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','211','0','0','0','0','0','0','1.0','429','429','1457671438','1457671438','0','0','科普教你如何科学应对火灾','youku','0','','XNjgzNTA2NjA0','','','','');
INSERT INTO `mac_vod` VALUES('870','教你应对职场性骚扰','','jiaoniyingduizhichangxingsaorao','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446283019.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','936','0','0','0','0','0','0','5.0','1655','331','1457671438','1457671438','0','0','教你应对职场性骚扰','youku','0','','XNjgzMDU0MjA0','','','','');
INSERT INTO `mac_vod` VALUES('871','告诉你古人为何竖着写字','','gaosunigurenweiheshuzhouxiezi','G','','http://www.egao8.cc/upload/vod/2015-10-12/144462830312.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','238','0','0','0','0','0','0','10.0','2050','205','1457671438','1457671438','0','0','告诉你古人为何竖着写字','youku','0','','XNjgwNDU2NDY4','','','','');
INSERT INTO `mac_vod` VALUES('872','预防老年痴呆我有妙招','','yufanglaonianchidaiwoyoumiaozhao','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462830615.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','497','0','0','0','0','0','0','10.0','2730','273','1457671438','1457671438','0','0','预防老年痴呆我有妙招','youku','0','','XNjc3ODQzMDUy','','','','');
INSERT INTO `mac_vod` VALUES('873','教你报复前男友','','jiaonibaofuqiannanyou','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446283171.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','60','0','0','0','0','0','0','4.0','1952','488','1457671438','1457671438','0','0','教你报复前男友','youku','0','','XNjc5OTk4MTU2','','','','');
INSERT INTO `mac_vod` VALUES('874','女神教你4招结束糟糕相亲','','nvshenjiaoni4zhaojieshuzaogaoxiangqin','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446283204.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','494','0','0','0','0','0','0','10.0','1670','167','1457671438','1457671438','0','0','女神教你4招结束糟糕相亲','youku','0','','XNjc0ODIyNzEy','','','','');
INSERT INTO `mac_vod` VALUES('875','女神教你如何应对前前前醉鬼男友','','nvshenjiaoniruheyingduiqianqianqianzuiguinanyou','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446283237.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','833','0','0','0','0','0','0','8.0','848','106','1457671438','1457671438','0','0','女神教你如何应对前前前醉鬼男友','youku','0','','XNjc3NDAyMTk2','','','','');
INSERT INTO `mac_vod` VALUES('876','正确与理发师沟通','','zhengqueyulifashigoutong','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462832711.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','832','0','0','0','0','0','0','9.0','1944','216','1457671438','1457671438','0','0','正确与理发师沟通','youku','0','','XNjc1Mjc4NTg0','','','','');
INSERT INTO `mac_vod` VALUES('877','一分钟让你了解处女膜','','yifenzhongrangniliaojiechunvmo','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462833315.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','214','0','0','0','0','0','0','3.0','411','137','1457671438','1457671438','0','0','一分钟让你了解处女膜','youku','0','','XNjc2OTY1MDk2','','','','');
INSERT INTO `mac_vod` VALUES('878','一分钟跑掉合唱贺新年','','yifenzhongpaodiaohechanghexinnian','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462833518.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','919','0','0','0','0','0','0','4.0','1492','373','1457671438','1457671438','0','0','一分钟跑掉合唱贺新年','youku','0','','XNjY3NjI3ODE2','','','','');
INSERT INTO `mac_vod` VALUES('879','练出八块腹肌的N种奇葩方法','','lianchubakuaifujideNzhongqipafangfa','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446283453.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','358','0','0','0','0','0','0','3.0','1230','410','1457671438','1457671438','0','0','练出八块腹肌的N种奇葩方法','youku','0','','XNjczOTQ5NTAw','','','','');
INSERT INTO `mac_vod` VALUES('880','教你给女朋友挑选卫生巾','','jiaonigeinvpengyoutaoxuanweishengjin','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462835110.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','660','0','0','0','0','0','0','9.0','3078','342','1457671438','1457671438','0','0','教你给女朋友挑选卫生巾','youku','0','','XNjU4ODM1MjMy','','','','');
INSERT INTO `mac_vod` VALUES('881','教你正确解决鱼刺卡喉','','jiaonizhengquejiejueyucikahou','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446281445.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','562','0','0','0','0','0','0','7.0','3276','468','1457671452','1457671452','0','0','教你正确解决鱼刺卡喉','youku','0','','XNjkwMTgxNjE2','','','','');
INSERT INTO `mac_vod` VALUES('882','一把泪计划生育伤害史','','yibaleijihuashengyushanghaishi','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446281456.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','853','0','0','0','0','0','0','5.0','1215','243','1457671452','1457671452','0','0','一把泪计划生育伤害史','youku','0','','161764566','','','','');
INSERT INTO `mac_vod` VALUES('883','苍老师是世界的，钓鱼岛是我们的！','','canglaoshishishijiedediaoyudaoshiwomende','C','','http://www.egao8.cc/upload/vod/2015-10-12/144462815011.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','194','0','0','0','0','0','0','5.0','40','8','1457671452','1457671452','0','0','苍老师是世界的，钓鱼岛是我们的！','youku','0','','124630766','','','','');
INSERT INTO `mac_vod` VALUES('884','技术活教你正确掏耳屎','','jishuhuojiaonizhengquetaoershi','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462815314.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','183','0','0','0','0','0','0','9.0','3078','342','1457671452','1457671452','0','0','技术活教你正确掏耳屎','youku','0','','XNjg5NzA1MTM2','','','','');
INSERT INTO `mac_vod` VALUES('885','一分钟让你了解女性的排卵期','','yifenzhongrangniliaojienvxingdepailuanqi','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462815819.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','636','0','0','0','0','0','0','7.0','1309','187','1457671452','1457671452','0','0','一分钟让你了解女性的排卵期','youku','0','','XNjg3OTg5NDc2','','','','');
INSERT INTO `mac_vod` VALUES('886','神曲贱舞贺新春那些毁童年的卡通记忆','','shenqujianwuhexinchunnaxiehuitongniandekatongjiyi','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446281684.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','839','0','0','0','0','0','0','2.0','928','464','1457671452','1457671452','0','0','神曲贱舞贺新春那些毁童年的卡通记忆','youku','0','','127412774','','','','');
INSERT INTO `mac_vod` VALUES('887','如何成为AV男优骚年行动吧','','ruhechengweiAVnanyousaonianxingdongba','R','','http://www.egao8.cc/upload/vod/2015-10-12/14446281739.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','795','0','0','0','0','0','0','6.0','1254','209','1457671452','1457671452','0','0','如何成为AV男优骚年行动吧','youku','0','','130062622','','','','');
INSERT INTO `mac_vod` VALUES('888','面对恶劣环境生化危机《降魔篇》','','mianduieliehuanjingshenghuaweijijiangmopian','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462817914.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','477','0','0','0','0','0','0','3.0','561','187','1457671452','1457671452','0','0','面对恶劣环境生化危机《降魔篇》','youku','0','','132497195','','','','');
INSERT INTO `mac_vod` VALUES('889','飞碟说降骗十八招','','feidieshuojiangpianshibazhao','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462818418.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','77','0','0','0','0','0','0','1.0','26','26','1457671452','1457671452','0','0','飞碟说降骗十八招','youku','0','','133444031','','','','');
INSERT INTO `mac_vod` VALUES('890','飞碟说儿童防拐须知','','feidieshuoertongfangguaixuzhi','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446281975.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','254','0','0','0','0','0','0','10.0','3380','338','1457671452','1457671452','0','0','飞碟说儿童防拐须知','youku','0','','138538963','','','','');
INSERT INTO `mac_vod` VALUES('891','拉翔的科学研究','','laxiangdekexueyanjiu','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446282019.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','388','0','0','0','0','0','0','3.0','1029','343','1457671452','1457671452','0','0','拉翔的科学研究','youku','0','','143277104','','','','');
INSERT INTO `mac_vod` VALUES('892','飞碟说长的好看才有青春','','feidieshuochangdehaokancaiyouqingchun','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462820813.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','826','0','0','0','0','0','0','1.0','496','496','1457671452','1457671452','0','0','飞碟说长的好看才有青春','youku','0','','144341244','','','','');
INSERT INTO `mac_vod` VALUES('893','中国特色的竞技体育','','zhongguotesedejingjitiyu','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462821016.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','134','0','0','0','0','0','0','1.0','112','112','1457671452','1457671452','0','0','中国特色的竞技体育','youku','0','','145785722','','','','');
INSERT INTO `mac_vod` VALUES('894','飞碟解说4B青年欢乐多：就是要黑老罗！','','feidiejieshuo4Bqingnianhuanleduojiushiyaoheilaoluo','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446282232.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','349','0','0','0','0','0','0','3.0','1467','489','1457671452','1457671452','0','0','飞碟解说4B青年欢乐多：就是要黑老罗！','youku','0','','145348065','','','','');
INSERT INTO `mac_vod` VALUES('895','屌丝不能承受的房价之重','','sibunenchengshoudefangjiazhizhong','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446282276.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','223','0','0','0','0','0','0','7.0','252','36','1457671452','1457671452','0','0','屌丝不能承受的房价之重','youku','0','','XNjM0MzIyNTI0','','','','');
INSERT INTO `mac_vod` VALUES('896','手机党这都是病吶','','shoujidangzhedushibing','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462823110.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','479','0','0','0','0','0','0','5.0','1975','395','1457671452','1457671452','0','0','手机党这都是病吶','youku','0','','148280465','','','','');
INSERT INTO `mac_vod` VALUES('897','涨姿势中国女人罩杯报告','','zhangzishizhongguonvrenzhaobeibaogao','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462823514.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','59','0','0','0','0','0','0','10.0','680','68','1457671452','1457671452','0','0','涨姿势中国女人罩杯报告','youku','0','','160166396','','','','');
INSERT INTO `mac_vod` VALUES('898','武林高手的自我修养','','wulingaoshoudeziwoxiuyang','W','','http://www.egao8.cc/upload/vod/2015-10-12/144462823817.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','373','0','0','0','0','0','0','3.0','126','42','1457671452','1457671452','0','0','武林高手的自我修养','youku','0','','151277355','','','','');
INSERT INTO `mac_vod` VALUES('899','跪舔求包养2013十大土豪','','guitianqiubaoyang2013shidatuhao','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446282493.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','550','0','0','0','0','0','0','2.0','826','413','1457671452','1457671452','0','0','跪舔求包养2013十大土豪','youku','0','','162644587','','','','');
INSERT INTO `mac_vod` VALUES('900','想牛B就看装逼进化史','','xiangniuBjiukanzhuangbijinhuashi','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446282537.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','688','0','0','0','0','0','0','7.0','63','9','1457671452','1457671452','0','0','想牛B就看装逼进化史','youku','0','','160943055','','','','');
INSERT INTO `mac_vod` VALUES('901','大姨妈的前世今生','','dayimadeqianshijinsheng','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462801419.gif','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','102','0','0','0','0','0','0','1.0','21','21','1457671462','1457671462','0','0','大姨妈的前世今生','youku','0','','XNjg3NTQ1MzMy','','','','');
INSERT INTO `mac_vod` VALUES('902','中国特色的嫖宿幼女罪','','zhongguotesedepiaosuyounvzui','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446280234.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','578','0','0','0','0','0','0','3.0','369','123','1457671462','1457671462','0','0','中国特色的嫖宿幼女罪','youku','0','','139381499','','','','');
INSERT INTO `mac_vod` VALUES('903','青年屁的春运漂流','','qingnianpidechunyunpiaoliu','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446280309.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','622','0','0','2','0','0','0','9.0','882','98','1457671462','1457671462','1458432178','0','青年屁的春运漂流','youku','0','','126207325','','','','');
INSERT INTO `mac_vod` VALUES('904','飞碟说如何杀死禽流病毒','','feidieshuoruheshasiqinliubingdu','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462803514.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','700','0','0','0','0','0','0','10.0','4630','463','1457671462','1457671462','0','0','飞碟说如何杀死禽流病毒','youku','0','','135264696','','','','');
INSERT INTO `mac_vod` VALUES('905','“剩斗士”再不相亲就软了','','shengdoushizaibuxiangqinjiuruanliao','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462804419.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','511','0','0','0','0','0','0','6.0','570','95','1457671462','1457671462','0','0','“剩斗士”再不相亲就软了','youku','0','','134478687','','','','');
INSERT INTO `mac_vod` VALUES('906','一口气毁掉小清新','','yikouqihuidiaoxiaoqingxin','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446280543.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','212','0','0','0','0','0','0','4.0','1424','356','1457671462','1457671462','0','0','一口气毁掉小清新','youku','0','','152952975','','','','');
INSERT INTO `mac_vod` VALUES('907','飞碟说全球男人长度报告','','feidieshuoquanqiunanrenchangdubaogao','F','','http://www.egao8.cc/upload/vod/2015-10-12/14446280597.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','682','0','0','0','0','0','0','2.0','432','216','1457671462','1457671462','0','0','飞碟说全球男人长度报告','youku','0','','144468026#143951269','','','','');
INSERT INTO `mac_vod` VALUES('908','飞碟说出租车司机的爱恨情仇','','feidieshuochuzuchesijideaihenqingchou','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462806210.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','768','0','0','0','0','0','0','6.0','2286','381','1457671462','1457671462','0','0','飞碟说出租车司机的爱恨情仇','youku','0','','140281826','','','','');
INSERT INTO `mac_vod` VALUES('909','足尖上的中国趣味科普中国舞蹈进化史','','zujianshangdezhongguoquweikepuzhongguowudaojinhuashi','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462806613.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','538','0','0','0','0','0','0','7.0','2905','415','1457671462','1457671462','0','0','足尖上的中国趣味科普中国舞蹈进化史','youku','0','','154946518','','','','');
INSERT INTO `mac_vod` VALUES('910','飞碟说人在胖天在看','','feidieshuorenzaipangtianzaikan','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462807017.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','526','0','0','0','0','0','0','1.0','366','366','1457671462','1457671462','0','0','飞碟说人在胖天在看','youku','0','','141061554','','','','');
INSERT INTO `mac_vod` VALUES('911','高端黑世界进入特权时代','','gaoduanheishijiejinrutequanshidai','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446280852.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','986','0','0','0','0','0','0','3.0','1182','394','1457671462','1457671462','0','0','高端黑世界进入特权时代','youku','0','','155596845','','','','');
INSERT INTO `mac_vod` VALUES('912','人情买卖：份子钱你随了吗','','renqingmaimaifenziqiannisuiliaoma','R','','http://www.egao8.cc/upload/vod/2015-10-12/14446280865.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','140','0','0','0','0','0','0','8.0','3120','390','1457671462','1457671462','0','0','人情买卖：份子钱你随了吗','youku','0','','146808695','','','','');
INSERT INTO `mac_vod` VALUES('913','添乱多过行善如何成为超级英雄','','tianluanduoguoxingshanruhechengweichaojiyingxiong','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462809210.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','431','0','0','0','0','0','0','7.0','742','106','1457671462','1457671462','0','0','添乱多过行善如何成为超级英雄','youku','0','','157098373','','','','');
INSERT INTO `mac_vod` VALUES('914','飞碟说你的城管我的城','','feidieshuonidechengguanwodecheng','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462809514.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','769','0','0','0','0','0','0','4.0','1116','279','1457671462','1457671462','0','0','飞碟说你的城管我的城','youku','0','','141914407','','','','');
INSERT INTO `mac_vod` VALUES('915','无节操解说女性自慰器简史','','wujiecaojieshuonvxingziweiqijianshi','W','','http://www.egao8.cc/upload/vod/2015-10-12/144462810417.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','782','0','0','0','0','0','0','3.0','765','255','1457671462','1457671462','0','0','无节操解说女性自慰器简史','youku','0','','147526858','','','','');
INSERT INTO `mac_vod` VALUES('916','没有娘炮就没有女汉子','','meiyouniangpaojiumeiyounvhanzi','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462810719.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','67','0','0','0','0','0','0','9.0','1017','113','1457671462','1457671462','0','0','没有娘炮就没有女汉子','youku','0','','156477240','','','','');
INSERT INTO `mac_vod` VALUES('917','你不知道的靖国神社','','nibuzhidaodejingguoshenshe','N','','http://www.egao8.cc/upload/vod/2015-10-12/14446281165.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','442','0','0','0','0','0','0','9.0','2637','293','1457671462','1457671462','0','0','你不知道的靖国神社','youku','0','','148999635','','','','');
INSERT INTO `mac_vod` VALUES('918','科普中国电视机进化史','','kepuzhongguodianshijijinhuashi','K','','http://www.egao8.cc/upload/vod/2015-10-12/14446281188.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','192','0','0','0','0','0','0','7.0','1533','219','1457671462','1457671462','0','0','科普中国电视机进化史','youku','0','','159373306','','','','');
INSERT INTO `mac_vod` VALUES('919','镀金时代的导演梦','','dujinshidaidedaoyanmeng','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462812111.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','320','0','0','0','0','0','0','7.0','2968','424','1457671462','1457671462','0','0','镀金时代的导演梦','youku','0','','XNjE0MDEzODQw','','','','');
INSERT INTO `mac_vod` VALUES('920','一分钟教你用嘴爱','','yifenzhongjiaoniyongzuiai','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462813218.jpg','','','老湿','','','','大陆','','0','14','','','0','0','0','0','0','0','0','0','799','0','0','0','0','0','0','10.0','1760','176','1457671462','1457671462','0','0','一分钟教你用嘴爱','youku','0','','XNjkxMDYzNTA0','','','','');
INSERT INTO `mac_vod` VALUES('921','小夏恶搞配音最新作品  最新作品','','xiaoxiaegaopeiyinzuixinzuopinzuixinzuopin','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446264599.png','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','922','0','0','0','0','0','0','10.0','10','1','1457671485','1457671485','0','0','小夏恶搞配音最新作品  最新作品','youku','0','','XMTI3ODA2MDQ3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('922','最后的城镇  最后的城镇','','zuihoudechengzhenzuihoudechengzhen','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462646816.png','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','461','0','0','0','0','0','0','10.0','760','76','1457671485','1457671485','0','0','最后的城镇  最后的城镇','youku','0','','XMTMxNTA3MDQwOA==','','','','');
INSERT INTO `mac_vod` VALUES('923','[奇趣视界]萌萝莉被粑粑偷了鼻子欢呼干得漂亮！—专辑：《萝莉正太合辑，卖萌到底哪家强？》','','qiqushijiemengluolibeibabatouliaobizihuanhugandepiaoliangzhuanjiluolizhengtaihejimaimengdaodinajiaqiang','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446264771.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','62','0','0','0','0','0','0','8.0','1920','240','1457671485','1457671485','0','0','【奇趣视界】萌萝莉被粑粑偷了鼻子欢呼干得漂亮！—专辑：《萝莉正太合辑，卖萌到底哪家强？》','youku','0','','XODgxMjM0MTEy','','','','');
INSERT INTO `mac_vod` VALUES('924','日防夜防 小三难防_  日防夜防','','rifangyefangxiaosannanfangrifangyefang','R','','http://www.egao8.cc/upload/vod/2015-10-12/14446264825.png','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','229','0','0','0','0','0','0','1.0','277','277','1457671485','1457671485','0','0','日防夜防 小三难防_  日防夜防','youku','0','','XMTI2Mzc5NDY5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('925','优酷牛人小夏即兴配音谈作品背后','','youkuniurenxiaoxiajixingpeiyintanzuopinbeihou','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446264858.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','435','0','0','0','0','0','0','8.0','1640','205','1457671485','1457671485','0','0','优酷牛人小夏即兴配音谈作品背后','youku','0','','88311842','','','','');
INSERT INTO `mac_vod` VALUES('926','使命召唤ol 试录无配音 短剑战术团队  试录无配音 短剑战术团队','','shimingzhaohuanolshiluwupeiyinduanjianzhanshutuanduishiluwupeiyinduanjianzhanshutuandui','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462649012.png','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','370','0','0','0','0','0','0','10.0','4000','400','1457671485','1457671485','0','0','使命召唤ol 试录无配音 短剑战术团队  试录无配音 短剑战术团队','youku','0','','XMTI4NTQ4OTk0OA==','','','','');
INSERT INTO `mac_vod` VALUES('927','小夏恶搞配音最新作品  《高了个考》','','xiaoxiaegaopeiyinzuixinzuopingaoliaogekao','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462649616.png','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','196','0','0','0','0','0','0','5.0','1115','223','1457671485','1457671485','0','0','小夏恶搞配音最新作品  《高了个考》','youku','0','','XMTI2MDc4NjQwMA==','','','','');
INSERT INTO `mac_vod` VALUES('928','小样的冰雪奇缘配音  小样的冰雪奇缘配音','','xiaoyangdebingxueqiyuanpeiyinxiaoyangdebingxueqiyuanpeiyin','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446265071.png','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','791','0','0','0','0','0','0','9.0','1314','146','1457671485','1457671485','0','0','小样的冰雪奇缘配音  小样的冰雪奇缘配音','youku','0','','XMTI4MTIwMDE3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('929','大年初一到初七都有哪些习俗？  分分钟涨姿势新年篇—专辑：《[分分钟涨姿势]姿势就是力量》','','danianchuyidaochuqiduyounaxiexisufenfenzhongzhangzishixinnianpianzhuanjifenfenzhongzhangzishizishijiushililiang','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446265206.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','2','0','0','0','0','0','0','9.0','3366','374','1457671485','1457671485','0','0','大年初一到初七都有哪些习俗？  分分钟涨姿势新年篇—专辑：《【分分钟涨姿势】姿势就是力量》','youku','0','','XODk0NDUyMDE2','','','','');
INSERT INTO `mac_vod` VALUES('930','恶搞分裂配音春节回家难不难','','egaofenliepeiyinchunjiehuijiananbunan','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462652310.gif','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','897','0','0','0','0','0','0','6.0','2820','470','1457671485','1457671485','0','0','恶搞分裂配音春节回家难不难','youku','0','','XMzQ0OTQyNDYw','','','','');
INSERT INTO `mac_vod` VALUES('931','配音秀：真情表白  真情表白','','peiyinxiuzhenqingbiaobaizhenqingbiaobai','P','','http://www.egao8.cc/upload/vod/2015-10-12/144462652714.png','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','10','0','0','0','0','0','0','6.0','2904','484','1457671485','1457671485','0','0','配音秀：真情表白  真情表白','youku','0','','XMTI3NzI3MTc0OA==','','','','');
INSERT INTO `mac_vod` VALUES('932','小夏恶搞配音：《钱哪，钱！》','','xiaoxiaegaopeiyinqiannaqian','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462652916.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','595','0','0','0','0','0','0','4.0','296','74','1457671486','1457671486','0','0','小夏恶搞配音：《钱哪，钱！》','youku','0','','XMzQ5Njc1MDY0','','','','');
INSERT INTO `mac_vod` VALUES('933','《高了个考》小夏搞笑恶搞配音最新作品  小夏搞笑恶搞','','gaoliaogekaoxiaoxiagaoxiaoegaopeiyinzuixinzuopinxiaoxiagaoxiaoegao','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446265412.png','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','875','0','0','0','0','0','0','6.0','792','132','1457671486','1457671486','0','0','《高了个考》小夏搞笑恶搞配音最新作品  小夏搞笑恶搞','youku','0','','XMTI3Mzk2MDM3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('934','怀旧小夏配音春节内点事儿','','huaijiuxiaoxiapeiyinchunjienadianshier','H','','http://www.egao8.cc/upload/vod/2015-10-12/14446265497.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','291','0','0','0','0','0','0','1.0','411','411','1457671486','1457671486','0','0','怀旧小夏配音春节内点事儿','youku','0','','XMzQ2NDY1MzUy','','','','');
INSERT INTO `mac_vod` VALUES('935','哎哟爱哟之单身篇七夕快乐','','aiyoaiyozhidanshenpianqixikuaile','A','','http://www.egao8.cc/upload/vod/2015-10-12/144462655611.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','753','0','0','0','0','0','0','5.0','730','146','1457671486','1457671486','0','0','哎哟爱哟之单身篇七夕快乐','youku','0','','XNDM5OTE5ODg4','','','','');
INSERT INTO `mac_vod` VALUES('936','小夏恶搞配音 高了个考','','xiaoxiaegaopeiyingaoliaogekao','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462655915.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','891','0','0','0','0','0','0','10.0','1850','185','1457671486','1457671486','0','0','小夏恶搞配音 高了个考','youku','0','','96074657','','','','');
INSERT INTO `mac_vod` VALUES('937','小夏重磅回归新减[zhe]肥[teng]时代','','xiaoxiazhongbanghuiguixinjianzhefeitengshidai','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462656319.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','302','0','0','0','0','0','0','2.0','210','105','1457671486','1457671486','0','0','小夏重磅回归新减（zhe）肥（teng）时代','youku','0','','XNjcyODI4ODI0','','','','');
INSERT INTO `mac_vod` VALUES('938','恶搞配音甑嬛传版非诚勿扰','','egaopeiyinzengchuanbanfeichengwurao','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446265744.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','802','0','0','0','0','0','0','8.0','2784','348','1457671486','1457671486','0','0','恶搞配音甑嬛传版非诚勿扰','youku','0','','109979972','','','','');
INSERT INTO `mac_vod` VALUES('939','小夏新作：哎哟爱哟之父母篇','','xiaoxiaxinzuoaiyoaiyozhifumupian','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446265787.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','676','0','0','0','0','0','0','3.0','1008','336','1457671486','1457671486','0','0','小夏新作：哎哟爱哟之父母篇','youku','0','','138437486','','','','');
INSERT INTO `mac_vod` VALUES('940','小夏恶搞配音：日防夜防 小三难防','','xiaoxiaegaopeiyinrifangyefangxiaosannanfang','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462658513.jpg','','','老湿','','','','大陆','','0','6','','','0','0','0','0','0','0','0','0','930','0','0','1','0','0','0','8.0','832','104','1457671486','1457671486','1458478028','0','小夏恶搞配音：日防夜防 小三难防','youku','0','','115090416','','','','');
INSERT INTO `mac_vod` VALUES('941','天津妞犀利吐槽那些娘炮','','tianjinniuxilitucaonaxieniangpao','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446258071.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','533','0','0','0','0','0','0','8.0','3344','418','1457671507','1457671507','0','0','天津妞犀利吐槽那些娘炮','youku','0','','XNzIzNDkyMTQ4','','','','');
INSERT INTO `mac_vod` VALUES('942','天津妞犀利吐槽白衣校花与大长腿','','tianjinniuxilitucaobaiyixiaohuayudachangtui','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462587418.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','680','0','0','0','0','0','0','9.0','3654','406','1457671507','1457671507','0','0','天津妞犀利吐槽白衣校花与大长腿','youku','0','','XNzQ2OTU2Mjc2','','','','');
INSERT INTO `mac_vod` VALUES('943','天津妞犀利吐槽我为什么不做代购','','tianjinniuxilitucaowoweishimebuzuodaigou','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446258856.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','29','0','0','0','0','0','0','3.0','537','179','1457671507','1457671507','0','0','天津妞犀利吐槽我为什么不做代购','youku','0','','XNzM5MjMzODMy','','','','');
INSERT INTO `mac_vod` VALUES('944','天津妞犀利吐槽那些坑爹的专业','','tianjinniuxilitucaonaxiekangdiedezhuanye','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462591913.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','960','0','0','0','0','0','0','2.0','914','457','1457671507','1457671507','0','0','天津妞犀利吐槽那些坑爹的专业','youku','0','','XNzM0ODg2MzUy','','','','');
INSERT INTO `mac_vod` VALUES('945','天津妞犀利解说中国式英雄','','tianjinniuxilijieshuozhongguoshiyingxiong','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446259342.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','820','0','0','0','0','0','0','8.0','1568','196','1457671507','1457671507','0','0','天津妞犀利解说中国式英雄','youku','0','','XNzIwNzQwNTg4','','','','');
INSERT INTO `mac_vod` VALUES('946','天津妞吐槽那些狗血的选秀节目','','tianjinniutucaonaxiegouxuedexuanxiujiemu','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446259642.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','175','0','0','0','0','0','0','6.0','1260','210','1457671507','1457671507','0','0','天津妞吐槽那些狗血的选秀节目','youku','0','','XNjMxMDI1ODcy','','','','');
INSERT INTO `mac_vod` VALUES('947','天津妞犀利吐槽丑到爆的校服','','tianjinniuxilitucaochoudaobaodexiaofu','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462597512.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','62','0','0','0','0','0','0','8.0','2392','299','1457671507','1457671507','0','0','天津妞犀利吐槽丑到爆的校服','youku','0','','XNjkxMzI3NTYw','','','','');
INSERT INTO `mac_vod` VALUES('948','张无忌暑假打工挣学费','','zhangwujishujiadagongzhengxuefei','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462608913.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','233','0','0','0','0','0','0','3.0','1107','369','1457671507','1457671507','0','0','张无忌暑假打工挣学费','youku','0','','XNDMzNTM4NTAw','','','','');
INSERT INTO `mac_vod` VALUES('949','天津妞犀利吐槽舌尖上的中国2','','tianjinniuxilitucaoshejianshangdezhongguo2','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462614010.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','411','0','0','0','0','0','0','3.0','192','64','1457671507','1457671507','0','0','天津妞犀利吐槽舌尖上的中国2','youku','0','','XNzE3NTQwMTcy','','','','');
INSERT INTO `mac_vod` VALUES('950','天津妞犀利吐槽曾经想火的明星','','tianjinniuxilitucaozengjingxianghuodemingxing','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462615514.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','538','0','0','0','0','0','0','2.0','772','386','1457671507','1457671507','0','0','天津妞犀利吐槽曾经想火的明星','youku','0','','XNzEwNzQ2ODY0','','','','');
INSERT INTO `mac_vod` VALUES('951','谁夺走了我的初夜','','shuiduozouliaowodechuye','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446262864.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','24','0','0','0','0','0','0','10.0','3210','321','1457671507','1457671507','0','0','谁夺走了我的初夜','youku$$$tudou','0$$$0','$$$','133570473$$$165694590','','','','');
INSERT INTO `mac_vod` VALUES('952','刘邦潘石屹谈环境治理','','liubangpanshiyitanhuanjingzhili','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462629612.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','998','0','0','0','0','0','0','5.0','2320','464','1457671507','1457671507','0','0','刘邦潘石屹谈环境治理','youku','0','','XNTAzMjc3NDI4','','','','');
INSERT INTO `mac_vod` VALUES('953','2012年流行语大盘点','','2012nianliuxingyudapandian','2','','http://www.egao8.cc/upload/vod/2015-10-12/14446263142.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','557','0','0','0','0','0','0','7.0','1029','147','1457671507','1457671507','0','0','2012年流行语大盘点','youku','0','','XNDgzNzEwMTgw','','','','');
INSERT INTO `mac_vod` VALUES('954','姚晨教你怎样找老公','','yaochenjiaonizenyangzhaolaogong','Y','','http://www.egao8.cc/upload/vod/2015-10-12/144462633518.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','18','0','0','0','0','0','0','10.0','570','57','1457671507','1457671507','0','0','姚晨教你怎样找老公','youku','0','','XNDc4MTM0Njg4','','','','');
INSERT INTO `mac_vod` VALUES('955','幸福的像花儿一样','','xingfudexianghuaeryiyang','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446263533.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','166','0','0','0','0','0','0','1.0','370','370','1457671507','1457671507','0','0','幸福的像花儿一样','youku','0','','XNDU5OTU3Njcy','','','','');
INSERT INTO `mac_vod` VALUES('956','恶搞张无忌版《韩寒大战方舟子》','','egaozhangwujibanhanhandazhanfangzhouzi','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462640612.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','505','0','0','0','0','0','0','9.0','3312','368','1457671507','1457671507','0','0','恶搞张无忌版《韩寒大战方舟子》','youku','0','','87085618','','','','');
INSERT INTO `mac_vod` VALUES('957','恶搞2012春晚司文痞子年度巨献','','egao2012chunwansiwenpiziniandujuxian','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462641419.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','507','0','0','0','0','0','0','2.0','138','69','1457671507','1457671507','0','0','恶搞2012春晚司文痞子年度巨献','youku','0','','84388638','','','','');
INSERT INTO `mac_vod` VALUES('958','我爸是李刚。经典搞笑歌曲','','wobashiligangjingdiangaoxiaogequ','W','','http://www.egao8.cc/upload/vod/2015-10-12/14446264212.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','865','0','0','0','0','0','0','1.0','350','350','1457671507','1457671507','0','0','我爸是李刚。经典搞笑歌曲','youku','0','','55002788','','','','');
INSERT INTO `mac_vod` VALUES('959','令人蛋疼的画壁VS老湿伤不起的国产大片','','lingrendantengdehuabiVSlaoshishangbuqideguochandapian','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446264245.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','737','0','0','0','0','0','0','5.0','360','72','1457671507','1457671507','0','0','令人蛋疼的画壁VS老湿伤不起的国产大片','youku','0','','79736321','','','','');
INSERT INTO `mac_vod` VALUES('960','黄梅戏痛批合肥最狠官二代毁容事件','','huangmeixitongpihefeizuihenguanerdaihuirongshijian','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462642910.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','4','0','0','0','0','0','0','9.0','1854','206','1457671507','1457671507','0','0','黄梅戏痛批合肥最狠官二代毁容事件','youku','0','','89325432','','','','');
INSERT INTO `mac_vod` VALUES('961','天津妞犀利吐槽那些坑爹的口水歌','','tianjinniuxilitucaonaxiekangdiedekoushuige','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446261099.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','512','0','0','0','0','0','0','10.0','4570','457','1457671517','1457671517','0','0','天津妞犀利吐槽那些坑爹的口水歌','youku','0','','145102987','','','','');
INSERT INTO `mac_vod` VALUES('962','最难就业季 述说应届毕业生之痛','','zuinanjiuyejishushuoyingjiebiyeshengzhitong','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446262308.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','329','0','0','0','0','0','0','9.0','3501','389','1457671517','1457671517','0','0','最难就业季 述说应届毕业生之痛','youku','0','','141567551','','','','');
INSERT INTO `mac_vod` VALUES('963','重口味！辣评中学艳照门','','zhongkouweilapingzhongxueyanzhaomen','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462623812.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','988','0','0','0','0','0','0','3.0','153','51','1457671517','1457671517','0','0','重口味！辣评中学艳照门','youku','0','','141178888','','','','');
INSERT INTO `mac_vod` VALUES('964','戒烟之歌 好兄弟今天一起戒烟吧','','jieyanzhigehaoxiongdijintianyiqijieyanba','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462624215.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','745','0','0','0','0','0','0','6.0','612','102','1457671517','1457671517','0','0','戒烟之歌 好兄弟今天一起戒烟吧','youku','0','','XNTY0MDUwMjA0','','','','');
INSERT INTO `mac_vod` VALUES('965','犀利解说约炮神器如果寂寞你就摇一摇','','xilijieshuoyuepaoshenqiruguojimonijiuyaoyiyao','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446262531.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','822','0','0','0','0','0','0','4.0','1736','434','1457671517','1457671517','0','0','犀利解说约炮神器如果寂寞你就摇一摇','youku','0','','139774618','','','','');
INSERT INTO `mac_vod` VALUES('966','保时捷的诱惑 都市残酷爱情短剧','','baoshijiedeyouhuodushicankuaiqingduanju','B','','http://www.egao8.cc/upload/vod/2015-10-12/14446262584.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','660','0','0','0','0','0','0','6.0','1788','298','1457671518','1457671518','0','0','保时捷的诱惑 都市残酷爱情短剧','youku','0','','134989394','','','','');
INSERT INTO `mac_vod` VALUES('967','犀利解说于正被打真相','','xilijieshuoyuzhengbeidazhenxiang','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462626914.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','169','0','0','0','0','0','0','8.0','3464','433','1457671518','1457671518','0','0','犀利解说于正被打真相','youku','0','','134077049','','','','');
INSERT INTO `mac_vod` VALUES('968','逆袭之歌《顺其自然》恶搞董洁王大治','','nixizhigeshunqiziranegaodongjiewangdazhi','N','','http://www.egao8.cc/upload/vod/2015-10-12/144462627115.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','979','0','0','0','0','0','0','4.0','728','182','1457671518','1457671518','0','0','逆袭之歌《顺其自然》恶搞董洁王大治','youku','0','','134724724','','','','');
INSERT INTO `mac_vod` VALUES('969','大神留几手现身，众人求虐求点评','','dashenliujishouxianshenzhongrenqiunuenueqiudianping','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462627216.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','687','0','0','0','0','0','0','6.0','756','126','1457671518','1457671518','0','0','大神留几手现身，众人求虐求点评','youku','0','','131227289','','','','');
INSERT INTO `mac_vod` VALUES('970','星爷消极比赛被取消比赛资格','','xingyexiaojibisaibeiquxiaobisaizige','X','','http://www.egao8.cc/upload/vod/2015-10-12/14446262918.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','109','0','0','0','0','0','0','5.0','1020','204','1457671518','1457671518','0','0','星爷消极比赛被取消比赛资格','youku','0','','108985561','','','','');
INSERT INTO `mac_vod` VALUES('971','尔康穿越与紫薇上演人鬼情未了','','erkangchuanyueyuziweishangyanrenguiqingweiliao','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462630217.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','530','0','0','0','0','0','0','3.0','1023','341','1457671518','1457671518','0','0','尔康穿越与紫薇上演人鬼情未了','youku','0','','75589445','','','','');
INSERT INTO `mac_vod` VALUES('972','恶搞还珠格格 做人流的女子伤不起','','egaohuaizhugegezuorenliudenvzishangbuqi','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446263186.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','955','0','0','0','0','0','0','4.0','280','70','1457671518','1457671518','0','0','恶搞还珠格格 做人流的女子伤不起','youku','0','','72296335','','','','');
INSERT INTO `mac_vod` VALUES('973','神曲甩尽2012年大事','','shenqushuaijin2012niandashi','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462632210.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','356','0','0','0','0','0','0','10.0','1580','158','1457671518','1457671518','0','0','神曲甩尽2012年大事','youku','0','','124931166','','','','');
INSERT INTO `mac_vod` VALUES('974','2012世界末日逃生必备宝典','','2012shijiemoritaoshengbibeibaodian','2','','http://www.egao8.cc/upload/vod/2015-10-12/144462632814.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','924','0','0','0','0','0','0','8.0','1848','231','1457671518','1457671518','0','0','2012世界末日逃生必备宝典','youku','0','','121854070','','','','');
INSERT INTO `mac_vod` VALUES('975','元芳你怎么看神逻辑雷倒众生','','yuanfangnizenmekanshenluojileidaozhongsheng','Y','','http://www.egao8.cc/upload/vod/2015-10-12/14446263618.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','320','0','0','0','0','0','0','10.0','4020','402','1457671518','1457671518','0','0','元芳你怎么看神逻辑雷倒众生','youku','0','','116429440','','','','');
INSERT INTO `mac_vod` VALUES('976','生存必备宝典<甩毒歌>','','shengcunbibeibaodianshuaiduge','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462637114.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','923','0','0','0','0','0','0','9.0','3528','392','1457671518','1457671518','0','0','生存必备宝典','youku','0','','97132785','','','','');
INSERT INTO `mac_vod` VALUES('977','恶搞周董霆锋“逆战”的真相','','egaozhoudongtingfengnizhandezhenxiang','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446263891.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','118','0','0','38','0','0','0','6.0','924','154','1457671518','1457671518','1458432634','0','恶搞周董霆锋“逆战”的真相','youku','0','','95900905','','','','');
INSERT INTO `mac_vod` VALUES('978','帝都暴雨呼吁人性管理','','didubaoyuhuyurenxingguanli','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446263913.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','357','0','0','0','0','0','0','7.0','28','4','1457671518','1457671518','0','0','帝都暴雨呼吁人性管理','youku','0','','107849565','','','','');
INSERT INTO `mac_vod` VALUES('979','恶搞周星星戏评<杜甫很忙>','','egaozhouxingxingxipingdufuhenmang','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446263977.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','790','0','0','0','0','0','0','2.0','482','241','1457671518','1457671518','0','0','恶搞周星星戏评','youku','0','','93625740','','','','');
INSERT INTO `mac_vod` VALUES('980','恶搞甄子丹赵文卓对骂内幕都是油价上涨惹的祸','','egaozhenzidanzhaowenzhuoduimanamudushiyoujiashangzhangruodehuo','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462641116.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','133','0','0','0','0','0','0','3.0','816','272','1457671518','1457671518','0','0','恶搞甄子丹赵文卓对骂内幕都是油价上涨惹的祸','youku','0','','92291721','','','','');
INSERT INTO `mac_vod` VALUES('981','2013年的9月13 吐槽王菲汪峰离婚','','2013niande9yue13tucaowangfeiwangfenglihun','2','','http://www.egao8.cc/upload/vod/2015-10-12/144462604017.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','821','0','0','0','0','0','0','4.0','404','101','1457671530','1457671530','0','0','2013年的9月13 吐槽王菲汪峰离婚','youku','0','','XNjA5MTUwNDY4','','','','');
INSERT INTO `mac_vod` VALUES('982','东北妞犀利解说高价月饼那些事儿','','dongbeiniuxilijieshuogaojiayuebingnaxieshier','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462609418.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','45','0','0','0','0','0','0','2.0','624','312','1457671530','1457671530','0','0','东北妞犀利解说高价月饼那些事儿','youku','0','','152572489','','','','');
INSERT INTO `mac_vod` VALUES('983','东北妞犀利吐槽小时代是闹哪样','','dongbeiniuxilitucaoxiaoshidaishinaonayang','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446261043.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','851','0','0','0','0','0','0','5.0','140','28','1457671530','1457671530','0','0','东北妞犀利吐槽小时代是闹哪样','youku','0','','145451696','','','','');
INSERT INTO `mac_vod` VALUES('984','张无忌的不伦恋','','zhangwujidebulunlian','Z','','http://www.egao8.cc/upload/vod/2015-10-12/14446261065.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','585','0','0','0','0','0','0','5.0','1020','204','1457671530','1457671530','0','0','张无忌的不伦恋','youku','0','','105613691#XNTY4NDIwOTU2#142105276#108384625','','','','');
INSERT INTO `mac_vod` VALUES('985','2012年大事件盘点《太刺激2012》','','2012niandashijianpandiantaiciji2012','2','','http://www.egao8.cc/upload/vod/2015-10-12/144462611413.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','816','0','0','0','0','0','0','7.0','1092','156','1457671530','1457671530','0','0','2012年大事件盘点《太刺激2012》','youku','0','','124324996#1616656','','','','');
INSERT INTO `mac_vod` VALUES('986','神曲吐槽：国足1:5耻辱惨败上演泰囧2！','','shenqutucaoguozu15chirucanbaishangyantai2','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462611917.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','577','0','0','0','0','0','0','2.0','362','181','1457671530','1457671530','0','0','神曲吐槽：国足1:5耻辱惨败上演泰囧2！','youku','0','','142927134','','','','');
INSERT INTO `mac_vod` VALUES('987','坑爹讲坛假如古代也有手机','','kangdiejiangtanjiarugudaiyeyoushouji','K','','http://www.egao8.cc/upload/vod/2015-10-12/14446261291.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','623','0','0','0','0','0','0','2.0','378','189','1457671530','1457671530','0','0','坑爹讲坛假如古代也有手机','youku','0','','136232668','','','','');
INSERT INTO `mac_vod` VALUES('988','神曲吐槽禽流感来袭之各种怪相','','shenqutucaoqinliuganlaixizhigezhongguaixiang','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446261303.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','677','0','0','0','0','0','0','5.0','1610','322','1457671530','1457671530','0','0','神曲吐槽禽流感来袭之各种怪相','youku','0','','135435561','','','','');
INSERT INTO `mac_vod` VALUES('989','东北妞犀利解说手机别坑我了','','dongbeiniuxilijieshuoshoujibiekangwoliao','D','','http://www.egao8.cc/upload/vod/2015-10-12/144462616119.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','679','0','0','0','0','0','0','8.0','648','81','1457671530','1457671530','0','0','东北妞犀利解说手机别坑我了','youku','0','','141817150','','','','');
INSERT INTO `mac_vod` VALUES('990','天津妞犀利吐槽哪些明星毁车不倦','','tianjinniuxilitucaonaxiemingxinghuichebujuan','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446261756.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','39','0','0','0','0','0','0','9.0','4086','454','1457671530','1457671530','0','0','天津妞犀利吐槽哪些明星毁车不倦','youku','0','','XNzA0Nzk0Mzg4','','','','');
INSERT INTO `mac_vod` VALUES('991','东北妞犀利解说免费医疗别幻想了','','dongbeiniuxilijieshuomianfeiyiliaobiehuanxiangliao','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446261778.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','888','0','0','0','0','0','0','8.0','280','35','1457671530','1457671530','0','0','东北妞犀利解说免费医疗别幻想了','youku','0','','155443244','','','','');
INSERT INTO `mac_vod` VALUES('992','天津妞犀利吐槽 都敏俊的胯下之物','','tianjinniuxilitucaoduminjundekuaxiazhiwu','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462618112.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','322','0','0','0','0','0','0','4.0','620','155','1457671530','1457671530','0','0','天津妞犀利吐槽 都敏俊的胯下之物','youku','0','','XNjg2OTAyNzcy','','','','');
INSERT INTO `mac_vod` VALUES('993','吐槽倚天屠龙记天龙八部八部穿帮','','tucaoyitiantulongjitianlongbabubabuchuanbang','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462618515.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','658','0','0','0','0','0','0','10.0','30','3','1457671530','1457671530','0','0','吐槽倚天屠龙记天龙八部八部穿帮','youku','0','','XNzEwNzEyMTIw','','','','');
INSERT INTO `mac_vod` VALUES('994','天津妞犀利解说全民吐槽雾霾天','','tianjinniuxilijieshuoquanmintucaowumaitian','T','','http://www.egao8.cc/upload/vod/2015-10-12/144462618919.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','681','0','0','0','0','0','0','6.0','1518','253','1457671530','1457671530','0','0','天津妞犀利解说全民吐槽雾霾天','youku','0','','161650539','','','','');
INSERT INTO `mac_vod` VALUES('995','天津妞犀利吐槽妻子的秘密','','tianjinniuxilitucaoqizidemimi','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446261984.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','895','0','0','0','0','0','0','7.0','1323','189','1457671530','1457671530','0','0','天津妞犀利吐槽妻子的秘密','youku','0','','XNjkyODM0MDgw','','','','');
INSERT INTO `mac_vod` VALUES('996','惊！央视批星巴克为何惹众怒','','jingyangshipixingbakeweiheruozhongnu','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446261995.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','773','0','0','0','0','0','0','4.0','1308','327','1457671530','1457671530','0','0','惊！央视批星巴克为何惹众怒','youku','0','','156475889','','','','');
INSERT INTO `mac_vod` VALUES('997','揭秘设计师不拼实力拼性感','','jiemishejishibupinshilipinxinggan','J','','http://www.egao8.cc/upload/vod/2015-10-12/14446262018.gif','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','5','0','0','0','0','0','0','7.0','315','45','1457671530','1457671530','0','0','揭秘设计师不拼实力拼性感','youku','0','','XNTk1NjgxMzU2#149670010','','','','');
INSERT INTO `mac_vod` VALUES('998','张无忌被大学破格录取','','zhangwujibeidaxuepogeluqu','Z','','http://www.egao8.cc/upload/vod/2015-10-12/144462620814.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','753','0','0','0','0','0','0','4.0','820','205','1457671530','1457671530','0','0','张无忌被大学破格录取','youku','0','','142105276#XNTY4NDIwOTU2#105613691#108384625','','','','');
INSERT INTO `mac_vod` VALUES('999','喷一喷天降神兵之城管','','penyipentianjiangshenbingzhichengguan','P','','http://www.egao8.cc/upload/vod/2015-10-12/144462620815.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','895','0','0','0','0','0','0','2.0','552','276','1457671530','1457671530','0','0','喷一喷天降神兵之城管','youku','0','','143279097','','','','');
INSERT INTO `mac_vod` VALUES('1000','恶搞日本人丢车那点破事','','egaoribenrendingchenadianposhi','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462621218.jpg','','','老湿','','','','大陆','','0','9','','','0','0','0','0','0','0','0','0','278','0','0','0','0','0','0','7.0','3248','464','1457671530','1457671530','0','0','恶搞日本人丢车那点破事','youku','0','','88958152','','','','');
INSERT INTO `mac_vod` VALUES('1001','恶搞西游记新编大闹天宫','','egaoxiyoujixinbiandanaotiangong','E','','http://www.egao8.cc/upload/vod/2015-10-12/144462529717.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','108','0','0','0','0','0','0','9.0','2169','241','1457671543','1457671543','0','0','恶搞西游记新编大闹天宫','youku','0','','XNDIyNTMxODU2','','','','');
INSERT INTO `mac_vod` VALUES('1002','九阴真经重现江湖，风云再起血雨腥风','','jiuyinzhenjingzhongxianjianghufengyunzaiqixueyuxingfeng','J','','http://www.egao8.cc/upload/vod/2015-10-12/144462532617.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','657','0','0','0','0','0','0','5.0','745','149','1457671543','1457671543','0','0','九阴真经重现江湖，风云再起血雨腥风','youku','0','','XMzE4NjEyMzg4','','','','');
INSERT INTO `mac_vod` VALUES('1003','某S解说小区人民喜迎“油价”上涨','','mouSjieshuoxiaoqurenminxiyingyoujiashangzhang','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462535319.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','190','0','0','0','0','0','0','1.0','482','482','1457671543','1457671543','0','0','某S解说小区人民喜迎“油价”上涨','youku','0','','XMzY0MTU3Mzk2','','','','');
INSERT INTO `mac_vod` VALUES('1004','葫芦兄弟大战神雕侠侣','','huluxiongdidazhanshendiaoxialv','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462555611.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','835','0','0','0','0','0','0','6.0','2016','336','1457671543','1457671543','0','0','葫芦兄弟大战神雕侠侣','youku','0','','XMzkyODcyNjA4','','','','');
INSERT INTO `mac_vod` VALUES('1005','某S网络水军够牛逼啊','','mouSwangluoshuijungouniubia','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446256003.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','691','0','0','0','0','0','0','9.0','378','42','1457671543','1457671543','0','0','某S网络水军够牛逼啊','youku','0','','XNDQxMDI2OTA0','','','','');
INSERT INTO `mac_vod` VALUES('1006','某月某S盘点','','mouyuemouSpandian','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446256319.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','74','0','0','0','0','0','0','4.0','1156','289','1457671543','1457671543','0','0','某月某S盘点','youku','0','','XMzc0MzA0NTI0','','','','');
INSERT INTO `mac_vod` VALUES('1007','某S戏说明星和手机','','mouSxishuomingxingheshouji','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462565711.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','769','0','0','0','0','0','0','9.0','2250','250','1457671543','1457671543','0','0','某S戏说明星和手机','youku','0','','XNDQwMjYxMjM2','','','','');
INSERT INTO `mac_vod` VALUES('1008','未来帝2044年看过的世界杯','','weilaidi2044niankanguodeshijiebei','W','','http://www.egao8.cc/upload/vod/2015-10-12/144462566318.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','280','0','0','0','0','0','0','2.0','418','209','1457671543','1457671543','0','0','未来帝2044年看过的世界杯','youku','0','','XNDE2MTc3NTAw','','','','');
INSERT INTO `mac_vod` VALUES('1009','某S：我三十年没杀人了！','','mouSwosanshinianmeisharenliao','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462568413.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','79','0','0','0','0','0','0','1.0','183','183','1457671543','1457671543','0','0','某S：我三十年没杀人了！','youku','0','','XMzI3MjMxNTY0','','','','');
INSERT INTO `mac_vod` VALUES('1010','某S戏说各路奇葩太极','','mouSxishuogeluqipataiji','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446256991.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','859','0','0','0','0','0','0','8.0','400','50','1457671543','1457671543','0','0','某S戏说各路奇葩太极','youku','0','','138213420','','','','');
INSERT INTO `mac_vod` VALUES('1011','东方卫视春晚请来的囧人们','','dongfangweishichunwanqinglaiderenmen','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446257078.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','778','0','0','0','0','0','0','10.0','1710','171','1457671543','1457671543','0','0','东方卫视春晚请来的囧人们','youku','0','','127937183','','','','');
INSERT INTO `mac_vod` VALUES('1012','史上最避孕的促销方法 有点邪恶','','shishangzuibiyundechunxiaofangfayoudianxiee','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446257292.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','717','0','0','0','0','0','0','4.0','60','15','1457671543','1457671543','0','0','史上最避孕的促销方法 有点邪恶','youku','0','','88102605','','','','');
INSERT INTO `mac_vod` VALUES('1013','某S横路真二的世界','','mouShengluzhenerdeshijie','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446257337.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','522','0','0','0','0','0','0','6.0','1740','290','1457671543','1457671543','0','0','某S横路真二的世界','youku','0','','86050815','','','','');
INSERT INTO `mac_vod` VALUES('1014','某S解说凤姐去美国吓屎一对双胞胎','','mouSjieshuofengjiequmeiguoxiashiyiduishuangbaotai','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462574215.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','260','0','0','0','0','0','0','8.0','464','58','1457671543','1457671543','0','0','某S解说凤姐去美国吓屎一对双胞胎','youku','0','','77464461','','','','');
INSERT INTO `mac_vod` VALUES('1015','某S盘点2011热点事件','','mouSpandian2011redianshijian','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446257563.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','467','0','0','0','0','0','0','5.0','1840','368','1457671543','1457671543','0','0','某S盘点2011热点事件','youku','0','','XMzM3MDY3MzY0','','','','');
INSERT INTO `mac_vod` VALUES('1016','大熊猫也不都天真无邪 某S','','daxiongmiaoyebudutianzhenwuxiemouS','D','','http://www.egao8.cc/upload/vod/2015-10-12/14446257649.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','396','0','0','0','0','0','0','3.0','1140','380','1457671543','1457671543','0','0','大熊猫也不都天真无邪 某S','youku','0','','81283042','','','','');
INSERT INTO `mac_vod` VALUES('1017','韩国明星的脑残粉儿够牛逼的啊 某S','','hanguomingxingdenaocanfenergouniubideamouS','H','','http://www.egao8.cc/upload/vod/2015-10-12/144462577317.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','269','0','0','0','0','0','0','7.0','3395','485','1457671543','1457671543','0','0','韩国明星的脑残粉儿够牛逼的啊 某S','youku','0','','81420613','','','','');
INSERT INTO `mac_vod` VALUES('1018','改编日和某S解说','','gaibianrihemouSjieshuo','G','','http://www.egao8.cc/upload/vod/2015-10-12/14446257855.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','529','0','0','0','0','0','0','7.0','3052','436','1457671543','1457671543','0','0','改编日和某S解说','youku','0','','82380304','','','','');
INSERT INTO `mac_vod` VALUES('1019','某S解说你们这是打架还是搞基？','','mouSjieshuonimenzheshidajiahuaishigaoji','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446257899.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','85','0','0','0','0','0','0','7.0','3283','469','1457671543','1457671543','0','0','某S解说你们这是打架还是搞基？','youku','0','','79240296','','','','');
INSERT INTO `mac_vod` VALUES('1020','恐怖追逃现场不喜不入某S解说','','kongbuzhuitaoxianchangbuxiburumouSjieshuo','K','','http://www.egao8.cc/upload/vod/2015-10-12/144462579516.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','567','0','0','0','0','0','0','2.0','858','429','1457671543','1457671543','0','0','恐怖追逃现场不喜不入某S解说','youku','0','','80834800','','','','');
INSERT INTO `mac_vod` VALUES('1021','史上最业余足球解说','','shishangzuiyeyuzuqiujieshuo','S','','http://www.egao8.cc/upload/vod/2015-10-12/14446255474.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','571','0','0','0','0','0','0','6.0','2376','396','1457671555','1457671555','0','0','史上最业余足球解说','youku','0','','87704618','','','','');
INSERT INTO `mac_vod` VALUES('1022','某S辣评汽车广告第六期','','mouSlapingqicheguanggaodiliuqi','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462555914.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','915','0','0','0','0','0','0','7.0','2177','311','1457671555','1457671555','0','0','某S辣评汽车广告第六期','youku','0','','129005007#112849088#G50jFNG6GtKnY34ggePtSg..$ku6\',\'u7B2Cu4E09u671F#121822936#125531401#132995107#136890763','','','','');
INSERT INTO `mac_vod` VALUES('1023','2012末日版西游记','','2012moribanxiyouji','2','','http://www.egao8.cc/upload/vod/2015-10-12/144462556116.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','883','0','0','0','0','0','0','9.0','864','96','1457671555','1457671555','0','0','2012末日版西游记','youku','0','','116741079','','','','');
INSERT INTO `mac_vod` VALUES('1024','老中医把脉了,脑残者不可治','','laozhongyibamailiaonaocanzhebukezhi','L','','http://www.egao8.cc/upload/vod/2015-10-12/14446255721.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','480','0','0','0','0','0','0','4.0','1144','286','1457671555','1457671555','0','0','老中医把脉了,脑残者不可治','youku','0','','112409701','','','','');
INSERT INTO `mac_vod` VALUES('1025','某S辣评汽车广告第十二期不明觉厉','','mouSlapingqicheguanggaodishierqibumingjueli','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446255765.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','678','0','0','0','0','0','0','6.0','882','147','1457671555','1457671555','0','0','某S辣评汽车广告第十二期不明觉厉','youku','0','','151026483','','','','');
INSERT INTO `mac_vod` VALUES('1026','iphone5横空出世,报价1800元 某S爆笑解说','','iphone5hengkongchushibaojia1800yuanmouSbaoxiaojieshuo','I','','http://www.egao8.cc/upload/vod/2015-10-12/144462558310.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','668','0','0','0','0','0','0','2.0','614','307','1457671555','1457671555','0','0','iphone5横空出世,报价1800元 某S爆笑解说','youku','0','','77715562','','','','');
INSERT INTO `mac_vod` VALUES('1027','史上情结最狗血的短片已经诞生 某S解说','','shishangqingjiezuigouxuededuanpianyijingdanshengmouSjieshuo','S','','http://www.egao8.cc/upload/vod/2015-10-12/144462558613.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','111','0','0','0','0','0','0','3.0','1128','376','1457671555','1457671555','0','0','史上情结最狗血的短片已经诞生 某S解说','youku','0','','77940233','','','','');
INSERT INTO `mac_vod` VALUES('1028','某S辣评汽车广告第十五期','','mouSlapingqicheguanggaodishiwuqi','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462559319.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','386','0','0','0','0','0','0','2.0','152','76','1457671555','1457671555','0','0','某S辣评汽车广告第十五期','youku','0','','160903998','','','','');
INSERT INTO `mac_vod` VALUES('1029','吐槽德系三剑客 某S辣评汽车广告第8期','','tucaodexisanjiankemouSlapingqicheguanggaodi8qi','T','','http://www.egao8.cc/upload/vod/2015-10-12/14446256047.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','839','0','0','0','0','0','0','10.0','3620','362','1457671555','1457671555','0','0','吐槽德系三剑客 某S辣评汽车广告第8期','youku','0','','136890763#112849088#G50jFNG6GtKnY34ggePtSg..$ku6\',\'u7B2Cu4E09u671F#121822936#125531401#129005007#132995107','','','','');
INSERT INTO `mac_vod` VALUES('1030','两个上海人打架，一个东北人某S解说','','lianggeshanghairendajiayigedongbeirenmouSjieshuo','L','','http://www.egao8.cc/upload/vod/2015-10-12/144462560710.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','39','0','0','0','0','0','0','2.0','96','48','1457671555','1457671555','0','0','两个上海人打架，一个东北人某S解说','youku','0','','76858324','','','','');
INSERT INTO `mac_vod` VALUES('1031','某S辣评汽车广告第七期','','mouSlapingqicheguanggaodiqiqi','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462560913.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','19','0','0','0','0','0','0','2.0','866','433','1457671555','1457671555','0','0','某S辣评汽车广告第七期','youku','0','','132995107#165376060#G50jFNG6GtKnY34ggePtSg..$ku6\',\'u7B2Cu4E09u671F#121822936#125531401#129005007#136890763','','','','');
INSERT INTO `mac_vod` VALUES('1032','某S爆笑解说自行车禽兽！放开那辆跑车！','','mouSbaoxiaojieshuozixingcheqinshoufangkainaliangpaoche','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446256231.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','533','0','0','0','0','0','0','7.0','2982','426','1457671555','1457671555','0','0','某S爆笑解说自行车禽兽！放开那辆跑车！','youku','0','','80128409','','','','');
INSERT INTO `mac_vod` VALUES('1033','某S辣评汽车广告','','mouSlapingqicheguanggao','M','','http://www.egao8.cc/upload/vod/2015-10-12/14446256254.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','305','0','0','0','0','0','0','9.0','1512','168','1457671555','1457671555','0','0','某S辣评汽车广告','youku','0','','112849088#G50jFNG6GtKnY34ggePtSg..$ku6\',\'u7B2Cu4E09u671F#121822936#125531401#129005007#132995107#136890763','','','','');
INSERT INTO `mac_vod` VALUES('1034','飞天猪大战李小龙','','feitianzhudazhanlixiaolong','F','','http://www.egao8.cc/upload/vod/2015-10-12/144462563413.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','276','0','0','0','0','0','0','2.0','322','161','1457671555','1457671555','0','0','飞天猪大战李小龙','youku','0','','147654329','','','','');
INSERT INTO `mac_vod` VALUES('1035','戏说电脑发展史','','xishuodiannaofazhanshi','X','','http://www.egao8.cc/upload/vod/2015-10-12/144462563716.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','856','0','0','0','0','0','0','7.0','2751','393','1457671555','1457671555','0','0','戏说电脑发展史','youku','0','','103878703','','','','');
INSERT INTO `mac_vod` VALUES('1036','七夕再不耍流氓，等着流氓耍你吗？','','qixizaibushualiumengdengzhouliumengshuanima','Q','','http://www.egao8.cc/upload/vod/2015-10-12/14446256482.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','173','0','0','0','0','0','0','2.0','916','458','1457671555','1457671555','0','0','七夕再不耍流氓，等着流氓耍你吗？','youku','0','','110582577','','','','');
INSERT INTO `mac_vod` VALUES('1037','恶搞中国男足最伤不起的10个字','','egaozhongguonanzuzuishangbuqide10gezi','E','','http://www.egao8.cc/upload/vod/2015-10-12/14446256515.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','326','0','0','0','0','0','0','7.0','1316','188','1457671555','1457671555','0','0','恶搞中国男足最伤不起的10个字','youku','0','','78127968','','','','');
INSERT INTO `mac_vod` VALUES('1038','传奇成就传奇','','chuanqichengjiuchuanqi','C','','http://www.egao8.cc/upload/vod/2015-10-12/144462566014.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','631','0','0','0','0','0','0','4.0','1080','270','1457671555','1457671555','0','0','传奇成就传奇','youku','0','','105955772','','','','');
INSERT INTO `mac_vod` VALUES('1039','日本相扑其实就是拱猪 某S第三部','','ribenxiangpuqishijiushigongzhumouSdisanbu','R','','http://www.egao8.cc/upload/vod/2015-10-12/14446256733.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','873','0','0','0','0','0','0','2.0','760','380','1457671555','1457671555','0','0','日本相扑其实就是拱猪 某S第三部','youku','0','','77226864','','','','');
INSERT INTO `mac_vod` VALUES('1040','某S超内涵篇逆袭远征','','mouSchaonahanpiannixiyuanzheng','M','','http://www.egao8.cc/upload/vod/2015-10-12/144462568010.jpg','','','老湿','','','','大陆','','0','10','','','0','0','0','0','0','0','0','0','555','0','0','0','0','0','0','10.0','3000','300','1457671555','1457671555','0','0','某S超内涵篇逆袭远征','youku','0','','130757039','','','','');
INSERT INTO `mac_vod` VALUES('1041','东莞神曲《爷栽在了东莞》','','dongguanshenquyezaizailiaodongguan','D','','http://www.egao8.cc/upload/vod/2015-10-14/14448000380.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','969','0','0','0','0','0','0','10.0','3340','334','1457671567','1457671567','0','0','东莞神曲《爷栽在了东莞》','youku','0','','XNjcyODU1OTM2','','','','');
INSERT INTO `mac_vod` VALUES('1042','韩少与四娘之今世虐恋','','hanshaoyusiniangzhijinshinuenuelian','H','','http://www.egao8.cc/upload/vod/2015-10-14/14448003460.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','504','0','0','0','0','0','0','8.0','3472','434','1457671567','1457671567','0','0','韩少与四娘之今世虐恋','youku','0','','XNzA5MDg4ODI4','','','','');
INSERT INTO `mac_vod` VALUES('1043','欧子最吐槽当泰森PK城管','','ouzizuitucaodangtaisenPKchengguan','O','','http://www.egao8.cc/upload/vod/2015-10-14/14448006750.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','136','0','0','0','0','0','0','4.0','1688','422','1457671567','1457671567','0','0','欧子最吐槽当泰森PK城管','youku','0','','149813308','','','','');
INSERT INTO `mac_vod` VALUES('1044','他没出轨的智商  献给邓超！','','tameichuguidezhishangxiangeidengchao','T','','http://www.egao8.cc/upload/vod/2015-10-14/14447961340.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','88','0','0','0','0','0','0','6.0','1146','191','1457671567','1457671567','0','0','他没出轨的智商  献给邓超！','youku','0','','XMTI2NjQ0MjQ4NA==','','','','');
INSERT INTO `mac_vod` VALUES('1045','曝杜海涛下跪内幕  曝杜海涛下跪内幕','','puduhaitaoxiaguinamupuduhaitaoxiaguinamu','P','','http://www.egao8.cc/upload/vod/2015-10-14/14447960970.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','801','0','0','0','0','0','0','2.0','988','494','1457671567','1457671567','0','0','曝杜海涛下跪内幕  曝杜海涛下跪内幕','youku','0','','XMTM1MjkzMzg0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1046','《大虾三十八》难道是叶良辰称霸  《大虾三十八》难道是叶良辰称霸','','daxiasanshibanandaoshiyeliangchenchenbadaxiasanshibanandaoshiyeliangchenchenba','D','','http://www.egao8.cc/upload/vod/2015-10-14/14447960630.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','185','0','0','0','0','0','0','8.0','520','65','1457671567','1457671567','0','0','《大虾三十八》难道是叶良辰称霸  《大虾三十八》难道是叶良辰称霸','youku','0','','XMTM1ODQ3MzgwOA==','','','','');
INSERT INTO `mac_vod` VALUES('1047','范爷大黑牛之恋  吐槽娱乐圈藏着掖着的恋情！','','fanyedaheiniuzhiliantucaoyulequancangzhouyezhoudelianqing','F','','http://www.egao8.cc/upload/vod/2015-10-14/14447960040.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','870','0','0','0','0','0','0','7.0','1764','252','1457671567','1457671567','0','0','范爷大黑牛之恋  吐槽娱乐圈藏着掖着的恋情！','youku','0','','XMTI2NjMxNDE4OA==','','','','');
INSERT INTO `mac_vod` VALUES('1048','一曲唱尽9月热点  一曲唱尽9月热点','','yiquchangjin9yueredianyiquchangjin9yueredian','Y','','http://www.egao8.cc/upload/vod/2015-10-14/14447959640.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','452','0','0','0','0','0','0','3.0','402','134','1457671567','1457671567','0','0','一曲唱尽9月热点  一曲唱尽9月热点','youku','0','','XMTM1Mjk4MjYyNA==','','','','');
INSERT INTO `mac_vod` VALUES('1049','教主和baby《女氏日》了 恭喜  教主和baby《女氏日》了 恭喜','','jiaozhuhebabynvshiriliaogongxijiaozhuhebabynvshiriliaogongxi','J','','http://www.egao8.cc/upload/vod/2015-10-14/14447959310.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','749','0','0','0','0','0','0','6.0','900','150','1457671567','1457671567','0','0','教主和baby《女氏日》了 恭喜  教主和baby《女氏日》了 恭喜','youku','0','','XMTM1NTM4ODY3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1050','《飞人不哭》站起来撸  《飞人不哭》站起来撸','','feirenbukuzhanqilailufeirenbukuzhanqilailu','F','','http://www.egao8.cc/upload/vod/2015-10-14/14447958960.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','46','0','0','0','0','0','0','8.0','1792','224','1457671567','1457671567','0','0','《飞人不哭》站起来撸  《飞人不哭》站起来撸','youku','0','','XMTMxODM5Mzc1Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1051','中秋最美情歌《月非圆一次》星爷浪漫出演！  中秋最美情歌《月非圆一次》星爷浪漫出演！','','zhongqiuzuimeiqinggeyuefeiyuanyicixingyelangmanchuyanzhongqiuzuimeiqinggeyuefeiyuanyicixingyelangmanchuyan','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14447958690.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','345','0','0','0','0','0','0','2.0','780','390','1457671567','1457671567','0','0','中秋最美情歌《月非圆一次》星爷浪漫出演！  中秋最美情歌《月非圆一次》星爷浪漫出演！','youku','0','','XMTM0NjA2OTgyMA==','','','','');
INSERT INTO `mac_vod` VALUES('1052','纪念邓丽君逝世二十周年  纪念邓丽君逝世二十周年','','jiniandenglijunshishiershizhounianjiniandenglijunshishiershizhounian','J','','http://www.egao8.cc/upload/vod/2015-10-14/14447958410.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','621','0','0','0','0','0','0','2.0','830','415','1457671567','1457671567','0','0','纪念邓丽君逝世二十周年  纪念邓丽君逝世二十周年','youku','0','','XMTMyMzUzNzAxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1053','《逆行英雄》向英雄们致敬 祈福天津  《逆行英雄》向英雄们致敬 祈福天津','','nixingyingxiongxiangyingxiongmenzhijingqifutianjinnixingyingxiongxiangyingxiongmenzhijingqifutianjin','N','','http://www.egao8.cc/upload/vod/2015-10-14/14447958110.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','65','0','0','0','0','0','0','3.0','1281','427','1457671567','1457671567','0','0','《逆行英雄》向英雄们致敬 祈福天津  《逆行英雄》向英雄们致敬 祈福天津','youku','0','','XMTMxNDIzOTQyNA==','','','','');
INSERT INTO `mac_vod` VALUES('1054','神曲《试衣间见！》吐槽优衣库啪啪啪！  神曲《试衣间见！》吐槽优衣库啪啪啪！','','shenqushiyijianjiantucaoyouyikupapapashenqushiyijianjiantucaoyouyikupapapa','S','','http://www.egao8.cc/upload/vod/2015-10-14/14447957660.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','336','0','0','0','0','0','0','10.0','350','35','1457671567','1457671567','0','0','神曲《试衣间见！》吐槽优衣库啪啪啪！  神曲《试衣间见！》吐槽优衣库啪啪啪！','youku','0','','XMTMxODM5MjQwMA==','','','','');
INSERT INTO `mac_vod` VALUES('1055','神曲《试衣间见》吐槽优衣库啪啪啪  吐槽优衣库啪啪啪','','shenqushiyijianjiantucaoyouyikupapapatucaoyouyikupapapa','S','','http://www.egao8.cc/upload/vod/2015-10-14/14447957170.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','813','0','0','0','0','0','0','3.0','1386','462','1457671567','1457671567','0','0','神曲《试衣间见》吐槽优衣库啪啪啪  吐槽优衣库啪啪啪','youku','0','','XMTI4NTg4NTc4NA==','','','','');
INSERT INTO `mac_vod` VALUES('1056','降温神曲《热真的shi了！》热不shi才怪  降温神曲《热真的shi了！》热不shi才怪','','jiangwenshenqurezhendeshiliaorebushicaiguaijiangwenshenqurezhendeshiliaorebushicaiguai','J','','http://www.egao8.cc/upload/vod/2015-10-14/14447956640.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','845','0','0','0','0','0','0','3.0','486','162','1457671568','1457671568','0','0','降温神曲《热真的shi了！》热不shi才怪  降温神曲《热真的shi了！》热不shi才怪','youku','0','','XMTI5NzY0OTYyOA==','','','','');
INSERT INTO `mac_vod` VALUES('1057','马震神曲《别问马震是谁》大黑牛都听哭了  马震神曲《别问马震是谁》大黑牛都听哭了','','mazhenshenqubiewenmazhenshishuidaheiniudutingkuliaomazhenshenqubiewenmazhenshishuidaheiniudutingkuliao','M','','http://www.egao8.cc/upload/vod/2015-10-14/14447956320.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','999','0','0','1','0','0','0','7.0','3150','450','1457671568','1457671568','1457756423','0','马震神曲《别问马震是谁》大黑牛都听哭了  马震神曲《别问马震是谁》大黑牛都听哭了','youku','0','','XMTI5MzAyMTk2NA==','','','','');
INSERT INTO `mac_vod` VALUES('1058','《归家の天路》祝归家的儿女新春快乐！  家的儿女新春快乐！','','guijiatianluzhuguijiadeernvxinchunkuailejiadeernvxinchunkuaile','G','','http://www.egao8.cc/upload/vod/2015-10-14/14447955970.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','306','0','0','0','0','0','0','7.0','868','124','1457671568','1457671568','0','0','《归家の天路》祝归家的儿女新春快乐！  家的儿女新春快乐！','youku','0','','XMTI3MTkyNDIyOA==','','','','');
INSERT INTO `mac_vod` VALUES('1059','《飞人不哭》站起来撸  站起来撸','','feirenbukuzhanqilailuzhanqilailu','F','','http://www.egao8.cc/upload/vod/2015-10-14/14447955590.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','524','0','0','0','0','0','0','1.0','93','93','1457671568','1457671568','0','0','《飞人不哭》站起来撸  站起来撸','youku','0','','XMTI3MDc0OTQxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1060','父亲节最温馨亲情MV《爸爸》  [牛人]欧子最吐槽 2015：23','','fuqinjiezuiwenxinqinqingMVbabaniurenouzizuitucao201523','F','','http://www.egao8.cc/upload/vod/2015-10-14/14447954900.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','377','0','0','3','0','0','0','1.0','499','499','1457671568','1457671568','1457753187','0','父亲节最温馨亲情MV《爸爸》  【牛人】欧子最吐槽 2015：23','youku','0','','XMTI2NzA2NTIzNg==','','','','');
INSERT INTO `mac_vod` VALUES('1061','打招呼才发现认错人该怎么办？网友列10招化解尴尬—专辑：《笑翻你！搞笑有趣视频大集锦》','','dazhaohucaifaxianrencuorengaizenmebanwangyoulie10zhaohuajiegangazhuanjixiaofannigaoxiaoyouqushipindajijin','D','','http://www.egao8.cc/upload/vod/2015-10-14/14448001430.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','798','0','0','0','0','0','0','10.0','3440','344','1457671577','1457671577','0','0','打招呼才发现认错人该怎么办？网友列10招化解尴尬—专辑：《笑翻你！搞笑有趣视频大集锦》','youku','0','','XODk3MDg4Mjky','','','','');
INSERT INTO `mac_vod` VALUES('1062','曾经想火 第二季 第06集—专辑：《《曾经想火》第二季》','','zengjingxianghuodierjidi06jizhuanjizengjingxianghuodierji','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14448006920.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','205','0','0','0','0','0','0','10.0','1150','115','1457671577','1457671577','0','0','曾经想火 第二季 第06集—专辑：《《曾经想火》第二季》','youku','0','','XODg0ODIzOTA4','','','','');
INSERT INTO `mac_vod` VALUES('1063','超萌炫酷R《爸爸去哪里》','','chaomengxuankuRbabaqunali','C','','http://www.egao8.cc/upload/vod/2015-10-14/14448001720.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','726','0','0','0','0','0','0','9.0','3663','407','1457671577','1457671577','0','0','超萌炫酷RAP版《爸爸去哪里》','youku','0','','162636652','','','','');
INSERT INTO `mac_vod` VALUES('1064','《女神之最》女神一出，引各路男神竞YY  欧子最吐槽','','nvshenzhizuinvshenyichuyingelunanshenjingYYouzizuitucao','N','','http://www.egao8.cc/upload/vod/2015-10-14/14448002160.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','457','0','0','0','0','0','0','6.0','300','50','1457671577','1457671577','0','0','《女神之最》女神一出，引各路男神竞YY  欧子最吐槽','youku','0','','XNzYwNTA4MTQ0','','','','');
INSERT INTO `mac_vod` VALUES('1065','2014世界悲吐槽巴西世界杯','','2014shijiebeitucaobaxishijiebei','2','','http://www.egao8.cc/upload/vod/2015-10-14/14448002440.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','715','0','0','0','0','0','0','5.0','1170','234','1457671577','1457671577','0','0','2014世界悲吐槽巴西世界杯','youku','0','','XNzI1MTYyOTQ0','','','','');
INSERT INTO `mac_vod` VALUES('1066','吐槽《咱们结婚吧》乃史上最长广告片','','tucaozaimenjiehunbanaishishangzuichangguanggaopian','T','','http://www.egao8.cc/upload/vod/2015-10-14/14448002780.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','285','0','0','0','0','0','0','4.0','532','133','1457671577','1457671577','0','0','吐槽《咱们结婚吧》乃史上最长广告片','youku','0','','158994298','','','','');
INSERT INTO `mac_vod` VALUES('1067','逗比毕业季新编小苹果神曲','','doubibiyejixinbianxiaopingguoshenqu','D','','http://www.egao8.cc/upload/vod/2015-10-14/14448003070.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','671','0','0','0','0','0','0','10.0','290','29','1457671577','1457671577','0','0','逗比毕业季新编小苹果神曲','youku','0','','XNzMwODI0MzY4','','','','');
INSERT INTO `mac_vod` VALUES('1068','童年是怎么毁掉的童年之终极追忆','','tongnianshizenmehuidiaodetongnianzhizhongjizhuiyi','T','','http://www.egao8.cc/upload/vod/2015-10-14/14448003840.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','345','0','0','0','0','0','0','3.0','1323','441','1457671577','1457671577','0','0','童年是怎么毁掉的童年之终极追忆','youku','0','','XNzE5MTU0MzUy','','','','');
INSERT INTO `mac_vod` VALUES('1069','做人不能太马来西亚因韩国沉船事件有感而发','','zuorenbunentaimalaixiyayinhanguochenchuanshijianyouganerfa','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14448004280.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','999','0','0','0','0','0','0','3.0','735','245','1457671577','1457671577','0','0','做人不能太马来西亚因韩国沉船事件有感而发','youku','0','','XNzA0OTkyMTky','','','','');
INSERT INTO `mac_vod` VALUES('1070','欧子最吐槽金像奖之奖后风云','','ouzizuitucaojinxiangjiangzhijianghoufengyun','O','','http://www.egao8.cc/upload/vod/2015-10-14/14448004640.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','794','0','0','0','0','0','0','9.0','2727','303','1457671577','1457671577','0','0','欧子最吐槽金像奖之奖后风云','youku','0','','XNzAxNjQxMTg0','','','','');
INSERT INTO `mac_vod` VALUES('1071','吐槽盘点娱乐圈吸毒明星','','tucaopandianyulequanxidumingxing','T','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','607','0','0','0','0','0','0','7.0','602','86','1457671577','1457671577','0','0','吐槽盘点娱乐圈吸毒明星','youku','0','','XNjg3NTk5MDQ0','','','','');
INSERT INTO `mac_vod` VALUES('1072','宫锁连城穿帮最吐槽','','gongsuolianchengchuanbangzuitucao','G','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','288','0','0','0','0','0','0','3.0','891','297','1457671577','1457671577','0','0','宫锁连城穿帮最吐槽','youku','0','','XNjk5MDk3NTc2#UMzAxMTI0OTg4','','','','');
INSERT INTO `mac_vod` VALUES('1073','大丈夫十大穿帮镜头','','dazhangfushidachuanbangjingtou','D','','http://www.egao8.cc/upload/vod/2015-10-14/14448005010.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','901','0','0','0','0','0','0','8.0','24','3','1457671577','1457671577','0','0','大丈夫十大穿帮镜头','youku','0','','XNjgxODUyODI4','','','','');
INSERT INTO `mac_vod` VALUES('1074','吐槽版《太疯癫》叹星爷经典被糟践','','tucaobantaifengdiantanxingyejingdianbeizaojian','T','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','983','0','0','0','0','0','0','9.0','2259','251','1457671578','1457671578','0','0','吐槽版《太疯癫》叹星爷经典被糟践','youku','0','','XNjg2Njg2ODIw','','','','');
INSERT INTO `mac_vod` VALUES('1075','十年之后揭秘李天一的十年感悟','','shinianzhihoujiemilitianyideshinianganwu','S','','http://www.egao8.cc/upload/vod/2015-10-14/14448005320.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','786','0','0','0','0','0','0','1.0','200','200','1457671578','1457671578','0','0','十年之后揭秘李天一的十年感悟','youku','0','','154760412','','','','');
INSERT INTO `mac_vod` VALUES('1076','你好蠢调侃张亮蠢哭了','','nihaochundiaokanzhangliangchunkuliao','N','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','535','0','0','0','0','0','0','9.0','2187','243','1457671578','1457671578','0','0','你好蠢调侃张亮蠢哭了','youku','0','','162952486','','','','');
INSERT INTO `mac_vod` VALUES('1077','李母救子七招全程回顾李天一案','','limujiuziqizhaoquanchenghuigulitianyian','L','','http://www.egao8.cc/upload/vod/2015-10-14/14448005610.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','670','0','0','0','0','0','0','2.0','262','131','1457671578','1457671578','0','0','李母救子七招全程回顾李天一案','youku','0','','154041867','','','','');
INSERT INTO `mac_vod` VALUES('1078','薛老爷子吐槽嫖娼被拘的薛大V','','xuelaoyezitucaopiaochangbeijudexuedaV','X','','http://www.egao8.cc/upload/vod/2015-10-14/14448005860.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','101','0','0','0','0','0','0','7.0','707','101','1457671578','1457671578','0','0','薛老爷子吐槽嫖娼被拘的薛大V','youku','0','','150364363','','','','');
INSERT INTO `mac_vod` VALUES('1079','平胸妹儿不简单吐槽平胸大赛','','pingxiongmeierbujiandantucaopingxiongdasai','P','','http://www.egao8.cc/upload/vod/2015-10-14/14448006150.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','458','0','0','0','0','0','0','5.0','2495','499','1457671578','1457671578','0','0','平胸妹儿不简单吐槽平胸大赛','youku','0','','151436019','','','','');
INSERT INTO `mac_vod` VALUES('1080','真汉子不打手枪》吐槽奇妙的“换枪为赞  真汉子不打手枪》吐槽奇妙的“换枪为赞','','zhenhanzibudashouqiangtucaoqimiaodehuanqiangweizanzhenhanzibudashouqiangtucaoqimiaodehuanqiangweizan','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14448006420.png','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','337','0','0','0','0','0','0','3.0','1212','404','1457671578','1457671578','0','0','真汉子不打手枪》吐槽奇妙的“换枪为赞  真汉子不打手枪》吐槽奇妙的“换枪为赞','youku','0','','XMTMxODM5NTY1Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1081','《扛不住の狂舞》演奏技术哪里  欧子最吐槽 2014','','kangbuzhukuangwuyanzoujishunaliouzizuitucao2014','K','','http://www.egao8.cc/upload/vod/2015-10-14/14447995580.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','152','0','0','0','0','0','0','5.0','240','48','1457671588','1457671588','0','0','《扛不住の狂舞》演奏技术哪里  欧子最吐槽 2014','youku','0','','XODA5MDc0OTEy','','','','');
INSERT INTO `mac_vod` VALUES('1082','配音员尼玛伤不起！','','peiyinyuannimashangbuqi','P','','http://www.egao8.cc/upload/vod/2015-10-14/14447996000.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','353','0','0','0','0','0','0','9.0','4500','500','1457671588','1457671588','0','0','配音员尼玛伤不起！','youku','0','','XNzIwODY2NjE2','','','','');
INSERT INTO `mac_vod` VALUES('1083','吐槽“被勾引发生X关系”被勾引的时光','','tucaobeigouyinfashengXguanxibeigouyindeshiguang','T','','http://www.egao8.cc/upload/vod/2015-10-14/14447996710.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','319','0','0','0','0','0','0','10.0','190','19','1457671588','1457671588','0','0','吐槽“被勾引发生X关系”被勾引的时光','youku','0','','XNjc4NzkyOTQ0','','','','');
INSERT INTO `mac_vod` VALUES('1084','别逼咱弃戏Rap吐槽步步惊情','','biebizaiqixiRaptucaobubujingqing','B','','http://www.egao8.cc/upload/vod/2015-10-14/14447997190.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','930','0','0','0','0','0','0','3.0','225','75','1457671588','1457671588','0','0','别逼咱弃戏Rap吐槽步步惊情','youku','0','','XNzAzNDYwNjY4','','','','');
INSERT INTO `mac_vod` VALUES('1085','药别停！<新天雷>用绳命代言','','yaobietingxintianleiyongshengmingdaiyan','Y','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','32','0','0','0','0','0','0','7.0','2611','373','1457671588','1457671588','0','0','药别停！用绳命代言','youku','0','','XNjU5NTcxOTI4','','','','');
INSERT INTO `mac_vod` VALUES('1086','文姚恋”之前世今生看一场出轨的闹剧！','','wenyaolianzhiqianshijinshengkanyichangchuguidenaoju','W','','http://www.egao8.cc/upload/vod/2015-10-14/14447997990.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','692','0','0','0','0','0','0','1.0','477','477','1457671588','1457671588','0','0','文姚恋”之前世今生看一场出轨的闹剧！','youku','0','','XNjkzMzMxMjQw','','','','');
INSERT INTO `mac_vod` VALUES('1087','三十九岁这年的危机一起来黑林志颖','','sanshijiusuizheniandeweijiyiqilaiheilinzhiying','S','','http://www.xuduba.com/pic/uploadimg/2013-12/2013121717201783216.jpg#err2015-10-14','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','445','0','0','0','0','0','0','2.0','872','436','1457671588','1457671588','0','0','三十九岁这年的危机一起来黑林志颖','youku','0','','162186983','','','','');
INSERT INTO `mac_vod` VALUES('1088','《拿什么选帅首 我的男神》男神齐聚经典重现  欧子最吐槽','','nashimexuanshuaishouwodenanshennanshenqijujingdianzhongxianouzizuitucao','N','','http://www.egao8.cc/upload/vod/2015-10-14/14447998800.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','546','0','0','0','0','0','0','4.0','1636','409','1457671588','1457671588','0','0','《拿什么选帅首 我的男神》男神齐聚经典重现  欧子最吐槽','youku','0','','XNzU5NTg4OTY4','','','','');
INSERT INTO `mac_vod` VALUES('1089','恶搞“妈妈再打我一次”','','egaomamazaidawoyici','E','','http://www.egao8.cc/upload/vod/2015-10-14/14447999090.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','217','0','0','0','0','0','0','5.0','1435','287','1457671588','1457671588','0','0','恶搞“妈妈再打我一次”','youku','0','','161201895','','','','');
INSERT INTO `mac_vod` VALUES('1090','吐槽最美的时光穿帮镜头','','tucaozuimeideshiguangchuanbangjingtou','T','','http://www.egao8.cc/upload/vod/2015-10-14/14447999340.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','898','0','0','0','0','0','0','2.0','648','324','1457671588','1457671588','0','0','吐槽最美的时光穿帮镜头','youku','0','','160114655','','','','');
INSERT INTO `mac_vod` VALUES('1091','拿什么选帅首我的男神男神齐聚经典重现','','nashimexuanshuaishouwodenanshennanshenqijujingdianzhongxian','N','','http://www.egao8.cc/upload/vod/2015-10-14/14448008010.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','501','0','0','0','0','0','0','1.0','255','255','1457671588','1457671588','0','0','拿什么选帅首我的男神男神齐聚经典重现','youku','0','','XNzU5NTg4OTY4','','','','');
INSERT INTO `mac_vod` VALUES('1092','欧子最吐槽《愿得一小金人》小李不哭！','','ouzizuitucaoyuandeyixiaojinrenxiaolibuku','O','','http://www.egao8.cc/upload/vod/2015-10-14/14447999630.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','655','0','0','0','0','0','0','6.0','2556','426','1457671588','1457671588','0','0','欧子最吐槽《愿得一小金人》小李不哭！','youku','0','','XNjgwOTY4NTky','','','','');
INSERT INTO `mac_vod` VALUES('1093','帮我上头条吧》吐槽帮汪峰上头条','','bangwoshangtoutiaobatucaobangwangfengshangtoutiao','B','','http://www.egao8.cc/upload/vod/2015-10-14/14448000040.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','956','0','0','0','0','0','0','1.0','417','417','1457671588','1457671588','0','0','帮我上头条吧》吐槽帮汪峰上头条','youku','0','','XNjM0OTg5NDgw','','','','');
INSERT INTO `mac_vod` VALUES('1094','超雷霸气直译版爸爸去哪里','','chaoleibaqizhiyibanbabaqunali','C','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','222','0','0','0','0','0','0','4.0','668','167','1457671588','1457671588','0','0','超雷霸气直译版爸爸去哪里','youku','0','','XNjQ3NjEwNDI0','','','','');
INSERT INTO `mac_vod` VALUES('1095','风骚说唱穿外套的707号','','fengsaoshuochangchuanwaitaode707hao','F','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','737','0','0','0','0','0','0','10.0','1010','101','1457671588','1457671588','0','0','风骚说唱穿外套的707号','youku','0','','155407001','','','','');
INSERT INTO `mac_vod` VALUES('1096','唐唐神吐槽：女模特的爱情 [Big笑工坊]第九十九期 脱口秀 综艺 搞笑—专辑：《[Big笑工坊]官方专辑》','','tangtangshentucaonvmotedeaiqingBigxiaogongfangdijiushijiuqituokouxiuzongyigaoxiaozhuanjiBigxiaogongfangguanfangzhuanji','T','','http://www.egao8.cc/upload/vod/2015-10-14/14448007750.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','506','0','0','0','0','0','0','10.0','2520','252','1457671588','1457671588','0','0','唐唐神吐槽：女模特的爱情 【Big笑工坊】第九十九期 脱口秀 综艺 搞笑—专辑：《【Big笑工坊】官方专辑》','youku','0','','XOTAwNTg5NTYw','','','','');
INSERT INTO `mac_vod` VALUES('1097','刘德华再唱《回家的路》续曲：《返程的路》—专辑：《[优酷牛人] 恶搞先锋欧子歪歌优秀作品大合辑》','','liudehuazaichanghuijiadeluxuqufanchengdeluzhuanjiyoukuniurenegaoxianfengouziwaigeyouxiuzuopindaheji','L','','http://www.egao8.cc/upload/vod/2015-10-14/14448007450.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','500','0','0','0','0','0','0','8.0','3088','386','1457671588','1457671588','0','0','刘德华再唱《回家的路》续曲：《返程的路》—专辑：《【优酷牛人】 恶搞先锋欧子歪歌优秀作品大合辑》','youku','0','','XODk5ODc0Nzg4','','','','');
INSERT INTO `mac_vod` VALUES('1098','[欧子最吐槽70]点赞版《好大一个家》给复出荧屏的陈佩斯点赞！—专辑：《[优酷牛人] 恶搞先锋欧子歪歌优秀作品大合辑》','','ouzizuitucao70dianzanbanhaodayigejiageifuchuyingpingdechenpeisidianzanzhuanjiyoukuniurenegaoxianfengouziwaigeyouxiuzuopindaheji','O','','http://www.egao8.cc/upload/vod/2015-10-14/14448007170.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','912','0','0','0','0','0','0','10.0','1320','132','1457671588','1457671588','0','0','【欧子最吐槽70】点赞版《好大一个家》给复出荧屏的陈佩斯点赞！—专辑：《【优酷牛人】 恶搞先锋欧子歪歌优秀作品大合辑》','youku','0','','XODk3OTk3NTk2','','','','');
INSERT INTO `mac_vod` VALUES('1099','[欧子最吐槽69]《归家の天路》祝归家的儿女新春快乐！—专辑：《[优酷牛人] 恶搞先锋欧子歪歌优秀作品大合辑》','','ouzizuitucao69guijiatianluzhuguijiadeernvxinchunkuailezhuanjiyoukuniurenegaoxianfengouziwaigeyouxiuzuopindaheji','O','','http://www.egao8.cc/upload/vod/2015-10-14/14448000620.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','402','0','0','0','0','0','0','10.0','1000','100','1457671588','1457671588','0','0','【欧子最吐槽69】《归家の天路》祝归家的儿女新春快乐！—专辑：《【优酷牛人】 恶搞先锋欧子歪歌优秀作品大合辑》','youku','0','','XODk0OTQ2ODI0','','','','');
INSERT INTO `mac_vod` VALUES('1100','欧子最吐槽新天龙停播内幕','','ouzizuitucaoxintianlongtingbonamu','O','','http://www.egao8.cc/upload/vod/2015-10-14/14448000850.jpg','','','老湿','','','','大陆','','0','12','','','0','0','0','0','0','0','0','0','349','0','0','0','0','0','0','9.0','99','11','1457671588','1457671588','0','0','欧子最吐槽新天龙停播内幕','youku','0','','XNjcxNDAwMjg0','','','','');
INSERT INTO `mac_vod` VALUES('1101','为什么南方人比北方人起床晚？','','weishimenanfangrenbibeifangrenqichuangwan','W','','http://www.egao8.cc/upload/vod/2015-10-14/14447968572.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','99','0','0','0','0','0','0','8.0','2560','320','1457671707','1457671707','0','0','为什么南方人比北方人起床晚？','youku','0','','XOTI2MjUxMjMy','','','','');
INSERT INTO `mac_vod` VALUES('1102','全球性交易的态度','','quanqiuxingjiaoyidetaidu','Q','','http://www.egao8.cc/upload/vod/2015-10-14/144479697416.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','226','0','0','6','0','0','0','3.0','1026','342','1457671707','1457671707','1458431694','0','全球性交易的态度','youku','0','','XNjI1NzkzMjky','','','','');
INSERT INTO `mac_vod` VALUES('1103','三分钟看懂中国官员级别','','sanfenzhongkandongzhongguoguanyuanjibie','S','','http://www.egao8.cc/upload/vod/2015-10-14/14447969954.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','747','0','0','0','0','0','0','6.0','2256','376','1457671707','1457671707','0','0','三分钟看懂中国官员级别','youku','0','','XNjgxODI4OTcy','','','','');
INSERT INTO `mac_vod` VALUES('1104','老外的超国民待遇','','laowaidechaoguomindaiyu','L','','http://www.egao8.cc/upload/vod/2015-10-14/14447969976.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','434','0','0','0','0','0','0','6.0','1974','329','1457671707','1457671707','0','0','老外的超国民待遇','youku','0','','XNTgxOTM4MDI0','','','','');
INSERT INTO `mac_vod` VALUES('1105','一家媒体丧心病狂的自黑','','yijiameitisangxinbingkuangdezihei','Y','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','3','0','0','0','0','0','0','4.0','1376','344','1457671707','1457671707','0','0','一家媒体丧心病狂的自黑','youku','0','','XNjg4MjM5NDM2','','','','');
INSERT INTO `mac_vod` VALUES('1106','无处不在的中国游客已占领全世界了？  壹读视频','','wuchubuzaidezhongguoyoukeyizhanlingquanshijieliaoyidushipin','W','','http://www.egao8.cc/upload/vod/2015-10-14/14447970087.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','395','0','0','0','0','0','0','5.0','2120','424','1457671707','1457671707','0','0','无处不在的中国游客已占领全世界了？  壹读视频','youku','0','','XODAwNTI5Mjg0','','','','');
INSERT INTO `mac_vod` VALUES('1107','大家为什么都爱黑处女座？  壹读视频','','dajiaweishimeduaiheichunvzuoyidushipin','D','','http://www.xuduba.com/pic/uploadimg/2014-9/20149301712423565.jpg#err2015-10-14','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','22','0','0','0','0','0','0','8.0','432','54','1457671707','1457671707','0','0','大家为什么都爱黑处女座？  壹读视频','youku','0','','XNzkzMzUxMTE2','','','','');
INSERT INTO `mac_vod` VALUES('1108','你所不知道的阿里巴巴','','nisuobuzhidaodealibaba','N','','http://www.egao8.cc/upload/vod/2015-10-14/14447970099.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','11','0','0','0','0','0','0','3.0','993','331','1457671707','1457671707','0','0','你所不知道的阿里巴巴','youku','0','','XNzI5MDEyNjgw','','','','');
INSERT INTO `mac_vod` VALUES('1109','勤劳难致富的中国人','','qinlaonanzhifudezhongguoren','Q','','http://www.egao8.cc/upload/vod/2015-10-14/144479701010.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','461','0','0','0','0','0','0','9.0','747','83','1457671707','1457671707','0','0','勤劳难致富的中国人','youku','0','','XNzM1NzI1NzAw','','','','');
INSERT INTO `mac_vod` VALUES('1110','吐槽解说中国官员怕什么','','tucaojieshuozhongguoguanyuanpashime','T','','http://www.egao8.cc/upload/vod/2015-10-14/144479701111.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','688','0','0','0','0','0','0','8.0','16','2','1457671707','1457671707','0','0','吐槽解说中国官员怕什么','youku','0','','XNzEyNzYxOTc2','','','','');
INSERT INTO `mac_vod` VALUES('1111','手机奴隶','','shoujinuli','S','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','476','0','0','0','0','0','0','1.0','260','260','1457671707','1457671707','0','0','手机奴隶','youku','0','','XNjc1NTkyMDYw','','','','');
INSERT INTO `mac_vod` VALUES('1112','你真的了解母亲劫吗？','','nizhendeliaojiemuqinjiema','N','','http://www.egao8.cc/upload/vod/2015-10-14/144479701212.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','331','0','0','0','0','0','0','3.0','423','141','1457671707','1457671707','0','0','你真的了解母亲劫吗？','youku','0','','XNzA5NzAxMjQ0','','','','');
INSERT INTO `mac_vod` VALUES('1113','中国官员升迁指南','','zhongguoguanyuanshengqianzhinan','Z','','http://www.egao8.cc/upload/vod/2015-10-14/144479701613.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','724','0','0','0','0','0','0','4.0','648','162','1457671707','1457671707','0','0','中国官员升迁指南','youku','0','','XNDY5NzExNzMy','','','','');
INSERT INTO `mac_vod` VALUES('1114','你未必知道的\"思密达\"说明书','','niweibizhidaodesimidashuomingshu','N','','http://www.egao8.cc/upload/vod/2015-10-14/144479701814.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','347','0','0','0','0','0','0','6.0','1206','201','1457671707','1457671707','0','0','你未必知道的\"思密达\"说明书','youku','0','','XNzAzNDk2MjU2','','','','');
INSERT INTO `mac_vod` VALUES('1115','三分钟科普网球趣史','','sanfenzhongkepuwangqiuqushi','S','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','360','0','0','0','0','0','0','5.0','590','118','1457671707','1457671707','0','0','三分钟科普网球趣史','youku','0','','XNTg4OTkxNjgw','','','','');
INSERT INTO `mac_vod` VALUES('1116','黑社会勾引大嫂是禁忌 半数黑老大涉及房地产','','heishehuigouyindasaoshijinjibanshuheilaodashejifangdichan','H','','http://www.egao8.cc/upload/vod/2015-10-14/144479701915.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','643','0','0','0','0','0','0','8.0','3072','384','1457671707','1457671707','0','0','黑社会勾引大嫂是禁忌 半数黑老大涉及房地产','youku','0','','XNzAwNDg4MzM2','','','','');
INSERT INTO `mac_vod` VALUES('1117','我们的爱不脆弱','','womendeaibucuiruo','W','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','42','0','0','0','0','0','0','3.0','618','206','1457671707','1457671707','0','0','我们的爱不脆弱','youku','0','','XNTIwMjM3NDI4','','','','');
INSERT INTO `mac_vod` VALUES('1118','春节衣锦还乡指南','','chunjieyijinhuaixiangzhinan','C','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','624','0','0','0','0','0','0','9.0','1314','146','1457671707','1457671707','0','0','春节衣锦还乡指南','youku','0','','XNTEyOTc2MTY0','','','','');
INSERT INTO `mac_vod` VALUES('1119','美国总统是怎样炼成的?','','meiguozongtongshizenyanglianchengde','M','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','924','0','0','0','0','0','0','4.0','1012','253','1457671707','1457671707','0','0','美国总统是怎样炼成的?','youku','0','','XNDcxNjUyMDI4','','','','');
INSERT INTO `mac_vod` VALUES('1120','你真的了解我们的邻居吗？','','nizhendeliaojiewomendelinjima','N','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','197','0','0','0','0','0','0','1.0','187','187','1457671707','1457671707','0','0','你真的了解我们的邻居吗？','youku','0','','XNTY3OTI2NjEy','','','','');
INSERT INTO `mac_vod` VALUES('1121','你们家谁最闲？  壹读','','nimenjiashuizuixianyidu','N','','http://www.egao8.cc/upload/vod/2015-10-14/14447969506.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','556','0','0','0','0','0','0','8.0','2048','256','1457671718','1457671718','0','0','你们家谁最闲？  壹读','youku','0','','XNzg4MjM3NDM2','','','','');
INSERT INTO `mac_vod` VALUES('1122','化学元素决定了人类的爱情?  壹读','','huaxueyuansujuedingliaorenleideaiqingyidu','H','','http://www.egao8.cc/upload/vod/2015-10-14/14447969517.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','399','0','0','0','0','0','0','4.0','1916','479','1457671718','1457671718','0','0','化学元素决定了人类的爱情?  壹读','youku','0','','XNzgwNTEwODA4','','','','');
INSERT INTO `mac_vod` VALUES('1123','粽子大战:你是咸党还是甜党','','zongzidazhannishixiandanghuaishitiandang','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14447969528.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','871','0','0','0','0','0','0','3.0','318','106','1457671718','1457671718','0','0','粽子大战:你是咸党还是甜党','youku','0','','XNzE5MzA2MTg0','','','','');
INSERT INTO `mac_vod` VALUES('1124','人类为什么爱八卦','','renleiweishimeaibagua','R','','http://www.egao8.cc/upload/vod/2015-10-14/14447969539.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','944','0','0','0','0','0','0','8.0','3240','405','1457671718','1457671718','0','0','人类为什么爱八卦','youku','0','','XNzUyNzY4ODk2','','','','');
INSERT INTO `mac_vod` VALUES('1125','中纪委办案步骤大起底 官员一年出差300天','','zhongjiweibananbuzhoudaqidiguanyuanyinianchucha300tian','Z','','http://www.egao8.cc/upload/vod/2015-10-14/144479695410.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','809','0','0','0','0','0','0','7.0','14','2','1457671718','1457671718','0','0','中纪委办案步骤大起底 官员一年出差300天','youku','0','','XNjg0Njc4NTU2','','','','');
INSERT INTO `mac_vod` VALUES('1126','其实很屌丝的日本右翼','','qishihensideribenyouyi','Q','','http://www.egao8.cc/upload/vod/2015-10-14/144479695511.gif','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','127','0','0','0','0','0','0','3.0','27','9','1457671718','1457671718','0','0','其实很屌丝的日本右翼','youku','0','','XNjk3NDQzMDQw','','','','');
INSERT INTO `mac_vod` VALUES('1127','人类从什么时候开始以瘦为美的','','renleicongshimeshihoukaishiyishouweimeide','R','','http://www.egao8.cc/upload/vod/2015-10-14/144479696012.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','276','0','0','0','0','0','0','5.0','735','147','1457671718','1457671718','0','0','人类从什么时候开始以瘦为美的','youku','0','','XNzU5ODc3Njc2','','','','');
INSERT INTO `mac_vod` VALUES('1128','春节返乡反逼婚指南','','chunjiefanxiangfanbihunzhinan','C','','http://www.egao8.cc/upload/vod/2015-10-14/144479697113.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','605','0','0','0','0','0','0','7.0','2590','370','1457671718','1457671718','0','0','春节返乡反逼婚指南','youku','0','','XNjY1NTM5Mjky','','','','');
INSERT INTO `mac_vod` VALUES('1129','不忍直视的大学专业真相','','burenzhishidedaxuezhuanyezhenxiang','B','','http://www.egao8.cc/upload/vod/2015-10-14/144479697214.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','679','0','0','0','0','0','0','3.0','1482','494','1457671718','1457671718','0','0','不忍直视的大学专业真相','youku','0','','XNzMyNDc2MDg0','','','','');
INSERT INTO `mac_vod` VALUES('1130','高端黑中国功夫到底能不能打','','gaoduanheizhongguogongfudaodinenbunenda','G','','http://www.egao8.cc/upload/vod/2015-10-14/144479697315.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','534','0','0','0','0','0','0','6.0','1896','316','1457671718','1457671718','0','0','高端黑中国功夫到底能不能打','youku','0','','XNzQ5MzU4NjIw','','','','');
INSERT INTO `mac_vod` VALUES('1131','中国足协不想让你知道的事','','zhongguozuxiebuxiangrangnizhidaodeshi','Z','','http://www.egao8.cc/upload/vod/2015-10-14/144479697517.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','924','0','0','0','0','0','0','5.0','1230','246','1457671718','1457671718','0','0','中国足协不想让你知道的事','youku','0','','XNzIyNjEyMDc2','','','','');
INSERT INTO `mac_vod` VALUES('1132','日本人为什么不乱丢垃圾','','ribenrenweishimebuluandinglaji','R','','http://www.egao8.cc/upload/vod/2015-10-14/144479697618.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','571','0','0','0','0','0','0','1.0','425','425','1457671718','1457671718','0','0','日本人为什么不乱丢垃圾','youku','0','','XNzQyNDgxNzIw','','','','');
INSERT INTO `mac_vod` VALUES('1133','三分钟科普五险一金','','sanfenzhongkepuwuxianyijin','S','','http://www.egao8.cc/upload/vod/2015-10-14/144479697719.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','417','0','0','0','0','0','0','8.0','2856','357','1457671718','1457671718','0','0','三分钟科普五险一金','youku','0','','154983309','','','','');
INSERT INTO `mac_vod` VALUES('1134','中国人的养老大业','','zhongguorendeyanglaodaye','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14447969891.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','872','0','0','0','0','0','0','7.0','182','26','1457671718','1457671718','0','0','中国人的养老大业','youku','0','','161143576','','','','');
INSERT INTO `mac_vod` VALUES('1135','最靠谱的中国人性福指数','','zuikaopudezhongguorenxingfuzhishu','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14447969902.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','64','0','0','0','0','0','0','5.0','145','29','1457671718','1457671718','0','0','最靠谱的中国人性福指数','youku','0','','XNjk0Mjk3ODEy','','','','');
INSERT INTO `mac_vod` VALUES('1136','日本首相为什么换得那么多?','','ribenshouxiangweishimehuandenameduo','R','','http://www.egao8.cc/upload/vod/2015-10-14/14447969913.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','92','0','0','0','0','0','0','4.0','784','196','1457671718','1457671718','0','0','日本首相为什么换得那么多?','youku','0','','XNDg2NzkxOTMy','','','','');
INSERT INTO `mac_vod` VALUES('1137','让孩子先走','','ranghaizixianzou','R','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','272','0','0','0','0','0','0','5.0','1080','216','1457671718','1457671718','0','0','让孩子先走','youku','0','','XNDUyOTkwMjE2','','','','');
INSERT INTO `mac_vod` VALUES('1138','中国精英移民地图','','zhongguojingyingyiminditu','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14447969965.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','388','0','0','0','0','0','0','7.0','1841','263','1457671718','1457671718','0','0','中国精英移民地图','youku','0','','XNDM4NTgwNTM2','','','','');
INSERT INTO `mac_vod` VALUES('1139','悲催的伦敦奥组委','','beicuidelundunaozuwei','B','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','946','0','0','0','0','0','0','8.0','960','120','1457671718','1457671718','0','0','悲催的伦敦奥组委','youku','0','','XNDMxNDk2MDIw','','','','');
INSERT INTO `mac_vod` VALUES('1140','防身工具并不\"防身\"','','fangshengongjubingbufangshen','F','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','417','0','0','0','0','0','0','7.0','2142','306','1457671718','1457671718','0','0','防身工具并不\"防身\"','youku','0','','XNjkxMjQ4MzQ0','','','','');
INSERT INTO `mac_vod` VALUES('1141','[哇哈哦哦]3岁超萌小萝莉学习跆拳道—专辑：《萝莉正太合辑，卖萌到底哪家强？》','','wahaouou3suichaomengxiaoluolixuexitaiquandaozhuanjiluolizhengtaihejimaimengdaodinajiaqiang','W','','http://www.egao8.cc/upload/vod/2015-10-14/14447969053.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','494','0','0','0','0','0','0','5.0','980','196','1457671732','1457671732','0','0','【哇哈哦哦】3岁超萌小萝莉学习跆拳道—专辑：《萝莉正太合辑，卖萌到底哪家强？》','youku','0','','XODk4NjA2ODgw','','','','');
INSERT INTO `mac_vod` VALUES('1142','食物残留激素其实对人体无害?  食物残留激素其实对人体无害','','shiwucanliujisuqishiduirentiwuhaishiwucanliujisuqishiduirentiwuhai','S','','http://www.egao8.cc/upload/vod/2015-10-14/14447969054.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','335','0','0','0','0','0','0','9.0','1368','152','1457671732','1457671732','0','0','食物残留激素其实对人体无害?  食物残留激素其实对人体无害','youku','0','','XOTE2MzAzNDQw','','','','');
INSERT INTO `mac_vod` VALUES('1143','奶牛有公的吗？  涨姿势','','nainiuyougongdemazhangzishi','N','','http://www.egao8.cc/upload/vod/2015-10-14/14447969075.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','820','0','0','0','0','0','0','7.0','1015','145','1457671732','1457671732','0','0','奶牛有公的吗？  涨姿势','youku','0','','XODYwMzIzNDY4','','','','');
INSERT INTO `mac_vod` VALUES('1144','5分鐘看完10小時的魔戒1-3集—专辑：《[谷阿莫神解说]几分钟带你看完各种电影大片》','','5fenkanwan10xiaodemojie13jizhuanjiguamoshenjieshuojifenzhongdainikanwangezhongdianyingdapian','5','','http://www.egao8.cc/upload/vod/2015-10-14/14447969096.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','797','0','0','0','0','0','0','4.0','1520','380','1457671732','1457671732','0','0','5分鐘看完10小時的魔戒1-3集—专辑：《【谷阿莫神解说】几分钟带你看完各种电影大片》','youku','0','','XOTA0NzkyOTIw','','','','');
INSERT INTO `mac_vod` VALUES('1145','不健康三部曲之一:你肾虚了吗?  壹读视频','','bujiankangsanbuquzhiyinishenxuliaomayidushipin','B','','http://www.egao8.cc/upload/vod/2015-10-14/14447969108.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','333','0','0','0','0','0','0','2.0','844','422','1457671732','1457671732','0','0','不健康三部曲之一:你肾虚了吗?  壹读视频','youku','0','','XODU3MzUzNzQ4','','','','');
INSERT INTO `mac_vod` VALUES('1146','四种血型各有什么致命弱点？  壹读','','sizhongxuexinggeyoushimezhimingruodianyidu','S','','http://www.egao8.cc/upload/vod/2015-10-14/14447969119.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','961','0','0','0','0','0','0','6.0','1914','319','1457671732','1457671732','0','0','四种血型各有什么致命弱点？  壹读','youku','0','','XODgyOTMxNzIw','','','','');
INSERT INTO `mac_vod` VALUES('1147','未来属于创造它的人  壹读','','weilaishuyuchuangzaotaderenyidu','W','','http://www.egao8.cc/upload/vod/2015-10-14/144479691311.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','937','0','0','0','0','0','0','3.0','687','229','1457671732','1457671732','0','0','未来属于创造它的人  壹读','youku','0','','XODU3NDI2ODQ4','','','','');
INSERT INTO `mac_vod` VALUES('1148','不健康三部曲之三:不靠谱的大补  壹读视频','','bujiankangsanbuquzhisanbukaopudedabuyidushipin','B','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','482','0','0','0','0','0','0','7.0','315','45','1457671732','1457671732','0','0','不健康三部曲之三:不靠谱的大补  壹读视频','youku','0','','XODc4MDg0MjE2','','','','');
INSERT INTO `mac_vod` VALUES('1149','看视频会上瘾是一种病,需要治吗?  壹读视频','','kanshipinhuishangyinshiyizhongbingxuyaozhimayidushipin','K','','http://www.egao8.cc/upload/vod/2015-10-14/144479691812.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','39','0','0','0','0','0','0','8.0','152','19','1457671732','1457671732','0','0','看视频会上瘾是一种病,需要治吗?  壹读视频','youku','0','','XODY3NTcxMTA4','','','','');
INSERT INTO `mac_vod` VALUES('1150','中国人的钱都去哪儿了？  十年算总账','','zhongguorendeqianduqunaerliaoshiniansuanzongzhang','Z','','http://www.egao8.cc/upload/vod/2015-10-14/144479692014.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','517','0','0','0','0','0','0','10.0','3880','388','1457671732','1457671732','0','0','中国人的钱都去哪儿了？  十年算总账','youku','0','','XODQ0Mzg4MDI4','','','','');
INSERT INTO `mac_vod` VALUES('1151','人人都在谈创业，你该怎么办  壹读','','renrenduzaitanchuangyenigaizenmebanyidu','R','','http://www.egao8.cc/upload/vod/2015-10-14/144479692215.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','545','0','0','0','0','0','0','9.0','4464','496','1457671732','1457671732','0','0','人人都在谈创业，你该怎么办  壹读','youku','0','','XODMwNjc0MzU2','','','','');
INSERT INTO `mac_vod` VALUES('1152','武侠小说里的门派真的存在吗？  壹读视频','','wuxiaxiaoshuolidemenpaizhendecunzaimayidushipin','W','','http://www.egao8.cc/upload/vod/2015-10-14/144479692416.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','722','0','0','0','0','0','0','8.0','3400','425','1457671732','1457671732','0','0','武侠小说里的门派真的存在吗？  壹读视频','youku','0','','XODUyMjI4MTQw','','','','');
INSERT INTO `mac_vod` VALUES('1153','为什么西方人用刀叉 中国人用筷子  壹读视频','','weishimexifangrenyongdaochazhongguorenyongkuaiziyidushipin','W','','http://www.egao8.cc/upload/vod/2015-10-14/144479692617.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','862','0','0','0','0','0','0','5.0','565','113','1457671732','1457671732','0','0','为什么西方人用刀叉 中国人用筷子  壹读视频','youku','0','','XODE1NzMzODQw','','','','');
INSERT INTO `mac_vod` VALUES('1154','[纯干货]双十一省钱还赚钱扫货全攻略  壹读','','chunganhuoshuangshiyishengqianhuaizhuanqiansaohuoquangonglueyidu','C','','http://www.egao8.cc/upload/vod/2015-10-14/144479692718.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','253','0','0','0','0','0','0','4.0','1936','484','1457671732','1457671732','0','0','【纯干货】双十一省钱还赚钱扫货全攻略  壹读','youku','0','','XODE5NTQxODg4','','','','');
INSERT INTO `mac_vod` VALUES('1155','中国有哪些传统美食是骗人的  壹读','','zhongguoyounaxiechuantongmeishishipianrendeyidu','Z','','http://www.egao8.cc/upload/vod/2015-10-14/144479692919.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','896','0','0','0','0','0','0','8.0','576','72','1457671732','1457671732','0','0','中国有哪些传统美食是骗人的  壹读','youku','0','','XODA1MzcxNzY0','','','','');
INSERT INTO `mac_vod` VALUES('1156','关于秋裤 听听时尚达人壹读君怎么说  壹读视频','','guanyuqiukutingtingshishangdarenyidujunzenmeshuoyidushipin','G','','http://www.egao8.cc/upload/vod/2015-10-14/14447969391.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','766','0','0','0','0','0','0','10.0','1440','144','1457671732','1457671732','0','0','关于秋裤 听听时尚达人壹读君怎么说  壹读视频','youku','0','','XODEwNDk3Mjgw','','','','');
INSERT INTO `mac_vod` VALUES('1157','为什么毒品让人上瘾,戒毒又为何这么难?  壹读视频','','weishimedupinrangrenshangyinjieduyouweihezhemenanyidushipin','W','','http://www.egao8.cc/upload/vod/2015-10-14/14447969432.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','53','0','0','0','0','0','0','6.0','1962','327','1457671732','1457671732','0','0','为什么毒品让人上瘾,戒毒又为何这么难?  壹读视频','youku','0','','XNzkxMTY1MTQ4','','','','');
INSERT INTO `mac_vod` VALUES('1158','盘点那些牛到令人发指的浙江人  壹读','','pandiannaxieniudaolingrenfazhidezhejiangrenyidu','P','','http://www.egao8.cc/upload/vod/2015-10-14/14447969443.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','418','0','0','0','0','0','0','10.0','2330','233','1457671732','1457671732','0','0','盘点那些牛到令人发指的浙江人  壹读','youku','0','','XODA0ODM2OTMy','','','','');
INSERT INTO `mac_vod` VALUES('1159','中国的演唱会为什么那么贵','','zhongguodeyanchanghuiweishimenamegui','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14447969454.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','239','0','0','0','0','0','0','2.0','162','81','1457671732','1457671732','0','0','中国的演唱会为什么那么贵','youku','0','','XNzM5MDIwNDcy','','','','');
INSERT INTO `mac_vod` VALUES('1160','有一种旅行,叫别人的旅行  壹读视频','','youyizhonglvxingjiaobierendelvxingyidushipin','Y','','http://www.egao8.cc/upload/vod/2015-10-14/14447969495.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','865','0','0','0','0','0','0','5.0','1640','328','1457671732','1457671732','0','0','有一种旅行,叫别人的旅行  壹读视频','youku','0','','XNzg2MjYwMTI4','','','','');
INSERT INTO `mac_vod` VALUES('1161','不健康三部曲之二:你上火了吗?  壹读视频','','bujiankangsanbuquzhiernishanghuoliaomayidushipin','B','','http://www.egao8.cc/upload/vod/2015-10-14/144479684615.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','664','0','0','0','0','0','0','8.0','2712','339','1457671744','1457671744','0','0','不健康三部曲之二:你上火了吗?  壹读视频','youku','0','','XODczMTMwMTI4','','','','');
INSERT INTO `mac_vod` VALUES('1162','[轻松时刻]Duang！有一种意外叫乐极生悲—专辑：《发现生活笑点，感受[轻松时刻]！》','','qingsongshikeDuangyouyizhongyiwaijiaolejishengbeizhuanjifaxianshenghuoxiaodianganshouqingsongshike','Q','','http://www.egao8.cc/upload/vod/2015-10-14/144479685019.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','767','0','0','0','0','0','0','2.0','924','462','1457671744','1457671744','0','0','【轻松时刻】Duang！有一种意外叫乐极生悲—专辑：《发现生活笑点，感受【轻松时刻】！》','youku','0','','XOTAwNzg2MDUy','','','','');
INSERT INTO `mac_vod` VALUES('1163','安全驾驶行为5大准则  壹读2015新作品','','anquanjiashixingwei5dazhunzeyidu2015xinzuopin','A','','http://www.egao8.cc/upload/vod/2015-10-14/14447968561.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','417','0','0','0','0','0','0','10.0','2910','291','1457671744','1457671744','0','0','安全驾驶行为5大准则  壹读2015新作品','youku','0','','XODY0MjIyOTE2','','','','');
INSERT INTO `mac_vod` VALUES('1164','关心她,就要了解她的亲戚--大姨妈  壹读视频','','guanxintajiuyaoliaojietadeqinqidayimayidushipin','G','','http://www.egao8.cc/upload/vod/2015-10-14/14447968593.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','243','0','0','0','0','0','0','4.0','692','173','1457671744','1457671744','0','0','关心她,就要了解她的亲戚--大姨妈  壹读视频','youku','0','','XODQ3MjYyNjEy','','','','');
INSERT INTO `mac_vod` VALUES('1165','习大大看博鳌的视频和壹读君有啥关系？你懂的  习大大看博鳌','','xidadakanboaodeshipinheyidujunyoushaguanxinidongdexidadakanboao','X','','http://www.egao8.cc/upload/vod/2015-10-14/14447968614.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','841','0','0','0','0','0','0','1.0','187','187','1457671744','1457671744','0','0','习大大看博鳌的视频和壹读君有啥关系？你懂的  习大大看博鳌','youku','0','','XOTE5OTg1NTI0','','','','');
INSERT INTO `mac_vod` VALUES('1166','不同省份的中国人,容易得什么病  壹读','','butongshengfendezhongguorenrongyideshimebingyidu','B','','http://www.egao8.cc/upload/vod/2015-10-14/14447968635.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','28','0','0','0','0','0','0','6.0','1644','274','1457671744','1457671744','0','0','不同省份的中国人,容易得什么病  壹读','youku','0','','XODQyMjQ1NjA0','','','','');
INSERT INTO `mac_vod` VALUES('1167','壹读独家揭秘，鹅厂求职指南  鹅厂','','yidudujiajiemiechangqiuzhizhinanechang','Y','','http://www.egao8.cc/upload/vod/2015-10-14/14447968656.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','90','0','0','0','0','0','0','5.0','1780','356','1457671744','1457671744','0','0','壹读独家揭秘，鹅厂求职指南  鹅厂','youku','0','','XOTE2Mjg2NzMy','','','','');
INSERT INTO `mac_vod` VALUES('1168','有钱没钱都不能任性的西餐礼仪  壹读视频','','youqianmeiqiandubunenrenxingdexicanliyiyidushipin','Y','','http://www.egao8.cc/upload/vod/2015-10-14/14447968677.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','31','0','0','0','0','0','0','10.0','4670','467','1457671744','1457671744','0','0','有钱没钱都不能任性的西餐礼仪  壹读视频','youku','0','','XODMxNjI5Njk2','','','','');
INSERT INTO `mac_vod` VALUES('1169','[飞碟唱]天蝎座之歌—专辑：《[飞碟唱]》','','feidiechangtianxiezuozhigezhuanjifeidiechang','F','','http://www.egao8.cc/upload/vod/2015-10-14/14447968698.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','823','0','0','0','0','0','0','4.0','1500','375','1457671744','1457671744','0','0','【飞碟唱】天蝎座之歌—专辑：《【飞碟唱】》','youku','0','','XODk5MTA4MDky','','','','');
INSERT INTO `mac_vod` VALUES('1170','走近科学——壹读君解密南方不装暖气之谜  壹读','','zoujinkexueyidujunjieminanfangbuzhuangnuanqizhimiyidu','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14447968699.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','657','0','0','0','0','0','0','4.0','828','207','1457671744','1457671744','0','0','走近科学——壹读君解密南方不装暖气之谜  壹读','youku','0','','XODIxNDEzNzk2','','','','');
INSERT INTO `mac_vod` VALUES('1171','除了扎堆看人海，放假还能干点啥？','','chuliaozhaduikanrenhaifangjiahuainengandiansha','C','','http://www.egao8.cc/upload/vod/2015-10-14/144479687111.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','193','0','0','0','0','0','0','3.0','219','73','1457671744','1457671744','0','0','除了扎堆看人海，放假还能干点啥？','youku','0','','XMTI2NTkzOTQ3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1172','哪7个人代表了中国几十万记者？嘿，有壹读君  壹读','','na7gerendaibiaoliaozhongguojishiwanjizheheiyouyidujunyidu','N','','http://www.egao8.cc/upload/vod/2015-10-14/144479687312.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','812','0','0','0','0','0','0','1.0','195','195','1457671744','1457671744','0','0','哪7个人代表了中国几十万记者？嘿，有壹读君  壹读','youku','0','','XODIwNDIyNjIw','','','','');
INSERT INTO `mac_vod` VALUES('1173','2015学车学车视频场地考试c1科目二','','2015xuechexuecheshipinchangdikaoshic1kemuer','2','','http://www.egao8.cc/upload/vod/2015-10-14/144479687614.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','859','0','0','0','0','0','0','2.0','56','28','1457671744','1457671744','0','0','2015学车学车视频场地考试c1科目二','youku','0','','XMTI2Mjk4NDUxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1174','壹读视频动画制作教程  壹读视频','','yidushipindonghuazhizuojiaochengyidushipin','Y','','http://www.egao8.cc/upload/vod/2015-10-14/144479687715.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','902','0','0','0','0','0','0','9.0','3474','386','1457671744','1457671744','0','0','壹读视频动画制作教程  壹读视频','youku','0','','XMTI2MjcwNDQwNA==','','','','');
INSERT INTO `mac_vod` VALUES('1175','你的家乡排第几？高考hard模式，','','nidejiaxiangpaidijigaokaohardmoshi','N','','http://www.egao8.cc/upload/vod/2015-10-14/144479688316.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','976','0','0','0','0','0','0','5.0','340','68','1457671744','1457671744','0','0','你的家乡排第几？高考hard模式，','youku','0','','XMTI1NTUxMTE0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1176','八一八堕胎人流背后吓尿的真相！所有女孩子都应该看看  清明特别策划','','bayibaduotairenliubeihouxianiaodezhenxiangsuoyounvhaiziduyinggaikankanqingmingtebiecehua','B','','http://www.egao8.cc/upload/vod/2015-10-14/144479688517.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','834','0','0','0','0','0','0','10.0','4820','482','1457671744','1457671744','0','0','八一八堕胎人流背后吓尿的真相！所有女孩子都应该看看  清明特别策划','youku','0','','XOTI2MDQ5MzQw','','','','');
INSERT INTO `mac_vod` VALUES('1177','中国的地名越改越没文化吗？','','zhongguodedimingyuegaiyuemeiwenhuama','Z','','http://www.egao8.cc/upload/vod/2015-10-14/144479688818.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','200','0','0','0','0','0','0','5.0','1355','271','1457671744','1457671744','0','0','中国的地名越改越没文化吗？','youku','0','','XOTU2NDAwODc2','','','','');
INSERT INTO `mac_vod` VALUES('1178','1块钱的成本卖100，为啥不犯法？  1块钱的成本卖100','','1kuaiqiandechengbenmai100weishabufanfa1kuaiqiandechengbenmai100','1','','http://www.egao8.cc/upload/vod/2015-10-14/144479689019.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','17','0','0','2','0','0','0','3.0','1311','437','1457671744','1457671744','1457755928','0','1块钱的成本卖100，为啥不犯法？  1块钱的成本卖100','youku','0','','XOTIxMjM5MjEy','','','','');
INSERT INTO `mac_vod` VALUES('1179','中国哪儿的人最能喝？  哪儿的人最能喝','','zhongguonaerderenzuinenhenaerderenzuinenhe','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14447969011.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','688','0','0','0','0','0','0','5.0','2325','465','1457671744','1457671744','0','0','中国哪儿的人最能喝？  哪儿的人最能喝','youku','0','','XOTM1ODYwOTEy','','','','');
INSERT INTO `mac_vod` VALUES('1180','三分钟为你解密中国最大的视频网站  中国最大的视频网站','','sanfenzhongweinijiemizhongguozuidadeshipinwangzhanzhongguozuidadeshipinwangzhan','S','','http://www.egao8.cc/upload/vod/2015-10-14/14447969032.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','349','0','0','0','0','0','0','9.0','4077','453','1457671744','1457671744','0','0','三分钟为你解密中国最大的视频网站  中国最大的视频网站','youku','0','','XOTE5MjM1MTQw','','','','');
INSERT INTO `mac_vod` VALUES('1181','普嘉贝尔带你深挖童装金矿  带你深挖童装金矿','','pujiabeierdainishenwatongzhuangjinkuangdainishenwatongzhuangjinkuang','P','','http://www.egao8.cc/upload/vod/2015-10-14/144479676915.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','863','0','0','2','0','0','0','4.0','1152','288','1457671754','1457671754','1458477289','0','普嘉贝尔带你深挖童装金矿  带你深挖童装金矿','youku','0','','XMTI3NDcxNDI5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1182','股市赚钱如何花 男藏私房女整形?  股市赚钱如何花','','gushizhuanqianruhehuanancangsifangnvzhengxinggushizhuanqianruhehua','G','','http://www.egao8.cc/upload/vod/2015-10-14/144479677518.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','267','0','0','4','0','0','0','10.0','2590','259','1457671754','1457671754','1458478629','0','股市赚钱如何花 男藏私房女整形?  股市赚钱如何花','youku','0','','XMTI3NjI1OTYxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1183','一个视频，让你读懂什么是父爱  一个视频','','yigeshipinrangnidudongshimeshifuaiyigeshipin','Y','','http://www.egao8.cc/upload/vod/2015-10-14/14447967853.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','824','0','0','0','0','0','0','4.0','596','149','1457671754','1457671754','0','0','一个视频，让你读懂什么是父爱  一个视频','youku','0','','XMTI3Mzg2MTAzNg==','','','','');
INSERT INTO `mac_vod` VALUES('1184','美甲基础基础-美甲教程视频  美甲基础基础','','meijiajichujichumeijiajiaochengshipinmeijiajichujichu','M','','http://www.egao8.cc/upload/vod/2015-10-14/14447967885.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','268','0','0','0','0','0','0','6.0','612','102','1457671754','1457671754','0','0','美甲基础基础-美甲教程视频  美甲基础基础','youku','0','','XMTI3MjE1NDE5Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1185','搞定自驾九九八十一难！你也可以  你也可以','','gaodingzijiajiujiubashiyinanniyekeyiniyekeyi','G','','http://www.egao8.cc/upload/vod/2015-10-14/14447967918.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','536','0','0','0','0','0','0','1.0','119','119','1457671754','1457671754','0','0','搞定自驾九九八十一难！你也可以  你也可以','youku','0','','XMTI3MTIxMTE2NA==','','','','');
INSERT INTO `mac_vod` VALUES('1186','中谷教育-Python视频教程-32-文件-1-文件读写  视频','','zhonggujiaoyuPythonshipinjiaocheng32wenjian1wenjianduxieshipin','Z','','http://www.egao8.cc/upload/vod/2015-10-14/144479680011.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','38','0','0','0','0','0','0','8.0','1496','187','1457671754','1457671754','0','0','中谷教育-Python视频教程-32-文件-1-文件读写  视频','youku','0','','XMTI2NzYxMjY5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1187','搞笑暖心的p2p平台安诚金融1+1贷完整版flash病毒动画展示广告','','gaoxiaonuanxindep2ppingtaianchengjinrong11daiwanzhengbanflashbingdudonghuazhanshiguanggao','G','','http://www.egao8.cc/upload/vod/2015-10-14/144479680715.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','902','0','0','0','0','0','0','6.0','2406','401','1457671754','1457671754','0','0','搞笑暖心的p2p平台安诚金融1+1贷完整版flash病毒动画展示广告','youku','0','','XMTI2MzU4OTk0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1188','上海人是真精明还是假精明','','shanghairenshizhenjingminghuaishijiajingming','S','','http://www.egao8.cc/upload/vod/2015-10-14/144479680916.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','227','0','0','0','0','0','0','6.0','546','91','1457671754','1457671754','0','0','上海人是真精明还是假精明','youku','0','','XMTI2MTM5NjEwNA==','','','','');
INSERT INTO `mac_vod` VALUES('1189','为啥中国人车技不好还容易犯路怒？','','weishazhongguorenchejibuhaohuairongyifanlunu','W','','http://www.egao8.cc/upload/vod/2015-10-14/144479681619.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','328','0','0','0','0','0','0','9.0','4023','447','1457671754','1457671754','0','0','为啥中国人车技不好还容易犯路怒？','youku','0','','XMTI2MDk1NTAxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1190','壹读君教你如何应对周末“钱包劫”  壹读君教','','yidujunjiaoniruheyingduizhoumoqianbaojieyidujunjiao','Y','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','992','0','0','0','0','0','0','5.0','715','143','1457671754','1457671754','0','0','壹读君教你如何应对周末“钱包劫”  壹读君教','youku','0','','XMTI1OTk5NTg1Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1191','新世纪十大奇葩定律[上]—专辑：《yp杨英鹏帅气大吐槽经典合辑，欢迎围观爆顶》','','xinshijishidaqipadinglvshangzhuanjiypyangyingpengshuaiqidatucaojingdianhejihuanyingweiguanbaoding','X','','http://www.egao8.cc/upload/vod/2015-10-14/14447968312.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','721','0','0','0','0','0','0','1.0','461','461','1457671754','1457671754','0','0','新世纪十大奇葩定律（上）—专辑：《yp杨英鹏帅气大吐槽经典合辑，欢迎围观爆顶》','youku','0','','XOTQyNjU3ODA4','','','','');
INSERT INTO `mac_vod` VALUES('1192','手机是如何暴露你的?  壹读视频：科技改变生活系列之一:','','shoujishiruhebaolunideyidushipinkejigaibianshenghuoxiliezhiyi','S','','http://www.egao8.cc/upload/vod/2015-10-14/14447968323.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','990','0','0','0','0','0','0','6.0','2520','420','1457671754','1457671754','0','0','手机是如何暴露你的?  壹读视频：科技改变生活系列之一:','youku','0','','XMTI0OTEwMjI1Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1193','柴油车尾气处理液与柴油机的逆袭','','chaiyoucheweiqichuliyeyuchaiyoujidenixi','C','','http://www.egao8.cc/upload/vod/2015-10-14/14447968345.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','488','0','0','0','0','0','0','1.0','396','396','1457671754','1457671754','0','0','柴油车尾气处理液与柴油机的逆袭','youku','0','','XOTU5NDU2MTEy','','','','');
INSERT INTO `mac_vod` VALUES('1194','[一剪你就笑]五一长假大作战—专辑：《[优酷搞笑]各种跨国界版逆天配音，无节操无底线~》','','yijiannijiuxiaowuyichangjiadazuozhanzhuanjiyoukugaoxiaogezhongkuaguojiebannitianpeiyinwujiecaowudixian','Y','','http://www.egao8.cc/upload/vod/2015-10-14/14447968366.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','376','0','0','0','0','0','0','4.0','1004','251','1457671754','1457671754','0','0','【一剪你就笑】五一长假大作战—专辑：《【优酷搞笑】各种跨国界版逆天配音，无节操无底线~》','youku','0','','XOTQyNzMyMjI4','','','','');
INSERT INTO `mac_vod` VALUES('1195','丝袜的魔性究竟在哪?  女爱穿男爱看','','siwademoxingjiujingzainanvaichuannanaikan','S','','http://www.egao8.cc/upload/vod/2015-10-14/14447968367.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','533','0','0','0','0','0','0','2.0','910','455','1457671754','1457671754','0','0','丝袜的魔性究竟在哪?  女爱穿男爱看','youku','0','','XOTYxNTg3MTMy','','','','');
INSERT INTO `mac_vod` VALUES('1196','中国人的全球海淘地图','','zhongguorendequanqiuhaitaoditu','Z','','http://www.egao8.cc/upload/vod/2015-10-14/14447968399.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','807','0','0','0','0','0','0','10.0','2130','213','1457671754','1457671754','0','0','中国人的全球海淘地图','youku','0','','XOTUwODg4MzAw','','','','');
INSERT INTO `mac_vod` VALUES('1197','金灶沐：小表砸，你解一下duang是啥意思？—专辑：《[优酷牛人]金灶沐恶搞配音系列》','','jinzaomuxiaobiaozanijieyixiaduangshishayisizhuanjiyoukuniurenjinzaomuegaopeiyinxilie','J','','http://www.egao8.cc/upload/vod/2015-10-14/144479684211.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','264','0','0','0','0','0','0','10.0','910','91','1457671754','1457671754','0','0','金灶沐：小表砸，你解一下duang是啥意思？—专辑：《【优酷牛人】金灶沐恶搞配音系列》','youku','0','','XOTAyNDAzODUy','','','','');
INSERT INTO `mac_vod` VALUES('1198','中国不同地区份子钱行情大揭秘','','zhongguobutongdiqufenziqianxingqingdajiemi','Z','','http://www.egao8.cc/upload/vod/2015-10-14/144479684313.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','440','0','0','0','0','0','0','8.0','1088','136','1457671754','1457671754','0','0','中国不同地区份子钱行情大揭秘','youku','0','','XOTQ0NzMyNzY4','','','','');
INSERT INTO `mac_vod` VALUES('1199','中国式地域歧视：有血有泪还有史','','zhongguoshidiyuqishiyouxueyouleihuaiyoushi','Z','','http://www.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','587','0','0','0','0','0','0','10.0','70','7','1457671754','1457671754','0','0','中国式地域歧视：有血有泪还有史','youku','0','','XOTMxMDQyNjMy','','','','');
INSERT INTO `mac_vod` VALUES('1200','大学专业“钱途”哪家强  大学专业','','daxuezhuanyeqiantunajiaqiangdaxuezhuanye','D','','http://www.egao8.cc/upload/vod/2015-10-14/144479684817.png','','','老湿','','','','大陆','','0','15','','','0','0','0','0','0','0','0','0','929','0','0','0','0','0','0','10.0','970','97','1457671754','1457671754','0','0','大学专业“钱途”哪家强  大学专业','youku','0','','XOTQwOTU0OTAw','','','','');
INSERT INTO `mac_vod` VALUES('1201','爆笑恶搞EXO《杀猪的》 字幕组又赢了','','baoxiaoegaoEXOshazhudezimuzuyouyingliao','B','','http://www.egao8.cc/upload/vod/2016-02-23/145618867718.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','908','0','0','0','0','0','0','8.0','1256','157','1457671779','1457671779','0','0','爆笑恶搞EXO《杀猪的》 字幕组又赢了','youku','0','','XNjIwMjIxNDky','','','','');
INSERT INTO `mac_vod` VALUES('1202','英文版《爸爸去哪儿》 高端洋气上档次','','yingwenbanbabaqunaergaoduanyangqishangdangci','Y','','http://www.egao8.cc/upload/vod/2016-02-23/145618867719.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','433','0','0','0','0','0','0','9.0','3816','424','1457671779','1457671779','0','0','英文版《爸爸去哪儿》 高端洋气上档次','youku','0','','XNjQ0MjA5MjA4','','','','');
INSERT INTO `mac_vod` VALUES('1203','精神分裂！牛人模仿9明星演绎雨蝶','','jingshenfenlieniurenmofang9mingxingyanyiyudie','J','','http://www.egao8.cc/upload/vod/2016-02-23/14561886811.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','133','0','0','0','0','0','0','8.0','1944','243','1457671780','1457671780','0','0','精神分裂！牛人模仿9明星演绎雨蝶','youku','0','','XNjIxMTcxMzAw','','','','');
INSERT INTO `mac_vod` VALUES('1204','全民吐槽办证难《办证难之歌》','','quanmintucaobanzhengnanbanzhengnanzhige','Q','','http://www.egao8.cc/upload/vod/2016-02-23/14561886812.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','610','0','0','4','0','0','0','8.0','1560','195','1457671780','1457671780','1458477960','0','全民吐槽办证难《办证难之歌》','youku','0','','XNjYxOTAzMTgw','','','','');
INSERT INTO `mac_vod` VALUES('1205','大学生恶搞学校食堂《食堂的罪》','','daxueshengegaoxuexiaoshitangshitangdezui','D','','http://www.egao8.cc/upload/vod/2016-02-23/14561886813.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','669','0','0','0','0','0','0','7.0','1533','219','1457671780','1457671780','0','0','大学生恶搞学校食堂《食堂的罪》','youku','0','','XNjYyMTI1MDYw','','','','');
INSERT INTO `mac_vod` VALUES('1206','碉堡！《杀马特遇见洗剪吹》已经走进农村中学','','diaobaoshamateyujianxijianchuiyijingzoujinnongcunzhongxue','D','','http://www.egao8.cc/upload/vod/2016-02-23/14561886814.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','610','0','0','4','0','0','0','10.0','2390','239','1457671780','1457671780','1458098985','0','碉堡！《杀马特遇见洗剪吹》已经走进农村中学','youku','0','','XNjQxNTU3MzA4','','','','');
INSERT INTO `mac_vod` VALUES('1207','美到爆！日文版《爸爸去哪儿》 超温柔 超动听','','meidaobaoriwenbanbabaqunaerchaowenrouchaodongting','M','','http://www.egao8.cc/upload/vod/2016-02-23/14561886815.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','422','0','0','0','0','0','0','9.0','2592','288','1457671780','1457671780','0','0','美到爆！日文版《爸爸去哪儿》 超温柔 超动听','youku','0','','XNjUwMzczOTY4','','','','');
INSERT INTO `mac_vod` VALUES('1208','美爆！女声版《卷珠帘》 一大波古装美女助阵','','meibaonvshengbanjuanzhulianyidaboguzhuangmeinvzhuzhen','M','','http://www.egao8.cc/upload/vod/2016-02-23/14561886816.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','113','0','0','25','0','0','0','6.0','798','133','1457671780','1457671780','1458350251','0','美爆！女声版《卷珠帘》 一大波古装美女助阵','youku','0','','XNjYwODU5NzA4','','','','');
INSERT INTO `mac_vod` VALUES('1209','雾霾版领悟《领雾》 啊 多么痛的领雾','','wumaibanlingwulingwuaduometongdelingwu','W','','http://www.egao8.cc/upload/vod/2016-02-23/14561886817.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','797','0','0','0','0','0','0','10.0','4020','402','1457671780','1457671780','0','0','雾霾版领悟《领雾》 啊 多么痛的领雾','youku','0','','XNjUwMDM0NDQ0','','','','');
INSERT INTO `mac_vod` VALUES('1210','剑三版《爸爸去哪儿》  笑岔了！','','jiansanbanbabaqunaerxiaochaliao','J','','http://www.egao8.cc/upload/vod/2016-02-23/14561886818.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','209','0','0','0','0','0','0','3.0','618','206','1457671780','1457671780','0','0','剑三版《爸爸去哪儿》  笑岔了！','youku','0','','XNjM4MzA2OTE2','','','','');
INSERT INTO `mac_vod` VALUES('1211','笑尿！《杀马特遇见洗剪吹》走进大学','','xiaoniaoshamateyujianxijianchuizoujindaxue','X','','http://www.egao8.cc/upload/vod/2016-02-23/14561886819.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','713','0','0','11','0','0','0','5.0','1330','266','1457671780','1457671780','1458477778','0','笑尿！《杀马特遇见洗剪吹》走进大学','youku','0','','XNjQ5MDgxOTcy','','','','');
INSERT INTO `mac_vod` VALUES('1212','内急拉稀版《至少还有你》 误入女厕的杯具','','najilaxibanzhishaohuaiyouniwurunvcedebeiju','N','','http://www.egao8.cc/upload/vod/2016-02-23/145618868110.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','625','0','0','0','0','0','0','9.0','324','36','1457671780','1457671780','0','0','内急拉稀版《至少还有你》 误入女厕的杯具','youku','0','','XNjI0OTAxNDk2','','','','');
INSERT INTO `mac_vod` VALUES('1213','洗脑神曲《王师傅前传》 杀马特洗剪吹的前世今生','','xinaoshenquwangshifuqianchuanshamatexijianchuideqianshijinsheng','X','','http://www.egao8.cc/upload/vod/2016-02-23/145618868111.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','543','0','0','0','0','0','0','10.0','3320','332','1457671780','1457671780','0','0','洗脑神曲《王师傅前传》 杀马特洗剪吹的前世今生','youku','0','','XNjM3MzUzNTY4','','','','');
INSERT INTO `mac_vod` VALUES('1214','原版《杀马特遇见洗剪吹》 王师傅拐走了女朋友','','yuanbanshamateyujianxijianchuiwangshifuguaizouliaonvpengyou','Y','','http://www.egao8.cc/upload/vod/2016-02-23/145618868112.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','491','0','0','0','0','0','0','10.0','4510','451','1457671780','1457671780','0','0','原版《杀马特遇见洗剪吹》 王师傅拐走了女朋友','youku','0','','XNjIyODUwNjI4','','','','');
INSERT INTO `mac_vod` VALUES('1215','《爸爸去哪儿》神级PS 爆笑穿越各种大片','','babaqunaershenjiPSbaoxiaochuanyuegezhongdapian','B','','http://www.egao8.cc/upload/vod/2016-02-23/145618868113.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','225','0','0','0','0','0','0','9.0','2727','303','1457671780','1457671780','0','0','《爸爸去哪儿》神级PS 爆笑穿越各种大片','youku','0','','XNjQ1NTQzNTUy','','','','');
INSERT INTO `mac_vod` VALUES('1216','光棍节神曲《千本光棍》 全程高能无尿点！','','guanggunjieshenquqianbenguanggunquanchenggaonenwuniaodian','G','','http://www.egao8.cc/upload/vod/2016-02-23/145618868114.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','466','0','0','0','0','0','0','7.0','203','29','1457671780','1457671780','0','0','光棍节神曲《千本光棍》 全程高能无尿点！','youku','0','','XNjMxODY3NjMy','','','','');
INSERT INTO `mac_vod` VALUES('1217','小学生滚出游戏圈小学生打游戏坑爹坑娘坑队友','','xiaoxueshenggunchuyouxiquanxiaoxueshengdayouxikangdiekangniangkangduiyou','X','','http://www.egao8.cc/upload/vod/2016-02-23/145618868115.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','155','0','0','0','0','0','0','8.0','1056','132','1457671780','1457671780','0','0','小学生滚出游戏圈小学生打游戏坑爹坑娘坑队友','youku','0','','XNjQyMjkwNDky','','','','');
INSERT INTO `mac_vod` VALUES('1218','化学版《王妃》 吊炸了！！！！','','huaxuebanwangfeidiaozhaliao','H','','http://www.egao8.cc/upload/vod/2016-02-23/145618868116.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','704','0','0','0','0','0','0','4.0','392','98','1457671780','1457671780','0','0','化学版《王妃》 吊炸了！！！！','youku','0','','XNjMwMDYxMDE2','','','','');
INSERT INTO `mac_vod` VALUES('1219','学霸学渣二人组《学霸去哪儿》','','xuebaxuezhaerrenzuxuebaqunaer','X','','http://www.egao8.cc/upload/vod/2016-02-23/145618868117.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','240','0','0','0','0','0','0','3.0','69','23','1457671780','1457671780','0','0','学霸学渣二人组《学霸去哪儿》','youku','0','','XNjQwNTg5NTM2','','','','');
INSERT INTO `mac_vod` VALUES('1220','神兽版《太阳之花》','','shenshoubantaiyangzhihua','S','','http://www.egao8.cc/upload/vod/2016-02-23/145618868118.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','861','0','0','0','0','0','0','3.0','711','237','1457671780','1457671780','0','0','神兽版《太阳之花》','youku','0','','XNjI3OTcxODMy','','','','');
INSERT INTO `mac_vod` VALUES('1221','屌丝搬砖进行曲《屌丝ING》','','sibanzhuanjinxingqusiING','S','','http://www.egao8.cc/upload/vod/2016-02-23/145618867216.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','885','0','0','0','0','0','0','9.0','3852','428','1457671792','1457671792','0','0','屌丝搬砖进行曲《屌丝ING》','youku','0','','XNjYwMzg0NzMy','','','','');
INSERT INTO `mac_vod` VALUES('1222','妹纸吐槽出题的汉子','','meizhitucaochutidehanzi','M','','http://www.egao8.cc/upload/vod/2016-02-23/145618867318.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','95','0','0','0','0','0','0','8.0','2176','272','1457671792','1457671792','0','0','妹纸吐槽出题的汉子','youku','0','','XNjU1NjY3NzM2','','','','');
INSERT INTO `mac_vod` VALUES('1223','刘恺威献歌杨幂：脚臭版《味道》','','liukaiweixiangeyangmijiaochubanweidao','L','','http://www.egao8.cc/upload/vod/2016-02-23/145618867319.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','1004','0','0','7','0','0','0','9.0','468','52','1457671792','1457671792','1458353791','0','刘恺威献歌杨幂：脚臭版《味道》','youku','0','','XNjYxNjkyODg0','','','','');
INSERT INTO `mac_vod` VALUES('1224','多冷啊！我在东北玩泥巴续集《我在东北采菊花》','','duolingawozaidongbeiwannibaxujiwozaidongbeicaijuhua','D','','http://www.egao8.cc/upload/vod/2016-02-23/14561886761.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','62','0','0','0','0','0','0','10.0','2840','284','1457671792','1457671792','0','0','多冷啊！我在东北玩泥巴续集《我在东北采菊花》','youku','0','','XNjUyMDgxMzQ4','','','','');
INSERT INTO `mac_vod` VALUES('1225','爆笑翻唱版《狼的诱惑》 翻唱者当场阵亡','','baoxiaofanchangbanlangdeyouhuofanchangzhedangchangzhenwang','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561886762.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','982','0','0','0','0','0','0','3.0','1038','346','1457671792','1457671792','0','0','爆笑翻唱版《狼的诱惑》 翻唱者当场阵亡','youku','0','','XNjUyOTc0MDQ4','','','','');
INSERT INTO `mac_vod` VALUES('1226','：犀利吐槽杜海涛《超级脑残》--杜海涛跪拜权志龙引争议','','xilitucaoduhaitaochaojinaocanduhaitaoguibaiquanzhilongyinzhengyi','X','','http://www.egao8.cc/upload/vod/2016-02-23/14561886763.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','917','0','0','0','0','0','0','4.0','396','99','1457671792','1457671792','0','0','：犀利吐槽杜海涛《超级脑残》--杜海涛跪拜权志龙引争议','youku','0','','XNjM5MDk1ODcy','','','','');
INSERT INTO `mac_vod` VALUES('1227','[加速版]龚琳娜《爱情买卖》 全程高能 结尾大亮','','jiasubangonglinnaaiqingmaimaiquanchenggaonenjieweidaliang','J','','http://www.egao8.cc/upload/vod/2016-02-23/14561886764.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','746','0','0','0','0','0','0','1.0','14','14','1457671792','1457671792','0','0','（加速版）龚琳娜《爱情买卖》 全程高能 结尾大亮','youku','0','','XNjQ4MTQyNzQw','','','','');
INSERT INTO `mac_vod` VALUES('1228','恶搞剑三：我的副本里','','egaojiansanwodefubenli','E','','http://www.egao8.cc/upload/vod/2016-02-23/14561886765.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','317','0','0','0','0','0','0','1.0','296','296','1457671792','1457671792','0','0','恶搞剑三：我的副本里','youku','0','','XNjMzNTI3NDQ0','','','','');
INSERT INTO `mac_vod` VALUES('1229','恶搞泰国新神曲《撸神曲》 野生字幕君亮了','','egaotaiguoxinshenqulushenquyeshengzimujunliangliao','E','','http://www.egao8.cc/upload/vod/2016-02-23/14561886766.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','696','0','0','0','0','0','0','3.0','30','10','1457671792','1457671792','0','0','恶搞泰国新神曲《撸神曲》 野生字幕君亮了','youku','0','','XNjMwNTA4NTM2','','','','');
INSERT INTO `mac_vod` VALUES('1230','粑粑进行曲 —— 便秘者的福音','','babajinxingqubianmizhedefuyin','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561886767.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','418','0','0','0','0','0','0','5.0','1015','203','1457671792','1457671792','0','0','粑粑进行曲 —— 便秘者的福音','youku','0','','XNjQwMDk4MzAw','','','','');
INSERT INTO `mac_vod` VALUES('1231','神译棒子神曲《啪啪啪》','','shenyibangzishenqupapapa','S','','http://www.egao8.cc/upload/vod/2016-02-23/14561886768.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','738','0','0','0','0','0','0','1.0','35','35','1457671792','1457671792','0','0','神译棒子神曲《啪啪啪》','youku','0','','XNjM2NDkyOTYw','','','','');
INSERT INTO `mac_vod` VALUES('1232','防止喜当爹必备神曲《拦精灵之歌》--春哥友情助演','','fangzhixidangdiebibeishenqulanjinglingzhigechungeyouqingzhuyan','F','','http://www.egao8.cc/upload/vod/2016-02-23/14561886779.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','877','0','0','0','0','0','0','7.0','2793','399','1457671792','1457671792','0','0','防止喜当爹必备神曲《拦精灵之歌》--春哥友情助演','youku','0','','XNjI1ODI2NDAw','','','','');
INSERT INTO `mac_vod` VALUES('1233','屌丝恶搞《Poker Face》高富帅躺枪吐血','','siegaoPokerFacegaofushuaithangqiangtuxue','S','','http://www.egao8.cc/upload/vod/2016-02-23/145618867710.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','277','0','0','0','0','0','0','3.0','135','45','1457671792','1457671792','0','0','屌丝恶搞《Poker Face》高富帅躺枪吐血','youku','0','','XNjU3ODMyOTY0','','','','');
INSERT INTO `mac_vod` VALUES('1234','爆笑改编狐狸叫《福利叫》 彻底放弃治疗','','baoxiaogaibianhulijiaofulijiaochedifangqizhiliao','B','','http://www.egao8.cc/upload/vod/2016-02-23/145618867711.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','849','0','0','0','0','0','0','3.0','630','210','1457671792','1457671792','0','0','爆笑改编狐狸叫《福利叫》 彻底放弃治疗','youku','0','','XNjM1OTg3MjY4','','','','');
INSERT INTO `mac_vod` VALUES('1235','小屌丝遇见大土豪','','xiaosiyujiandatuhao','X','','http://www.egao8.cc/upload/vod/2016-02-23/145618867712.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','221','0','0','0','0','0','0','1.0','240','240','1457671792','1457671792','0','0','小屌丝遇见大土豪','youku','0','','XNjIxODgxNzEy','','','','');
INSERT INTO `mac_vod` VALUES('1236','小萝莉洗脑神曲《爸爸啵哪儿》 龚琳娜收了她吧','','xiaoluolixinaoshenqubababonaergonglinnashouliaotaba','X','','http://www.egao8.cc/upload/vod/2016-02-23/145618867713.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','991','0','0','0','0','0','0','2.0','432','216','1457671792','1457671792','0','0','小萝莉洗脑神曲《爸爸啵哪儿》 龚琳娜收了她吧','youku','0','','XNjUxNjI4MzYw','','','','');
INSERT INTO `mac_vod` VALUES('1237','秋裤版《我从草原来》 凤凰传奇冷哭了！','','qiukubanwocongcaoyuanlaifenghuangchuanqilingkuliao','Q','','http://www.egao8.cc/upload/vod/2016-02-23/145618867714.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','976','0','0','0','0','0','0','4.0','300','75','1457671792','1457671792','0','0','秋裤版《我从草原来》 凤凰传奇冷哭了！','youku','0','','XNjM0NzY0NTk2','','','','');
INSERT INTO `mac_vod` VALUES('1238','剑三众基友大合唱《One night in 剑三》','','jiansanzhongjiyoudahechangOnenightinjiansan','J','','http://www.egao8.cc/upload/vod/2016-02-23/145618867715.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','460','0','0','0','0','0','0','10.0','2440','244','1457671792','1457671792','0','0','剑三众基友大合唱《One night in 剑三》','youku','0','','XNjIwOTkxMjUy','','','','');
INSERT INTO `mac_vod` VALUES('1239','自强不吸！内涵吐槽《雾霾是会呼吸的痛》','','ziqiangbuxinahantucaowumaishihuihuxidetong','Z','','http://www.egao8.cc/upload/vod/2016-02-23/145618867716.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','447','0','0','0','0','0','0','4.0','1012','253','1457671792','1457671792','0','0','自强不吸！内涵吐槽《雾霾是会呼吸的痛》','youku','0','','XNjQ3Mzg0MzMy','','','','');
INSERT INTO `mac_vod` VALUES('1240','中文版《太阳之花》','','zhongwenbantaiyangzhihua','Z','','http://www.egao8.cc/upload/vod/2016-02-23/145618867717.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','910','0','0','0','0','0','0','8.0','2976','372','1457671792','1457671792','0','0','中文版《太阳之花》','youku','0','','XNjI3MDg0NzI4','','','','');
INSERT INTO `mac_vod` VALUES('1241','搞笑歪唱《填词叫》','','gaoxiaowaichangtiancijiao','G','','http://www.egao8.cc/upload/vod/2016-02-23/145618866816.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','96','0','0','0','0','0','0','6.0','1374','229','1457671802','1457671802','0','0','搞笑歪唱《填词叫》','youku','0','','XNjgwMzM4MzE2','','','','');
INSERT INTO `mac_vod` VALUES('1242','腐女惹不起《腐女之歌》逆天的节奏','','funvruobuqifunvzhigenitiandejiezou','F','','http://www.egao8.cc/upload/vod/2016-02-23/145618866817.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','244','0','0','0','0','0','0','8.0','3864','483','1457671802','1457671802','0','0','腐女惹不起《腐女之歌》逆天的节奏','youku','0','','XNjYzNzY3Njcy','','','','');
INSERT INTO `mac_vod` VALUES('1243','学生吐血歪唱《学生放假欢乐多》','','xueshengtuxuewaichangxueshengfangjiahuanleduo','X','','http://www.egao8.cc/upload/vod/2016-02-23/145618866818.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','580','0','0','0','0','0','0','4.0','1560','390','1457671802','1457671802','0','0','学生吐血歪唱《学生放假欢乐多》','youku','0','','XNjY0NTYwNDA0','','','','');
INSERT INTO `mac_vod` VALUES('1244','新编歪版《穷开心》 秒杀原版','','xinbianwaibanqiongkaixinmiaoshayuanban','X','','http://www.egao8.cc/upload/vod/2016-02-23/145618866819.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','606','0','0','0','0','0','0','1.0','232','232','1457671802','1457671802','0','0','新编歪版《穷开心》 秒杀原版','youku','0','','XNjg5NjExNjI4','','','','');
INSERT INTO `mac_vod` VALUES('1245','《来自猩猩的你》之酷男的故事','','laizixingxingdenizhikunandegushi','L','','http://www.egao8.cc/upload/vod/2016-02-23/14561886721.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','796','0','0','0','0','0','0','8.0','208','26','1457671802','1457671802','0','0','《来自猩猩的你》之酷男的故事','youku','0','','XNjc2MDQwNTI0','','','','');
INSERT INTO `mac_vod` VALUES('1246','歪歌吐槽穿越火线','','waigetucaochuanyuehuoxian','W','','http://www.egao8.cc/upload/vod/2016-02-23/14561886722.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','841','0','0','0','0','0','0','7.0','1057','151','1457671802','1457671802','0','0','歪歌吐槽穿越火线','youku','0','','XNjg1NjI5MTI0','','','','');
INSERT INTO `mac_vod` VALUES('1247','川话搞笑雷人版《双节棍之油炸粑》','','chuanhuagaoxiaoleirenbanshuangjiegunzhiyouzhaba','C','','http://www.egao8.cc/upload/vod/2016-02-23/14561886723.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','901','0','0','0','0','0','0','5.0','2330','466','1457671802','1457671802','0','0','川话搞笑雷人版《双节棍之油炸粑》','youku','0','','XNjgzODQ0NTI0','','','','');
INSERT INTO `mac_vod` VALUES('1248','东莞风云4之两封家书','','dongguanfengyun4zhiliangfengjiashu','D','','http://www.egao8.cc/upload/vod/2016-02-23/14561886724.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','855','0','0','0','0','0','0','8.0','3552','444','1457671803','1457671803','0','0','东莞风云4之两封家书','youku','0','','XNjc2MDIwOTc2','','','','');
INSERT INTO `mac_vod` VALUES('1249','剑三版《时间都去哪儿了》','','jiansanbanshijianduqunaerliao','J','','http://www.egao8.cc/upload/vod/2016-02-23/14561886725.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','551','0','0','0','0','0','0','4.0','1156','289','1457671803','1457671803','0','0','剑三版《时间都去哪儿了》','youku','0','','XNjc4MTU3MTEy','','','','');
INSERT INTO `mac_vod` VALUES('1250','爆笑川话版《let it go》','','baoxiaochuanhuabanletitgo','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561886726.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','55','0','0','0','0','0','0','3.0','192','64','1457671803','1457671803','0','0','爆笑川话版《let it go》','youku','0','','XNjc1MjU5NTE2','','','','');
INSERT INTO `mac_vod` VALUES('1251','吐槽封神英雄榜《倍儿爽》','','tucaofengshenyingxiongbangbeiershuang','T','','http://www.egao8.cc/upload/vod/2016-02-23/14561886727.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','907','0','4','4','0','0','0','1.0','321','321','1457671803','1457671803','1458705843','0','吐槽封神英雄榜《倍儿爽》','youku','0','','XNjc2ODY2NTY4','','','','');
INSERT INTO `mac_vod` VALUES('1252','妹纸high歌《男神你快来》 根本把持不住','','meizhihighgenanshennikuailaigenbenbachibuzhu','M','','http://www.egao8.cc/upload/vod/2016-02-23/14561886728.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','347','0','0','0','0','0','0','3.0','645','215','1457671803','1457671803','0','0','妹纸high歌《男神你快来》 根本把持不住','youku','0','','XNjc1NjUyMzg4','','','','');
INSERT INTO `mac_vod` VALUES('1253','冰雪奇缘版《倍儿爽》','','bingxueqiyuanbanbeiershuang','B','','http://www.egao8.cc/upload/vod/2016-02-23/14561886729.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','611','0','0','0','0','0','0','5.0','705','141','1457671803','1457671803','0','0','冰雪奇缘版《倍儿爽》','youku','0','','XNjc0NzI5ODU2','','','','');
INSERT INTO `mac_vod` VALUES('1254','都是扫黄惹的祸 裸跑哥亮瞎了','','dushisaohuangruodehuoluopaogeliangxialiao','D','','http://www.egao8.cc/upload/vod/2016-02-23/145618867210.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','137','0','0','0','0','0','0','7.0','2443','349','1457671803','1457671803','0','0','都是扫黄惹的祸 裸跑哥亮瞎了','youku','0','','XNjcxNzE2NzEy','','','','');
INSERT INTO `mac_vod` VALUES('1255','神翻译 屌丝租韩国女友回家过年','','shenfanyisizuhanguonvyouhuijiaguonian','S','','http://www.egao8.cc/upload/vod/2016-02-23/145618867211.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','840','0','3','7','0','0','0','3.0','231','77','1457671803','1457671803','1458716533','0','神翻译 屌丝租韩国女友回家过年','youku','0','','XNjY2OTAwNzY4','','','','');
INSERT INTO `mac_vod` VALUES('1256','熊孩子梁逸峰《土豪去哪儿》 亮瞎了','','xionghaiziliangyifengtuhaoqunaerliangxialiao','X','','http://www.egao8.cc/upload/vod/2016-02-23/145618867212.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','331','0','0','0','0','0','0','8.0','1360','170','1457671803','1457671803','0','0','熊孩子梁逸峰《土豪去哪儿》 亮瞎了','youku','0','','XNjYyNTU5MjQ4','','','','');
INSERT INTO `mac_vod` VALUES('1257','东莞风云三 东莞您好','','dongguanfengyunsandongguanninhao','D','','http://www.egao8.cc/upload/vod/2016-02-23/145618867213.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','227','0','1','1','0','0','0','5.0','1040','208','1457671803','1457671803','1458716636','0','东莞风云三 东莞您好','youku','0','','XNjc0NzczMTM2','','','','');
INSERT INTO `mac_vod` VALUES('1258','民工讨薪之歌《向天再借五百万》','','mingongtaoxinzhigexiangtianzaijiewubaiwan','M','','http://www.egao8.cc/upload/vod/2016-02-23/145618867214.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','335','0','0','0','0','0','0','3.0','390','130','1457671803','1457671803','0','0','民工讨薪之歌《向天再借五百万》','youku','0','','XNjY3MTg1MzA4','','','','');
INSERT INTO `mac_vod` VALUES('1259','春运抢票版《卷珠帘》','','chunyunqiangpiaobanjuanzhulian','C','','http://www.egao8.cc/upload/vod/2016-02-23/145618867215.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','944','0','0','0','0','0','0','6.0','2166','361','1457671803','1457671803','0','0','春运抢票版《卷珠帘》','youku','0','','XNjY1MDIzMTI0','','','','');
INSERT INTO `mac_vod` VALUES('1260','论看女优的好处','','lunkannvyoudehaochu','L','','http://www.egao8.cc/upload/vod/2016-02-23/145618867317.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','56','0','0','0','0','0','0','6.0','2598','433','1457671803','1457671803','0','0','论看女优的好处','youku','0','','XNjU2NTM4NDA0','','','','');
INSERT INTO `mac_vod` VALUES('1261','学生改编《开学去哪儿》献歌教师','','xueshenggaibiankaixuequnaerxiangejiaoshi','X','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879013.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','271','0','80','274','0','0','0','7.0','1995','285','1458788218','1458788218','0','0','学生改编《开学去哪儿》献歌教师','youku','0','','XNjc1MTc5MTQw','','','','');
INSERT INTO `mac_vod` VALUES('1262','屌丝吐槽春节后《钞票都去哪儿了》伤不起啊！','','situcaochunjiehouchaopiaoduqunaerliaoshangbuqia','S','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879015.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','330','0','295','622','0','0','0','9.0','2214','246','1458788218','1458788218','0','0','屌丝吐槽春节后《钞票都去哪儿了》伤不起啊！','youku','0','','XNjcxNDExNTg0','','','','');
INSERT INTO `mac_vod` VALUES('1263','歪唱改编森碟最爱《吃饭睡觉打豆豆》','','waichanggaibiansendiezuiaichifanshuijuedadoudou','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879017.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','793','0','661','560','0','0','0','8.0','3624','453','1458788218','1458788218','0','0','歪唱改编森碟最爱《吃饭睡觉打豆豆》','youku','0','','XNjU3NDA3MzE2','','','','');
INSERT INTO `mac_vod` VALUES('1264','：狂吐槽《坑爹年终奖》','','kuangtucaokangdienianzhongjiang','K','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887941.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','429','0','977','372','0','0','0','2.0','890','445','1458788218','1458788218','0','0','：狂吐槽《坑爹年终奖》','youku','0','','XNjY1NTIxNTg0','','','','');
INSERT INTO `mac_vod` VALUES('1265','雷人方言歪歌毁童年《还珠格格》','','leirenfangyanwaigehuitongnianhuaizhugege','L','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887942.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','851','0','638','62','0','0','0','6.0','2616','436','1458788218','1458788218','0','0','雷人方言歪歌毁童年《还珠格格》','youku','0','','XNjU2NTY0MzQ0','','','','');
INSERT INTO `mac_vod` VALUES('1266','歪歌吐槽黄牛刷票《春运车票抢不起》','','waigetucaohuangniushuapiaochunyunchepiaoqiangbuqi','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887944.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','768','0','883','604','0','0','0','2.0','872','436','1458788218','1458788218','0','0','歪歌吐槽黄牛刷票《春运车票抢不起》','youku','0','','XNjU5ODA2MDM2','','','','');
INSERT INTO `mac_vod` VALUES('1267','超级雷人爆笑神曲《二逼STYLE》','','chaojileirenbaoxiaoshenquerbiSTYLE','C','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887946.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','228','0','44','188','0','0','0','9.0','3384','376','1458788218','1458788218','0','0','超级雷人爆笑神曲《二逼STYLE》','youku','0','','XNDgyOTY5NzEy','','','','');
INSERT INTO `mac_vod` VALUES('1268','上班族吐槽春节加班《想家》','','shangbanzutucaochunjiejiabanxiangjia','S','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887948.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','878','0','796','475','0','0','0','1.0','234','234','1458788218','1458788218','0','0','上班族吐槽春节加班《想家》','youku','0','','XNjU4OTA2Njk2','','','','');
INSERT INTO `mac_vod` VALUES('1269','：调侃非诚勿扰《成也扰 败也扰》','','diaokanfeichengwuraochengyeraobaiyerao','D','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879410.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','205','0','408','843','0','0','0','7.0','1134','162','1458788218','1458788218','0','0','：调侃非诚勿扰《成也扰 败也扰》','youku','0','','XNjIxMjEwMDky','','','','');
INSERT INTO `mac_vod` VALUES('1270','屌丝歪歌调侃心目中的土豪《土豪，我们做朋友》','','siwaigediaokanxinmuzhongdetuhaotuhaowomenzuopengyou','S','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879412.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','791','0','995','640','0','0','0','1.0','106','106','1458788218','1458788218','0','0','屌丝歪歌调侃心目中的土豪《土豪，我们做朋友》','youku','0','','XNjI3MzY3MjQ4','','','','');
INSERT INTO `mac_vod` VALUES('1271','2014屌丝励志神曲《向钱冲》','','2014silizhishenquxiangqianchong','2','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879415.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','563','0','763','433','0','0','0','8.0','3488','436','1458788218','1458788218','0','0','2014屌丝励志神曲《向钱冲》','youku','0','','XNjczOTU1MzMy','','','','');
INSERT INTO `mac_vod` VALUES('1272','妹子歪歌吐槽《胖子是会呼吸的痛》唱Cay了','','meiziwaigetucaopangzishihuihuxidetongchangCayliao','M','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879417.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','39','0','263','257','0','0','0','4.0','268','67','1458788218','1458788218','0','0','妹子歪歌吐槽《胖子是会呼吸的痛》唱Cay了','youku','0','','XNjg5MTk4NDUy','','','','');
INSERT INTO `mac_vod` VALUES('1273','扫黄神曲《东莞 东莞》','','saohuangshenqudongguandongguan','S','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879418.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','582','0','639','865','0','0','0','2.0','174','87','1458788218','1458788218','0','0','扫黄神曲《东莞 东莞》','hd_iask','0','','126217616','','','','');
INSERT INTO `mac_vod` VALUES('1274','屌丝爆笑诉苦神曲《穷伤心》','','sibaoxiaosukushenquqiongshangxin','S','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887982.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','651','0','880','981','0','0','0','10.0','3820','382','1458788218','1458788218','0','0','屌丝爆笑诉苦神曲《穷伤心》','youku','0','','XNjYzMzcyNjY0','','','','');
INSERT INTO `mac_vod` VALUES('1275','萌妹子吐槽《有一个腐女》','','mengmeizitucaoyouyigefunv','M','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887984.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','45','0','68','546','0','0','0','7.0','1799','257','1458788218','1458788218','0','0','萌妹子吐槽《有一个腐女》','youku','0','','XNjU4NTI0OTE2','','','','');
INSERT INTO `mac_vod` VALUES('1276','妹纸歪歌《有一个腐女》','','meizhiwaigeyouyigefunv','M','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887986.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','160','0','628','969','0','0','0','3.0','201','67','1458788218','1458788218','0','0','妹纸歪歌《有一个腐女》','youku','0','','XNjU4NTI0OTE2','','','','');
INSERT INTO `mac_vod` VALUES('1277','搞笑歪唱《最炫考试风》献歌考生','','gaoxiaowaichangzuixuankaoshifengxiangekaosheng','G','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887988.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','233','0','581','380','0','0','0','4.0','1344','336','1458788218','1458788218','0','0','搞笑歪唱《最炫考试风》献歌考生','youku','0','','XNTUzMzEwMDUy','','','','');
INSERT INTO `mac_vod` VALUES('1278','学妹吐槽《不想开学》','','xuemeitucaobuxiangkaixue','X','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879812.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','597','0','788','877','0','0','0','2.0','776','388','1458788218','1458788218','0','0','学妹吐槽《不想开学》','youku','0','','XNjc2NjY4OTM2','','','','');
INSERT INTO `mac_vod` VALUES('1279','歪歌吐槽《春运车票抢不起》','','waigetucaochunyunchepiaoqiangbuqi','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879814.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','926','0','209','775','0','0','0','10.0','4650','465','1458788218','1458788218','0','0','歪歌吐槽《春运车票抢不起》','youku','0','','XNjU5ODA2MDM2','','','','');
INSERT INTO `mac_vod` VALUES('1280','吐槽除夕不放假《想家》','','tucaochuxibufangjiaxiangjia','T','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879816.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','492','0','142','861','0','0','0','1.0','360','360','1458788218','1458788218','0','0','吐槽除夕不放假《想家》','youku','0','','XNjU4OTA2Njk2','','','','');
INSERT INTO `mac_vod` VALUES('1281','歪歌厂商何苦为难女人','','waigechangshanghekuweinannvren','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618878510.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','407','0','483','637','0','0','0','5.0','170','34','1458788228','1458788228','0','0','歪歌厂商何苦为难女人','youku','0','','XNjkzNTM3Nzk2','','','','');
INSERT INTO `mac_vod` VALUES('1282','爆笑歪歌《一起来跳广场舞》','','baoxiaowaigeyiqilaitiaoguangchangwu','B','','http://zy.egao8.cc/upload/vod/2016-02-23/145618878511.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','878','0','970','577','0','0','0','9.0','2241','249','1458788228','1458788228','0','0','爆笑歪歌《一起来跳广场舞》','youku','0','','XNjk3Njk3MTA4','','','','');
INSERT INTO `mac_vod` VALUES('1283','四川屌丝咆哮《我没有钱我要逆天》','','sichuansipaoxiaowomeiyouqianwoyaonitian','S','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887909.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','456','0','435','372','0','0','0','8.0','1480','185','1458788228','1458788228','0','0','四川屌丝咆哮《我没有钱我要逆天》','youku','0','','XNjgzMDI4OTU2','','','','');
INSERT INTO `mac_vod` VALUES('1284','超级歪歌《中国好声音》变《乡村好声音》','','chaojiwaigezhongguohaoshengyinbianxiangcunhaoshengyin','C','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879011.jpg','','','饭小杰','','','','大陆','','0','19','','','0','0','0','0','0','0','0','0','285','0','54','183','0','0','0','10.0','710','71','1458788228','1458788228','0','0','超级歪歌《中国好声音》变《乡村好声音》','youku','0','','XNDQ2MDg1NjI4','','','','');
INSERT INTO `mac_vod` VALUES('1285','敖尼玛/敖厂长的脱口秀','','aonimaaochangchangdetuokouxiu','A','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141313.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','736','0','713','308','0','0','0','3.0','663','221','1458788333','1458788333','0','0','敖尼玛/敖厂长的脱口秀','youku','0','','XNTcwOTA2NDA4','','','','');
INSERT INTO `mac_vod` VALUES('1286','暴走大事件 第一季 05','','baozoudashijiandiyiji05','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141316.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','528','0','484','18','0','0','0','8.0','1032','129','1458788334','1458788334','0','0','暴走大事件 第一季 05','youku','0','','XNTYxMjcwMjY4','','','','');
INSERT INTO `mac_vod` VALUES('1287','暴走大事件 第一季 10','','baozoudashijiandiyiji10','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141317.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','659','0','589','35','0','0','0','4.0','1588','397','1458788334','1458788334','0','0','暴走大事件 第一季 10','youku','0','','XNTkwMTYxMzA4','','','','');
INSERT INTO `mac_vod` VALUES('1288','暴走大事件第一季合集 30分钟','','baozoudashijiandiyijiheji30fenzhong','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141318.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','613','0','730','293','0','0','0','2.0','924','462','1458788334','1458788334','0','0','暴走大事件第一季合集 30分钟','youku','0','','XNTY1OTI2MjYw','','','','');
INSERT INTO `mac_vod` VALUES('1289','暴走动画 第一季：5 西游降魔的真相','','baozoudonghuadiyiji5xiyoujiangmodezhenxiang','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141319.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','814','0','615','860','0','0','0','1.0','444','444','1458788334','1458788334','0','0','暴走动画 第一季：5 西游降魔的真相','youku','0','','XNTI3MTUyMzY0','','','','');
INSERT INTO `mac_vod` VALUES('1290','暴走大事件 第一季 07','','baozoudashijiandiyiji07','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814171.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','282','0','295','270','0','0','0','3.0','24','8','1458788334','1458788334','0','0','暴走大事件 第一季 07','youku','0','','XNTczNTkwNzc2','','','','');
INSERT INTO `mac_vod` VALUES('1291','暴走大事件 第一季 08','','baozoudashijiandiyiji08','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814172.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','880','0','413','777','0','0','0','4.0','1976','494','1458788334','1458788334','0','0','暴走大事件 第一季 08','youku','0','','XNTc5MTA0MzQw','','','','');
INSERT INTO `mac_vod` VALUES('1292','暴走动画 第一季：1 中国成语解说','','baozoudonghuadiyiji1zhongguochengyujieshuo','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814173.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','566','0','459','603','0','0','0','8.0','272','34','1458788334','1458788334','0','0','暴走动画 第一季：1 中国成语解说','youku','0','','XNTA5OTI4MTQ0','','','','');
INSERT INTO `mac_vod` VALUES('1293','暴走大事件 第一季 06','','baozoudashijiandiyiji06','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814174.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','640','0','14','191','0','0','0','10.0','1870','187','1458788334','1458788334','0','0','暴走大事件 第一季 06','youku','0','','XNTYzOTc3MTYw','','','','');
INSERT INTO `mac_vod` VALUES('1294','暴走大事件 第一季 03','','baozoudashijiandiyiji03','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814175.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','997','0','4','451','0','0','0','4.0','220','55','1458788334','1458788334','0','0','暴走大事件 第一季 03','youku','0','','XNTUwMjE4MDY0','','','','');
INSERT INTO `mac_vod` VALUES('1295','暴走大事件 第一季 04','','baozoudashijiandiyiji04','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814176.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','375','0','949','10','0','0','0','10.0','4150','415','1458788334','1458788334','0','0','暴走大事件 第一季 04','youku','0','','XNTU2MTUyMjE2','','','','');
INSERT INTO `mac_vod` VALUES('1296','暴走大事件 第一季 02','','baozoudashijiandiyiji02','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814177.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','605','0','211','468','0','0','0','7.0','2359','337','1458788334','1458788334','0','0','暴走大事件 第一季 02','youku','0','','XNTQ3MjQxNDY0','','','','');
INSERT INTO `mac_vod` VALUES('1297','暴走动画 第一季：8 尽信书不如无书','','baozoudonghuadiyiji8jinxinshuburuwushu','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814178.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','865','0','249','640','0','0','0','2.0','634','317','1458788334','1458788334','0','0','暴走动画 第一季：8 尽信书不如无书','youku','0','','XNTUwMTE4NTg4','','','','');
INSERT INTO `mac_vod` VALUES('1298','暴走大事件 第一季 01','','baozoudashijiandiyiji01','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814179.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','923','0','862','811','0','0','0','4.0','1580','395','1458788334','1458788334','0','0','暴走大事件 第一季 01','youku','0','','XNTM0NDk5Mjgw','','','','');
INSERT INTO `mac_vod` VALUES('1299','暴走动画 第一季：7 王尼玛和曹尼玛特辑','','baozoudonghuadiyiji7wangnimahecaonimateji','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141710.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','392','0','445','986','0','0','0','6.0','1710','285','1458788334','1458788334','0','0','暴走动画 第一季：7 王尼玛和曹尼玛特辑','youku','0','','XNTQ0MDE3OTA4','','','','');
INSERT INTO `mac_vod` VALUES('1300','暴走动画 第一季：9 宠物小尼玛篇','','baozoudonghuadiyiji9chongwuxiaonimapian','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141711.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','981','0','237','137','0','0','0','1.0','496','496','1458788334','1458788334','0','0','暴走动画 第一季：9 宠物小尼玛篇','youku','0','','XNTU3NTIwNzI4','','','','');
INSERT INTO `mac_vod` VALUES('1301','暴走动画 第一季：4 历史老师死得早系列','','baozoudonghuadiyiji4lishilaoshisidezaoxilie','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141712.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','738','0','569','455','0','0','0','10.0','4590','459','1458788334','1458788334','0','0','暴走动画 第一季：4 历史老师死得早系列','youku','0','','XNTIwOTM4NDQw','','','','');
INSERT INTO `mac_vod` VALUES('1302','暴走动画 第一季：6 史书里都是骗人的','','baozoudonghuadiyiji6shishulidushipianrende','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141713.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','310','0','118','601','0','0','0','5.0','765','153','1458788334','1458788334','0','0','暴走动画 第一季：6 史书里都是骗人的','youku','0','','XNTM1ODc4MjY4','','','','');
INSERT INTO `mac_vod` VALUES('1303','暴走动画 第一季：2 神话典故解说','','baozoudonghuadiyiji2shenhuadiangujieshuo','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141714.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','184','0','152','954','0','0','0','4.0','916','229','1458788334','1458788334','0','0','暴走动画 第一季：2 神话典故解说','youku','0','','XNTA5OTM0NzAw','','','','');
INSERT INTO `mac_vod` VALUES('1304','暴走动画 第一季：3 国外童话解说','','baozoudonghuadiyiji3guowaitonghuajieshuo','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141715.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','942','0','786','861','0','0','0','3.0','402','134','1458788334','1458788334','0','0','暴走动画 第一季：3 国外童话解说','youku','0','','XNTA5OTQzNzMy','','','','');
INSERT INTO `mac_vod` VALUES('1305','暴走大事件08 敖厂长为茶叶蛋失态','','baozoudashijian08aochangchangweichayedanshitai','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628140918.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','355','0','597','887','0','0','0','8.0','2456','307','1458788344','1458788344','0','0','暴走大事件08 敖厂长为茶叶蛋失态','youku','0','','XNjk0MDQ5MzY4','','','','');
INSERT INTO `mac_vod` VALUES('1306','暴走动画 第二季：09 历史老师死得早系列','','baozoudonghuadierji09lishilaoshisidezaoxilie','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628140919.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','745','0','676','333','0','0','0','3.0','273','91','1458788344','1458788344','0','0','暴走动画 第二季：09 历史老师死得早系列','youku','0','','XNjE0MDE4MjEy','','','','');
INSERT INTO `mac_vod` VALUES('1307','暴走动画 第二季：04 尽信书不如无书2','','baozoudonghuadierji04jinxinshuburuwushu2','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814121.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','884','0','998','587','0','0','0','4.0','168','42','1458788344','1458788344','0','0','暴走动画 第二季：04 尽信书不如无书2','youku','0','','XNTk5NzE0NDQ4','','','','');
INSERT INTO `mac_vod` VALUES('1308','暴走大事件 第二季 04','','baozoudashijiandierji04','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814132.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','790','0','615','184','0','0','0','2.0','650','325','1458788344','1458788344','0','0','暴走大事件 第二季 04','youku','0','','XNjY3NDc3NTI0','','','','');
INSERT INTO `mac_vod` VALUES('1309','暴走动画 第二季：03 机智的诸葛亮','','baozoudonghuadierji03jizhidezhugeliang','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814133.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','325','0','171','378','0','0','0','6.0','1674','279','1458788344','1458788344','0','0','暴走动画 第二季：03 机智的诸葛亮','youku','0','','XNTk2NDg2ODM2','','','','');
INSERT INTO `mac_vod` VALUES('1310','暴走大事件 第二季 03','','baozoudashijiandierji03','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814134.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','449','0','154','392','0','0','0','7.0','266','38','1458788344','1458788344','0','0','暴走大事件 第二季 03','youku','0','','XNjYyODIxNDcy','','','','');
INSERT INTO `mac_vod` VALUES('1311','暴走脱口秀2','','baozoutuokouxiu2','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814135.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','460','0','147','668','0','0','0','10.0','1600','160','1458788344','1458788344','0','0','暴走脱口秀2','youku','0','','XNTc5NTY2OTU2','','','','');
INSERT INTO `mac_vod` VALUES('1312','暴走动画 第三季：03 暴走童话','','baozoudonghuadisanji03baozoutonghua','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814136.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','255','0','74','115','0','0','0','1.0','247','247','1458788344','1458788344','0','0','暴走动画 第三季：03 暴走童话','youku','0','','XNjkwNDYyNTUy','','','','');
INSERT INTO `mac_vod` VALUES('1313','暴走大事件 暴走小课堂01','','baozoudashijianbaozouxiaoketang01','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814137.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','570','0','456','362','0','0','0','10.0','750','75','1458788344','1458788344','0','0','暴走大事件 暴走小课堂01','youku','0','','XNjA0ODE0NzA0','','','','');
INSERT INTO `mac_vod` VALUES('1314','暴走动画 第三季：01 节操都市','','baozoudonghuadisanji01jiecaodushi','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814138.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','238','0','657','7','0','0','0','3.0','648','216','1458788344','1458788344','0','0','暴走动画 第三季：01 节操都市','youku','0','','XNjg0MjY2MDYw','','','','');
INSERT INTO `mac_vod` VALUES('1315','暴走大事件 第二季：03期之汪峰率汪星人入侵地球','','baozoudashijiandierji03qizhiwangfenglvwangxingrenruqindiqiu','B','','http://zy.egao8.cc/upload/vod/2016-02-24/14562814139.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','435','0','131','866','0','0','0','10.0','1650','165','1458788344','1458788344','0','0','暴走大事件 第二季：03期之汪峰率汪星人入侵地球','youku','0','','XNjY0MDY4OTg0','','','','');
INSERT INTO `mac_vod` VALUES('1316','暴走漫画之AV特别版','','baozoumanhuazhiAVtebieban','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141310.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','931','0','682','225','0','0','0','8.0','3696','462','1458788344','1458788344','0','0','暴走漫画之AV特别版','youku','0','','XNjYyNDc5MDIw','','','','');
INSERT INTO `mac_vod` VALUES('1317','暴走大事件 暴走漫画-暴走脱口秀3','','baozoudashijianbaozoumanhuabaozoutuokouxiu3','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141311.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','338','0','703','88','0','0','0','3.0','960','320','1458788344','1458788344','0','0','暴走大事件 暴走漫画-暴走脱口秀3','youku','0','','XNTg2MTA0Mjc2','','','','');
INSERT INTO `mac_vod` VALUES('1318','暴走大事件 暴走漫画-脑残对话1','','baozoudashijianbaozoumanhuanaocanduihua1','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141312.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','363','0','432','426','0','0','0','5.0','1245','249','1458788344','1458788344','0','0','暴走大事件 暴走漫画-脑残对话1','youku','0','','XNTg3NzY5ODY0','','','','');
INSERT INTO `mac_vod` VALUES('1319','暴走大事件 第一季特别版 天山武林大会 11','','baozoudashijiandiyijitebiebantianshanwulindahui11','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141314.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','58','0','202','432','0','0','0','5.0','910','182','1458788344','1458788344','0','0','暴走大事件 第一季特别版 天山武林大会 11','youku','0','','XNTkzMjg5MDY4','','','','');
INSERT INTO `mac_vod` VALUES('1320','暴走史上最丧心病狂的电视汽车广告','','baozoushishangzuisangxinbingkuangdedianshiqicheguanggao','B','','http://zy.egao8.cc/upload/vod/2016-02-24/145628141315.jpg','','','暴走漫画','','','','大陆','','0','13','','','0','0','0','0','0','0','0','0','68','0','688','766','0','0','0','7.0','665','95','1458788344','1458788344','0','0','暴走史上最丧心病狂的电视汽车广告','youku','0','','XNjEwNTA3MDUy','','','','');
INSERT INTO `mac_vod` VALUES('1321','最新搞笑视频 一人神配音  西游火拼记 15','','zuixingaoxiaoshipinyirenshenpeiyinxiyouhuopinji15','Z','','http://zy.egao8.cc/upload/vod/2015-10-12/14446295250.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','510','0','226','888','0','0','0','6.0','1422','237','1458788453','1458788453','0','0','最新搞笑视频 一人神配音  西游火拼记 15','youku','0','','XMTMwNTg4NzczMg==','','','','');
INSERT INTO `mac_vod` VALUES('1322','有一种冲动叫掐死理发师  胥渡吧最新','','youyizhongchongdongjiaoqiasilifashixudubazuixin','Y','','http://zy.egao8.cc/upload/vod/2015-10-12/14446294720.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','408','0','22','71','0','0','0','9.0','4086','454','1458788453','1458788453','0','0','有一种冲动叫掐死理发师  胥渡吧最新','youku','0','','XMTMwNjE0NDM0NA==','','','','');
INSERT INTO `mac_vod` VALUES('1323','《卖猪肉》 广西北海话版 合浦话版  胥渡吧-周星驰电影','','maizhurouguangxibeihaihuabanhepuhuabanxudubazhouxingchidianying','M','','http://zy.egao8.cc/upload/vod/2015-10-12/14446294120.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','998','0','321','164','0','0','0','6.0','2238','373','1458788453','1458788453','0','0','《卖猪肉》 广西北海话版 合浦话版  胥渡吧-周星驰电影','youku','0','','XMTMwNTc2MjE0NA==','','','','');
INSERT INTO `mac_vod` VALUES('1324','漫漫学车路 胥渡吧最新搞笑  驯车族','','manmanxuecheluxudubazuixingaoxiaoxunchezu','M','','http://zy.egao8.cc/upload/vod/2015-10-12/14446293700.gif','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','739','0','108','889','0','0','0','4.0','1516','379','1458788453','1458788453','0','0','漫漫学车路 胥渡吧最新搞笑  驯车族','youku','0','','XMTI5NzA5NzE4NA==','','','','');
INSERT INTO `mac_vod` VALUES('1325','悟空的齐B小短裙  11胥渡吧更新：太搞笑了~！','','wukongdeqiBxiaoduanqun11xudubagengxintaigaoxiaoliao','W','','http://zy.egao8.cc/upload/vod/2015-10-12/14446293360.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','430','0','468','188','0','0','0','2.0','554','277','1458788453','1458788453','0','0','悟空的齐B小短裙  11胥渡吧更新：太搞笑了~！','youku','0','','XMTI5ODY4NjIyMA==','','','','');
INSERT INTO `mac_vod` VALUES('1326','搞笑视频-恶搞史诗级灾难大片  搞笑视频-恶搞史诗级灾难大片','','gaoxiaoshipinegaoshishijizainandapiangaoxiaoshipinegaoshishijizainandapian','G','','http://zy.egao8.cc/upload/vod/2015-10-12/14446293030.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','467','0','825','471','0','0','0','10.0','4230','423','1458788453','1458788453','0','0','搞笑视频-恶搞史诗级灾难大片  搞笑视频-恶搞史诗级灾难大片','youku','0','','XMTMwMTAxNDc2NA==','','','','');
INSERT INTO `mac_vod` VALUES('1327','皇上，奴婢就是当年的夏雨荷呀！  皇上，奴婢就是当年的夏雨荷呀！','','huangshangnubijiushidangniandexiayuheyahuangshangnubijiushidangniandexiayuheya','H','','http://zy.egao8.cc/upload/vod/2015-10-12/14446292760.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','86','0','200','867','0','0','0','5.0','1705','341','1458788453','1458788453','0','0','皇上，奴婢就是当年的夏雨荷呀！  皇上，奴婢就是当年的夏雨荷呀！','youku','0','','XMTI5MzA3NzUwMA==','','','','');
INSERT INTO `mac_vod` VALUES('1328','西游火拼记  最新搞笑视频 一人神配音','','xiyouhuopinjizuixingaoxiaoshipinyirenshenpeiyin','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446292360.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','622','0','454','473','0','0','0','8.0','2824','353','1458788453','1458788453','0','0','西游火拼记  最新搞笑视频 一人神配音','youku','0','','XMTI5NzI4Njc5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1329','官三代白素贞的身世之谜  [牛人]胥渡吧：121','','guansandaibaisuzhendeshenshizhiminiurenxuduba121','G','','http://zy.egao8.cc/upload/vod/2015-10-12/14446291960.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','749','0','546','606','0','0','0','1.0','204','204','1458788453','1458788453','0','0','官三代白素贞的身世之谜  【牛人】胥渡吧：121','youku','0','','XMTI5ODcyMDMyNA==','','','','');
INSERT INTO `mac_vod` VALUES('1330','胥渡吧最新恶搞配音搞笑视频：春节防逼婚指南  胥渡吧最新恶搞配音搞笑视频','','xudubazuixinegaopeiyingaoxiaoshipinchunjiefangbihunzhinanxudubazuixinegaopeiyingaoxiaoshipin','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446291730.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','736','0','777','50','0','0','0','10.0','1850','185','1458788453','1458788453','0','0','胥渡吧最新恶搞配音搞笑视频：春节防逼婚指南  胥渡吧最新恶搞配音搞笑视频','youku','0','','XMTI5MDg4NjIxNg==','','','','');
INSERT INTO `mac_vod` VALUES('1331','《唐僧习武记》毁西游系列 恶搞西游记  《唐僧习武记》毁西游系列 恶搞西游记','','tangsengxiwujihuixiyouxilieegaoxiyoujitangsengxiwujihuixiyouxilieegaoxiyouji','T','','http://zy.egao8.cc/upload/vod/2015-10-12/14446291410.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','698','0','40','311','0','0','0','3.0','774','258','1458788454','1458788454','0','0','《唐僧习武记》毁西游系列 恶搞西游记  《唐僧习武记》毁西游系列 恶搞西游记','youku','0','','XMTI5NDQ4NDI5Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1332','22胥渡吧-周星驰电影《卖猪肉》  广西北海话版 合浦话版 搞笑视频 恶搞','','22xudubazhouxingchidianyingmaizhurouguangxibeihaihuabanhepuhuabangaoxiaoshipinegao','2','','http://zy.egao8.cc/upload/vod/2015-10-12/14446291170.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','841','0','74','861','0','0','0','6.0','1104','184','1458788454','1458788454','0','0','22胥渡吧-周星驰电影《卖猪肉》  广西北海话版 合浦话版 搞笑视频 恶搞','youku','0','','XMTI5ODY3Nzc0MA==','','','','');
INSERT INTO `mac_vod` VALUES('1333','搞笑配音视频 胥渡吧最新作品 猴子卖肾记  搞笑配音视频','','gaoxiaopeiyinshipinxudubazuixinzuopinhouzimaishenjigaoxiaopeiyinshipin','G','','http://zy.egao8.cc/upload/vod/2015-10-12/14446290650.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','716','0','711','390','0','0','0','6.0','858','143','1458788454','1458788454','0','0','搞笑配音视频 胥渡吧最新作品 猴子卖肾记  搞笑配音视频','youku','0','','XMTI4NjkxMTU2MA==','','','','');
INSERT INTO `mac_vod` VALUES('1334','胥渡吧恶搞视频-拆迁那些事儿  胥渡吧恶搞视频-拆迁那些事儿','','xudubaegaoshipinchaiqiannaxieshierxudubaegaoshipinchaiqiannaxieshier','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446290360.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','467','0','127','59','0','0','0','1.0','365','365','1458788454','1458788454','0','0','胥渡吧恶搞视频-拆迁那些事儿  胥渡吧恶搞视频-拆迁那些事儿','youku','0','','XMTI5MTY4NzYyOA==','','','','');
INSERT INTO `mac_vod` VALUES('1335','胥渡吧搞笑视频-武松不哭  胥渡吧搞笑视频-武松不哭','','xudubagaoxiaoshipinwusongbukuxudubagaoxiaoshipinwusongbuku','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446290020.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','83','0','91','748','0','0','0','3.0','747','249','1458788454','1458788454','0','0','胥渡吧搞笑视频-武松不哭  胥渡吧搞笑视频-武松不哭','youku','0','','XMTI5NDQ4NzE4OA==','','','','');
INSERT INTO `mac_vod` VALUES('1336','胥渡吧最新-丈母娘要20万彩礼竟逼小伙双双殉情-恶搞西游  恶搞西游','','xudubazuixinzhangmuniangyao20wancailijingbixiaohuoshuangshuangxunqingegaoxiyouegaoxiyou','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446289770.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','646','0','217','303','0','0','0','2.0','988','494','1458788454','1458788454','0','0','胥渡吧最新-丈母娘要20万彩礼竟逼小伙双双殉情-恶搞西游  恶搞西游','youku','0','','XMTI4NzAzMzU0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1337','风之音-胥渡吧恶搞视频-拆迁那些事儿  风之音-胥渡吧恶搞视频','','fengzhiyinxudubaegaoshipinchaiqiannaxieshierfengzhiyinxudubaegaoshipin','F','','http://zy.egao8.cc/upload/vod/2015-10-12/14446289490.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','581','0','211','792','0','0','0','9.0','1962','218','1458788454','1458788454','0','0','风之音-胥渡吧恶搞视频-拆迁那些事儿  风之音-胥渡吧恶搞视频','youku','0','','XMTI4NzYwOTU0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1338','超搞笑配音视频 胥渡吧最新作品 猴子卖肾记  超搞笑配音视频 胥渡吧最新作品 猴子卖肾记','','chaogaoxiaopeiyinshipinxudubazuixinzuopinhouzimaishenjichaogaoxiaopeiyinshipinxudubazuixinzuopinhouzimaishenji','C','','http://zy.egao8.cc/upload/vod/2015-10-12/14446289090.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','909','0','125','748','0','0','0','5.0','440','88','1458788454','1458788454','0','0','超搞笑配音视频 胥渡吧最新作品 猴子卖肾记  超搞笑配音视频 胥渡吧最新作品 猴子卖肾记','youku','0','','XMTI5MTgxMzc0NA==','','','','');
INSERT INTO `mac_vod` VALUES('1339','太搞笑了~！悟空的齐B小短裙  太搞笑了~！','','taigaoxiaoliaowukongdeqiBxiaoduanquntaigaoxiaoliao','T','','http://zy.egao8.cc/upload/vod/2015-10-12/14446288730.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','491','0','603','427','0','0','0','7.0','3080','440','1458788454','1458788454','0','0','太搞笑了~！悟空的齐B小短裙  太搞笑了~！','youku','0','','XMTI4NDM5NDY0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1340','胥渡吧：有一种冲动叫掐死理发师  有一种冲动叫掐死理发师','','xudubayouyizhongchongdongjiaoqiasilifashiyouyizhongchongdongjiaoqiasilifashi','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446288260.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','287','0','133','51','0','0','0','8.0','3280','410','1458788454','1458788454','0','0','胥渡吧：有一种冲动叫掐死理发师  有一种冲动叫掐死理发师','youku','0','','XMTI3NjQ3NDExMg==','','','','');
INSERT INTO `mac_vod` VALUES('1341','最新搞笑视频 一人神配音 西游火拼记  最新搞笑视频 一人神配音','','zuixingaoxiaoshipinyirenshenpeiyinxiyouhuopinjizuixingaoxiaoshipinyirenshenpeiyin','Z','','http://zy.egao8.cc/upload/vod/2015-10-12/14446287970.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','879','0','160','806','0','0','0','8.0','1120','140','1458788457','1458788457','0','0','最新搞笑视频 一人神配音 西游火拼记  最新搞笑视频 一人神配音','youku','0','','XMTI4OTc1ODE1Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1342','泡妞有绝招 唐僧师徒不过光棍节  泡妞有绝招','','paoniuyoujuezhaotangsengshitubuguoguanggunjiepaoniuyoujuezhao','P','','http://zy.egao8.cc/upload/vod/2015-10-12/14446287620.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','75','0','731','900','0','0','0','4.0','1052','263','1458788457','1458788457','0','0','泡妞有绝招 唐僧师徒不过光棍节  泡妞有绝招','youku','0','','XMTI4MTYzMjk0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1343','官三代白素贞的身世之谜  白素贞的身世之谜','','guansandaibaisuzhendeshenshizhimibaisuzhendeshenshizhimi','G','','http://zy.egao8.cc/upload/vod/2015-10-12/14446287320.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','580','0','608','615','0','0','0','8.0','2680','335','1458788457','1458788457','0','0','官三代白素贞的身世之谜  白素贞的身世之谜','youku','0','','XMTI3NDc3MTk1Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1344','胥渡吧 恶搞配音-道歉风波  恶搞配音','','xudubaegaopeiyindaoqianfengboegaopeiyin','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446287040.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','915','0','343','986','0','0','0','9.0','2439','271','1458788457','1458788457','0','0','胥渡吧 恶搞配音-道歉风波  恶搞配音','youku','0','','XMTI4OTM0NTUzMg==','','','','');
INSERT INTO `mac_vod` VALUES('1345','你妈逼你穿秋裤了吗  穿秋裤了吗','','nimabinichuanqiukuliaomachuanqiukuliaoma','N','','http://zy.egao8.cc/upload/vod/2015-10-12/14446286580.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','444','0','78','766','0','0','0','8.0','1264','158','1458788458','1458788458','0','0','你妈逼你穿秋裤了吗  穿秋裤了吗','youku','0','','XMTI4MDY1ODUyOA==','','','','');
INSERT INTO `mac_vod` VALUES('1346','取经遇扫黄 东莞招工难 猪八戒被抓－新闻乱播  东莞招工难 猪八戒被抓－新闻乱播','','qujingyusaohuangdongguanzhaogongnanzhubajiebeizhuaxinwenluanbodongguanzhaogongnanzhubajiebeizhuaxinwenluanbo','Q','','http://zy.egao8.cc/upload/vod/2015-10-12/14446286330.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','622','0','804','679','0','0','0','2.0','766','383','1458788458','1458788458','0','0','取经遇扫黄 东莞招工难 猪八戒被抓－新闻乱播  东莞招工难 猪八戒被抓－新闻乱播','youku','0','','XMTI3NDA1MTY3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1347','周星驰电影《卖猪肉》搞笑合浦话  周星驰电影','','zhouxingchidianyingmaizhurougaoxiaohepuhuazhouxingchidianying','Z','','http://zy.egao8.cc/upload/vod/2015-10-12/14446286070.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','250','0','601','665','0','0','0','2.0','500','250','1458788458','1458788458','0','0','周星驰电影《卖猪肉》搞笑合浦话  周星驰电影','youku','0','','XMTI4NzAyNzU4OA==','','','','');
INSERT INTO `mac_vod` VALUES('1348','高温来袭——致我们终将热死的夏天。  高温来袭','','gaowenlaixizhiwomenzhongjiangresidexiatiangaowenlaixi','G','','http://zy.egao8.cc/upload/vod/2015-10-12/14446285700.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','724','0','896','135','0','0','0','8.0','920','115','1458788458','1458788458','0','0','高温来袭——致我们终将热死的夏天。  高温来袭','youku','0','','XMTI4MDE5MTA2OA==','','','','');
INSERT INTO `mac_vod` VALUES('1349','《新白娘子传奇》配音《坑爹的法海》  配音坑爹的法海','','xinbainiangzichuanqipeiyinkangdiedefahaipeiyinkangdiedefahai','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446285420.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','282','0','707','218','0','0','0','4.0','4','1','1458788458','1458788458','0','0','《新白娘子传奇》配音《坑爹的法海》  配音坑爹的法海','youku','0','','XMTI3Mjg1NjcwMA==','','','','');
INSERT INTO `mac_vod` VALUES('1350','[法海的梨花烫]我叫许仙，我跟理发师  我叫许仙，我跟理发师','','fahaidelihuathengwojiaoxuxianwogenlifashiwojiaoxuxianwogenlifashi','F','','http://zy.egao8.cc/upload/vod/2015-10-12/14446285080.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','255','0','900','12','0','0','0','4.0','928','232','1458788458','1458788458','0','0','【法海的梨花烫】我叫许仙，我跟理发师  我叫许仙，我跟理发师','youku','0','','XMTI3NzU3MzM1Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1351','胥渡吧：舌尖上的吃货  胥渡吧：舌尖上的吃货','','xudubashejianshangdechihuoxudubashejianshangdechihuo','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446284860.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','319','0','429','832','0','0','0','9.0','468','52','1458788458','1458788458','0','0','胥渡吧：舌尖上的吃货  胥渡吧：舌尖上的吃货','youku','0','','XMTMwMDI3MzIwOA==','','','','');
INSERT INTO `mac_vod` VALUES('1352','国外恶搞整人视频 胥渡吧搞笑视频  国外恶搞整人视频 胥渡吧搞笑视频','','guowaiegaozhengrenshipinxudubagaoxiaoshipinguowaiegaozhengrenshipinxudubagaoxiaoshipin','G','','http://zy.egao8.cc/upload/vod/2015-10-12/14446284610.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','744','0','597','465','0','0','0','5.0','1255','251','1458788458','1458788458','0','0','国外恶搞整人视频 胥渡吧搞笑视频  国外恶搞整人视频 胥渡吧搞笑视频','youku','0','','XMTMwMzY2NzcwNA==','','','','');
INSERT INTO `mac_vod` VALUES('1353','孙悟坑大战流量怪  胥渡吧恶搞配音视频','','sunwukangdazhanliuliangguaixudubaegaopeiyinshipin','S','','http://zy.egao8.cc/upload/vod/2015-10-12/14446284370.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','643','0','298','413','0','0','0','9.0','2637','293','1458788458','1458788458','0','0','孙悟坑大战流量怪  胥渡吧恶搞配音视频','youku','0','','XMTI5NzE2ODUxNg==','','','','');
INSERT INTO `mac_vod` VALUES('1354','报考风暴 填报志愿哪家强  报考风暴 填报志愿哪家强','','baokaofengbaotianbaozhiyuannajiaqiangbaokaofengbaotianbaozhiyuannajiaqiang','B','','http://zy.egao8.cc/upload/vod/2015-10-12/14446284130.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','224','0','269','150','0','0','0','10.0','4370','437','1458788458','1458788458','0','0','报考风暴 填报志愿哪家强  报考风暴 填报志愿哪家强','youku','0','','XMTMwMDI5OTYxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1355','官三代白素贞的身世之谜  官三代白素贞的身世之谜','','guansandaibaisuzhendeshenshizhimiguansandaibaisuzhendeshenshizhimi','G','','http://zy.egao8.cc/upload/vod/2015-10-12/14446283880.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','36','0','344','367','0','0','0','1.0','366','366','1458788458','1458788458','0','0','官三代白素贞的身世之谜  官三代白素贞的身世之谜','youku','0','','XMTI5NTUyODM2NA==','','','','');
INSERT INTO `mac_vod` VALUES('1356','胥渡吧恶搞配音视频孙悟坑大战流量怪  胥渡吧恶搞配音视频孙悟坑大战流量怪','','xudubaegaopeiyinshipinsunwukangdazhanliuliangguaixudubaegaopeiyinshipinsunwukangdazhanliuliangguai','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446283650.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','225','0','697','224','0','0','0','3.0','918','306','1458788458','1458788458','0','0','胥渡吧恶搞配音视频孙悟坑大战流量怪  胥渡吧恶搞配音视频孙悟坑大战流量怪','youku','0','','XMTI5NTY3OTkyOA==','','','','');
INSERT INTO `mac_vod` VALUES('1357','胥渡吧最新-唐僧单身之谜终于解开  胥渡吧最新-唐僧单身之谜终于解开','','xudubazuixintangsengdanshenzhimizhongyujiekaixudubazuixintangsengdanshenzhimizhongyujiekai','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446283420.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','778','0','99','600','0','0','0','7.0','1120','160','1458788458','1458788458','0','0','胥渡吧最新-唐僧单身之谜终于解开  胥渡吧最新-唐僧单身之谜终于解开','youku','0','','XMTI5NjQ1MzQxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1358','20神人恶搞配音- 胥渡吧搞笑视频-武松不哭  20神人恶搞配音-','','20shenrenegaopeiyinxudubagaoxiaoshipinwusongbuku20shenrenegaopeiyin','2','','http://zy.egao8.cc/upload/vod/2015-10-12/14446283150.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','779','0','162','342','0','0','0','3.0','369','123','1458788458','1458788458','0','0','20神人恶搞配音- 胥渡吧搞笑视频-武松不哭  20神人恶搞配音-','youku','0','','XMTI4NTQ3MDE3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1359','胥渡吧来袭 苏有朋笑哭不顾形象  胥渡吧来袭 苏有朋笑哭不顾形象','','xudubalaixisuyoupengxiaokubuguxingxiangxudubalaixisuyoupengxiaokubuguxingxiang','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446282920.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','652','0','594','518','0','0','0','2.0','632','316','1458788458','1458788458','0','0','胥渡吧来袭 苏有朋笑哭不顾形象  胥渡吧来袭 苏有朋笑哭不顾形象','youku','0','','XMTI5Mzg0OTA0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1360','每逢过年必心塞  每逢过年必心塞','','meifengguonianbixinsaimeifengguonianbixinsai','M','','http://zy.egao8.cc/upload/vod/2015-10-12/14446282700.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','416','0','445','662','0','0','0','5.0','2020','404','1458788458','1458788458','0','0','每逢过年必心塞  每逢过年必心塞','youku','0','','XMTI4MDY2MjA3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1361','搞笑视频-恶搞史诗级灾难大片  搞笑视频','','gaoxiaoshipinegaoshishijizainandapiangaoxiaoshipin','G','','http://zy.egao8.cc/upload/vod/2015-10-12/14446282430.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','825','0','608','135','0','0','0','4.0','260','65','1458788462','1458788462','0','0','搞笑视频-恶搞史诗级灾难大片  搞笑视频','youku','0','','XMTI4Njg5MTkxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1362','恶搞配音《松哥的天使梦》  恶搞配音','','egaopeiyinsonggedetianshimengegaopeiyin','E','','http://zy.egao8.cc/upload/vod/2015-10-12/14446282190.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','76','0','222','717','0','0','0','3.0','288','96','1458788462','1458788462','0','0','恶搞配音《松哥的天使梦》  恶搞配音','youku','0','','XMTI4MDE4NTk0NA==','','','','');
INSERT INTO `mac_vod` VALUES('1363','唐僧单身之谜终于解开  唐僧单身之','','tangsengdanshenzhimizhongyujiekaitangsengdanshenzhi','T','','http://zy.egao8.cc/upload/vod/2015-10-12/14446281900.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','195','0','795','24','0','0','0','2.0','644','322','1458788462','1458788462','0','0','唐僧单身之谜终于解开  唐僧单身之','youku','0','','XMTI4NDQzNTY2OA==','','','','');
INSERT INTO `mac_vod` VALUES('1364','胥渡吧：年度盘点 笑死不偿命  年度盘点 笑死不偿命','','xudubaniandupandianxiaosibuchangmingniandupandianxiaosibuchangming','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446281630.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','234','0','659','248','0','0','0','2.0','352','176','1458788462','1458788462','0','0','胥渡吧：年度盘点 笑死不偿命  年度盘点 笑死不偿命','youku','0','','XMTI3NjgxMDcyNA==','','','','');
INSERT INTO `mac_vod` VALUES('1365','张飞干的好事  干的好事','','zhangfeigandehaoshigandehaoshi','Z','','http://zy.egao8.cc/upload/vod/2015-10-12/14446281380.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','837','0','489','51','0','0','0','6.0','816','136','1458788462','1458788462','0','0','张飞干的好事  干的好事','youku','0','','XMTI4MTg0MzU1Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1366','唐僧卖肉记  唐僧卖肉记','','tangsengmairoujitangsengmairouji','T','','http://zy.egao8.cc/upload/vod/2015-10-12/14446281120.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','492','0','555','810','0','0','0','2.0','704','352','1458788462','1458788462','0','0','唐僧卖肉记  唐僧卖肉记','youku','0','','XMTI3NTk0Njg5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1367','胥渡吧：舌尖上的吃货  舌尖上的吃货','','xudubashejianshangdechihuoshejianshangdechihuo','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446280810.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','782','0','969','873','0','0','0','5.0','1365','273','1458788462','1458788462','0','0','胥渡吧：舌尖上的吃货  舌尖上的吃货','youku','0','','XMTI3NDg0NTg1Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1368','每逢过年必心塞  每逢过年','','meifengguonianbixinsaimeifengguonian','M','','http://zy.egao8.cc/upload/vod/2015-10-12/14446280500.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','631','0','941','806','0','0','0','9.0','2403','267','1458788462','1458788462','0','0','每逢过年必心塞  每逢过年','youku','0','','XMTI2OTA4NTMxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1369','高考过后众生相_','','gaokaoguohouzhongshengxiang','G','','http://zy.egao8.cc/upload/vod/2015-10-12/14446280190.gif','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','560','0','18','646','0','0','0','2.0','498','249','1458788462','1458788462','0','0','高考过后众生相_','youku','0','','XMTI2NDI3NDYxNg==','','','','');
INSERT INTO `mac_vod` VALUES('1370','名著不播 神剧称霸暑期档','','mingzhububoshenjuchenbashuqidang','M','','http://zy.egao8.cc/upload/vod/2015-10-12/14446279930.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','932','0','348','145','0','0','0','5.0','1545','309','1458788462','1458788462','0','0','名著不播 神剧称霸暑期档','youku','0','','XNzQ4NzI2OTE2','','','','');
INSERT INTO `mac_vod` VALUES('1371','西游小妖大逆袭，不靠拼爹靠活好  胥渡吧：','','xiyouxiaoyaodanixibukaopindiekaohuohaoxuduba','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446279670.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','204','0','917','26','0','0','0','7.0','2310','330','1458788462','1458788462','0','0','西游小妖大逆袭，不靠拼爹靠活好  胥渡吧：','youku','0','','XMTI2ODAxNDI2OA==','','','','');
INSERT INTO `mac_vod` VALUES('1372','胥渡吧 后宫值班转 爆笑  胥渡吧 后宫值班转 爆笑','','xudubahougongzhibanzhuanbaoxiaoxudubahougongzhibanzhuanbaoxiao','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446279390.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','176','0','808','231','0','0','0','7.0','833','119','1458788462','1458788462','0','0','胥渡吧 后宫值班转 爆笑  胥渡吧 后宫值班转 爆笑','youku','0','','XMTM0OTU4MjIxNg==','','','','');
INSERT INTO `mac_vod` VALUES('1373','慎入，笑死不负责  慎入，笑死不负责','','shenruxiaosibufuzeshenruxiaosibufuze','S','','http://zy.egao8.cc/upload/vod/2015-10-12/14446279100.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','244','0','446','170','0','0','0','4.0','124','31','1458788462','1458788462','0','0','慎入，笑死不负责  慎入，笑死不负责','youku','0','','XMTMzNDkwMzczMg==','','','','');
INSERT INTO `mac_vod` VALUES('1374','南安市公安局溪美派出所第三期“捕快乐”  警营文化播报---《小白说事--老张成名记》爆笑来袭','','nananshigonganjuximeipaichusuodisanqibukuailejingyingwenhuabobaoxiaobaishuoshilaozhangchengmingjibaoxiaolaixi','N','','http://zy.egao8.cc/upload/vod/2015-10-12/14446278760.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','645','0','852','972','0','0','0','5.0','445','89','1458788462','1458788462','0','0','南安市公安局溪美派出所第三期“捕快乐”  警营文化播报---《小白说事--老张成名记》爆笑来袭','youku','0','','XMTI2NjAyOTY4MA==','','','','');
INSERT INTO `mac_vod` VALUES('1375','悟空的齐B小短裙  悟空的齐B小短裙','','wukongdeqiBxiaoduanqunwukongdeqiBxiaoduanqun','W','','http://zy.egao8.cc/upload/vod/2015-10-12/14446278520.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','712','0','888','734','0','0','0','2.0','234','117','1458788462','1458788462','0','0','悟空的齐B小短裙  悟空的齐B小短裙','youku','0','','XMTMyNjE5MzczNg==','','','','');
INSERT INTO `mac_vod` VALUES('1376','西游火拼记  西游火拼记','','xiyouhuopinjixiyouhuopinji','X','','http://zy.egao8.cc/upload/vod/2015-10-12/14446278210.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','120','0','511','774','0','0','0','8.0','2872','359','1458788462','1458788462','0','0','西游火拼记  西游火拼记','youku','0','','XMTMxODAzNjUzMg==','','','','');
INSERT INTO `mac_vod` VALUES('1377','大盘暴跌真相 灭绝师太跳楼为哪般  大盘暴跌真相','','dapanbaodiezhenxiangmiejueshitaitiaolouweinabandapanbaodiezhenxiang','D','','http://zy.egao8.cc/upload/vod/2015-10-12/14446277940.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','139','0','23','875','0','0','0','5.0','525','105','1458788462','1458788462','0','0','大盘暴跌真相 灭绝师太跳楼为哪般  大盘暴跌真相','youku','0','','XMTMzNjIyMjI3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1378','我要上春晚 创意配音秀  我要上春晚 创意配音秀','','woyaoshangchunwanchuangyipeiyinxiuwoyaoshangchunwanchuangyipeiyinxiu','W','','http://zy.egao8.cc/upload/vod/2015-10-12/14446277650.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','882','0','317','542','0','0','0','5.0','1595','319','1458788462','1458788462','0','0','我要上春晚 创意配音秀  我要上春晚 创意配音秀','youku','0','','XMTMyNDU3OTE2NA==','','','','');
INSERT INTO `mac_vod` VALUES('1379','丝滑的正确打开方式  丝滑的正确打开方式','','sihuadezhengquedakaifangshisihuadezhengquedakaifangshi','S','','http://zy.egao8.cc/upload/vod/2015-10-12/14446277370.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','556','0','132','247','0','0','0','2.0','520','260','1458788462','1458788462','0','0','丝滑的正确打开方式  丝滑的正确打开方式','youku','0','','XMTMxODIwMjM4OA==','','','','');
INSERT INTO `mac_vod` VALUES('1380','我要上春晚 创意配音秀 表演  我要上春晚 创意配音秀 表演','','woyaoshangchunwanchuangyipeiyinxiubiaoyanwoyaoshangchunwanchuangyipeiyinxiubiaoyan','W','','http://zy.egao8.cc/upload/vod/2015-10-12/14446277070.png','','','','','','','大陆','','0','5','','','0','0','0','0','0','0','0','0','712','0','301','683','0','0','0','4.0','440','110','1458788462','1458788462','0','0','我要上春晚 创意配音秀 表演  我要上春晚 创意配音秀 表演','youku','0','','XMTMxODg1NTc4MA==','','','','');
INSERT INTO `mac_vod` VALUES('1381','静态电影《让田螺飞》—那些钞票燃烧的岁月','','jingtaidianyingrangtianluofeinaxiechaopiaoranshaodesuiyue','J','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879019.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','595','0','297','60','0','0','0','3.0','165','55','1458788508','1458788508','0','0','静态电影《让田螺飞》—那些钞票燃烧的岁月','youku','0','','XMjQwMzIxOTY4','','','','');
INSERT INTO `mac_vod` VALUES('1382','沙画演绎爱情歌曲《幸福的彩虹》','','shahuayanyiaiqinggequxingfudecaihong','S','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887943.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','311','0','22','367','0','0','0','6.0','2868','478','1458788508','1458788508','0','0','沙画演绎爱情歌曲《幸福的彩虹》','youku','0','','XMTk4OTM0MzA4','','','','');
INSERT INTO `mac_vod` VALUES('1383','80后球迷内牛满面的回忆：世界杯的梦','','80houqiuminaniumanmiandehuiyishijiebeidemeng','8','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887945.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','173','0','826','598','0','0','0','8.0','3640','455','1458788508','1458788508','0','0','80后球迷内牛满面的回忆：世界杯的梦','youku','0','','XMTg4ODY1MjA0','','','','');
INSERT INTO `mac_vod` VALUES('1384','那些年：追过的女孩','','naxienianzhuiguodenvhai','N','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887947.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','14','0','73','353','0','0','0','6.0','342','57','1458788508','1458788508','0','0','那些年：追过的女孩','youku','0','','XMTk3MjUzODgw','','','','');
INSERT INTO `mac_vod` VALUES('1385','007全球追捕未来帝','','007quanqiuzhuibuweilaidi','0','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887949.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','7','0','219','446','0','0','0','9.0','2511','279','1458788508','1458788508','0','0','007全球追捕未来帝','youku','0','','XMTkwMTQ1ODg0','','','','');
INSERT INTO `mac_vod` VALUES('1386','《人再囧途之渝囧》重庆话配音亮了！','','renzaituzhiyuzhongqinghuapeiyinliangliao','R','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879411.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','925','0','67','165','0','0','0','5.0','810','162','1458788508','1458788508','0','0','《人再囧途之渝囧》重庆话配音亮了！','youku','0','','XNTA4OTU5NzE2','','','','');
INSERT INTO `mac_vod` VALUES('1387','孟姜女的三角恋','','mengjiangnvdesanjiaolian','M','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879413.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','379','0','9','511','0','0','0','8.0','3352','419','1458788508','1458788508','0','0','孟姜女的三角恋','youku','0','','XMTMyNjUyNTI0','','','','');
INSERT INTO `mac_vod` VALUES('1388','变形金刚之网络战','','bianxingjingangzhiwangluozhan','B','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879414.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','76','0','286','459','0','0','0','10.0','590','59','1458788508','1458788508','0','0','变形金刚之网络战','youku','0','','XMTMyNjczNjI0','','','','');
INSERT INTO `mac_vod` VALUES('1389','哈利波特与重庆妹儿','','haliboteyuzhongqingmeier','H','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879416.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','68','0','227','200','0','0','0','1.0','15','15','1458788508','1458788508','0','0','哈利波特与重庆妹儿','youku','0','','XNDMwMDA2MjQ4','','','','');
INSERT INTO `mac_vod` VALUES('1390','歪歌讽刺《钱钱钱》','','waigefengciqianqianqian','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879419.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','999','0','510','392','0','0','0','5.0','1320','264','1458788508','1458788508','0','0','歪歌讽刺《钱钱钱》','youku','0','','XMjUxMjMxNDY0','','','','');
INSERT INTO `mac_vod` VALUES('1391','蜗居惊魂夜','','wojijinghunye','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887981.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','357','0','404','417','0','0','0','10.0','4570','457','1458788508','1458788508','0','0','蜗居惊魂夜','youku','0','','XMTc0MjkzMjQ4','','','','');
INSERT INTO `mac_vod` VALUES('1392','猥琐男重庆方言版《昨日重现》','','weisuonanzhongqingfangyanbanzuorizhongxian','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887983.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','725','0','22','621','0','0','0','10.0','420','42','1458788508','1458788508','0','0','猥琐男重庆方言版《昨日重现》','youku','0','','XMTY3MjgzMDQ0','','','','');
INSERT INTO `mac_vod` VALUES('1393','原创MV《爱的感觉》','','yuanchuangMVaideganjue','Y','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887985.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','27','0','571','570','0','0','0','1.0','387','387','1458788508','1458788508','0','0','原创MV《爱的感觉》','youku','0','','XMjQzODk0NDA4','','','','');
INSERT INTO `mac_vod` VALUES('1394','723动车事故周年祭：我把思念寄给你','','723dongcheshiguzhounianjiwobasinianjigeini','7','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887987.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','785','0','602','300','0','0','0','9.0','3672','408','1458788508','1458788508','0','0','723动车事故周年祭：我把思念寄给你','youku','0','','XNDMwMDQwOTMy','','','','');
INSERT INTO `mac_vod` VALUES('1395','乡村屌丝MV系列之《俺们村的人》','','xiangcunsiMVxiliezhianmencunderen','X','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887989.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','360','0','260','565','0','0','0','6.0','1164','194','1458788508','1458788508','0','0','乡村屌丝MV系列之《俺们村的人》','youku','0','','XNTYzNTUxNTI0','','','','');
INSERT INTO `mac_vod` VALUES('1396','《望天树·阿莲雅》—：自拍阿凡达2','','wangtianshualianyazipaiafanda2','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879810.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','210','0','532','87','0','0','0','1.0','130','130','1458788508','1458788508','0','0','《望天树·阿莲雅》—：自拍阿凡达2','youku','0','','XMTg1MzI5OTcy','','','','');
INSERT INTO `mac_vod` VALUES('1397','雷人儿童 汉奸鬼子兵','','leirenertonghanjianguizibing','L','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879811.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','135','0','501','807','0','0','0','2.0','42','21','1458788508','1458788508','0','0','雷人儿童 汉奸鬼子兵','youku','0','','XMTc4NzM2NjI0','','','','');
INSERT INTO `mac_vod` VALUES('1398','《山寨版2012》','','shanzhaiban2012','S','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879813.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','531','0','593','137','0','0','0','10.0','2210','221','1458788508','1458788508','0','0','《山寨版2012》','youku','0','','XMjg1Mjg0Mjky','','','','');
INSERT INTO `mac_vod` VALUES('1399','：巨制：灾难大片《2012》中国版','','juzhizainandapian2012zhongguoban','J','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879815.jpg','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','635','0','827','205','0','0','0','10.0','2560','256','1458788508','1458788508','0','0','：巨制：灾难大片《2012》中国版','youku','0','','XMjgyOTU5OTU2','','','','');
INSERT INTO `mac_vod` VALUES('1400','2012末日杀手系列之《杀手的礼物》avi','','2012morishashouxiliezhishashoudeliwuavi','2','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879817.jpg','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','780','0','66','107','0','0','0','4.0','1792','448','1458788509','1458788509','0','0','2012末日杀手系列之《杀手的礼物》avi','youku','0','','XMzU3OTY0MDgw','','','','');
INSERT INTO `mac_vod` VALUES('1401','海之爱最新：安居古城之《屌丝泡洋妞》','','haizhiaizuixinanjiguchengzhisipaoyangniu','H','','http://zy.egao8.cc/upload/vod/2016-02-23/145618878615.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','641','0','267','162','0','0','0','6.0','246','41','1458788520','1458788520','0','0','海之爱最新：安居古城之《屌丝泡洋妞》','youku','0','','XMTMwMzYyNTgxMg==','','','','');
INSERT INTO `mac_vod` VALUES('1402','海之爱最新作品：屌丝剧务之《碧玉簪》','','haizhiaizuixinzuopinsijuwuzhibiyuzan','H','','http://zy.egao8.cc/upload/vod/2016-02-23/145618878616.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','488','0','732','154','0','0','0','9.0','2943','327','1458788520','1458788520','0','0','海之爱最新作品：屌丝剧务之《碧玉簪》','youku','0','','XMTI5OTI3NDg0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1403','情感静像电影《向幸福出发》献给圣诞的礼物','','qingganjingxiangdianyingxiangxingfuchufaxiangeishengdandeliwu','Q','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879010.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','434','0','354','587','0','0','0','2.0','534','267','1458788520','1458788520','0','0','情感静像电影《向幸福出发》献给圣诞的礼物','youku','0','','XMzM1MjY1NjI4','','','','');
INSERT INTO `mac_vod` VALUES('1404','变形金刚之龙珠争夺战','','bianxingjingangzhilongzhuzhengduozhan','B','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879012.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','687','0','873','933','0','0','0','2.0','244','122','1458788520','1458788520','0','0','变形金刚之龙珠争夺战','youku','0','','XMTEyMjU3NTY0','','','','');
INSERT INTO `mac_vod` VALUES('1405','元首的咆哮之城管篇','','yuanshoudepaoxiaozhichengguanpian','Y','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879014.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','796','0','119','884','0','0','0','5.0','370','74','1458788520','1458788520','0','0','元首的咆哮之城管篇','youku','0','','XMjY1NDY2ODgw','','','','');
INSERT INTO `mac_vod` VALUES('1406','农村屌丝自励MV《够坚强》','','nongcunsiziliMVgoujianqiang','N','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879016.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','906','0','269','601','0','0','0','9.0','3150','350','1458788520','1458788520','0','0','农村屌丝自励MV《够坚强》','youku','0','','XNTEzMTk2OTMy','','','','');
INSERT INTO `mac_vod` VALUES('1407','爱有来生《铜雀台style》','','aiyoulaishengtongquetaistyle','A','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879018.gif','','','海之爱','','','','大陆','','0','18','','','0','0','0','0','0','0','0','0','7','0','93','961','0','0','0','6.0','2112','352','1458788520','1458788520','0','0','爱有来生《铜雀台style》','youku','0','','XNDczNTc5MTk2','','','','');
INSERT INTO `mac_vod` VALUES('1408','《车模故事》外围女钱色交易的故事完整版','','chemogushiwaiweinvqiansejiaoyidegushiwanzhengban','C','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879818.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','179','0','203','813','0','0','0','7.0','1932','276','1458788576','1458788576','0','0','《车模故事》外围女钱色交易的故事完整版','youku','0','','XNzQzMTE0ODg0','','','','');
INSERT INTO `mac_vod` VALUES('1409','《毒你》舌尖上的中国','','dunishejianshangdezhongguo','D','','http://zy.egao8.cc/upload/vod/2016-02-23/145618879819.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','849','0','307','223','0','0','0','2.0','486','243','1458788576','1458788576','0','0','《毒你》舌尖上的中国','youku','0','','XNzM1NDY3MDAw','','','','');
INSERT INTO `mac_vod` VALUES('1410','某官员与情归偷情视频曝光','','mouguanyuanyuqingguitouqingshipinpuguang','M','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888021.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','36','0','455','727','0','0','0','2.0','834','417','1458788576','1458788576','0','0','某官员与情归偷情视频曝光','youku','0','','XNzQxOTAwODc2','','','','');
INSERT INTO `mac_vod` VALUES('1411','地道战之搞笑讽刺吐槽恶搞版《哄抢战》','','didaozhanzhigaoxiaofengcitucaoegaobanhongqiangzhan','D','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888022.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','603','0','292','577','0','0','0','5.0','680','136','1458788576','1458788576','0','0','地道战之搞笑讽刺吐槽恶搞版《哄抢战》','youku','0','','XNzA1NzA2NjMy','','','','');
INSERT INTO `mac_vod` VALUES('1412','赵四版《小苹果舞蹈》','','zhaosibanxiaopingguowudao','Z','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888023.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','508','1','308','999','0','0','0','3.0','108','36','1458788576','1458788576','1458790852','0','赵四版《小苹果舞蹈》','youku','0','','XNzM3MjM1ODIw','','','','');
INSERT INTO `mac_vod` VALUES('1413','日本女优波多野结衣《女优之歌》','','ribennvyouboduoyejieyinvyouzhige','R','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888024.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','50','0','80','430','0','0','0','10.0','1730','173','1458788576','1458788576','0','0','日本女优波多野结衣《女优之歌》','youku','0','','XNjgyMzgzMzcy','','','','');
INSERT INTO `mac_vod` VALUES('1414','小苹果版性感美女美腿丝袜诱惑热舞','','xiaopingguobanxingganmeinvmeituisiwayouhuorewu','X','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888025.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','126','0','539','783','0','0','0','2.0','302','151','1458788576','1458788576','0','0','小苹果版性感美女美腿丝袜诱惑热舞','youku','0','','XNzM2NzM1Mzc2','','','','');
INSERT INTO `mac_vod` VALUES('1415','性感美女热舞版小苹果','','xingganmeinvrewubanxiaopingguo','X','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888026.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','472','0','203','686','0','0','0','10.0','2450','245','1458788576','1458788576','0','0','性感美女热舞版小苹果','youku','0','','XNzQ2Mzk1NTg4','','','','');
INSERT INTO `mac_vod` VALUES('1416','《失身情歌》单身情歌之欲望','','shishenqinggedanshenqinggezhiyuwang','S','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888027.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','922','0','434','737','0','0','0','10.0','270','27','1458788576','1458788576','0','0','《失身情歌》单身情歌之欲望','youku','0','','XNzIxODkwMjY4','','','','');
INSERT INTO `mac_vod` VALUES('1417','小苹果各种美女热舞','','xiaopingguogezhongmeinvrewu','X','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888028.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','650','0','690','753','0','0','0','1.0','491','491','1458788576','1458788576','0','0','小苹果各种美女热舞','youku','0','','XNzQ2MzE5NjE2','','','','');
INSERT INTO `mac_vod` VALUES('1418','吃喝讽刺吐槽恶搞版《酒肉酒的酒》','','chihefengcitucaoegaobanjiuroujiudejiu','C','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888029.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','427','0','772','18','0','0','0','1.0','179','179','1458788576','1458788576','0','0','吃喝讽刺吐槽恶搞版《酒肉酒的酒》','youku','0','','XNjk0ODc2ODQ0','','','','');
INSERT INTO `mac_vod` VALUES('1419','小城故事之外围女钱色交易版《车模故事》','','xiaochenggushizhiwaiweinvqiansejiaoyibanchemogushi','X','','http://zy.egao8.cc/upload/vod/2016-02-23/145618880213.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','865','0','74','537','0','0','0','5.0','1515','303','1458788576','1458788576','0','0','小城故事之外围女钱色交易版《车模故事》','youku','0','','XNzQ1Mjk1NDQw','','','','');
INSERT INTO `mac_vod` VALUES('1420','爱情买卖之犯罪版<病毒灵买卖＞','','aiqingmaimaizhifanzuibanbingdulingmaimai','A','','http://zy.egao8.cc/upload/vod/2016-02-23/145618880215.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','677','39','839','287','0','0','0','3.0','1119','373','1458788576','1458788576','1458790721','0','爱情买卖之犯罪版<病毒灵买卖＞','youku','0','','XNjg0NTAwNTA0','','','','');
INSERT INTO `mac_vod` VALUES('1421','奥特曼版小苹果舞蹈','','aotemanbanxiaopingguowudao','A','','http://zy.egao8.cc/upload/vod/2016-02-23/145618880217.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','898','0','386','444','0','0','0','7.0','2240','320','1458788576','1458788576','0','0','奥特曼版小苹果舞蹈','youku','0','','XNzM4MTY1NzQ0','','','','');
INSERT INTO `mac_vod` VALUES('1422','最炫民族风之恶搞车震版《最炫偷情风》','','zuixuanminzufengzhiegaochezhenbanzuixuantouqingfeng','Z','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888062.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','189','0','403','684','0','0','0','1.0','124','124','1458788576','1458788576','0','0','最炫民族风之恶搞车震版《最炫偷情风》','youku','0','','XNzE0NzA5NDI4','','','','');
INSERT INTO `mac_vod` VALUES('1423','阿初歪歌《最炫偷情风》','','achuwaigezuixuantouqingfeng','A','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888064.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','31','0','156','380','0','0','0','1.0','435','435','1458788576','1458788576','0','0','阿初歪歌《最炫偷情风》','youku','0','','XNzE0MDY5OTQ0','','','','');
INSERT INTO `mac_vod` VALUES('1424','走天涯之教师版《跳山涯》','','zoutianyazhijiaoshibantiaoshanya','Z','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888068.jpg','','','阿初','','','','大陆','','0','20','','','0','0','0','0','0','0','0','0','8','0','759','880','0','0','0','3.0','597','199','1458788576','1458788576','0','0','走天涯之教师版《跳山涯》','youku','0','','XNjg3MTk2MDQ4','','','','');
INSERT INTO `mac_vod` VALUES('1425','新剑侠传奇刷新国产游戏下限','','xinjianxiachuanqishuaxinguochanyouxixiaxian','X','','http://zy.egao8.cc/upload/vod/2015-10-14/14447964425.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','937','0','361','29','0','0','0','8.0','1800','225','1458788632','1458788632','0','0','新剑侠传奇刷新国产游戏下限','youku','0','','XNzQ3NjI0NDQ4','','','','');
INSERT INTO `mac_vod` VALUES('1426','当荣誉勋章遭遇龙之谷 囧的呼唤85集-娱乐悖论','','dangrongyuxunzhangzaoyulongzhigudehuhuan85jiyulebeilun','D','','http://zy.egao8.cc/upload/vod/2015-10-14/144479679610.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','170','0','828','840','0','0','0','7.0','2898','414','1458788632','1458788632','0','0','当荣誉勋章遭遇龙之谷 囧的呼唤85集-娱乐悖论','youku','0','','54253241','','','','');
INSERT INTO `mac_vod` VALUES('1427','厂长不好!金将军来偷鸡了 囧的呼唤90期-将军来了','','changchangbuhaojinjiangjunlaitoujiliaodehuhuan90qijiangjunlailiao','C','','http://zy.egao8.cc/upload/vod/2015-10-14/144479680212.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','415','0','430','537','0','0','0','3.0','84','28','1458788632','1458788632','0','0','厂长不好!金将军来偷鸡了 囧的呼唤90期-将军来了','youku','0','','58557138','','','','');
INSERT INTO `mac_vod` VALUES('1428','那年圣诞，我的爷爷在越南 囧的呼唤89期-早安越南','','nanianshengdanwodeyeyezaiyuenandehuhuan89qizaoanyuenan','N','','http://zy.egao8.cc/upload/vod/2015-10-14/144479680513.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','569','0','92','31','0','0','0','3.0','510','170','1458788632','1458788632','0','0','那年圣诞，我的爷爷在越南 囧的呼唤89期-早安越南','youku','0','','58008962','','','','');
INSERT INTO `mac_vod` VALUES('1429','世界上最垃圾的射击游戏 囧的呼唤97期-垃圾FPS','','shijieshangzuilajideshejiyouxidehuhuan97qilajiFPS','S','','http://zy.egao8.cc/upload/vod/2015-10-14/144479680614.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','369','0','333','950','0','0','0','7.0','805','115','1458788632','1458788632','0','0','世界上最垃圾的射击游戏 囧的呼唤97期-垃圾FPS','youku','0','','63270310','','','','');
INSERT INTO `mac_vod` VALUES('1430','迅速烧毁你显卡的五款游戏 囧的呼唤91期-显卡毁灭者','','xunsushaohuinixiankadewukuanyouxidehuhuan91qixiankahuimiezhe','X','','http://zy.egao8.cc/upload/vod/2015-10-14/144479681117.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','646','0','518','892','0','0','0','2.0','872','436','1458788632','1458788632','0','0','迅速烧毁你显卡的五款游戏 囧的呼唤91期-显卡毁灭者','youku','0','','59594080','','','','');
INSERT INTO `mac_vod` VALUES('1431','比血狮更傻更天真的游戏 囧的呼唤第101期','','bixueshigengshagengtianzhendeyouxidehuhuandi101qi','B','','http://zy.egao8.cc/upload/vod/2015-10-14/144479681218.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','578','0','102','673','0','0','0','7.0','889','127','1458788632','1458788632','0','0','比血狮更傻更天真的游戏 囧的呼唤第101期','youku','0','','68200551','','','','');
INSERT INTO `mac_vod` VALUES('1432','一款连女生都能蛋疼的游戏 囧的呼唤95期-摇摆大陆','','yikuanliannvshengdunendantengdeyouxidehuhuan95qiyaobaidalu','Y','','http://zy.egao8.cc/upload/vod/2015-10-14/14447968271.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','933','0','887','579','0','0','0','10.0','2280','228','1458788632','1458788632','0','0','一款连女生都能蛋疼的游戏 囧的呼唤95期-摇摆大陆','youku','0','','62141983','','','','');
INSERT INTO `mac_vod` VALUES('1433','一场炒作一场梦 囧的呼唤99期-天堂梦','','yichangchaozuoyichangmengdehuhuan99qitiantangmeng','Y','','http://zy.egao8.cc/upload/vod/2015-10-14/14447968344.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','324','0','267','613','0','0','0','5.0','2270','454','1458788632','1458788632','0','0','一场炒作一场梦 囧的呼唤99期-天堂梦','youku','0','','65235606','','','','');
INSERT INTO `mac_vod` VALUES('1434','一款女生都爱的暴菊游戏 囧的呼唤103期','','yikuannvshengduaidebaojuyouxidehuhuan103qi','Y','','http://zy.egao8.cc/upload/vod/2015-10-14/14447968388.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','459','0','481','748','0','0','0','3.0','939','313','1458788632','1458788632','0','0','一款女生都爱的暴菊游戏 囧的呼唤103期','youku','0','','70317294','','','','');
INSERT INTO `mac_vod` VALUES('1435','篮球是原来是棒子发明的 囧的呼唤新105期','','lanqiushiyuanlaishibangzifamingdedehuhuanxin105qi','L','','http://zy.egao8.cc/upload/vod/2015-10-14/144479684110.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','389','0','860','176','0','0','0','7.0','1659','237','1458788632','1458788632','0','0','篮球是原来是棒子发明的 囧的呼唤新105期','youku','0','','74501088','','','','');
INSERT INTO `mac_vod` VALUES('1436','历经三次屏蔽和整改,终于面世 囧的呼唤109期','','lijingsancipingbihezhenggaizhongyumianshidehuhuan109qi','L','','http://zy.egao8.cc/upload/vod/2015-10-14/144479684212.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','757','0','81','557','0','0','0','8.0','1640','205','1458788632','1458788632','0','0','历经三次屏蔽和整改,终于面世 囧的呼唤109期','youku','0','','76246999','','','','');
INSERT INTO `mac_vod` VALUES('1437','史上最坑爹的游戏续作 囧的呼唤106期','','shishangzuikangdiedeyouxixuzuodehuhuan106qi','S','','http://zy.egao8.cc/upload/vod/2015-10-14/144479684514.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','53','0','412','269','0','0','0','4.0','1468','367','1458788632','1458788632','0','0','史上最坑爹的游戏续作 囧的呼唤106期','youku','0','','74707690','','','','');
INSERT INTO `mac_vod` VALUES('1438','血狮自豪表示自己后继有人 囧的呼唤113期','','xueshizihaobiaoshizijihoujiyourendehuhuan113qi','X','','http://zy.egao8.cc/upload/vod/2015-10-14/144479684716.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','858','0','968','660','0','0','0','1.0','171','171','1458788632','1458788632','0','0','血狮自豪表示自己后继有人 囧的呼唤113期','youku','0','','81498165','','','','');
INSERT INTO `mac_vod` VALUES('1439','请给仙剑奇侠传5多一点宽容 囧的呼唤117期','','qinggeixianjianqixiachuan5duoyidiankuanrongdehuhuan117qi','Q','','http://zy.egao8.cc/upload/vod/2015-10-14/144479685018.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','98','0','954','296','0','0','0','4.0','1936','484','1458788632','1458788632','0','0','请给仙剑奇侠传5多一点宽容 囧的呼唤117期','youku','0','','83838515','','','','');
INSERT INTO `mac_vod` VALUES('1440','过去对付脑残的方式弱爆了 囧的呼唤94期-致命工程','','guoquduifunaocandefangshiruobaoliaodehuhuan94qizhiminggongcheng','G','','http://zy.egao8.cc/upload/vod/2015-10-14/144479687110.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','292','0','923','214','0','0','0','9.0','2025','225','1458788632','1458788632','0','0','过去对付脑残的方式弱爆了 囧的呼唤94期-致命工程','youku','0','','61044663','','','','');
INSERT INTO `mac_vod` VALUES('1441','这款垃圾让国产游戏找回尊严 囧的呼唤98期-阴谋','','zhekuanlajirangguochanyouxizhaohuizunyandehuhuan98qiyinmou','Z','','http://zy.egao8.cc/upload/vod/2015-10-14/144479687513.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','805','0','18','166','0','0','0','8.0','3840','480','1458788632','1458788632','0','0','这款垃圾让国产游戏找回尊严 囧的呼唤98期-阴谋','youku','0','','63849635','','','','');
INSERT INTO `mac_vod` VALUES('1442','人民教师竟如此教越南话 囧的呼唤107期','','renminjiaoshijingrucijiaoyuenanhuadehuhuan107qi','R','','http://zy.egao8.cc/upload/vod/2015-10-14/14447969097.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','92','0','228','876','0','0','0','10.0','1340','134','1458788632','1458788632','0','0','人民教师竟如此教越南话 囧的呼唤107期','youku','0','','75235830','','','','');
INSERT INTO `mac_vod` VALUES('1443','我见过长相最讨打的怪物 囧的呼唤108期','','wojianguochangxiangzuitaodadeguaiwudehuhuan108qi','W','','http://zy.egao8.cc/upload/vod/2015-10-14/144479691210.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','955','0','634','284','0','0','0','2.0','986','493','1458788632','1458788632','0','0','我见过长相最讨打的怪物 囧的呼唤108期','youku','0','','75674408','','','','');
INSERT INTO `mac_vod` VALUES('1444','一款让更年期提前来的游戏 囧的呼唤116期','','yikuanranggengnianqitiqianlaideyouxidehuhuan116qi','Y','','http://zy.egao8.cc/upload/vod/2015-10-14/144479691913.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','789','0','663','801','0','0','0','7.0','2884','412','1458788632','1458788632','0','0','一款让更年期提前来的游戏 囧的呼唤116期','youku','0','','83278876','','','','');
INSERT INTO `mac_vod` VALUES('1445','马化腾之心,路人皆知 囧的呼唤93期-野心的根源','','mahuatengzhixinlurenjiezhidehuhuan93qiyexindegenyuan','M','','http://zy.egao8.cc/upload/vod/2015-10-14/144479663214.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','45','0','417','752','0','0','0','2.0','572','286','1458788686','1458788686','0','0','马化腾之心,路人皆知 囧的呼唤93期-野心的根源','youku','0','','60351447','','','','');
INSERT INTO `mac_vod` VALUES('1446','山寨之王与坑钱公爵 囧的呼唤102期','','shanzhaizhiwangyukangqiangongjuedehuhuan102qi','S','','http://zy.egao8.cc/upload/vod/2015-10-14/144479663716.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','662','0','683','28','0','0','0','4.0','448','112','1458788686','1458788686','0','0','山寨之王与坑钱公爵 囧的呼唤102期','youku','0','','69857393','','','','');
INSERT INTO `mac_vod` VALUES('1447','至今配置要求最变态游戏 囧的呼唤第100期','','zhijinpeizhiyaoqiuzuibiantaiyouxidehuhuandi100qi','Z','','http://zy.egao8.cc/upload/vod/2015-10-14/144479664018.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','221','0','699','465','0','0','0','2.0','532','266','1458788686','1458788686','0','0','至今配置要求最变态游戏 囧的呼唤第100期','youku','0','','67010264','','','','');
INSERT INTO `mac_vod` VALUES('1448','奥特曼同学躺着中枪 囧的呼唤104期','','aotemantongxuethangzhouzhongqiangdehuhuan104qi','A','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967291.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','180','0','456','784','0','0','0','3.0','393','131','1458788686','1458788686','0','0','奥特曼同学躺着中枪 囧的呼唤104期','youku','0','','71787427','','','','');
INSERT INTO `mac_vod` VALUES('1449','都是人民币惹得祸! 囧的呼唤111期','','dushirenminbiruodehuodehuhuan111qi','D','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967313.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','340','0','34','927','0','0','0','7.0','98','14','1458788686','1458788686','0','0','都是人民币惹得祸! 囧的呼唤111期','youku','0','','77176892','','','','');
INSERT INTO `mac_vod` VALUES('1450','让人HOLD不住的印度游戏 囧的呼唤110期','','rangrenHOLDbuzhudeyinduyouxidehuhuan110qi','R','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967425.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','95','0','860','303','0','0','0','4.0','1076','269','1458788686','1458788686','0','0','让人HOLD不住的印度游戏 囧的呼唤110期','youku','0','','76649770','','','','');
INSERT INTO `mac_vod` VALUES('1451','请别跟我说抄袭CF! 囧的呼唤番外2','','qingbiegenwoshuochaoxiCFdehuhuanfanwai2','Q','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967617.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','684','0','954','42','0','0','0','9.0','3789','421','1458788686','1458788686','0','0','请别跟我说抄袭CF! 囧的呼唤番外2','youku','0','','80296893','','','','');
INSERT INTO `mac_vod` VALUES('1452','细数那些令人陶醉的游戏场景 囧的呼唤115期','','xishunaxielingrentaozuideyouxichangjingdehuhuan115qi','X','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967639.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','438','0','177','242','0','0','0','6.0','1758','293','1458788686','1458788686','0','0','细数那些令人陶醉的游戏场景 囧的呼唤115期','youku','0','','82658431','','','','');
INSERT INTO `mac_vod` VALUES('1453','国产网游请勿侮辱虚幻3 囧的呼唤114期','','guochanwangyouqingwuwuruxuhuan3dehuhuan114qi','G','','http://zy.egao8.cc/upload/vod/2015-10-14/144479676511.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','34','0','488','219','0','0','0','5.0','640','128','1458788686','1458788686','0','0','国产网游请勿侮辱虚幻3 囧的呼唤114期','youku','0','','82080469','','','','');
INSERT INTO `mac_vod` VALUES('1454','刺客信条2最强恶搞 囧的呼唤70集-复仇信条','','cikexintiao2zuiqiangegaodehuhuan70jifuchouxintiao','C','','http://zy.egao8.cc/upload/vod/2015-10-14/144479676813.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','740','0','187','757','0','0','0','2.0','436','218','1458788686','1458788686','0','0','刺客信条2最强恶搞 囧的呼唤70集-复仇信条','youku','0','','41026213','','','','');
INSERT INTO `mac_vod` VALUES('1455','三位游戏大师的吐血推荐 囧的呼唤66集-雨霏之声','','sanweiyouxidashidetuxuetuijiandehuhuan66jiyufeizhisheng','S','','http://zy.egao8.cc/upload/vod/2015-10-14/144479676914.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','671','0','169','362','0','0','0','6.0','156','26','1458788686','1458788686','0','0','三位游戏大师的吐血推荐 囧的呼唤66集-雨霏之声','youku','0','','39786081','','','','');
INSERT INTO `mac_vod` VALUES('1456','湖人季后首轮惨遭黑八 囧的呼唤71集-雷霆划空','','hurenjihoushouluncanzaoheibadehuhuan71jileitinghuakong','H','','http://zy.egao8.cc/upload/vod/2015-10-14/144479677416.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','32','0','171','505','0','0','0','3.0','933','311','1458788686','1458788686','0','0','湖人季后首轮惨遭黑八 囧的呼唤71集-雷霆划空','youku','0','','41409895','','','','');
INSERT INTO `mac_vod` VALUES('1457','战地叛逆连2最强恶搞 囧的呼唤68集-救赎战役','','zhandipannilian2zuiqiangegaodehuhuan68jijiushuzhanyi','Z','','http://zy.egao8.cc/upload/vod/2015-10-14/144479677517.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','376','0','27','878','0','0','0','9.0','2286','254','1458788686','1458788686','0','0','战地叛逆连2最强恶搞 囧的呼唤68集-救赎战役','youku','0','','40203122','','','','');
INSERT INTO `mac_vod` VALUES('1458','女流化身园丁恶搞植物大战僵尸 囧的呼唤79集-最后的秘密','','nvliuhuashenyuandingegaozhiwudazhanjiangshidehuhuan79jizuihoudemimi','N','','http://zy.egao8.cc/upload/vod/2015-10-14/144479677719.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','846','0','912','642','0','0','0','2.0','170','85','1458788686','1458788686','0','0','女流化身园丁恶搞植物大战僵尸 囧的呼唤79集-最后的秘密','youku','0','','47421255','','','','');
INSERT INTO `mac_vod` VALUES('1459','命令与征服4抢先评测 囧的呼唤67集-CNC4','','minglingyuzhengfu4qiangxianpingcedehuhuan67jiCNC4','M','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967841.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','431','0','595','674','0','0','0','5.0','1025','205','1458788686','1458788686','0','0','命令与征服4抢先评测 囧的呼唤67集-CNC4','youku','0','','39871898','','','','');
INSERT INTO `mac_vod` VALUES('1460','求生之路2DLC抢先讲解 囧的呼唤72集-二度求生','','qiushengzhilu2DLCqiangxianjiangjiedehuhuan72jierduqiusheng','Q','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967842.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','212','0','689','823','0','0','0','8.0','2472','309','1458788686','1458788686','0','0','求生之路2DLC抢先讲解 囧的呼唤72集-二度求生','youku','0','','41946112','','','','');
INSERT INTO `mac_vod` VALUES('1461','星际争霸2蛋疼恶搞登场 囧的呼唤81集-自由之翼','','xingjizhengba2dantengegaodengchangdehuhuan81jiziyouzhiyi','X','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967874.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','616','0','902','155','0','0','0','10.0','170','17','1458788686','1458788686','0','0','星际争霸2蛋疼恶搞登场 囧的呼唤81集-自由之翼','youku','0','','48685841','','','','');
INSERT INTO `mac_vod` VALUES('1462','南非世界杯G组葡萄牙vs巴西 囧的呼唤75集-葡巴战争','','nanfeishijiebeiGzuputaoyavsbaxidehuhuan75jipubazhanzheng','N','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967896.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','663','0','285','205','0','0','0','5.0','2480','496','1458788686','1458788686','0','0','南非世界杯G组葡萄牙vs巴西 囧的呼唤75集-葡巴战争','youku','0','','44795993','','','','');
INSERT INTO `mac_vod` VALUES('1463','FC冒险岛惨遭基情解说 囧的呼唤80集-遗失的财富','','FCmaoxiandaocanzaojiqingjieshuodehuhuan80jiyishidecaifu','F','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967907.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','214','0','482','228','0','0','0','8.0','664','83','1458788686','1458788686','0','0','FC冒险岛惨遭基情解说 囧的呼唤80集-遗失的财富','youku','0','','47748532','','','','');
INSERT INTO `mac_vod` VALUES('1464','乔丹惨受易建联颜扣之辱 囧的呼唤92期-易帝降临','','qiaodancanshouyijianlianyankouzhirudehuhuan92qiyidijianglin','Q','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967929.jpg','','','老湿','','','','大陆','','0','23','','','0','0','0','0','0','0','0','0','228','0','980','445','0','0','0','2.0','824','412','1458788686','1458788686','0','0','乔丹惨受易建联颜扣之辱 囧的呼唤92期-易帝降临','youku','0','','60175933','','','','');
INSERT INTO `mac_vod` VALUES('1465','龙颜大悦021期：魔幻号 天涯配音公社','','longyandayue021qimohuanhaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','831','0','334','556','0','0','0','9.0','3744','416','1458788726','1458788726','0','0','龙颜大悦021期：魔幻号 天涯配音公社','youku','0','','57481447','','','','');
INSERT INTO `mac_vod` VALUES('1466','龙颜大悦010期：七夕号 天涯配音公社','','longyandayue010qiqixihaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','413','0','511','647','0','0','0','10.0','3270','327','1458788726','1458788726','0','0','龙颜大悦010期：七夕号 天涯配音公社','youku','0','','50543273','','','','');
INSERT INTO `mac_vod` VALUES('1467','萌化世界三大招  萌化世界','','menghuashijiesandazhaomenghuashijie','M','','http://www.xuduba.com/pic/uploadimg/2015-1/201512522111851394.png#err2015-10-14','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','212','0','150','389','0','0','0','4.0','1556','389','1458788726','1458788726','0','0','萌化世界三大招  萌化世界','youku','0','','XODc5MDU3Mzgw','','','','');
INSERT INTO `mac_vod` VALUES('1468','龙颜大悦002期：降妖除魔号 天涯配音公社','','longyandayue002qijiangyaochumohaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','496','0','552','568','0','0','0','3.0','1179','393','1458788726','1458788726','0','0','龙颜大悦002期：降妖除魔号 天涯配音公社','youku','0','','57353944','','','','');
INSERT INTO `mac_vod` VALUES('1469','龙颜大悦038期三八号：结婚向左，离婚往右','','longyandayue038qisanbahaojiehunxiangzuolihunwangyou','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','380','0','612','688','0','0','0','9.0','2718','302','1458788726','1458788726','0','0','龙颜大悦038期三八号：结婚向左，离婚往右','youku','0','','62320884','','','','');
INSERT INTO `mac_vod` VALUES('1470','龙颜大悦另类解说利比亚：《卡扎菲的愤怒》','','longyandayuelingleijieshuolibiyakazhafeidefennu','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','69','0','68','222','0','0','0','6.0','2256','376','1458788726','1458788726','0','0','龙颜大悦另类解说利比亚：《卡扎菲的愤怒》','youku','0','','63678827','','','','');
INSERT INTO `mac_vod` VALUES('1471','龙颜大悦034期村晚号：爆笑草根网络春晚','','longyandayue034qicunwanhaobaoxiaocaogenwangluochunwan','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','116','0','752','861','0','0','0','10.0','2960','296','1458788726','1458788726','0','0','龙颜大悦034期村晚号：爆笑草根网络春晚','youku','0','','60273623','','','','');
INSERT INTO `mac_vod` VALUES('1472','龙颜大悦027期：卡通号 天涯配音公社','','longyandayue027qikatonghaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','664','0','839','765','0','0','0','1.0','292','292','1458788726','1458788726','0','0','龙颜大悦027期：卡通号 天涯配音公社','youku','0','','57425196','','','','');
INSERT INTO `mac_vod` VALUES('1473','龙颜大悦032期春运号：给力的买票必杀技[让票飞翔吧]','','longyandayue032qichunyunhaogeilidemaipiaobishajirangpiaofeixiangba','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','702','0','101','812','0','0','0','10.0','2620','262','1458788726','1458788726','0','0','龙颜大悦032期春运号：给力的买票必杀技【让票飞翔吧】','youku','0','','59436850','','','','');
INSERT INTO `mac_vod` VALUES('1474','龙颜大悦022期：艰难决定号 天涯配音公社','','longyandayue022qijiannanjuedinghaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','312','0','148','852','0','0','0','8.0','3240','405','1458788726','1458788726','0','0','龙颜大悦022期：艰难决定号 天涯配音公社','youku','0','','57480852','','','','');
INSERT INTO `mac_vod` VALUES('1475','龙颜大悦029期：清仓号 天涯配音公社','','longyandayue029qiqingcanghaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','919','0','690','950','0','0','0','5.0','1700','340','1458788726','1458788726','0','0','龙颜大悦029期：清仓号 天涯配音公社','youku','0','','58257114','','','','');
INSERT INTO `mac_vod` VALUES('1476','龙颜大悦017期：爱祖国号 天涯配音公社','','longyandayue017qiaizuguohaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','543','0','775','641','0','0','0','2.0','466','233','1458788726','1458788726','0','0','龙颜大悦017期：爱祖国号 天涯配音公社','youku','0','','53535863','','','','');
INSERT INTO `mac_vod` VALUES('1477','龙颜大悦016期：不可说号 龙颜大悦','','longyandayue016qibukeshuohaolongyandayue','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','48','0','50','179','0','0','0','6.0','2526','421','1458788726','1458788726','0','0','龙颜大悦016期：不可说号 龙颜大悦','youku','0','','52520040','','','','');
INSERT INTO `mac_vod` VALUES('1478','龙颜大悦009期：知音号 天涯配音公社','','longyandayue009qizhiyinhaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','390','0','2','787','0','0','0','1.0','40','40','1458788726','1458788726','0','0','龙颜大悦009期：知音号 天涯配音公社','youku','0','','50540900','','','','');
INSERT INTO `mac_vod` VALUES('1479','龙颜大悦024期：抗涨号 天涯配音公社','','longyandayue024qikangzhanghaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','870','0','213','906','0','0','0','10.0','1460','146','1458788726','1458788726','0','0','龙颜大悦024期：抗涨号 天涯配音公社','youku','0','','57428616','','','','');
INSERT INTO `mac_vod` VALUES('1480','龙颜大悦003期：人在江湖号 天涯配音公社','','longyandayue003qirenzaijianghuhaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','383','0','610','447','0','0','0','10.0','3430','343','1458788726','1458788726','0','0','龙颜大悦003期：人在江湖号 天涯配音公社','youku','0','','57354764','','','','');
INSERT INTO `mac_vod` VALUES('1481','龙颜大悦018期：重阳号 天涯配音公社','','longyandayue018qizhongyanghaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','667','0','710','38','0','0','0','9.0','3645','405','1458788726','1458788726','0','0','龙颜大悦018期：重阳号 天涯配音公社','youku','0','','53533163','','','','');
INSERT INTO `mac_vod` VALUES('1482','龙颜大悦015期：中秋诗会 天涯配音公社','','longyandayue015qizhongqiushihuitianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','555','0','879','276','0','0','0','6.0','2436','406','1458788726','1458788726','0','0','龙颜大悦015期：中秋诗会 天涯配音公社','youku','0','','52046023','','','','');
INSERT INTO `mac_vod` VALUES('1483','龙颜大悦014期：鸦王争霸号 天涯配音公社','','longyandayue014qiyawangzhengbahaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','220','0','573','980','0','0','0','9.0','3051','339','1458788726','1458788726','0','0','龙颜大悦014期：鸦王争霸号 天涯配音公社','youku','0','','57582892','','','','');
INSERT INTO `mac_vod` VALUES('1484','龙颜大悦006期：非诚勿扰号 天涯配音公社','','longyandayue006qifeichengwuraohaotianyapeiyingongshe','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','435','0','592','432','0','0','0','6.0','1470','245','1458788726','1458788726','0','0','龙颜大悦006期：非诚勿扰号 天涯配音公社','youku','0','','57582978','','','','');
INSERT INTO `mac_vod` VALUES('1485','富锦双语学校大合唱  富锦双语学校大合唱','','fujinshuangyuxuexiaodahechangfujinshuangyuxuexiaodahechang','F','','http://zy.egao8.cc/upload/vod/2015-10-14/14447971890.png','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','5','0','364','299','0','0','0','3.0','126','42','1458788737','1458788737','0','0','富锦双语学校大合唱  富锦双语学校大合唱','youku','0','','XMTM0ODU5NTY2NA==','','','','');
INSERT INTO `mac_vod` VALUES('1486','龙颜大悦045期劳动号子：光荣而苦逼的劳动者们万岁！','','longyandayue045qilaodonghaoziguangrongerkubidelaodongzhemenwansui','L','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','22','','','0','0','0','0','0','0','0','0','440','0','557','699','0','0','0','4.0','296','74','1458788737','1458788737','0','0','龙颜大悦045期劳动号子：光荣而苦逼的劳动者们万岁！','youku','0','','65930651','','','','');
INSERT INTO `mac_vod` VALUES('1487','萌妹纸发嗲解说大国足','','mengmeizhifadiajieshuodaguozu','M','','http://zy.egao8.cc/upload/vod/2015-10-14/14447963730.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','810','0','332','638','0','0','0','1.0','338','338','1458788753','1458788753','0','0','萌妹纸发嗲解说大国足','youku','0','','143338753','','','','');
INSERT INTO `mac_vod` VALUES('1488','《视纪》古刹风采之：双泉禅院  双泉禅院','','shijigushafengcaizhishuangquanchanyuanshuangquanchanyuan','S','','http://zy.egao8.cc/upload/vod/2015-10-14/14447964130.png','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','55','0','30','571','0','0','0','7.0','882','126','1458788753','1458788753','0','0','《视纪》古刹风采之：双泉禅院  双泉禅院','youku','0','','XMTI2MjczMDYyNA==','','','','');
INSERT INTO `mac_vod` VALUES('1489','网友无耐改编《城市欢迎您》','','wangyouwunaigaibianchengshihuanyingnin','W','','http://zy.egao8.cc/upload/vod/2015-10-14/14447964390.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','219','0','18','420','0','0','0','3.0','129','43','1458788753','1458788753','0','0','网友无耐改编《城市欢迎您》','youku','0','','132787417','','','','');
INSERT INTO `mac_vod` VALUES('1490','新闻神扯淡北京公交调情惹祸','','xinwenshenchedanbeijinggongjiaodiaoqingruohuo','X','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','946','0','973','848','0','0','0','3.0','195','65','1458788753','1458788753','0','0','新闻神扯淡北京公交调情惹祸','youku','0','','XNzExMDQ4NDA4','','','','');
INSERT INTO `mac_vod` VALUES('1491','现代扯淡版《新华山论剑》','','xiandaichedanbanxinhuashanlunjian','X','','http://zy.egao8.cc/upload/vod/2015-10-14/14447964590.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','727','0','164','231','0','0','0','5.0','1725','345','1458788753','1458788753','0','0','现代扯淡版《新华山论剑》','youku','0','','XNjE4MjMzOTY0','','','','');
INSERT INTO `mac_vod` VALUES('1492','爆笑！客服电话 叫板恶搞10086','','baoxiaokefudianhuajiaobanegao10086','B','','http://zy.egao8.cc/upload/vod/2015-10-14/14447964910.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','141','0','704','919','0','0','0','4.0','1312','328','1458788753','1458788753','0','0','爆笑！客服电话 叫板恶搞10086','youku','0','','89188955','','','','');
INSERT INTO `mac_vod` VALUES('1493','唱谈半价买唱谈某快餐欺诈促销','','changtanbanjiamaichangtanmoukuaicanqizhachunxiao','C','','http://zy.egao8.cc/upload/vod/2015-10-14/14447965520.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','115','0','800','478','0','0','0','5.0','1920','384','1458788753','1458788753','0','0','唱谈半价买唱谈某快餐欺诈促销','youku','0','','157208177','','','','');
INSERT INTO `mac_vod` VALUES('1494','沁园春-热调侃无奈的全国高温','','qinyuanchunrediaokanwunaidequanguogaowen','Q','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967280.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','169','0','3','943','0','0','0','4.0','1716','429','1458788753','1458788753','0','0','沁园春-热调侃无奈的全国高温','youku','0','','XNTk1MTU0MzMy','','','','');
INSERT INTO `mac_vod` VALUES('1495','新闻神扯谈《禽流感来袭了》','','xinwenshenchetanqinliuganlaixiliao','X','','http://zy.egao8.cc/upload/vod/2015-10-14/14447967820.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','666','0','457','67','0','0','0','3.0','153','51','1458788753','1458788753','0','0','新闻神扯谈《禽流感来袭了》','youku','0','','XNTM4OTc1MDk2','','','','');
INSERT INTO `mac_vod` VALUES('1496','新闻神扯谈猪八戒夜袭上海滩','','xinwenshenchetanzhubajieyexishanghaitan','X','','http://zy.egao8.cc/upload/vod/2015-10-14/14447968220.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','63','0','151','573','0','0','0','2.0','270','135','1458788753','1458788753','0','0','新闻神扯谈猪八戒夜袭上海滩','youku','0','','133826689','','','','');
INSERT INTO `mac_vod` VALUES('1497','唱谈有所谓收复钓鱼岛','','changtanyousuoweishoufudiaoyudao','C','','http://zy.egao8.cc/upload/vod/2015-10-14/14447968550.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','161','0','167','403','0','0','0','7.0','3402','486','1458788753','1458788753','0','0','唱谈有所谓收复钓鱼岛','youku','0','','113372557','','','','');
INSERT INTO `mac_vod` VALUES('1498','新闻神扯淡主播在直播时挖鼻屎被播出','','xinwenshenchedanzhubozaizhiboshiwabishibeibochu','X','','http://zy.egao8.cc/upload/vod/2015-10-14/14447968970.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','353','0','931','967','0','0','0','1.0','460','460','1458788753','1458788753','0','0','新闻神扯淡主播在直播时挖鼻屎被播出','youku','0','','XNzA3NzczMjU2','','','','');
INSERT INTO `mac_vod` VALUES('1499','新闻神扯淡主播情绪失控被轰出演播室','','xinwenshenchedanzhuboqingxushikongbeihongchuyanboshi','X','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','879','0','461','394','0','0','0','8.0','648','81','1458788753','1458788753','0','0','新闻神扯淡主播情绪失控被轰出演播室','youku','0','','XNzE4MTMzNjY0','','','','');
INSERT INTO `mac_vod` VALUES('1500','吐槽世间万态亮瞎各种24k氪金狗眼','','tucaoshijianwantailiangxiagezhong24kkejingouyan','T','','http://zy.egao8.cc/upload/vod/2015-10-14/14447969350.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','71','0','622','781','0','0','0','2.0','344','172','1458788753','1458788753','0','0','吐槽世间万态亮瞎各种24k氪金狗眼','youku','0','','146171331','','','','');
INSERT INTO `mac_vod` VALUES('1501','那些年被单词伤过的青春因为单词','','naxienianbeidancishangguodeqingchunyinweidanci','N','','http://zy.egao8.cc/upload/vod/2015-10-14/14447969820.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','604','0','371','445','0','0','0','3.0','1428','476','1458788753','1458788753','0','0','那些年被单词伤过的青春因为单词','youku','0','','142614526','','','','');
INSERT INTO `mac_vod` VALUES('1502','新闻神扯大咖也怕追杀','','xinwenshenchedakayepazhuisha','X','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','748','0','7','172','0','0','0','7.0','1995','285','1458788753','1458788753','0','0','新闻神扯大咖也怕追杀','youku','0','','141985637','','','','');
INSERT INTO `mac_vod` VALUES('1503','辛酸蚁族竟成弱势群体','','xinsuanyizujingchengruoshiqunti','X','','http://zy.egao8.cc/upload/vod/2015-10-14/14447970300.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','616','0','426','464','0','0','0','3.0','183','61','1458788753','1458788753','0','0','辛酸蚁族竟成弱势群体','youku','0','','136210314','','','','');
INSERT INTO `mac_vod` VALUES('1504','新闻神扯淡《孔雀大战东方不败》唱谈评委骂架','','xinwenshenchedankongquedazhandongfangbubaichangtanpingweimajia','X','','http://zy.egao8.cc/upload/vod/2015-10-14/14447970880.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','415','0','367','794','0','0','0','6.0','384','64','1458788753','1458788753','0','0','新闻神扯淡《孔雀大战东方不败》唱谈评委骂架','youku','0','','XNTQyNTYyMDk2','','','','');
INSERT INTO `mac_vod` VALUES('1505','吐槽苹果“向苹果开炮”','','tucaopingguoxiangpingguokaipao','T','','http://zy.egao8.cc/upload/vod/2015-10-14/14447971510.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','696','0','660','855','0','0','0','4.0','1908','477','1458788753','1458788753','0','0','吐槽苹果“向苹果开炮”','youku','0','','134365863','','','','');
INSERT INTO `mac_vod` VALUES('1506','随机播放的天气伤不起','','suijibofangdetianqishangbuqi','S','','http://zy.egao8.cc/upload/vod/nopic.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','604','0','482','806','0','0','0','4.0','108','27','1458788753','1458788753','0','0','随机播放的天气伤不起','youku','0','','132959586','','','','');
INSERT INTO `mac_vod` VALUES('1507','悲催蚁族叹城市好像垃圾场','','beicuiyizutanchengshihaoxianglajichang','B','','http://zy.egao8.cc/upload/vod/2015-10-14/14447961820.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','271','0','80','274','0','0','0','7.0','1995','285','1458788765','1458788765','0','0','悲催蚁族叹城市好像垃圾场','youku','0','','147500098','','','','');
INSERT INTO `mac_vod` VALUES('1508','中秋献礼  中秋献礼','','zhongqiuxianlizhongqiuxianli','Z','','http://zy.egao8.cc/upload/vod/2015-10-14/14447962190.png','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','330','0','295','622','0','0','0','9.0','2214','246','1458788765','1458788765','0','0','中秋献礼  中秋献礼','youku','0','','XMTM0NjQzMDk5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1509','大数据时代  大数据时代','','dashujushidaidashujushidai','D','','http://zy.egao8.cc/upload/vod/2015-10-14/14447962530.png','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','793','0','661','560','0','0','0','8.0','3624','453','1458788765','1458788765','0','0','大数据时代  大数据时代','youku','0','','XMTMzNTgxNTkyNA==','','','','');
INSERT INTO `mac_vod` VALUES('1510','中国八卦电视台唱谈近期新闻热点','','zhongguobaguadianshitaichangtanjinqixinwenredian','Z','','http://zy.egao8.cc/upload/vod/2015-10-14/14447962880.jpg','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','429','0','977','372','0','0','0','2.0','890','445','1458788765','1458788765','0','0','中国八卦电视台唱谈近期新闻热点','youku','0','','XNTgyOTg2MTYw','','','','');
INSERT INTO `mac_vod` VALUES('1511','佛说吉祥经  佛说吉祥经','','fushuojixiangjingfushuojixiangjing','F','','http://zy.egao8.cc/upload/vod/2015-10-14/14447963270.png','','','老湿','','','','大陆','','0','21','','','0','0','0','0','0','0','0','0','851','0','638','62','0','0','0','6.0','2616','436','1458788765','1458788765','0','0','佛说吉祥经  佛说吉祥经','youku','0','','XMTMxOTk3MjUyMA==','','','','');
INSERT INTO `mac_vod` VALUES('1512','歪歌公社考试版《你是我的眼》','','waigegongshekaoshibannishiwodeyan','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887186.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','126','0','602','525','0','0','0','9.0','1035','115','1458788897','1458788897','0','0','歪歌公社考试版《你是我的眼》','tudou','0','','243941745','','','','');
INSERT INTO `mac_vod` VALUES('1513','歪歌公社新编《没有车没有房》','','waigegongshexinbianmeiyouchemeiyoufang','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887187.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','345','0','635','862','0','0','0','9.0','3942','438','1458788897','1458788897','0','0','歪歌公社新编《没有车没有房》','youku','0','','XMTM4NDY2MTc0NA==','','','','');
INSERT INTO `mac_vod` VALUES('1514','歪歌公社搞笑歪唱忘情水版《敌敌畏》','','waigegongshegaoxiaowaichangwangqingshuibandidiwei','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887188.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','687','0','285','881','0','0','0','3.0','345','115','1458788897','1458788897','0','0','歪歌公社搞笑歪唱忘情水版《敌敌畏》','tudou','0','','243649461','','','','');
INSERT INTO `mac_vod` VALUES('1515','歪歌公社2015光棍节神作《光棍情歌》','','waigegongshe2015guanggunjieshenzuoguanggunqingge','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887189.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','170','0','605','119','0','0','0','5.0','1560','312','1458788897','1458788897','0','0','歪歌公社2015光棍节神作《光棍情歌》','youku','0','','XMTM4MzAxNDA3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1516','歪歌公社爆笑洗脑神曲《辣条不吃 何以吃天下》','','waigegongshebaoxiaoxinaoshenqulatiaobuchiheyichitianxia','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871810.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','659','0','239','829','0','0','0','9.0','3312','368','1458788897','1458788897','0','0','歪歌公社爆笑洗脑神曲《辣条不吃 何以吃天下》','youku','0','','XMTM4NzIwMDc0MA==','','','','');
INSERT INTO `mac_vod` VALUES('1517','歪歌公社吐槽停车牛人','','waigegongshetucaotingcheniuren','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871811.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','111','0','676','234','0','0','0','1.0','416','416','1458788897','1458788897','0','0','歪歌公社吐槽停车牛人','youku','0','','XMTM4MjA3NjgzNg==','','','','');
INSERT INTO `mac_vod` VALUES('1518','歪歌吐槽同学会《变味的同学会》','','waigetucaotongxuehuibianweidetongxuehui','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871812.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','826','0','496','775','0','0','0','3.0','42','14','1458788897','1458788897','0','0','歪歌吐槽同学会《变味的同学会》','youku','0','','XMTM1NDMxODc0NA==','','','','');
INSERT INTO `mac_vod` VALUES('1519','球迷歪歌怒喷国足《国足伤不起》','','qiumiwaigenupenguozuguozushangbuqi','Q','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871813.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','698','0','627','363','0','0','0','1.0','265','265','1458788897','1458788897','0','0','球迷歪歌怒喷国足《国足伤不起》','youku','0','','XMTM4OTk3NjM5Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1520','光棍神曲《新鸳鸯光棍梦》','','guanggunshenquxinyuanyangguanggunmeng','G','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871814.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','466','0','587','625','0','0','0','6.0','2670','445','1458788897','1458788897','0','0','光棍神曲《新鸳鸯光棍梦》','youku','0','','XMTM4MTIyNDM3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1521','汤姆猫吐槽双十一败家娘们《剁手族伤不起》','','tangmumiaotucaoshuangshiyibaijianiangmenduoshouzushangbuqi','T','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871815.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','963','0','740','161','0','0','0','5.0','625','125','1458788897','1458788897','0','0','汤姆猫吐槽双十一败家娘们《剁手族伤不起》','youku','0','','XMTM4MzgwOTkxNg==','','','','');
INSERT INTO `mac_vod` VALUES('1522','歪歌公社爆笑神改编《光棍语录》','','waigegongshebaoxiaoshengaibianguanggunyulu','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871816.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','363','0','544','786','0','0','0','6.0','1806','301','1458788897','1458788897','0','0','歪歌公社爆笑神改编《光棍语录》','youku','0','','XMTM3ODU5NTM4MA==','','','','');
INSERT INTO `mac_vod` VALUES('1523','歪歌公社怒斥碰瓷党《碰瓷之歌》','','waigegongshenuchipengcidangpengcizhige','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871817.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','436','0','797','786','0','0','0','7.0','84','12','1458788897','1458788897','0','0','歪歌公社怒斥碰瓷党《碰瓷之歌》','youku','0','','XMTM3Nzc3MTAzMg==','','','','');
INSERT INTO `mac_vod` VALUES('1524','歪歌公社吐槽考试作弊版《偏爱》','','waigegongshetucaokaoshizuobibanpianai','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871818.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','797','0','896','164','0','0','0','3.0','1416','472','1458788897','1458788897','0','0','歪歌公社吐槽考试作弊版《偏爱》','tudou','0','','242099930','','','','');
INSERT INTO `mac_vod` VALUES('1525','陕北农民新编歪歌《别忘穿秋裤》','','shanbeinongminxinbianwaigebiewangchuanqiuku','S','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871819.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','150','0','79','893','0','0','0','5.0','950','190','1458788897','1458788897','0','0','陕北农民新编歪歌《别忘穿秋裤》','tudou','0','','242854432','','','','');
INSERT INTO `mac_vod` VALUES('1526','歪歌公社吐槽网吧未成年人《网吧的孩子》','','waigegongshetucaowangbaweichengnianrenwangbadehaizi','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887221.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','549','0','677','164','0','0','0','4.0','396','99','1458788897','1458788897','0','0','歪歌公社吐槽网吧未成年人《网吧的孩子》','tudou','0','','241978466','','','','');
INSERT INTO `mac_vod` VALUES('1527','萌妹搞笑翻唱《感觉自己萌萌哒》','','mengmeigaoxiaofanchangganjuezijimengmengda','M','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887222.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','636','0','366','639','0','0','0','4.0','704','176','1458788897','1458788897','0','0','萌妹搞笑翻唱《感觉自己萌萌哒》','tudou','0','','242165927','','','','');
INSERT INTO `mac_vod` VALUES('1528','歪歌公社神吐槽《你牛什么牛》','','waigegongsheshentucaoniniushimeniu','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887223.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','900','0','416','694','0','0','0','1.0','72','72','1458788897','1458788897','0','0','歪歌公社神吐槽《你牛什么牛》','youku','0','','XMTM2MDY3NjM2MA==','','','','');
INSERT INTO `mac_vod` VALUES('1529','歪歌公社魔性洗脑神曲《咱们屯里的羊》','','waigegongshemoxingxinaoshenquzaimentunlideyang','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887224.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','924','0','940','679','0','0','0','2.0','470','235','1458788897','1458788897','0','0','歪歌公社魔性洗脑神曲《咱们屯里的羊》','youku','0','','XMTM1NzUzNTQzMg==','','','','');
INSERT INTO `mac_vod` VALUES('1530','歪歌公社搞笑歪歌《等我有钱了》','','waigegongshegaoxiaowaigedengwoyouqianliao','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887225.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','633','0','146','160','0','0','0','1.0','33','33','1458788897','1458788897','0','0','歪歌公社搞笑歪歌《等我有钱了》','youku','0','','XMTM1OTg2OTk0OA==','','','','');
INSERT INTO `mac_vod` VALUES('1531','歪歌公社超现实改编《单身钱歌》 唱多了都是泪啊','','waigegongshechaoxianshigaibiandanshenqiangechangduoliaodushileia','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887226.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','546','0','583','171','0','0','0','4.0','1532','383','1458788897','1458788897','0','0','歪歌公社超现实改编《单身钱歌》 唱多了都是泪啊','youku','0','','XMTM1ODI4Mzc4NA==','','','','');
INSERT INTO `mac_vod` VALUES('1532','歪歌公社新编《有多少爱 可以乱来》','','waigegongshexinbianyouduoshaoaikeyiluanlai','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887149.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','561','0','621','822','0','0','0','3.0','396','132','1458788907','1458788907','0','0','歪歌公社新编《有多少爱 可以乱来》','tudou','0','','247292164','','','','');
INSERT INTO `mac_vod` VALUES('1533','歪歌盘点2015大事件《蛋疼2015》','','waigepandian2015dashijiandanteng2015','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871410.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','925','0','130','907','0','0','0','1.0','126','126','1458788907','1458788907','0','0','歪歌盘点2015大事件《蛋疼2015》','youku','0','','XMTQzODUwOTU5Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1534','歪歌公社最新《我要去西藏》看看这个拉风的女子','','waigegongshezuixinwoyaoquxicangkankanzhegelafengdenvzi','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871411.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','252','0','441','687','0','0','0','7.0','784','112','1458788907','1458788907','0','0','歪歌公社最新《我要去西藏》看看这个拉风的女子','youku','0','','XMTQzNzM1OTM1Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1535','歪歌公社吐槽：女婿编唱《丈母娘之歌》','','waigegongshetucaonvxubianchangzhangmuniangzhige','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871412.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','841','0','137','603','0','0','0','3.0','441','147','1458788907','1458788907','0','0','歪歌公社吐槽：女婿编唱《丈母娘之歌》','youku','0','','XMTQxNjM2MTgzMg==','','','','');
INSERT INTO `mac_vod` VALUES('1536','歪歌公社模仿众星《世上女人都是毒蛇》赵本山亮了','','waigegongshemofangzhongxingshishangnvrendushidushezhaobenshanliangliao','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871413.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','589','0','143','566','0','0','0','5.0','1680','336','1458788907','1458788907','0','0','歪歌公社模仿众星《世上女人都是毒蛇》赵本山亮了','youku','0','','XMTQxNTQ0MTIxNg==','','','','');
INSERT INTO `mac_vod` VALUES('1537','歪歌吐槽：《没钱不爱》穷吊丝调侃没钱谈不了恋爱','','waigetucaomeiqianbuaiqiongdiaosidiaokanmeiqiantanbuliaolianai','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871414.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','232','0','978','204','0','0','0','3.0','1359','453','1458788907','1458788907','0','0','歪歌吐槽：《没钱不爱》穷吊丝调侃没钱谈不了恋爱','youku','0','','XMTQ2NTQ2MDMyOA==','','','','');
INSERT INTO `mac_vod` VALUES('1538','歪歌公社给猴哥上春晚的歌曲《猴哥伤不起》','','waigegongshegeihougeshangchunwandegequhougeshangbuqi','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871415.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','603','0','6','114','0','0','0','6.0','426','71','1458788907','1458788907','0','0','歪歌公社给猴哥上春晚的歌曲《猴哥伤不起》','youku','0','','XMTQ2Mzg2NjkwNA==','','','','');
INSERT INTO `mac_vod` VALUES('1539','矮穷矬歪歌吐槽《来生投胎做思聪》','','aiqiongcuowaigetucaolaishengtoutaizuosicong','A','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871416.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','879','0','684','114','0','0','0','10.0','1830','183','1458788907','1458788907','0','0','矮穷矬歪歌吐槽《来生投胎做思聪》','youku','0','','XMTQ2MzExOTQ5Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1540','歪歌公社神改编《我们都是单身狗儿》','','waigegongsheshengaibianwomendushidanshengouer','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871417.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','827','0','813','489','0','0','0','5.0','1660','332','1458788907','1458788907','0','0','歪歌公社神改编《我们都是单身狗儿》','youku','0','','XMTQ0MTM2NTcwOA==','','','','');
INSERT INTO `mac_vod` VALUES('1541','员工歪歌吐槽老板《不想加班好多年》','','yuangongwaigetucaolaobanbuxiangjiabanhaoduonian','Y','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871418.jpg','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','62','0','787','242','0','0','0','5.0','1145','229','1458788907','1458788907','0','0','员工歪歌吐槽老板《不想加班好多年》','tudou','0','','244683939','','','','');
INSERT INTO `mac_vod` VALUES('1542','打工族编唱《打工妹呀打工仔》','','dagongzubianchangdagongmeiyadagongzi','D','','http://zy.egao8.cc/upload/vod/2016-02-23/145618871419.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','291','0','844','346','0','0','0','1.0','385','385','1458788907','1458788907','0','0','打工族编唱《打工妹呀打工仔》','youku','0','','XMTQwMjI2NDE3Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1543','烟民自编戒烟歌《戒烟好难》','','yanminzibianjieyangejieyanhaonan','Y','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887171.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','564','0','317','993','0','0','0','4.0','924','231','1458788907','1458788907','0','0','烟民自编戒烟歌《戒烟好难》','youku','0','','XMTQwMTMyOTYyMA==','','','','');
INSERT INTO `mac_vod` VALUES('1544','歪歌公社系列：歪唱版《南山南》','','waigegongshexiliewaichangbannanshannan','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887172.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','527','0','881','842','0','0','0','7.0','1722','246','1458788907','1458788907','0','0','歪歌公社系列：歪唱版《南山南》','tudou','0','','132612952','','','','');
INSERT INTO `mac_vod` VALUES('1545','大神恶搞毛宁吸毒版《涛声依旧》 歌词很牛','','dashenegaomaoningxidubantaoshengyijiugecihenniu','D','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887183.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','666','0','807','272','0','0','0','8.0','640','80','1458788907','1458788907','0','0','大神恶搞毛宁吸毒版《涛声依旧》 歌词很牛','youku','0','','XMTM5OTQ2MDE3Ng==','','','','');
INSERT INTO `mac_vod` VALUES('1546','妹子歪歌爆笑吐槽《甩大姨妈》','','meiziwaigebaoxiaotucaoshuaidayima','M','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887184.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','565','0','206','632','0','0','0','3.0','540','180','1458788907','1458788907','0','0','妹子歪歌爆笑吐槽《甩大姨妈》','youku','0','','XMTM5Njg5OTY0MA=','','','','');
INSERT INTO `mac_vod` VALUES('1547','歪歌公社新作《成都人的生活》','','waigegongshexinzuochengdurendeshenghuo','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561887185.gif','','','歪歌公社','','','','大陆','','0','11','','','0','0','0','0','0','0','0','0','149','0','286','488','0','0','0','5.0','2080','416','1458788907','1458788907','0','0','歪歌公社新作《成都人的生活》','youku','0','','XMTM5NjA0NDg1Mg==','','','','');
INSERT INTO `mac_vod` VALUES('1548','最牛搞笑交通错峰限行之歌《堵情》','','zuiniugaoxiaojiaotongcuofengxianxingzhigeduqing','Z','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888758.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','768','0','883','604','0','0','0','2.0','872','436','1458789046','1458789046','0','0','最牛搞笑交通错峰限行之歌《堵情》','youku','0','','XMzExOTI3MTQw','','','','');
INSERT INTO `mac_vod` VALUES('1549','《疯狂的石头》现实版之故宫失窃爆笑歪歌《千年偷一回》','','fengkuangdeshitouxianshibanzhigugongshiqiebaoxiaowaigeqianniantouyihui','F','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888759.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','228','0','44','188','0','0','0','9.0','3384','376','1458789046','1458789046','0','0','《疯狂的石头》现实版之故宫失窃爆笑歪歌《千年偷一回》','youku','0','','XMjY4NzE5MTI0','','','','');
INSERT INTO `mac_vod` VALUES('1550','碉堡了--铁杆粉丝献歌让本山大叔泪流满面《本山别哭》','','diaobaoliaotieganfensixiangerangbenshandashuleiliumanmianbenshanbieku','D','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887610.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','878','0','796','475','0','0','0','1.0','234','234','1458789046','1458789046','0','0','碉堡了--铁杆粉丝献歌让本山大叔泪流满面《本山别哭》','youku','0','','XMzQ1MDAwMjM2','','','','');
INSERT INTO `mac_vod` VALUES('1551','祈祷7.23动车追尾遇难同胞《潇洒雷一回》','','qidao723dongchezhuiweiyunantongbaoxiaosaleiyihui','Q','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887611.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','205','0','408','843','0','0','0','7.0','1134','162','1458789046','1458789046','0','0','祈祷7.23动车追尾遇难同胞《潇洒雷一回》','youku','0','','XMjg5MTYyMzA0','','','','');
INSERT INTO `mac_vod` VALUES('1552','毒瘤瘦肉精-吃肉难放心，养猪也疯狂之《生猪也跳健美操》','','duliushouroujingchirounanfangxinyangzhuyefengkuangzhishengzhuyetiaojianmeicao','D','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887612.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','791','0','995','640','0','0','0','1.0','106','106','1458789046','1458789046','0','0','毒瘤瘦肉精-吃肉难放心，养猪也疯狂之《生猪也跳健美操》','youku','0','','XMjUxNjc3NzU2','','','','');
INSERT INTO `mac_vod` VALUES('1553','无票回家游子撕心裂肺的歪唱《咱回家的人》','','wupiaohuijiayouzisixinliefeidewaichangzaihuijiaderen','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887613.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','563','0','763','433','0','0','0','8.0','3488','436','1458789046','1458789046','0','0','无票回家游子撕心裂肺的歪唱《咱回家的人》','youku','0','','XMzQzMzc0MTI0','','','','');
INSERT INTO `mac_vod` VALUES('1554','护膝弟翻唱秒杀大衣哥之关云长雷人版《滚滚长江冻死谁》','','huxidifanchangmiaoshadayigezhiguanyunchangleirenbangungunchangjiangdongsishui','H','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887614.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','39','0','263','257','0','0','0','4.0','268','67','1458789046','1458789046','0','0','护膝弟翻唱秒杀大衣哥之关云长雷人版《滚滚长江冻死谁》','youku','0','','XMjcwMjE5NjI0','','','','');
INSERT INTO `mac_vod` VALUES('1555','萝莉-超萌搞笑翻唱凤凰传奇童声版《荷塘月色》mv','','luolichaomenggaoxiaofanchangfenghuangchuanqitongshengbanhetangyuesemv','L','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887615.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','582','0','639','865','0','0','0','2.0','174','87','1458789046','1458789046','0','0','萝莉-超萌搞笑翻唱凤凰传奇童声版《荷塘月色》mv','youku','0','','XMzA0NTcyOTM2','','','','');
INSERT INTO `mac_vod` VALUES('1556','圣诞元旦都不是蛋，2011新春贺岁爆笑mv视频《蛋特》','','shengdanyuandandubushidan2011xinchunhesuibaoxiaomvshipindante','S','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887616.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','651','0','880','981','0','0','0','10.0','3820','382','1458789046','1458789046','0','0','圣诞元旦都不是蛋，2011新春贺岁爆笑mv视频《蛋特》','youku','0','','XMjMyODQ1NTEy','','','','');
INSERT INTO `mac_vod` VALUES('1557','三八节刘德华丝袜诱惑，5大骨灰歌手联唱《春风里》','','sanbajieliudehuasiwayouhuo5daguhuigeshoulianchangchunfengli','S','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887617.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','45','0','68','546','0','0','0','7.0','1799','257','1458789046','1458789046','0','0','三八节刘德华丝袜诱惑，5大骨灰歌手联唱《春风里》','youku','0','','XMjQ5MTEyNTgw','','','','');
INSERT INTO `mac_vod` VALUES('1558','陈真《大号是中华》逆子弑母歪歌版《挥刀自宫吧》','','chenzhendahaoshizhonghuanizishimuwaigebanhuidaozigongba','C','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887618.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','160','0','628','969','0','0','0','3.0','201','67','1458789046','1458789046','0','0','陈真《大号是中华》逆子弑母歪歌版《挥刀自宫吧》','youku','0','','XMjY1NDY1Mjcy','','','','');
INSERT INTO `mac_vod` VALUES('1559','2014春晚祝福进行曲《祝福》','','2014chunwanzhufujinxingquzhufu','2','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887619.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','233','0','581','380','0','0','0','4.0','1344','336','1458789046','1458789046','0','0','2014春晚祝福进行曲《祝福》','youku','0','','XNjY4NzQ2NDA4','','','','');
INSERT INTO `mac_vod` VALUES('1560','为神马华仔削发为僧，《新少林寺》非插曲煽情版《来生缘》','','weishenmahuazixiaofaweisengxinshaolinsifeichaqushanqingbanlaishengyuan','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888791.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','597','0','788','877','0','0','0','2.0','776','388','1458789046','1458789046','0','0','为神马华仔削发为僧，《新少林寺》非插曲煽情版《来生缘》','youku','0','','XMjQ1NjMxMDAw','','','','');
INSERT INTO `mac_vod` VALUES('1561','迈克尔杰克逊携手小沈阳，给力演唱一曲中国风的《新红楼梦》','','maikeerjiekexunxieshouxiaoshenyanggeiliyanchangyiquzhongguofengdexinhongloumeng','M','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888802.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','926','0','209','775','0','0','0','10.0','4650','465','1458789046','1458789046','0','0','迈克尔杰克逊携手小沈阳，给力演唱一曲中国风的《新红楼梦》','youku','0','','XMjI4NDE1NDIw','','','','');
INSERT INTO `mac_vod` VALUES('1562','你懂的--红歌红爹红孩儿之搞笑版《红爹闪闪亮》','','nidongdehonggehongdiehonghaierzhigaoxiaobanhongdieshanshanliang','N','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888803.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','492','0','142','861','0','0','0','1.0','360','360','1458789046','1458789046','0','0','你懂的--红歌红爹红孩儿之搞笑版《红爹闪闪亮》','youku','0','','XMzAzMDkxNDky','','','','');
INSERT INTO `mac_vod` VALUES('1563','白娘子返人间化解“腾”与“三”之孽缘，神曲《渡情》直译《毒情》','','bainiangzifanrenjianhuajietengyusanzhinieyuanshenquduqingzhiyiduqing','B','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888804.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','407','0','483','637','0','0','0','5.0','170','34','1458789046','1458789046','0','0','白娘子返人间化解“腾”与“三”之孽缘，神曲《渡情》直译《毒情》','youku','0','','XMjIwOTI1OTQ0','','','','');
INSERT INTO `mac_vod` VALUES('1564','《铁血丹心》2011全国高考作文给力大串烧版《作文蛋心》','','tiexuedanxin2011quanguogaokaozuowengeilidachuanshaobanzuowendanxin','T','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888805.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','878','0','970','577','0','0','0','9.0','2241','249','1458789046','1458789046','0','0','《铁血丹心》2011全国高考作文给力大串烧版《作文蛋心》','youku','0','','XMjc0NDcxMTY0','','','','');
INSERT INTO `mac_vod` VALUES('1565','拍客 春节买票无门回家无望，满含热泪写下《新一封家书》','','paikechunjiemaipiaowumenhuijiawuwangmanhanreleixiexiaxinyifengjiashu','P','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888806.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','456','0','435','372','0','0','0','8.0','1480','185','1458789046','1458789046','0','0','拍客 春节买票无门回家无望，满含热泪写下《新一封家书》','youku','0','','XMjM5MDExMzI4','','','','');
INSERT INTO `mac_vod` VALUES('1566','黄渤搞笑歪唱版《爱情买霾》','','huangbogaoxiaowaichangbanaiqingmaimai','H','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888807.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','285','0','54','183','0','0','0','10.0','710','71','1458789046','1458789046','0','0','黄渤搞笑歪唱版《爱情买霾》','youku','0','','XNjQ5NTMzNDk2','','','','');
INSERT INTO `mac_vod` VALUES('1567','神字幕《我的哥胜利》','','shenzimuwodegeshengli','S','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888808.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','355','0','597','887','0','0','0','8.0','2456','307','1458789046','1458789046','0','0','神字幕《我的哥胜利》','youku','0','','XNDUyMzgxMjQ4','','','','');
INSERT INTO `mac_vod` VALUES('1568','逆天中文直译字幕，曲婉婷这次笑喷了《我的哥胜利》','','nitianzhongwenzhiyizimuquwantingzhecixiaopenliaowodegeshengli','N','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887111.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','745','0','676','333','0','0','0','3.0','273','91','1458789056','1458789056','0','0','逆天中文直译字幕，曲婉婷这次笑喷了《我的哥胜利》','youku','0','','XNDUyMzgxMjQ4','','','','');
INSERT INTO `mac_vod` VALUES('1569','毒胶囊引发：声泪俱下赋诗一首《毒你》','','dujiaonanyinfashengleijuxiafushiyishouduni','D','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887112.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','884','0','998','587','0','0','0','4.0','168','42','1458789056','1458789056','0','0','毒胶囊引发：声泪俱下赋诗一首《毒你》','youku','0','','XMzgzMTk2MjY0','','','','');
INSERT INTO `mac_vod` VALUES('1570','爱在七夕！爆笑屌丝爱的呐喊--诗朗诵《爱你 使命打》','','aizaiqixibaoxiaosiaidenahanshilangsongainishimingda','A','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887113.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','790','0','615','184','0','0','0','2.0','650','325','1458789056','1458789056','0','0','爱在七夕！爆笑屌丝爱的呐喊--诗朗诵《爱你 使命打》','youku','0','','XNDQyMzQ3NjQw','','','','');
INSERT INTO `mac_vod` VALUES('1571','《纤夫的爱》三八节董卿刘谦魔幻搞笑版《三八的爱》','','xianfudeaisanbajiedongqingliuqianmohuangaoxiaobansanbadeai','X','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887114.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','325','0','171','378','0','0','0','6.0','1674','279','1458789056','1458789056','0','0','《纤夫的爱》三八节董卿刘谦魔幻搞笑版《三八的爱》','youku','0','','XMzYyMDIzOTgw','','','','');
INSERT INTO `mac_vod` VALUES('1572','吹灯搞笑系列之跨栏有风险《跨栏高手》','','chuidenggaoxiaoxiliezhikualanyoufengxiankualangaoshou','C','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887115.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','449','0','154','392','0','0','0','7.0','266','38','1458789056','1458789056','0','0','吹灯搞笑系列之跨栏有风险《跨栏高手》','youku','0','','XMzM0OTEwOTQw','','','','');
INSERT INTO `mac_vod` VALUES('1573','叫人真的想笑却又想哭的《爱情买卖》悲催买票版《车票买卖》','','jiaorenzhendexiangxiaoqueyouxiangkudeaiqingmaimaibeicuimaipiaobanchepiaomaimai','J','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887116.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','460','0','147','668','0','0','0','10.0','1600','160','1458789056','1458789056','0','0','叫人真的想笑却又想哭的《爱情买卖》悲催买票版《车票买卖》','youku','0','','XMzQ0MjA0NTc2','','','','');
INSERT INTO `mac_vod` VALUES('1574','五音不全凄凄惨惨！老屌丝搞笑吐槽神曲《坑爷》','','wuyinbuquanqiqicancanlaosigaoxiaotucaoshenqukangye','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887117.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','255','0','74','115','0','0','0','1.0','247','247','1458789056','1458789056','0','0','五音不全凄凄惨惨！老屌丝搞笑吐槽神曲《坑爷》','youku','0','','XNDI2MjUzODcy','','','','');
INSERT INTO `mac_vod` VALUES('1575','停止冷漠 呼唤热心！跪求！为了小悦悦让我痛痛快快骂一下吧《冷漠路人甲》','','tingzhilingmohuhuanrexinguiqiuweiliaoxiaoyueyuerangwotongtongkuaikuaimayixiabalingmolurenjia','T','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887118.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','570','0','456','362','0','0','0','10.0','750','75','1458789056','1458789056','0','0','停止冷漠 呼唤热心！跪求！为了小悦悦让我痛痛快快骂一下吧《冷漠路人甲》','youku','0','','XMzE0NDMzODY4','','','','');
INSERT INTO `mac_vod` VALUES('1576','爆笑音译之最狗血的冬天里的一把火《医霸火》','','baoxiaoyinyizhizuigouxuededongtianlideyibahuoyibahuo','B','','http://zy.egao8.cc/upload/vod/2016-02-23/145618887219.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','238','0','657','7','0','0','0','3.0','648','216','1458789056','1458789056','0','0','爆笑音译之最狗血的冬天里的一把火《医霸火》','youku','0','','XMzMzOTk3NjEy','','','','');
INSERT INTO `mac_vod` VALUES('1577','全国高考作文题屌丝串烧版《最炫作文疯》','','quanguogaokaozuowentisichuanshaobanzuixuanzuowenfeng','Q','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888751.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','435','0','131','866','0','0','0','10.0','1650','165','1458789056','1458789056','0','0','全国高考作文题屌丝串烧版《最炫作文疯》','youku','0','','XNDEwNDQ4NjY0','','','','');
INSERT INTO `mac_vod` VALUES('1578','好一个悲催光棍搞笑歪唱《新光棍鸳鸯梦》','','haoyigebeicuiguanggungaoxiaowaichangxinguanggunyuanyangmeng','H','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888752.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','931','0','682','225','0','0','0','8.0','3696','462','1458789056','1458789056','0','0','好一个悲催光棍搞笑歪唱《新光棍鸳鸯梦》','youku','0','','XMzIzMzQzNjMy','','','','');
INSERT INTO `mac_vod` VALUES('1579','房奴也伤不起-不堪重负声嘶力竭歪唱版《万元房价永不倒》','','fangnuyeshangbuqibukanzhongfushengsilijiewaichangbanwanyuanfangjiayongbudao','F','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888753.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','338','0','703','88','0','0','0','3.0','960','320','1458789057','1458789057','0','0','房奴也伤不起-不堪重负声嘶力竭歪唱版《万元房价永不倒》','youku','0','','XMjk4NDUzMDM2','','','','');
INSERT INTO `mac_vod` VALUES('1580','令奸商黑商闻风丧胆之《东鞋西毒》','','lingjianshangheishangwenfengsangdanzhidongxiexidu','L','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888754.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','363','0','432','426','0','0','0','5.0','1245','249','1458789057','1458789057','0','0','令奸商黑商闻风丧胆之《东鞋西毒》','youku','0','','XMzg3NjY3MDI4','','','','');
INSERT INTO `mac_vod` VALUES('1581','爆笑2011-11-11神马光棍节之歌《我想娶贵玲》','','baoxiao20111111shenmaguanggunjiezhigewoxiangquguiling','B','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888755.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','58','0','202','432','0','0','0','5.0','910','182','1458789057','1458789057','0','0','爆笑2011-11-11神马光棍节之歌《我想娶贵玲》','youku','0','','XMzE5Nzk0Mjky','','','','');
INSERT INTO `mac_vod` VALUES('1582','搞笑歪唱-给力吹灯叔令人震惊的黄瓜双节棍歪唱《潇洒吃一回》','','gaoxiaowaichanggeilichuidengshulingrenzhenjingdehuangguashuangjiegunwaichangxiaosachiyihui','G','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888756.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','68','0','688','766','0','0','0','7.0','665','95','1458789057','1458789057','0','0','搞笑歪唱-给力吹灯叔令人震惊的黄瓜双节棍歪唱《潇洒吃一回》','youku','0','','XMjc4NjgyMjQ4','','','','');
INSERT INTO `mac_vod` VALUES('1583','这不是搞笑-因为爱情四川方言版《因为爱琴》','','zhebushigaoxiaoyinweiaiqingsichuanfangyanbanyinweiaiqin','Z','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888757.jpg','','','唱罢吹灯','','','','大陆','','0','16','','','0','0','0','0','0','0','0','0','879','0','160','806','0','0','0','8.0','1120','140','1458789057','1458789057','0','0','这不是搞笑-因为爱情四川方言版《因为爱琴》','youku','0','','XMzc5MzEyMDQ0','','','','');
INSERT INTO `mac_vod` VALUES('1584','歪歌吐槽雾霾《我的气管里》','','waigetucaowumaiwodeqiguanli','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881512.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','938','1','600','875','0','0','0','2.0','406','203','1458789164','1458789164','1458809804','0','歪歌吐槽雾霾《我的气管里》','youku','0','','XODAxMTUwMDk2','','','','');
INSERT INTO `mac_vod` VALUES('1585','国庆游《堵你》千遍不厌倦','','guoqingyouduniqianbianbuyanjuan','G','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881514.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','293','0','287','545','0','0','0','6.0','780','130','1458789164','1458789164','0','0','国庆游《堵你》千遍不厌倦','youku','0','','XNzk3NDYzOTE2','','','','');
INSERT INTO `mac_vod` VALUES('1586','《五仁代表我的心》为月饼界涨粉','','wurendaibiaowodexinweiyuebingjiezhangfen','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881516.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','674','0','341','223','0','0','0','5.0','405','81','1458789164','1458789164','0','0','《五仁代表我的心》为月饼界涨粉','youku','0','','XNzc1Mjg1NjUy','','','','');
INSERT INTO `mac_vod` VALUES('1587','《毒角戏》盘点吸毒明星','','dujiaoxipandianxidumingxing','D','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881518.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','881','0','841','850','0','0','0','7.0','2534','362','1458789164','1458789164','0','0','《毒角戏》盘点吸毒明星','youku','0','','XNzU1NDkzNDY4','','','','');
INSERT INTO `mac_vod` VALUES('1588','祈福！鲁甸版《后会无期》','','qifuludianbanhouhuiwuqi','Q','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888191.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','308','0','214','836','0','0','0','4.0','1312','328','1458789164','1458789164','0','0','祈福！鲁甸版《后会无期》','youku','0','','XNzU0NDc4OTA0','','','','');
INSERT INTO `mac_vod` VALUES('1589','锋菲歪歌《传奇》','','fengfeiwaigechuanqi','F','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888193.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','194','0','479','310','0','0','0','10.0','40','4','1458789164','1458789164','0','0','锋菲歪歌《传奇》','youku','0','','XNzkwMTQwMDEy','','','','');
INSERT INTO `mac_vod` VALUES('1590','小沈阳嘴开光，郭美美狂躺枪','','xiaoshenyangzuikaiguangguomeimeikuangthangqiang','X','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888195.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','870','0','499','369','0','0','0','9.0','1908','212','1458789164','1458789164','0','0','小沈阳嘴开光，郭美美狂躺枪','youku','0','','XNzY4NjA2MjM2','','','','');
INSERT INTO `mac_vod` VALUES('1591','无厘头版《小苹果》','','wulitoubanxiaopingguo','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888197.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','12','0','232','330','0','0','0','2.0','392','196','1458789164','1458789164','0','0','无厘头版《小苹果》','youku','0','','XNzg1NzE3NzIw','','','','');
INSERT INTO `mac_vod` VALUES('1592','七夕《娘子相公在哪儿》，洞房洞房我要我要','','qixiniangzixianggongzainaerdongfangdongfangwoyaowoyao','Q','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888198.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','891','0','978','978','0','0','0','4.0','988','247','1458789164','1458789164','0','0','七夕《娘子相公在哪儿》，洞房洞房我要我要','youku','0','','XNzQ5Mjg0NzEy','','','','');
INSERT INTO `mac_vod` VALUES('1593','我是五花肉，我为《蒸服》带盐','','woshiwuhuarouwoweizhengfudaiyan','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881910.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','618','0','632','817','0','0','0','4.0','1308','327','1458789164','1458789164','0','0','我是五花肉，我为《蒸服》带盐','youku','0','','XNzM3Nzg2OTQ0','','','','');
INSERT INTO `mac_vod` VALUES('1594','吸毒版《吸游记》','','xidubanxiyouji','X','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881911.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','401','0','931','320','0','0','0','8.0','1584','198','1458789164','1458789164','0','0','吸毒版《吸游记》','youku','0','','XNzU3OTM5NzUy','','','','');
INSERT INTO `mac_vod` VALUES('1595','懂球帝一回VS《伪球迷一回》','','dongqiudiyihuiVSweiqiumiyihui','D','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881912.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','792','0','709','177','0','0','0','3.0','120','40','1458789164','1458789164','0','0','懂球帝一回VS《伪球迷一回》','youku','0','','XNzM5NDQ0MDky','','','','');
INSERT INTO `mac_vod` VALUES('1596','悼祭！鲁甸版《后会无期》','','daojiludianbanhouhuiwuqi','D','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881916.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','934','0','140','550','0','0','0','5.0','415','83','1458789164','1458789164','0','0','悼祭！鲁甸版《后会无期》','youku','0','','XNzU0MDQwMzM2','','','','');
INSERT INTO `mac_vod` VALUES('1597','《小苹果》变身高烤神曲《热死我》','','xiaopingguobianshengaokaoshenquresiwo','X','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881917.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','815','0','995','316','0','0','0','9.0','2025','225','1458789164','1458789164','0','0','《小苹果》变身高烤神曲《热死我》','youku','0','','XNzIzNDg1MTI0','','','','');
INSERT INTO `mac_vod` VALUES('1598','《泪别世界杯》，俄罗斯再会','','leibieshijiebeieluosizaihui','L','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881919.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','519','0','886','325','0','0','0','5.0','825','165','1458789164','1458789164','0','0','《泪别世界杯》，俄罗斯再会','youku','0','','XNzQwNjY1ODA0','','','','');
INSERT INTO `mac_vod` VALUES('1599','跑男加特技《逗比到底》笑出一脸腹肌','','paonanjiatejidoubidaodixiaochuyilianfuji','P','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888233.gif','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','470','0','522','641','0','0','0','1.0','22','22','1458789164','1458789164','0','0','跑男加特技《逗比到底》笑出一脸腹肌','youku','0','','XOTQ0MTk5NzAw','','','','');
INSERT INTO `mac_vod` VALUES('1600','猿创精选 英文歌开挂飚国语','','yuanchuangjingxuanyingwengekaiguabiaoguoyu','Y','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888235.gif','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','688','0','951','801','0','0','0','10.0','4620','462','1458789164','1458789164','0','0','猿创精选 英文歌开挂飚国语','youku','0','','XOTM1NzIyMjky','','','','');
INSERT INTO `mac_vod` VALUES('1601','世界杯狂欢神曲《夺冠歌》嗨翻天','','shijiebeikuanghuanshenquduoguangehaifantian','S','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888237.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','36','0','820','58','0','0','0','9.0','2898','322','1458789164','1458789164','0','0','世界杯狂欢神曲《夺冠歌》嗨翻天','youku','0','','XNzI5NDExNDA0','','','','');
INSERT INTO `mac_vod` VALUES('1602','情谊在，何弃聊！毕业季压轴神曲《难忘母校》','','qingyizaiheqiliaobiyejiyazhoushenqunanwangmuxiao','Q','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888239.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','472','0','615','635','0','0','0','1.0','238','238','1458789164','1458789164','0','0','情谊在，何弃聊！毕业季压轴神曲《难忘母校》','youku','0','','XNzMzNDkxMzky','','','','');
INSERT INTO `mac_vod` VALUES('1603','猿创艺神曲《舌尖上的吃货》','','yuanchuangyishenqushejianshangdechihuo','Y','','http://zy.egao8.cc/upload/vod/2016-02-23/145618882312.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','296','0','920','973','0','0','0','10.0','2650','265','1458789164','1458789164','0','0','猿创艺神曲《舌尖上的吃货》','youku','0','','XNzE5OTIxOTY0','','','','');
INSERT INTO `mac_vod` VALUES('1604','高考三部曲上部 《好汗歌》迎高烤','','gaokaosanbuqushangbuhaohangeyinggaokao','G','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888105.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','403','0','660','982','0','0','0','2.0','18','9','1458789174','1458789174','0','0','高考三部曲上部 《好汗歌》迎高烤','youku','0','','XMTI1NTIyODUyMA==','','','','');
INSERT INTO `mac_vod` VALUES('1605','那些年来自民间的毁歌之王','','naxienianlaiziminjiandehuigezhiwang','N','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888106.gif','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','531','0','355','291','0','0','0','6.0','1458','243','1458789174','1458789174','0','0','那些年来自民间的毁歌之王','youku','0','','XOTMzNTA5Njg4','','','','');
INSERT INTO `mac_vod` VALUES('1606','《醉东北》东北人创意神曲','','zuidongbeidongbeirenchuangyishenqu','Z','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881117.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','512','0','367','499','0','0','0','10.0','400','40','1458789174','1458789174','0','0','《醉东北》东北人创意神曲','youku','0','','XODQ1OTYxMjI4','','','','');
INSERT INTO `mac_vod` VALUES('1607','歪歌吐槽《双十一》','','waigetucaoshuangshiyi','W','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881119.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','521','0','155','421','0','0','0','2.0','790','395','1458789174','1458789174','0','0','歪歌吐槽《双十一》','youku','0','','XODIzMjgwMjg0','','','','');
INSERT INTO `mac_vod` VALUES('1608','歪歌吐槽项链姐、抢劫哥《那么逗币为什么》','','waigetucaoxianglianjieqiangjiegenamedoubiweishime','W','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888142.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','334','5','523','347','0','0','0','1.0','349','349','1458789174','1458789174','1458809654','0','歪歌吐槽项链姐、抢劫哥《那么逗币为什么》','youku','0','','XODQwMTc2NzI4','','','','');
INSERT INTO `mac_vod` VALUES('1609','UGC神曲《赵本山》小品','','UGCshenquzhaobenshanxiaopin','U','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888144.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','550','1','852','268','0','0','0','2.0','226','113','1458789174','1458789174','1458809704','0','UGC神曲《赵本山》小品','youku','0','','XODM1MTE0NjI0','','','','');
INSERT INTO `mac_vod` VALUES('1610','神曲歪歌《我从蓝翔来》','','shenquwaigewoconglanxianglai','S','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888156.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','887','0','393','168','0','0','0','4.0','796','199','1458789174','1458789174','0','0','神曲歪歌《我从蓝翔来》','youku','0','','XODEyODU0MDU2','','','','');
INSERT INTO `mac_vod` VALUES('1611','iphone金曲《单肾情歌》为您逼格护驾！','','iphonejinqudanshenqinggeweininbigehujia','I','','http://zy.egao8.cc/upload/vod/2016-02-23/14561888158.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','394','0','475','237','0','0','0','10.0','370','37','1458789174','1458789174','0','0','iphone金曲《单肾情歌》为您逼格护驾！','youku','0','','XODA0NzYxMjI4','','','','');
INSERT INTO `mac_vod` VALUES('1612','神曲《光棍当自强》','','shenquguanggundangziqiang','S','','http://zy.egao8.cc/upload/vod/2016-02-23/145618881510.jpg','','','猿创艺','','','','大陆','','0','17','','','0','0','0','0','0','0','0','0','716','0','774','133','0','0','0','3.0','318','106','1458789174','1458789174','0','0','神曲《光棍当自强》','youku','0','','XODI2NDU5Mzky','','','','');
DROP TABLE IF EXISTS mac_manager
CREATE TABLE `mac_manager` (  `m_id` smallint(6) unsigned NOT NULL auto_increment,  `m_name` varchar(32) NOT NULL,  `m_password` varchar(32) NOT NULL,  `m_levels` varchar(32) NOT NULL,  `m_random` varchar(32) NOT NULL,  `m_status` tinyint(1) NOT NULL default '0',  `m_logintime` int(10) NOT NULL,  `m_loginip` int(10) NOT NULL,  `m_loginnum` smallint(6) NOT NULL,  PRIMARY KEY  (`m_id`),  KEY `m_status` (`m_status`)) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8
INSERT INTO mac_manager VALUES('1','admin','21232f297a57a5a743894a0e4a801fc3','b,c,d,e,f,g,h,i,j','66df636cec4554ac3f959a4d2aaa96e2','1','1458809913','2130706433','0');
