<?php

namespace Addons\messages;
use Common\Controller\Addon;
use Think\Model;
/**
 * 留言板插件
 * @author 马剑威
 */

    class messagesAddon extends Addon{

        public $info = array(
            'name'=>'messages',
            'title'=>'留言板',
            'description'=>'这是一个简单的留言板',
            'status'=>1,
            'author'=>'thinkphp',
            'version'=>'0.1'
        );

        public $admin_list = array(
            'model'=>'messages',		//要查的表
			'fields'=>'',			//要查的字段
			'map'=>'',				//查询条件, 如果需要可以再插件类的构造方法里动态重置这个属性
			'order'=>'id desc',		//排序,
			'list_grid'=>array( 		//这里定义的是除了id序号外的表格里字段显示的表头名和模型一样支持函数和链接
                'nickname:昵称',
                'link:联系方式',
                'content:留言内容',
                'r_content:回复内容',
                'starttime|time_format:留言时间',
                'is_reply:是否回复',
                'is_pass:是否通过',
                'id:操作:[EDIT]|编辑,[DELETE]|删除'
            ),
        );

        public function install(){
            //读取SQL文件
            $sql = file_get_contents(__DIR__.'/data.sql');
            $sql = str_replace("\r", "\n", $sql);
            $sql = explode(";\n", $sql);
            $md = new Model();
            
            foreach ($sql as $value) {
                $value = trim($value);
                if(empty($value)) continue;
                $md->execute($value);
            }
            return true;
        }

        public function uninstall(){
            //删除数据表
            $md =new Model();
            $sql = 'DROP TABLE IF EXISTS `onethink_messages`';
            $md->execute($sql);
            M('hooks')->where(array('name'=>'messagesDisplay',))->delete();
            return true;
        }

        public function messagesDisplay($param)
        {
            $config = $this->getConfig();
            $listdb = M('messages')->order('id DESC')->select();
            $this->assign('addons_config',$config);
            $this->assign('listdb',$listdb);
            if($config['random'])
                $this->display('message');
        }

    }