<?php

//扩展函数库
/**
 * @abstract 获取目录下的模板文件
 * @param string $dir 路径
 * @return array 文件数组
 */
function read_dir($dir){
	$array = array();
	if (is_dir($dir)){
		if ($dh = opendir($dir)){
			while (($file = readdir($dh))!= false){
				if(strpos($file,".".C('TMPL_TEMPLATE_SUFFIX')))
					$array[] = $file;
			}
			closedir($dh);
		}
	}
	return $array;
}


/**
 * 获取图片
 * @param int $cover_id
 * @param string $field
 * @return 完整的数据  或者  指定的$field字段值
 * @author zxf
 */
function get_image($cover_id){
	if(empty($cover_id)){
		return false;
	}
	$picture = M('Picture')->where(array('status'=>1))->getById($cover_id);
	return $picture['path'];
}

/**
 * @abstract 返回材料列表
 * @return array
 */
function get_meterial($id = "",$filed = "name"){
	if($id == "")
		return M("Meterial")->select();
	else
		return M("Meterial")->where("id = {$id}")->getField($filed);
}
/**
 * @abstract 返回制作列表
 * @param string $id
 * @param string $filed
 */
function get_made($id = "",$filed = "name"){
	if($id == "")
		return M("made")->select();
	else
		return M("made")->where("id = {$id}")->getField($filed);
}

/**
 * @abstract 返回制作多个制作
 * @param string $ids
 * @param string $filed
 */
function get_mades($ids = "",$filed = "name"){
		return implode(",",M("made")->where("id = {$ids}")->getField($filed));
}

/**
 * @abstract 返回制作option选项
 * @param int $id 制作id
 * @return string
 */
function get_made_option($id = ""){
	$str = "<option value = \"\">请选择</option>";
	foreach (M("made")->select() as $v){
		$select = $v['id'] == $id?"selected":"";
		$str .= "<option value =\"{$v['id']}\" {$select} >{$v['name']}</option>";
	}
	return $str;
}



/**
 * @abstract 返回模型
 * @param string $id
 * @param string $filed
 */
function get_model($id = "",$filed = "title"){
	if($id == "")
		return M("Document")->select();
	else 
		return M("Document")->where("id = {$id}")->getField($filed)==""?"无":M("Document")->where("id = {$id}")->getField($filed);
	
}

/**
 * @abstract 返回区域地址
 * @param string $str
 * @return string
 */
function get_area($str){
	$temp = "";
	foreach (explode(",",$str) as $id){
		if($id)
			$temp .= M("district")->where("id = {$id}")->getField("name");
	}
	return $temp;
}

/**
 * 
 */
function get_file($id){
	return ;
}

