<?php
namespace Home\Controller;
/**
 * 文档模型控制器
 * 文档模型列表和详情
 */
class ArticleController extends HomeController {
	
	/* 文档模型频道页 */
	public function index() {
		/* 分类信息 */
		$category = $this->category ();
		
		// 频道页只显示模板，默认不读取任何内容
		// 内容可以通过模板标签自行定制
		$pics = M ( 'indexpics' )->order ( 'orders' )->select ();
		$this->assign ( 'pics', $pics );
		/* 模板赋值并渲染模板 */
		$this->assign ( 'category', $category );
		$this->display ( $category ['template_index'] );
	}
	
	/* 文档模型列表页 */
	public function lists($p = 1, $type = null) {
		/* 分类信息 */
		$category = $this->category ();
		/* 获取当前分类列表 */
		$Document = D ( 'Document' );
		
		
		
		$where = null;
		if (empty ( $type )) {// 最新
			$order = "update_time desc";
		} elseif ($type == "charge") { //收费模型
			$where = array("position"=>array("in","8,9,10,11,12,13,14,15"));
			$order = "update_time desc";
		} elseif ($type == "hot") { // 最热
			$order = "view desc";
		} elseif ($type == "recommend") { // 推荐
			$where = array("position"=>array("in","1,3,5,7,9,11,13,15"));
			$order = "level desc";
		}
		$this->view->assign ("type", $type );
		// 解析子类
		$childids = D ( 'Category' )->getChildrenId ( $category ['id'] );
		if ($childids) {
			$array = array_unique ( explode ( ",", $childids ) );
			$childids = implode ( ",", $array );
		}
		if ($childids) { // 包含子类
			$list = $Document->page ( $p, $category ['list_row'] )->lists ( $childids, $order ,1,true,$where);
			$count = count($Document->lists ( $childids, $order ,1,true,$where));
			$category ["id"] = $childids;
		} else { // 不包含子类
			$list = $Document->page ( $p, $category ['list_row'] )->lists ( $category ['id'], $order,1,true,$where);
			$count = count($Document->lists ( $childids, $order ,1,true,$where));
		}
		if (false === $list) {
			$this->error ( '获取列表数据失败！' );
		}
		
		
		
		/* 模板赋值并渲染模板 */
		$this->assign ( 'category', $category );
		foreach ( $list as $v ) {
			$temp [] = $Document->detail ( $v [id] );
		}
		$list = $temp;
		$this->assign ( 'list', $list );
		
		$page = new \Think\Page ( $count, 12 );
		$this->assign("page",$page->show () );
		
		$pics = M ( 'indexpics' )->order ( 'orders' )->select ();
		$this->assign ( 'pics', $pics );
		$this->assign("subtitle",$category['meta_title']);
		$this->assign("subkey",$category['keywords']);
		$this->assign("subdes",$category['description']);
		$this->display ( $category ['template_lists'] );
	}
	
	/* 文档模型详情页 */
	public function detail($id = 0, $p = 1) {
		/* 标识正确性检测 */
		if (! ($id && is_numeric ( $id ))) {
			$this->error ( '文档ID错误！' );
		}
		
		/* 页码检测 */
		$p = intval ( $p );
		$p = empty ( $p ) ? 1 : $p;
		
		/* 获取详细信息 */
		$Document = D ( 'Document' );
		$info = $Document->detail ( $id );
		if (! $info) {
			$this->error ( $Document->getError () );
		}
		
		/* 分类信息 */
		$category = $this->category ( $info ['category_id'] );
		
		/* 获取模板 */
		if (! empty ( $info ['template'] )) { // 已定制模板
			$tmpl = $info ['template'];
		} elseif (! empty ( $category ['template_detail'] )) { // 分类已定制模板
			$tmpl = $category ['template_detail'];
		} else { // 使用默认模板
			$tmpl = 'Article/' . get_document_model ( $info ['model_id'], 'name' ) . '/detail';
		}
		
		/* 更新浏览数 */
		$map = array (
				'id' => $id 
		);
		$Document->where ( $map )->setInc ( 'view' );
		/* 模板赋值并渲染模板 */
		$this->assign ( 'category', $category );
		$this->assign ( 'info', $info );
		
		$this->assign ( 'page', $p ); // 页码
		$this->assign("subtitle",$info['title']."_".$category['title']."_");
		$this->display ( $tmpl );
	}
	
	/* 文档分类检测 */
	private function category($id = 0) {
		/* 标识正确性检测 */
		$id = $id ? $id : I ( 'get.category', 0 );
		if (empty ( $id )) {
			$this->error ( '没有指定文档分类！' );
		}
		
		/* 获取分类信息 */
		$category = D ( 'Category' )->info ( $id );
		if ($category && 1 == $category ['status']) {
			switch ($category ['display']) {
				case 0 :
					$this->error ( '该分类禁止显示！' );
					break;
				// TODO: 更多分类显示状态判断
				default :
					return $category;
			}
		} else {
			$this->error ( '分类不存在或被禁用！' );
		}
	}
}
