<?php
namespace Home\Controller;
use User\Api\UserApi;

/**
 *
 * @abstract 模型管理控制器
 * @author zxf
 *        
 */
class ModelsController extends HomeController {
	
	/*
	protected  function _initialize(){
		$role = $this->checkAuth();
		if($role == 1  or $role == 3 or $role == 5 or $role == 7)
			parent::_initialize();
		else 
			$this->error("没有购买该模块，无法使用！");
		
	}
	*/
	
	/* 文档模型列表页 */
	public function lists($p = 1, $type = null) {
		// 获得分类信息
		$tree = D ( 'Category' )->getTree ( 46 );
		$this->assign ( "modelcate", $tree ['_'] );
		$_GET ['category'] = isset ( $_GET ['category'] ) ? $_GET ['category'] : "models";
		A ( "Article" )->lists ( $p, $type );
	}
	
	public function search($p = 1){
		$keyword = I ( 'keyword');
		$document = D("document");
		
		$ids = $document->where("model_id = 6 and title like '%{$keyword}%'")->page($p,12)->select();
		foreach ( $ids as $id ) {
			$model [] = $document->detail ( $id ["id"] );
		}
		$this->assign ( "list", array_filter ( $model ) );
		$page = new \Think\Page ( count(array_filter ($document->where("title like '%{$keyword}%'")->select())), 12 ,array("keyword"=>$keyword));
		
		$this->assign("page",$page->show ());
		$this->assign("subtitle",$keyword."_相关搜索_");
		$this->assign("subkey",$keyword."_相关搜索_");
		$this->assign("subdes",$keyword."_相关搜索_");
		$this->display();
	}
	
	/**
	 *
	 * @abstract 显示模型详情
	 * @param int $modelid        	
	 * @param int $madeid        	
	 */
	public function model($modelid, $madeid = "") {
		/* 标识正确性检测 */
		if (! ($modelid && is_numeric ( $modelid ))) {
			$this->error ( '文档ID错误！' );
		}
		
		if(IS_POST){
			if (! $uid = is_login ()) {
				$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
			}
			$data["uid"] = $uid;
			$data["modelid"] = I ( 'post.modelid', '', 'int' );
			$data ["addtime"] = time ();
			$data ["orderid"] = date ( "YmdHis", time () );
			$model = M("document_model")->where ( "id={$data['modelid']}" )->select ()[0];
			$data['total'] = $model['price'];
			$data['status'] = 1;
			if ($oid = M ( 'modelorder' )->add ( $data )) {
				$this->success ( '订单提交成功！', U('Home/Models/step1/id/'.$oid));
			} else {
				$this->error ( '订单提交失败' );
			}
			
		}
		/* 获取详细信息 */
		$Document = D ( 'Document' );
		$info = $Document->detail ( $modelid );
		if (! $info) {
			$this->error ( $Document->getError () );
		}
		$info ["cate"] = D ( "Category" )->info ( $info ["category_id"] );
		$info ["images"] = explode ( ",", $info ["images"] );
		$info ["file"] = M ( "file" )->where ( "id={$info['stl']}" )->select ()[0];
		
		/* 更新浏览数 */
		$map = array (
				'id' => $modelid 
		);
		$Document->where ( $map )->setInc ( 'view' );
		/* 模板赋值并渲染模板 */
		$this->assign ('info', $info );
		$uid = is_login ();
		$this->assign("hasmodel",hasmodel($uid,$info['id']));
		$this->assign("subtitle",$info['title']."_模型详情_");
		$this->display ();
	}
	
	/**
	 *
	 * @abstract 下载文件
	 * @param int $id        	
	 */
	public function download($modelid) {
		$model = D("document")->detail($modelid);
		if($model['price'] != 0){
			if (! $uid = is_login ()) {
				$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
			}
		}
		$uid = is_login ();
		if(($model['price'] != 0) and (hasmodel($uid, $modelid) == 0)){
			$this->error ( '没有下载权限', Cookie ( '__forward__' )  );
		}
		$file = D ( "file" );
		if (! $file->download ( C ( "DOWNLOAD_UPLOAD.rootPath" ), $model['stl'], adddowns,  $model['stl'] )) {
			$this->error ( $file->error );
		}
	}
	
	/**
	 *
	 * @abstract 用户中心模型列表
	 */
	public function modellist($p = 1) {
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		$User = new UserApi ();
		$userinfo = $User->info ( $uid );
		$this->assign ( 'user', $userinfo );
		
		$document = D ( "document" );
		$ids = $document->field ( "id" )->where ( "uid = {$uid} and model_id = 6" )->page ( $p, 12 )->select ();
		$count = $document->field ( "id" )->where ( "uid = {$uid} and model_id = 6" )->count ();
		foreach ( $ids as $id ) {
			$model [] = $document->detail ( $id ["id"] );
		}

		$this->assign ( "model", array_filter ( $model ) );
		$page = new \Think\Page ( $count, 12 );
		$this->assign("page",$page->show () );
		$this->assign("subtitle","我上传的模型_");
		$this->display ();
	}
	
	public function buylist($p = 1){
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		$User = new UserApi ();
		$userinfo = $User->info ( $uid );
		$this->assign ( 'user', $userinfo );
		
		$ids = M("modelorder")->where("uid = {$uid} and status >= 2")->page ( $p, 12 )->select ();
		$count = M("modelorder")->where("uid = {$uid} and status >= 2")->page ( $p, 12 )->count();
		
		foreach ( $ids as $id ) {
			$model [] = D( "document" )->detail ( $id ["modelid"] );
		}
		
		$this->assign ( "model", array_filter ( $model ) );
		$page = new \Think\Page ( $count, 12 );
		$this->assign("page",$page->show () );
		$this->assign("subtitle","我购买的模型_");
		$this->display ();
	}
	
	/**
	 *
	 * @abstract 上传模型
	 */
	public function upload() {
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		
		// 获得模型分类
		$tree = D ( 'Category' )->getTree ( 46 );
		foreach ( $tree ['_'] as $cate ) {
			$str .= "<option value = {$cate['id']}>{$cate['title']}</option>";
			if (! empty ( $cate ['_'] )) {
				foreach ( $cate ['_'] as $v ) {
					$str .= "<option value = {$v['id']}>&nbsp;&nbsp;&nbsp;&nbsp;{$v['title']}</option>";
				}
			}
		}
		$this->assign ( "option", $str );
		
		if (IS_POST) {
			$document = D ( 'Document' );
			$res = $document->update ();
			if (! $res) {
				$this->error ( $document->getError () );
			} else {
				$this->success ( $res ['id'] ? '更新成功' : '新增成功', Cookie ( '__forward__' ) );
			}
		}
		
		$this->display ();
	}
	/**
	 *
	 * @abstract 编辑模型
	 * @param int $id        	
	 */
	public function editmodel($modelid) {
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		if(hasmodel($uid, $modelid) != 1){
			$this->error ( '没有修改权限', Cookie ( '__forward__' )  );
		}
		$document = D ( "document" );
		
		$model = $document->detail ( $modelid );
		$this->assign ( "model", $model );
		// 获得图组信息
		foreach ( explode ( ",", $model ['images'] ) as $v ) {
			$picture [] = get_cover ( $v );
		}
		$this->assign ("picture", $picture );
		
		//获得模型信息
		$this->assign("stl",M("file")->where("id={$model['stl']}")->find());
		
		// 获得模型分类
		$tree = D ( 'Category' )->getTree ( 46 );
		foreach ( $tree ['_'] as $cate ) {
			if ($model ['category_id'] == $cate ['id'])
				$str .= "<option selected=\"selected\" value = {$cate['id']}>{$cate['title']}</option>";
			else
				$str .= "<option value = {$cate['id']}>{$cate['title']}</option>";
			if (! empty ( $cate ['_'] )) {
				foreach ( $cate ['_'] as $v ) {
					if ($model ['category_id'] == $v ['id'])
						$str .= "<option selected=\"selected\" value = {$v['id']}>&nbsp;&nbsp;&nbsp;&nbsp;{$v['title']}</option>";
					else
						$str .= "<option value = {$v['id']}>&nbsp;&nbsp;&nbsp;&nbsp;{$v['title']}</option>";
				}
			}
		}
		$this->assign ( "option", $str );
		if (IS_POST) {
			$res = $document->update ();
			if (! $res) {
				$this->error ( $document->getError () );
			} else {
				$this->success ( $res ['id'] ? '更新成功' : '新增成功', Cookie ( '__forward__' ) );
			}
		}
		$this->assign("subtitle","编辑模型_");
		$this->display ( "upload" );
	}
	/**
	 *
	 * @abstract 删除模型
	 * @param int $id        	
	 */
	public function deletemodel($modelid) {
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		if(hasmodel($uid, $modelid) != 1){
			$this->error ( '没有修改权限', Cookie ( '__forward__' )  );
		}
		$data ['status'] = - 1;
		$Model = D ( "document" )->where ( "uid={$uid} and id={$modelid}" );
		if ($Model->save ( $data )) {
			$this->success ( '删除成功', Cookie ( '__forward__' ) );
		} else {
			$this->error ( '删除失败', Cookie ( '__forward__' ) );
		}
	}
	
	/**
	 * 
	 * @param int $id
	 */
	public function step1($id){
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		$order = M("modelorder");
		$orderid = I ( 'id', '', 'int' );
		$User = new UserApi ();
		$userinfo = $User->info ( $uid );
		$this->assign ( 'user', $userinfo );
		$info = $order->where ( "id={$orderid}" )->select ()[0];
		$this->assign ( "info", $info );
		$this->assign("subtitle","购买模型_");
		$this->display ();
	}
	
	
	public function step2(){
		$this->assign("subtitle","购买模型_");
		$this->display ();
	}
	
	public function  step3($id){
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		$order = M("modelorder")->where("id = {$id}")->find();
		if($order['uid'] !== $uid){
			$this->error ( '您未购买该模型！', U ( 'Home/index' ) );
		}
		$Document = D ( 'Document' );
		$info = $Document->detail ($order['modelid']);
		if (! $info) {
			$this->error ( $Document->getError());
		}
		$info ["file"] = M ( "file" )->where ( "id={$info['stl']}" )->select ()[0];
		$this->assign("id",$id);
		$this->assign("info", $info );
		$this->assign("subtitle","购买模型_");
		$this->display ();
	}
	
	public function step4(){
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		$order = M("modelorder");
		$orderid = I ( 'id', '', 'int' );
		$this->assign ( "id", $orderid );
		if(IS_POST){
			$orderid = I ( 'post.id', '', 'int' );
			$data["comment"] = I ( 'post.comment', '', 'htmlspecialchars' );
			$data["status"] = 4;
			if ($order->where ( "id={$orderid}" )->save ( $data )) {
				$this->success ( '评价提交成功！', U('Models/orderlists'));
			} else {
				$this->error ( '评价提交失败' );
			}
		}
		$this->assign("subtitle","购买模型_");
		$this->display ();
	}
	
	public function orderlists($status = "all", $p = 1){
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		$order = M ( "modelorder" );
		if ($status != "all") {
			$list = $order->where ( "status={$status} and uid={$uid}" )->order ( "addtime desc" )->page ( $p, 10 )->select ();
			$count = $order->where ( "status={$status} and uid={$uid}" )->count ();
		} else {
			$list = $order->where ( "uid={$uid}" )->page ( $p, 10 )->order ( "addtime desc" )->select ();
			$count = $order->where ( "uid={$uid}" )->count ();
		}
		$page = new \Think\Page ( $count, 10 );
		foreach ($list as $k => $v){
			$product = D("document")->detail($v['modelid']);
			$list[$k]["pic"] = $product['cover_id'];
			$list[$k]["name"] = $product['title'];
		}
		
		$Api = new UserApi ();
		$res = $Api->info ( $uid );
		$this->assign ( "user", $res );
		$this->assign ( "page", $page->show () );
		$this->assign ( "order", $list );
		$this->assign("subtitle","模型订单_");
		$this->display ();
	}
	
	
	public function collectlist($p = 1){
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ));
		}
		
		$User = new UserApi ();
		$userinfo = $User->info ( $uid );
		$this->assign ( 'user', $userinfo );
		
		$ids = M("collects")->where("uid = {$uid}")->page ( $p, 12 )->select();
		$count = M("collects")->where("uid = {$uid}")->page ( $p, 12 )->count();
		
		
		foreach ( $ids as $id ) {
			$model [] = D( "document" )->detail ( $id ["modelid"] );
		}
		
		$this->assign ( "model", array_filter ( $model ) );
		$page = new \Think\Page ( $count, 12 );
		$this->assign("page",$page->show () );
		$this->assign("subtitle","我收藏的模型_");
		$this->display ();
	}
	
	
	public function addcollect($id){
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ));
		}
		$data["uid"] = $uid;
		$data["modelid"] = $id;
		if(M("collects")->where("modelid={$id} and uid = {$uid}")->count()){
			$this->error ( '请勿重复添加！');
		}
		if(M("collects")->data($data)->add()){
			M("document_model")->where("id={$id}")->setInc("collects");
			$this->success ( '成功添加收藏！', U ( "Models/collectlist" ) );
		}else{
			$this->error ( '添加收藏失败！');
		}
	}
	
	public function deletecollects($id){
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ));
		}
		if(M("collects")->where("modelid={$id} and uid = {$uid}")->delete()){
			$this->success ( '删除成功！');
		}else{
			$this->error ( '删除失败！');
		}
	}
	
	/**
	 *
	 * @abstract 用户取消订单
	 */
	public function cancelorder($orderid) {
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ));
		}
		if (IS_POST) {
			$order = M ( "modelorder" )->where ( "uid={$uid} and id={$orderid}" );
			$data ["note"] = I ( "note" );
			$data ["status"] = -1;
			if ($order->save ( $data )) {
				$this->success ( '订单已取消！', U ( "Models/orderlists" ) );
			} else {
				$this->error ( '订单取消失败！', U ( "Models/orderlists" ) );
			}
		}
	}
	
}