<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
namespace Home\Controller;

use User\Api\UserApi;

/**
 * 用户控制器
 * 包括用户中心，用户登录及注册
 */
class UserController extends HomeController {
	
	/* 用户中心首页 */
	public function index() {
	}
	
	/* 注册页面 */
	public function register($username = '', $password = '', $repassword = '', $email = '', $verify = '') {
		if (! C ( 'USER_ALLOW_REGISTER' )) {
			$this->error ( '注册已关闭' );
		}
		$this->assign("subtitle","用户注册_");
		if (IS_POST) { // 注册用户
			/*
			 * 检测验证码 if(!check_verify($verify)){ $this->error('验证码输入错误！'); }
			 */
			
			/* 检测密码 */
			if ($password != $repassword) {
				$this->error ( '密码和重复密码不一致！' );
			}
			/* 调用注册接口注册用户 */
			$User = new UserApi ();
			$uid = $User->register ( $username, $password, $email );
			if (0 < $uid) { // 注册成功
				$callback_url = "http://" . $_SERVER ['HTTP_HOST'] . U ( "User/validate?uid={$uid}&code=" . md5 ( $uid . C ( 'DATA_AUTH_KEY' ) ) );
				$body = '嗨，欢迎来到浮思绘的世界。浮思绘科技专注3D打印，希望运用3D打印，绘画你的“浮思乱想”，如果你想更多的了解3D打印，希望切身体验3D打印如何改变我们的生活，那就不要等待啦，<a href=' . $callback_url . '>立即点击这里激活</a>，加入浮思绘的世界吧！
				';
				if (send_mail ( $email, C ( 'WEB_SITE_TITLE' ) . '新用户', C ( 'WEB_SITE_TITLE' ) . '注册提醒邮件', $body ))
					$this->success ( '注册成功！请查看邮箱以激活用户~', U ( 'login' ) );
			} else { // 注册失败，显示错误信息
				$this->error ( $this->showRegError ( $uid ) );
			}
		} else { // 显示注册表单
			$this->display ();
		}
	}
	
	/**
	 *
	 * @abstract 验证用户邮箱
	 * @param int $uid        	
	 * @param string $code        	
	 */
	public function validate($uid, $code) {
		if (md5 ( $uid . C ( 'DATA_AUTH_KEY' ) ) == $code) { // 验证通过
			$Api = new UserApi ();
			$data ["status"] = 1;
			$re = M("ucenter_member")->where("id={$uid}")->save($data);
			if ($re !== false) {
				$this->success ( '邮箱激活成功~', U ( 'login' ) );
			} else {
				$this->error ( '激活失败！请重试~', U ( 'login' ) );
			}
		}
	}
	
	/**
	 * 忘记密码申请重置接受
	 * 
	 * @author Marvin9002
	 */
	public function pssHaddon() {
		if (IS_POST) {
			// 获取参数
			$uid = I ( 'get.id' );
			$repassword = I ( 'post.repassword' );
			$data ['password'] = I ( 'post.password' );
			empty ( $data ['password'] ) && $this->error ( '请输入新密码' );
			empty ( $repassword ) && $this->error ( '请输入确认密码' );
			
			if ($data ['password'] !== $repassword) {
				$this->error ( '您输入的新密码与确认密码不一致' );
			}
			$Api = new UserApi ();
			$res = $Api->updateInfo ( $uid, $password, $data );
			if ($res ['status']) {
				$this->success ( '修改密码成功！', U ( 'User/login' ) );
			} else {
				$this->error ( $res ['info'] );
			}
		} else {
			$this->display ();
		}
	}
	
	/* 登录页面 */
	public function login($username = '', $password = '', $verify = '') {
		$this->assign("subtitle","用户登录_");
		if (IS_POST) { // 登录验证
			/*
			 * 检测验证码 if(!check_verify($verify)){ $this->error('验证码输入错误！'); }
			 */
			/* 调用UC登录接口登录 */
			$user = new UserApi ();
			$uid = $user->login ( $username, $password );
			if (0 < $uid) { // UC登录成功
				/* 登录用户 */
				$Member = D ( 'Member' );
				if ($Member->login ( $uid )) { // 登录用户
					$this->success ( '登录成功！', U ( 'Home/Index/index' ) );
				} else {
					$this->error ( $Member->getError () );
				}
			} else { // 登录失败
				switch ($uid) {
					case - 1 :
						$error = '用户不存在或被禁用！';
						break; // 系统级别禁用
					case - 2 :
						$error = '密码错误！';
						break;
					case - 3 :
						$error = '邮箱未激活！';
						break;
					default :
						$error = '未知错误！';
						break; // 0-接口参数错误（调试阶段使用）
				}
				$this->error ( $error );
			}
		} else { // 显示登录表单
			$this->display ();
		}
	}
	
	/* 退出登录 */
	public function logout() {
		$this->assign("subtitle","用户退出_");
		if (is_login ()) {
			D ( 'Member' )->logout ();
			$this->success ( '退出成功！', U ( 'User/login' ) );
		} else {
			$this->redirect ( 'User/login' );
		}
	}
	
	/* 验证码，用于登录和注册 */
	public function verify() {
		$verify = new \Think\Verify ();
		$verify->entry ( 1 );
	}
	
	/**
	 * 获取用户注册错误信息
	 * 
	 * @param integer $code
	 *        	错误编码
	 * @return string 错误信息
	 */
	private function showRegError($code = 0) {
		switch ($code) {
			case - 1 :
				$error = '用户名长度必须在16个字符以内！';
				break;
			case - 2 :
				$error = '用户名被禁止注册！';
				break;
			case - 3 :
				$error = '用户名被占用！';
				break;
			case - 4 :
				$error = '密码长度必须在6-30个字符之间！';
				break;
			case - 5 :
				$error = '邮箱格式不正确！';
				break;
			case - 6 :
				$error = '邮箱长度必须在1-32个字符之间！';
				break;
			case - 7 :
				$error = '邮箱被禁止注册！';
				break;
			case - 8 :
				$error = '邮箱被占用！';
				break;
			case - 9 :
				$error = '手机格式不正确！';
				break;
			case - 10 :
				$error = '手机被禁止注册！';
				break;
			case - 11 :
				$error = '手机号被占用！';
				break;
			default :
				$error = '未知错误';
		}
		return $error;
	}
	
	/**
	 * 修改密码提交
	 * 
	 * @author huajie <banhuajie@163.com>
	 */
	public function profile() {
		$this->assign("subtitle","修改密码_");
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		$Api = new UserApi ();
		$res = $Api->info ( $uid );
		$this->assign ( "user", $res );
		if (IS_POST) {
			// 获取参数
			$uid = is_login ();
			$password = I ( 'post.old' );
			$repassword = I ( 'post.repassword' );
			$data ['password'] = I ( 'post.password' );
			empty ( $password ) && $this->error ( '请输入原密码' );
			empty ( $data ['password'] ) && $this->error ( '请输入新密码' );
			empty ( $repassword ) && $this->error ( '请输入确认密码' );
			
			if ($data ['password'] !== $repassword) {
				$this->error ( '您输入的新密码与确认密码不一致' );
			}
			
			$Api = new UserApi ();
			$res = $Api->updateInfo ( $uid, $password, $data );
			if ($res ['status']) {
				$this->success ( '修改密码成功！' );
			} else {
				$this->error ( $res ['info'] );
			}
		} else {
			$this->display ();
		}
	}
	
	/**
	 *
	 * @abstract 个人信息修改
	 * @author Zxf
	 */
	public function ucenter() {
		if (! $uid = is_login ()) {
			$this->error ( '使用此功能需要登录哦', U ( 'User/login' ) );
		}
		$Api = new UserApi ();
		if (IS_POST) {
			$data ['realname'] = I ( 'post.realname' );
			$data ['area'] = I ( 'post.area' );
			$data ['address'] = I ( 'post.address' );
			$data ['mobile'] = I ( 'post.mobile' );
			$data ['avatar'] = I ( 'post.avatar' );
			$re = $Api->updateInfo ( $uid, "", $data );
			
			/* 记录登录SESSION和COOKIES */
			$auth = array(
					'uid'             => $uid,
					'username'        => get_username($uid),
					'last_login_time' => session("user_auth.last_login_time"),
					'avatar'          => get_useravator($uid),
			);
			
			session("user_auth",$auth);
			if ($re ['status']) {
				$this->success ( '信息修改成功！' );
			} else {
				$this->error ( $re ['info'] );
			}
		}
		$res = $Api->info ( $uid );
		$this->assign ( "user", $res );
		$this->assign("subtitle","用户基本信息_");
		$this->display ();
	}
}
