<?php

/**
 * 主页
 *
 * @author 杨金球
 * @author 汤华斌
 */
class IndexAction extends PublicAction {

    //TODO:bpi-重构本页面方法
    public function index($build=0) {
        //获取软件滚动列表
        $roll_list = $this->getSoftwareRollList();
        //获取软件推荐列表
        $recommend_list = $this->getSoftwareRecommendList();
        //获取专题展示列表
        $menu_list = $this->getMenuList();
        //获取最新应用
        $newapp = $this->getNewApp();
        //获取最新游戏
        $newgame = $this->getNewGame();



        $this->hot();   //热门下载
        //$this->download_rank_list();    //下载排行榜
        $this->assign('title', $this->setting['title']); //分配标题
        $this->assign('keyword', $this->setting['keyword']); //分配关键字
        $this->assign('content', $this->setting['describe']); //分配内容



        $this->assign('roll_list', $roll_list); //滚动显示
        $this->assign('menu_list', $menu_list); //专题展示
        $this->assign('recommend_list', $recommend_list);   //软件推荐
        $this->assign('newapp', $newapp);
        $this->assign('newgame', $newgame);
        $this->assign('subjectCount', count($menu_list));
		if(!$build) $this->display();

		//HTML静态，此版暂时不支持 $this->buildHtml(文件名,路径,项目地址);
		//$this->buildHtml($htmlfile='1',$htmlpath='a',$templateFile='Public:software_list');
		//$this->buildHtml('index','./','Home:Index:index');
    }

    //首页24小时生成静态一次//静态下的登录状态没做处理，暂时隐蔽。
    /*
	public function buildindex() {
		// 生成当前模块首页静态文件
		$indexfile = WEB_ROOT.'/index.html'; //静态首页文件
		clearstatcache(true, $indexfile); //清除文件状态缓存
		$filetime = filemtime($indexfile); //获取文件最后修改时间
		C('HTML_CACHE_ON',false); //临时关闭静态缓存
		if((time()-$filetime) > (24*60*60)){
			$this->index(1); //调用index操作给模版变量赋值
			$this->buildHtml('index','./','Home:Index:index');
		}
	}*/

    private function getSoftwareRollList() {
        //软件滚动列表
        $soft = new Model();
        $map['status'] = 1;
        $map['roll'] = 1;
        $roll_list = F('Roll/list');    //读取滚动数据



        if (empty($roll_list)) {  //缓存过期或者不存在
            $roll_list = $soft->query("SELECT id, name, jumpurl, roll_img FROM ".C('DB_PREFIX')."software where status='1' AND roll='1' ORDER BY roll_order ASC");
            F('Roll/list', $roll_list); //缓存
        }
        return $roll_list;
    }

    private function getSoftwareRecommendList() {
        //软件推荐列表
		$soft = new Model();
        $arg['status'] = 1;
        $arg['recommend'] = 1;
        $arg['jumpurl'] = 0;

		$recommend_list = $soft->query("SELECT id,name,icon,jumpurl,hits FROM ".C('DB_PREFIX')."software where status='$arg[status]' AND recommend='$arg[recommend]' AND jumpurl='0' GROUP BY id ORDER BY recommend_order ASC LIMIT 0,20 ");

        return $recommend_list;
    }

    private function getMenuList() {
        //专题展示
		$menu = new Model();
        $cond['status'] = 1;
        $cond['extend'] = 0;
        $cond['show'] = 1;
        $cond['pid'] = C('HOME_CUSTOMACTION_ID');

        $menu_list = F('Subject_show/list');    //读取缓存
        if (empty($menu_list)) {    //缓存不存在或过期
			$menu_list = $menu->query("SELECT id, name, picture FROM ".C('DB_PREFIX')."menu where status='$cond[status]' AND extend='$cond[extend]' AND show='$cond[show]' AND pid='$cond[pid]'");
            F('Subject_show/list', $menu_list); //缓存
        }
        return $menu_list;
    }

    private function getNewApp() {
		$soft_belong = new Model();
        //最新应用
        $map2['menu_id'] = C('HOME_APPLY_ID');
        $map2['status'] = 1;
        $map2['jumpurl'] = 0;

		$newapp = $soft_belong->query("SELECT B.id,B.icon,B.jumpurl,SUBSTR(B.name, '1',6) AS name,B.hits FROM ".C('DB_PREFIX')."software B LEFT JOIN ".C('DB_PREFIX')."soft_belong A ON B.id=A.soft_id where B.status='1' AND A.menu_id='$map2[menu_id]' AND B.jumpurl='0' GROUP BY A.soft_id ORDER BY B.time DESC LIMIT 0,12");

        return $newapp;
    }

    private function getNewGame() {
        $soft_belong = new Model();
        //最新游戏
        $arg2['menu_id'] = C('HOME_GAMEACTION_ID');
        $arg2['status'] = 1;
        $arg2['jumpurl'] = 0;

		$newgame = $soft_belong->query("SELECT B.id,B.icon,B.jumpurl,SUBSTR(B.name, '1',6) AS name,B.hits FROM ".C('DB_PREFIX')."software B LEFT JOIN ".C('DB_PREFIX')."soft_belong A ON B.id=A.soft_id where B.status='1' AND A.menu_id='$arg2[menu_id]' AND B.jumpurl='0' GROUP BY A.soft_id ORDER BY B.time DESC LIMIT 0,20");

        return $newgame;
    }

}

?>
