<?php

/**
 * 本类为软件信息类
 *
 * @author 杨金球
 */
class SoftAction extends PublicAction {

    //软件信息
    public function _empty($method) {
        if (is_numeric($method)) {
            $map[C('DB_PREFIX').'software.id'] = $method;
            //$map['status'] = 1;
            $map['jumpurl'] = 0;

            $soft = M('software');

            $soft_msg = $soft->field(C('DB_PREFIX').'software.id, name,  mobile_name, charge, version, size, language, suitsdk, hits, status, upload_uid, '.C('DB_PREFIX').'software.time, `explain`, update_explain,
                                     keyword, icon, picture, url, passageway, qr_url, COUNT('.C('DB_PREFIX').'download.soft_id) AS down, TMP.score')
                            ->join(C('DB_PREFIX').'download ON '.C('DB_PREFIX').'software.id = '.C('DB_PREFIX').'download.soft_id')
                            ->join('(SELECT soft_id, ROUND(AVG('.C('DB_PREFIX').'comment.score),1) AS score FROM '.C('DB_PREFIX').'comment GROUP BY soft_id) AS TMP ON TMP.soft_id = '.C('DB_PREFIX').'software.id')
                            ->where($map)->group(C('DB_PREFIX').'software.id')->find();

            if (!empty($soft_msg)) {    //如果搜索到软件信息
                $soft_belong = M('soft_belong');
                $arg['soft_id'] = $method;
                $arg['menu_id'] = array('IN', C('HOME_APPLY_ID') . ',' . C('HOME_GAMEACTION_ID'));
                $soft_msg['type'] = $soft_belong->field('name')->join(C('DB_PREFIX').'menu ON '.C('DB_PREFIX').'menu.id = '.C('DB_PREFIX').'soft_belong.menu_child_id')->where($arg)->find();
                //分数转换成对应图片
                $soft_msg['score'] = empty($soft_msg['score']) ? scoreToStar(0) : scoreToStar($soft_msg['score']);
				$soft_msg['time'] = date("Y-m-d",$soft_msg['time']);

                $pic = explode(',', $soft_msg['picture'], 5); //分割图片
                if ($pic[0] == '') {
                    $pic = '';  //如果没图片的话清除值
                }

                //dump($pic);
                $passageway = M('passageway');  //通道管理
                $arg['id'] = array('IN', $soft_msg['passageway']);
                $arg['status'] = 1;

                $passageway_list = $passageway->field('name, url, type')->where($arg)->order('type DESC, id ASC')->select();

                //猜你喜欢。随机选取10个软件
                $soft_list = S('soft_list');
                if (empty($soft_list)) {    //读取出全部有效软件的下载数
                    $soft_list = $soft->field(C('DB_PREFIX').'software.id, SUBSTR(name, 1, 5) AS name, icon, jumpurl, ROUND(AVG(score),1) AS score')
                                    ->join(C('DB_PREFIX').'comment ON '.C('DB_PREFIX').'comment.soft_id = '.C('DB_PREFIX').'software.id')
                                    ->where('status = 1 AND jumpurl = 0')->group(C('DB_PREFIX').'software.id')->select();
                    S('soft_list', $soft_list, 3600); //缓存1小时
                }
                //读取缓存
                $rand_recommend = S('rand_recommend_' . $method);
                if (empty($rand_recommend)) {
                    shuffle($soft_list);    //打乱数组
                    $rand_recommend = array_slice($soft_list, 0, 10);
                    for ($i = 0; $i < count($rand_recommend); $i++) {
                        $rand_recommend[$i]['score'] = empty($rand_recommend[$i]['score']) ? scoreToStar(0) : scoreToStar($rand_recommend[$i]['score']);
                    }
                    S('rand_recommend_' . $method, $rand_recommend, 300); //缓存5分钟
                }

                //版本选择
                $cond['soft_id'] = intval($method);
                $soft_version = M('soft_version');
                $softVersion = $soft_version->field('id, soft_version')->where($cond)->order('update_time DESC, id ASC')->select();

				if(isset($soft_msg) && $soft_msg['status'] == '1'){
					$this->assign('soft_name', $soft_msg['name'].'&nbsp;&nbsp;'. $soft_msg['version']. '版');
					$this->assign('soft_msg', $soft_msg);       //分配软件信息
                	$this->assign('soft_pic', $pic);        //分配截图
                	$this->assign('passageway_list', $passageway_list);     //分配通道
               	    $this->assign('title', $soft_msg['name'].'-'.$this->setting['title']);  //分配标题
               		$this->assign('content', substr($soft_msg['explain'], 0, 60));        //分配软件简介
                	$this->assign('keyword', $soft_msg['keyword']); //分配关键字
                	$this->assign('rand_recommend', $rand_recommend);   //分配猜你喜欢
                	$this->assign('softVersion', $softVersion); //分配版本列表
                	$this->display('soft');
				}else if(isset($soft_msg) && $soft_msg['upload_uid'] == $_SESSION['user_id'] && $soft_msg['status'] != '1'){
					$this->assign('soft_name', '<span style="color:#FF3F00">该软件已下架或者审核中，你是软件发布者，所以可预览！</span>');
					$this->assign('soft_msg', $soft_msg);       //分配软件信息
                	$this->assign('soft_pic', $pic);        //分配截图
                	$this->assign('passageway_list', $passageway_list);     //分配通道
               	    $this->assign('title', $soft_msg['name'].'-'.$this->setting['title']);  //分配标题
               		$this->assign('content', substr($soft_msg['explain'], 0, 60));        //分配软件简介
                	$this->assign('keyword', $soft_msg['keyword']); //分配关键字
                	$this->assign('rand_recommend', $rand_recommend);   //分配猜你喜欢
                	$this->assign('softVersion', $softVersion); //分配版本列表
                	$this->display('soft');
				}else{
					$url = $this->setting['domain'];
        			$this->assign('jumpUrl', $url);
        			$this->success('该应用已被删除或者还在审核中！');
				}

            } else {
                $this->error(C('ERROR_MESSAGE'));
            }
        } else {
            $this->error(C('ERROR_MESSAGE'));
        }
    }

    /**
     * 评论
     */
    public function comment() {
        $map[C('DB_PREFIX').'comment.soft_id'] = intval($_GET['id']);
        $map[C('DB_PREFIX').'software.status'] = 1;

        $comment = M('comment');

        import("ORG.Util.Page");    //导入分页类
        $count = $comment->where('soft_id=' . $map[C('DB_PREFIX').'comment.soft_id'])->count(); //读取总条数

        $page = new Page($count, 15);

        $page->setConfig('theme', '%upPage% %first%  %prePage%  %linkPage%  %nextPage% %end%  %downPage% '); //自定义分页显示
        $show = $page->show();

        $comment_list = $comment->field(C('DB_PREFIX').'comment.id, '.C('DB_PREFIX').'comment.time, content, score, user_id, '.C('DB_PREFIX').'user.name AS username,
                                         '.C('DB_PREFIX').'software.name, '.C('DB_PREFIX').'soft_version.soft_version, max_version ')
                        ->join(C('DB_PREFIX').'user ON '.C('DB_PREFIX').'user.id = '.C('DB_PREFIX').'comment.user_id')
                        ->join(C('DB_PREFIX').'software ON '.C('DB_PREFIX').'software.id = '.C('DB_PREFIX').'comment.soft_id')
                        ->join(C('DB_PREFIX').'soft_version ON '.C('DB_PREFIX').'soft_version.id = '.C('DB_PREFIX').'comment.soft_version')
                        ->join('(SELECT soft_version AS max_version, id, soft_id FROM '.C('DB_PREFIX').'soft_version where soft_id = ' . intval($_GET['id']) . ' ORDER BY id DESC limit 1 ) AS TMP ON TMP.soft_id = '.C('DB_PREFIX').'comment.soft_id')
                        ->where($map)->order(C('DB_PREFIX').'comment.time DESC')->limit($page->firstRow . ', ' . $page->listRows)->select();
        for ($i = 0; $i < count($comment_list); $i++) {
            $comment_list[$i]['time'] = date("Y-m-d",$comment_list[$i]['time']);
			$comment_list[$i]['score'] = empty($comment_list[$i]['score']) ? scoreToStar(0) : scoreToStar($comment_list[$i]['score']);
            $comment_list[$i]['soft_version'] = $comment_list[$i]['soft_version'] == $comment_list[$i]['max_version'] ? '当前版本' : $comment_list[$i]['soft_version'];
        }
        $this->assign('page', $show);   //分配分页
        $this->assign('comment_list', $comment_list); //分配评论内容
        $this->assign('count', $count);     //分配总条数
        $this->display();
    }

    //软件评论
    public function soft_comment() {
			if (isset($_SESSION['user_id'])) {  //判断有没有登录
            if ($_SESSION['user_status']) { //判断是否禁用
                $s = htmlspecialchars(trim($_POST['comment_text']));
                if (!empty($s)) {
                    $map['soft_id'] = intval($_GET['id']);
                    $map['user_id'] = $_SESSION['user_id'];
					//自动匹配当前版本
                    $cond['soft_id'] = $map['soft_id'];
					$soft_version = M('soft_version');
                    $softVersion = $soft_version->field('id')->where($cond)->order('update_time DESC, id ASC')->find();
                    $map['soft_version'] = $softVersion['id'];

                    $comment = M('comment');
                    if (!$comment->where($map)->find()) {
                        $map['time'] = time();
                        $map['score'] = $_POST['score'];
                        $map['content'] = $s;
                        if ($comment->add($map)) {
                            $this->ajaxReturn('', '', 1);
                        } else {
                            $this->ajaxReturn('', '发表评论失败，请稍后再试', 0);
                        }
                    } else {
                        $this->ajaxReturn('', '对不起，你对此版本已经发表过评论，请勿重新发表', 0);
                    }
                } else {
                    $this->ajaxReturn('', '评论内容不能为空', 0);
                }
            } else {
                $this->ajaxReturn('', '该用户已经被禁用，禁止发表评论', 0);
            }
        } else {
            $this->ajaxReturn('', '对不起，未登录不能发表评论', 0);
        }
    }

    //搜索软件
    public function search() {
        $map['name'] = array('LIKE', '%' . $_GET['keyword'] . '%');
        $map['status'] = 1;
        $map['LENGTH(jumpurl)'] = 0;
        //dump($map);
        $this->software_list($map);
        $this->hot();
        //$this->download_rank_list();
        $this->assign('title', '搜索 [' . $_GET['keyword'] . ']');  //分配标题
        $this->assign('keyword', '搜索 [' . $_GET['keyword'] . ']'); //分配关键字
        $this->assign('content', '搜索 [' . $_GET['keyword'] . ']');    //分配内容
        $this->assign('barName', '搜索');
        $this->display();
    }

    //软件推荐列表
    public function recommend() {
        //软件推荐列表
        $arg['status'] = 1;
        $arg['recommend'] = 1;
        $arg['menu_id'] = array('IN', C('HOME_APPLY_ID') . ',' . C('HOME_GAMEACTION_ID'));
        $this->software_list($arg);

        $this->hot();
        $this->assign('title', '精品推荐');  //分配标题
        $this->assign('keyword', '推荐软件'); //分配关键字
        $this->assign('content', '推荐软件');    //分配内容
        $this->assign('barName', '精品推荐');
        $this->display('search');
    }

    //收藏软件
    public function favorite() {
        if (!isset($_SESSION['user_id']) || empty($_SESSION['user_id'])) {
            $this->ajaxReturn('', '', 2);
        }
        $map['soft_id'] = intval($_GET['id']);
        $map['user_id'] = intval($_SESSION['user_id']);

        $softFavorite = M('soft_favorites');

        if (!$softFavorite->where($map)->find()) {
            if ($softFavorite->add($map)) {
                $this->ajaxReturn('', '', 1);
            } else {
                $this->ajaxReturn('', '', 0);
            }
        } else {
            $this->ajaxReturn('', '', 0);
        }
    }

}

?>
