<?php

/**
 * 注册成员管理类
 *
 * @author Yang
 */
class UserAction extends PublicAction {

    //初始化设置
    public function _initialize() {
        parent::_initialize();
        if (!isset($_SESSION['user_id']) || empty($_SESSION['user_id'])) {
            //页面跳转
            echo "<script language='javascript' type='text/javascript'>window.location.href='" . __APP__ . "/Login/index?url=" . rawurlencode(__APP__ . '/User/') . "'</script>";
        }
    }

    public function index() {
        if (C('BIND_BBS')) {    //绑定论坛后跳到论坛用户中心
            //页面跳转
            echo "<script language='javascript' type='text/javascript'>window.location.href='" . C('BBS_URL') . "/home.php?mod=spacecp'</script>";
        } else {    //没有绑定就本地处理
            $this->assign('title', '用户中心');
            $this->display();
        }
    }

    //获取用户头像
    public function images() {
        if (!C('BIND_BBS')) { //没有绑定论坛
            $head = strtolower(($_SERVER['HTTPS'] == 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . substr($_SERVER['PHP_SELF'], 0, strrpos($_SERVER['PHP_SELF'], '/')));
            $head = substr($head,'0','16');
            if (file_exists(WEB_ROOT.'/Public/Upload/user/' . $_GET['id'] . '.jpg')) {
                $url = '/Public/Upload/user/' . $_GET['id'] . '.jpg';
            } else {
                $url = '/Public/Upload/user/img.gif';
            }

            header('Location: ' . $head . $url);
            exit;
        } else {
            header('Location: ' . C('BBS_URL') . '/uc_server/avatar.php?uid=' . $_GET['uid'] . '&size=small');
            exit;
        }
    }

    //上传用户头像
    public function upload_user_img() {
        if (!C('BIND_BBS')) {
            //导入上传类
            import("ORG.Net.UploadFile");
            //实例化上传类
            $upload = new UploadFile();
            $upload->maxSize = 50000; // 设置附件上传大小
            $upload->allowExts = array('jpg', 'jpeg', 'png', 'gif'); // 设置附件上传类型
            $upload->savePath = './Public/Upload/temp/'; // 设置附件上传目录
            $upload->saveRule = 'time';
            $upload->uploadReplace = true; //存在同名文件是否覆盖
            $upload->thumb = true;   //是否进行缩略图处理
            $upload->thumbPrefix = 'user_'; //保存时文件名前缀
            $upload->thumbMaxWidth = 48; //最大宽度
            $upload->thumbMaxHeight = 48; //最大高度
            $upload->thumbRemoveOrigin = true; //是否删除原图

            if (!$upload->upload()) {
                $this->ajaxReturn('', $upload->getErrorMsg(), 0);
            } else {
                $info = $upload->getUploadFileInfo();
                $this->ajaxReturn('', 'user_' . $info[0]['savename'], 1);
            }
        } else {
            $this->ajaxReturn('', C('ERROR_MESSAGE'), 0);
        }
    }

    //修改用户资料
    public function user_msg() {
        if (!C('BIND_BBS')) {   //没有绑定论坛
            $info = '';
            if (!empty($_POST['password']) && !empty($_POST['newpassword'])) {
                $user = M('user');
                $map['id'] = $_SESSION['user_id'];
                $map['pwd'] = md5($_POST['password']);
                if ($user->where($map)->find()) {
                    $map['pwd'] = md5($_POST['newpassword']);
                    if (!$user->save($map)) {
                        $this->error('密码修改失败，请稍后再试');
                    } else {
                        $info = '修改密码成功。';
                    }
                } else {
                    $this->error('修改密码错误，原密码不匹配');
                }
            }
            if (!empty($_POST['user_img_name'])) {
                if (is_file('./Public/Upload/temp/' . $_POST['user_img_name'])) {
                    if (rename('./Public/Upload/temp/' . $_POST['user_img_name'], './Public/Upload/user/' . $_SESSION['user_id'] . '.jpg')) {
                        $info .= '头像修改成功';
                    } else {
                        $this->error($info . '修改头像失败，请重新再试');
                    }
                } else {
                    $this->error($info . '修改头像失败，请重新再试');
                }
            }
            $this->success($info);
        } else {
            $this->error(C('ERROR_MESSAGE'));
        }
    }

}

?>
