/**
 * 本类放着本项目大部分JS函数
 */

/**
 * 重定向分页中a标签链接到本页main区域中
 */
function returnPage(){
    $('#page > a').click(function (){
        var url = $(this).attr('href');
        $('#main').load(url);
        return false;
    })
}

/**
 * ajax提交数据(POST)方法
 * @param 后台接收地址
 * @param 数据
 */
function postData(url, data){
    $.post(url, data, function (json){
        if(json.status == 1){
            alert('操作成功');
        } else {
           alert('操作失败');
        }
    },'json')
}

/**
 * get方法AJAX操作
 * @param 操作时确认信息
 * @param 后台处理地址
 * @param 数据
 * @param 操作成功时重定向网址
 */
function get_json(msg, url, data, redirect){
    if(confirm(msg)){
        $.getJSON(url, data, function (json){
            if(json.status == 1){
                alert('操作成功');
                $('#main').load(redirect);
            } else {
                if(json.info.length == 0){
                    alert('操作失败');
                } else {
                    alert(json.info);
                }
            }
        })
    }
}

/**
 * 通过选取父类别的下拉列表获取子类别下拉列表
 * @param url 后台操作地址
 * @param pid 父类别ID
 */
function get_menu_child_list(url, pid){
    $.getJSON(url, {
        pid:pid
    }, function (json){
        if(json.status == 1){
            $('#menu_child_list').html(json.info);
        } else {
            alert('获取子类别时发生错误，请稍后再试');
        }
    })
}

/**
 * 全选复选框 点击ID=checkall 选中name为check[]的复选框
 */
function all_checkbox(){
    $('#checkall').click(function (){
        var e = document.getElementsByName("check[]");
        for(var i = 0; i < e.length; i++){
            e[i].checked = document.getElementById("checkall").checked;
        }
    })
}

//获取复选框的值，多值以‘，’;
function get_checkbox(){
    var e = $('[name="check[]"]');
    var id = '';
    var dh = '';
    var status = false;
    for(var i = 0; i < e.length; i++){
        if(e.eq(i).attr('checked') == 'checked'){
            id += dh +  e.eq(i).val();
            dh = ',';
            status = true;
        }
    }
    if(!status){
        return 0;
    } else {
        return id;
    }
}