<?php

/**
 * 本类放置函数调用类，在加载的时候自动调用。不必引用
 */
/*
 * 需要引入THINKPHP的extend类Load('extend');
 * 截取中文字符串
 * $str 要处理的字符串
 * $max_length 当字符串长度超过这个时，就截取
 * $length 截取的长度（汉字长度），（从0开始截取）
 */
function cut_str($str, $max_length, $length) {
    $str = strip_tags($str); //去除HTML标签
    if (strlen($str) > $max_length) {
        $str = msubstr($str, 0, $length);
    }
    return $str;
}

//传入评分时，返回对应图片
function scoreToStar($score) {
    if ($score < 0.5) {
        $star = 'app_star00.png';
    } else if ($score >= 0.5 && $score < 1) {
        $star = 'app_star01.png';
    } else if ($score >= 1 && $score < 1.5) {
        $star = 'app_star02.png';
    } else if ($score >= 1.5 && $score < 2) {
        $star = 'app_star03.png';
    } else if ($score >= 2 && $score < 2.5) {
        $star = 'app_star04.png';
    } else if ($score >= 2.5 && $score < 3) {
        $star = 'app_star05.png';
    } else if ($score >= 3 && $score < 3.5) {
        $star = 'app_star06.png';
    } else if ($score >= 3.5 && $score < 4) {
        $star = 'app_star07.png';
    } else if ($score >= 4 && $score < 4.5) {
        $star = 'app_star08.png';
    } else if ($score >= 4.5 && $score < 4.7) {
        $star = 'app_star09.png';
    } else if ($score >= 4.7 && $score <= 5) {
        $star = 'app_star10.png';
    }
    return $star;
}


/**
*服务器信息
**/
function systemMsg(){
	global $db,$siteurl,$SCRIPT_FILENAME,$WEBURL;

	isset($_COOKIE) ? $rs[ifcookie]="SUCCESS" : $rs[ifcookie]="FAIL";
	$rs[sysversion]=PHP_VERSION;	//PHP版本
	$rs[max_upload]= ini_get('upload_max_filesize') ? ini_get('upload_max_filesize') : 'Disabled';	//最大上传限制
	$rs[max_ex_time]=ini_get('max_execution_time').' 秒';	//最大执行时间
	$rs[sys_mail]= ini_get('sendmail_path') ? 'Unix Sendmail ( Path: '.ini_get('sendmail_path').')' :( ini_get('SMTP') ? 'SMTP ( Server: '.ini_get('SMTP').')': 'Disabled' );	//邮件支持模式
	$rs[systemtime]=date("Y-m-j g:i A");	//服务器所在时间
	if( function_exists("imagealphablending") && function_exists("imagecreatefromjpeg") && function_exists("ImageJpeg") ){
		$rs[gdpic]="支持";
	}else{
		$rs[gdpic]="不支持";
	}
	$rs[allow_url_fopen]=ini_get('allow_url_fopen')?"On 支持采集数据":"OFF 不支持采集数据";
	$rs[safe_mode]=ini_get('safe_mode')?"打开":"关闭";
	$rs[DOCUMENT_ROOT]=$_SERVER["DOCUMENT_ROOT"];	//程序所在磁盘物理位置
	$rs[SERVER_ADDR]=$_SERVER["SERVER_ADDR"]?$_SERVER["SERVER_ADDR"]:$_SERVER["LOCAL_ADDR"];		//服务器IP
	$rs[SERVER_PORT]=$_SERVER["SERVER_PORT"];		//服务器端口
	$rs[SERVER_SOFTWARE]=$_SERVER["SERVER_SOFTWARE"];	//服务器软件
	$rs[SCRIPT_FILENAME]=$_SERVER["SCRIPT_FILENAME"]?$_SERVER["SCRIPT_FILENAME"]:$_SERVER["PATH_TRANSLATED"];//当前文件路径


	//获取ZEND的版本
	ob_end_clean();
	ob_start();
	phpinfo();
	$phpinfo=ob_get_contents();
	ob_end_clean();
	ob_start();
	preg_match("/with(&nbsp;| )Zend(&nbsp;| )Optimizer(&nbsp;| )([^,]+),/is",$phpinfo,$zenddb);
	$rs[zendVersion]=$zenddb[4]?$zenddb[4]:"未知/可能没安装";


	$rs[memory_user_limit]=ini_get('memory_limit');    //最大执行时间/空间限制内存
	$rs[file_uploads]=ini_get('file_uploads')?"允许":"不允许"; //是否允许上传文件
	
	return $rs;
}
?>
