<?php

/**
 * 超级管理员管理类（包含对普通管理员增删权限）
 *
 * @author Yang
 */
class AdministratorAction extends CommonAction {

    public function _initialize() {
        parent::_initialize();
        if (!isset($_SESSION['flag']) || $_SESSION['flag'] != 1) {
            exit(C('ERROR_MESSAGE'));
        }
    }

    //首页
    public function index() {
        $admin = M('admin');
        $map['flag'] = 0;

        $adminList = $admin->where($map)->select();
        //dump($adminList);
        $this->assign('adminList', $adminList);

        $this->display();
    }

    //增加管理员
    public function add() {
        $this->display();
    }

    //增加管理员保存
    public function addAdmin() {
        $map['username'] = $_POST['username'];
        $map['pwd'] = md5(substr(md5($_POST['pwd']), 0, 16));
        $map['status'] = $_POST['status'];

        $admin = M('admin');
        if (!$admin->add($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

    //禁用管理员
    public function forbiddenAdmin() {
        $map['id'] = intval($_GET['id']);
        $map['status'] = 0;

        $admin = M('admin');

        if (!$admin->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

    //开启管理员
    public function openAdmin() {
        $map['id'] = intval($_GET['id']);
        $map['status'] = 1;

        $admin = M('admin');

        if (!$admin->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

    //删除管理员
    public function deleteAdmin() {
        $map['id'] = intval($_GET['id']);

        $admin = M('admin');

        if (!$admin->where($map)->delete()) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

    //修改管理员密码
    public function chgpwd() {
        $map['id'] = intval($_GET['id']);
        $map['pwd'] = md5(substr(md5($_GET['pwd']), 0, 16));

        $admin = M('admin');

        if (!$admin->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

}

?>
