<?php

/**
 * 
 * 这里是项目公共函数
 * @author 杨金球
 *
 */
class CommonAction extends Action {

    
    public function _initialize(){
        if(!isset ($_SESSION['adminID']) || empty ($_SESSION['adminID'])){
			$this->redirect('Login/');
        }
    }

    //添加扩展子类别
    public function add() {
        $map['id'] = $_GET['id']; //获取父菜单ID
        $map['extend'] = 1; //保证该父菜单是支持扩展的

        $menu = M('menu'); //实例化bpi_menu 数据库

        $name = $menu->field('name, path')->where($map)->find();

        if (!$name) {
            $this->assign('name', '错误，此类不支持自动扩展。');
        } else {
            $this->assign('name', $name);
        }
        $this->display();
    }

    //新增类别中上传类别图标
    public function add_category_upload_icon() {
        $size = 200000;
        $ext = array('jpg', 'gif', 'png', 'jpeg');
        $path = './Public/Upload/category/';
        $name = 'cat_';
        $maxwidth = 69;
        $maxheight = 69;

        $info = $this->upload($size, $ext, $path, $name, $maxwidth, $maxheight ,$rule = true);

        if ($info[0] == 0) {
            $this->ajaxReturn('', $info[1], 0);
        } else {
            $this->ajaxReturn('', $name . $info[0]['savename'], 1);
        }
    }

    //添加子类别数据库保存
    public function add_category() {
        $map['pid'] = $_GET['id'];

        $map['name'] = $_POST['name'];
		$map['keyword'] = $_POST['keyword'];
        $map['icon'] = $_POST['image'];
        $map['picture'] = $_POST['image'];
        $map['explain'] = $_POST['cat_exp'];
        $map['status'] = 1;
        if ($map['pid'] == C('HOME_CUSTOMACTION_ID')) {
            if (!empty($_POST['title'])) {
                $map['title'] = $_POST['title'];
            } else {
                $map['title'] = '专题推荐';
            }
        }

        $menu = M('menu');

        if (!$menu->add($map)) {
			$this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL); //清空缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //父类别下的子类别列表
    public function menu_index($id) {
        $map['pid'] = $id;
        $arg['id'] = $id;
        $menu = M('menu');

        import("ORG.Util.Page"); //导入分页类

        $count = $menu->where($map)->count(); //总记录数
        $page = new Page($count, 10);
        $show = $page->show();

        $menu_child = $menu->field(C('DB_PREFIX').'menu.id, name, icon, status, SUBSTRING(`explain`,1,20) AS `explain`, count(soft_id) AS count')
                        ->join(C('DB_PREFIX').'soft_belong ON '.C('DB_PREFIX').'menu.id = '.C('DB_PREFIX').'soft_belong.menu_child_id')->where($map)->group(C('DB_PREFIX').'menu.id')
                        ->limit($page->firstRow . ',' . $page->listRows)->select();

        $menu_name = $menu->field('id, name')->where($arg)->find();

        $this->assign('menu', $menu_child);
        $this->assign('page', $show);
        $this->assign('name', $menu_name);
    }

    //删除子类别
    public function del_menu() {
        $map['id'] = $_GET['id'];

        $map['length(pid)'] = array('GT', 0); //确保类别上有父类别

        $menu = M('menu');
        $soft_belong = M('soft_belong');

        if (!$menu->where($map)->delete()) {
            $this->ajaxReturn('', '', 0);
        } else {
            $arg['menu_child_id'] = $_GET['id'];
            $soft_belong->where($arg)->delete(); //删除在该类别的软件列表数据
            F('List/menu_list', NULL); //清空子类列列表缓存
            F('Subject/subject_msg_' . $_GET['id'], NULL);  //清空专题信息缓存
            F('Subject_recommend/recommend_list', NULL); //清空专题推荐缓存
            F('Subject_show/list', NULL); //清空专题显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //禁用子类别
    public function forbidden_menu() {
        $map['id'] = $_GET['id'];

        $map['length(pid)'] = array('GT', 0); //确保类别上有父类别
        $map['status'] = 0;

        $menu = M('menu');

        if (!$menu->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL); //清空缓存
            F('Subject/subject_msg_' . $_GET['id'], NULL);  //清空专题信息缓存
            F('Subject_recommend/recommend_list', NULL); //清空专题推荐缓存
            F('Subject_show/list', NULL); //清空专题显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //开启子类别
    public function open_menu() {
        $map['id'] = $_GET['id'];

        $map['status'] = 1;

        $menu = M('menu');

        if (!$menu->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL); //清空缓存
            F('Subject/subject_msg_' . $_GET['id'], NULL);  //清空专题信息缓存
            F('Subject_recommend/recommend_list', NULL); //清空专题推荐缓存
            F('Subject_show/list', NULL); //清空专题显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //编辑子类别
    public function edit_category() {
        $map['id'] = $_GET['id'];
        $map['length(pid)'] = array('GT', 0); //确保类别上有父类别

        $menu = M('menu');

        $menu_msg = $menu->field('`name`, `keyword`, `icon`, `explain`, `title`')->where($map)->find();

        $this->assign('menu', $menu_msg);



        $this->display();
    }

    //保存子类别修改
    public function edit_category_save() {
        $map['id'] = $_GET['id'];

        $map['name'] = $_POST['name'];
		$map['keyword'] = $_POST['keyword'];
        $map['icon'] = $_POST['image'];
        $map['explain'] = $_POST['cat_exp'];
        if (isset($_POST['title'])) {
            if (!empty($_POST['title'])) {
                $map['title'] = $_POST['title'];
            } else {
                $map['title'] = '专题推荐';
            }
        }
        $map['length(pid)'] = array('GT', 0); //确保类别上有父类别

        $menu = M('menu');

        if (!$menu->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL); //清空缓存
            F('Subject/subject_msg_' . $_GET['id'], NULL);  //清空专题信息缓存
            F('Subject_recommend/recommend_list', NULL); //清空专题推荐缓存
            F('Subject_show/list', NULL); //清空专题显示缓存
			//HTML静态，此版暂时不支持
			//$this->buildHtml($htmlfile='1',$htmlpath='a',$templateFile='Public:software_list');
			//$this->buildHtml($map['id'],'a/','Home:Public:software_list');
            $this->ajaxReturn('', '', 1);
        }
    }

    //子类别内容
    public function category() {
        $map['id'] = $_GET['id'];
        $map['length(pid)'] = array('GT', 0); //确保类别上有父类别

        $menu = M('menu');

        $menu_msg = $menu->field('pid, name, status, icon')->where($map)->find();

        if ($menu_msg) {
            $arg['menu_id'] = $menu_msg['pid'];
            $arg['menu_child_id'] = $_GET['id'];

            $software = M('software');

            import("ORG.Util.Page"); //导入分页类

            $count = $software->join(C('DB_PREFIX').'soft_belong ON '.C('DB_PREFIX').'soft_belong.soft_id = '.C('DB_PREFIX').'software.id')->where($arg)->count(); //总记录数
            $page = new Page($count, 10);
            $show = $page->show();

            $software_list = $software->field(C('DB_PREFIX').'software.id, name, version, time, icon, status')
                    ->join(C('DB_PREFIX').'soft_belong ON '.C('DB_PREFIX').'soft_belong.soft_id = '.C('DB_PREFIX').'software.id')
                    ->where($arg)
                    ->limit($page->firstRow . ',' . $page->listRows)
                    ->select();

            $this->get_menu();
            //dump($software_list);
            $this->assign('soft', $software_list);
            $this->assign('page', $show);
            $this->assign('name', $menu_msg);

            $this->display();
        }
    }

    //移除软件出类别
    public function del_soft() {
        $map['soft_id'] = $_GET['id']; //获取软件ID		
        $map['menu_child_id'] = $_GET['menu_id']; //获取栏目ID

        $soft_belong = M('soft_belong');

        if (!$soft_belong->where($map)->delete()) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL); //清空缓存
            F('Subject_soft_list/subject_' . $_GET['menu_id'], NULL); //清空缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //移动软件
    public function move_soft() {
        $arg['soft_id'] = $_GET['soft_id'];
        $arg['menu_child_id'] = $_GET['mid']; //此条件为查询现类别软件所在ID

        $map['soft_id'] = $_GET['soft_id'];
        $map['menu_id'] = $_GET['menu_id'];
        $map['menu_child_id'] = $_GET['menu_child_id']; //此条件为查询类别有没有此软件存在

        $soft_belong = M('soft_belong');

        if (!$soft_belong->field('id')->where($map)->find()) { //如果类别中没有此软件	
            $id = $soft_belong->field('id')->where($arg)->find();
            if ($id) {
                $map['id'] = $id['id']; //获取主键
                if ($soft_belong->save($map)) { //更新所在主键信息
                    F('List/menu_list', NULL); //清空缓存
                    F('Subject_soft_list/subject_' . $_GET['mid'], NULL); //清空原类别缓存
                    F('Subject_soft_list/subject_' . $_GET['menu_child_id'], NULL); //清空现类别缓存
                    $this->ajaxReturn('', '', 1);
                } else {
                    $this->ajaxReturn('', '', 0);
                }
            } else {
                $this->ajaxReturn('', '操作失败，类别中无此软件存在', 0);
            }
        } else { //如果现类别已有此软件
            $this->ajaxReturn('', '操作失败，类别中已有此软件', 0);
        }
    }

    //复制软件或分配软件到类别
    public function copy_soft() {
        $map['soft_id'] = $_GET['soft_id'];
        $map['menu_id'] = $_GET['menu_id'];
        $map['menu_child_id'] = $_GET['menu_child_id'];

        $soft_belong = M('soft_belong');

        if (!$soft_belong->field('id')->where($map)->find()) { //如果类别中没有此软件
            if (!$soft_belong->add($map)) {
                $this->ajaxReturn('', '', 0);
            } else {
                F('List/menu_list', NULL); //清空缓存
                F('Subject_soft_list/subject_' . $_GET['menu_child_id'], NULL); //清空现类别缓存
                $this->ajaxReturn('', '', 1);
            }
        } else {//如果类别中已有此软件
            $this->ajaxReturn('', '操作失败，类别中已有此软件', 0);
        }
    }

    //获取软件类别下拉列表以及第一个类别中的子类别列表(下拉列表)
    public function get_menu() {
        $menu = M('menu');

        $map['extend'] = 1; //确保此类别是支持自动扩展的

        $menu_list = $menu->field('id, name')->where($map)->select(); //获取父类别

        if ($menu_list) {
            $arg['pid'] = $menu_list[0]['id']; //获取第一个父类别下的子类别列表

            $menu_child_list = $menu->field('id, name')->where($arg)->select();

            $count = count($menu_list);
            $menu_msg = '';

            for ($i = 0; $i < $count; $i++) {//转换为HTML语句
                $menu_msg .= "<option value=" . $menu_list[$i]['id'] . ">" . $menu_list[$i]['name'] . "</option>";
            }

            $count = count($menu_child_list);
            $child = '';

            for ($i = 0; $i < $count; $i++) {//转换为HTML语句
                $child .= "<option value=" . $menu_child_list[$i]['id'] . ">" . $menu_child_list[$i]['name'] . "</option>";
            }

            $this->assign('menu', $menu_msg);
            $this->assign('child', $child);
        }
    }

    //通过选取父类别的下拉列表AJAX加载子类别
    public function get_child_menu() {
        $map['pid'] = $_GET['pid'];

        $menu = M('menu');

        $menu_child = $menu->field('id, name')->where($map)->select();

        $count = count($menu_child);
        $menu_child_list = '';

        for ($i = 0; $i < $count; $i++) {
            $menu_child_list .= "<option value=" . $menu_child[$i]['id'] . ">" . $menu_child[$i]['name'] . "</option>";
        }

        $this->ajaxReturn('', $menu_child_list, 1);
    }

    //获取镜像列表
    public function get_passageway() {
        $map['status'] = 1;

        $way = M('passageway');

        $way_list = $way->where($map)->order('type DESC')->select();

        $this->assign('way_list', $way_list);
    }

    /**
     * 
     * 文件上传类
     * @param int 	     最大文件大小 单位Byte
     * @param array   允许的文件后缀，数组表示
     * @param url 	     存储路径
     * @param varchar 图片文件压缩后图片名前缀
     * @param int 	     图片最大宽度
     * @param int     图片最大高度
     */
    public function upload($size, $ext, $path, $name, $maxwidth, $maxheight, $rule = true) {
        //导入上传类
        import("ORG.Net.UploadFile");
        //实例化上传类
        $upload = new UploadFile();
        $upload->maxSize = $size; // 设置附件上传大小
        $upload->allowExts = $ext; // 设置附件上传类型
        $upload->savePath = $path; // 设置附件上传目录
        if ($rule) { //文件保存规则
            $upload->saveRule = 'time';
        }
        $upload->uploadReplace = false; //存在同名文件是否覆盖
        $upload->thumb = true;   //是否进行缩略图处理
        $upload->thumbPrefix = $name; //保存时文件名前缀
        $upload->thumbMaxWidth = $maxwidth; //最大宽度	
        $upload->thumbMaxHeight = $maxheight; //最大高度	
        $upload->thumbRemoveOrigin = true; //是否删除原图

        if (!$upload->upload()) {
            $info[0] = 0;
            $info[1] = $upload->getErrorMsg();
            return $info; //上传失败时返回错误信息
        } else {
            $info = $upload->getUploadFileInfo();
            return $info; //上传成功时返回文件信息
        }
    }

}