<?php

/**
 *
 * 本类为软件管理操作
 * @author 杨金球
 *
 */
class SoftwareAction extends CommonAction {

    //软件菜单下的子菜单列表
    public function menu() {
        $map['pid'] = C('HOME_SOFT_MENU_ID');

        $menu = M('menu');

        $menu_list = $menu->field('id, name, path')->where($map)->select();

        $count = count($menu_list);
        $path = "$('#main').load('" . __GROUP__ . "/Software/index')";
        $msg = '<input type="button" class="btn02" value="软件管理" onclick="' . $path . '"/>';

        for ($i = 0; $i < $count; $i++) {
            $path = "$('#main').load('" . __GROUP__ . $menu_list[$i]['path'] . "')";
            $msg .= '<input class="btn02" type="button" value="' . $menu_list[$i]['name'] . '" onclick="' . $path . '"/>';
        }
        $this->assign('menu_child', $msg);
    }

    //软件首页
    public function index() {
        //javascript 传参数用encodeURIComponent($str);
        //PHP 解析用 rawurldecode($str);
        //$map = 1;
        //$map['upload_uid'] = 0;
        $map['jumpurl'] = 0;
        $order = 'id ASC';
        if (isset($_GET['kw_type'])) {//表示有搜索
            //unset($map);
            if (isset($_GET['kw']) && $_GET['kw'] != null && $_GET['kw_type'] = 'id') {
				$kw_type = C('DB_PREFIX').'software.id';
				$map[$kw_type] = array('like', rawurldecode($_GET['kw']) );
            }else if(isset($_GET['kw']) && $_GET['kw'] != null){
				$map[$_GET['kw_type']] = array('like', '%' . rawurldecode($_GET['kw']) . '%');
			}
            if (isset($_GET['charge']) && $_GET['charge'] != 2) {//2表示全部(是否收费)
                $map['charge'] = $_GET['charge'];
            }
            if (isset($_GET['status']) && $_GET['status'] != 2) {//2表示全部(状态)
                $map['status'] = $_GET['status'];
            }
            if (isset($_GET['recommend']) && $_GET['recommend'] != 2) {//2表示全部(是否推荐)
                $map['recommend'] = $_GET['recommend'];
            }
//            if (!isset($map)) {
//                $map = 1;
//            }
        }

        if (isset($_GET['order']) && $_GET['order'] != null) {
            switch ($_GET['order']) {
                case 1 : $order = 'id DESC';
                    break;
                case 2 : $order = 'id ASC';
                    break;
                case 3 : $order = 'time DESC';
                    break;
                case 4 : $order = 'time ASC';
                    break;
                default : $order = 'id DESC';
            }
        }else{
			$order = 'id DESC';
		}

        $soft = M('software');

        import("ORG.Util.Page"); //导入分页类

        $count = $soft->where($map)->count();
        $page = new Page($count, 15);
        $show = $page->show();

        $soft_list = $soft->field(C('DB_PREFIX') .'software.id, icon, name, mobile_name, version, '.C('DB_PREFIX').'software.time, charge, status, recommend ,
                                   COUNT('.C('DB_PREFIX').'download.soft_id) AS down,  TMP.comment')
                        ->join(C('DB_PREFIX').'download ON '.C('DB_PREFIX').'software.id = '.C('DB_PREFIX').'download.soft_id')
                        ->join('(SELECT soft_id, COUNT(soft_id) AS comment FROM '.C('DB_PREFIX').'comment WHERE 1 GROUP BY soft_id)AS TMP  ON '.C('DB_PREFIX').'software.id = TMP.soft_id')
                        ->where($map)->group(C('DB_PREFIX').'software.id')->order($order)->limit($page->firstRow . ',' . $page->listRows)->select();

        for ($i = 0; $i < count($soft_list); $i++) {
            $soft_list[$i]['time'] = date("Y-m-d",$soft_list[$i]['time']);
        }
		$this->get_menu(); //获取分类类别
        $this->assign('soft', $soft_list);
        $this->assign('page', $show);
        $this->menu();
        $this->display();
    }



    //上传软件
    public function upload_soft() {
        $this->get_passageway(); //获取镜像列表
        $this->get_menu(); //获取类别
        $this->menu();
        $this->display();
    }

    //上传软件ICON(仅支持PNG)
    public function upload_icon() {
        import("ORG.Net.UploadFile");
        $data = date('Ymd');
        $upload = new UploadFile();
        $upload->maxSize = 50000; //大小限制50K
        $upload->allowExts = array('png'); //仅支持PNG
        $upload->savePath = './Public/Upload/soft_icon/' . $data . '/';
        $upload->saveRule = 'time';

        if (!$upload->upload()) {
            $this->ajaxReturn('', $upload->getErrorMsg(), 0);
        } else {
            $info = $upload->getUploadFileInfo();
            $this->ajaxReturn('', $data . '/' . $info[0]['savename'], 1);
        }
    }

    //上传软件内容
    public function upload_soft_url() {
        $data = date('Ymd');
        $size = 31457280; //大小限制30M
        $ext = array();
        $path = './Public/Upload/soft/' . $data . '/';
        $name = "";
        $maxwidth = "";
        $maxheight = "";

        $info = $this->upload($size, $ext, $path, $name, $maxwidth, $maxheight, $rule = true);

        if ($info[0] == 0) { //上传失败返回错误信息
            $this->ajaxReturn('', $info[1], 0);
        } else {    //上传成功时返回文件信息
            $info[0]['savename'] = $data . '/' . $info[0]['savename'];
            $this->ajaxReturn('', $info[0], 1);
        }
    }

    //上传软件截图
    public function soft_picture() {
        $data = date('Ymd');
        $size = 600000; //大小限制150K
        $ext = array('jpg', 'gif', 'png', 'jpeg');
        $path = './Public/Upload/soft_img/' . $data . '/';
        $name = "img_";
        $maxwidth = 200;
        $maxheight = 200;

        $info = $this->upload($size, $ext, $path, $name, $maxwidth, $maxheight, $rule = true);

        if ($info[0] == 0) {
            $this->ajaxReturn('', $info[1], 0);
        } else {
            import("@.ORG.Image");
            //缩略图添加水印, Image::water('原文件名','水印图片地址')
            //Image::water($info[0]['savepath'] . $name . $info[0]['savename'], './Public/Hi/chrome.png');
            $this->ajaxReturn('', $data . '/' . $name . $info[0]['savename'], 1);
        }
    }

    //增加软件数据库保存
    public function upload_soft_save() {
        Vendor('qr.phpqrcode'); //引入二维码类库
        $map['name'] = $_POST['soft_name'];
        $map['keyword'] = $_POST['soft_keyword'];
        $map['mobile_name'] = $_POST['soft_mobile_name'];
        $map['charge'] = $_POST['soft_chrage'];
        $map['version'] = $_POST['version'];
        $map['language'] = $_POST['soft_language'];
        $map['explain'] = $_POST['soft_explain'];
        $map['icon'] = $_POST['soft_icon_name'];
        $map['url'] = $_POST['soft_url_value'];
        $map['md5_file'] = $_POST['soft_url_hash'];
        $map['time'] = time();
        $map['status'] = 1;
        $map['recommend'] = 0;

        $arg['menu_id'] = $_POST['menu_list'];
        $arg['menu_child_id'] = $_POST['menu_child_list'];

        Load('extend'); //引入文件
        $map['size'] = byte_format($_POST['soft_url_size']); //字节格式化

        $map['picture'] = '';   //获取截图信息，多个截图以,隔开
        $dh = '';
        if (isset($_POST['soft_picture'])) {
            $count = count($_POST['soft_picture']);
            for ($i = 0; $i < $count; $i++) {
                $map['picture'] .= $dh . $_POST['soft_picture'][$i];
                $dh = ',';
            }
        }

        $map['passageway'] = '';
        $dh = '';
        if (isset($_POST['check'])) {
            $count = count($_POST['check']);
            for ($i = 0; $i < $count; $i++) {
                $map['passageway'] .= $dh . $_POST['check'][$i];
                $dh = ',';
            }
        }

        $soft = M('software');
        $soft_belong = M('soft_belong');
        $soft_version = M('soft_version');

        $time = date('Ymd');
        $map['qr_url'] = '/Public/Upload/qr/' . $time . '/';
        $id = $soft->add($map);

        if (!$id) {
            $this->ajaxReturn('', '', 0);
        } else {
            //增加软件版本列表
            $cond['soft_id'] = $id;
            $cond['soft_version'] = $map['version'];
            $cond['update_time'] = time();
            $soft_version->add($cond);
            F('List/menu_list', NULL); //清空列表缓存
            //绘制二维码保存
            if (!is_dir('./Public/Upload/qr/')) {
                mkdir('./Public/Upload/qr/');
            }
            if (!is_dir('./Public/Upload/qr/' . $time)) {
                mkdir('./Public/Upload/qr/' . $time);
            }
            QRcode::png($id, '.' . $map['qr_url'] . $id . '.png', $level = QR_ECLEVEL_L, $size = 3, $margin = 2);
            if (isset($_POST['assign_check']) && $_POST['assign_check'] == 'on') { //没有分配列表
                $this->ajaxReturn('', '', 1);
            } else {
                $arg['soft_id'] = $id;
                if (!$soft_belong->add($arg)) {
                    $this->ajaxReturn('', '上传软件成功，但分配失败。稍后请手动分配', 0);
                } else {
                    $this->ajaxReturn('', '', 1);
                }
            }
        }
    }

    //查看详情
    public function soft_msg() {
        $softwareid = C('DB_PREFIX').'software.id';
		$map[$softwareid] = intval($_GET['id']);

        $soft = M('software');

        $soft_msg = $soft->field(C('DB_PREFIX').'software.id, name, mobile_name, charge, version, size, language, '.C('DB_PREFIX').'software.time, `explain`, update_explain,
                                  keyword, icon, picture, passageway, qr_url, COUNT('.C('DB_PREFIX').'comment.soft_id) AS comment_num, ROUND(avg('.C('DB_PREFIX').'comment.score),1) AS score')
                ->join(''.C('DB_PREFIX').'comment ON '.C('DB_PREFIX').'comment.soft_id = '.C('DB_PREFIX').'software.id')
                ->where($map)
                ->group(C('DB_PREFIX').'software.id')
                ->find();

        $download = M('download');
        $soft_msg['download_num'] = $download->field('soft_id')->where('soft_id = ' . $map['bpi_software.id'])->group('soft_id')->count();


        $pic = explode(',', $soft_msg['picture'], 5); //获取图片列表

        if (count($pic) == 1 && $pic[0] == '') {
            $pic = null;
        }

        $this->assign('soft', $soft_msg);
        $this->assign('pic', $pic);
        $this->get_passageway();
        $this->display();
    }

    //更新软件信息
    public function soft_msg_save() {
        $map['id'] = trim($_POST['id']);
        $map['name'] = $_POST['soft_name'];
        $map['keyword'] = $_POST['soft_keyword'];
        $map['mobile_name'] = $_POST['soft_mobile_name'];
        $map['charge'] = $_POST['soft_chrage'];
        $map['version'] = $_POST['version'];
        $map['language'] = $_POST['soft_language'];
        $map['explain'] = $_POST['soft_explain'];
        $map['icon'] = $_POST['soft_icon_name'];
        $map['update_explain'] = $_POST['soft_update_explain'];

        $map['picture'] = '';   //获取截图信息，多个截图以,隔开
        $dh = '';
        if (isset($_POST['soft_picture'])) {
            $count = count($_POST['soft_picture']);
            for ($i = 0; $i < $count; $i++) {
                $map['picture'] .= $dh . $_POST['soft_picture'][$i];
                $dh = ',';
            }
        }

        $map['passageway'] = '';   //获取镜像信息，多个截图以,隔开
        $dh = '';
        if (isset($_POST['check'])) {
            $count = count($_POST['check']);
            for ($i = 0; $i < $count; $i++) {
                $map['passageway'] .= $dh . $_POST['check'][$i];
                $dh = ',';
            }
        }

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //更新软件
    public function update_soft() {
        $map['id'] = $_GET['id'];

        $soft = M('software');

        $soft_msg = $soft->field('id, name, version, update_explain, icon, url')->where($map)->find();

        $this->assign('soft', $soft_msg);
        $this->display();
    }

    //更新软件数据库保存
    public function update_soft_save() {
        $map['id'] = $_POST['id'];
        $map['version'] = $_POST['version'];
        $map['url'] = $_POST['soft_url_value'];
        $map['update_explain'] = $_POST['soft_explain'];
        $map['md5_file'] = $_POST['soft_url_hash'];
        $map['time'] = time();

        Load('extend'); //引入文件
        $map['size'] = byte_format($_POST['soft_url_size']); //字节格式化

        $soft = M('software');
        $soft_version = M('soft_version');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            //增加软件版本信息
            $arg['soft_id'] = $_GET['id'];
            $arg['soft_version'] = $map['version'];
            $arg['update_time'] = time();
            $soft_version->add($arg);
            $this->ajaxReturn('', '', 1);
        }
    }

    //下架软件
    public function forbidden_soft() {
        $map['id'] = $_GET['id'];
        $map['status'] = -1;

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL);
            // 清空缓存
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //批量禁用
    public function forbidden_softs() {
        $map['id'] = array('in', $_GET['id']);
        $map['status'] = -1;

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL);  //清空子类别缓存
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //审核软件
    public function open_soft() {
        $map['id'] = $_GET['id'];
        $map['status'] = 0;

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL);
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }


	//销售软件
    public function sale_soft() {
        $map['id'] = $_GET['id'];
        $map['status'] = 1;

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL);
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //推荐软件
    public function recommend_soft() {
        $map['id'] = $_GET['id'];
        $map['recommend'] = 1;

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

    //删除软件
    public function del_soft() {
        $map['id'] = $_GET['id'];

        $soft = M('software');
        $soft_belong = M('soft_belong');
        $comment = M('comment');
        $down = M('download');

        if (!$soft->where($map)->delete()) {
            $this->ajaxReturn('', '', 0);
        } else {
            $soft_belong->where($arg)->delete(); //删除软件在分配列表的数据
            $comment->where($arg)->delete();    //删除评论列表
            $down->where($arg)->delete();       //删除下载列表
            F('List/menu_list', NULL);          //清空类别缓存，类别中含有软件数量
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //获取软件分配列表
    public function assign_list() {
        $map['soft_id'] = $_GET['id'];

        $soft_belong = M('soft_belong');

        $soft_belong_list = $soft_belong->field(C('DB_PREFIX').'soft_belong.id, '.C('DB_PREFIX').'menu.name, TMP.child_name')
                        ->join(C('DB_PREFIX').'menu ON  '.C('DB_PREFIX').'menu.id = '.C('DB_PREFIX').'soft_belong.menu_id')
                        ->join('(SELECT id, name AS child_name FROM '.C('DB_PREFIX').'menu) AS TMP ON TMP.id = '.C('DB_PREFIX').'soft_belong.menu_child_id')
                        ->where($map)->order('menu_id ASC, menu_child_id ASC')->select();

        if (!$soft_belong_list) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', $soft_belong_list, 1);
        }
    }

    //移除软件出列表，根据主键删除
    public function remove_soft() {
        $map['id'] = $_GET['id'];

        $soft_belong = M('soft_belong');

        if (!$soft_belong->where($map)->delete()) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('List/menu_list', NULL);
            $this->ajaxReturn('', '', 1);
        }
    }

    //软件滚动中图片
    public function upload_preview() {
        $size = 3000000; //大小限制300K
        $ext = array('jpg', 'gif', 'png', 'jpeg');
        $path = './Public/Upload/soft_roll/';
        $name = "roll_";
        $maxwidth = 700;
        $maxheight = 220;

        $info = $this->upload($size, $ext, $path, $name, $maxwidth, $maxheight);

        if ($info[0] == 0) {
            $this->ajaxReturn('', $info[1], 0);
        } else {
            $this->ajaxReturn('', $name . $info[0]['savename'], 1);
        }
    }

    //定制软件中查询软件信息(是否推荐，是否跳转，是否滚动)
    public function operate_soft_msg() {
        $map['id'] = $_GET['id'];

        $soft = M('software');

        $soft_msg = $soft->field('id, recommend, jumpurl, roll, roll_img, apk_show')->where($map)->find();

        if ($soft_msg) {
            $this->ajaxReturn($soft_msg, '', 1);
        } else {
            $this->ajaxReturn('', '', 0);
        }
    }

    //定制软件中保存信息
    public function soft_operate_save() {
        $map['id'] = intval($_POST['id']);
        $map['recommend'] = 0;
        $map['jumpurl'] = '0';
        $map['roll'] = 0;
        $map['apk_show'] = 0;
		$map['roll_img'] = empty($_POST['preview_img_name'])? '': $_POST['preview_img_name'];


        if (isset($_POST['soft_recommend']) && $_POST['soft_recommend'] == 'on') {
            $map['recommend'] = 1;
        }

        if (isset($_POST['soft_jump']) && $_POST['soft_jump'] == 'on' && !empty($_POST['soft_jumpurl'])) {
            $map['jumpurl'] = $_POST['soft_jumpurl'];
        }

        if (isset($_POST['soft_roll']) && $_POST['soft_roll'] == 'on' && !empty($_POST['preview_img_name'])) {
            $map['roll'] = 1;
        }

        if (isset($_POST['soft_show']) && $_POST['soft_show'] == 'on') {
            $map['apk_show'] = 1;
        }

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //推荐列表
    public function recommend() {
        $soft = M('software');

        $map['recommend'] = 1;

        import("ORG.Util.Page"); //导入分页类

        $count = $soft->where($map)->count();
        $page = new Page($count, 20);
        $show = $page->show();

        $soft_list = $soft->field('id, icon, name, time, charge, status, recommend_order')
                        ->where($map)->order('recommend_order ASC')->limit($page->firstRow . ',' . $page->listRows)->select();

        $this->assign('soft', $soft_list);
        $this->assign('page', $show);
        $this->menu();
        $this->display();
    }

    //软件推荐顺序
    public function ord_recommend() {
        $map['id'] = intval($_GET['id']);
        $map['recommend'] = 1;
        $map['recommend_order'] = intval($_GET['ord']);

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

    //从推荐列表中移除
    public function del_recommend() {
        $map['id'] = $_GET['id'];
        $map['recommend'] = 0;

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

    //评论列表模式一
    public function comment() {
        $comment = M('comment');

        import("ORG.Util.Page"); //导入分页类

        $count = $comment->count();
        $page = new Page($count, 15);
        $show = $page->show();

        $comment_list = $comment->field(C('DB_PREFIX').'comment.id, content, '.C('DB_PREFIX').'comment.time, score, '.C('DB_PREFIX').'software.name, '.C('DB_PREFIX').'user.name AS username, '.C('DB_PREFIX').'soft_version.soft_version')
                        ->join(C('DB_PREFIX').'software ON '.C('DB_PREFIX').'software.id = '.C('DB_PREFIX').'comment.soft_id')
                        ->join(C('DB_PREFIX').'user ON '.C('DB_PREFIX').'user.id = '.C('DB_PREFIX').'comment.user_id')
                        ->join(C('DB_PREFIX').'soft_version ON '.C('DB_PREFIX').'soft_version.id = '.C('DB_PREFIX').'comment.soft_version')
                        ->order(C('DB_PREFIX').'comment.id DESC')->limit($page->firstRow . ',' . $page->listRows)->select();
//        $comment_list = $comment->field('bpi_comment.id, bpi_comment.time, content, score, user_id, username, bpi_software.name, bpi_soft_version.soft_version ')
//                        ->join('bpi_software ON bpi_software.id = bpi_comment.soft_id')
//                        ->join('bpi_soft_version ON bpi_soft_version.id = bpi_comment.soft_version')
//                        ->order('bpi_comment.time DESC')->limit($page->firstRow . ',' . $page->listRows)->select();

        $this->assign('comment', $comment_list);
        $this->assign('page', $show);
        $this->menu();
        $this->display();
    }

    //评论列表模式二
    public function comment2() {
        $comment = M('comment');

        import("ORG.Util.Page"); //导入分页类

        $count = count($comment->group('soft_id')->select());
        $page = new Page($count, 15);
        $show = $page->show();

        $comment_list = $comment->field('soft_id, count(soft_id), ROUND(avg(score),1) AS score, '.C('DB_PREFIX').'software.name, '.C('DB_PREFIX').'software.icon')
                        ->join(C('DB_PREFIX').'software ON '.C('DB_PREFIX').'software.id = '.C('DB_PREFIX').'comment.soft_id')
                        ->group('soft_id')->order('count(soft_id) DESC, soft_id ASC')
                        ->limit($page->firstRow . ',' . $page->listRows)->select();

        $this->assign('comment', $comment_list);
        $this->assign('page', $show);
        $this->menu();
        $this->display();
    }

    //评论列表模式二查看评论
    public function comment_list() {
        $soft_id = C('DB_PREFIX').'comment.soft_id';
		$map[$soft_id] = $_GET['id'];

        $comment = M('comment');

        import("ORG.Util.Page"); //导入分页类

        $count = $comment->where($map)->count();
        $page = new Page($count, 15);
        $show = $page->show();

        $comment_list = $comment->field(C('DB_PREFIX').'comment.id, content, '.C('DB_PREFIX').'comment.time, score, '.C('DB_PREFIX').'software.name, '.C('DB_PREFIX').'user.name AS username, '.C('DB_PREFIX').'soft_version.soft_version')
                        ->join(C('DB_PREFIX').'software ON '.C('DB_PREFIX').'software.id = '.C('DB_PREFIX').'comment.soft_id')
                        ->join(C('DB_PREFIX').'user ON '.C('DB_PREFIX').'user.id = '.C('DB_PREFIX').'comment.user_id')
                        ->join(C('DB_PREFIX').'soft_version ON '.C('DB_PREFIX').'soft_version.id = '.C('DB_PREFIX').'comment.soft_version')
                        ->where($map)->order('time DESC')->limit($page->firstRow . ',' . $page->listRows)->select();
//        $comment_list = $comment->field('bpi_comment.id, bpi_comment.time, content, score, user_id, username, bpi_software.name, bpi_soft_version.soft_version ')
//                        ->join('bpi_software ON bpi_software.id = bpi_comment.soft_id')
//                        ->join('bpi_soft_version ON bpi_soft_version.id = bpi_comment.soft_version')
//                        ->where($map)->order('bpi_comment.time DESC')->limit($page->firstRow . ',' . $page->listRows)->select();

        $this->assign('comment', $comment_list);
        $this->assign('page', $show);
        $this->display();
    }

    //删除一条评论
    public function del_comment() {
        $map['id'] = $_GET['id'];

        $comment = M('comment');

        $id = $comment->field('soft_id')->where($map)->find();

        if (!$comment->where($map)->delete()) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

    //批量删除评论
    public function del_comments() {
        $map['id'] = array('in', $_GET['id']);

        $comment = M('comment');

        if (!$comment->where($map)->delete()) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

    //下载查看
    public function download() {
        $download = M('download');

        import("ORG.Util.Page"); //导入分页类

        $count = count($download->group('soft_id')->select());
        $page = new Page($count, 15);
        $show = $page->show();

        $down_list = $download->field('soft_id, count(soft_id) AS download_count,  '.C('DB_PREFIX').'software.name, '.C('DB_PREFIX').'software.icon')
                        ->join(C('DB_PREFIX').'software ON '.C('DB_PREFIX').'software.id = '.C('DB_PREFIX').'download.soft_id')
                        ->group('soft_id')->order('download_count DESC, soft_id ASC')
                        ->limit($page->firstRow . ',' . $page->listRows)->select();

        $this->assign('download', $down_list);
        $this->assign('page', $show);
        $this->menu();
        $this->display();
    }

    //下载详情
    public function download_list() {
        $map['soft_id'] = $_GET['id'];

        $download = M('download');

        import("ORG.Util.Page"); //导入分页类

        $count = $download->where($map)->count();
        $page = new Page($count, 15);
        $show = $page->show();

        $download_list = $download->field(C('DB_PREFIX').'download.id, '.C('DB_PREFIX').'download.time, '.C('DB_PREFIX').'user.name')
                        ->join(C('DB_PREFIX').'user ON '.C('DB_PREFIX').'user.id = '.C('DB_PREFIX').'download.user_id')->where($map)
                        ->order(C('DB_PREFIX').'download.time DESC')->limit($page->firstRow . ',' . $page->listRows)->select();

        $soft = M('software');

        $arg['id'] = $map['soft_id'];
        $soft_msg = $soft->field('name, icon')->where($arg)->find();

        $this->assign('soft_msg', $soft_msg);
        $this->assign('download_list', $download_list);
        $this->assign('page', $show);
        $this->display();
    }

    //跳转列表
    public function jump() {
        $soft = M('software');
        $map['jumpurl'] = array('gt', 0);
        /* import("ORG.Util.Page"); //导入分页类

          $count = $soft->where($map)->count();
          $page = new Page($count, 15);
          $show = $page->show(); */

//        $soft_list = $soft->field('id, name, time, status, jumpurl, roll, roll_img')->where($map)->limit($page->firstRow . ',' . $page->listRows)->select();
        $soft_list = $soft->field('id, name, time, status, roll')->where($map)->select();

        $this->menu();
        $this->assign('soft', $soft_list);
        //$this->assign('page', $show);
        $this->display();
    }

    //增加跳转
    public function add_jump() {
        $this->menu();
        $this->display();
    }

    //增加跳转保存
    public function add_jump_save() {
        $map['name'] = $_POST['name'];
        $map['jumpurl'] = $_POST['url'];
        $map['roll_img'] = $_POST['img_src'];
        $map['roll'] = $_POST['roll'];
        $map['time'] = time();
        if (empty($map['jumpurl']) || empty($map['roll_img'])) {
            $this->ajaxReturn('', '跳转网址和滚动图片不能为空', 0);
        } else {
            $software = M('software');
            if (!$software->add($map)) {
                $this->ajaxReturn('', '增加跳转软件失败，请检查', 0);
            } else {
                F('Roll/list', NULL);   //清空滚动显示缓存
                $this->ajaxReturn('', '', 1);
            }
        }
    }

    //删除跳转
    public function del_jump() {
        $map['id'] = $_GET['id'];
        $map['jumpurl'] = '0';

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //编辑跳转
    public function edit_jump() {
        $map['id'] = intval($_GET['id']);
        $software = M('software');

        $softMsg = $software->field('id, name, roll_img, jumpurl')->where($map)->find();

        $this->assign('softMsg', $softMsg);
        $this->menu();
        $this->display();
    }

    //编辑跳转保存
    public function edit_jump_save() {
        $map['id'] = $_POST['id'];
        $map['name'] = $_POST['name'];
        $map['jumpurl'] = $_POST['url'];
        $map['roll_img'] = $_POST['img_src'];

        if (empty($map['jumpurl']) || empty($map['roll_img'])) {
            $this->ajaxReturn('', '跳转网址和滚动图片不能为空', 0);
        } else {
            $software = M('software');
            if (!$software->save($map)) {
                $this->ajaxReturn('', '修改跳转软件失败，请检查', 0);
            } else {
                F('Roll/list', NULL);   //清空滚动显示缓存
                $this->ajaxReturn('', '', 1);
            }
        }
    }

    //编辑跳转
//    public function jump_save() {
//        $map['id'] = $_POST['id'];
//        $map['jumpurl'] = $_POST['url'];
//
//        $soft = M('software');
//
//        if (!$soft->save($map)) {
//            $this->ajaxReturn('', '', 0);
//        } else {
//            F('Roll/list', NULL);   //清空滚动显示缓存
//            $this->ajaxReturn('', '', 1);
//        }
//    }
    //滚动列表
    public function roll() {
        $soft = M('software');
        $map['roll'] = 1;

        $soft_list = $soft->field('id,  name, time, status, roll_img, roll_order, jumpurl')->where($map)->order('roll_order ASC')->select();

        $this->menu();
        $this->assign('soft', $soft_list);
        $this->display();
    }

    //排序滚动
    public function ord_roll() {
        $map['roll'] = 1;
        $map['id'] = intval($_GET['id']);
        $map['roll_order'] = intval($_GET['ord']);

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    // 删除滚动
    public function del_roll() {
        $map['id'] = $_GET['id'];
        $map['roll'] = 0;

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //开启滚动
    public function open_roll() {
        $map['id'] = $_GET['id'];
        $map['roll'] = 1;

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    //编辑滚动
    public function save_roll() {
        $map['id'] = $_POST['id'];
        $map['roll_img'] = $_POST['img'];

        $soft = M('software');

        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            F('Roll/list', NULL);   //清空滚动显示缓存
            $this->ajaxReturn('', '', 1);
        }
    }

    /**
     * 头部推荐
     */
    public function show() {
        $soft = M('software');
        $map['apk_show'] = 1;

        $soft_list = $soft->field('id, icon, name, charge, time, status, roll_img')->where($map)->order('time DESC')->select();

        $this->menu();
        $this->assign('soft', $soft_list);
        $this->display();
    }

    /**
     * 删除头部推荐
     */
    public function del_show() {
        $map['id'] = intval($_GET['id']);
        $map['apk_show'] = 0;

        $software = M('software');

        if (!$software->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }


	//新版待审核列表
    public function news() {
        $map['status'] = 0;
		if (isset($_GET['order']) && $_GET['order'] != null) {
            switch ($_GET['order']) {
                case 1 : $order = 'id DESC';
                    break;
                case 2 : $order = 'id ASC';
                    break;
                case 3 : $order = 'time DESC';
                    break;
                case 4 : $order = 'time ASC';
                    break;
                default : $order = 'id ASC';
            }
        }else{
			$order = 'id DESC';
		}
		$soft = M('software_temp');
        import("ORG.Util.Page"); //导入分页类

        $count = $soft->where($map)->count();
        $page = new Page($count, 15);
        $show = $page->show();

        $soft_list = $soft->field()->where($map)->order($order)->limit($page->firstRow . ',' . $page->listRows)->select();

        $this->get_menu(); //获取分类类别
        $this->assign('soft', $soft_list);
        $this->assign('page', $show);
        $this->menu();
        $this->display();
    }



    //新版审核
    public function news_soft() {
        $temp['id'] = $_GET['id'];
		$soft_temp = M('software_temp');
		$soft_msg = $soft_temp->field('`soft_id`, `version`, `url`, `update_explain`, `md5_file`, `size`')->where($temp)->find();

		$map['id'] = $soft_msg['soft_id'];
		$map['version'] = $soft_msg['version'];
		$map['url'] = $soft_msg['url'];
		$map['update_explain'] = $soft_msg['update_explain'];
		$map['md5_file'] = $soft_msg['md5_file'];
		$map['size'] = $soft_msg['size'];
        $map['status'] = 1;
		$map['time'] = time();
        $soft = M('software');


        if (!$soft->save($map)) {
            $this->ajaxReturn('', '', 0);
        } else {
            $soft_temp->where('id='.$temp['id'])->delete();
			$this->ajaxReturn('', '', 1);
        }
    }


	//删除软件
    public function news_del_soft() {
        $map['id'] = $_GET['id'];
        $soft = M('software_temp');


        if (!$soft->where('id='.$map['id'])->delete()) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }

	//批量删除
    public function news_forbidden_softs() {
        $map['id'] = array('in', $_GET['id']);

        $soft = M('software_temp');

        if (!$soft->where($map)->delete()) {
            $this->ajaxReturn('', '', 0);
        } else {
            $this->ajaxReturn('', '', 1);
        }
    }



}