

-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_admin`
-- 

DROP TABLE IF EXISTS `bpi_admin`;
CREATE TABLE `bpi_admin` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL COMMENT '用户名',
  `pwd` varchar(255) NOT NULL COMMENT '用户密码',
  `flag` int(1) NOT NULL DEFAULT '0' COMMENT '标志是否为高级管理员',
  `status` int(1) NOT NULL DEFAULT '1' COMMENT '是否禁用',
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `pwd` (`pwd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_admin`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_comment`
-- 

DROP TABLE IF EXISTS `bpi_comment`;
CREATE TABLE `bpi_comment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '评论者ID',
  `content` varchar(255) NOT NULL COMMENT '评论内容',
  `time` int(11) NOT NULL,
  `soft_id` int(11) NOT NULL COMMENT '软件ID',
  `soft_version` int(11) NOT NULL COMMENT '软件版本',
  `score` decimal(2,1) NOT NULL COMMENT '分数',
  `up` int(11) NOT NULL DEFAULT '0' COMMENT '''顶'' 数',
  `down` int(11) NOT NULL DEFAULT '0' COMMENT '''降'' 数',
  PRIMARY KEY (`id`),
  KEY `soft_id` (`soft_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_comment`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_developer`
-- 

DROP TABLE IF EXISTS `bpi_developer`;
CREATE TABLE `bpi_developer` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL COMMENT '用户ID',
  `type` int(11) NOT NULL COMMENT '开发者类型',
  `name` varchar(25) NOT NULL COMMENT '开发者名称',
  `url` varchar(255) NOT NULL DEFAULT '0' COMMENT '网址',
  `email` varchar(255) NOT NULL DEFAULT '0' COMMENT '电子邮箱',
  `phone` varchar(255) NOT NULL DEFAULT '0' COMMENT '联系电话',
  `time` int(11) NOT NULL,
  `ip` varchar(15) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_developer`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_download`
-- 

DROP TABLE IF EXISTS `bpi_download`;
CREATE TABLE `bpi_download` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '下载者ID',
  `time` int(11) NOT NULL,
  `soft_id` int(11) NOT NULL COMMENT '软件ID',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `soft_id` (`soft_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_download`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_menu`
-- 

DROP TABLE IF EXISTS `bpi_menu`;
CREATE TABLE `bpi_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '类别ID',
  `name` varchar(255) NOT NULL COMMENT '类别名称',
  `title` varchar(255) NOT NULL COMMENT '专题类别中子标题',
  `pid` int(11) NOT NULL COMMENT '父类别ID',
  `path` varchar(255) NOT NULL COMMENT '路径',
  `extend` int(1) NOT NULL DEFAULT '0' COMMENT '是否支持自动扩展',
  `explain` varchar(255) NOT NULL COMMENT '类别简介',
  `status` int(1) NOT NULL DEFAULT '0' COMMENT '类别状态',
  `icon` varchar(255) NOT NULL COMMENT '列表ICON',
  `recommend` int(1) NOT NULL DEFAULT '0' COMMENT '专题 类别中是否推荐',
  `show` int(1) NOT NULL DEFAULT '0' COMMENT '专题 类别中是否展示',
  `picture` varchar(255) NOT NULL COMMENT '专题展示中的展示图片',
  `keyword` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_menu`
-- 



-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_passageway`
-- 

DROP TABLE IF EXISTS `bpi_passageway`;
CREATE TABLE `bpi_passageway` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '通道名称',
  `url` varchar(255) NOT NULL COMMENT '通道链接URL',
  `status` int(1) NOT NULL DEFAULT '1' COMMENT '通道状态',
  `type` int(1) NOT NULL COMMENT '通道类型 1为电信 0为其他',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_passageway`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_recommend`
-- 

DROP TABLE IF EXISTS `bpi_recommend`;
CREATE TABLE `bpi_recommend` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '推荐者ID',
  `soft_id` int(11) NOT NULL COMMENT '推荐软件ID',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `soft_id` (`soft_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_recommend`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_setting`
-- 

DROP TABLE IF EXISTS `bpi_setting`;
CREATE TABLE `bpi_setting` (
  `name` varchar(25) NOT NULL COMMENT '设置名称',
  `data` varchar(255) NOT NULL DEFAULT '' COMMENT '网址设置属性'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_setting`
-- 



-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_soft_backup`
-- 

DROP TABLE IF EXISTS `bpi_soft_backup`;
CREATE TABLE `bpi_soft_backup` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '用户ID',
  `soft_name` varchar(255) NOT NULL COMMENT '软件名字',
  `soft_version` varchar(128) NOT NULL COMMENT '软件版本',
  `soft_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `soft_id` (`soft_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_soft_backup`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_soft_belong`
-- 

DROP TABLE IF EXISTS `bpi_soft_belong`;
CREATE TABLE `bpi_soft_belong` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `soft_id` int(11) NOT NULL COMMENT '软件ID',
  `menu_id` int(11) NOT NULL COMMENT '类别ID',
  `menu_child_id` int(11) NOT NULL COMMENT '类别子ID',
  PRIMARY KEY (`id`),
  KEY `soft_id` (`soft_id`),
  KEY `menu_child_id` (`menu_child_id`),
  KEY `menu_id` (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_soft_belong`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_soft_favorites`
-- 

DROP TABLE IF EXISTS `bpi_soft_favorites`;
CREATE TABLE `bpi_soft_favorites` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '收藏人ID',
  `soft_id` int(11) NOT NULL COMMENT '软件ID',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `soft_id` (`soft_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_soft_favorites`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_soft_version`
-- 

DROP TABLE IF EXISTS `bpi_soft_version`;
CREATE TABLE `bpi_soft_version` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `soft_id` int(11) NOT NULL COMMENT '软件ID',
  `soft_version` varchar(128) NOT NULL COMMENT '软件ID',
  `update_time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `soft_id` (`soft_id`),
  KEY `update_time` (`update_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_soft_version`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_software`
-- 

DROP TABLE IF EXISTS `bpi_software`;
CREATE TABLE `bpi_software` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '软件名字',
  `mobile_name` varchar(255) NOT NULL,
  `charge` int(1) NOT NULL DEFAULT '0' COMMENT '是否收费 0 否 ， 1 是',
  `version` varchar(255) NOT NULL,
  `size` varchar(128) NOT NULL,
  `language` varchar(128) NOT NULL DEFAULT '中文' COMMENT '软件语言',
  `time` int(11) NOT NULL,
  `explain` text NOT NULL,
  `update_explain` text NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `picture` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `passageway` varchar(255) NOT NULL,
  `suitsdk` varchar(255) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '1' COMMENT '软件状态',
  `recommend` int(1) NOT NULL DEFAULT '0' COMMENT '是否推荐',
  `recommend_order` int(11) NOT NULL DEFAULT '999999',
  `jumpurl` varchar(255) NOT NULL DEFAULT '0',
  `roll` int(1) NOT NULL DEFAULT '0' COMMENT '是否滚动显示',
  `roll_img` varchar(255) DEFAULT '' COMMENT '滚动显示时图片的URL',
  `roll_order` int(2) NOT NULL DEFAULT '999999',
  `apk_show` int(1) NOT NULL DEFAULT '0' COMMENT '是否在客户端中推荐（头部推荐）',
  `upload_uid` int(11) NOT NULL DEFAULT '0' COMMENT '上传者ID，管理员上传时为0',
  `md5_file` varchar(255) NOT NULL,
  `qr_url` varchar(255) NOT NULL DEFAULT '' COMMENT '二维码地址',
  `hits` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `upload_uid` (`upload_uid`),
  KEY `jumpurl` (`jumpurl`),
  KEY `recommend` (`recommend`),
  KEY `apk_show` (`apk_show`),
  KEY `roll` (`roll`),
  KEY `hits` (`hits`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_software`
-- 


-- --------------------------------------------------------



-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_software`
-- 

DROP TABLE IF EXISTS `bpi_software_temp`;
CREATE TABLE `bpi_software_temp` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `soft_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL COMMENT '软件名字',
  `mobile_name` varchar(255) NOT NULL,
  `charge` int(1) NOT NULL DEFAULT '0' COMMENT '是否收费 0 否 ， 1 是',
  `version` varchar(255) NOT NULL,
  `size` varchar(128) NOT NULL,
  `language` varchar(128) NOT NULL DEFAULT '中文' COMMENT '软件语言',
  `time` int(11) NOT NULL,
  `explain` text NOT NULL,
  `update_explain` text NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `picture` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `passageway` varchar(255) NOT NULL,
  `suitsdk` varchar(255) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '1' COMMENT '软件状态',
  `recommend` int(1) NOT NULL DEFAULT '0' COMMENT '是否推荐',
  `recommend_order` int(11) NOT NULL DEFAULT '999999',
  `jumpurl` varchar(255) NOT NULL DEFAULT '0',
  `roll` int(1) NOT NULL DEFAULT '0' COMMENT '是否滚动显示',
  `roll_img` varchar(255) DEFAULT '' COMMENT '滚动显示时图片的URL',
  `roll_order` int(2) NOT NULL DEFAULT '999999',
  `apk_show` int(1) NOT NULL DEFAULT '0' COMMENT '是否在客户端中推荐（头部推荐）',
  `upload_uid` int(11) NOT NULL DEFAULT '0' COMMENT '上传者ID，管理员上传时为0',
  `md5_file` varchar(255) NOT NULL,
  `qr_url` varchar(255) NOT NULL DEFAULT '' COMMENT '二维码地址',
  `hits` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `upload_uid` (`upload_uid`),
  KEY `jumpurl` (`jumpurl`),
  KEY `recommend` (`recommend`),
  KEY `apk_show` (`apk_show`),
  KEY `roll` (`roll`),
  KEY `hits` (`hits`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_software_temp`
-- 


-- --------------------------------------------------------

-- 
-- 表的结构 `bpi_user`
-- 

DROP TABLE IF EXISTS `bpi_user`;
CREATE TABLE `bpi_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '帐号',
  `pwd` varchar(255) NOT NULL COMMENT '密码',
  `email` varchar(255) NOT NULL COMMENT '用户邮箱',
  `picture` varchar(255) NOT NULL,
  `reg_date` int(11) NOT NULL,
  `user_status` int(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `bbs_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 
-- 导出表中的数据 `bpi_user`
-- 

