<?php
/** check login */
function check_user_login($data) {
	global $DB, $usertypes;
	
	list($user_id, $user_pass, $login_count) = $data ? explode('|', authcode($data, 'DECODE')) : array('', '', '');
	$user_id = intval($user_id);
	$user_pass = addslashes($user_pass);
	$userinfo = array();
	if ($user_id && $user_pass) {
		$user = $DB->fetch_one("SELECT user_id, user_type, user_email, user_pass, nick_name, user_qq, user_score, site_count, user_status, join_time, login_time, login_ip, login_count FROM ".$DB->table('users')." WHERE user_id=$user_id");
		if ($user['user_pass'] == $user_pass && $user['login_count'] == $login_count) {
			$userinfo = array(
				'user_id' => $user['user_id'],
				'user_type' => $usertypes[$user['user_type']],
				'user_email' => $user['user_email'],
				'nick_name' => $user['nick_name'],
				'user_qq' => $user['user_qq'],
				'user_score' => $user['user_score'],
				'site_count' => $user['site_count'],
				'user_status' => $user['user_status'],
				'join_time' => date('Y-m-d H:i:s', $user['join_time']),
				'login_time' => date('Y-m-d H:i:s', $user['login_time']),
				'login_ip' => long2ip($user['login_ip']),
				'login_count' => $user['login_count'],
			);
		}
	}
	
	return $userinfo;
}

/** user list */
function get_user_list($where = 1, $field = 'join_time', $order = 'DESC', $start = 0, $pagesize = 0) {
	global $DB;
	
	$sql = "SELECT user_id, user_type, user_email, nick_name, user_qq, join_time, user_status FROM ".$DB->table('users')." WHERE $where ORDER BY $field $order LIMIT $start, $pagesize";
	$query = $DB->query($sql);
	$users = array();
	while ($row = $DB->fetch_array($query)) {
		$users[] = $row;
	}
	unset($row);
	$DB->free_result($query);
		
	return $users;
}
	
/** one user */
function get_one_user($user_id) {
	global $DB;
	
	$user = $DB->fetch_one("SELECT user_id, user_type, user_email, nick_name, user_qq, join_time, user_status FROM ".$DB->table('users')." WHERE user_id=$user_id LIMIT 1");
	
	return $user;
}

/** user option */
function get_usertype_option($type = 'member') {
	global $usertypes;
	
	foreach ($usertypes as $key => $val) {
		$optstr .= '<option value="'.$key.'"';
		if ($type == $key) $optstr .= ' selected';
		$optstr .= '>'.$val.'</option>';
	}
	
	return $optstr;
}
?>