<?php
	require APPMODULES_DIR.'default'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'CommonClass.php';
	require APPMODULES_DIR.'default'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'HotelClass.php';
	require APPMODULES_DIR.'default'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'PageUrlClass.php';
	require APPMODULES_DIR.'default'.DIRECTORY_SEPARATOR.'models'.DIRECTORY_SEPARATOR.'SpecialClass.php';
    class DefaultCommonController extends Zend_Controller_Action
    {	
		//对象属性
		public $Request;
		public $Model;
		public $Handle;
		public $CommonHelper;
		public $HotelHelper;
		public $SpecialHelper;
		public $PageUrler;
		
        function init()
        {
        	if(Web_Issetup=='0'){
				header("Location: " . Web_Webpath . 'index.php/install/index');
			}
        	//实例化相关对象
			$this->Request = $this->getRequest();
        	$this->Model = new ModelClass();
			$this->Handle = new HandleClass();
		 	$this->CommonHelper = new CommonClass();
			$this->HotelHelper = new HotelClass();
			$this->SpecialHelper = new SpecialClass();
			$this->PageUrler = new PageUrlClass();
			
			//固定值部分
			$this->view->Supporter = ModelClass::$Supporter;
			$this->view->SupporterUrl = ModelClass::$SupporterUrl;
			$this->view->Copyright = ModelClass::$Copyright;
			$this->view->CopyrightUrl = ModelClass::$CopyrightUrl;
			$this->view->License =ModelClass::$License;
			$this->view->WebPath = Web_Webpath;
			$this->view->WebName = ModelClass::$WebName;
			$this->view->LogoUrl = ModelClass::$LogoUrl;
			
			//入住离开时间
			session_save_path(APPMODULES_DIR.'default'.DIRECTORY_SEPARATOR.'tmp'.DIRECTORY_SEPARATOR);
			session_start();
			
			if($this->Request->getParam('intime')!=''){
				$_SESSION['InTime'] = $this->Request->getParam('intime');
			}
			elseif($_SESSION['InTime']==''){
				$_SESSION['InTime'] = date("Y-m-d",strtotime("+1 day"));
			}
			$this->Model->InTime = $_SESSION['InTime'];
			
			if($this->Request->getParam('outtime')!=''){
				$_SESSION['OutTime'] = $this->Request->getParam('outtime');
			}
			elseif($_SESSION['OutTime']==''){
				$_SESSION['OutTime'] = date("Y-m-d",strtotime("+2 day"));
			}
			$this->Model->OutTime = $_SESSION['OutTime'];
			
			//城市链接
			$this->view->HListUrl_City = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid'));
        
			//导航栏链接
			$this->view->IndexPageUrl = PageUrlClass::$IndexPageUrl;
			$this->view->HelpPageUrl = PageUrlClass::$HelpPageUrl;
			$this->view->ChainsPageUrl = PageUrlClass::$ChainsPageUrl;
			$this->view->CitiesPageUrl = PageUrlClass::$CitiesPageUrl;
			$this->view->SpecialPageUrl = PageUrlClass::$SpecialPageUrl;
			
			//获取底部城市链接
			$this->view->SystemCities = $this->CommonHelper->GetSystemCities();	
        }
        
		//生成模块参数
		public function CreateMedules($Page){		
			$Flag = 'page_'.$Page.'_layout';
			if(!$LayoutStr = $this->Handle->GetCache($Flag)){
				$Arguments = array('agentid'=>Web_Agentid,'agentmd'=>Web_Agentmd,'page'=>$Page);
				$LayoutStr = $this->Handle->SoapAccess('GetPageLayout',$Arguments,'GetPageLayoutResult');
				$this->Handle->CreateCache($Flag,$LayoutStr);
			}
			$LayoutArray = explode(',',$LayoutStr);
			$Layout = array();
			foreach($LayoutArray as $val){
				$Item = explode('_',$val);
				array_push($Layout,$Item);
			}
			//根据模块赋值给变量并显示于页面
			foreach($Layout as $Item){
				$area = 'area_'.$Item[0];
				$module = 'module_'.$Item[0];
				$this->view->$area = $Item[1];
				$this->view->$module = 'module_'.$Item[2];
				$this->GetModule($Item[1],$Item[2]);
			}
		}
		
		//获取对应模块
		public function GetModule($Name,$Num){
			switch($Name){
				case 'article' :
					switch($Num) {
						case '401' : 
							break;
					}	
					break;
				case 'chain' :
					switch($Num) {
						case '201' : //主城市连锁品牌（跳转到相关酒店列表页面）
							if(!isset($this->view->CityChains)){
								$this->Model->Cid = ModelClass::$MainCityId;
								$this->view->CityChains = $this->CommonHelper->GetCityChains($this->Model);
							}
							if(!isset($this->view->HListUrl_Chain)){
								$this->view->HListUrl_Chain = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{chain}'=>'Chain'));
							}
							break;
						case '202' : //系统默认连锁品牌（跳转到单个连锁品牌页面）
							if(!isset($this->view->CityChains)){
								$this->Model->Cid = 0;
								$this->view->CityChains = $this->CommonHelper->GetCityChains($this->Model);
							}
							if(!isset($this->view->ChainPageUrl)){
								$this->view->ChainPageUrl = $this->Handle->BatchReplace(PageUrlClass::$ChainPageUrl,array('{chainid}'=>'Chainid'));
							}
							break;
						case '301' : //主城市连锁品牌（跳转到相关酒店列表页面）
							if(!isset($this->view->CityChains)){
								$this->Model->Cid = ModelClass::$MainCityId;
								$this->view->CityChains = $this->CommonHelper->GetCityChains($this->Model);
							}
							if(!isset($this->view->HListUrl_Chain)){
								$this->view->HListUrl_Chain = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{chain}'=>'Chain'));
							}
							break;
						case '302' : //系统默认连锁品牌（跳转到单个连锁品牌页面）						
							if(!isset($this->view->CityChains)){
								$this->Model->Cid = 0;
								$this->view->CityChains = $this->CommonHelper->GetCityChains($this->Model);
							}
							if(!isset($this->view->ChainPageUrl)){
								$this->view->ChainPageUrl = $this->Handle->BatchReplace(PageUrlClass::$ChainPageUrl,array('{chainid}'=>'Chainid'));		
							}							
							break;
					}
					break;
				case 'city' :
					switch($Num) {
						case '101' : //热门城市
							if(!isset($this->view->HotCities)){
								$this->Model->Num = 20;
								$this->view->HotCities = $this->CommonHelper->GetHotCities($this->Model);
							}
							break;
						case '201' : //热门城市
							if(!isset($this->view->HotCities)){
								$this->Model->Num = 20;
								$this->view->HotCities = $this->CommonHelper->GetHotCities($this->Model);
							}
							break;
						case '202' : //连锁品牌下的城市
							if(!isset($this->view->ChainCity)){
								$this->Model->ChainId = $this->Request->getParam('chainid');
								$this->view->ChainCity = $this->SpecialHelper->GetChainCity($this->Model);
							}
							if(!isset($this->view->HListUrl_ChainCity)){
								$this->view->HListUrl_ChainCity = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{chain}'=>$this->Model->ChainId));
							}
							break;
					}	
					break;
				case 'comment' :
					switch($Num) {
						case '201' : 
							if(!isset($this->view->LatestComments)){
								$LatestComments = $this->CommonHelper->GetLatestComments();
								$Rand_keys = array_rand($LatestComments,2);
								$this->view->LatestComments = array($LatestComments[$Rand_keys[0]],$LatestComments[$Rand_keys[1]]);
							}
							if(!isset($this->view->HViewPageUrl)){
								$this->view->HViewPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HViewPageUrl);
							}
							break;
						case '401' :
							if(!isset($this->view->HotelComments)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$this->view->HotelComments = $this->HotelHelper->GetHotelComments($this->Model);
							}
							break;	
					}
					break;
				case 'district':
					switch($Num) {
						case '201' : 
							$Cid = $this->Request->getParam('cid');
							$this->view->Cid = $Cid;
							if(!isset($this->view->CityAreas)){
								$this->Model->Cid = $Cid;
								$this->Model->Num = 18;
								$this->view->CityAreas = $this->CommonHelper->GetCityAreas($this->Model);
							}
							if(!isset($this->view->HListUrl_Addres)){
								$this->view->HListUrl_Address = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{address}'=>'Address'));
							}
							break;
					}
					break;
				case 'flink':
					switch($Num) {
						case '501' :
							$this->view->PicFlinks =$this->CommonHelper->GetPicFlinks();
							$this->view->WordFlinks = $this->CommonHelper->GetWordFlinks();
							break;
					}	
				break;
				case 'hotel':
					switch($Num) {
						case '201' :
							$Hid = $this->Request->getParam('hid');
							if(isset($Hid)){ //酒店详细页面
								if(!isset($this->view->HotelView)){
									$this->Model->Hid = $Hid;
									$HotelView = $this->HotelHelper->GetHotelView($this->Model);
									$this->view->HotelView = $HotelView;
								}else{
									$HotelView = $this->view->HotelView;
								}
								if(!isset($this->view->HViewPageUrl)){
									$this->view->HViewPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HViewPageUrl);
								}
								
					        	if(empty($_COOKIE['HistoryHotels'])){ //当前是第一条记录
					        		setcookie('HistoryHotels',$HotelView['id'].','.$HotelView['hotelname'].','.$HotelView['lowprice'],time()+3600,Web_Webpath);
					        	}else{
					        		$HistoryHotels = $_COOKIE['HistoryHotels'];
					        		if(strpos($HistoryHotels, $HotelView['id'].','.$HotelView['hotelname'].','.$HotelView['lowprice']) !== false){	
					        		}else{
					        			setcookie('HistoryHotels',$HotelView['id'].','.$HotelView['hotelname'].','.$HotelView['lowprice'].'#'.$HistoryHotels,time()+3600,Web_Webpath);
					        		}
					        	}
							}else{ //其他页面
								if(empty($_COOKIE['HistoryHotels'])){//历史记录为空
					        		setcookie('HistoryHotels','',time()+3600,Web_Webpath);
					        	}
							}
							$HistoryHotel = array();
							if(!empty($_COOKIE['HistoryHotels'])){
								$HistoryHotelsArray = explode('#', $_COOKIE['HistoryHotels']);
								
								foreach($HistoryHotelsArray as $HistoryHotelsval){
									$HistoryHotelval = explode(',', $HistoryHotelsval);
									array_push($HistoryHotel, array('hid'=>$HistoryHotelval[0],'hname'=>$HistoryHotelval[1],'lowprice'=>$HistoryHotelval[2]));
								}
							}
				        	$this->view->HistoryHotels = $HistoryHotel;
							break;
						case '202' :
								if(!isset($this->view->HotelView)){
									$this->Model->Hid = $this->Request->getParam('hid');
									$HotelView = $this->HotelHelper->GetHotelView($this->Model);
									$this->view->HotelView = $HotelView;
								}else{
									$HotelView = $this->view->HotelView;
								}
								$this->Model->Cid = $HotelView['cid'];
								$this->Model->Hid = $HotelView['id'];
								$this->Model->Pos = $HotelView['hotelpos'];
								$this->Model->LowPrice = $HotelView['lowprice'];
								$this->view->NearbyHotels = $this->CommonHelper->GetNearbyHotels($this->Model);
								if(!isset($this->view->HViewPageUrl)){
									$this->view->HViewPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HViewPageUrl);
								}
							break;
						case '401' :
							if(!isset($this->view->RHotCities)){
								$this->Model->Num = 13;
								$this->view->RHotCities = $this->CommonHelper->GetHotCities($this->Model);
							}
							if(!isset($this->view->RecommonedHotels)){
								$this->Model->Cid = ModelClass::$MainCityId;
								$this->view->RecommonedHotels = $this->CommonHelper->GetRecommonedHotels($this->Model);
							}
							if(!isset($this->view->HViewPageUrl)){
								$this->view->HViewPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HViewPageUrl);
							}
							break;
						case '402' : 
							$this->view->MainCityName = ModelClass::$MainCityName;
							if(!isset($this->view->RecommonedHotels)){
								$this->Model->Cid = ModelClass::$MainCityId;
								$this->view->RecommonedHotels = $this->CommonHelper->GetRecommonedHotels($this->Model);
							}
							if(!isset($this->view->HViewPageUrl)){
								$this->view->HViewPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HViewPageUrl);
							}
							break;
						case '403' :
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
								$this->view->HotelView = $HotelView;
							}else{
								$HotelView = $this->view->HotelView;
							}
        					$Star = $HotelView['xingji'];
							if(intval($Star)>0 && intval($Star)<7){
								if(!isset($this->view->StarName)){
									$this->Model->StarId = $Star;
									$this->view->StarName = $this->CommonHelper->GetStarNameById($this->Model);
								}
								if(!isset($this->view->HListUrl_Star)){
									$this->view->HListUrl_Star = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{star}'=>'Star'));
								}
							}
							break;
						case '404' :
							$Hid = $this->Request->getParam('hid');
							$this->view->Hid = $Hid;
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $Hid;
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
								$this->view->HotelView = $HotelView;
							}
							if(!isset($this->view->HViewPageUrl)){
								$this->view->HViewPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HViewPageUrl);
							}
							if(!isset($this->view->HCommentPageUrl)){
								$this->view->HCommentPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HCommentPageUrl);
							}
							if(!isset($this->view->HPicturePageUrl)){
								$this->view->HPicturePageUrl = str_replace('{hid}','Hid',PageUrlClass::$HPicturePageUrl);
							}
							if(!isset($this->view->HVideoPageUrl)){
								$this->view->HVideoPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HVideoPageUrl);
							}
							if(!isset($this->view->HTransportPageUrl)){
								$this->view->HTransportPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HTransportPageUrl);
							}
							if(!isset($this->view->HAroundsPageUrl)){
								$this->view->HAroundsPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HAroundsPageUrl);
							}
							if(!isset($this->view->HQuestionPageUrl)){
								$this->view->HQuestionPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HQuestionPageUrl);
							}
							break;
						case '405' :
							$Hid = $this->Request->getParam('hid');
							$this->view->Hid = $Hid;
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $Hid;
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
								$this->view->HotelView = $HotelView;
							}else{
								$HotelView = $this->view->HotelView;
							}
							if(!isset($this->view->HotelPicture)){
								$this->Model->HInfo = $HotelView['pic'];
								$HotelPicture = $this->HotelHelper->GetHotelPicture($this->Model);
								if(count($HotelPicture)>0){
									$this->view->HotelPicture = $HotelPicture[0];
								}
							}
							$this->Model->HP = $HotelView['haoping'];
							$this->Model->ZP = $HotelView['zhongping'];
							$this->Model->CP = $HotelView['chaping'];
							if(!isset($this->view->HotelGoodRate)){
								$this->view->HotelGoodRate = $this->HotelHelper->GetHotelGoodRate($this->Model);
							}
							if(!isset($this->view->HotelCommetCount)){
								$this->view->HotelCommetCount = $this->HotelHelper->GetHotelCommetCount($this->Model);
							}
							if(!isset($this->view->HCommentPageUrl)){
								$this->view->HCommentPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HCommentPageUrl);
							}
							if(!isset($this->view->HPicturePageUrl)){
								$this->view->HPicturePageUrl = str_replace('{hid}','Hid',PageUrlClass::$HPicturePageUrl);
							}
							if(!isset($this->view->HTransportPageUrl)){
								$this->view->HTransportPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HTransportPageUrl);
							}
							
							if(!isset($this->view->HotelPos_x)){
								$HotelPos = explode(',',$HotelView['hotelpos']);
								$this->view->HotelPos_x = str_replace('(','',$HotelPos[0]);
								$this->view->HotelPos_y = str_replace(')','',$HotelPos[1]);
							}
							break;
						case '406' :
							break;
						case '407' :
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
								$this->view->HotelView = $HotelView;
							}else{
								$HotelView = $this->view->HotelView;
							}
							if(!isset($this->view->HotelBaseInfo)){
								$this->Model->HInfo = $HotelView['shijian'];
								$this->view->HotelBaseInfo = $this->HotelHelper->GetHotelBaseInfo($this->Model);
							}
							if(!isset($this->view->HotelGoodRate)){
								$this->Model->HP = $HotelView['haoping'];
								$this->Model->ZP = $HotelView['zhongping'];
								$this->Model->CP = $HotelView['chaping'];
								$this->view->HotelGoodRate = $this->HotelHelper->GetHotelGoodRate($this->Model);
							}
							if(!isset($this->view->HotelImpressions)){
								$this->Model->HInfo = $HotelView['yixiang'];
								$this->view->HotelImpressions = $this->HotelHelper->GetHotelImpressions($this->Model);
							}
							break;
						case '408' :
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
								$this->view->HotelView = $HotelView;
							}else{
								$HotelView = $this->view->HotelView;
							}
							$this->view->Cid = $HotelView['cid'];
							if(!isset($this->view->HListUrl_Address)){
								$this->view->HListUrl_Address = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{address}'=>'Address'));
							}
							if(!isset($this->view->HotelAreaName)){
								$this->Model->HAreaId = $HotelView['jdwz_id'];
								$this->view->HotelAreaName = $this->CommonHelper->GetAreaNameById($this->Model);
							}
							if(!isset($this->view->HotelToBuilding)){
								$HotelToBuilding = '';
								if(strpos($HotelView['building'],'@')===false){
									$HotelToBuilding = str_replace('【','<br />【',str_replace('-至','"<br />-至',str_replace('-距','<br />-距',$HotelView['building'])));
								}else{
									$buildings = explode('@',$HotelView['building']);
									for($i=1; $i<count($buildings);$i++){
										$BuildingInfo = explode('|', $buildings[$i]);
										$HotelToBuilding .='-距离'.$BuildingInfo[0].'约'.$BuildingInfo[2].'<br />';
									}
								}
								$this->view->HotelToBuilding = $HotelToBuilding;
							}
							break;
						case '409' :
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
								$this->view->HotelView = $HotelView;
							}else{
								$HotelView = $this->view->HotelView;
							}
							if(!isset($this->view->PayCards)){
								$this->Model->HInfo = $HotelView['yhang'];
								$this->view->PayCards = $this->HotelHelper->GetHotelPayCard($this->Model);
							}
							break;
						case '410' :
							if(!isset($this->view->HotelPictures)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$this->view->HotelPictures = $this->HotelHelper->GetHotelPictures($this->Model);
							}
							break;
						case '411' :
							$Hid = $this->Request->getParam('hid');
							$this->view->Hid = $Hid;						
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $Hid;
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
								$this->view->HotelView = $HotelView;
							}else{
								$HotelView = $this->view->HotelView;
							}
							$this->view->Cid = $HotelView['cid'];
							if(!isset($this->view->HotelPos_x)){
								$HotelPos = explode(',',$HotelView['hotelpos']);
								$this->view->HotelPos_x = str_replace('(','',$HotelPos[0]);
								$this->view->HotelPos_y = str_replace(')','',$HotelPos[1]);
							}
							break;
						case '412' : //某单个周边环境
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
							}else{
								$HotelView = $this->view->HotelView;
							}
							if(!isset($this->view->HotelAround)){
								$this->Model->Cid = $HotelView['cid'];
								$this->Model->Pos = $HotelView['hotelpos'];
								$this->Model->AroundType = $this->Request->getParam('tid');
								$this->Model->Num = 50;
								$HotelAround = $this->HotelHelper->GetHotelAround($this->Model);
								$this->view->HotelAround = $HotelAround;
								$this->Model->HAroundName = $HotelAround['name'];
							}	
							if(!isset($this->view->HListUrl_Special)){		
								$this->view->HListUrl_Special = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{keyword}'=>'Keyword'));
							}
							break;
						case '413' : //周边环境（所有类目）
							if(!isset($this->view->HotelAroundPageUrl)){
								$this->view->Hid = $this->Request->getParam('hid');
								$this->view->HAroundPageUrl = str_replace('{hid}','Hid',str_replace('{tid}','Tid',PageUrlClass::$HAroundPageUrl));
							}
							break;
						case '414' : //附近景点
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
								$this->view->HotelView = $HotelView;
							}else{
								$HotelView = $this->view->HotelView;
							}
							if(!isset($this->view->HotelAround_3)){
								$this->Model->Cid = $HotelView['cid'];
								$this->Model->Pos = $HotelView['hotelpos'];
								$this->Model->Num = 0;
								$this->Model->AroundType = 3;
								$this->view->HotelAround_3 = $this->HotelHelper->GetHotelAround($this->Model);
							}
							if(!isset($this->view->HListUrl_Special)){		
								$this->view->HListUrl_Special = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{keyword}'=>'Keyword'));
							}
							break;
						case '415' : //附近茶馆
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
								$this->view->HotelView = $HotelView;
							}else{
								$HotelView = $this->view->HotelView;
							}
							if(!isset($this->view->HotelAround_18)){
								$this->Model->Cid = $HotelView['cid'];
								$this->Model->Pos = $HotelView['hotelpos'];
								$this->Model->Num = 0;
								$this->Model->AroundType = 18;
								$this->view->HotelAround_18 = $this->HotelHelper->GetHotelAround($this->Model);
							}
							if(!isset($this->view->HListUrl_Special)){		
								$this->view->HListUrl_Special = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{keyword}'=>'Keyword'));
							}
							break;	
						case '470' :
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
							}else{
								$HotelView = $this->view->HotelView;
							}
							$this->view->VidioUrl = $HotelView['vedio'];
							break;
						case '471' :
							$Hid = $this->Request->getParam('hid');
							$this->view->Hid = $Hid;
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $Hid;
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
							}else{
								$HotelView = $this->view->HotelView;
							}
							if(!isset($this->view->VideoHotels)){
								$this->Model->Cid = $HotelView['cid'];
								$this->view->VideoHotels = $this->HotelHelper->GetCityVideoHotels($this->Model);
							}
							if(!isset($this->view->HVideoPageUrl)){
								$this->view->HVideoPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HVideoPageUrl);
							}
							break;
						case '472' : //全景图
							break;
						case '473' :
							$Hid = $this->Request->getParam('hid');
							$this->view->Hid = $Hid;
							if(!isset($this->view->HotelView)){
								$this->Model->Hid = $Hid;
								$HotelView = $this->HotelHelper->GetHotelView($this->Model);
							}else{
								$HotelView = $this->view->HotelView;
							}
							if(!isset($this->view->SciHotels)){
								$this->Model->Cid = $HotelView['cid'];
								$this->view->SciHotels = $this->HotelHelper->GetCitySciHotels($this->Model);
							}
							if(!isset($this->view->HViewPageUrl)){
								$this->view->HViewPageUrl = str_replace('{hid}','Hid',str_replace('{page}','Page',PageUrlClass::$HViewPageUrl));
							}
							break;
					}	
					break;
				case 'landmark':
					switch($Num) {
						case '201' : 
							$Cid = $this->Request->getParam('cid');
							$this->view->Cid = $Cid;
							$this->Model->Cid = $Cid;
							$this->Model->Num = 20;
							if(!isset($this->view->CityName)){
								$this->view->CityName = $this->CommonHelper->GetCityNameById($this->Model);
							}
							if(!isset($this->view->AirPortLandMark)){
								$this->view->AirPortLandMark = $this->SpecialHelper->GetAirportOfCity($this->Model);
							}
							if(!isset($this->view->StationLandMark)){
								$this->view->StationLandMark = $this->SpecialHelper->GetStationOfCity($this->Model);
							}
							if(!isset($this->view->MetroLandMark)){	
								if(in_array($Cid,array('20','21','27','30','38','40','42','44','75','81'))){
									$this->view->MetroLandMark = $this->SpecialHelper->GetMetroOfCity($this->Model);
								}else{
									$this->view->MetroLandMark = array();
								}
							}
							if(!isset($this->view->SchoolLandMark)){
								$this->view->SchoolLandMark = $this->SpecialHelper->GetSchoolOfCity($this->Model);
							}
							if(!isset($this->view->AttractionLandMark)){
								$this->view->AttractionLandMark = $this->SpecialHelper->GetAttractionOfCity($this->Model);
							}
							if(!isset($this->view->HListUrl_Special)){		
								$this->view->HListUrl_Special = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{keyword}'=>'Keyword'));
							}
							break;
					}	
					break;
				case 'order' : 
					switch($Num) {
						case '201' : 
							if(!isset($this->view->LatestOrders)){
								$LatestOrders = $this->CommonHelper->GetLatestOrders();
								$Rand_keys = array_rand($LatestOrders,3);
								$this->view->LatestOrders = array($LatestOrders[$Rand_keys[0]],$LatestOrders[$Rand_keys[1]],$LatestOrders[$Rand_keys[2]]);
							}
							if(!isset($this->view->HViewPageUrl)){
								$this->view->HViewPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HViewPageUrl);
							}
							break;
					}
					break;
				case 'others':
					switch($Num) {
						case '100' : 		
							break;
						case '200' : 		
							break;
						case '201' : 		
							break;
						case '202' : 		
							break;
						case '203' : 		
							break;
						case '204' : 		
							break;
						case '205' : 
							$this->view->Hid = $this->Request->getParam('hid');
							if(!isset($this->view->HQuestionPageUrl)){
								$this->view->HQuestionPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HQuestionPageUrl);	
							}
							break;
						case '300' : 		
							break;
						case '400' : 
							break;
						case '500' : 		
							break;
					}
				break;
				case 'question':
					switch($Num) {
						case '201' : 
							if(!isset($this->view->LatestAsks)){
								$LatestAsks = $this->CommonHelper->GetLatestAsks();
								$Rand_keys = array_rand($LatestAsks,2);
								$this->view->LatestAsks = array($LatestAsks[$Rand_keys[0]],$LatestAsks[$Rand_keys[1]]);	
							}		
							break;
						case '401' :
							break;
						case '402' :
							if(!isset($this->view->HotelAsks)){
								$this->Model->Hid = $this->Request->getParam('hid');
								$this->view->HotelAsks = $this->HotelHelper->GetHotelAsks($this->Model);
							}
							break;
					}	
					break;
				case 'quicksearch':
					switch($Num) {
						case '401' :
							$Cid = ModelClass::$MainCityId;
							$this->view->Cid = $Cid;
							$this->Model->Cid = $Cid;
							$this->Model->Num = 13;
							if(!isset($this->view->QHotCities)){
								$this->view->QHotCities = $this->CommonHelper->GetHotCities($this->Model);
							}
							if(!isset($this->view->QCityChains)){
								$this->view->QCityChains = $this->CommonHelper->GetCityChains($this->Model);
							}
							if(!isset($this->view->QCityAreas)){
								$this->Model->Num = 12;
								$this->view->QCityAreas = $this->CommonHelper->GetCityAreas($this->Model);
							}
							if(!isset($this->view->HListUrl_Price)){		
								$this->view->HListUrl_Price = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{lowprice}'=>'Lowprice','{highprice}'=>'Highprice'));
							}
							if(!isset($this->view->HListUrl_Star)){
								$this->view->HListUrl_Star = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{star}'=>'Star'));
							}
							if(!isset($this->view->HListUrl_Chain)){
								$this->view->HListUrl_Chain = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{chain}'=>'Chain'));
							}
							if(!isset($this->view->HListUrl_Address)){
								$this->view->HListUrl_Address = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{address}'=>'Address'));
							}
							break;
					}
					break;
				case 'search' : 
					switch($Num) {
						case '201' : 
							$this->view->InTime = $this->Model->InTime;
							$this->view->OutTime = $this->Model->OutTime;
							$this->view->ServerDate = date("Y-m-d");
							if(!isset($this->view->CityName)){
								$this->view->CityName ='';
								$this->view->MainCityName =ModelClass::$MainCityName;
								$this->view->MainCityId = ModelClass::$MainCityId;
							}
							if(!isset($this->view->KeyWord)){
								$this->view->KeyWord = '';
							}
							break;
					}
					break;
				case 'slide' : 
					switch($Num) {
						case '301' : 
							break;
					}
					break;
				case 'special':
					switch($Num) {
						case '101' : 
							$this->view->StationPageUrl = PageUrlClass::$StationPageUrl;
							$this->view->AirportPageUrl = PageUrlClass::$AirportPageUrl;
							$this->view->SchoolsPageUrl = PageUrlClass::$SchoolsPageUrl;
							break;
					}
					break;
			}
		}
    
		//获取页面关键字
		public function GetPageKeywords($Page){
			$this->Model->PageName = $Page;
			$WebKeyword = $this->CommonHelper->GetPageKeywords($this->Model);		
			$this->view->Title = $this->Handle->ReplaceKeywords($WebKeyword['Title'],$this->Model);
	        $this->view->Keyword = $this->Handle->ReplaceKeywords($WebKeyword['Keyword'],$this->Model);
	        $this->view->Description = $this->Handle->ReplaceKeywords($WebKeyword['Description'],$this->Model);
		}
		
		//释放资源
		public function UnsetAll(){
			if(isset($this->Model)){
				unset($this->Model);
			}
			if(isset($this->Handle)){
				unset($this->Handle);
			}
			if(isset($this->CommonHelper)){
				unset($this->CommonHelper);
			}
			if(isset($this->HotelHelper)){
				unset($this->HotelHelper);
			}
			if(isset($this->SpecialHelper)){
				unset($this->SpecialHelper);
			}
			if(isset($this->PageUrler)){
				unset($this->PageUrler);
			}
		}
    }
?>