<?php
    class HotelController extends DefaultCommonController
    {
    	function init(){
    		parent::init();
    		$this->view->ordertype = ModelClass::$OrderType;
    		$Hid = $this->Request->getParam('hid');
    		if(isset($Hid)){
				$this->Model->Hid = $Hid;
				$HotelView = $this->HotelHelper->GetHotelView($this->Model);			
				$this->view->HotelView = $HotelView;
				
				$this->Model->HAreaId = $HotelView['jdwz_id'];
				$this->view->HotelAreaName = $this->Model->HAreaName = $this->CommonHelper->GetAreaNameById($this->Model);
				
				$this->Model->Cid = $HotelView['cid'];
				$this->view->CityName = $this->Model->CityName = $this->CommonHelper->GetCityNameById($this->Model);
				
				$this->view->Cid = $HotelView['cid'];
				$this->view->HListUrl_Address = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{address}'=>'Address'));
    			
				$this->Model->HName = $HotelView['hotelname'];
				$this->Model->HAddressName = $HotelView['address'];
				
				$this->Model->ARId = $HotelView['rid'];
				$this->Model->ARName = $this->CommonHelper->GetARNameById($this->Model);
				
				$this->Model->ChainId = $HotelView['chain_id'];
				$this->Model->ChainName = $this->CommonHelper->GetChainNameById($this->Model);
    		}
    	}
    	
		//酒店列表页
        public function hotellistAction()
       	{
			$this->view->InTime = $this->Model->InTime;
			$this->view->OutTime = $this->Model->OutTime;
			$this->view->TimeDiff = $this->Handle->GetTimeDiff($this->Model->OutTime,$this->Model->InTime);		
			
			//获取传参
       		if(isset($_SERVER["HTTP_X_REWRITE_URL"])||isset($_SERVER['HTTP_X_ORIGINAL_URL'])){
				$KeyWord =iconv('GBK', 'UTF-8', $this->Request->getParam('keyword'));
			}else{
				$KeyWord =$this->Request->getParam('keyword');
			}
			$Cid = $this->Request->getParam('cid');
			$Rid = $this->Request->getParam('rid');
			$Address = $this->Request->getParam('address');
			$Star = $this->Request->getParam('star');
			$Chain = $this->Request->getParam('chain');
			$Page = $this->Request->getParam('page');
			$Sort = $this->Request->getParam('sort');
			$LowPrice = $this->Request->getParam('lowprice');
			$HighPrice = $this->Request->getParam('highprice');
			$Pos = $this->Request->getParam('pos');
			
			$this->view->Cid = $Cid;
			$this->Model->Cid = $Cid;
			
			//专题栏目
			if(strpos($KeyWord,"_")!==false){
				$this->Model->KeyStr = rawurlencode($KeyWord);
				$NewKeyWord = $this->CommonHelper->GetSuggestKey($this->Model);
				$Pos = str_replace(' ','',$NewKeyWord['pos']);
				$Key = str_replace('附近酒店','地铁站',$NewKeyWord['keyword']);
				if($Pos!='0'){
					$KeyWord = $Key;
					$Sort = '4';
					$Rid = '0';
					$Address = '0';
					$Star = '0';
					$Chain = '0';
					$Page = '0';
					$LowPrice = '0';
					$HighPrice = '0';
				}
			}			

			//获取城市Id及名称供前台页面处理
			$CityName = $this->CommonHelper->GetCityNameById($this->Model);
			$this->Model->CityName = $CityName;
			$this->view->CityName = $CityName;
			$this->view->KeyWord = $KeyWord=='0'?'':$this->Handle->UnEscape($KeyWord);
			
       		//获取酒店地址
			if(intval($Address)>0){
				$this->Model->HAreaId = $Address;
				$HAreaName = $this->CommonHelper->GetAreaNameById($this->Model);
				$this->view->HAreaName = $this->Model->HAreaName = $HAreaName;
			}
			if($KeyWord!='0'){
				$HAreaName = $this->Handle->UnEscape($KeyWord);
				$this->view->HAreaName = $this->Model->HAreaName = $HAreaName;
			}
			if(!isset($HAreaName)){
				$this->view->HAreaName ='';
			}
       		//获取星级名称
			if(intval($Star)>0 && intval($Star)<7){
				$this->Model->StarId = $Star;
				$this->view->StarName = $this->Model->StarName = $this->CommonHelper->GetStarNameById($this->Model);
			}else{
				$this->view->StarName = '';
			}
			//获取价格区域
			if(intval($HighPrice)>0){
				if(intval($HighPrice)<=200){
					$this->view->Price = $this->Model->Price = '200元以下';
				}else{
					$this->view->Price = $this->Model->Price = $LowPrice.'元-'.$HighPrice.'元';
				}
			}else{
				$this->view->Price = '';
			}
			//获取连锁名称
			if(intval($Chain)>0){
				$this->Model->ChainId = $Chain;
				$this->view->ChainName = $this->Model->ChainName = $this->CommonHelper->GetChainNameById($this->Model);
			}else{
				$this->view->ChainName = '';
			}
			
			//构造酒店列表链接地址及酒店列表接口
			$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>$Star,'{chain}'=>$Chain,'{keyword}'=>'0','{page}'=>$Page,'{sort}'=>$Sort,'{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>$Pos);
			$this->Model->IHListUrl = $this->Handle->BatchReplace(PageUrlClass::$IHList,$Arguments);
			$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>$Star,'{chain}'=>$Chain,'{keyword}'=>$KeyWord,'{page}'=>$Page,'{sort}'=>$Sort,'{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>$Pos);
			$HListPageUrl = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);
			
			//获取酒店列表及相关
			$HotelList = $this->HotelHelper->GetHotelList($this->Model);
			$this->view->HotelList = $HotelList;		
			
			//分页链接及相关
			$CurrentPage = $this->Model->CurrentPage;
			$TotalPage = $this->Model->TotalPage;		
			$this->view->CurrentPage = $CurrentPage;
			$this->view->TotalPage = $TotalPage;
			$this->view->TotalHCount = $this->Model->TotalHCount;
			$PrePage = ($CurrentPage-1)<0?'0':($CurrentPage-1);
			$NextPage = ($CurrentPage+1)>$TotalPage?$TotalPage:($CurrentPage+1);
			if($CurrentPage==0||$CurrentPage==1){
				$this->view->FirstPageUrl = 'javascript:void(0)';
				$this->view->PrePageUrl = 'javascript:void(0)';
			}else{			
				$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>$Star,'{chain}'=>$Chain,'{keyword}'=>$KeyWord,'{page}'=>'0','{sort}'=>$Sort,'{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>$Pos);				
				$this->view->FirstPageUrl=$this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);
				$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>$Star,'{chain}'=>$Chain,'{keyword}'=>$KeyWord,'{page}'=>$PrePage,'{sort}'=>$Sort,'{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>$Pos);	
				$this->view->PrePageUrl=$this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);
			}
			if($CurrentPage == $TotalPage){
				$this->view->NextPageUrl = 'javascript:void(0)';
				$this->view->LastPageUrl = 'javascript:void(0)';
			}else{
				$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>$Star,'{chain}'=>$Chain,'{keyword}'=>$KeyWord,'{page}'=>$NextPage,'{sort}'=>$Sort,'{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>$Pos);
				$this->view->NextPageUrl=$this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);
				$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>$Star,'{chain}'=>$Chain,'{keyword}'=>$KeyWord,'{page}'=>$TotalPage,'{sort}'=>$Sort,'{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>$Pos);
				$this->view->LastPageUrl = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);
			}
			
			//条件筛选
			$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>$Star,'{chain}'=>$Chain,'{keyword}'=>$KeyWord,'{page}'=>'0','{sort}'=>$Sort,'{lowprice}'=>'Lowprice','{highprice}'=>'Highprice','{pos}'=>$Pos);
			$this->view->HListUrl_PlusPrice = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);			
			$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>'Address','{star}'=>$Star,'{chain}'=>$Chain,'{keyword}'=>'0','{page}'=>'0','{sort}'=>$Sort,'{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>'0');
			$this->view->HListUrl_PlusAddress = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);			
			$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>'Star','{chain}'=>$Chain,'{keyword}'=>$KeyWord,'{page}'=>'0','{sort}'=>$Sort,'{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>$Pos);	
			$this->view->HListUrl_PlusStar = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);			
			$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>$Star,'{chain}'=>'Chain','{keyword}'=>$KeyWord,'{page}'=>'0','{sort}'=>$Sort,'{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>$Pos);		
			$this->view->HListUrl_PlusChain = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);
			
			//排序
			$this->view->Sort = $Sort;
			$Arguments=array('{cid}'=>$Cid,'{rid}'=>$Rid,'{address}'=>$Address,'{star}'=>$Star,'{chain}'=>$Chain,'{keyword}'=>$KeyWord,'{page}'=>$Page,'{sort}'=>'Sort','{lowprice}'=>$LowPrice,'{highprice}'=>$HighPrice,'{pos}'=>$Pos);
			$this->view->HListUrl_Sort = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,$Arguments);
			
			//酒店详细链接
			$this->view->HViewPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HViewPageUrl);	
			$this->view->HPicturePageUrl = str_replace('{hid}','Hid',PageUrlClass::$HPicturePageUrl);
			$this->view->HVideoPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HVideoPageUrl);
			$this->view->HCommentPageUrl = str_replace('{hid}','Hid',PageUrlClass::$HCommentPageUrl);
			
			$this->Model->Num = 0;
			$this->view->CCityAreas = $this->CommonHelper->GetCityAreas($this->Model);
			$this->view->HListUrl_Address = $this->Handle->BatchReplace(PageUrlClass::$HListPageUrl,array('{cid}'=>'Cid','{address}'=>'Address'));
			
			$this->view->CCityChains = $this->CommonHelper->GetCityChains($this->Model);
        	
			//创建模块
			$this->CreateMedules('hotellist');
			//获取页面关键字
			$this->GetPageKeywords('hotellist');
			
			//释放资源
			$this->UnsetAll();
	    }
		
		//酒店介绍页
		public function hotelviewAction()
        {
			$this->view->InTime = $this->Model->InTime;
			$this->view->OutTime = $this->Model->OutTime;
			$this->view->TimeDiff = $this->Handle->GetTimeDiff($this->Model->OutTime,$this->Model->InTime);	
			//创建模块
			$this->CreateMedules('hotelview');
			//获取页面关键字
			$this->GetPageKeywords('hotelview');
			
			//释放资源
			$this->UnsetAll();
	    }
		
		//酒店点评页
		public function hotelcommentAction()
        {	
        	$this->CreateMedules('hotelcomment');
        	//获取页面关键字
			$this->GetPageKeywords('hotelcomment');
			
			//释放资源
			$this->UnsetAll();
	    }
		
		//酒店图集页
		public function hotelpictureAction()
        {
			$this->CreateMedules('hotelpicture');
			//获取页面关键字
			$this->GetPageKeywords('hotelpicture');
			
			//释放资源
			$this->UnsetAll();
	    }
		
		//酒店全景图页
		public function hotelpanoramaAction()
        {
			$this->CreateMedules('hotelpanorama');
			//获取页面关键字
			$this->GetPageKeywords('hotelpanorama');
			
			//释放资源
			$this->UnsetAll();
	    }
		
		//酒店视频页
		public function hotelvideoAction()
        {
			$this->CreateMedules('hotelvideo');
			//获取页面关键字
			$this->GetPageKeywords('hotelvideo');
			
			//释放资源
			$this->UnsetAll();
	    }
		
		//酒店交通指引页
		public function hoteltransportAction()
        {
        	$this->CreateMedules('hoteltransport');
        	//获取页面关键字
			$this->GetPageKeywords('hoteltransport');
			
			//释放资源
			$this->UnsetAll();
		}
		
		//酒店周边环境页
		public function hotelaroundsAction()
        {
			$this->CreateMedules('hotelarounds');
			//获取页面关键字
			$this->GetPageKeywords('hotelarounds');
			
			//释放资源
			$this->UnsetAll();
	    }
		
    	//酒店单个周边环境页
		public function hotelaroundAction()
        {
			$this->CreateMedules('hotelaround');
			//获取页面关键字
			$this->GetPageKeywords('hotelaround');
			
			//释放资源
			$this->UnsetAll();
	    }
	    
		//酒店问答页
		public function hotelquestionAction()
        {
			$this->CreateMedules('hotelquestion');
			//获取页面关键字
			$this->GetPageKeywords('hotelquestion');
			
			//释放资源
			$this->UnsetAll();
	    }
    }
?>