<?php
	/**
	 * 共同数据模型类
	 */
	class CommonClass {	
		
		public $Handle;
		public function __construct(){
			$this->Handle = new HandleClass();
		}
		
		//获取热门城市,$Num=0则取全部
		public function GetHotCities(ModelClass $Model){
			$Num = $Model->Num;
			$HotCities = array();
			$Flag = 0;
			$CityList = explode('#',ModelClass::$HotCitys);
			foreach($CityList as $val){
				$City = explode(',',$val);
				$HotCities[$City[0]]=$City[1];
				$Flag++;
				if($Num <= $Flag){ break; }
			}
			return $HotCities;
		}

		//获取连锁品牌（$Cid=0为获取所有连锁品牌，否则为指定城市的连锁品牌）
		public function GetCityChains (ModelClass $Model){
			$Cid = $Model->Cid;
			$Flag = 'CityChains_'.$Cid;
			if(!$CityChains = $this->Handle->GetCache($Flag)){
				$CityChains = json_decode($this->Handle->RemoteAccess(str_replace('{cid}',$Cid,PageUrlClass::$ICityChains)),true);
				$this->Handle->CreateCache($Flag,$CityChains);
			}
			return $CityChains;
		}
		
		//根据品牌Id获取品牌名称
		public function GetChainNameById(ModelClass $Model){
			$Chainid = $Model->ChainId;	
			$Flag = 'ChainNameAndId';
			if(!$Chains = $this->Handle->GetCache($Flag)){
				$AllChains = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IAllChains),true);
				foreach ($AllChains as $Chain){
					$Chains[$Chain['name']] = $Chain['id'];
				}
				$this->Handle->CreateCache($Flag,$Chains);
			}
			return array_search($Chainid,$Chains)=='0'?'':array_search($Chainid,$Chains);
		}
		
		//根据城市ID获取对应城市名
		public function GetCityNameById(ModelClass $Model){
			$Flag = 'CityNameAndId';
			if(!$Cities = $this->Handle->GetCache($Flag)){
				$AllCity = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IAllCities),true);
				foreach($AllCity as $City){
					$Cities[$City['name']] = $City['id'];
				}
				unset($AllCity);
				$this->Handle->CreateCache($Flag,$Cities);
			}
			return array_search($Model->Cid,$Cities);
		}
		
		//获取城市热门商业
		public function GetCityAreas (ModelClass $Model){		
			$Cid = $Model->Cid;
			$Flag = 'CityAreas_'.$Cid;
			if(!$CityAreas = $this->Handle->GetCache($Flag)){
				$Areas = json_decode($this->Handle->RemoteAccess(PageUrlClass::$ICityAreas),true);
				foreach($Areas as $Area){
					if($Area['cid'] == $Cid){
						$CityAreas[] = $Area;
					}
				}
				unset($Areas);
				$this->Handle->CreateCache($Flag,$CityAreas);
			}
			return $CityAreas;
		}
		
		//获取推荐酒店
		public function GetRecommonedHotels(ModelClass $Model){
			$Cid = $Model->Cid;	
			$Flag = 'RecommondHotels_'.$Cid;
			if(!$RecommondHotels = $this->Handle->GetCache($Flag)){
				$RecommondHotels =  json_decode($this->Handle->RemoteAccess(str_replace('{cid}', $Cid, PageUrlClass::$ICityHotels)),true);
				$this->Handle->CreateCache($Flag,$RecommondHotels);
			}
			return $RecommondHotels;
		}
		
		//获得可能的连锁品牌名称及酒店类型
   		public function GetMayBeChain(ModelClass $Model) {
   			$Cid = $Model->Cid;
   			$KeyStr = $Model->KeyStr;
			$KeyWord = preg_replace('/[\ |\~|\`|\!|\@|\#|\$|\%|\^|\&|\*|\(|\)|\-|\_|\+|\=|\||\\|\[|\]|\{|\}|\;|\:|\"|\'|\,|\<|\.|\>|\/|\?]/','',$KeyStr);
			$KeyWord = str_replace('可输入酒店名、品牌、地址、著名地标','',str_replace($this->GetCityNameById($Model),'',$KeyWord));
        	if ($KeyWord=='') { return array('{cid}'=>$Cid);}
        	if (strpos($KeyWord,'好如家') !== false && $Cid == '79') { return array('{cid}'=>'79','{chain}'=>'51','{page}'=>'1');}
        	if (strpos($KeyWord,'七天') !== false || strpos($KeyWord,'7天') !== false) { return array('{cid}'=>$Cid,'{star}'=>'2','{page}'=>'1');}
       		if (str_replace('酒店','',$KeyWord) == '连锁') { return array('{cid}'=>$Cid,'{star}'=>'2','{page}'=>'1');}
       		$Star = $this->GetStarIdByName($Model); //获得可能的酒店星级
        	if ($Star > 0) { return array('{cid}'=>$Cid,'{star}'=>$Star,'{page}'=>'1');}
			$AllChains =$this->GetCityChains($Model);
			foreach($AllChains as $Chain){
				if(strpos($Chain['Tag'],$KeyWord)!== false){
					return array('{cid}'=>$Cid,'{chain}'=>$Chain['id'],'{page}'=>'1');
                	break;
				}
			}
			return array();
		}
		
		//获取最匹配的关键字
		public function GetSuggestKey(ModelClass $Model){
			$IKeysuggest = str_replace('{keyword}',$Model->KeyStr,str_replace('{cid}',$Model->Cid,PageUrlClass::$IKeysuggest));
			return json_decode($this->Handle->RemoteAccess($IKeysuggest) ,true);
		}
		
		//根据地址ID获取对应的地址名称
		public function GetAreaNameById(ModelClass $Model){
			$AreaId = $Model->HAreaId;
			$Flag = 'HAreaNameAndId';
			if(!$Areas = $this->Handle->GetCache($Flag)){
				$AllAreas = json_decode($this->Handle->RemoteAccess(PageUrlClass::$ICityAreas),true);
				foreach($AllAreas as $Area){
					$Areas[$Area['id']] = $Area['name'];
				}
				unset($AllAreas);
				$this->Handle->CreateCache($Flag,$Areas);
			}
			return empty($Areas[$AreaId])?'':$Areas[$AreaId];
		}	
		
		//获取全部城市（应用于网站底部显示）
		public function GetSystemCities(){
			$Flag = 'AllCities';
			if(!$AllCities = $this->Handle->GetCache($Flag)){
				$AllCities = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IAllCities),true);
				$this->Handle->CreateCache($Flag,$AllCities);
			}
			return $AllCities;
		}
		
		//获取历史酒店数据
		public function GetOldHotels(){
			$OldHotels = '';
			$Cookie = new Zend_Http_Cookie('OldHotels',$OldHotels,'来源地址',time() + 7200,'/');
		}
		
		//获取酒店附近的酒店
		public function GetNearbyHotels(ModelClass $Model){
			$IHNearby = str_replace('{lowprice}',$Model->LowPrice,str_replace('{pos}',$Model->Pos,str_replace('{hid}',$Model->Hid,str_replace('{cid}',$Model->Cid,PageUrlClass::$IHNearby))));
			return json_decode($this->Handle->RemoteAccess($IHNearby),true);
			/*$Flag = 'NearbyHotels';
			if(!$NearbyHotels = $this->Handle->GetCache($Flag)){
				$IHNearby = str_replace('{lowprice}',$Model->Lowprice,str_replace('{pos}',$Model->Pos,str_replace('{hid}',$Model->Hid,str_replace('{cid}',$Model->Cid,PageUrlClass::$IHNearby))));
				$NearbyHotels = json_decode($this->Handle->RemoteAccess($IHNearby),true);
				$this->Handle->CreateCache($Flag,$NearbyHotels);
			}
			return $NearbyHotels;*/
		}
		
		//获取指定号码的订单数据
		public function GetOrderList(ModelClass $Model){
			$IOrderList = str_replace('{phone}',$Model->Phone,PageUrlClass::$IHOrders);	
			return json_decode($this->Handle->RemoteAccess($IOrderList),true);
		}
		
		//获取最新订单(缓存7分钟)
		public function GetLatestOrders (){
			$Flag = 'LatestOrders';
			if(!$LatestOrders = $this->Handle->GetCache($Flag,0.005)){
				$LatestOrders = array_slice(json_decode($this->Handle->RemoteAccess(PageUrlClass::$IHLatestOrders),true),0,10);
				$this->Handle->CreateCache($Flag,$LatestOrders);
			}
        	return $LatestOrders;
		}
		
		//获取最新点评数据(缓存7分钟)
		function GetLatestComments (){
			$Flag = 'LatestComments';
			if(!$LatestComments = $this->Handle->GetCache($Flag,0.005)){
				$LatestComments = array_slice(json_decode($this->Handle->RemoteAccess(PageUrlClass::$IHLatestComments),true),0,10);
				$this->Handle->CreateCache($Flag,$LatestComments);
			}
        	return $LatestComments;
		}
		
		//获取最新问答数据(缓存7分钟)	
		public function GetLatestAsks (){
			$Flag = 'LatestAsks';
			if(!$LatestAsks = $this->Handle->GetCache($Flag,0.005)){
				$LatestAsks = array_slice(json_decode($this->Handle->RemoteAccess(PageUrlClass::$IHLatestAsks),true),0,10);
				$this->Handle->CreateCache($Flag,$LatestAsks);
			}
        	return $LatestAsks;
		}
		
		//根据酒店类型获得对应ID
    	public function GetStarIdByName(ModelClass $Model){ 
			$Result=0;
			$StarName = $Model->StarName;
			$StarArray = array('1'=>'经济型酒店','2'=>'连锁酒店','3'=>'三星级酒店','4'=>'四星级酒店','5'=>'五星级酒店','6'=>'酒店式公寓');
			return array_search($StarName,$StarArray);
		}

		//根据星级ID获取酒店类型
    	public function GetStarNameById(ModelClass $Model){ 
    		$Result = '';
			$StarId = $Model->StarId;
			$StarArray = array('经济型'=>'1','连锁型'=>'2','三星级'=>'3','四星级'=>'4','五星级'=>'5','公寓型'=>'6');
			return array_search($StarId,$StarArray);
		}
		
		//根据行政区Id获取行政区名称
		public function GetARNameById(ModelClass $Model){
			$ARName = '';
			$ARid = $Model->ARId;
			$AllARs = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IAllAR),true);
			foreach($AllARs as $AR){
				if($AR['id']==$ARid){
					$ARName = $AR['name'];
					break;
				}
			}
			unset($AllARs);
			return $ARName;
		}
		
		//获取各个页面的关键字
        public function GetPageKeywords(ModelClass $Model){     	
			$currentpage = $Model->PageName;
			$Flag = 'page_'.$currentpage.'_keyword';
			if(!$WebKeyword = $this->Handle->GetCache($Flag)){
				$Arguments = array('agentid'=>Web_Agentid,'agentmd'=>Web_Agentmd,'page'=>$currentpage);
				$WebKeyword = $this->Handle->SoapAccess('GetWebKeyword',$Arguments,'GetWebKeywordResult');
				unset($Arguments);
				$this->Handle->CreateCache($Flag,$WebKeyword);
			}
        	return $WebKeyword;
        }
        
		//获取友情链接（1:图片）
		function GetPicFlinks (){
			$Flag = 'PicFlinks';
			if(!$PicFlinks = $this->Handle->GetCache($Flag)){
				$Arguments = array('agentid'=>Web_Agentid,'agentmd'=>Web_Agentmd,'type'=>'1','enable'=>'1');
        		$PicFlinksResult = $this->Handle->SoapAccess('GetFLink',$Arguments,'GetFLinkResult');
        		unset($Arguments);
        		if($PicFlinksResult!=null){    			
	        		$PicFlinksCount = count($PicFlinksResult['string']);
		        	for($i=0;$i<$PicFlinksCount/7;$i++){
		        		$PicFlinks[] = array('Id'=>$PicFlinksResult['string'][$i*7+0],'Title'=>$PicFlinksResult['string'][$i*7+1],'PicUrl'=>$PicFlinksResult['string'][$i*7+2],'Type'=>$PicFlinksResult['string'][$i*7+3],'SOrder'=>$PicFlinksResult['string'][$i*7+4],'LinkUrl'=>$PicFlinksResult['string'][$i*7+5],'Enable'=>$PicFlinksResult['string'][$i*7+6]);
		        	}
        		}else{
        			$PicFlinks[] = array('Id'=>'','Title'=>'','PicUrl'=>'','Type'=>'','SOrder'=>'','LinkUrl'=>'','Enable'=>'');
        		}
        		unset($PicFlinksResult);
				$this->Handle->CreateCache($Flag,$PicFlinks);
			}
        	return $PicFlinks;
		}
		
		//获取友情链接（0:文字）
		function GetWordFlinks (){
			$Flag = 'WordFlinks';
			if(!$WordFlinks = $this->Handle->GetCache($Flag)){
				$Arguments = array('agentid'=>Web_Agentid,'agentmd'=>Web_Agentmd,'type'=>'0','enable'=>'1');
        		$WordFlinksResult = $this->Handle->SoapAccess('GetFLink',$Arguments,'GetFLinkResult');
				unset($Arguments);
				if($WordFlinksResult!=null){
					$WordFlinksCount = count($WordFlinksResult['string']);
		        	for($i=0;$i<$WordFlinksCount/7;$i++){
		        		$WordFlinks[] = array('Id'=>$WordFlinksResult['string'][$i*7+0],'Title'=>$WordFlinksResult['string'][$i*7+1],'PicUrl'=>$WordFlinksResult['string'][$i*7+2],'Type'=>$WordFlinksResult['string'][$i*7+3],'SOrder'=>$WordFlinksResult['string'][$i*7+4],'LinkUrl'=>$WordFlinksResult['string'][$i*7+5],'Enable'=>$WordFlinksResult['string'][$i*7+6]);
		        	}
        		}else{
        			$WordFlinks[] = array('Id'=>'','Title'=>'','PicUrl'=>'','Type'=>'','SOrder'=>'','LinkUrl'=>'','Enable'=>'');
        		}
        		unset($WordFlinksResult);
				$this->Handle->CreateCache($Flag,$WordFlinks);
			}
        	return $WordFlinks;
		}
	}
?>
