<?php
	/**
	 * 名称：酒店详细类
	 */
	class HotelClass{
		
		public $Handle;
		public function __construct(){
			$this->Handle = new HandleClass();
		}
		
		//获取酒店列表
		public function GetHotelList(ModelClass $Model){
			$HotelList = json_decode($this->Handle->RemoteAccess($Model->IHListUrl),true);
			$Model->TotalHCount = $HotelList['total'];
			$Model->CurrentPage = $HotelList['page'];
			$Model->TotalPage = ceil($HotelList['total'] / 10);	
			return $HotelList['hotel_list'];
		}
		
		//获取酒店介绍数据
		public function GetHotelView(ModelClass $Model){
			$Hid = $Model->Hid;
			$Flag = 'HotelView_'.$Hid;
			if(!$HotelView = $this->Handle->GetCache($Flag)){
				$HotelView = json_decode($this->Handle->RemoteAccess(str_replace('{hid}',$Hid,PageUrlClass::$IHInfo)),true);
				$this->Handle->CreateCache($Flag,$HotelView);
			}
			return $HotelView;
		}
		
		//获取酒店印象
		public function GetHotelImpressions(ModelClass $Model){
			$Impressions = array();
			$ImpressionArray = explode('|', $Model->HInfo);
			foreach($ImpressionArray as $Impression){
				$Item = explode(',', $Impression);
				$Impressions [] = $Item[0];
			}
			return $Impressions;
		}
		
		//获取好评率(中评也算好评)
		public function GetHotelGoodRate(ModelClass $Model) {
			$hp = $Model->HP;
			$zp = $Model->ZP;
			$cp = $Model->CP;
			$Sump = $hp + $zp + $cp;
			$Rate = 100;
        	if ($Sump > 0) { 
        		$Rate = ceil(($hp + $zp) * 100 / $Sump) ;
			}
			return $Rate;
		}
		
		//获取酒店点评数
		public function GetHotelCommetCount(ModelClass $Model) {
			$hp = $Model->HP;
			$zp = $Model->ZP;
			$cp = $Model->CP;
			$Sum = $hp + $zp + $cp;
			return $Sum;
		}
		
		//获取酒店的基本信息（开业时间，楼层，房间数等）
		public function GetHotelBaseInfo(ModelClass $Model){
			$HotelBaseInfo = array();
			$AllBaseInfo = explode('|', $Model->HInfo);
			if(count($AllBaseInfo)>1){
				foreach($AllBaseInfo as $BaseInfo){
					$Item = explode('：', $BaseInfo);
					$HotelBaseInfo[] = $Item[1];
				}
			}
			return $HotelBaseInfo;
		}
		
		//获取酒店支付方式（卡）
		public function GetHotelPayCard(ModelClass $Model){
			$HotelInfo = $Model->HInfo;
			$Cards = array();
			if(strpos($HotelInfo,'|')!==false && strpos($HotelInfo,'gif')!==false){
				$Card = explode('|', $HotelInfo);
				for($i=0;$i<count($Card);$i=$i+2){
					$Cards[$Card[$i]]=$Card[$i+1];
				}
			}
			return $Cards;
		}
		
		//获取酒店介绍页面的酒店图
		public function GetHotelPicture(ModelClass $Model){
			return explode('|', str_replace('..','http://www.128uu.com',$Model->HInfo));
		}
		
		//获取酒店图集
		public function GetHotelPictures(ModelClass $Model){
			return json_decode($this->Handle->RemoteAccess(str_replace('{hid}',$Model->Hid,PageUrlClass::$IHPictures)),true);
		}
		
		//获取酒店点评数据
		public function GetHotelComments(ModelClass $Model){
			$HotelComments = json_decode($this->Handle->RemoteAccess(str_replace('{hid}', $Model->Hid, PageUrlClass::$IHComments)),true);
			return $HotelComments['dianping_list'];
		}
		
		//获取酒店问答数据
		public function GetHotelAsks(ModelClass $Model){
			$HotelAsks = json_decode($this->Handle->RemoteAccess(str_replace('{hid}',$Model->Hid,PageUrlClass::$IHAsks)),true);
			return $HotelAsks['ask_list'];
		}
		
		//获取酒店单个周边环境	
		public function GetHotelAround(ModelClass $Model){
			$Cid = $Model->Cid;
			$Hid = $Model->Hid;
			$Pos = $Model->Pos;
			$Num = $Model->Num;	
			$AroundType = $Model->AroundType;
			return json_decode($this->Handle->RemoteAccess(str_replace('{cid}',$Cid,str_replace('{num}',$Num,str_replace('{typeid}',$AroundType,str_replace('{pos}',$Pos,str_replace('{hid}',$Hid,PageUrlClass::$IHArouds)))))),true);
		}
		
		//获取同城有全景图的酒店
		public function GetCitySciHotels(ModelClass $Model){
			$Cid = $Model->Cid;
			$Flag = 'CitySciHotels_'.$Cid;
			if(!$CitySciHotels = $this->Handle->GetCache($Flag)){	
				$CitySciHotels = json_decode($this->Handle->RemoteAccess(str_replace('{cid}',$Cid,PageUrlClass::$IHPanorama)),true);
				$this->Handle->CreateCache($Flag,$CitySciHotels);
			}
			return $CitySciHotels;
		}
		
		//获取同城有视频的酒店
		public function GetCityVideoHotels(ModelClass $Model){
			$Cid = $Model->Cid;
			$Flag = 'CityVideoHotels_'.$Cid;
			if(!$CityVideoHotels = $this->Handle->GetCache($Flag)){
				$CityVideoHotels = json_decode($this->Handle->RemoteAccess(str_replace('{cid}',$Cid,PageUrlClass::$IHVedio)),true);
				$this->Handle->CreateCache($Flag,$CityVideoHotels);
			}
			return $CityVideoHotels;
		}
    }
?>