<?php
	/**
	 * 酒店专题数据模型类
	 */
	class SpecialClass{
		
		public $Handle;
		public function __construct(){
			$this->Handle = new HandleClass();	
		}
		
		//获取全国城市（按字母格式排序）
		function GetAllCity (){
			$Flag = 'AllCitieso';
			if(!$AllCitieso = $this->Handle->GetCache($Flag)){
				$AllCity = array();
				$SortCity = array();
				$TempNewCity = array();	
				$OrgAllCity = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IAllCitieso),true);		
				foreach($OrgAllCity as $OrgCity){
					foreach($OrgCity['info'] as $City){
						$AllCity[] = $City;
					}
				}
				foreach($AllCity as $City){
					$SortCity[] = $City['enname'];
				}
				array_multisort($SortCity, $AllCity);
				unset($SortCity);
				$CityCount = count($AllCity);
				for( $i=0; $i< $CityCount; $i++){
					$TempNewCity[] = $AllCity[$i];
					if($i+1 != $CityCount){
						if(substr($AllCity[$i]['enname'],0,1)!=substr($AllCity[$i+1]['enname'],0,1)){
							$AllCitieso[substr($AllCity[$i]['enname'],0,1)] = $TempNewCity;
							$TempNewCity = array();
						}
					}else{
						$AllCitieso[substr($AllCity[$i]['enname'],0,1)] = $TempNewCity;
						$TempNewCity = array();
					}
				}
				$this->Handle->CreateCache($Flag,$AllCitieso);
			}
			return $AllCitieso;
		}

		//获取单一连锁品牌信息（介绍）
		public function GetSingleChain(ModelClass $Model){
			$ChainId = $Model->ChainId;
			$Flag = 'SingleChain_'.$ChainId;
			if(!$SingleChain = $this->Handle->GetCache($Flag)){
				$SingleChain = json_decode($this->Handle->RemoteAccess(str_replace('{chain}', $ChainId, PageUrlClass::$IChainCities)),true);
				$this->Handle->CreateCache($Flag,$SingleChain);
			}
			return $SingleChain;
		}
		
		//获取连锁相关的城市（按字母格式排序）
		public function GetChainCity(ModelClass $Model){
			$ChainId = $Model->ChainId;
			$Flag = 'ChainCities_'.$ChainId;
			if(!$ChainCities = $this->Handle->GetCache($Flag)){
				$AllChainInfo = json_decode($this->Handle->RemoteAccess(str_replace('{chain}', $ChainId, PageUrlClass::$IChainCities)),true);
				$TempChainCity = $AllChainInfo['CityList'];
				$ChainCities = array();
				$TempNewCity = array();
				$SortCity = array();
				foreach($TempChainCity as $City){
					$SortCity[] = $City['L'];
				}
				array_multisort($SortCity, $TempChainCity);	
				$ChainCityCount = count($TempChainCity);
				for( $i=0; $i<$ChainCityCount; $i++){
					$TempNewCity[] = $TempChainCity[$i];
					if($i+1 !=$ChainCityCount){
						if($TempChainCity[$i]['L']!=$TempChainCity[$i+1]['L']){
							$ChainCities[$TempChainCity[$i]['L']] = $TempNewCity;
							$TempNewCity = array();
						}
					}else{
						$ChainCities[$TempChainCity[$i]['L']] = $TempNewCity;
						$TempNewCity = array();
					}
				}
				$this->Handle->CreateCache($Flag,$ChainCities);
			}
			return $ChainCities;
		}
		
		//获取连锁酒店城市
		public function GetChainHotels(ModelClass $Model){
			$ChainId = $Model->ChainId;
			$Flag = 'ChainHotels_'.$ChainId;
			if(!$NewChainHotels = $this->Handle->GetCache($Flag)){			
				$CommonHelper = new CommonClass();
				$ChainHotels = json_decode($this->Handle->RemoteAccess(str_replace('{chain}', $ChainId, PageUrlClass::$IChainHotels)),true);
				$ChainHotelsInfo = array();
				$NewChainHotels = array();
				$ChainHotelsCount = count($ChainHotels);
				for($i=0; $i<$ChainHotelsCount; $i++){
					$ChainHotelsInfo[] = $ChainHotels[$i];
					if($i+1!=$ChainHotelsCount){
						if($ChainHotels[$i]['cid']!=$ChainHotels[$i+1]['cid']){
							$Model->Cid = $ChainHotels[$i]['cid'];
							$NewChainHotelsItem = array('info' => $ChainHotelsInfo , 'cityname' => $CommonHelper->GetCityNameById($Model), 'total' => $ChainHotels[$i]['total'],'cid'=>$ChainHotels[$i]['cid']);
							array_push($NewChainHotels,$NewChainHotelsItem);
							$ChainHotelsInfo = array();
						}
					}else{
							$Model->Cid = $ChainHotels[$i]['cid'];
							$NewChainHotelsItem = array('info' => $ChainHotelsInfo , 'cityname' => $CommonHelper->GetCityNameById($Model), 'total' => $ChainHotels[$i]['total'],'cid'=>$ChainHotels[$i]['cid']);
							array_push($NewChainHotels,$NewChainHotelsItem);
					}
				}
				$this->Handle->CreateCache($Flag,$NewChainHotels);
			}
			return $NewChainHotels;
		}
		
		//获取城市地铁数据
		public function GetCityMetro(ModelClass $Model){
			return json_decode($this->Handle->RemoteAccess(str_replace('{cid}', $Model->Cid, PageUrlClass::$ICityMetro)),true);
		}
		
		//获取机场数据
		public function GetAirport(){
			$Flag = 'AllAirports';
			if(!$AllAirports = $this->Handle->GetCache($Flag)){
				$AllAirports = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IAirport),true); 
				$this->Handle->CreateCache($Flag,$AllAirports);
			}
			return $AllAirports;
		}
		
		//获取火车站数据
		public function GetStaion(){
			$Flag = 'AllStaions';
			if(!$AllStaions = $this->Handle->GetCache($Flag)){
				$AllStaions = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IStation),true); 
				$this->Handle->CreateCache($Flag,$AllStaions);
			}
			return $AllStaions;
		}
		
		//获取学校城市数据（按字母排序）
		public function GetSchoolCity(){
			$Flag = 'AllSchoolCities';
			if(!$AllSchoolCities = $this->Handle->GetCache($Flag)){
				$AllSchoolCities = array();
				$OlsSchoolCity = json_decode($this->Handle->RemoteAccess(PageUrlClass::$ISchoolCity),true);
				$SchoolCity = array();
				foreach($OlsSchoolCity as $OldCity){
					foreach($OldCity['info'] as $val){
						$SchoolCity[] = $val;
					}
				}
				$SortCity = array();
				$NewCity = array();
				foreach($SchoolCity as $City){
					array_push($SortCity,$City["enname"]);
				}
				array_multisort($SortCity, $SchoolCity);
				$CityCount = count($SchoolCity);
				for( $i=0; $i < $CityCount; $i++){
					$NewCity[] = $SchoolCity[$i];
					if($i+1!=$CityCount){
						if($SchoolCity[$i]['enname'] != $SchoolCity[$i+1]['enname']){				
							$TempNewSchoolCity = array('info' => $NewCity , 'enname' => $SchoolCity[$i]['enname']);
							array_push($AllSchoolCities,$TempNewSchoolCity);
							$NewCity = array();
						}
					}else{
						$TempNewSchoolCity = array('info' => $NewCity , 'enname' => $SchoolCity[$i]['enname']);
						array_push($AllSchoolCities,$TempNewSchoolCity);
					}
				}
				$this->Handle->CreateCache($Flag,$AllSchoolCities);
			}
			return $AllSchoolCities;
		}
		
		//获取城市学校数据
		public function GetCitySchool(ModelClass $Model){
			return json_decode($this->Handle->RemoteAccess(str_replace('{typeid}',$Model->SchoolType,str_replace('{cid}', $Model->Cid, PageUrlClass::$ITypeSchoolCity))),true);
		}	
		
		//获取机场周边酒店（实际是获取机场地标）
		public function GetAirportOfCity(ModelClass $Model){
			$Cid = $Model->Cid;		
			$Flag = 'AirportOfCity_'.$Cid;
			if(!$CityAirPorts = $this->Handle->GetCache($Flag)){
				$CityAirPorts = array();
				$AllAirPort = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IAirport),true);
				if(count($AllAirPort)>0){
					foreach($AllAirPort as $AirPort){
						foreach($AirPort['info'] as $AirPortInfo){
							if($AirPortInfo['cid'] == $Cid){
								$CityAirPorts[$AirPortInfo['name']]=$AirPortInfo['id'];
							}
						}
					}
				}
				$this->Handle->CreateCache($Flag,$CityAirPorts);
			}
			return 	$CityAirPorts;
		}
		
		//获取火车站周边酒店（实际是获取火车站地标）
		public function GetStationOfCity(ModelClass $Model){
			$Cid = $Model->Cid;		
			$Flag = 'StationOfCity_'.$Cid;
			if(!$CityStations = $this->Handle->GetCache($Flag)){
				$CityStations = array();
				$AllStation = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IStation),true);
				if(count($AllStation)>0){
					foreach($AllStation as $Station){
						foreach($Station['info'] as $StationInfo){
							if($StationInfo['cid'] == $Cid){
								$CityStations[$StationInfo['name']]=$StationInfo['id'];
							}
						}
					}
				}
				$this->Handle->CreateCache($Flag,$CityStations);
			}
			return $CityStations;
		}
		
		//获取地铁周边酒店（实际是获取地铁地标）
		public function GetMetroOfCity(ModelClass $Model){
			$Cid = $Model->Cid;
			$Flag = 'MetroOfCity_'.$Cid;	
			if(!$CityMetros=$this->Handle->GetCache($Flag)){
				$CityMetros = array();		
				$AllMetro = json_decode($this->Handle->RemoteAccess(PageUrlClass::$IAllMetro),true);
				if(count($AllMetro)>0){
					foreach($AllMetro as $Metro){
						if($Metro['cid'] == $Cid){
							foreach($Metro['info'] as $MetroInfo){
								$CityMetros[$MetroInfo['name']]=$MetroInfo['id'];
							}
						}
					}
				}
				$this->Handle->CreateCache($Flag,$CityMetros);
			}
			return $CityMetros;
		}
		
		//获取景点周边酒店（实际是获取景点地标）
		public function GetAttractionOfCity(ModelClass $Model){
			$Cid = $Model->Cid;
			$Flag = 'AttractionOfCity_'.$Cid;
			if(!$CityAttractions=$this->Handle->GetCache($Flag)){
				$CityAttractions = array();
				$AllAttraction = json_decode($this->Handle->RemoteAccess(str_replace('{cid}', $Cid, PageUrlClass::$ICityAttration)),true);
				if(count($AllAttraction)>0){
					foreach($AllAttraction as $Attraction){
						if($Attraction['cid'] == $Cid){
							foreach($Attraction['info'] as $AttractionInfo){
								$CityAttractions[$AttractionInfo['name']]=$AttractionInfo['id'];
							}
						}
					}
				}
				$this->Handle->CreateCache($Flag,$CityAttractions);
			}
			return $CityAttractions;
		}
		
		//获取学校周边酒店（实际是获取学校地标）
		public function GetSchoolOfCity(ModelClass $Model){
			$Cid = $Model->Cid;
			$Flag = 'SchoolOfCity_'.$Cid;
			if(!$CitySchools = $this->Handle->GetCache($Flag)){	
				$CitySchools = array();
				$AllSchool = json_decode($this->Handle->RemoteAccess(str_replace('{cid}', $Cid, PageUrlClass::$ICitySchool)),true);
				if(count($AllSchool)>0){
					foreach($AllSchool as $School){
						if($School['cid'] == $Cid){
							foreach($School['info'] as $SchoolInfo){
								$CitySchools[$SchoolInfo['name']]=$SchoolInfo['id'];
							}
						}
					}
				}
				$this->Handle->CreateCache($Flag,$CitySchools);
			}
			return $CitySchools;
		}
    }
?>