<?php
	/**
	 * 名称：工具类
	 */
	class HandleClass{		
		//远程请求接口，返回对应数据
		public function RemoteAccess($IDataUrl,$SendMethod='GET'){
			$Result = '';
			try {
				$http = new Zend_Http_Client();
	    		$http->setUri($IDataUrl);	
	    		$response = $http->request($SendMethod);
	    		if ($response->isSuccessful()) {
					$Result=$response->getBody();
	    		} 
			} catch (Zend_Exception $e) {
			}
			return $Result;
		}
		
		//功能：远程SOAP调用webservice服务
		public function SoapAccess($Method,$Arguments,$Result){
			$client = new Zend_Nusoap(ModelClass::$IWsdata,true);
			$client->decode_utf8 = false;
			$client->soap_defencoding = 'UTF-8';
			$wsresult = $client->call($Method,$Arguments);
			//echo($client->getDebug());
			return $wsresult[$Result];
		}
		
		//批量替换字符串
		//$Arguments:数组对
		public function BatchReplace($OldStr,$Arguments) {
			$NewStr = $OldStr;
			unset($OldStr);
			foreach($Arguments as $key=>$val){
				$NewStr = str_replace($key,$val,$NewStr);
			}
			return preg_replace('/{\w+?}+/','0',$NewStr);
		}
		
		//单个特定替换：如page/1->page/2
		public function SpecificReplace($OldStr,$Arguments) {
			$NewStr = $OldStr;
			unset($OldStr);
			foreach($Arguments as $key=>$val){
				$NewStr = preg_replace("/$key\/[^\/]+/","$key/$val",$NewStr);
			}
			return $NewStr;
		}
		
		//escape解码
		public function UnEscape($str){
			$ret = '';
			$len = strlen($str);
			for ($i = 0; $i < $len; $i++){
				if ($str[$i] == '%' && $str[$i+1] == 'u'){
					$val = hexdec(substr($str, $i+2, 4));
					if ($val < 0x7f) $ret .= chr($val);
					else if($val < 0x800) $ret .= chr(0xc0|($val>>6)).chr(0x80|($val&0x3f));
					else $ret .= chr(0xe0|($val>>12)).chr(0x80|(($val>>6)&0x3f)).chr(0x80|($val&0x3f));
					$i += 5;
				}
				else if ($str[$i] == '%'){
					$ret .= urldecode(substr($str, $i, 3));
					$i += 2;
				}
				else $ret .= $str[$i];
			}
			return $ret;
		} 
		
		//escape加密
		public function escape($string, $in_encoding = 'UTF-8',$out_encoding = 'UCS-2') { 
			$return = ''; 
			if (function_exists('mb_get_info')) { 
				for($x = 0; $x < mb_strlen ( $string, $in_encoding ); $x ++) { 
					$str = mb_substr ( $string, $x, 1, $in_encoding ); 
					if (strlen ( $str ) > 1) { // 多字节字符 
						$return .= '%u' . strtoupper ( bin2hex ( mb_convert_encoding ( $str, $out_encoding, $in_encoding ) ) ); 
					} else { 
						$return .= '%' . strtoupper ( bin2hex ( $str ) ); 
					} 
				} 
			} 
			return $return; 
		}
		
		//URL解码为utf8
		public function utf8RawUrlDecode ($source) {
		   $decodedStr = "";
		   $pos = 0;
		   $len = strlen ($source);
		   while ($pos < $len) {
		       $charAt = substr ($source, $pos, 1);
		       if ($charAt == '%') {
		           $pos++;
		           $charAt = substr ($source, $pos, 1);
		           if ($charAt == 'u') {
		               $pos++;
		               $unicodeHexVal = substr ($source, $pos, 4);
		               $unicode = hexdec ($unicodeHexVal);
		               $entity = "&#". $unicode . ';';
		               $decodedStr .= utf8_encode ($entity);
		               $pos += 4;
		           }
		           else {
		               $hexVal = substr ($source, $pos, 2);
		               $decodedStr .= chr (hexdec ($hexVal));
		               $pos += 2;
		           }
		       } else {
		           $decodedStr .= $charAt;
		           $pos++;
		       }
		   }
		   return $decodedStr;
		}

		//生成缓存
		public function CreateCache($Flag,$Data,$CacheTime=Web_CacheTime){
			$Lifetime = 60*60*intval($CacheTime);
			$frontendOptions = array('caching' => TRUE,'lifetime' => $Lifetime,'automatic_serialization'=>true);
			$backendOptions = array('cache_dir' => './application/modules/default/cache');
			$cache = Zend_Cache::factory('Core', 'File', $frontendOptions ,$backendOptions);
			if(!$cache->load($Flag)){
				$cache->save($Data, $Flag);
			}
		}
		
		//读取缓存
		public function GetCache($Flag,$CacheTime=Web_CacheTime){
			$Lifetime = 60*60*intval($CacheTime);
			$frontendOptions = array('caching' => TRUE,'lifetime' => $Lifetime,'automatic_serialization'=>true);
			$backendOptions = array('cache_dir' => './application/modules/default/cache');
			$cache = Zend_Cache::factory('Core', 'File', $frontendOptions ,$backendOptions);
			return $cache->load($Flag);
		}
	
		//获取时期的时间差
		public function GetTimeDiff($Edate,$Sdate){
			$Date_List_e=explode("-",$Edate);  
			$Date_List_s=explode("-",$Sdate);  
			$d1=mktime(0,0,0,$Date_List_e[1],$Date_List_e[2],$Date_List_e[0]);  
			$d2=mktime(0,0,0,$Date_List_s[1],$Date_List_s[2],$Date_List_s[0]);  
			return round(($d1-$d2)/3600/24);  
		}
		
		//替换字符串中的系统关键字
        public function ReplaceKeywords($OrgStr,ModelClass $Model){
        	$SystemKeywords = array(ModelClass::$WebName=>'{WebName}',
        							$Model->CityName=>'{CityName}',
        							$Model->HAreaName=>'{HAreaName}',
        							$Model->ChainName=>'{ChainName}',
        							$Model->StarName=>'{StarName}',
        							$Model->Price=>'{Price}',
        							ModelClass::$MainCityName=>'{MainCityName}',
        							$Model->HName=>'{HotelName}',
        							$Model->CityName=>'{CityName}',
        							$Model->HAddressName=>'{HAddressName}',
        							$Model->ARName=>'{ARName}',
        							$Model->ChainName=>'{ChainName}',
        							$Model->HAroundName=>'{HAroundName}',
        							$Model->CurrentPage=>'{CurrentPage}');
        	$NewStr = $OrgStr;
        	preg_match_all('/{.*?}/',$OrgStr,$Keywords);
        	foreach($Keywords as $keyword){
        		foreach($keyword as $val){
        			$NewStr = str_replace($val, array_search($val,$SystemKeywords), $NewStr);
        		}
        	}
        	unset($SystemKeywords);
        	return $NewStr;
        }
        
        //清楚目录中的所有文件true为成功，false失败
		public function DeleteDir($Directory){
			$Flag = false;
		 	if(is_dir($Directory)){
		 		$handle = openDir($Directory);
				 while(($file_name = readdir($handle))!==false){
		  			$file_path = $Directory.DIRECTORY_SEPARATOR.$file_name;
		  			if($file_name!="." && $file_name!=".."){
		   				if(is_dir($file_path)){
		    				$this->DeleteDir($file_path);
		   				}else{
						    if(unlink($file_path)){
						    	$Flag = true;
						    }
		   				}
		  			}
		 		}
		 		closedir($handle);
			}
			return $Flag;
		}
	}
?>