<?php
    class Templater extends Zend_View_Abstract
    {
        protected $_path;
        protected $_engine;

        public function __construct($moduleName)
        {
           require 'Smarty'.DIRECTORY_SEPARATOR.'Smarty.class.php';
           $this->_engine = new Smarty();
           $this->_engine->use_sub_dirs = false;
           $this->_engine->caching = false;
           $this->_engine->compile_check = false;  //正式发布时使用false，调试时使用true
           $this->_engine->template_dir  = ROOT_DIR.DIRECTORY_SEPARATOR.'application'.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.$moduleName.DIRECTORY_SEPARATOR.'views';
           $this->_engine->compile_dir = ROOT_DIR.DIRECTORY_SEPARATOR.'application'.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.$moduleName.DIRECTORY_SEPARATOR.'templates_c';
           $this->_engine->plugins_dir = array(ROOT_DIR.DIRECTORY_SEPARATOR.'library'.DIRECTORY_SEPARATOR.'custom'.DIRECTORY_SEPARATOR.'controller'.DIRECTORY_SEPARATOR.'plugin','plugins');
        }

        public function getEngine()
        {
            return $this->_engine;
        }

        public function __set($key, $val)
        {
            $this->_engine->assign($key, $val);
        }

        public function __get($key)
        {
            return $this->_engine->get_template_vars($key);
        }

        public function __isset($key)
        {
            return $this->_engine->get_template_vars($key) !== null;
        }

        public function __unset($key)
        {
            $this->_engine->clear_assign($key);
        }

        public function assign($spec, $value = null)
        {
            if (is_array($spec)) {
                $this->_engine->assign($spec);
                return;
            }

            $this->_engine->assign($spec, $value);
        }

        public function clearVars()
        {
            $this->_engine->clear_all_assign();
        }

        public function render($name)
        {
            return $this->_engine->fetch(strtolower($name));
        }

        public function _run()
        { }
    }
?>