<?php
//require_once 'Zend/Config.php';

class Zend_Config_Ini extends Zend_Config
{
    public function __construct($filename, $allowModifications = false)
    {  
        $iniArray = $this->_loadIniFile($filename);
        
        $dataArray = array();
        foreach ($iniArray as $sectionName => $sectionData) {
           if(!is_array($sectionData)) {
               $dataArray = $this->_arrayMergeRecursive($dataArray, array($sectionName=>$sectionData));
           } else {
               throw new Zend_Exception('The data format is not correct in '.$filename);
           }
        }
        parent::__construct($dataArray, $allowModifications);
    }
    
    //加载配置文件并返回数组形式的数据
	protected function _loadIniFile($filename)
    {
        $loaded = parse_ini_file($filename, true);
        $iniArray = array();
        foreach ($loaded as $key => $data)
        {
            $pieces = explode(':', $key);
            $iniArray[trim($pieces[0])] = $data;
        }
        return $iniArray;
    }
}