<?php
abstract class Zend_Config_Writer
{
    protected $_skipOptions = array('options');
    protected $_config = null;

    public function __construct(array $options = null)
    {
        if (is_array($options)) {
            $this->setOptions($options);
        }
    }

    public function setConfig(Zend_Config $config)
    {
        $this->_config = $config;

        return $this;
    }

    public function setOptions(array $options)
    {
        foreach ($options as $key => $value) {
            if (in_array(strtolower($key), $this->_skipOptions)) {
                continue;
            }

            $method = 'set' . ucfirst($key);
            if (method_exists($this, $method)) {
                $this->$method($value);
            }
        }

        return $this;
    }

    abstract public function write();
}
