<?php
/*require_once "Zend/Config/Writer.php";*/

class Zend_Config_Writer_FileAbstract extends Zend_Config_Writer
{
    protected $_filename = null;
    protected $_exclusiveLock = false;

    public function setFilename($filename)
    {
        $this->_filename = $filename;

        return $this;
    }

    public function setExclusiveLock($exclusiveLock)
    {
        $this->_exclusiveLock = $exclusiveLock;

        return $this;
    }

    public function write($filename = null, Zend_Config $config = null, $exclusiveLock = null)
    {
        if ($filename !== null) {
            $this->setFilename($filename);
        }

        if ($config !== null) {
            $this->setConfig($config);
        }

        if ($exclusiveLock !== null) {
            $this->setExclusiveLock($exclusiveLock);
        }

        if ($this->_filename === null) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('No filename was set');
        }

        if ($this->_config === null) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('No config was set');
        }

        $configString = $this->render();

        $flags = 0;

        if ($this->_exclusiveLock) {
            $flags |= LOCK_EX;
        }

        $result = @file_put_contents($this->_filename, $configString, $flags);

        if ($result === false) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('Could not write to file "' . $this->_filename . '"');
        }
    }

    public function render()
    {
        return "";
    }
}