<?php
/*require_once 'Zend/Controller/Action.php';*/

abstract class Zend_Controller_Action_Helper_Abstract
{
    protected $_actionController = null;
    protected $_frontController = null;

    public function setActionController(Zend_Controller_Action $actionController = null)
    {
        $this->_actionController = $actionController;
        return $this;
    }

    public function getActionController()
    {
        return $this->_actionController;
    }

    public function getFrontController()
    {
        return Zend_Controller_Front::getInstance();
    }

    public function init(){}

    public function preDispatch(){}

    public function postDispatch(){}

    public function getRequest()
    {
        $controller = $this->getActionController();
        if (null === $controller) {
            $controller = $this->getFrontController();
        }

        return $controller->getRequest();
    }

    public function getResponse()
    {
        $controller = $this->getActionController();
        if (null === $controller) {
            $controller = $this->getFrontController();
        }

        return $controller->getResponse();
    }

    public function getName()
    {
        $fullClassName = get_class($this);
        if (strpos($fullClassName, '_') !== false) {
            $helperName = strrchr($fullClassName, '_');
            return ltrim($helperName, '_');
        } elseif (strpos($fullClassName, '\\') !== false) {
            $helperName = strrchr($fullClassName, '\\');
            return ltrim($helperName, '\\');
        } else {
            return $fullClassName;
        }
    }
}
