<?php
/*require_once 'Zend/Controller/Dispatcher/Interface.php';*/

abstract class Zend_Controller_Dispatcher_Abstract implements Zend_Controller_Dispatcher_Interface
{
    protected $_defaultAction = 'index';
    protected $_defaultController = 'index';
    protected $_defaultModule = 'default';
    protected $_frontController;
    protected $_invokeParams = array();
    protected $_pathDelimiter = '_';
    protected $_response = null;
    protected $_wordDelimiter = array('-', '.');
    
    public function __construct(array $params = array())
    {
        $this->setParams($params);
    }
    
    public function formatControllerName($unformatted)
    {
        return ucfirst($this->_formatName($unformatted)) . 'Controller';
    }

    public function formatActionName($unformatted)
    {
        $formatted = $this->_formatName($unformatted, true);
        return strtolower(substr($formatted, 0, 1)) . substr($formatted, 1) . 'Action';
    }

    public function _verifyDelimiter($spec)
    {
        if (is_string($spec)) {
            return (array) $spec;
        } elseif (is_array($spec)) {
            $allStrings = true;
            foreach ($spec as $delim) {
                if (!is_string($delim)) {
                    $allStrings = false;
                    break;
                }
            }

            if (!$allStrings) {
                //require_once 'Zend/Exception.php';
                throw new Zend_Exception('Word delimiter array must contain only strings');
            }

            return $spec;
        }

        //require_once 'Zend/Exception.php';
        throw new Zend_Exception('Invalid word delimiter');
    }

    public function getWordDelimiter()
    {
        return $this->_wordDelimiter;
    }

    public function setWordDelimiter($spec)
    {
        $spec = $this->_verifyDelimiter($spec);
        $this->_wordDelimiter = $spec;

        return $this;
    }

    public function getPathDelimiter()
    {
        return $this->_pathDelimiter;
    }

    public function setPathDelimiter($spec)
    {
        if (!is_string($spec)) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('Invalid path delimiter');
        }
        $this->_pathDelimiter = $spec;

        return $this;
    }

    protected function _formatName($unformatted, $isAction = false)
    {
        if (!$isAction) {
            $segments = explode($this->getPathDelimiter(), $unformatted);
        } else {
            $segments = (array) $unformatted;
        }

        foreach ($segments as $key => $segment) {
            $segment        = str_replace($this->getWordDelimiter(), ' ', strtolower($segment));
            $segment        = preg_replace('/[^a-z0-9 ]/', '', $segment);
            $segments[$key] = str_replace(' ', '', ucwords($segment));
        }

        return implode('_', $segments);
    }

    public function getFrontController()
    {
        if (null === $this->_frontController) {
            //require_once 'Zend/Controller/Front.php';
            $this->_frontController = Zend_Controller_Front::getInstance();
        }

        return $this->_frontController;
    }

    public function setFrontController(Zend_Controller_Front $controller)
    {
        $this->_frontController = $controller;
        return $this;
    }

    public function setParam($name, $value)
    {
        $name = (string) $name;
        $this->_invokeParams[$name] = $value;
        return $this;
    }

    public function setParams(array $params)
    {
        $this->_invokeParams = array_merge($this->_invokeParams, $params);
        return $this;
    }

    public function getParam($name)
    {
        if(isset($this->_invokeParams[$name])) {
            return $this->_invokeParams[$name];
        }

        return null;
    }

    public function getParams()
    {
        return $this->_invokeParams;
    }

    public function clearParams($name = null)
    {
        if (null === $name) {
            $this->_invokeParams = array();
        } elseif (is_string($name) && isset($this->_invokeParams[$name])) {
            unset($this->_invokeParams[$name]);
        } elseif (is_array($name)) {
            foreach ($name as $key) {
                if (is_string($key) && isset($this->_invokeParams[$key])) {
                    unset($this->_invokeParams[$key]);
                }
            }
        }

        return $this;
    }

    public function setResponse(Zend_Controller_Response_Abstract $response = null)
    {
        $this->_response = $response;
        return $this;
    }

    public function getResponse()
    {
        return $this->_response;
    }

    public function setDefaultControllerName($controller)
    {
        $this->_defaultController = (string) $controller;
        return $this;
    }

    public function getDefaultControllerName()
    {
        return $this->_defaultController;
    }

    public function setDefaultAction($action)
    {
        $this->_defaultAction = (string) $action;
        return $this;
    }

    public function getDefaultAction()
    {
        return $this->_defaultAction;
    }

    public function setDefaultModule($module)
    {
        $this->_defaultModule = (string) $module;
        return $this;
    }

    public function getDefaultModule()
    {
        return $this->_defaultModule;
    }
}