<?php
/*require_once 'Zend/Controller/Plugin/Abstract.php';*/

class Zend_Controller_Plugin_ErrorHandler extends Zend_Controller_Plugin_Abstract
{
    const EXCEPTION_NO_CONTROLLER = 'EXCEPTION_NO_CONTROLLER';
    const EXCEPTION_NO_ACTION = 'EXCEPTION_NO_ACTION';
    const EXCEPTION_NO_ROUTE = 'EXCEPTION_NO_ROUTE';
    const EXCEPTION_OTHER = 'EXCEPTION_OTHER';
    
    protected $_errorModule;
    protected $_errorController = 'error';
    protected $_errorAction = 'error';
    protected $_isInsideErrorHandlerLoop = false;
    protected $_exceptionCountAtFirstEncounter = 0;

    public function __construct(Array $options = array())
    {
        $this->setErrorHandler($options);
    }

    public function setErrorHandler(Array $options = array())
    {
        if (isset($options['module'])) {
            $this->setErrorHandlerModule($options['module']);
        }
        if (isset($options['controller'])) {
            $this->setErrorHandlerController($options['controller']);
        }
        if (isset($options['action'])) {
            $this->setErrorHandlerAction($options['action']);
        }
        return $this;
    }

    public function setErrorHandlerModule($module)
    {
        $this->_errorModule = (string) $module;
        return $this;
    }

    public function getErrorHandlerModule()
    {
        if (null === $this->_errorModule) {
            $this->_errorModule = Zend_Controller_Front::getInstance()->getDispatcher()->getDefaultModule();
        }
        return $this->_errorModule;
    }

    public function setErrorHandlerController($controller)
    {
        $this->_errorController = (string) $controller;
        return $this;
    }

    public function getErrorHandlerController()
    {
        return $this->_errorController;
    }

    public function setErrorHandlerAction($action)
    {
        $this->_errorAction = (string) $action;
        return $this;
    }

    public function getErrorHandlerAction()
    {
        return $this->_errorAction;
    }

    public function routeShutdown(Zend_Controller_Request_Abstract $request)
    {
        $this->_handleError($request);
    }

    public function preDispatch(Zend_Controller_Request_Abstract $request)
    {
        $this->_handleError($request);
    }
	
    public function postDispatch(Zend_Controller_Request_Abstract $request)
    {
        $this->_handleError($request);
    }

    protected function _handleError(Zend_Controller_Request_Abstract $request)
    {
        $frontController = Zend_Controller_Front::getInstance();
        if ($frontController->getParam('noErrorHandler')) {
            return;
        }

        $response = $this->getResponse();

        if ($this->_isInsideErrorHandlerLoop) {
            $exceptions = $response->getException();
            if (count($exceptions) > $this->_exceptionCountAtFirstEncounter) {
                $frontController->throwExceptions(true);
                throw array_pop($exceptions);
            }
        }

        if (($response->isException()) && (!$this->_isInsideErrorHandlerLoop)) {
            $this->_isInsideErrorHandlerLoop = true;

            $error            = new ArrayObject(array(), ArrayObject::ARRAY_AS_PROPS);
            $exceptions       = $response->getException();
            $exception        = $exceptions[0];
            $exceptionType    = get_class($exception);
            $error->exception = $exception;
            switch ($exceptionType) {
                case 'Zend_Controller_Router_Exception':
                    if (404 == $exception->getCode()) {
                        $error->type = self::EXCEPTION_NO_ROUTE;
                    } else {
                        $error->type = self::EXCEPTION_OTHER;
                    }
                    break;
                case 'Zend_Controller_Dispatcher_Exception':
                    $error->type = self::EXCEPTION_NO_CONTROLLER;
                    break;
                case 'Zend_Controller_Action_Exception':
                    if (404 == $exception->getCode()) {
                        $error->type = self::EXCEPTION_NO_ACTION;
                    } else {
                        $error->type = self::EXCEPTION_OTHER;
                    }
                    break;
                default:
                    $error->type = self::EXCEPTION_OTHER;
                    break;
            }

            $error->request = clone $request;
            $this->_exceptionCountAtFirstEncounter = count($exceptions);
            $request->setParam('error_handler', $error)
                    ->setModuleName($this->getErrorHandlerModule())
                    ->setControllerName($this->getErrorHandlerController())
                    ->setActionName($this->getErrorHandlerAction())
                    ->setDispatched(false);
        }
    }
}