<?php
/*require_once 'Zend/Controller/Request/Http.php';*/

class Zend_Controller_Request_HttpTestCase extends Zend_Controller_Request_Http
{
    protected $_headers = array();
    protected $_method = 'GET';
    protected $_rawBody;
    protected $_validMethodTypes = array(
        'DELETE',
        'GET',
        'HEAD',
        'OPTIONS',
        'POST',
        'PUT',
    );

    public function clearQuery()
    {
        $_GET = array();
        return $this;
    }

    public function clearPost()
    {
        $_POST = array();
        return $this;
    }

    public function setRawBody($content)
    {
        $this->_rawBody = (string) $content;
        return $this;
    }

    public function getRawBody()
    {
        return $this->_rawBody;
    }

    public function clearRawBody()
    {
        $this->_rawBody = null;
        return $this;
    }

    public function setCookie($key, $value)
    {
        $_COOKIE[(string) $key] = $value;
        return $this;
    }

    public function setCookies(array $cookies)
    {
        foreach ($cookies as $key => $value) {
            $_COOKIE[$key] = $value;
        }
        return $this;
    }

    public function clearCookies()
    {
        $_COOKIE = array();
        return $this;
    }

    public function setMethod($type)
    {
        $type = strtoupper(trim((string) $type));
        if (!in_array($type, $this->_validMethodTypes)) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('Invalid request method specified');
        }
        $this->_method = $type;
        return $this;
    }

    public function getMethod()
    {
        return $this->_method;
    }

    public function setHeader($key, $value)
    {
        $key = $this->_normalizeHeaderName($key);
        $this->_headers[$key] = (string) $value;
        return $this;
    }

    public function setHeaders(array $headers)
    {
        foreach ($headers as $key => $value) {
            $this->setHeader($key, $value);
        }
        return $this;
    }

    public function getHeader($header, $default = null)
    {
        $header = $this->_normalizeHeaderName($header);
        if (array_key_exists($header, $this->_headers)) {
            return $this->_headers[$header];
        }
        return $default;
    }

    public function getHeaders()
    {
        return $this->_headers;
    }

    public function clearHeaders()
    {
        $this->_headers = array();
        return $this;
    }

    public function getRequestUri()
    {
        return $this->_requestUri;
    }

    protected function _normalizeHeaderName($name)
    {
        $name = strtoupper((string) $name);
        $name = str_replace('-', '_', $name);
        return $name;
    }
}