<?php
//require_once 'Zend/Controller/Router/Interface.php';

abstract class Zend_Controller_Router_Abstract implements Zend_Controller_Router_Interface
{
    const URI_DELIMITER = '/';
    
    protected $_frontController;
    protected $_invokeParams = array();
    public function __construct(array $params = array())
    {
        $this->setParams($params);
    }

    public function setParam($name, $value)
    {
        $name = (string) $name;
        $this->_invokeParams[$name] = $value;
        return $this;
    }

    public function setParams(array $params)
    {
        $this->_invokeParams = array_merge($this->_invokeParams, $params);
        return $this;
    }

    public function getParam($name)
    {
        if(isset($this->_invokeParams[$name])) {
            return $this->_invokeParams[$name];
        }

        return null;
    }

    public function getParams()
    {
        return $this->_invokeParams;
    }

    public function clearParams($name = null)
    {
        if (null === $name) {
            $this->_invokeParams = array();
        } elseif (is_string($name) && isset($this->_invokeParams[$name])) {
            unset($this->_invokeParams[$name]);
        } elseif (is_array($name)) {
            foreach ($name as $key) {
                if (is_string($key) && isset($this->_invokeParams[$key])) {
                    unset($this->_invokeParams[$key]);
                }
            }
        }

        return $this;
    }

    public function getFrontController()
    {
        if (null !== $this->_frontController) {
            return $this->_frontController;
        }

        //require_once 'Zend/Controller/Front.php';
        $this->_frontController = Zend_Controller_Front::getInstance();
        return $this->_frontController;
    }

    public function setFrontController(Zend_Controller_Front $controller)
    {
        $this->_frontController = $controller;
        return $this;
    }

}