<?php
//require_once 'Zend/Controller/Router/Route/Interface.php';

abstract class Zend_Controller_Router_Route_Abstract implements Zend_Controller_Router_Route_Interface
{
    const URI_DELIMITER = '/';
    protected $_isAbstract = false;
    protected $_matchedPath = null;
    
    public function getVersion()
    {
        return 2;
    }
    
    public function setMatchedPath($path)
    {
        $this->_matchedPath = $path;
    }
    
    public function getMatchedPath()
    {
        return $this->_matchedPath;
    }

    public function isAbstract($flag = null)
    {
        if ($flag !== null) {
            $this->_isAbstract = $flag;
        }

        return $this->_isAbstract;
    }

    public function chain(Zend_Controller_Router_Route_Abstract $route, $separator = '/')
    {
        //require_once 'Zend/Controller/Router/Route/Chain.php';

        $chain = new Zend_Controller_Router_Route_Chain();
        $chain->chain($this)->chain($route, $separator);

        return $chain;
    }

}