<?php
//require_once 'Zend/Controller/Router/Route/Abstract.php';

class Zend_Controller_Router_Route_Static extends Zend_Controller_Router_Route_Abstract
{

    protected $_route = null;
    protected $_defaults = array();

    public function getVersion() {
        return 1;
    }

    public static function getInstance(Zend_Config $config)
    {
        $defs = ($config->defaults instanceof Zend_Config) ? $config->defaults->toArray() : array();
        return new self($config->route, $defs);
    }

    public function __construct($route, $defaults = array())
    {
        $this->_route = trim($route, self::URI_DELIMITER);
        $this->_defaults = (array) $defaults;
    }

    public function match($path, $partial = false)
    {
        if ($partial) {
            if ((empty($path) && empty($this->_route))
                || (substr($path, 0, strlen($this->_route)) === $this->_route)
            ) {
                $this->setMatchedPath($this->_route);
                return $this->_defaults;
            }
        } else {
            if (trim($path, self::URI_DELIMITER) == $this->_route) {
                return $this->_defaults;
            }
        }

        return false;
    }

    public function assemble($data = array(), $reset = false, $encode = false, $partial = false)
    {
        return $this->_route;
    }

    public function getDefault($name) {
        if (isset($this->_defaults[$name])) {
            return $this->_defaults[$name];
        }
        return null;
    }

    public function getDefaults() {
        return $this->_defaults;
    }

}