<?php
//require_once 'Zend/Filter/Interface.php';

class Zend_Filter_PregReplace implements Zend_Filter_Interface
{
    protected $_matchPattern = null;
    protected $_replacement = '';
    static protected $_unicodeSupportEnabled = null;
    
    static public function isUnicodeSupportEnabled()
    {
        if (self::$_unicodeSupportEnabled === null) {
            self::_determineUnicodeSupport();
        }

        return self::$_unicodeSupportEnabled;
    }

    static protected function _determineUnicodeSupport()
    {
        self::$_unicodeSupportEnabled = (@preg_match('/\pL/u', 'a')) ? true : false;
    }

    public function __construct($options = null)
    {
        if ($options instanceof Zend_Config) {
            $options = $options->toArray();
        } else if (!is_array($options)) {
            $options = func_get_args();
            $temp    = array();
            if (!empty($options)) {
                $temp['match'] = array_shift($options);
            }

            if (!empty($options)) {
                $temp['replace'] = array_shift($options);
            }

            $options = $temp;
        }

        if (array_key_exists('match', $options)) {
            $this->setMatchPattern($options['match']);
        }

        if (array_key_exists('replace', $options)) {
            $this->setReplacement($options['replace']);
        }
    }

    public function setMatchPattern($match)
    {
        $this->_matchPattern = $match;
        return $this;
    }

    public function getMatchPattern()
    {
        return $this->_matchPattern;
    }

    public function setReplacement($replacement)
    {
        $this->_replacement = $replacement;
        return $this;
    }

    public function getReplacement()
    {
        return $this->_replacement;
    }

    public function filter($value)
    {
        if ($this->_matchPattern == null) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception(get_class($this) . ' does not have a valid MatchPattern set.');
        }

        return preg_replace($this->_matchPattern, $this->_replacement, $value);
    }

}