<?php
class Zend_Http_Response_Stream extends Zend_Http_Response
{
    protected $stream;
    protected $stream_name;
    protected $_cleanup;

    public function getStream()
    {
        return $this->stream;
    }

    public function setStream($stream)
    {
        $this->stream = $stream;
        return $this;
    }

    public function getCleanup() {
        return $this->_cleanup;
    }

    public function setCleanup($cleanup = true) {
        $this->_cleanup = $cleanup;
    }

    public function getStreamName() {
        return $this->stream_name;
    }

    public function setStreamName($stream_name) {
        $this->stream_name = $stream_name;
        return $this;
    }

    public function __construct($code, $headers, $body = null, $version = '1.1', $message = null)
    {

        if(is_resource($body)) {
            $this->setStream($body);
            $body = '';
        }
        parent::__construct($code, $headers, $body, $version, $message);
    }
    
    public static function fromStream($response_str, $stream)
    {
        $code    = self::extractCode($response_str);
        $headers = self::extractHeaders($response_str);
        $version = self::extractVersion($response_str);
        $message = self::extractMessage($response_str);

        return new self($code, $headers, $stream, $version, $message);
    }

    public function getBody()
    {
        if($this->stream != null) {
            $this->readStream();
        }
        return parent::getBody();
    }

    public function getRawBody()
    {
        if($this->stream) {
            $this->readStream();
        }
        return $this->body;
    }

    protected function readStream()
    {
        if(!is_resource($this->stream)) {
            return '';
        }

        if(isset($headers['content-length'])) {
            $this->body = stream_get_contents($this->stream, $headers['content-length']);
        } else {
            $this->body = stream_get_contents($this->stream);
        }
        fclose($this->stream);
        $this->stream = null;
    }

    public function __destruct()
    {
        if(is_resource($this->stream)) {
            fclose($this->stream);
            $this->stream = null;
        }
        if($this->_cleanup) {
            @unlink($this->stream_name);
        }
    }

}