<?php
/*require_once 'Zend/Loader/Autoloader/Interface.php';*/

class Zend_Loader_Autoloader_Resource implements Zend_Loader_Autoloader_Interface
{
    protected $_basePath;
    protected $_components = array();
    protected $_defaultResourceType;
    protected $_namespace;
    protected $_resourceTypes = array();

    public function __construct($options)
    {
        if ($options instanceof Zend_Config) {
            $options = $options->toArray();
        }
        if (!is_array($options)) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('Options must be passed to resource loader constructor');
        }

        $this->setOptions($options);

        $namespace = $this->getNamespace();
        if ((null === $namespace)
            || (null === $this->getBasePath())
        ) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('Resource loader requires both a namespace and a base path for initialization');
        }

        if (!empty($namespace)) {
            $namespace .= '_';
        }
        //require_once 'Zend/Loader/Autoloader.php';
        Zend_Loader_Autoloader::getInstance()->unshiftAutoloader($this, $namespace);
    }

    public function __call($method, $args)
    {
        if ('get' == substr($method, 0, 3)) {
            $type  = strtolower(substr($method, 3));
            if (!$this->hasResourceType($type)) {
                //require_once 'Zend/Exception.php';
                throw new Zend_Exception("Invalid resource type $type; cannot load resource");
            }
            if (empty($args)) {
                //require_once 'Zend/Exception.php';
                throw new Zend_Exception("Cannot load resources; no resource specified");
            }
            $resource = array_shift($args);
            return $this->load($resource, $type);
        }

        //require_once 'Zend/Exception.php';
        throw new Zend_Exception("Method '$method' is not supported");
    }

    public function getClassPath($class)
    {
        $segments          = explode('_', $class);
        $namespaceTopLevel = $this->getNamespace();
        $namespace         = '';

        if (!empty($namespaceTopLevel)) {
            $namespace = array();
            $topLevelSegments = count(explode('_', $namespaceTopLevel));
            for ($i = 0; $i < $topLevelSegments; $i++) {
                $namespace[] = array_shift($segments);
            }
            $namespace = implode('_', $namespace);
            if ($namespace != $namespaceTopLevel) {
                return false;
            }
        }

        if (count($segments) < 2) {
            return false;
        }

        $final     = array_pop($segments);
        $component = $namespace;
        $lastMatch = false;
        do {
            $segment    = array_shift($segments);
            $component .= empty($component) ? $segment : '_' . $segment;
            if (isset($this->_components[$component])) {
                $lastMatch = $component;
            }
        } while (count($segments));

        if (!$lastMatch) {
            return false;
        }

        $final = substr($class, strlen($lastMatch) + 1);
        $path = $this->_components[$lastMatch];
        $classPath = $path . '/' . str_replace('_', '/', $final) . '.php';

        if (Zend_Loader::isReadable($classPath)) {
            return $classPath;
        }

        return false;
    }

    public function autoload($class)
    {
        $classPath = $this->getClassPath($class);
        if (false !== $classPath) {
            return include $classPath;
        }
        return false;
    }

    public function setOptions(array $options)
    {
        if (isset($options['namespace'])) {
            $this->setNamespace($options['namespace']);
            unset($options['namespace']);
        }

        $methods = get_class_methods($this);
        foreach ($options as $key => $value) {
            $method = 'set' . ucfirst($key);
            if (in_array($method, $methods)) {
                $this->$method($value);
            }
        }
        return $this;
    }

    public function setNamespace($namespace)
    {
        $this->_namespace = rtrim((string) $namespace, '_');
        return $this;
    }

    public function getNamespace()
    {
        return $this->_namespace;
    }

    public function setBasePath($path)
    {
        $this->_basePath = (string) $path;
        return $this;
    }

    public function getBasePath()
    {
        return $this->_basePath;
    }

    public function addResourceType($type, $path, $namespace = null)
    {
        $type = strtolower($type);
        if (!isset($this->_resourceTypes[$type])) {
            if (null === $namespace) {
                //require_once 'Zend/Exception.php';
                throw new Zend_Exception('Initial definition of a resource type must include a namespace');
            }
            $namespaceTopLevel = $this->getNamespace();
            $namespace = ucfirst(trim($namespace, '_'));
            $this->_resourceTypes[$type] = array(
                'namespace' => empty($namespaceTopLevel) ? $namespace : $namespaceTopLevel . '_' . $namespace,
            );
        }
        if (!is_string($path)) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('Invalid path specification provided; must be string');
        }
        $this->_resourceTypes[$type]['path'] = $this->getBasePath() . '/' . rtrim($path, '\/');

        $component = $this->_resourceTypes[$type]['namespace'];
        $this->_components[$component] = $this->_resourceTypes[$type]['path'];
        return $this;
    }

    public function addResourceTypes(array $types)
    {
        foreach ($types as $type => $spec) {
            if (!is_array($spec)) {
                //require_once 'Zend/Exception.php';
                throw new Zend_Exception('addResourceTypes() expects an array of arrays');
            }
            if (!isset($spec['path'])) {
                //require_once 'Zend/Exception.php';
                throw new Zend_Exception('addResourceTypes() expects each array to include a paths element');
            }
            $paths  = $spec['path'];
            $namespace = null;
            if (isset($spec['namespace'])) {
                $namespace = $spec['namespace'];
            }
            $this->addResourceType($type, $paths, $namespace);
        }
        return $this;
    }

    public function setResourceTypes(array $types)
    {
        $this->clearResourceTypes();
        return $this->addResourceTypes($types);
    }

    public function getResourceTypes()
    {
        return $this->_resourceTypes;
    }

    public function hasResourceType($type)
    {
        return isset($this->_resourceTypes[$type]);
    }

    public function removeResourceType($type)
    {
        if ($this->hasResourceType($type)) {
            $namespace = $this->_resourceTypes[$type]['namespace'];
            unset($this->_components[$namespace]);
            unset($this->_resourceTypes[$type]);
        }
        return $this;
    }

    public function clearResourceTypes()
    {
        $this->_resourceTypes = array();
        $this->_components    = array();
        return $this;
    }

    public function setDefaultResourceType($type)
    {
        if ($this->hasResourceType($type)) {
            $this->_defaultResourceType = $type;
        }
        return $this;
    }

    public function getDefaultResourceType()
    {
        return $this->_defaultResourceType;
    }

    public function load($resource, $type = null)
    {
        if (null === $type) {
            $type = $this->getDefaultResourceType();
            if (empty($type)) {
                //require_once 'Zend/Exception.php';
                throw new Zend_Exception('No resource type specified');
            }
        }
        if (!$this->hasResourceType($type)) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('Invalid resource type specified');
        }
        $namespace = $this->_resourceTypes[$type]['namespace'];
        $class     = $namespace . '_' . ucfirst($resource);
        if (!isset($this->_resources[$class])) {
            $this->_resources[$class] = new $class;
        }
        return $this->_resources[$class];
    }
}