<?php
abstract class Zend_Uri
{
    protected $_scheme = '';
    static protected $_config = array(
        'allow_unwise' => false
    );

    public function __toString()
    {
        try {
            return $this->getUri();
        } catch (Exception $e) {
            trigger_error($e->getMessage(), E_USER_WARNING);
            return '';
        }
    }

    public static function check($uri)
    {
        try {
            $uri = self::factory($uri);
        } catch (Exception $e) {
            return false;
        }

        return $uri->valid();
    }

    public static function factory($uri = 'http', $className = null)
    {
        $uri            = explode(':', $uri, 2);
        $scheme         = strtolower($uri[0]);
        $schemeSpecific = isset($uri[1]) === true ? $uri[1] : '';

        if (strlen($scheme) === 0) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('An empty string was supplied for the scheme');
        }

        if (ctype_alnum($scheme) === false) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception('Illegal scheme supplied, only alphanumeric characters are permitted');
        }

        if ($className === null) {
            switch ($scheme) {
                case 'http':
                case 'https':
                    $className = 'Zend_Uri_Http';
                    break;
                case 'mailto':
                default:
                    //require_once 'Zend/Exception.php';
                    throw new Zend_Exception("Scheme \"$scheme\" is not supported");
                    break;
            }
        }

        //require_once 'Zend/Loader.php';
        try {
            Zend_Loader::loadClass($className);
        } catch (Exception $e) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception("\"$className\" not found");
        }

        $schemeHandler = new $className($scheme, $schemeSpecific);

        if (! $schemeHandler instanceof Zend_Uri) {
            //require_once 'Zend/Exception.php';
            throw new Zend_Exception("\"$className\" is not an instance of Zend_Uri");
        }

        return $schemeHandler;
    }

    public function getScheme()
    {
        if (empty($this->_scheme) === false) {
            return $this->_scheme;
        } else {
            return false;
        }
    }

    static public function setConfig($config)
    {
        if ($config instanceof Zend_Config) {
            $config = $config->toArray();
        } elseif (!is_array($config)) {
            throw new Zend_Exception("Config must be an array or an instance of Zend_Config.");
        }

        foreach ($config as $k => $v) {
            self::$_config[$k] = $v;
        }
    }

    abstract protected function __construct($scheme, $schemeSpecific = '');

    abstract public function getUri();

    abstract public function valid();
}
