<?php
/*require_once 'Zend/Validate/Interface.php';*/

class Zend_Validate implements Zend_Validate_Interface
{
    protected $_validators = array();
    protected $_messages = array();
    protected static $_defaultNamespaces = array();
    protected $_errors = array();

    public function addValidator(Zend_Validate_Interface $validator, $breakChainOnFailure = false)
    {
        $this->_validators[] = array(
            'instance' => $validator,
            'breakChainOnFailure' => (boolean) $breakChainOnFailure
            );
        return $this;
    }

    public function isValid($value)
    {
        $this->_messages = array();
        $this->_errors   = array();
        $result = true;
        foreach ($this->_validators as $element) {
            $validator = $element['instance'];
            if ($validator->isValid($value)) {
                continue;
            }
            $result = false;
            $messages = $validator->getMessages();
            $this->_messages = array_merge($this->_messages, $messages);
            $this->_errors   = array_merge($this->_errors,   array_keys($messages));
            if ($element['breakChainOnFailure']) {
                break;
            }
        }
        return $result;
    }

    public function getMessages()
    {
        return $this->_messages;
    }

    public function getErrors()
    {
        return $this->_errors;
    }

    public static function getDefaultNamespaces()
    {
        return self::$_defaultNamespaces;
    }

    public static function setDefaultNamespaces($namespace)
    {
        if (!is_array($namespace)) {
            $namespace = array((string) $namespace);
        }

        self::$_defaultNamespaces = $namespace;
    }

    public static function addDefaultNamespaces($namespace)
    {
        if (!is_array($namespace)) {
            $namespace = array((string) $namespace);
        }

        self::$_defaultNamespaces = array_unique(array_merge(self::$_defaultNamespaces, $namespace));
    }

    public static function hasDefaultNamespaces()
    {
        return (!empty(self::$_defaultNamespaces));
    }

    public static function is($value, $classBaseName, array $args = array(), $namespaces = array())
    {
        $namespaces = array_merge((array) $namespaces, self::$_defaultNamespaces, array('Zend_Validate'));
        $className  = ucfirst($classBaseName);
        try {
            if (!class_exists($className, false)) {
                //require_once 'Zend/Loader.php';
                foreach($namespaces as $namespace) {
                    $class = $namespace . '_' . $className;
                    $file  = str_replace('_', DIRECTORY_SEPARATOR, $class) . '.php';
                    if (Zend_Loader::isReadable($file)) {
                        Zend_Loader::loadClass($class);
                        $className = $class;
                        break;
                    }
                }
            }

            $class = new ReflectionClass($className);
            if ($class->implementsInterface('Zend_Validate_Interface')) {
                if ($class->hasMethod('__construct')) {
                    $keys    = array_keys($args);
                    $numeric = false;
                    foreach($keys as $key) {
                        if (is_numeric($key)) {
                            $numeric = true;
                            break;
                        }
                    }

                    if ($numeric) {
                        $object = $class->newInstanceArgs($args);
                    } else {
                        $object = $class->newInstance($args);
                    }
                } else {
                    $object = $class->newInstance();
                }

                return $object->isValid($value);
            }
        } catch (Zend_Exception $ze) {
            throw $ze;
        } catch (Exception $e) {}

        //require_once 'Zend/Exception.php';
        throw new Zend_Exception("Validate class not found from basename '$classBaseName'");
    }

    public static function getMessageLength()
    {
        //require_once 'Zend/Validate/Abstract.php';
        return Zend_Validate_Abstract::getMessageLength();
    }

    public static function setMessageLength($length = -1)
    {
        //require_once 'Zend/Validate/Abstract.php';
        Zend_Validate_Abstract::setMessageLength($length);
    }

    public static function getDefaultTranslator($translator = null)
    {
        //require_once 'Zend/Validate/Abstract.php';
        return Zend_Validate_Abstract::getDefaultTranslator();
    }

    public static function setDefaultTranslator($translator = null)
    {
        //require_once 'Zend/Validate/Abstract.php';
        Zend_Validate_Abstract::setDefaultTranslator($translator);
    }
}