<?php
class Zend_View_Stream
{
    protected $_pos = 0;
    protected $_data;
    protected $_stat;

    public function stream_open($path, $mode, $options, &$opened_path)
    {
        $path        = str_replace('zend.view://', '', $path);
        $this->_data = file_get_contents($path);

        if ($this->_data === false) {
            $this->_stat = stat($path);
            return false;
        }

        $this->_data = preg_replace('/\<\?\=/',          "<?php echo ",  $this->_data);
        $this->_data = preg_replace('/<\?(?!xml|php)/s', '<?php ',       $this->_data);
        $this->_stat = stat($path);

        return true;
    }

    public function url_stat()
    {
        return $this->_stat;
    }

    public function stream_read($count)
    {
        $ret = substr($this->_data, $this->_pos, $count);
        $this->_pos += strlen($ret);
        return $ret;
    }

    public function stream_tell()
    {
        return $this->_pos;
    }

    public function stream_eof()
    {
        return $this->_pos >= strlen($this->_data);
    }

    public function stream_stat()
    {
        return $this->_stat;
    }

    public function stream_seek($offset, $whence)
    {
        switch ($whence) {
            case SEEK_SET:
                if ($offset < strlen($this->_data) && $offset >= 0) {
                $this->_pos = $offset;
                    return true;
                } else {
                    return false;
                }
                break;

            case SEEK_CUR:
                if ($offset >= 0) {
                    $this->_pos += $offset;
                    return true;
                } else {
                    return false;
                }
                break;

            case SEEK_END:
                if (strlen($this->_data) + $offset >= 0) {
                    $this->_pos = strlen($this->_data) + $offset;
                    return true;
                } else {
                    return false;
                }
                break;

            default:
                return false;
        }
    }
}