<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
if(ZIBANMA_SYS_LINK != 'zibanma_com'){
	die('access deny');
}
class AdminControl{
	private $_base;
	private $_user_info;
	private $_admin_model;
	private $_config_model;
	private $_news_model;
	private $_pic_model;
	private $_nav_model;
	private $_link_model;
	private $_focus_model;
	
	public function __construct(){
		if(is_object($_SESSION['user_info'])){
			$this->_user_info = $_SESSION['user_info'];
		}else{
			die('access deny');
		}
		$this->zibanma_factory();
	}
	
	private function zibanma_factory(){
		$this->_base = ZibanmaBase::get_instance();
		$this->_admin_model = new AdminModel();
		$this->_config_model = new ConfigModel();
		$this->_news_model = new NewsModel();
		$this->_pic_model = new PicModel();
		$this->_nav_model = new NavigationModel();
		$this->_link_model = new LinkModel();
		$this->_focus_model = new FocusModel();
	}
	
	/**
	 * 后台管理首页
	 */
	public function zibanma_index(){
		$assign = array(
			'url_admin_menu' => $this->_base->_common->get_rewriter_url('admin-menu'),
			'url_admin_main' => $this->_base->_common->get_rewriter_url('admin-main'),
		);
		$this->_base->_view->make('admin.admin_index', $assign);
	}
	
	/**
	 * 后台管理菜单
	 */
	public function zibanma_menu(){
		$assign = array(
			'admin_menu' => $this->_admin_model->zibanma_admin_menu(),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('admin.admin_menu', $assign);
	}
	
	/**
	 * 后台管理默认页
	 */
	public function zibanma_main(){
		$assign = array(
			'today' => date('Y/m/d'),
			'user' => $this->_user_info->user,
			'login_time' => date('Y/m/d H:i:s', $this->_user_info->last_login_time)
		);
		$this->_base->_view->make('admin.admin_main', $assign);
	}
	
	/**
	 * 系统设置
	 */
	public function zibanma_setting(){
		if(($post=$this->_base->_request->post())){
			$post['site_copyright'] = str_replace('©', '&copy;', $post['site_copyright']);
			$config = array(
				'config_id' => 'global',
				'config_content' => $post
			);
			$this->_config_model->zibanma_set_sys_config($config);
			$_SESSION['global']->site_config = $this->_config_model->zibanma_get_sys_config('global');
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url('admin-setting'));
		}else{
			$assign = array(
				'menu_name'=>'系统设置',
				'config_info' => $this->_config_model->zibanma_get_sys_config('global'),
				'common' => $this->_base->_common,
			);
			$this->_base->_view->make('admin.admin_setting', $assign);
		}
	}
	
	/**
	 * 修改密码
	 */
	public function zibanma_password(){
		if(($post=$this->_base->_request->post())){
			if($this->_user_info->password == md5($post['old_password']) && ($password=md5($post['new_password1'])) == md5($post['new_password2'])){
				$status = $this->_admin_model->zibanma_admin_password_modification($this->_user_info->user, $password);
				if($status > 0){
					echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url('admin-password'));
				}else{
					echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url('admin-password'));
				}
			}else{
				echo $this->_base->_common->show_message_url('密码填写错误，请重新填写正确', $this->_base->_common->get_rewriter_url('admin-password'));
			}
		}else{
			$assign = array(
				'menu_name'=>'修改密码',
				'user' => $this->_user_info->user,
			);
			$this->_base->_view->make('admin.admin_password', $assign);
		}
	}
	
	/**
	 * 导航栏
	 */
	public function zibanma_navigation_manage(){
		$assign = array(
			'menu_name' => '导航管理',
			'navigation_list' => $this->_nav_model->zibanma_navigation_list(),
			'http_host' => 'http://'.$_SERVER['HTTP_HOST'].'/',
			'common' => $this->_base->_common,
			'add_post_url' => $this->_base->_common->get_rewriter_url_arr(array('admin','navigation_add')),
		);
		$this->_base->_view->make('admin.navigation_manage', $assign);
	}
	
	/**
	 * 添加导航
	 */
	public function zibanma_navigation_add(){
		$post = $this->_base->_request->post();
		if($post && $this->_nav_model->zibanma_navigation_add($post)){
			$_SESSION['global']->navigation = $this->_nav_model->zibanma_navigation_list();
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','navigation_manage')));
		}else{
			echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','navigation_manage')));
		}
	}
	
	/**
	 * 导航更新排序
	 */
	public function zibanma_navigation_sort(){
		$post=$this->_base->_request->post();
		if(is_numeric($post['id']) && is_numeric($post['value'])){
			$this->_nav_model->zibanma_update_sort($post);
			$_SESSION['global']->navigation = $this->_nav_model->zibanma_navigation_list();
			$arr = array(
				'status'=>'success',
			);
			echo $this->_base->_common->json_create($arr);
		}else{
			$arr = array(
				'status'=>'fail',
			);
			echo $this->_base->_common->json_create($arr);
		}
	}
	
	/**
	 * 导航删除
	 */
	public function zibanma_navigation_delete(){
		$param = $this->_base->_request->get_parameter();
		if($this->_nav_model->zibanma_delete($param[2])){
			$_SESSION['global']->navigation = $this->_nav_model->zibanma_navigation_list();
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','navigation_manage',$param[2])));
		}else{
			echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','navigation_manage',$param[2])));
		}
	}
	
	/**
	 * 退出系统
	 */
	public function zibanma_logout(){
		unset($_SESSION['user_info']);
		echo $this->_base->_common->show_message_url('退出登录成功', '/');
	}
	
	/**
	 * 添加新闻分类
	 */
	public function zibanma_news_category_add(){
		if(($post=$this->_base->_request->post())){
			if($this->_news_model->zibanma_category_add($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url('admin-news_category_add'));
			}else{
				echo $this->_base->_common->show_message_url('操作失败，请重新操作', $this->_base->_common->get_rewriter_url('admin-news_category_add'));
			}
		}else{
			$assign = array(
					'menu_name'=>'添加新闻分类',
			);
			$this->_base->_view->make('admin.news_category_add', $assign);
		}
	}
	
	/**
	 * 管理新闻分类
	 */
	public function zibanma_news_category_manage(){
		$assign = array(
			'menu_name'=>'管理新闻分类',
			'category_list' => $this->_news_model->zibanma_get_category_list(),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('admin.news_category_manage', $assign);
	}
	
	/**
	 * 修改管理分类
	 */
	public function zibanma_news_category_modification(){
		if(($post=$this->_base->_request->post())){
			if($this->_news_model->zibanma_update_category_info($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url('admin-news_category_manage'));
			}else{
				echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url('admin-news_category_manage'));
			}
		}else{
			$param = $this->_base->_request->get_parameter();
			if($param[2]>0){
				$category_info = $this->_news_model->zibanma_get_category_info_by_id($param[2]);
				$assign = array(
					'menu_name'=>'修改新闻分类',
					'category_info' => $category_info[0],
				);
				$this->_base->_view->make('admin.news_category_modification', $assign);
			}
		}
	}
	
	/**
	 * 删除分类
	 */
	public function zibanma_news_category_delete(){
		$param = $this->_base->_request->get_parameter();
		if($this->_news_model->zibanma_delete_category($param[2])){
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url('admin-news_category_manage'));
		}else{
			echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url('admin-news_category_manage'));
		}
	}
	
	/**
	 * 更新排序
	 */
	public function zibanma_news_category_sort(){
		$post=$this->_base->_request->post();
		if(is_numeric($post['id']) && is_numeric($post['value'])){
			$this->_news_model->zibanma_update_category_sort($post);
			$arr = array(
				'status'=>'success',
			);
			echo $this->_base->_common->json_create($arr);
		}else{
			$arr = array(
				'status'=>'fail',
			);
			echo $this->_base->_common->json_create($arr);
		}
	}
	
	/**
	 * 添加文章
	 */
	public function zibanma_news_article_add(){
		if(($post=$this->_base->_request->post())){
			if($this->_news_model->zibanma_article_add($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url('admin-news_article_add'));
			}else{
				echo $this->_base->_common->show_message_url('操作失败，请重新操作', $this->_base->_common->get_rewriter_url('admin-news_article_add'));
			}
		}else{
			$assign = array(
				'menu_name'=>'添加文章',
				'user' => $this->_user_info->user,
				'category_list' => $this->_news_model->zibanma_get_category_list(),
				'common' => $this->_base->_common,
			);
			$this->_base->_view->make('admin.news_article_add', $assign);
		}
	}
	
	/**
	 * 文章管理
	 */
	public function zibanma_news_article_manage(){
		$param = $this->_base->_request->get_parameter();
		$set = $this->_base->_zibanma;
		$set->category_id = $param[2] ? intval($param[2]) : 0;
		$set->page_current = $param[3] ? intval($param[3]) : 1;
		$set->page_size = 20;
		$set->first_limit = $set->page_current * $set->page_size - $set->page_size;
		$set->end_limit = $set->page_size;
		$set->sort = 'desc';
		$set->links = array('admin','news_article_manage');
		$assign = array(
			'menu_name'=>'文章管理',
			'article_list' => $this->_news_model->zibanma_get_article_list($set),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('admin.news_article_manage', $assign);
	}
	
	/**
	 * 文章修改
	 */
	public function zibanma_news_article_modification(){
		if(($post=$this->_base->_request->post())){
			if($this->_news_model->zibanma_update_article_info($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','news_article_manage',$post['category'])));
			}else{
				echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','news_article_manage',$post['category'])));
			}
		}else{
			$param = $this->_base->_request->get_parameter();
			if($param[2]>0){
				$article_info = $this->_news_model->zibanma_get_article_info($param[3]);
				$assign = array(
					'menu_name'=>'修改新闻分类',
					'category_list' => $this->_news_model->zibanma_get_category_list(),
					'article_info' => $article_info[0],
				);
				$this->_base->_view->make('admin.news_article_modification', $assign);
			}
		}
	}
	
	/**
	 * 删除文章
	 */
	public function zibanma_news_article_delete(){
		$param = $this->_base->_request->get_parameter();
		if($this->_news_model->zibanma_article_delete($param[3])){
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','news_article_manage',$param[2])));
		}else{
			echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','news_article_manage',$param[2])));
		}
	}
	
	/**
	 * 管理图片分类
	 */
	public function zibanma_pic_category_manage(){
		$assign = array(
			'menu_name'=>'管理图片分类',
			'category_list' => $this->_pic_model->zibanma_get_category_list(),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('admin.pic_category_manage', $assign);
	}
	
	/**
	 * 添加图片分类
	 */
	public function zibanma_pic_category_add(){
		if(($post=$this->_base->_request->post())){
			if($this->_pic_model->zibanma_category_add($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_category_add')));
			}else{
				echo $this->_base->_common->show_message_url('操作失败，请重新操作', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_category_add')));
			}
		}else{
			$assign = array(
					'menu_name'=>'添加图片分类',
			);
			$this->_base->_view->make('admin.pic_category_add', $assign);
		}
	}
	
	/**
	 * 修改图片分类
	 */
	public function zibanma_pic_category_modification(){
		if(($post=$this->_base->_request->post())){
			if($this->_pic_model->zibanma_update_category_info($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_category_manage')));
			}else{
				echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_category_manage')));
			}
		}else{
			$param = $this->_base->_request->get_parameter();
			if($param[2]>0){
				$category_info = $this->_pic_model->zibanma_get_category_info_by_id($param[2]);
				$assign = array(
					'menu_name'=>'修改图片分类',
					'category_info' => $category_info[0],
				);
				$this->_base->_view->make('admin.pic_category_modification', $assign);
			}
		}
	}
	
	/**
	 * 删除图片分类
	 */
	public function zibanma_pic_category_delete(){
		$param = $this->_base->_request->get_parameter();
		if($this->_pic_model->zibanma_delete_category($param[2])){
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_category_manage')));
		}else{
			echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_category_manage')));
		}
	}
	
	/**
	 * 更新图片分类排序
	 */
	public function zibanma_pic_category_sort(){
		$post=$this->_base->_request->post();
		if(is_numeric($post['id']) && is_numeric($post['value'])){
			$this->_pic_model->zibanma_update_category_sort($post);
			$arr = array(
				'status'=>'success',
			);
			echo $this->_base->_common->json_create($arr);
		}else{
			$arr = array(
				'status'=>'fail',
			);
			echo $this->_base->_common->json_create($arr);
		}
	}
	
	/**
	 * 添加相册
	 */
	public function zibanma_pic_album_add(){
		if(($post=$this->_base->_request->post())){
			if($this->_pic_model->zibanma_album_add($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_album_add')));
			}else{
				echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_album_add')));
			}
		}else{
			$assign = array(
				'menu_name'=>'添加相册',
				'album_list' => $this->_pic_model->zibanma_get_category_list(),
				'common' => $this->_base->_common,
				'create_user' => $this->_user_info->user,
				'user_is_exists_post_url' => $this->_base->_common->get_rewriter_url_arr(array('admin','user_is_exists')),
			);
			$this->_base->_view->make('admin.pic_album_add', $assign);
		}
	}
	
	/**
	 * 管理相册
	 */
	public function zibanma_pic_album_manage(){
		$param = $this->_base->_request->get_parameter();
		$set = $this->_base->_zibanma;
		$set->category_id = $param[2] ? intval($param[2]) : 0;
		$set->page_current = $param[3] ? intval($param[3]) : 1;
		$set->page_size = 20;
		$set->first_limit = $set->page_current * $set->page_size - $set->page_size;
		$set->end_limit = $set->page_size;
		$set->sort = 'desc';
		$assign = array(
			'menu_name'=>'管理相册',
			'album_list' => $this->_pic_model->zibanma_get_album_list($set),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('admin.pic_album_manage', $assign);
	}
	
	/**
	 * 修改相册
	 */
	public function zibanma_pic_album_modification(){
		if(($post=$this->_base->_request->post())){
			if($this->_pic_model->zibanma_update_album_info($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_album_manage',$post['category'])));
			}else{
				echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_album_manage',$post['category'])));
			}
		}else{
			$param = $this->_base->_request->get_parameter();
			if($param[2]>0){
				$album_info = $this->_pic_model->zibanma_get_album_info_by_id($param[3]);
				$assign = array(
					'menu_name'=>'修改新闻分类',
					'category_list' => $this->_pic_model->zibanma_get_category_list(),
					'album_info' => $album_info[0],
				);
				$this->_base->_view->make('admin.pic_album_modification', $assign);
			}
		}
	}
	
	/**
	 * 删除相册
	 */
	public function zibanma_pic_album_delete(){
		$param = $this->_base->_request->get_parameter();
		if($this->_pic_model->zibanma_delete_album($param[3])){
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_album_manage')));
		}else{
			echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_album_manage')));
		}
	}
	
	/**
	 * 添加图片
	 */
	public function zibanma_pic_graph_add(){
		if(($post=$this->_base->_request->post())){
			if($this->_pic_model->zibanma_user_graph_add($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_graph_add')));
			}else{
				echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_graph_add')));
			}
		}else{
			$assign = array(
				'menu_name'=>'添加图片',
				'user_is_exists_post_url' => $this->_base->_common->get_rewriter_url_arr(array('admin','user_is_exists')),
				'user_album_list_url' => $this->_base->_common->get_rewriter_url_arr(array('admin','user_album_list')),
			);
			$this->_base->_view->make('admin.pic_graph_add', $assign);
		}
	}
	
	/**
	 * 判断用户是否存在
	 */
	public function zibanma_user_is_exists(){
		if(($post=$this->_base->_request->post())){
			if($this->_pic_model->zibanma_select_user_is_exists($post['user'])){
				echo $this->_base->_common->json_create(array('status'=>'success'));
			}else{
				echo $this->_base->_common->json_create(array('status'=>'fail'));
			}
		}else{
			echo $this->_base->_common->json_create(array('status'=>'fail'));
		}
	}
	
	/**
	 * 用户相册列表
	 */
	public function zibanma_user_album_list(){
		if(($post=$this->_base->_request->post())){
			$user_album_list = $this->_pic_model->zibanma_user_album_list($post['user']);
			echo $this->_base->_common->json_create($user_album_list);
		}else{
			echo $this->_base->_common->json_create(array('status'=>'fail'));
		}
	}
	
	/**
	 * 管理图片
	 */
	public function zibanma_pic_graph_manage(){
		$param = $this->_base->_request->get_parameter();
		$set = $this->_base->_zibanma;
		$set->category_id = $param[2] ? intval($param[2]) : 0;
		$set->page_current = $param[3] ? intval($param[3]) : 1;
		$set->page_size = 5;
		$set->first_limit = $set->page_current * $set->page_size - $set->page_size;
		$set->end_limit = $set->page_size;
		$set->sort = 'desc';
		$set->links = array('admin','pic_graph_manage');
		$assign = array(
			'menu_name'=>'管理图片',
			'graph_list' => $this->_pic_model->zibanma_get_graph_list($set),
			'common' => $this->_base->_common,
		);
		$this->_base->_view->make('admin.pic_graph_manage', $assign);
	}
	
	/**
	 * 图片修改
	 */
	public function zibanma_pic_graph_modification(){
		if(($post=$this->_base->_request->post())){
			if($this->_pic_model->zibanma_update_garph_info($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_graph_manage')));
			}else{
				echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_graph_manage')));
			}
		}else{
			$param = $this->_base->_request->get_parameter();
			$graph_info = $this->_pic_model->zibanma_get_graph_info_by_id(intval($param[4]));
			$assign = array(
				'menu_name'=>'修改图片',
				'user_album_list' => $this->_pic_model->zibanma_user_album_list($param[2]),
				'graph_info' => $graph_info[0],
			);
			$this->_base->_view->make('admin.pic_graph_modification', $assign);
		}
	}
	
	/**
	 * 删除图片
	 */
	public function zibanma_pic_graph_delete(){
		$param = $this->_base->_request->get_parameter();
		if($this->_pic_model->zibanma_delete_graph($param[2])){
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_graph_manage')));
		}else{
			echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','pic_graph_manage')));
		}
	}
	
	/**
	 * 链接管理
	 */
	public function zibanma_link_manage(){
		$assign = array(
				'menu_name'=>'链接管理',
				'link_list' => $this->_link_model->zibanma_get_list_all(),
				'common' => $this->_base->_common,
		);
		$this->_base->_view->make('admin.link_manage', $assign);
	}
	
	/**
	 * 添加链接
	 */
	public function zibanma_link_add(){
		if(($post=$this->_base->_request->post())){
			if($this->_link_model->zibanma_add($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','link_manage')));
			}else{
				echo $this->_base->_common->show_message_url('操作失败，请重新添加', $this->_base->_common->get_rewriter_url_arr(array('admin','link_add')));
			}
		}else{
			$assign = array(
				'menu_name'=>'添加链接',
				'common' => $this->_base->_common,
			);
			$this->_base->_view->make('admin.link_add', $assign);
		}
	}
	
	/**
	 * 编辑链接
	 */
	public function zibanma_link_modification(){
		if(($post=$this->_base->_request->post())){
			if($this->_link_model->zibanma_modification($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','link_manage')));
			}else{
				echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','link_manage')));
			}
		}else{
			$param = $this->_base->_request->get_parameter();
			$link_info = $this->_link_model->zibanma_get_info_by_id($param[2]);
			$assign = array(
				'menu_name'=>'修改链接',
				'link_info' => $link_info[0],
				'common' => $this->_base->_common,
			);
			$this->_base->_view->make('admin.link_modification', $assign);
		}
	}
	
	/**
	 * 删除链接
	 */
	public function zibanma_link_delete(){
		$param = $this->_base->_request->get_parameter();
		if($this->_link_model->zibanma_delete($param[2])){
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','link_manage')));
		}else{
			echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','link_manage')));
		}
	}
	
	/**
	 * 焦点图管理
	 */
	public function zibanma_focus_manage(){
		$assign = array(
			'common' => $this->_base->_common,
			'addurl' => $this->_base->_common->get_rewriter_url_arr(array('admin','focus_add')),
			'focus_list' => $this->_focus_model->zibanma_focus_list(),
			'http_host' => 'http://'.$_SERVER['HTTP_HOST'].'/',
		);
		$this->_base->_view->make('admin.focus_manage', $assign);
	}
	
	public function zibanma_focus_add(){
		if(($post=$this->_base->_request->post())){
			if($this->_focus_model->zibanma_focus_add($post)){
				echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','focus_manage')));
			}else{
				echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','focus_manage')));
			}
		}
	}
	
	/**
	 * 导航更新排序
	 */
	public function zibanma_focus_sort(){
		$post=$this->_base->_request->post();
		if(is_numeric($post['id']) && is_numeric($post['value'])){
			$this->_focus_model->zibanma_update_sort($post);
			$arr = array(
				'status'=>'success',
			);
			echo $this->_base->_common->json_create($arr);
		}else{
			$arr = array(
				'status'=>'fail',
			);
			echo $this->_base->_common->json_create($arr);
		}
	}
	
	/**
	 * 导航删除
	 */
	public function zibanma_focus_delete(){
		$param = $this->_base->_request->get_parameter();
		if($this->_focus_model->zibanma_delete($param[2])){
			echo $this->_base->_common->show_message_url('操作成功', $this->_base->_common->get_rewriter_url_arr(array('admin','focus_manage')));
		}else{
			echo $this->_base->_common->show_message_url('操作失败', $this->_base->_common->get_rewriter_url_arr(array('admin','focus_manage')));
		}
	}
}
?>