﻿/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
(function(window){
	var focus_num = 0;
	var param;
	var setInterval;
	function getDomEle(){
		return getDom().documentElement;
	}
	function creatEle($node){
		return getDom().createElement($node);
	}
	function getEleId(id){
		return getDom().getElementById(id);	
	}
	function getEleTag(tag){
		return getDom().getElementsByTagName(tag);
	}
	function getDomIdTag(id,tag){
		return getEleId(id).getElementsByTagName(tag);
	}
	function getDom(){
		return document;
	}
	window.zibanma = {
		init : function(init){
			if(init){
				param = init;
				if(param.method == 'focus'){
					window.zibanma.focus.timing();
				}
				if(param.method == 'dialog.dom'){
					window.zibanma.dialog.dom();
					setInterval = window.setInterval(function(){
						window.zibanma.dialog.scroll();
					},50);
				}
				if(param.method == 'dialog.show'){
					window.zibanma.dialog.show();
				}
			}
		},
		focus : {
			run : function(){
				var li = getDomIdTag(param.data.id,'li');
				var length = li.length;
				if(focus_num == 0){
					focus_num = 2;	
				}
				for(var i=0; i<length; i++){
					li[i].style.display = 'none';
				}
				li[focus_num-1].style.display = 'inline';
				focus_num==length ? focus_num = 1 : focus_num++;	
			},
			mouseover : function(){
				window.clearInterval(setInterval);	
			},
			mouseout : function(){
				window.zibanma.focus.timing();
			},
			timing : function(){
				setInterval = window.setInterval(function(){
					window.zibanma.focus.run();	
				}, param.data.time);
			}
		},
		dialog : {
			remove : function(node){
				window.clearInterval(setInterval);
				document.body.removeChild(getEleId(node));
			},
			dom : function(){
				var div = creatEle('div');
				div.id = 'zibanma_dialog';
				div.innerHTML = '<div id="zibanma_dialog_div" style="position:absolute; width:'+param.data.width+'px; height:'+param.data.height+'px; box-shadow:#666 0px 0px 10px; background: #eeff99; z-index:9999;"><div style="width:100%; height:30px; line-height:30px; background-color:#207bc1; float:left;"><div style="width:80%; color:#fff; text-indent:5px; float:left;">'+param.data.title+'</div><div style="height:30px; padding-right:10px; float:right;"><a href="javascript:void(0);" onclick="window.zibanma.dialog.remove(\'zibanma_dialog\');" style="color:#fff; text-decoration:none;">[关闭]</a></div></div><div style="width:100%; height:'+(param.data.height-30)+'px; background-color:#fff; float:left;">'+param.data.content+'</div></div>';
				document.body.appendChild(div);
			},
			scroll : function(){
				var dialog = getEleId('zibanma_dialog_div');
				var domEle = getDomEle();
				dialog.style.top = (domEle.scrollTop+document.body.scrollTop+(domEle.clientHeight-dialog.offsetHeight)/2)+'px';
				dialog.style.left = (domEle.scrollLeft+(domEle.clientWidth-dialog.offsetWidth)/2)+'px';
			},
			show : function(){}
		},
		graph : {
			single : function(obj){
				window.zibanma.init({
					method:'dialog.dom',
					data:{
						width:850,
						height:500,
						title:obj.title,
						content:'<img src="'+obj.name+'" style="width:850px; height:470px; border:0px;" />'
					}
				});
			},
			multi : function(){}
		}
	};
})(window);