<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
class NewsModel{
	public $_model;
	public function __construct(){
		$this->_model = ZibanmaModel::get_instance();
	}
	
	/**
	 * 添加分类
	 * @param array $post
	 */
	public function zibanma_category_add($post){
		if($post){
			return $this->_model->_db->execute("insert into ".ZIBANMA_DB_PREFIX."news_category (category_name, category_keywords, category_description) values ('{$post[category_name]}', '{$post[category_keywords]}',  '{$post[category_description]}'); ");
		}
		return null;
	}
	
	/**
	 * 获取分类列表
	 * @param $sort desc/asc
	 */
	public function zibanma_get_category_list($sort='asc'){
		return $this->_model->_db->query("select * from ".ZIBANMA_DB_PREFIX."news_category where status=1 order by sort {$sort}; ");
	}
	
	/**
	 * 获取分类信息
	 */
	public function zibanma_get_category_info_by_id($id){
		if($id>0){
			return $this->_model->_db->query("select * from ".ZIBANMA_DB_PREFIX."news_category where status=1 and id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 更新分类信息
	 */
	public function zibanma_update_category_info($post){
		if($post){
			$post['id'] = intval($post['id']);
			return $this->_model->_db->execute("update ".ZIBANMA_DB_PREFIX."news_category set category_name='{$post[category_name]}',category_keywords='{$post[category_keywords]}',category_description='{$post[category_description]}' where id={$post[id]} ; ");
		}
		return null;
	}
	
	/**
	 * 删除分类
	 */
	public function zibanma_delete_category($id){
		if($id>0){
			return $this->_model->_db->execute("update ".ZIBANMA_DB_PREFIX."news_category set status=0 where id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 更新排序
	 * @param $arr id/value
	 */
	public function zibanma_update_category_sort($arr){
		if($arr){
			return $this->_model->_db->execute("update ".ZIBANMA_DB_PREFIX."news_category set sort={$arr[value]} where id={$arr[id]}; ");
		}
	}
	
	/**
	 * 添加文章
	 */
	public function zibanma_article_add($post){
		if($post){
			$post['title'] = $post['title'] != '' ? trim($post['title']) : '本文没有标题';
			$post['keywords'] = $post['keywords'] != '' ? $post['keywords'] : $post['title'];
			$post['description'] = $post['description'] != '' ? $post['description'] : $post['title'];
			$post['content'] = $post['content'] != '' ? $post['content'] : '本文没有内容';
			$post['category'] = $post['category'] != '' ? intval($post['category']) : 0;
			$post['click'] = $post['click'] != '' ? intval($post['click']) : 0;
			$post['create_user'] = $post['create_user'] != '' ? trim($post['create_user']) : 'guest';
			$post['create_time'] = $post['create_time'] != '' ? strtotime(trim($post['create_time'])) : time();
			$sql = "insert into ".ZIBANMA_DB_PREFIX."news_article (title, keywords, description, content, category, click, create_user, create_time) values 
			('{$post[title]}', '{$post[keywords]}', '{$post[description]}', '{$post[content]}', '{$post[category]}', '{$post[click]}', '{$post[create_user]}', '{$post[create_time]}'); ";
			return $this->_model->_db->execute($sql);
		}
		return null;
	}
	
	/**
	 * 记录统计
	 */
	public function zibanma_get_article_count($set){
		if($set->category_id != 0){
			$search = " and category={$set->category_id}";
		}
		$rs = $this->_model->_db->query("select count(id) as count from ".ZIBANMA_DB_PREFIX."news_article where status=1 {$search}; ");
		return $rs[0]->count;
	}
	
	/**
	 * 文章列表
	 * Obejct $set
	 * $set->category_id
	 * $set->page_current
	 * $set->page_size
	 * $set->first_limit
	 * $set->end_limit
	 * $set->sort
	 * $set->links array
	 * @return object
	 */
	public function zibanma_get_article_list($set){
		if($set->category_id != 0){
			$search = " and cat.id={$set->category_id}";
		}
		$sql = "select cat.id category_id,cat.*,art.id article_id,art.* from ".ZIBANMA_DB_PREFIX."news_category cat left join ".ZIBANMA_DB_PREFIX."news_article art
		on cat.id=art.category where cat.status=1 and art.status=1 {$search} order by art.id {$set->sort} limit {$set->first_limit},{$set->end_limit}; ";
		$set->rs = $this->_model->_db->query($sql);
		$set->count = $this->zibanma_get_article_count($set);
		$set->links = $this->_model->_page->links($set, $set->links, $this->_model->_common);
		return $set;
	}
	
	/**
	 * 获取文章信息
	 */
	public function zibanma_get_article_info($id){
		if($id){
			return $this->_model->_db->query("select * from ".ZIBANMA_DB_PREFIX."news_article where status=1 and id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 更新文章
	 */
	public function zibanma_update_article_info($post){
		if($post){
			$post['id'] = $post['id'] ? intval($post['id']) : 0;
			$post['title'] = $post['title'] != '' ? trim($post['title']) : '本文没有标题';
			$post['keywords'] = $post['keywords'] != '' ? $post['keywords'] : $post['title'];
			$post['description'] = $post['description'] != '' ? $post['description'] : $post['title'];
			$post['author'] = $post['author'] != '' ? $post['author'] : 'guest';
			$post['content'] = $post['content'] != '' ? $post['content'] : '本文没有内容';
			$post['category'] = $post['category'] != '' ? intval($post['category']) : 0;
			$post['click'] = $post['click'] != '' ? intval($post['click']) : 0;
			$post['create_user'] = $post['create_user'] != '' ? trim($post['create_user']) : $post['author'];
			$post['create_time'] = $post['create_time'] != '' ? strtotime(trim($post['create_time'])) : time();
			$sql = "update ".ZIBANMA_DB_PREFIX."news_article set title='{$post[title]}',keywords='{$post[keywords]}',description='{$post[description]}',
			author='{$post[author]}',content='{$post[content]}',category={$post[category]},click={$post[click]},create_user='{$post[create_user]}',
			create_time={$post[create_time]} where id={$post[id]} ; ";
			return $this->_model->_db->execute($sql);
		}
		return null;
	}
	
	/**
	 * 删除文章
	 */
	public function zibanma_article_delete($id){
		if($id>0){
			return $this->_model->_db->execute("update ".ZIBANMA_DB_PREFIX."news_article set status=0 where id={$id}; ");
		}
		return null;
	}
	
	/**
	 * 获取频道列表
	 */
	public function zibanma_channel_list(){
		$category = $this->zibanma_get_category_list();
		if($category && count($category)){
			foreach ($category as $v){
				$v->article = $this->_model->_db->query("select id,title,create_user,create_time from [prefix]news_article where category={$v->id} and status=1 order by id desc limit 8;");
			}
		}
		return $category;
	}
	
	/**
	 * 热门文章列表
	 */
	public function zibanma_get_host_list($limit=10){
		return $this->_model->_db->query("select id,title from [prefix]news_article where status=1 order by click desc limit {$limit};");
	}
	
	/**
	 * 随机文章列表
	 */
	public function zibanma_get_random_list($limit=10){
		return $this->_model->_db->query("select id,title from [prefix]news_article where status=1 order by rand() limit {$limit};");
	}
	
	/**
	 * 最新文章
	 */
	public function zibanma_get_new_list($limit=10){
		return $this->_model->_db->query("select art.id,art.title,cat.id as category_id,cat.category_name from [prefix]news_article art left join [prefix]news_category cat on art.category=cat.id where art.status=1 order by art.id desc limit {$limit};");
	}
	
	/**
	 * 更新点击
	 */
	public function zibanma_update_cilck($id){
		$interval = explode(',', ZIBANMA_CLICK_NUM);
		if($interval[0]>=0 && $interval[1]>0){
			$click = rand(intval($interval[0]), intval($interval[1]));
			$this->_model->_db->query("update [prefix]news_article set click=click+{$click} where id={$id};");
		}else{
			echo '点击随机增量设置异常！';
		}
	}
	
	/**
	 * 获取首页推荐栏目
	 */
	public function zibanma_index_category_list(){
		if(ZIBANMA_INDEX_CATEGORY_LIST == '0'){
			$category_list = $this->_model->_db->query("select id,category_name from [prefix]news_category where status=1 order by id desc limit 6;");
		}else{
			$category_list = $this->_model->_db->query("select id,category_name from [prefix]news_category where status=1 and id in(".ZIBANMA_INDEX_CATEGORY_LIST."); ");
		}
		foreach ($category_list as $v){
			$v->data = $this->_model->_db->query("select id,title,create_time from [prefix]news_article where status=1 and category={$v->id} order by id desc limit ".(ZIBANMA_INDEX_CATEGORY_LIMIT?ZIBANMA_INDEX_CATEGORY_LIMIT:8).";");
		}
		return $category_list;
	}
}
?>