<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
session_start();
error_reporting(0);
header("content-Type: text/html; charset=utf-8");
date_default_timezone_set('PRC');
define('ZIBANMA_SYS_LINK', 'zibanma_com');
class Zibanma{
	private $parameter;
	private $class_name;
	private $method_name;
	
	public function __construct(){
		$this->parameter = $this->get_parameter();
		$this->class_name = $this->get_class_name();
		$this->method_name = $this->get_method_name();
	}
	
	public function start(){
		$this->get_initialization();
	}
	
	public function get_parameter(){
		$request = new ZibanmaRequest();
		return $request->get_parameter();
	}
	
	public function get_class_name(){
		return isset($this->parameter[0]) ? trim($this->parameter[0]).'Control' : 'IndexControl';
	}
	
	public function get_method_name(){
		return isset($this->parameter[1]) ? 'zibanma_'.trim($this->parameter[1]) : 'zibanma_index';
	}
	
	public function get_initialization(){
		$initialization = new $this->class_name();
		if(method_exists($initialization, ($method_name=$this->method_name))){
			$initialization->$method_name();
		}else{
			echo '访问方法异常';
		}
	}
	
	public static function get_instance(){
		if(!is_object(($instance = new stdClass()))){
			echo '初始化实例失败';
		}
		return $instance;
	}
}
$zibanma = new Zibanma();
$zibanma->start();
function __autoload($className){
	$className = ucfirst($className);
	foreach (array('controller', 'model', 'zibanma') as $path){
		if(file_exists(ZIBANMA_SYS_APP_ROOT.'/'.$path.'/'.$className.'.php')){
			include_once ZIBANMA_SYS_APP_ROOT.'/'.$path.'/'.$className.'.php';
		}
	}
}
?>